/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgNWorkViewDimensionCollection;
import com.kingdee.eas.ma.bgcsl.BgNWorkViewDimensionInfo;
import com.kingdee.eas.ma.bgcsl.IBgNWorkTemplate;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgNWorkViewDimensionControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgFacadeHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class BgNWorkViewDimensionControllerBean
extends AbstractBgNWorkViewDimensionControllerBean {
    private static final long serialVersionUID = 5821625580376712962L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgNWorkViewDimensionControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected IObjectPK _addNewView(Context ctx, IObjectValue bgDimensionInfo, IObjectValue bgTemplate) throws BOSException, EASBizException {
        IBgNWorkTemplate itemplate = BgNWorkTemplateFactory.getLocalInstance(ctx);
        BgNWorkTemplateInfo templateInfo = (BgNWorkTemplateInfo)bgTemplate;
        IObjectPK templateid = itemplate.save((CoreBaseInfo)templateInfo);
        templateInfo.setId(BOSUuid.read((String)templateid.toString()));
        BgNWorkViewDimensionInfo info = (BgNWorkViewDimensionInfo)bgDimensionInfo;
        BgNWorkViewDimensionCollection old = this.getBgNWorkViewDimensionCollection(ctx, "select id, template where template.id = '" + templateid + "'");
        if (old == null || old.isEmpty()) {
            info.setTemplate(templateInfo);
            info.setId(BOSUuid.create((BOSObjectType)this.getBOSType()));
            this._addnew(ctx, (IObjectValue)info);
        } else {
            old.get(0).setData(info.getData());
            this._update(ctx, (IObjectPK)new ObjectUuidPK(old.get(0).getId()), (IObjectValue)old.get(0));
        }
        try {
            MbgViewListManager view = null;
            view = new MbgViewListXMLParser(ctx).parse(info.getData());
            if (view != null) {
                BgFacadeHelper.saveBgTemplateRef((Context)ctx, (String)templateid.toString(), (IMbgViewBase)view);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return templateid;
    }

    @Override
    protected IObjectValue _getDimensionByTemplate(Context ctx, String bgTemplateId) throws BOSException, EASBizException {
        BgNWorkViewDimensionInfo bgNWorkViewDimensionInfo;
        if (StringUtils.isEmpty((String)bgTemplateId)) {
            return null;
        }
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select dimen.fid, dimen.FData from T_MBG_BgNWorkViewDimension dimen  where dimen.FTemplateID =? ;");
        connection = this.getConnection(ctx);
        try {
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, bgTemplateId);
            rs = sm.executeQuery();
            BgNWorkViewDimensionInfo info = null;
            while (rs.next()) {
                if (info != null) continue;
                info = new BgNWorkViewDimensionInfo();
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setData(rs.getBytes("FData"));
            }
            bgNWorkViewDimensionInfo = info;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return bgNWorkViewDimensionInfo;
    }

    @Override
    protected void _deleteDimension(Context ctx, String id) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        Connection conn = this.getConnection(ctx);
        PreparedStatement ps = null;
        String sql = "delete from T_MBG_BgNWorkViewDimension  where FTemplateID = ? ;";
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, id);
            ps.execute();
            BgFacadeHelper.deleteRef((Context)ctx, (String)id);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
        }
    }

    @Override
    @Deprecated
    protected void _saveFixedTemplateDimension(Context ctx, String bgTemplateId, Collection formulas) throws BOSException, EASBizException {
    }

    private boolean checkDimensionManager(IBgDimensionManager manager) {
        List entries = manager.getDimension();
        for (BgDimensionInfo entry : entries) {
            if (!DimensionConstants.DEF_INDEX_NUMBER.equals(entry.getType()) && !DimensionConstants.DEF_ACCOUNT_NUMBER.equals(entry.getType())) continue;
            return true;
        }
        return false;
    }
}

