/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateType;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateHistCollection;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateHistFactory;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateHistInfo;
import com.kingdee.eas.ma.bgcsl.IBizRefCslTemplateHist;
import com.kingdee.eas.ma.bgcsl.app.AbstractBizRefCslTemplateHistControllerBean;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizRefCslTemplateHistControllerBean
extends AbstractBizRefCslTemplateHistControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BizRefCslTemplateHistControllerBean");

    @Override
    protected Map _getRefTemplates(Context ctx, Set bizCalcIds) throws BOSException, EASBizException {
        HashMap<String, Map> result = new HashMap<String, Map>();
        if (ctx == null || bizCalcIds == null || bizCalcIds.isEmpty()) {
            return result;
        }
        String bizCalcId2 = null;
        Map temMap = null;
        for (String bizCalcId2 : bizCalcIds) {
            temMap = this._getRefTemplateCollection(ctx, bizCalcId2);
            if (temMap.isEmpty()) continue;
            result.put(bizCalcId2, temMap);
        }
        return result;
    }

    @Override
    protected Map _getRefTemplateCollection(Context ctx, String bizCalcID) throws BOSException, EASBizException {
        FilterInfo filter;
        HashMap<String, AbstractObjectCollection> resultmap = new HashMap<String, AbstractObjectCollection>();
        if (ctx == null || StringUtils.isEmpty((String)bizCalcID)) {
            return resultmap;
        }
        IBizRefCslTemplateHist iBizRefCslTemplate = BizRefCslTemplateHistFactory.getLocalInstance(ctx);
        BizRefCslTemplateHistCollection colls = iBizRefCslTemplate.getBizRefCslTemplateHistCollection("where bizCalcID = '" + bizCalcID + "'");
        if (colls == null || colls.isEmpty()) {
            return resultmap;
        }
        BizRefCslTemplateHistInfo info = null;
        HashSet<String> workTemplateIds = new HashSet<String>();
        HashSet<String> cslTemplateIds = new HashSet<String>();
        HashSet<String> cslAdjTemplateIds = new HashSet<String>();
        for (int index = 0; index < colls.size(); ++index) {
            info = colls.get(index);
            if (BgCslTemplateType.WORKTEMPLATE.equals((Object)info.getType())) {
                workTemplateIds.add(info.getTemplateID().toString());
                continue;
            }
            if (BgCslTemplateType.CSLTEMPLATE.equals((Object)info.getType())) {
                cslTemplateIds.add(info.getTemplateID().toString());
                continue;
            }
            if (!BgCslTemplateType.CSLADJTEMPLATE.equals((Object)info.getType())) continue;
            cslAdjTemplateIds.add(info.getTemplateID().toString());
        }
        if (!workTemplateIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(this.getSelector());
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", workTemplateIds, CompareType.INCLUDE));
            view.setFilter(filter);
            BgNWorkTemplateCollection workTemplateColls = BgNWorkTemplateFactory.getLocalInstance(ctx).getBgNWorkTemplateCollection(view);
            resultmap.put("WORKTEMPLATE_COLLECTION", workTemplateColls);
        }
        if (!cslTemplateIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(this.getSelector());
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", cslTemplateIds, CompareType.INCLUDE));
            view.setFilter(filter);
            BgCslTemplateCollection cslTemplateColls = BgCslTemplateFactory.getLocalInstance(ctx).getBgCslTemplateCollection(view);
            resultmap.put("bgtemplate", cslTemplateColls);
        }
        if (!cslAdjTemplateIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(this.getSelector());
            view.getSelector().add("orgUnit.id");
            view.getSelector().add("orgUnit.number");
            view.getSelector().add("orgUnit.name");
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", cslAdjTemplateIds, CompareType.INCLUDE));
            view.setFilter(filter);
            BgCslAdjTemplateCollection cslAdjTemplateColls = BgCslAdjTemplateFactory.getLocalInstance(ctx).getBgCslAdjTemplateCollection(view);
            resultmap.put("bgcsladjtemplate", cslAdjTemplateColls);
        }
        return resultmap;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        return selector;
    }
}

