/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.BindingPropertyInfo;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperException;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.bgcsl.app.AbstractMbgWorkPaperControllerBean;
import com.kingdee.eas.ma.bgcsl.utils.MbgCslDataHelper;
import com.kingdee.eas.ma.mbg.BgAuditIdeaEnum;
import com.kingdee.eas.ma.mbg.BgAuditIdeaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.utils.BgFacadeHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgWorkPaperControllerBean
extends AbstractMbgWorkPaperControllerBean {
    private static final long serialVersionUID = -4002443997372807928L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.MbgWorkPaperControllerBean");

    @Override
    protected Map _audit(Context ctx, List billIds, IObjectValue idea) throws BOSException, EASBizException {
        return this._batchAudit(ctx, billIds, idea, false);
    }

    @Override
    protected Map _batchAudit(Context ctx, List billIds, IObjectValue idea, boolean isReqMutex) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        if (ctx == null || billIds == null || billIds.isEmpty()) {
            return result;
        }
        String billId = null;
        String cubeName = null;
        String cubeEntry = null;
        String unionId = null;
        Set workFlow = null;
        Set mutex = null;
        HashMap<String, String[]> workFlowMap = new HashMap<String, String[]>();
        HashMap<String, String[]> mutexMap = new HashMap<String, String[]>();
        HashMap<String, String[]> stateMap = new HashMap<String, String[]>();
        BgSchemeInfo schemeInfo = null;
        BgAuditIdeaInfo ideaInfo = null;
        BgAuditIdeaInfo _tmpIdea = null;
        CoreBaseCollection ideas = new CoreBaseCollection();
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            if (idea instanceof BgAuditIdeaInfo) {
                ideaInfo = (BgAuditIdeaInfo)idea;
            } else {
                ideaInfo = new BgAuditIdeaInfo();
                ideaInfo.setState(BgAuditIdeaEnum.AUDITPASS);
            }
            ideaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            ideaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            mutex = isReqMutex ? MBgCheckHelper.requestMutex((Context)ctx, (List)billIds, (boolean)true) : new HashSet();
            workFlow = MBgCheckHelper.checkInProInst((Context)ctx, (Collection)billIds);
            List<MbgWorkPaperInfo> workPapers = MbgCslDataHelper.getMBgWorkPaperInfo(ctx, conn, billIds);
            for (MbgWorkPaperInfo workPaper : workPapers) {
                billId = workPaper.getId().toString();
                if (mutex.contains(billId) || workFlow.contains(billId)) {
                    if (mutex.contains(billId)) {
                        mutexMap.put(billId, new String[]{workPaper.getNumber(), workPaper.getName()});
                    }
                    if (!workFlow.contains(billId)) continue;
                    workFlowMap.put(billId, new String[]{workPaper.getNumber(), workPaper.getName()});
                    continue;
                }
                if (1 == workPaper.getState().getValue()) {
                    unionId = workPaper.getOrgTree().getId().toString();
                    if (schemeInfo == null) {
                        schemeInfo = MbgDataHelper.getBgSchemeInfo((Connection)conn, (Locale)ctx.getLocale(), (BOSUuid)workPaper.getBgScheme().getId());
                        cubeName = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
                        cubeEntry = BgCubeUtils.getCFSEntryCubeName((String)schemeInfo.getRefCube());
                    }
                    BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_MbgWorkPaper set FState = ?, FAuditorID = ?, FAuditedTime = ? where FID = ?", (Object[])new Object[]{2, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), new Timestamp(System.currentTimeMillis()), billId});
                    _tmpIdea = ideaInfo.getClone();
                    _tmpIdea.setFormId(BOSUuid.read((String)billId));
                    ideas.add((CoreBaseInfo)_tmpIdea);
                    continue;
                }
                stateMap.put(billId, new String[]{workPaper.getNumber(), workPaper.getName()});
            }
            if (!ideas.isEmpty()) {
                BgAuditIdeaFactory.getLocalInstance((Context)ctx).addnewBatchData(ideas);
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"workPaper audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            billIds.removeAll(mutexMap.keySet());
            MBgCheckHelper.releaseMutex((Context)ctx, (List)billIds);
        }
        result.put("CHECK_NETMUTEX", mutexMap);
        result.put("CHECK_WORKFLOW", workFlowMap);
        result.put("CHECK_STATE", stateMap);
        return result;
    }

    @Override
    protected Map _unAudit(Context ctx, List billIds, IObjectValue idea) throws BOSException, EASBizException {
        return this._batchUnAudit(ctx, billIds, idea, false);
    }

    @Override
    protected Map _batchUnAudit(Context ctx, List billIds, IObjectValue idea, boolean isReqMutex) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        if (ctx == null || billIds == null || billIds.isEmpty()) {
            return result;
        }
        String billId = null;
        String cubeName = null;
        String cubeEntry = null;
        String unionId = null;
        BgSchemeInfo schemeInfo = null;
        BgAuditIdeaInfo ideaInfo = null;
        BgAuditIdeaInfo _tmpIdea = null;
        CoreBaseCollection ideas = new CoreBaseCollection();
        HashSet<String> orgUnitIds = new HashSet<String>();
        HashSet bgPeriodNums = new HashSet();
        HashSet versionNums = new HashSet();
        Set workFlow = null;
        Set mutex = null;
        HashMap<String, String[]> workFlowMap = new HashMap<String, String[]>();
        HashMap<String, String[]> mutexMap = new HashMap<String, String[]>();
        HashMap<String, String[]> stateMap = new HashMap<String, String[]>();
        Object mbgDimMap = null;
        Object mbgDim = null;
        HashSet<String> mbgDimNums = new HashSet<String>();
        mbgDimNums.add(DimensionBaseConstants.DEF_PERIOD_NUMBER);
        mbgDimNums.add(DimensionBaseConstants.DEF_VERSION_NUMBER);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            if (idea instanceof BgAuditIdeaInfo) {
                ideaInfo = (BgAuditIdeaInfo)idea;
            } else {
                ideaInfo = new BgAuditIdeaInfo();
                ideaInfo.setState(BgAuditIdeaEnum.UNAUDIT);
            }
            ideaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            ideaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            mutex = isReqMutex ? MBgCheckHelper.requestMutex((Context)ctx, (List)billIds, (boolean)true) : new HashSet();
            workFlow = MBgCheckHelper.checkInProInst((Context)ctx, (Collection)billIds);
            List<MbgWorkPaperInfo> workPapers = MbgCslDataHelper.getMBgWorkPaperInfo(ctx, conn, billIds);
            for (MbgWorkPaperInfo workPaper : workPapers) {
                billId = workPaper.getId().toString();
                if (mutex.contains(billId) || workFlow.contains(billId)) {
                    if (mutex.contains(billId)) {
                        mutexMap.put(billId, new String[]{workPaper.getNumber(), workPaper.getName()});
                    }
                    if (!workFlow.contains(billId)) continue;
                    workFlowMap.put(billId, new String[]{workPaper.getNumber(), workPaper.getName()});
                    continue;
                }
                if (2 == workPaper.getState().getValue()) {
                    unionId = workPaper.getOrgTree().getId().toString();
                    orgUnitIds.add(workPaper.getOrgUnit().getId().toString());
                    if (schemeInfo == null) {
                        schemeInfo = MbgDataHelper.getBgSchemeInfo((Connection)conn, (Locale)ctx.getLocale(), (BOSUuid)workPaper.getBgScheme().getId());
                        cubeName = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
                        cubeEntry = BgCubeUtils.getCFSEntryCubeName((String)schemeInfo.getRefCube());
                    }
                    BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_MbgWorkPaper set FState = ?, FAuditorID = null, FAuditedTime = ? where FID = ?", (Object[])new Object[]{1, new Timestamp(System.currentTimeMillis()), billId});
                    _tmpIdea = ideaInfo.getClone();
                    _tmpIdea.setFormId(BOSUuid.read((String)billId));
                    ideas.add((CoreBaseInfo)_tmpIdea);
                    continue;
                }
                stateMap.put(billId, new String[]{workPaper.getNumber(), workPaper.getName()});
            }
            if (!ideas.isEmpty()) {
                BgAuditIdeaFactory.getLocalInstance((Context)ctx).addnewBatchData(ideas);
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"workPaper audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            billIds.removeAll(mutexMap.keySet());
            MBgCheckHelper.releaseMutex((Context)ctx, (List)billIds);
        }
        result.put("CHECK_NETMUTEX", mutexMap);
        result.put("CHECK_WORKFLOW", workFlowMap);
        result.put("CHECK_STATE", stateMap);
        return result;
    }

    @Override
    protected Map _checkCanAudit(Context ctx, List billIds) throws BOSException, EASBizException {
        return this.checkCanAudit2UnAudit(ctx, billIds, 1);
    }

    @Override
    protected Map _checkCanUnAudit(Context ctx, List billIds) throws BOSException, EASBizException {
        return this.checkCanAudit2UnAudit(ctx, billIds, 2);
    }

    private Map<String, Map<String, String[]>> checkCanAudit2UnAudit(Context ctx, List<String> billIds, int checkState) throws BOSException, EASBizException {
        HashMap<String, Map<String, String[]>> result = new HashMap<String, Map<String, String[]>>();
        if (ctx == null || billIds == null || billIds.isEmpty()) {
            return result;
        }
        String billId = null;
        Set workFlow = null;
        Set mutex = null;
        HashMap<String, String[]> workFlowMap = new HashMap<String, String[]>();
        HashMap<String, String[]> mutexMap = new HashMap<String, String[]>();
        HashMap<String, String[]> stateMap = new HashMap<String, String[]>();
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            mutex = MBgCheckHelper.requestMutex((Context)ctx, billIds, (boolean)true);
            workFlow = MBgCheckHelper.checkInProInst((Context)ctx, billIds);
            List<MbgWorkPaperInfo> workPapers = MbgCslDataHelper.getMBgWorkPaperInfo(ctx, conn, billIds);
            for (MbgWorkPaperInfo workPaper : workPapers) {
                billId = workPaper.getId().toString();
                if (mutex.contains(billId) || workFlow.contains(billId)) {
                    if (mutex.contains(billId)) {
                        mutexMap.put(billId, new String[]{workPaper.getNumber(), workPaper.getName()});
                    }
                    if (workFlow.contains(billId)) {
                        workFlowMap.put(billId, new String[]{workPaper.getNumber(), workPaper.getName()});
                    }
                }
                if (checkState == workPaper.getState().getValue()) continue;
                stateMap.put(billId, new String[]{workPaper.getNumber(), workPaper.getName()});
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"workPaper check unAudit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            billIds.removeAll(mutexMap.keySet());
            MBgCheckHelper.releaseMutex((Context)ctx, billIds);
        }
        result.put("CHECK_NETMUTEX", mutexMap);
        result.put("CHECK_WORKFLOW", workFlowMap);
        result.put("CHECK_STATE", stateMap);
        return result;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        Connection conn = null;
        Object imsc = null;
        try {
            conn = this.getConnection(ctx);
            List<MbgWorkPaperInfo> workPapers = MbgCslDataHelper.getMBgWorkPaperInfo(ctx, conn, ids);
            if (workPapers != null) {
                for (MbgWorkPaperInfo workPaper : workPapers) {
                    if (1 == workPaper.getState().getValue()) continue;
                    throw new MbgWorkPaperException(MbgWorkPaperException.CANNTREMOVE, new Object[]{workPaper.getNumber()});
                }
            }
            this.deleteOtherData(ctx, conn, ids, workPapers);
        }
        catch (SQLException e) {
            logger.error((Object)"sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            if (imsc != null) {
                imsc.releaseObjIDForUpdate(pk.toString());
            }
        }
        super._delete(ctx, pk);
    }

    protected void recycleNumberByOrg(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        boolean useIntermitNumber;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        MbgWorkPaperInfo reportBase = this.getMbgWorkPaperInfo(ctx, pk, sic);
        if (StringUtils.isEmpty((String)reportBase.getNumber())) {
            return;
        }
        FullOrgUnitInfo company = reportBase.getCompany();
        if (company == null || null == company.getId() || company.getId().toString().equals("")) {
            company = reportBase.getOrgUnit();
        } else {
            CompanyOrgUnitInfo org = MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType((OrgUnitInfo)company, ctx);
            company = org.castToFullOrgUnitInfo();
        }
        if (null == company || null == company.getId()) {
            return;
        }
        String companyId = company.getId().toString();
        CodingRuleInfo codingRule = null;
        String orgUnitId = null;
        BindingPropertyInfo bindingProperty = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)reportBase, companyId, "sourceType");
        if (!isCodingRule) {
            isCodingRule = iCodingRuleManager.isExist((IObjectValue)reportBase, companyId);
        }
        if (isCodingRule && (codingRule = iCodingRuleManager.getCodingRule((IObjectValue)reportBase, companyId, "sourceType")) == null) {
            codingRule = iCodingRuleManager.getCodingRule((IObjectValue)reportBase, companyId);
        }
        if (codingRule != null) {
            orgUnitId = codingRule.getAppOrgUnit().getId().toString();
            bindingProperty = codingRule.getBindingProperty();
        }
        if (StringUtils.isEmpty(orgUnitId)) {
            orgUnitId = companyId;
        }
        if (!(useIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)reportBase, companyId, "sourceType"))) {
            useIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)reportBase, companyId);
        }
        if (isCodingRule && useIntermitNumber) {
            if (bindingProperty != null && bindingProperty.getPropertyName() != null) {
                iCodingRuleManager.recycleNumber((IObjectValue)reportBase, orgUnitId, bindingProperty.getPropertyName(), "", reportBase.getNumber());
            } else {
                iCodingRuleManager.recycleNumber((IObjectValue)reportBase, orgUnitId, reportBase.getNumber());
            }
        }
    }

    protected ICodingRuleManager getCodingRuleCtrl(Context ctx) throws BOSException {
        return CodingRuleManagerFactory.getLocalInstance((Context)ctx);
    }

    private void deleteOtherData(Context ctx, Connection conn, List<String> ids, List<MbgWorkPaperInfo> workPapers) throws SQLException, BOSException {
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_RPT_RptSheetPara where FReportID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_RPT_RptPostil where FReportID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgCurrency where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgElement where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgScenario where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgPeriod where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgItemCombin where FBgFormID = ?", ids);
        this.clearBgData(ctx, conn, ids, workPapers);
        BgFacadeHelper.deleteRef((Context)ctx, ids);
    }

    private void clearBgData(Context ctx, Connection conn, List<String> ids, List<MbgWorkPaperInfo> workPapers) throws BOSException {
        final HashMap cube_ids = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("Select mbgWorkPaper.FID, bgScheme.FRefCube FROM T_MBg_MbgWorkPaper mbgWorkPaper LEFT JOIN T_MBg_BgScheme bgScheme ON mbgWorkPaper.FBgSchemeId = bgScheme.FID Where mbgWorkPaper.FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])ids.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String cubeName = res.getString("FRefCube");
                String id = res.getString("FID");
                if (!cube_ids.containsKey(cubeName)) {
                    cube_ids.put(cubeName, new ArrayList());
                }
                ((List)cube_ids.get(cubeName)).add(id);
            }
        });
        MbgWorkPaperInfo workPaper = null;
        HashMap<String, MbgWorkPaperInfo> workPaperMap = new HashMap<String, MbgWorkPaperInfo>();
        for (MbgWorkPaperInfo _workPaper : workPapers) {
            workPaperMap.put(_workPaper.getId().toString(), _workPaper);
        }
        String cubeName2 = null;
        String cslCubeName = null;
        String cslEntryCubeName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tempTable = null;
        try {
            tempTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FDataID VARCHAR(44), FFormID VARCHAR(44))");
            if (tempTable == null) {
                return;
            }
            for (String cubeName2 : cube_ids.keySet()) {
                ids = (List)cube_ids.get(cubeName2);
                cslCubeName = BgCubeUtils.getCFSCubeName((String)cubeName2);
                cslEntryCubeName = BgCubeUtils.getCFSEntryCubeName((String)cubeName2);
                MbgSqlHelper.execute((Connection)conn, (String)("TRUNCATE TABLE " + tempTable));
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tempTable + " (FDataID, FFormId) Select FDataID, FFormId from " + cslEntryCubeName + " where FFormId = ?"), (List)ids);
                MbgSqlHelper.executeBatch((Connection)conn, (String)("delete " + cslEntryCubeName + " where FFormId = ?"), (List)ids);
                MbgSqlHelper.execute((Connection)conn, (String)("delete " + tempTable + " where exists (select FDataID from " + cslEntryCubeName + " where FDataID = " + tempTable + ".FDataID)"));
                MbgSqlHelper.execute((Connection)conn, (String)("delete " + cslCubeName + " where FID IN (select FDataID from " + tempTable + ") and (F100 = '" + BgCslDimConstants.csl01 + "' OR (FState = " + 1 + " OR FState = " + 3 + "))"));
                if (cslCubeName == null || ids == null || ids.isEmpty()) continue;
                for (String _id : ids) {
                    workPaper = (MbgWorkPaperInfo)workPaperMap.get(_id);
                    MbgViewListDescriptionHelper.clearViewlistDesEntries((Connection)conn, (IDimDataQuery)workPaper);
                    MbgViewListDescriptionHelper.clearEditNote((Connection)conn, (IDimDataQuery)workPaper);
                    MbgViewListDescriptionHelper.clearBgCommentRef((Connection)conn, (IDimDataQuery)workPaper);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tempTable != null) {
                try {
                    pool.releaseTable(tempTable);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }
}

