/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.app.data.IBgCslDataCopy;
import com.kingdee.eas.ma.bgcsl.app.data.IBgCslDataCopyProcessor;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public abstract class AbstractBgCslDataCopy
implements IBgCslDataCopy {
    private Context ctx = null;
    private IBgCslDataCopyProcessor processor = null;
    private String refCube = null;

    public Context getCtx() {
        return this.ctx;
    }

    public IBgCslDataCopyProcessor getProcessor() {
        return this.processor;
    }

    public String getSourceTable() {
        return BgCubeUtils.getCFSCubeName((String)this.getRefCube());
    }

    public String getSourceEntryTable() {
        return BgCubeUtils.getCFSEntryCubeName((String)this.getRefCube());
    }

    public String getRefCube() {
        return this.refCube;
    }

    protected AbstractBgCslDataCopy(Context ctx, IBgCslDataCopyProcessor processor) {
        this.ctx = ctx;
    }

    protected void init() throws EASBizException, BOSException {
        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance((Context)this.ctx).getBgSchemeInfo("select refCube where id = '" + this.getProcessor().getBgSchemeId() + "'");
        this.refCube = bgSchemeInfo.getRefCube();
        this.getProcessor().afterInit();
    }

    @Override
    public void execute() throws BOSException, EASBizException {
        Connection conn = null;
        try {
            List<MbgUpdateDataBaseCopyInfo> copyInfos = this.buildCopyInfo(conn);
            List<MbgUpdateDataBaseCopyInfo> entryCopyInfos = this.buildEntryCopyInfo(conn);
            if (copyInfos != null && !copyInfos.isEmpty()) {
                MbgUpdateDataBaseCopyHelper.copyDataBase(conn, (String)this.getProcessor().getTargetTable(), (String)this.getSourceTable(), copyInfos, this.getOtherFields());
            }
            if (entryCopyInfos != null && !entryCopyInfos.isEmpty() && !StringUtils.isEmpty((String)this.getProcessor().getTargetEntryTable())) {
                MbgUpdateDataBaseCopyHelper.copyDataBase(conn, (String)this.getProcessor().getTargetEntryTable(), (String)this.getSourceEntryTable(), entryCopyInfos, this.getEntryOtherFields());
            }
            this.afterExcute(conn);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(conn);
        }
    }

    protected void afterExcute(Connection conn) throws BOSException, EASBizException {
    }

    protected abstract List<MbgUpdateDataBaseCopyInfo> buildEntryCopyInfo(Connection var1) throws BOSException, EASBizException;

    protected Set<String> getEntryOtherFields() {
        return null;
    }

    protected abstract List<MbgUpdateDataBaseCopyInfo> buildCopyInfo(Connection var1) throws BOSException, EASBizException;

    protected Set<String> getOtherFields() {
        return null;
    }

    public static final IBgCslDataCopy getBgAdjImpl(Context ctx, BgCslAdjFormInfo bgAdjForm) {
        return null;
    }
}

