/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.app.data.AbstractBgCslDataCopy;
import com.kingdee.eas.ma.bgcsl.app.data.IBgCslDataCopyProcessor;
import com.kingdee.eas.ma.mbg.BgDataStateEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BgCslAdjFormProcessor
implements IBgCslDataCopyProcessor {
    private AbstractBgCslDataCopy dataCopy = null;
    private BgCslAdjFormInfo bgFormInfo = null;
    private String targetTable = null;
    private String targetEntryTable = null;

    public AbstractBgCslDataCopy getDataCopy() {
        return this.dataCopy;
    }

    public BgCslAdjFormInfo getBgFormInfo() {
        return this.bgFormInfo;
    }

    public BgCslAdjFormProcessor(AbstractBgCslDataCopy dataCopy, BgCslAdjFormInfo bgFormInfo) {
        this.dataCopy = dataCopy;
        this.bgFormInfo = bgFormInfo;
    }

    @Override
    public void afterInit() {
        this.targetTable = BgCubeUtils.getCFSAdjustCubeName((String)this.getDataCopy().getRefCube());
        this.targetEntryTable = BgCubeUtils.getCFSAdjustEntryCubeName((String)this.getDataCopy().getRefCube());
    }

    @Override
    public String getTargetTable() {
        return this.targetTable;
    }

    @Override
    public String getTargetEntryTable() {
        return this.targetEntryTable;
    }

    @Override
    public String getBgSchemeId() {
        return this.getBgFormInfo().getBgScheme().getId().toString();
    }

    @Override
    public BgSchemeInfo getBgScheme() {
        return this.getBgFormInfo().getBgScheme();
    }

    @Override
    public String getOrgUnitId() {
        return this.getBgFormInfo().getOrgUnit().getId().toString();
    }

    @Override
    public String getUnionId() {
        return this.getBgFormInfo().getOrgTree().getId().toString();
    }

    @Override
    public Set<String> getBgVersionNumbers() {
        HashSet<String> bgVersions = new HashSet<String>();
        bgVersions.add(this.getBgFormInfo().getBgVersion().getNumber());
        return bgVersions;
    }

    @Override
    public BgDataStateEnum getTargetState() {
        return BgDataStateEnum.Adjust;
    }

    @Override
    public BgDataStateEnum getSourceState() {
        return BgDataStateEnum.Approved;
    }

    @Override
    public String getId() {
        return this.getBgFormInfo().getId().toString();
    }

    @Override
    public List<String> getFormulaList() throws BOSException {
        try {
            return BgNFSHelper.getFormulaListOfBook((Book)this.getBgFormInfo().getBook());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

