/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.bgcsl.app.data.AbstractBgCslDataCopy;
import com.kingdee.eas.ma.bgcsl.app.data.IBgCslDataCopyProcessor;
import com.kingdee.eas.ma.bgcsl.utils.BgCslDimensionMemberCheckHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewManagerImpl;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyInfo;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BgCslDataFormulaCopy
extends AbstractBgCslDataCopy {
    private TempTablePool pool = null;
    private String tempTable = null;
    private MbgUpdateDataBaseCopyInfo entryCopy = null;

    public TempTablePool getPool() {
        if (this.pool == null) {
            this.pool = TempTablePool.getInstance((Context)this.getCtx());
        }
        return this.pool;
    }

    protected BgCslDataFormulaCopy(Context ctx, IBgCslDataCopyProcessor processor) {
        super(ctx, processor);
    }

    @Override
    protected List<MbgUpdateDataBaseCopyInfo> buildCopyInfo(Connection conn) throws BOSException, EASBizException {
        List<String> formulaList = this.getProcessor().getFormulaList();
        if (formulaList == null || formulaList.isEmpty()) {
            return null;
        }
        MbgViewManagerImpl view = DimensionFormulaHelper.buildViewMamager((Context)this.getCtx(), formulaList, this.getProcessor().getBgVersionNumbers());
        BgCslSchemeDimensionHelper schemeHelper = new BgCslSchemeDimensionHelper(this.getCtx(), this.getProcessor().getBgSchemeId(), this.getProcessor().getBgScheme().getOrgUnit().getId().toString());
        DimensionCacheHelper cacheHelper = new DimensionCacheHelper(this.getCtx());
        BgCslDimensionMemberCheckHelper checkHelper = BgCslDimensionMemberCheckHelper.getLocalIntance(this.getCtx(), cacheHelper, this.getProcessor().getOrgUnitId(), this.getProcessor().getBgScheme().getOrgUnit().getId().toString(), null, (BgSchemeDimensionHelper)schemeHelper, (IMbgViewManager)view);
        Set<String> versions = this.getProcessor().getBgVersionNumbers();
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        HashMap<String, BgVersionInfo> versionMap = new HashMap<String, BgVersionInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("versionId");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", versions, CompareType.INCLUDE));
        BgVersionCollection col = BgVersionFactory.getLocalInstance((Context)this.getCtx()).getBgVersionCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            versionMap.put(col.get(i).getNumber(), col.get(i));
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        String formula2 = null;
        for (String version : versions) {
            for (String formula2 : formulaList) {
                if (!checkHelper.canSave(formula2, null, version)) continue;
                paramList.add(new Object[]{this.getInsertParam(formula2, ((BgVersionInfo)versionMap.get(version)).getVersionId())});
            }
        }
        if (paramList.isEmpty()) {
            return null;
        }
        this.tempTable = this.createTempTable(conn);
        try {
            MbgSqlHelper.executeBatch((Connection)conn, (String)this.getInsertSql(), paramList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
        if (this.getProcessor().getTargetState() != null) {
            copyInfo.addReplace("FState", String.valueOf(this.getProcessor().getTargetState().getValue()));
        }
        StringBuilder where = new StringBuilder();
        where.append("FUnionId = '" + this.getProcessor().getUnionId() + "' AND FOrgUnitId = '" + this.getProcessor().getOrgUnitId() + "' ");
        if (this.getProcessor().getSourceState() != null) {
            where.append(" AND FState = " + this.getProcessor().getSourceState() + " ");
        }
        where.append(" AND exists(Select 1 FROM " + this.tempTable + " t1 Where " + this.getSourceTable() + ".FFormula = t1.FFormula AND " + this.getSourceTable() + ".FVersion = t1.FVersion)");
        copyInfo.setWhere(where.toString());
        ArrayList<MbgUpdateDataBaseCopyInfo> copyInfos = new ArrayList<MbgUpdateDataBaseCopyInfo>();
        copyInfos.add(copyInfo);
        this.entryCopy = new MbgUpdateDataBaseCopyInfo();
        this.entryCopy.setWhere(where.toString());
        this.entryCopy.addReplace("FDataID", "FID");
        this.entryCopy.addReplaceString("FFormId", this.getProcessor().getId());
        return copyInfos;
    }

    @Override
    protected Set<String> getEntryOtherFields() {
        HashSet<String> fields = new HashSet<String>();
        fields.add("FFormId");
        fields.add("FDataId");
        return fields;
    }

    protected String getInsertSql() {
        return "Insert Into " + this.tempTable + "(FFormula, FVersion) Values(?, ?)";
    }

    protected Object getInsertParam(String formula, int versionId) {
        return new Object[]{formula, versionId};
    }

    protected String createTempTable(Connection conn) throws BOSException {
        try {
            return this.getPool().createTempTable("Create Table T_MBG_FORMULACDF(FFormula NVARCHAR(300) NOT NULL, FVersion INT NOT NULL, Primary Key(FFormula, FVersion))");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected List<MbgUpdateDataBaseCopyInfo> buildEntryCopyInfo(Connection conn) throws BOSException, EASBizException {
        ArrayList<MbgUpdateDataBaseCopyInfo> copyInfos = new ArrayList<MbgUpdateDataBaseCopyInfo>();
        copyInfos.add(this.entryCopy);
        return copyInfos;
    }

    @Override
    protected void afterExcute(Connection conn) throws BOSException, EASBizException {
        super.afterExcute(conn);
        if (this.tempTable != null) {
            this.getPool().releaseTable(this.tempTable);
        }
    }
}

