/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.bgcsl.utils.MbgCslDataHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.AbstractMbgBizFacade;
import com.kingdee.eas.ma.mbg.app.data.QueryResult;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.util.db.SQLUtils;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgCsl04DataFacade
extends AbstractMbgBizFacade {
    private static Logger logger = Logger.getLogger(MbgCsl04DataFacade.class);

    public void executeAfter() throws Exception {
        if (this.getMbgDataFacade() == null || this.getMbgDataFacade().getDataManager() == null || this.getMbgDataFacade().getDataManager().getCtx() == null) {
            return;
        }
        long beginTime = System.currentTimeMillis();
        logger.error((Object)"begin excute MbgCsl04DataFacade.");
        Context ctx = this.getMbgDataFacade().getDataManager().getCtx();
        QueryResult result = this.getMbgDataFacade().getQuery().result;
        if (this.checkHasCslData(result) && this.getMbgDataFacade().getDataManager().getBillId() != null) {
            String billId = this.getMbgDataFacade().getDataManager().getBillId();
            String bosType = BOSUuid.read((String)billId).getType().toString();
            String userId = this.getMbgDataFacade().getDataManager().getUserId();
            Timestamp time = new Timestamp(System.currentTimeMillis());
            if ("9E7BD5E2".equals(bosType)) {
                String unionId = null;
                String orgUnitId = null;
                String tmpTableName = null;
                String tmpTableEntry = null;
                String orgTmpTable = null;
                String cubeName = null;
                String cubeEntry = null;
                String FCsl100 = DimensionBaseConstants.DEF_CSL_FIELD;
                String tmpIndex = null;
                String tmpPeriod = null;
                String tmpElement = null;
                String tmpCurrency = null;
                String tmpScenario = null;
                String tmpVersion = null;
                StringBuffer sql = new StringBuffer();
                StringBuffer fieldStr = new StringBuffer();
                List fields = null;
                ArrayList<String> tmpTables = new ArrayList<String>();
                ArrayList<String> tmpList = new ArrayList<String>();
                Map mbgMemNumMap = null;
                MbgWorkPaperInfo dimDataQuery = null;
                BgSchemeInfo schemeInfo = null;
                Connection conn = null;
                TempTablePool pool = TempTablePool.getInstance((Context)ctx);
                try {
                    conn = BgDBUtils.getConnection((Context)ctx);
                    dimDataQuery = MbgCslDataHelper.getMBgWorkPaperInfo(ctx, conn, billId);
                    if (dimDataQuery != null) {
                        unionId = dimDataQuery.getBizUnionId().toString();
                        orgUnitId = dimDataQuery.getBizOrgUnit().getId().toString();
                        schemeInfo = MbgDataHelper.getBgSchemeInfo((Context)ctx, (BOSUuid)dimDataQuery.getBizBgScheme().getId());
                        fields = schemeInfo.getRefFields(conn);
                        cubeName = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
                        cubeEntry = BgCubeUtils.getCFSEntryCubeName((String)schemeInfo.getRefCube());
                        if (this.getMbgDataFacade().getDataManager().getMbgMemNumMap().containsKey(billId)) {
                            mbgMemNumMap = (Map)this.getMbgDataFacade().getDataManager().getMbgMemNumMap().get(billId);
                        } else {
                            List workMembers = MbgDataHelper.parseMbgMember((Context)ctx, (IDimDataQuery)dimDataQuery, (BgSchemeInfo)schemeInfo, (Map)this.getMbgDataFacade().getDataManager().getSrcFieldMap());
                            mbgMemNumMap = MbgDataHelper.mergeMbgMember((List)workMembers);
                            this.getMbgDataFacade().getDataManager().getMbgMemNumMap().put(billId, mbgMemNumMap);
                        }
                        DecimalFormat df = new DecimalFormat("#########");
                        SecureRandom sRandom = new SecureRandom();
                        String Pk = "PK_MBG_" + df.format(sRandom.nextInt(999999999));
                        sql.append("CREATE TABLE TMPTABLE (FID VARCHAR(44) NOT NULL, FOrgUnitID VARCHAR(44), FFormula NVARCHAR(300)");
                        for (String field : fields) {
                            sql.append(", " + field + " NVARCHAR(84)");
                            fieldStr.append(", " + field);
                        }
                        sql.append(", " + FCsl100 + " NVARCHAR(84), FVALUE NUMERIC(21,8) DEFAULT 0, FBgItemCombination NVARCHAR(" + 300 + "), FBgPeriodID VARCHAR(44), FBgElementID VARCHAR(44), FCurrencyID VARCHAR(44), FScenario INT, FVersion INT, CONSTRAINT " + Pk + " PRIMARY KEY (FID))");
                        tmpTableName = pool.createTempTable(sql.toString());
                        pool.createIndex(tmpTableName, "FOrgUnitID, FFormula, FVersion", true, false);
                        tmpTables.add(tmpTableName);
                        tmpTableEntry = pool.createTempTable("CREATE TABLE TMPTABLE (FFormID VARCHAR(44), FDataId VARCHAR(44))");
                        pool.createIndex(tmpTableEntry, "FFormID, FDataId", false, false);
                        tmpTables.add(tmpTableEntry);
                        orgTmpTable = pool.createTempTable("CREATE TABLE TMPTABLE (FID VARCHAR(44))");
                        tmpTables.add(orgTmpTable);
                        BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + orgTmpTable + " (FID) Select FUNITID from T_ORG_STRUCTURE where FPARENTID IN (select FID from T_ORG_STRUCTURE where FUNITID = ?)"), (Object[])new Object[]{orgUnitId});
                        if (mbgMemNumMap != null && !mbgMemNumMap.isEmpty()) {
                            if (!(mbgMemNumMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD) && mbgMemNumMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD) && mbgMemNumMap.containsKey(DimensionBaseConstants.DEF_ELEMENT_FIELD) && mbgMemNumMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD) && mbgMemNumMap.containsKey(DimensionBaseConstants.DEF_SCENARIO_FIELD) && mbgMemNumMap.containsKey(DimensionBaseConstants.DEF_VERSION_FIELD))) {
                                return;
                            }
                            if (tmpIndex == null) {
                                tmpIndex = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84))");
                                tmpTables.add(tmpIndex);
                            }
                            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpIndex + " (FNumber) values (?)"), (Collection)((Collection)mbgMemNumMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD)));
                            if (tmpPeriod == null) {
                                tmpPeriod = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                                tmpTables.add(tmpPeriod);
                            }
                            tmpList.clear();
                            tmpList.addAll((Collection)mbgMemNumMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
                            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpPeriod + " (FID) select FID from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            if (tmpElement == null) {
                                tmpElement = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                                tmpTables.add(tmpElement);
                            }
                            tmpList.clear();
                            tmpList.addAll((Collection)mbgMemNumMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD));
                            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpElement + " (FID) select FID from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            if (tmpCurrency == null) {
                                tmpCurrency = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                                tmpTables.add(tmpCurrency);
                            }
                            tmpList.clear();
                            tmpList.addAll((Collection)mbgMemNumMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
                            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpCurrency + " (FID) select FID from T_BD_Currency where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            if (tmpScenario == null) {
                                tmpScenario = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
                                tmpTables.add(tmpScenario);
                            }
                            tmpList.clear();
                            tmpList.addAll((Collection)mbgMemNumMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD));
                            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpScenario + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            if (tmpVersion == null) {
                                tmpVersion = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
                                tmpTables.add(tmpVersion);
                            }
                            tmpList.clear();
                            tmpList.add(dimDataQuery.getBizVersion().getNumber());
                            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpVersion + " (FID) select FVersionId from T_MBG_BgVersion where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            sql.setLength(0);
                            sql.append("Insert Into " + tmpTableName + " (FID, FOrgUnitID, FFormula" + fieldStr + ", " + FCsl100 + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FValue) ");
                            sql.append("select newbosid('3BA4D30D'), FOrgUnitID, FFormula" + fieldStr + "," + FCsl100 + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, sum(FValue) from ");
                            sql.append(" (select FOrgUnitID, replace(FFormula,'" + BgCslDimConstants.csl01 + "','" + BgCslDimConstants.csl03 + "') as FFormula" + fieldStr + ", '" + BgCslDimConstants.csl03 + "' AS " + FCsl100 + ", replace(FBgItemCombination,'" + BgCslDimConstants.csl01 + "','" + BgCslDimConstants.csl03 + "') as FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FValue  from " + cubeName + " where FUnionID = ? and FOrgUnitID IN (select FID from " + orgTmpTable + ") and " + FCsl100 + " = ?  and exists (select FNumber from " + tmpIndex + " where FNumber = " + cubeName + ".F2)  and exists (select FID from " + tmpPeriod + " where FID = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)   and exists (select FID from " + tmpVersion + " where FID = " + cubeName + ".FVersion) ");
                            sql.append(" UNION ALL ");
                            sql.append(" select FOrgUnitID, replace(FFormula,'" + BgCslDimConstants.csl02 + "','" + BgCslDimConstants.csl03 + "') as FFormula" + fieldStr + ", '" + BgCslDimConstants.csl03 + "' AS " + FCsl100 + ", replace(FBgItemCombination,'" + BgCslDimConstants.csl02 + "','" + BgCslDimConstants.csl03 + "') as FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FValue  from " + cubeName + " where FUnionID = ? and FOrgUnitID IN (select FID from " + orgTmpTable + ") and " + FCsl100 + " = ?  and exists (select FNumber from " + tmpIndex + " where FNumber = " + cubeName + ".F2)  and exists (select FID from " + tmpPeriod + " where FID = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)   and exists (select FID from " + tmpVersion + " where FID = " + cubeName + ".FVersion)) as tempT ");
                            sql.append(" group by FOrgUnitID, FFormula" + fieldStr + "," + FCsl100 + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion");
                            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, BgCslDimConstants.csl01, unionId, BgCslDimConstants.csl02});
                            sql.setLength(0);
                            sql.append("Insert Into " + tmpTableName + " (FID, FOrgUnitID, FFormula" + fieldStr + ", " + FCsl100 + ", FVALUE, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion) ");
                            sql.append(" select newbosid('3BA4D30D'), ?, REPLACE(FFormula,'" + BgCslDimConstants.csl03 + "','" + BgCslDimConstants.csl04 + "')" + fieldStr + ", '" + BgCslDimConstants.csl04 + "', sum(FVALUE), REPLACE(FBgItemCombination,'" + BgCslDimConstants.csl03 + "','" + BgCslDimConstants.csl04 + "'),  FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion  from " + tmpTableName + " group by FFormula" + fieldStr + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion");
                            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new String[]{orgUnitId});
                            BgDBUtils.executeUpdate((Connection)conn, (String)("update " + cubeName + " set FValue = 0, FTmpValue = 0 where FUnionID = ? and FOrgUnitID = ? and " + FCsl100 + " = ?  and exists (select FNumber from " + tmpIndex + " where FNumber = " + cubeName + ".F2)  and exists (select FID from " + tmpPeriod + " where FID = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)  and exists (select FID from " + tmpVersion + " where FID = " + cubeName + ".FVersion)  and FState IN (?, ?)"), (Object[])new Object[]{unionId, orgUnitId, BgCslDimConstants.csl04, 1, 3});
                            sql.setLength(0);
                            sql.append("update " + tmpTableName + " Set FID = (select FID from " + cubeName + " where FUnionID = ? and FOrgUnitID = " + tmpTableName + ".FOrgUnitID and FFormula = " + tmpTableName + ".FFormula and FVersion = " + tmpTableName + ".FVersion)  where exists (select FID from " + cubeName + " where FUnionID = ? and FOrgUnitID = " + tmpTableName + ".FOrgUnitID and FFormula = " + tmpTableName + ".FFormula and FVersion = " + tmpTableName + ".FVersion)");
                            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, unionId});
                            BgDBUtils.executeUpdate((Connection)conn, (String)("update " + cubeName + " set FValue = 0, FLastUpdateUserId = ?, FLastUpdateTime = ? where FUnionID = ? and FOrgUnitID IN (select FID from " + orgTmpTable + ") and " + FCsl100 + " = ? and FState IN (?,?)  and exists (select FDataId from " + cubeEntry + " where FDataId = " + cubeName + ".FID and FFormId = ?)"), (Object[])new Object[]{userId, time, unionId, BgCslDimConstants.csl03, 1, 3, billId});
                            sql.setLength(0);
                            sql.append("update " + cubeName + " Set FValue = (select FValue from " + tmpTableName + " where FID = " + cubeName + ".FID), FLastUpdateUserId = ?, FLastUpdateTime = ?  where FUnionID = ? and exists (select FID from " + tmpTableName + " where FID = " + cubeName + ".FID) and FState IN (?, ?)");
                            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{userId, time, unionId, 1, 3});
                            sql.setLength(0);
                            sql.append("Insert Into " + cubeName + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FUnionID, FOrgUnitID, FFormula" + fieldStr + ", " + FCsl100 + ", FValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState)  select FID,'" + userId + "',NOW(),'" + userId + "',NOW(),?, FOrgUnitID, FFormula" + fieldStr + "," + FCsl100 + ", FValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, ?  from " + tmpTableName + " where not exists (select FID from " + cubeName + " where FUnionID = ? and FOrgUnitID = " + tmpTableName + ".FOrgUnitID and FFormula = " + tmpTableName + ".FFormula and FVersion = " + tmpTableName + ".FVersion)");
                            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, 1, unionId});
                            BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpTableEntry + " (FFormId, FDataId) Select ?, FID from " + tmpTableName), (Object[])new Object[]{billId});
                            BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + cubeEntry + " (FFormId, FDataId)  Select FFormId, FDataID from " + tmpTableEntry + " where not exists (select * from " + cubeEntry + " where FFormId = " + tmpTableEntry + ".FFormId and FDataID = " + tmpTableEntry + ".FDataID)"));
                        }
                    }
                }
                catch (SQLDataException ex) {
                    logger.error((Object)"cslData executeBiz sql error:", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (SQLException ex) {
                    logger.error((Object)"cslData executeBiz sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Exception ex) {
                    logger.error((Object)"cslData executeBiz sql error:", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                finally {
                    int in = tmpTables.size();
                    for (int i = 0; i < in; ++i) {
                        pool.releaseTable((String)tmpTables.get(i));
                    }
                    SQLUtils.cleanup((Connection)conn);
                }
            }
        }
        long endTime = System.currentTimeMillis();
        logger.error((Object)("end excute MbgCsl04DataFacade. use = " + (endTime - beginTime) + " ms."));
    }

    protected boolean checkHasCslData(QueryResult result) {
        return result != null;
    }
}

