/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.bgcsl.utils.MbgCslDataHelper;
import com.kingdee.eas.ma.mbg.BgDataInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.AbstractMbgBizFacade;
import com.kingdee.eas.ma.mbg.app.data.QueryResult;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgCsl07DataFacade
extends AbstractMbgBizFacade {
    private static Logger logger = Logger.getLogger(MbgCsl07DataFacade.class);
    private boolean checkHasData = false;
    private BOSUuid billID = null;

    protected void setCheckHasData(boolean checkHasData) {
        this.checkHasData = checkHasData;
    }

    protected boolean isCheckHasData() {
        return this.checkHasData;
    }

    public void setBillID(BOSUuid billID) {
        this.billID = billID;
    }

    public BOSUuid getBillID() {
        return this.billID;
    }

    public MbgCsl07DataFacade() {
    }

    public MbgCsl07DataFacade(boolean isCheckData) {
        this.setCheckHasData(isCheckData);
    }

    public MbgCsl07DataFacade(boolean isBefore, boolean isAfter, boolean isCheckData) {
        this.setBefore(isBefore);
        this.setAfter(isAfter);
        this.setCheckHasData(isCheckData);
    }

    public void executeAfter() throws Exception {
        if (this.getMbgDataFacade() == null || this.getMbgDataFacade().getDataManager() == null || this.getMbgDataFacade().getDataManager().getCtx() == null) {
            return;
        }
        long beginTime = System.currentTimeMillis();
        logger.error((Object)"begin excute MbgCsl07DataFacade.");
        Context ctx = this.getMbgDataFacade().getDataManager().getCtx();
        QueryResult result = this.getMbgDataFacade().getQuery().result;
        if (this.checkHasCslData(result) && this.getMbgDataFacade().getDataManager().getBillId() != null) {
            String billId = this.getMbgDataFacade().getDataManager().getBillId();
            String bosType = BOSUuid.read((String)billId).getType().toString();
            String userId = this.getMbgDataFacade().getDataManager().getUserId();
            Timestamp time = new Timestamp(System.currentTimeMillis());
            if ("9E7BD5E2".equals(bosType)) {
                String unionId = null;
                String orgUnitId = null;
                String tmpTableName = null;
                String orgTmpTable = null;
                String csl08Table = null;
                String csl08Entry = null;
                String cubeName = null;
                String cubeEntry = null;
                String type = null;
                String csl01 = DimensionConstants.DEF_CSL_SRCNUMBER + ":" + "CSL-01";
                String csl02 = DimensionConstants.DEF_CSL_SRCNUMBER + ":" + "CSL-02";
                String csl04 = DimensionConstants.DEF_CSL_SRCNUMBER + ":" + "CSL-04";
                String csl05 = DimensionConstants.DEF_CSL_SRCNUMBER + ":" + "CSL-05";
                String csl06 = DimensionConstants.DEF_CSL_SRCNUMBER + ":" + "CSL-06";
                String csl07 = DimensionConstants.DEF_CSL_SRCNUMBER + ":" + "CSL-07";
                String csl08 = DimensionConstants.DEF_CSL_SRCNUMBER + ":" + "CSL-08";
                String FCsl100 = DimensionBaseConstants.DEF_CSL_FIELD;
                String tmpIndex = null;
                String tmpPeriod = null;
                String tmpElement = null;
                String tmpCurrency = null;
                String tmpScenario = null;
                String tmpVersion = null;
                StringBuffer sql = new StringBuffer();
                StringBuffer fieldStr = new StringBuffer();
                List fields = null;
                ArrayList<String> tmpTables = new ArrayList<String>();
                ArrayList<String> tmpList = new ArrayList<String>();
                Map mbgMemNumMap = null;
                MbgWorkPaperInfo dimDataQuery = null;
                BgSchemeInfo schemeInfo = null;
                Connection conn = null;
                TempTablePool pool = TempTablePool.getInstance((Context)ctx);
                try {
                    conn = BgDBUtils.getConnection((Context)ctx);
                    dimDataQuery = MbgCslDataHelper.getMBgWorkPaperInfo(ctx, conn, billId);
                    if (dimDataQuery != null) {
                        unionId = dimDataQuery.getBizUnionId().toString();
                        orgUnitId = dimDataQuery.getBizOrgUnit().getId().toString();
                        type = new BgDataInfo().getBOSType().toString();
                        schemeInfo = MbgDataHelper.getBgSchemeInfo((Context)ctx, (BOSUuid)dimDataQuery.getBizBgScheme().getId());
                        fields = schemeInfo.getRefFields(conn);
                        cubeName = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
                        cubeEntry = BgCubeUtils.getCFSEntryCubeName((String)schemeInfo.getRefCube());
                        if (this.getMbgDataFacade().getDataManager().getMbgMemNumMap().containsKey(billId)) {
                            mbgMemNumMap = (Map)this.getMbgDataFacade().getDataManager().getMbgMemNumMap().get(billId);
                        } else {
                            List workMembers = MbgDataHelper.parseMbgMember((Context)ctx, (IDimDataQuery)dimDataQuery, (BgSchemeInfo)schemeInfo, (Map)this.getMbgDataFacade().getDataManager().getSrcFieldMap());
                            mbgMemNumMap = MbgDataHelper.mergeMbgMember((List)workMembers);
                            this.getMbgDataFacade().getDataManager().getMbgMemNumMap().put(billId, mbgMemNumMap);
                        }
                        DecimalFormat df = new DecimalFormat("#########");
                        SecureRandom sRandom = new SecureRandom();
                        String Pk = "PK_MBG_" + df.format(sRandom.nextInt(999999999));
                        sql.append("CREATE TABLE TMPTABLE (FID VARCHAR(44) NOT NULL, FFormula NVARCHAR(300)");
                        for (String field : fields) {
                            sql.append(", " + field + " NVARCHAR(84)");
                            fieldStr.append(", " + field);
                        }
                        sql.append(", " + FCsl100 + " NVARCHAR(84), FVALUE NUMERIC(21,8) DEFAULT 0, FBgItemCombination NVARCHAR(" + 300 + "), FBgPeriodID VARCHAR(44), FBgElementID VARCHAR(44), FCurrencyID VARCHAR(44), FScenario INT, FVersion INT, CONSTRAINT " + Pk + " PRIMARY KEY (FID))");
                        tmpTableName = pool.createTempTable(sql.toString());
                        pool.createIndex(tmpTableName, "F2, " + FCsl100, false, false);
                        pool.createIndex(tmpTableName, "FFormula " + fieldStr + "," + FCsl100 + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FValue", false, false);
                        tmpTables.add(tmpTableName);
                        orgTmpTable = pool.createTempTable("CREATE TABLE TMPTABLE (FID VARCHAR(44))");
                        tmpTables.add(orgTmpTable);
                        BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + orgTmpTable + " (FID) Select FUNITID from T_ORG_STRUCTURE where FPARENTID IN (select FID from T_ORG_STRUCTURE where FUNITID = ?)"), (Object[])new Object[]{orgUnitId});
                        if (mbgMemNumMap != null && !mbgMemNumMap.isEmpty()) {
                            if (!(mbgMemNumMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD) && mbgMemNumMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD) && mbgMemNumMap.containsKey(DimensionBaseConstants.DEF_ELEMENT_FIELD) && mbgMemNumMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD) && mbgMemNumMap.containsKey(DimensionBaseConstants.DEF_SCENARIO_FIELD) && mbgMemNumMap.containsKey(DimensionBaseConstants.DEF_VERSION_FIELD))) {
                                return;
                            }
                            if (tmpIndex == null) {
                                tmpIndex = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84))");
                                tmpTables.add(tmpIndex);
                            }
                            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpIndex + " (FNumber) values (?)"), (Collection)((Collection)mbgMemNumMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD)));
                            if (tmpPeriod == null) {
                                tmpPeriod = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                                tmpTables.add(tmpPeriod);
                            }
                            tmpList.clear();
                            tmpList.addAll((Collection)mbgMemNumMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
                            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpPeriod + " (FID) select FID from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            if (tmpElement == null) {
                                tmpElement = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                                tmpTables.add(tmpElement);
                            }
                            tmpList.clear();
                            tmpList.addAll((Collection)mbgMemNumMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD));
                            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpElement + " (FID) select FID from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            if (tmpCurrency == null) {
                                tmpCurrency = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                                tmpTables.add(tmpCurrency);
                            }
                            tmpList.clear();
                            tmpList.addAll((Collection)mbgMemNumMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
                            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpCurrency + " (FID) select FID from T_BD_Currency where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            if (tmpScenario == null) {
                                tmpScenario = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
                                tmpTables.add(tmpScenario);
                            }
                            tmpList.clear();
                            tmpList.addAll((Collection)mbgMemNumMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD));
                            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpScenario + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            if (tmpVersion == null) {
                                tmpVersion = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
                                tmpTables.add(tmpVersion);
                            }
                            tmpList.clear();
                            tmpList.add(dimDataQuery.getBizVersion().getNumber());
                            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpVersion + " (FID) select FVersionId from T_MBG_BgVersion where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            sql.setLength(0);
                            sql.append("Insert Into " + tmpTableName + " (FID, FFormula" + fieldStr + ", " + FCsl100 + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FValue) ");
                            sql.append("select newbosid('" + type + "'), FFormula" + fieldStr + "," + FCsl100 + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, sum(FValue) from ");
                            sql.append(" (select replace(FFormula,'" + csl01 + "','" + csl04 + "') as FFormula" + fieldStr + ",'" + csl04 + "' AS " + FCsl100 + ", replace(FBgItemCombination,'" + csl01 + "','" + csl04 + "') as FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FValue  from " + cubeName + " where FUnionID = ? and FOrgUnitID IN (select FID from " + orgTmpTable + ") and " + FCsl100 + " = ?  and exists (select FNumber from " + tmpIndex + " where FNumber = " + cubeName + ".F2)  and exists (select FID from " + tmpPeriod + " where FID = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)   and exists (select FID from " + tmpVersion + " where FID = " + cubeName + ".FVersion) ");
                            sql.append(" UNION ALL ");
                            sql.append(" select replace(FFormula,'" + csl02 + "','" + csl04 + "') as FFormula" + fieldStr + ",'" + csl04 + "' AS " + FCsl100 + ", replace(FBgItemCombination,'" + csl02 + "','" + csl04 + "') as FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FValue  from " + cubeName + " where FUnionID = ? and FOrgUnitID IN (select FID from " + orgTmpTable + ") and " + FCsl100 + " = ?  and exists (select FNumber from " + tmpIndex + " where FNumber = " + cubeName + ".F2)  and exists (select FID from " + tmpPeriod + " where FID = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)   and exists (select FID from " + tmpVersion + " where FID = " + cubeName + ".FVersion)) AS T_TEMP_TABLE ");
                            sql.append(" group by FFormula" + fieldStr + "," + FCsl100 + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion");
                            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, csl01, unionId, csl02});
                            sql.setLength(0);
                            sql.append("Insert Into " + tmpTableName + " (FID, FFormula" + fieldStr + ", " + FCsl100 + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FValue)  Select newbosid('" + type + "'), FFormula" + fieldStr + "," + FCsl100 + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FValue from " + cubeName + " where FUnionID = ? and FOrgUnitID = ? and " + FCsl100 + " IN (?,?,?) and exists (select FNumber from " + tmpIndex + " where FNumber = " + cubeName + ".F2)  and exists (select FID from " + tmpPeriod + " where FID = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)   and exists (select FID from " + tmpVersion + " where FID = " + cubeName + ".FVersion)");
                            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, orgUnitId, csl05, csl06, csl07});
                        }
                        String acctViewId = schemeInfo.getViewId(DimensionBaseConstants.DEF_INDEX_NUMBER).toString();
                        sql.setLength(0);
                        sql.append("update " + tmpTableName + " set FValue = 0 - FValue where " + FCsl100 + " = ? and exists (select FID from T_MBG_BgAccount where CONCAT('" + DimensionBaseConstants.DEF_INDEX_SRCNUMBER + ":" + "', FNumber) = " + tmpTableName + ".F2 and FBgAccountViewId = ? and FBgDecreditAlgorithm = ?)");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{csl06, acctViewId, 10});
                        sql.setLength(0);
                        sql.append("update " + tmpTableName + " set FValue = 0 - FValue where " + FCsl100 + " = ? and exists (select FID from T_MBG_BgAccount where CONCAT('" + DimensionBaseConstants.DEF_INDEX_SRCNUMBER + ":" + "', FNumber) = " + tmpTableName + ".F2 and FBgAccountViewId = ? and FBgDecreditAlgorithm = ?)");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{csl05, acctViewId, 20});
                        sql.setLength(0);
                        sql.append("update " + tmpTableName + " set FFormula = replace(FFormula,'" + csl04 + "','" + csl08 + "'), FBgItemCombination = replace(FBgItemCombination,'" + csl04 + "','" + csl08 + "'), " + FCsl100 + " = ? where " + FCsl100 + " = ?");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{csl08, csl04});
                        sql.setLength(0);
                        sql.append("update " + tmpTableName + " set FFormula = replace(FFormula,'" + csl05 + "','" + csl08 + "'), FBgItemCombination = replace(FBgItemCombination,'" + csl05 + "','" + csl08 + "'), " + FCsl100 + " = ? where " + FCsl100 + " = ?");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{csl08, csl05});
                        sql.setLength(0);
                        sql.append("update " + tmpTableName + " set FFormula = replace(FFormula,'" + csl06 + "','" + csl08 + "'), FBgItemCombination = replace(FBgItemCombination,'" + csl06 + "','" + csl08 + "'), " + FCsl100 + " = ? where " + FCsl100 + " = ?");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{csl08, csl06});
                        sql.setLength(0);
                        sql.append("update " + tmpTableName + " set FFormula = replace(FFormula,'" + csl07 + "','" + csl08 + "'), FBgItemCombination = replace(FBgItemCombination,'" + csl07 + "','" + csl08 + "'), " + FCsl100 + " = ? where " + FCsl100 + " = ?");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{csl08, csl07});
                        sql.setLength(0);
                        sql.append("CREATE TABLE TMPTABLE (FID VARCHAR(44) NOT NULL, FFormula NVARCHAR(300)");
                        for (String field : fields) {
                            sql.append(", " + field + " NVARCHAR(84)");
                        }
                        sql.append(", " + FCsl100 + " NVARCHAR(84), FVALUE NUMERIC(21,8) DEFAULT 0, FBgItemCombination NVARCHAR(" + 300 + "), FBgPeriodID VARCHAR(44), FBgElementID VARCHAR(44), FCurrencyID VARCHAR(44), FScenario INT, FVersion INT)");
                        csl08Table = pool.createTempTable(sql.toString());
                        pool.createIndex(csl08Table, "FFormula, FVersion", true, false);
                        tmpTables.add(csl08Table);
                        csl08Entry = pool.createTempTable("CREATE TABLE TMPTABLE (FFormID VARCHAR(44), FDataId VARCHAR(44))");
                        pool.createIndex(csl08Entry, "FFormID, FDataId", false, false);
                        tmpTables.add(csl08Entry);
                        sql.setLength(0);
                        sql.append("Insert Into " + csl08Table + " (FID, FFormula" + fieldStr + ", " + FCsl100 + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FValue)  Select newbosid('" + type + "'), FFormula" + fieldStr + "," + FCsl100 + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, sum(FValue) from " + tmpTableName + " group by FFormula" + fieldStr + "," + FCsl100 + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
                        sql.setLength(0);
                        sql.append("update " + csl08Table + " Set FID = (select FID from " + cubeName + " where FUnionID = ? and FOrgUnitID = ? and FFormula = " + csl08Table + ".FFormula and FVersion = " + csl08Table + ".FVersion)  where exists (select FID from " + cubeName + " where FUnionID = ? and FOrgUnitID = ? and FFormula = " + csl08Table + ".FFormula and FVersion = " + csl08Table + ".FVersion)");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, orgUnitId, unionId, orgUnitId});
                        sql.setLength(0);
                        sql.append("update " + cubeName + " Set FValue = (select FValue from " + csl08Table + " where FID = " + cubeName + ".FID), FLastUpdateUserId = ?, FLastUpdateTime = ?  where FUnionID = ? and FOrgUnitID = ? and " + FCsl100 + " = ? and exists (select FID from " + csl08Table + " where FID = " + cubeName + ".FID) and FState IN (?,?)");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{userId, time, unionId, orgUnitId, BgCslDimConstants.csl08, 1, 3});
                        sql.setLength(0);
                        sql.append("Insert Into " + cubeName + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FUnionID, FOrgUnitID, FFormula" + fieldStr + ", " + FCsl100 + ", FValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState)  select FID,'" + userId + "',NOW(),'" + userId + "',NOW(),?,?,FFormula" + fieldStr + "," + FCsl100 + ", FValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, ?  from " + csl08Table + " where not exists (select FID from " + cubeName + " where FUnionID = ? and FOrgUnitID = ? and FFormula = " + csl08Table + ".FFormula and FVersion = " + csl08Table + ".FVersion)");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, orgUnitId, 1, unionId, orgUnitId});
                        BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + csl08Entry + " (FFormId, FDataId) Select ?, FID from " + csl08Table), (Object[])new Object[]{billId});
                        BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + cubeEntry + " (FFormId, FDataId) Select FFormId, FDataID from " + csl08Entry + " where not exists (select * from " + cubeEntry + " where FFormId = " + csl08Entry + ".FFormId and FDataID = " + csl08Entry + ".FDataID)"));
                        this.clearData(pool, conn, cubeName, cubeEntry, unionId, orgUnitId, orgTmpTable, tmpIndex, tmpPeriod, tmpElement, tmpCurrency, tmpScenario, tmpVersion);
                    }
                }
                catch (SQLDataException ex) {
                    logger.error((Object)"cslData executeBiz sql error:", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (SQLException ex) {
                    logger.error((Object)"cslData executeBiz sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Exception ex) {
                    logger.error((Object)"cslData executeBiz sql error:", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                finally {
                    if (pool != null) {
                        int in = tmpTables.size();
                        for (int i = 0; i < in; ++i) {
                            pool.releaseTable((String)tmpTables.get(i));
                        }
                    }
                    SQLUtils.cleanup((Connection)conn);
                }
            }
        }
        long endTime = System.currentTimeMillis();
        logger.error((Object)("end excute MbgCsl07DataFacade. use = " + (endTime - beginTime) + " ms."));
    }

    protected boolean checkHasCslData(QueryResult result) {
        boolean re = true;
        if (this.isCheckHasData() && result != null && result.addnew.isEmpty() && result.update.isEmpty() && result.delete.isEmpty() && !this.getMbgDataFacade().getDataManager().hasClearData) {
            re = false;
        }
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void clearData(TempTablePool pool, Connection conn, String cslDataTable, String cslDataEntry, String unionId, String orgUnitId, String orgTmpTable, String tmpIndex, String tmpPeriod, String tmpElement, String tmpCurrency, String tmpScenario, String tmpVersion) throws BOSException, EASBizException {
        if (pool == null) return;
        if (conn == null) return;
        if (cslDataTable == null) return;
        if (cslDataEntry == null) return;
        if (orgTmpTable == null) return;
        if (tmpIndex == null) return;
        if (tmpPeriod == null) return;
        if (tmpElement == null) return;
        if (tmpCurrency == null) return;
        if (tmpScenario == null) return;
        if (tmpVersion == null) {
            return;
        }
        String _id = null;
        String _orgUnitId = null;
        String _formula = null;
        String tmpFormula = null;
        String dimNumber = null;
        String cslMember = null;
        String tmpTable = null;
        String[] formulaParams = null;
        Object[] cslValue = null;
        int _versionId = 0;
        boolean hasData = false;
        boolean hasCsl08Source = false;
        BigDecimal _value = null;
        HashMap cslDataMap = new HashMap();
        Map formulaMap = null;
        Map<String, Object[]> cslMap = null;
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> clearCsl08 = new ArrayList<String>();
        boolean isWorkPaper = this.billID != null && new MbgWorkPaperInfo().getBOSType().equals((Object)this.billID.getType());
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FOrgUnitID, FFormula, FVersion, FValue from " + cslDataTable + " where FUnionID = ?  and FOrgUnitID IN (select FID from " + orgTmpTable + ") and exists (select FNumber from " + tmpIndex + " where FNumber = " + cslDataTable + ".F2) and exists (select FID from " + tmpPeriod + " where FID = " + cslDataTable + ".FBgPeriodID) and exists (select FID from " + tmpElement + " where FID = " + cslDataTable + ".FBgElementID) and exists (select FID from " + tmpCurrency + " where FID = " + cslDataTable + ".FCurrencyID) and exists (select FID from " + tmpScenario + " where FID = " + cslDataTable + ".FScenario) and exists (select FID from " + tmpVersion + " where FID = " + cslDataTable + ".FVersion)");
        IRowSet rst = null;
        try {
            BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + orgTmpTable + "(FID) values (?)"), (Object[])new Object[]{orgUnitId});
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId});
            while (rst.next()) {
                _id = rst.getString("FID");
                _orgUnitId = rst.getString("FOrgUnitID");
                _formula = rst.getString("FFormula");
                _versionId = rst.getInt("FVersion");
                _value = rst.getBigDecimal("FValue");
                formulaParams = BgNFSHelper.parseFormulaPara((String)_formula);
                dimNumber = formulaParams[0];
                cslMember = dimNumber.substring(dimNumber.lastIndexOf(",") + 1);
                formulaParams[0] = dimNumber.substring(0, dimNumber.indexOf(cslMember) - 1);
                tmpFormula = BgNFSHelper.getFormulaFromParam((String[])formulaParams) + "_" + _versionId;
                if (cslDataMap.containsKey(_orgUnitId)) {
                    formulaMap = (Map)cslDataMap.get(_orgUnitId);
                } else {
                    formulaMap = new HashMap();
                    cslDataMap.put(_orgUnitId, formulaMap);
                }
                if (formulaMap.containsKey(tmpFormula)) {
                    cslMap = (Map)formulaMap.get(tmpFormula);
                } else {
                    cslMap = new HashMap();
                    formulaMap.put(tmpFormula, cslMap);
                }
                cslMap.put(cslMember, new Object[]{_id, _value});
            }
            SQLUtils.cleanup((ResultSet)rst);
            Map.Entry entry2 = null;
            Map.Entry cslentry2 = null;
            for (Map.Entry entry2 : cslDataMap.entrySet()) {
                _orgUnitId = (String)entry2.getKey();
                formulaMap = (HashMap)entry2.getValue();
                for (Map.Entry cslentry2 : formulaMap.entrySet()) {
                    tmpFormula = (String)cslentry2.getKey();
                    cslMap = (HashMap)cslentry2.getValue();
                    hasData = false;
                    if (!_orgUnitId.equals(orgUnitId) && cslMap.containsKey(BgCslDimConstants.csl01) && BigDecimal.ZERO.compareTo(_value = (BigDecimal)(cslValue = (Object[])cslMap.get(BgCslDimConstants.csl01))[1]) != 0) {
                        hasData = true;
                    }
                    if (!hasData && cslMap.containsKey(BgCslDimConstants.csl05) && BigDecimal.ZERO.compareTo(_value = (BigDecimal)(cslValue = (Object[])cslMap.get(BgCslDimConstants.csl05))[1]) != 0) {
                        hasData = true;
                    }
                    if (!hasData && cslMap.containsKey(BgCslDimConstants.csl06) && BigDecimal.ZERO.compareTo(_value = (BigDecimal)(cslValue = (Object[])cslMap.get(BgCslDimConstants.csl06))[1]) != 0) {
                        hasData = true;
                    }
                    if (!hasData && cslMap.containsKey(BgCslDimConstants.csl07) && BigDecimal.ZERO.compareTo(_value = (BigDecimal)(cslValue = (Object[])cslMap.get(BgCslDimConstants.csl07))[1]) != 0) {
                        hasData = true;
                    }
                    if (cslMap.containsKey(BgCslDimConstants.csl03)) {
                        cslValue = (Object[])cslMap.get(BgCslDimConstants.csl03);
                        _value = (BigDecimal)cslValue[1];
                        if (!hasData && BigDecimal.ZERO.compareTo(_value) == 0) {
                            ids.add((String)cslValue[0]);
                        }
                    }
                    if (cslMap.containsKey(BgCslDimConstants.csl04)) {
                        cslValue = (Object[])cslMap.get(BgCslDimConstants.csl04);
                        _value = (BigDecimal)cslValue[1];
                        if (!hasData && BigDecimal.ZERO.compareTo(_value) == 0) {
                            ids.add((String)cslValue[0]);
                        }
                    }
                    if (!cslMap.containsKey(BgCslDimConstants.csl08)) continue;
                    cslValue = (Object[])cslMap.get(BgCslDimConstants.csl08);
                    _value = (BigDecimal)cslValue[1];
                    if (!hasData && BigDecimal.ZERO.compareTo(_value) == 0) {
                        ids.add((String)cslValue[0]);
                        continue;
                    }
                    if (cslMap.size() != 1 || !isWorkPaper || !_orgUnitId.equals(orgUnitId)) continue;
                    clearCsl08.add((String)cslValue[0]);
                }
            }
            if (!ids.isEmpty()) {
                tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("insert into " + tmpTable + "(FID) values (?)"), ids);
                BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + cslDataTable + " where FUnionID = ? and FValue = 0 and exists (select FID from " + tmpTable + " where FID = " + cslDataTable + ".FID)"), (Object[])new Object[]{unionId});
                BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + cslDataEntry + " where exists (select FID from " + tmpTable + " where FID = " + cslDataEntry + ".FDataID)"));
                pool.releaseTable(tmpTable);
            }
            if (!clearCsl08.isEmpty()) {
                tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("insert into " + tmpTable + "(FID) values (?)"), clearCsl08);
                BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + cslDataTable + " where FUnionID = ? and FState = 1 and exists (select FID from " + tmpTable + " where FID = " + cslDataTable + ".FID)"), (Object[])new Object[]{unionId});
                BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + cslDataEntry + " where FFormId = ? and exists (select FID from " + tmpTable + " where FID = " + cslDataEntry + ".FDataID)"), (Object[])new Object[]{this.billID.toString()});
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"cslData executeBiz sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    logger.error((Object)"cslData executeBiz sql error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                if (tmpTable == null) throw throwable;
                pool.releaseTable(tmpTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (tmpTable == null) return;
        pool.releaseTable(tmpTable);
    }
}

