/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app.newUnion;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.app.IUnionVersionBizHandler;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTempNodeInfo;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateEntryCollection;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateEntryFactory;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateEntryInfo;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsInfo;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialRelationGroupInfo;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgExamineRefCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgNWorkViewDimensionInfo;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateInfo;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizRelyInfo;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgExamineSubsetInfo;
import com.kingdee.eas.ma.mbg.BgScopeInfo;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryCollection;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryFactory;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgUnionBeforeVersion
implements IUnionVersionBizHandler {
    private static Logger logger = Logger.getLogger((String)BgUnionBeforeVersion.class.getName());
    private static final String FUNIONID = "FUNIONID";
    private Map<String, String> workIdMap = new HashMap<String, String>();
    private Map<String, String> cslIdMap = new HashMap<String, String>();
    private Map<String, String> adjIdMap = new HashMap<String, String>();

    public Map onStartingUnion(Context ctx, String oldUnionID, String newUnionID, Timestamp date) throws Exception {
        OrgTreeInfo tree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectStringPK(newUnionID));
        if (!tree.isIsForBudget()) {
            return null;
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            Map<String, String> unionMap = this.getNewVersionOrgUnit(newUnionID, conn);
            Set<String> schemeIdSet = this.copySchemeData(oldUnionID, conn, newUnionID, userId);
            if (schemeIdSet == null || schemeIdSet.isEmpty()) {
                Map map = null;
                return map;
            }
            ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
            list.add(BOSUuid.read((String)newUnionID));
            new MbgVirtualView(ctx).checkUnionDebt(ctx, list);
            this.copyBgNWorkTemplate(oldUnionID, newUnionID, userId, conn, schemeIdSet, date);
            this.copyBgCslTemplate(oldUnionID, newUnionID, userId, conn, schemeIdSet, date);
            this.copyBgCslAdjTemplate(oldUnionID, newUnionID, userId, conn, unionMap, schemeIdSet, date);
            this.copyBgBizCalc(oldUnionID, newUnionID, userId, conn, schemeIdSet, unionMap, date);
            this.copyBgExamine(oldUnionID, newUnionID, userId, conn, schemeIdSet, unionMap, date);
            this.copyBgCslOffsetEntryTemplate(oldUnionID, newUnionID, userId, conn, unionMap, schemeIdSet, date, ctx);
            this.copyDimensionRelation(oldUnionID, newUnionID, userId, conn, schemeIdSet, date, ctx, unionMap);
        }
        catch (SQLException exc) {
            logger.error((Object)"sql error:", (Throwable)exc);
            throw exc;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return null;
    }

    private void copyDimensionRelation(String oldUnionID, final String newUnionID, final String userId, Connection conn, Set<String> schemeIdSet, final Timestamp date, Context ctx, Map<String, String> unionMap) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select dim.FID from T_MBG_DimensionRelationGroup dim where dim.FISCSL = 1 and dim.FOrgTreeId = ? and ").append(" not exists(select t.FNumber from T_MBG_DimensionRelationGroup t where dim.FNumber = t.FNumber ").append(" and t.FBGSCHEMEID = dim.FBGSCHEMEID and t.FOrgTreeId = ?) and dim.FBGSCHEMEID in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        final ArrayList relationGroupList = new ArrayList();
        final HashMap<String, String> groupIdMap = new HashMap<String, String>();
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{oldUnionID, newUnionID}, (Object[])schemeIdSet.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldRelationGroupId = res.getString("FID");
                String newRelationGroupId = BOSUuid.create((BOSObjectType)new DimensionRelationshipGroupInfo().getBOSType()).toString();
                if (oldRelationGroupId != null && !groupIdMap.containsKey(oldRelationGroupId)) {
                    groupIdMap.put(oldRelationGroupId, newRelationGroupId);
                }
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldRelationGroupId + "'");
                copyInfo.addReplace("FID", "'" + newRelationGroupId + "'");
                copyInfo.addReplace("FORGTREEID", "'" + newUnionID + "'");
                BgUnionBeforeVersion.this.replaceCreateInfo(userId, copyInfo, date);
                relationGroupList.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_DimensionRelationGroup", relationGroupList);
        if (groupIdMap != null && !groupIdMap.isEmpty()) {
            this.addDimensionRelationEntry(conn, groupIdMap, ctx);
            this.addDimensionRelationship(conn, groupIdMap, date, userId, unionMap, oldUnionID);
        }
    }

    private void addDimensionRelationship(Connection conn, final Map<String, String> groupIdMap, final Timestamp date, final String userId, final Map<String, String> newUnionMap, String oldUnionID) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FDIMENSIONGROUPID,FFILLTERUNITID from T_MBG_DimensionRelationship where FISENABLED  = 1 and FDIMENSIONGROUPID in ( ");
        final ArrayList relationshipList = new ArrayList();
        final Map<String, String> oldUnitMap = this.getNewVersionOrgUnit(oldUnionID, conn);
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(" )");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])groupIdMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldRelationshipId = res.getString("FID");
                String dimensionGroupId = res.getString("FDIMENSIONGROUPID");
                String oldUnitId = res.getString("FFILLTERUNITID");
                String newOrgUnitId = BgUnionBeforeVersion.this.getOrgUnitId(oldUnitMap, newUnionMap, oldUnitId);
                String newRelationshipId = BOSUuid.create((BOSObjectType)new DimensionRelationshipInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldRelationshipId + "'");
                copyInfo.addReplace("FID", "'" + newRelationshipId + "'");
                copyInfo.addReplace("FDIMENSIONGROUPID", "'" + (String)groupIdMap.get(dimensionGroupId) + "'");
                copyInfo.addReplace("FFILLTERUNITID", "'" + newOrgUnitId + "'");
                BgUnionBeforeVersion.this.replaceCreateInfo(userId, copyInfo, date);
                relationshipList.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_DimensionRelationship", relationshipList);
    }

    private void addDimensionRelationEntry(Connection conn, Map<String, String> groupIdMap, Context ctx) throws BOSException, SQLException {
        ArrayList<MbgUpdateDataBaseCopyInfo> DimRelaEntryList = new ArrayList<MbgUpdateDataBaseCopyInfo>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectColl = new SelectorItemCollection();
        selectColl.add(new SelectorItemInfo("id"));
        selectColl.add(new SelectorItemInfo("DimRelashipGroup"));
        view.setSelector(selectColl);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("DimRelashipGroup", new HashSet<String>(groupIdMap.keySet()), CompareType.INCLUDE));
        view.setFilter(filter);
        DimRelashipGroupEntryCollection dimRelashipColl = DimRelashipGroupEntryFactory.getLocalInstance((Context)ctx).getDimRelashipGroupEntryCollection(view);
        for (int i = 0; i < dimRelashipColl.size(); ++i) {
            DimRelashipGroupEntryInfo entryInfo = dimRelashipColl.get(i);
            String oldDimRelaEntryId = entryInfo.getId().toString();
            String groupId = entryInfo.getDimRelashipGroup().getId().toString();
            if (oldDimRelaEntryId == null) continue;
            String newDimRelaEntryId = BOSUuid.create((BOSObjectType)new DimRelashipGroupEntryInfo().getBOSType()).toString();
            MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
            copyInfo.setWhere("FID = '" + oldDimRelaEntryId + "'");
            copyInfo.addReplace("FID", "'" + newDimRelaEntryId + "'");
            copyInfo.addReplace("FDIMRELASHIPGROUPID", "'" + groupIdMap.get(groupId) + "'");
            DimRelaEntryList.add(copyInfo);
        }
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_DimRelashipGroupEntry", DimRelaEntryList);
    }

    private void copyBgCslOffsetEntryTemplate(String oldUnionID, final String newUnionID, final String userId, Connection conn, final Map<String, String> newUnitMap, Set<String> schemeIdSet, final Timestamp date, Context ctx) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select offse.FID,offse.FNUMBER,offse.FOrgUnitId from T_MBG_BgCsloffsetEntryTemplate offse inner join T_Org_BaseUnit unit ").append(" on offse.FOrgUnitId = unit.FID where offse.FTEMPLATESTATUS = ? AND offse.FORGTREEID = ? ").append(" and not exists ( select t.FNumber,baseUnit.FNUMBER from T_MBG_BgCslOffsetEntryTemplate t inner join T_Org_BaseUnit baseUnit on t.FOrgUnitId = baseUnit.FID where ").append(" t.FNumber = offse.FNUMBER and baseUnit.FNUMBER = unit.Fnumber and t.FBGSCHEMEID = offse.FBGSCHEMEID and t.FORGTREEID = ? ) and offse.FBGSCHEMEID in ( ");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        final Map<String, String> oldUnitMap = this.getNewVersionOrgUnit(oldUnionID, conn);
        final HashMap<String, String> offsetIdMap = new HashMap<String, String>();
        final ArrayList offsetTemplateList = new ArrayList();
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{0, oldUnionID, newUnionID}, (Object[])schemeIdSet.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldOffsetId = res.getString("FID");
                String oldUnitId = res.getString("FORGUNITID");
                String newOrgUnitId = BgUnionBeforeVersion.this.getOrgUnitId(oldUnitMap, newUnitMap, oldUnitId);
                String newOffsetId = BOSUuid.create((BOSObjectType)new BgCslOffsetEntryTemplateInfo().getBOSType()).toString();
                if (newOrgUnitId == null) {
                    return;
                }
                if (oldOffsetId != null && !offsetIdMap.containsKey(oldOffsetId)) {
                    offsetIdMap.put(oldOffsetId, newOffsetId);
                }
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldOffsetId + "'");
                copyInfo.addReplace("FID", "'" + newOffsetId + "'");
                copyInfo.addReplace("FORGTREEID", "'" + newUnionID + "'");
                copyInfo.addReplace("FORGUNITID", "'" + newOrgUnitId + "'");
                BgUnionBeforeVersion.this.replaceCreateInfo(userId, copyInfo, date);
                offsetTemplateList.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgCslOffsetEntryTemplate", offsetTemplateList);
        if (offsetIdMap != null && !offsetIdMap.isEmpty()) {
            this.dealBgCslOffsetTemplateRootId(offsetIdMap, conn);
            this.addBgCslOffsetEntryTemplateEntry(offsetIdMap, conn, ctx);
        }
    }

    private void dealBgCslOffsetTemplateRootId(Map<String, String> offsetIdMap, Connection conn) throws BOSException, SQLException {
        StringBuffer buff = new StringBuffer();
        final HashMap rootIdRef = new HashMap();
        ArrayList<String[]> updateRootList = new ArrayList<String[]>();
        buff.append("select FID,FROOTID from T_MBG_BgCslOffsetEntryTemplate where FID in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)buff).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)buff.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])offsetIdMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                rootIdRef.put(res.getString("FID"), res.getString("FROOTID"));
            }
        });
        for (Map.Entry entry : rootIdRef.entrySet()) {
            String id = (String)entry.getKey();
            String rootId = (String)entry.getValue();
            String newId = offsetIdMap.get(id);
            String newRootId = offsetIdMap.get(rootId);
            updateRootList.add(new String[]{newRootId, newId});
        }
        String sql = "update T_MBG_BgCslOffsetEntryTemplate set FROOTID = ? where FID = ?";
        BgDBUtils.executeBatch((Connection)conn, (String)sql, updateRootList);
    }

    private void addBgCslOffsetEntryTemplateEntry(Map<String, String> offsetIdMap, Connection conn, Context ctx) throws BOSException, SQLException {
        ArrayList<MbgUpdateDataBaseCopyInfo> offsetEntryList = new ArrayList<MbgUpdateDataBaseCopyInfo>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectColl = new SelectorItemCollection();
        selectColl.add(new SelectorItemInfo("id"));
        selectColl.add(new SelectorItemInfo("parent"));
        view.setSelector(selectColl);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", new HashSet<String>(offsetIdMap.keySet()), CompareType.INCLUDE));
        view.setFilter(filter);
        BgCslOffsetEntryTemplateEntryCollection offsetEntryColl = BgCslOffsetEntryTemplateEntryFactory.getLocalInstance(ctx).getBgCslOffsetEntryTemplateEntryCollection(view);
        for (int i = 0; i < offsetEntryColl.size(); ++i) {
            BgCslOffsetEntryTemplateEntryInfo entryInfo = offsetEntryColl.get(i);
            String offsetEntryId = entryInfo.getId().toString();
            String parentId = entryInfo.getParent().getId().toString();
            if (offsetEntryId == null) continue;
            String newOffsetEntryId = BOSUuid.create((BOSObjectType)new BgCslOffsetEntryTemplateEntryInfo().getBOSType()).toString();
            MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
            copyInfo.setWhere("FID = '" + offsetEntryId + "'");
            copyInfo.addReplace("FID", "'" + newOffsetEntryId + "'");
            copyInfo.addReplace("FPARENTID", "'" + offsetIdMap.get(parentId) + "'");
            offsetEntryList.add(copyInfo);
        }
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgCslOffsetEntTempEntry", offsetEntryList);
    }

    private void copyBgCslAdjTemplate(String oldUnionID, final String newUnionID, final String userId, Connection conn, final Map<String, String> newUnitMap, Set<String> schemeIdSet, final Timestamp date) throws SQLException, BOSException {
        final ArrayList adjTemplateList = new ArrayList();
        final Map<String, String> oldUnitMap = this.getNewVersionOrgUnit(oldUnionID, conn);
        StringBuffer sql = new StringBuffer();
        sql.append(" select adj.FID,adj.FNUMBER,adj.FOrgUnitID,adj.FRootId from T_MBG_BgCslAdjTemplate adj inner join T_Org_BaseUnit unit on adj.FOrgUnitId = unit.FID ").append(" WHERE adj.FTemplateStatus = ? AND adj.FORGTREEID = ? ").append(" AND not exists (select t.FNumber,baseUnit.FNUMBER from T_MBG_BgCslAdjTemplate t inner join T_Org_BaseUnit baseUnit on t.FOrgUnitId = baseUnit.FID ").append(" where t.FBGSCHEMEID = adj.FBGSCHEMEID and t.FNumber = adj.FNumber and baseUnit.FNUMBER = unit.Fnumber ").append(" and t.FORGTREEID = ? ) and adj.FBGSCHEMEID in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")").append(" order by unit.FLevel");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{0, oldUnionID, newUnionID}, (Object[])schemeIdSet.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldAdjId = res.getString("FID");
                String oldRootAdjId = res.getString("FRootID");
                String oldUnitId = res.getString("FOrgUnitID");
                String newAdjId = BOSUuid.create((BOSObjectType)new BgCslAdjTemplateInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                String newOrgUnitId = BgUnionBeforeVersion.this.getOrgUnitId(oldUnitMap, newUnitMap, oldUnitId);
                if (newOrgUnitId == null) {
                    return;
                }
                if (oldAdjId != null && !BgUnionBeforeVersion.this.adjIdMap.containsKey(oldAdjId)) {
                    BgUnionBeforeVersion.this.adjIdMap.put(oldAdjId, newAdjId);
                }
                copyInfo.setWhere("FID = '" + oldAdjId + "'");
                copyInfo.addReplace("FID", "'" + newAdjId + "'");
                copyInfo.addReplace("FORGTREEID", "'" + newUnionID + "'");
                copyInfo.addReplace("FORGUNITID", "'" + newOrgUnitId + "'");
                copyInfo.addReplace("FRootID", "'" + (String)BgUnionBeforeVersion.this.adjIdMap.get(oldRootAdjId) + "'");
                BgUnionBeforeVersion.this.replaceCreateInfo(userId, copyInfo, date);
                adjTemplateList.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgCslAdjTemplate", adjTemplateList);
        if (this.adjIdMap != null && !this.adjIdMap.isEmpty()) {
            this.addAdjTempldateMeasureUnit(conn);
            Map<String, String> specialMap = this.addAdjSpecialItem(conn, userId, date);
            this.addAdjNodes(conn, oldUnitMap, newUnitMap);
            if (specialMap != null && specialMap.size() > 0) {
                this.addSpecialRelationGroup(conn, specialMap);
            }
        }
    }

    protected String getOrgUnitId(Map<String, String> oldUnitMap, Map<String, String> newUnitMap, String oldUnitId) {
        String oldUnitNumber;
        if (oldUnitId != null && oldUnitId.length() > 0 && (oldUnitNumber = oldUnitMap.get(oldUnitId)) != null) {
            for (Map.Entry<String, String> entry : newUnitMap.entrySet()) {
                String newUnitId = entry.getKey();
                String newUnitNumber = entry.getValue();
                if (!oldUnitNumber.equals(newUnitNumber)) continue;
                return newUnitId;
            }
        }
        return null;
    }

    private void addAdjNodes(Connection cn, final Map<String, String> oldUnitMap, final Map<String, String> newUnitMap) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FBgTemplateID,FORGUNITID from T_MBG_BgCslAdjTempNode where FBgTemplateID in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        final ArrayList list = new ArrayList();
        MbgSqlHelper.executeBatchQuery((Connection)cn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])this.adjIdMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldId = res.getString("FID");
                String bgAdjTemplateId = res.getString("FBgTemplateID");
                String oldUnitId = res.getString("FORGUNITID");
                String newOrgUnitId = BgUnionBeforeVersion.this.getOrgUnitId(oldUnitMap, newUnitMap, oldUnitId);
                if (newOrgUnitId == null) {
                    return;
                }
                String newNodeId = BOSUuid.create((BOSObjectType)new BgCslAdjTempNodeInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldId + "'");
                copyInfo.addReplace("FID", "'" + newNodeId + "'");
                copyInfo.addReplace("FBgTemplateID", "'" + (String)BgUnionBeforeVersion.this.adjIdMap.get(bgAdjTemplateId) + "'");
                copyInfo.addReplace("FORGUNITID", "'" + newOrgUnitId + "'");
                list.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)cn, (String)"T_MBG_BgCslAdjTempNode", list);
    }

    private Map<String, String> addAdjSpecialItem(Connection conn, final String userId, final Timestamp date) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FBGADJTEMPLATEID from T_MBG_BgCslSpecialItems where FBGADJTEMPLATEID in ( ");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        final ArrayList list = new ArrayList();
        final HashMap<String, String> specialMap = new HashMap<String, String>();
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])this.adjIdMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldSpecialId = res.getString("FID");
                String bgAdjTemplateId = res.getString("FBGADJTEMPLATEID");
                String newSpecialId = BOSUuid.create((BOSObjectType)new BgCslSpecialItemsInfo().getBOSType()).toString();
                if (null != oldSpecialId && !specialMap.containsKey(oldSpecialId)) {
                    specialMap.put(oldSpecialId, newSpecialId);
                }
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldSpecialId + "'");
                copyInfo.addReplace("FID", "'" + newSpecialId + "'");
                copyInfo.addReplace("FBGADJTEMPLATEID", "'" + (String)BgUnionBeforeVersion.this.adjIdMap.get(bgAdjTemplateId) + "'");
                BgUnionBeforeVersion.this.replaceCreateInfo(userId, copyInfo, date);
                list.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgCslSpecialItems", list);
        return specialMap;
    }

    private void addAdjTempldateMeasureUnit(Connection conn) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FID,FBgCslTemplateID from T_MBG_BgCslAdjTemMsUnit where FBgCslTemplateID in (");
        final ArrayList adjMeasureUnitList = new ArrayList();
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])this.adjIdMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldMeasureUnitId = res.getString("FID");
                String bgCslTemplateID = res.getString("FBGCSLTEMPLATEID");
                String newMeasureUnitId = BOSUuid.create((BOSObjectType)new BgCslAdjTemplateInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldMeasureUnitId + "'");
                copyInfo.addReplace("FID", "'" + newMeasureUnitId + "'");
                copyInfo.addReplace("FBGCSLTEMPLATEID", "'" + (String)BgUnionBeforeVersion.this.adjIdMap.get(bgCslTemplateID) + "'");
                adjMeasureUnitList.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgCslAdjTemMsUnit", adjMeasureUnitList);
    }

    private void copyBgExamine(String oldUnionID, final String newUnionID, final String userId, Connection conn, Set<String> schemeIdSet, Map<String, String> unionMap, final Timestamp date) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        final ArrayList list = new ArrayList();
        final HashMap<String, String> bgExamineMap = new HashMap<String, String>();
        sql.append("select exam.FID from T_MBG_BgExamine exam where exam.FSTATE = ? and exam.FORGTREEID = ? and ").append(" not exists(select t.FNumber from T_MBG_BgExamine t where t.FNumber = exam.FNumber and exam.FBGSCHEMEID = t.FBGSCHEMEID ").append(" and t.FORGTREEID = ?) and exam.FBGSCHEMEID in(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{1, oldUnionID, newUnionID}, (Object[])schemeIdSet.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                String oldBgExamineId = res.getString("FID");
                String newBgExamineId = BOSUuid.create((BOSObjectType)new BizCalcInfo().getBOSType()).toString();
                if (null != oldBgExamineId && !bgExamineMap.containsKey(oldBgExamineId)) {
                    bgExamineMap.put(oldBgExamineId, newBgExamineId);
                }
                copyInfo.setWhere("FID = '" + oldBgExamineId + "'");
                copyInfo.addReplace("FID", "'" + newBgExamineId + "'");
                copyInfo.addReplace("FORGTREEID", "'" + newUnionID + "'");
                copyInfo.addReplace("FState", "'2'");
                BgUnionBeforeVersion.this.replaceCreateInfo(userId, copyInfo, date);
                list.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgExamine", list);
        if (bgExamineMap != null && bgExamineMap.size() > 0) {
            this.addBgExamineRefTemplate(conn, bgExamineMap, newUnionID, oldUnionID, unionMap);
            Map<String, String> ExamineSubSet = this.addBgExamineSubSet(conn, bgExamineMap, unionMap);
            if (ExamineSubSet != null && ExamineSubSet.size() > 0) {
                this.addBgScopeSub(conn, ExamineSubSet, unionMap);
            }
        }
    }

    private void addBgExamineRefTemplate(final Connection conn, final Map<String, String> bgExamineMap, final String newUnionID, final String oldUnionID, final Map<String, String> newUnionMap) throws BOSException, SQLException {
        final ArrayList list = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FBgExamineID,FTemplateID,FType from T_MBG_BgExamineRefCslTemplate where FBGEXAMINEID in ( ");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])bgExamineMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldRefId = res.getString("FID");
                String bgExamineId = res.getString("FBGEXAMINEID");
                String templateId = res.getString("FTEMPLATEID");
                int type = res.getInt("FTYPE");
                String newRefId = BOSUuid.create((BOSObjectType)new BgExamineRefCslTemplateInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldRefId + "'");
                copyInfo.addReplace("FID", "'" + newRefId + "'");
                copyInfo.addReplace("FBGEXAMINEID", "'" + (String)bgExamineMap.get(bgExamineId) + "'");
                switch (type) {
                    case 1: {
                        if (BgUnionBeforeVersion.this.workIdMap == null || BgUnionBeforeVersion.this.workIdMap.isEmpty()) {
                            String newTemplateId = BgUnionBeforeVersion.this.getNewTemplateId(conn, newUnionID, templateId, "T_MBG_BgNWorkTemplate", newUnionMap, oldUnionID);
                            copyInfo.addReplace("FTEMPLATEID", "'" + newTemplateId + "'");
                            break;
                        }
                        copyInfo.addReplace("FTEMPLATEID", "'" + (String)BgUnionBeforeVersion.this.workIdMap.get(templateId) + "'");
                        break;
                    }
                    case 2: {
                        if (BgUnionBeforeVersion.this.cslIdMap == null || BgUnionBeforeVersion.this.cslIdMap.isEmpty()) {
                            String newTemplateId = BgUnionBeforeVersion.this.getNewTemplateId(conn, newUnionID, templateId, "T_MBG_BgCslTemplate", newUnionMap, oldUnionID);
                            copyInfo.addReplace("FTEMPLATEID", "'" + newTemplateId + "'");
                            break;
                        }
                        copyInfo.addReplace("FTEMPLATEID", "'" + (String)BgUnionBeforeVersion.this.cslIdMap.get(templateId) + "'");
                        break;
                    }
                    case 3: {
                        if (BgUnionBeforeVersion.this.adjIdMap == null || BgUnionBeforeVersion.this.adjIdMap.isEmpty()) {
                            String newTemplateId = BgUnionBeforeVersion.this.getNewTemplateId(conn, newUnionID, templateId, "T_MBG_BgCslAdjTemplate", newUnionMap, oldUnionID);
                            copyInfo.addReplace("FTEMPLATEID", "'" + newTemplateId + "'");
                            break;
                        }
                        copyInfo.addReplace("FTEMPLATEID", "'" + (String)BgUnionBeforeVersion.this.adjIdMap.get(templateId) + "'");
                        break;
                    }
                }
                list.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgExamineRefCslTemplate", list);
    }

    private void addBgScopeSub(Connection conn, final Map<String, String> examineSubSet, final Map<String, String> unionMap) throws SQLException, BOSException {
        final ArrayList list = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append(" select FID,FBGMEMBERNUM,FBGMEMBERTYPE,FBGEXAMINESUBSETID from T_MBG_Bgscope where FBGEXAMINESUBSETID in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])examineSubSet.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldBgScope = res.getString("FID");
                String bgMemberNum = res.getString("FBGMEMBERNUM");
                int bgMemberType = res.getInt("FBGMEMBERTYPE");
                String bgExamineSubsetId = res.getString("FBGEXAMINESUBSETID");
                Collection unionColl = unionMap.values();
                if (unionColl != null && !unionColl.contains(bgMemberNum) && BizConstants.BIZ_BGORGUNIT_TYPE_VALUE == bgMemberType) {
                    return;
                }
                String newBgScope = BOSUuid.create((BOSObjectType)new BgScopeInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldBgScope + "'");
                copyInfo.addReplace("FID", "'" + newBgScope + "'");
                copyInfo.addReplace("FBGEXAMINESUBSETID", "'" + (String)examineSubSet.get(bgExamineSubsetId) + "'");
                list.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_Bgscope", list);
    }

    private Map<String, String> addBgExamineSubSet(Connection conn, final Map<String, String> bgExamineMap, Map<String, String> unionMap) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        final HashMap<String, String> map = new HashMap<String, String>();
        final ArrayList list = new ArrayList();
        sql.append("select FID,FBGEXAMINEID from T_MBG_BgExamineSubset where FBGEXAMINEID in(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])bgExamineMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldExamSubsetId = res.getString("FID");
                String bgExamineId = res.getString("FBGEXAMINEID");
                String newExamSubsetId = BOSUuid.create((BOSObjectType)new BgExamineSubsetInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                if (null != oldExamSubsetId && !map.containsKey(oldExamSubsetId)) {
                    map.put(oldExamSubsetId, newExamSubsetId);
                }
                copyInfo.setWhere("FID = '" + oldExamSubsetId + "'");
                copyInfo.addReplace("FID", "'" + newExamSubsetId + "'");
                copyInfo.addReplace("FBGEXAMINEID", "'" + (String)bgExamineMap.get(bgExamineId) + "'");
                list.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgExamineSubset", list);
        return map;
    }

    private void copyBgBizCalc(String oldUnionID, final String newUnionID, final String userId, Connection conn, Set<String> schemeIdSet, Map<String, String> unionMap, final Timestamp date) throws SQLException, BOSException {
        final HashMap<String, String> bgCslMap = new HashMap<String, String>();
        final ArrayList list = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append("select calc.FID,calc.FNumber from T_MBG_BizCalc calc where calc.FSTATE = ? and calc.FORGTREEID = ? ").append(" and not exists(select t.FNumber from T_MBG_BizCalc t where t.FOrgTreeId = ? and t.FNumber = calc.FNumber and calc.FBgSchemeId = t.FBgSchemeId) ").append(" and calc.FBgSchemeId in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{2, oldUnionID, newUnionID}, (Object[])schemeIdSet.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldBgCslId = res.getString("FID");
                String newBgCslId = BOSUuid.create((BOSObjectType)new BizCalcInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo bgCslCopyInfo = new MbgUpdateDataBaseCopyInfo();
                bgCslCopyInfo.setWhere("FID = '" + oldBgCslId + "'");
                bgCslCopyInfo.addReplace("FID", "'" + newBgCslId + "'");
                bgCslCopyInfo.addReplace("FSTATE", "'3'");
                if (oldBgCslId != null && !bgCslMap.containsKey(oldBgCslId)) {
                    bgCslMap.put(oldBgCslId, newBgCslId);
                }
                bgCslCopyInfo.addReplace("FORGTREEID", "'" + newUnionID + "'");
                BgUnionBeforeVersion.this.replaceCreateInfo(userId, bgCslCopyInfo, date);
                list.add(bgCslCopyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BizCalc", list);
        if (bgCslMap != null && !bgCslMap.isEmpty()) {
            this.addBizCslRefTemplate(conn, bgCslMap, newUnionID, oldUnionID, unionMap);
            this.addBgBizRely(conn, bgCslMap);
            Map<String, String> CalcSubset = this.addBizCalcSubset(conn, bgCslMap);
            if (CalcSubset != null && CalcSubset.size() > 0) {
                this.addBizScope(conn, CalcSubset, unionMap);
            }
        }
    }

    private void addBizCslRefTemplate(final Connection conn, final Map<String, String> bgCslMap, final String newUnionID, final String oldUnionID, final Map<String, String> newUnionMap) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FBIZCALCID,FTemplateID,FType from T_MBG_BizRefCslTemplate where FBIZCALCID in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(" )");
        final ArrayList list = new ArrayList();
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])bgCslMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldRefId = res.getString("FID");
                String bizCalcId = res.getString("FBIZCALCID");
                String templateId = res.getString("FTEMPLATEID");
                int type = res.getInt("FTYPE");
                String newRefId = BOSUuid.create((BOSObjectType)new BizRefCslTemplateInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldRefId + "'");
                copyInfo.addReplace("FID", "'" + newRefId + "'");
                copyInfo.addReplace("FBIZCALCID", "'" + (String)bgCslMap.get(bizCalcId) + "'");
                switch (type) {
                    case 1: {
                        if (BgUnionBeforeVersion.this.workIdMap == null || BgUnionBeforeVersion.this.workIdMap.isEmpty()) {
                            String newTemplateId = BgUnionBeforeVersion.this.getNewTemplateId(conn, newUnionID, templateId, "T_MBG_BgNWorkTemplate", newUnionMap, oldUnionID);
                            copyInfo.addReplace("FTEMPLATEID", "'" + newTemplateId + "'");
                            break;
                        }
                        copyInfo.addReplace("FTEMPLATEID", "'" + (String)BgUnionBeforeVersion.this.workIdMap.get(templateId) + "'");
                        break;
                    }
                    case 2: {
                        if (BgUnionBeforeVersion.this.cslIdMap == null || BgUnionBeforeVersion.this.cslIdMap.isEmpty()) {
                            String newTemplateId = BgUnionBeforeVersion.this.getNewTemplateId(conn, newUnionID, templateId, "T_MBG_BgCslTemplate", newUnionMap, oldUnionID);
                            copyInfo.addReplace("FTEMPLATEID", "'" + newTemplateId + "'");
                            break;
                        }
                        copyInfo.addReplace("FTEMPLATEID", "'" + (String)BgUnionBeforeVersion.this.cslIdMap.get(templateId) + "'");
                        break;
                    }
                    case 3: {
                        if (BgUnionBeforeVersion.this.adjIdMap == null || BgUnionBeforeVersion.this.adjIdMap.isEmpty()) {
                            String newTemplateId = BgUnionBeforeVersion.this.getNewTemplateId(conn, newUnionID, templateId, "T_MBG_BgCslAdjTemplate", newUnionMap, oldUnionID);
                            copyInfo.addReplace("FTEMPLATEID", "'" + newTemplateId + "'");
                            break;
                        }
                        copyInfo.addReplace("FTEMPLATEID", "'" + (String)BgUnionBeforeVersion.this.adjIdMap.get(templateId) + "'");
                        break;
                    }
                }
                list.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BizRefCslTemplate", list);
    }

    private final Map<String, String> getNewVersionOrgUnit(String newUnionID, Connection conn) throws SQLException {
        HashMap<String, String> unionMap = new HashMap<String, String>();
        String sql = "select unit.FNUMBER,unit.FID from T_ORG_Structure struct left join T_ORG_Tree tree on struct.FTREEID = tree.FID left join T_ORG_BaseUnit unit on struct.FUNITID = unit.FID where tree.FID = ? and unit.FISGROUPING = '1'";
        try {
            IRowSet executeQuery = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{newUnionID});
            while (executeQuery.next()) {
                String unitId = executeQuery.getString("FID");
                String unitNumber = executeQuery.getString("FNUMBER");
                if (unitNumber == null || unitNumber.length() <= 0) continue;
                unionMap.put(unitId, unitNumber);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"sql error ", (Throwable)e);
            throw e;
        }
        return unionMap;
    }

    private void addBizScope(Connection conn, final Map<String, String> calcSubset, final Map<String, String> unionMap) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        final ArrayList list = new ArrayList();
        sql.append("select FID,FBGMEMBERNUM,FBGMEMBERTYPE,FBIZCALCSUBSETID from T_MBG_BizScope where FBIZCALCSUBSETID in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])calcSubset.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldBizScope = res.getString("FID");
                String bgMemberNum = res.getString("FBGMEMBERNUM");
                int bgMemberType = res.getInt("FBGMEMBERTYPE");
                String bizCalcSubsetId = res.getString("FBIZCALCSUBSETID");
                Collection unionColl = unionMap.values();
                if (unionColl != null && !unionColl.contains(bgMemberNum) && BizConstants.BIZ_BGORGUNIT_TYPE_VALUE == bgMemberType) {
                    return;
                }
                String newBizScope = BOSUuid.create((BOSObjectType)new BizScopeInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldBizScope + "'");
                copyInfo.addReplace("FID", "'" + newBizScope + "'");
                copyInfo.addReplace("FBIZCALCSUBSETID", "'" + (String)calcSubset.get(bizCalcSubsetId) + "'");
                list.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BizScope", list);
    }

    private Map<String, String> addBizCalcSubset(Connection conn, final Map<String, String> bgCslMap) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        final HashMap<String, String> map = new HashMap<String, String>();
        final ArrayList list = new ArrayList();
        sql.append("select t.FID,t.FBIZCALCID from T_MBG_BizCalcSubset t where t.FBIZCALCID in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])bgCslMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldSubsetId = res.getString("FID");
                String bizCalcId = res.getString("FBIZCALCID");
                if (oldSubsetId != null && oldSubsetId.length() > 0) {
                    MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                    String newCSubsetId = BOSUuid.create((BOSObjectType)new BizCalcSubsetInfo().getBOSType()).toString();
                    if (null != oldSubsetId && !map.containsKey(oldSubsetId)) {
                        map.put(oldSubsetId, newCSubsetId);
                    }
                    copyInfo.setWhere("FID = '" + oldSubsetId + "'");
                    copyInfo.addReplace("FID", "'" + newCSubsetId + "'");
                    copyInfo.addReplace("FBIZCALCID", "'" + (String)bgCslMap.get(bizCalcId) + "'");
                    list.add(copyInfo);
                }
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BizCalcSubset", list);
        return map;
    }

    private void addBgBizRely(Connection conn, final Map<String, String> bgCslMap) throws SQLException, BOSException {
        final ArrayList list = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FRELYBIZID,FBIZCALCID from T_MBG_BizRely where FBIZCALCID in(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])bgCslMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldRelyId = res.getString("FID");
                String relyBizId = res.getString("FRELYBIZID");
                String bizCalcId = res.getString("FBIZCALCID");
                if (oldRelyId != null && oldRelyId.length() > 0) {
                    MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                    String newRely = BOSUuid.create((BOSObjectType)new BizRelyInfo().getBOSType()).toString();
                    copyInfo.setWhere("FID = '" + oldRelyId + "'");
                    copyInfo.addReplace("FID", "'" + newRely + "'");
                    copyInfo.addReplace("FBIZCALCID", "'" + (String)bgCslMap.get(bizCalcId) + "'");
                    copyInfo.addReplace("FRELYBIZID", "'" + (String)bgCslMap.get(relyBizId) + "'");
                    list.add(copyInfo);
                }
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BizRely", list);
    }

    private void copyBgNWorkTemplate(String oldUnionID, final String newUnionID, final String userId, Connection conn, Set<String> schemeIdSet, final Timestamp date) throws SQLException, BOSException {
        final ArrayList cslTemplateList = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append("select workTemplate.FID from T_MBG_BgNWorkTemplate workTemplate ").append(" where workTemplate.FTEMPLATESTATUS = 0 and workTemplate.FORGTREEID = ?").append(" and not exists(select FNumber from T_MBG_BgNWorkTemplate t where t.FOrgtreeId = ? ").append(" and t.FNumber = workTemplate.FNumber and t.FBgSchemeId = workTemplate.FBgSchemeId)").append(" and workTemplate.FBgSchemeId in(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{oldUnionID, newUnionID}, (Object[])schemeIdSet.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldWorkId = res.getString("FID");
                String newWorkId = BOSUuid.create((BOSObjectType)new BgNWorkTemplateInfo().getBOSType()).toString();
                BgUnionBeforeVersion.this.workIdMap.put(oldWorkId, newWorkId);
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldWorkId + "'");
                copyInfo.addReplace("FID", "'" + newWorkId + "'");
                copyInfo.addReplace("FOrgTreeId", "'" + newUnionID + "'");
                BgUnionBeforeVersion.this.replaceCreateInfo(userId, copyInfo, date);
                cslTemplateList.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgNWorkTemplate", cslTemplateList);
        if (this.workIdMap != null && !this.workIdMap.isEmpty()) {
            this.addBgNWorkViewDimension(conn);
        }
    }

    private void addBgNWorkViewDimension(Connection conn) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FTemplateID from T_MBG_BgNWorkViewDimension where FTemplateID in ( ");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(" )");
        final ArrayList list = new ArrayList();
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])this.workIdMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldWorkDimId = res.getString("FID");
                String templateId = res.getString("FTEMPLATEID");
                String newWorkDimId = BOSUuid.create((BOSObjectType)new BgNWorkViewDimensionInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID= '" + oldWorkDimId + "'");
                copyInfo.addReplace("FID", "'" + newWorkDimId + "'");
                copyInfo.addReplace("FTEMPLATEID", "'" + (String)BgUnionBeforeVersion.this.workIdMap.get(templateId) + "'");
                list.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgNWorkViewDimension", list);
    }

    private void copyBgCslTemplate(String oldUnionID, final String newUnionID, final String userId, Connection conn, Set<String> schemeIdSet, final Timestamp date) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select clsTemplate.FID from T_MBG_BgCslTemplate clsTemplate where clsTemplate.FTEMPLATESTATUS  = 0 ").append(" and clsTemplate.FORGTREEID = ? and not exists ( select t.FNumber from T_MBG_BgCslTemplate t where t.FNumber = clsTemplate.FNumber ").append(" and t.FBGSCHEMEID = clsTemplate.FBGSCHEMEID and t.FORGTREEID = ? ) and clsTemplate.FBGSCHEMEID in ( ");
        final ArrayList cslTemplateList = new ArrayList();
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{oldUnionID, newUnionID}, (Object[])schemeIdSet.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                String oldCslId = res.getString("FID");
                String newCslId = BOSUuid.create((BOSObjectType)new BgCslTemplateInfo().getBOSType()).toString();
                if (null != oldCslId && !BgUnionBeforeVersion.this.cslIdMap.containsKey(oldCslId)) {
                    BgUnionBeforeVersion.this.cslIdMap.put(oldCslId, newCslId);
                }
                copyInfo.setWhere("FID = '" + oldCslId + "'");
                copyInfo.addReplace("FID", "'" + newCslId + "'");
                copyInfo.addReplace("FOrgTreeId", "'" + newUnionID + "'");
                BgUnionBeforeVersion.this.replaceCreateInfo(userId, copyInfo, date);
                cslTemplateList.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgCslTemplate", cslTemplateList);
        if (this.cslIdMap != null && this.cslIdMap.size() > 0) {
            this.addBgCslTempldateMeasureUnit(conn);
            Map<String, String> specialMap = this.addBgCslSpecialItem(conn, userId, date);
            if (specialMap != null && specialMap.size() > 0) {
                this.addSpecialRelationGroup(conn, specialMap);
            }
        }
    }

    private void addSpecialRelationGroup(Connection conn, final Map<String, String> specialMap) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FBgSpecialItemsID from T_MBG_BgCslSpcRela where FBgSpecialItemsID in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(" )");
        final ArrayList list = new ArrayList();
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])specialMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldRelationId = res.getString("FID");
                String bgSpecialItemsID = res.getString("FBgSpecialItemsID");
                String newRelationId = BOSUuid.create((BOSObjectType)new BgCslSpecialRelationGroupInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldRelationId + "'");
                copyInfo.addReplace("FID", "'" + newRelationId + "'");
                copyInfo.addReplace("FBGSPECIALITEMSID", "'" + (String)specialMap.get(bgSpecialItemsID) + "'");
                list.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgCslSpcRela", list);
    }

    private Map<String, String> addBgCslSpecialItem(Connection conn, final String userId, final Timestamp date) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FBGTEMPLATEID from T_MBG_BgCslSpecialItems where FBGTEMPLATEID in ( ");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        final ArrayList list = new ArrayList();
        final HashMap<String, String> specialMap = new HashMap<String, String>();
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])this.cslIdMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldSpecialId = res.getString("FID");
                String bgTemplateId = res.getString("FBGTEMPLATEID");
                String newSpecialId = BOSUuid.create((BOSObjectType)new BgCslSpecialItemsInfo().getBOSType()).toString();
                if (null != oldSpecialId && !specialMap.containsKey(oldSpecialId)) {
                    specialMap.put(oldSpecialId, newSpecialId);
                }
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldSpecialId + "'");
                copyInfo.addReplace("FID", "'" + newSpecialId + "'");
                copyInfo.addReplace("FBGTEMPLATEID", "'" + (String)BgUnionBeforeVersion.this.cslIdMap.get(bgTemplateId) + "'");
                BgUnionBeforeVersion.this.replaceCreateInfo(userId, copyInfo, date);
                list.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgCslSpecialItems", list);
        return specialMap;
    }

    private void addBgCslTempldateMeasureUnit(Connection conn) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FID,FBgCslTemplateID from T_MBG_BgCslTemMeasureUnit where FBgCslTemplateID in (");
        final ArrayList adjMeasureUnitList = new ArrayList();
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])this.cslIdMap.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String oldMeasureUnitId = res.getString("FID");
                String bgCslTemplateID = res.getString("FBGCSLTEMPLATEID");
                String newMeasureUnitId = BOSUuid.create((BOSObjectType)new BgCslAdjTemplateInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = '" + oldMeasureUnitId + "'");
                copyInfo.addReplace("FID", "'" + newMeasureUnitId + "'");
                copyInfo.addReplace("FBGCSLTEMPLATEID", "'" + (String)BgUnionBeforeVersion.this.cslIdMap.get(bgCslTemplateID) + "'");
                adjMeasureUnitList.add(copyInfo);
            }
        });
        MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgCslTemMeasureUnit", adjMeasureUnitList);
    }

    private Set<String> copySchemeData(String id, Connection conn, String newUnionID, String userId) throws SQLException, BOSException {
        HashSet<String> schemeSet = new HashSet<String>();
        ArrayList<MbgUpdateDataBaseCopyInfo> copyMemderList = new ArrayList<MbgUpdateDataBaseCopyInfo>();
        StringBuffer buff = new StringBuffer();
        buff.append("select member.FID,dimSettings.FBGSCHEMEID,member.FBGDIMSETTINGSID from t_mbg_bgscheme AS bgscheme ").append("inner join T_MBG_BgDimSettings AS dimSettings on bgscheme.FID  = dimSettings.FBGSCHEMEID and bgscheme.FISFILING = 0").append("inner join T_MBG_BgDimSettingsMember AS member on dimSettings.FID  = member.FBGDIMSETTINGSID ").append(" and member.FMEMBERID  = ?");
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FID from T_MBG_BgDimSettingsMember where FMEMBERID = ?");
        try {
            IRowSet schemeResult = BgDBUtils.executeQuery((Connection)conn, (String)buff.toString(), (Object[])new Object[]{id});
            IRowSet executeQuery = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{newUnionID});
            while (schemeResult.next()) {
                String memberId = schemeResult.getString("FID");
                String SchemeId = schemeResult.getString("FBGSCHEMEID");
                if (null != SchemeId) {
                    schemeSet.add(SchemeId);
                }
                if (executeQuery.size() > 0) continue;
                String newMemberId = BOSUuid.create((BOSObjectType)new BgDimSettingsMemberInfo().getBOSType()).toString();
                MbgUpdateDataBaseCopyInfo memberInfo = new MbgUpdateDataBaseCopyInfo();
                memberInfo.setWhere("FID = '" + memberId + "'");
                memberInfo.addReplace("FID", "'" + newMemberId + "'");
                memberInfo.addReplace("FMemberID", "'" + newUnionID + "'");
                copyMemderList.add(memberInfo);
            }
            MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgDimSettingsMember", copyMemderList);
        }
        catch (SQLException exc) {
            logger.error((Object)"sql error:", (Throwable)exc);
            throw exc;
        }
        return schemeSet;
    }

    protected void replaceCreateInfo(String userId, MbgUpdateDataBaseCopyInfo copyInfo, Timestamp stamp) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(new Date(System.currentTimeMillis()));
        copyInfo.addReplace("FCreatorID", "'" + userId + "'");
        copyInfo.addReplace("FLastUpdateUserID", "'" + userId + "'");
        copyInfo.addReplace("FCreateTime", "{ts'" + date + "'}");
        copyInfo.addReplace("FLastUpdateTime", "{ts'" + date + "'}");
    }

    public Map onUnstartingUnion(Context ctx, String unionID) throws Exception {
        return null;
    }

    public void onCreatingNewUnion(Context ctx, String oldUnionID) throws Exception {
        OrgTreeInfo tree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectStringPK(oldUnionID));
        if (!tree.isIsForBudget()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select W.FRefCube from t_mbg_bgscheme W inner join T_MBG_BgDimSettings K on W.FID = K.FBGSCHEMEID ").append(" inner join T_MBG_BgDimSettingsMember T on K.FID = T.FBGDIMSETTINGSID where T.FMEMBERID  = ?");
        IRowSet refCubeQuery = BgDBUtils.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{oldUnionID});
        while (refCubeQuery.next()) {
            String RefCubeTable = refCubeQuery.getString("FRefCube");
            String cfsCubeName = BgCubeUtils.getCFSCubeName((String)RefCubeTable);
            String cfsAdjustCubeName = BgCubeUtils.getCFSAdjustCubeName((String)RefCubeTable);
            if (this.isCheckData(ctx, oldUnionID, cfsCubeName)) {
                return;
            }
            if (!this.isCheckData(ctx, oldUnionID, cfsAdjustCubeName)) continue;
            return;
        }
        StringBuffer offsetSql = new StringBuffer();
        offsetSql.append(" select top 1 FID from T_MBG_BgCslElim where ForgtreeId = ?");
        IRowSet offsetQuery = BgDBUtils.executeQuery((Context)ctx, (String)offsetSql.toString(), (Object[])new Object[]{oldUnionID});
        if (offsetQuery.next()) {
            return;
        }
        throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"UnionVersion_NoBusinessData", (Locale)ctx.getOriginLocale())));
    }

    private boolean isCheckData(Context ctx, String oldUnionID, String cfsCubeName) throws SQLException {
        if (BgDBUtils.existTable((Context)ctx, (String)cfsCubeName) == 1 && null != cfsCubeName && cfsCubeName.length() > 0) {
            List columns = BgDBUtils.getColumns((Context)ctx, (String)cfsCubeName);
            MbgUpdateDataBaseCopyHelper.toUpperCase((Collection)columns);
            if (columns.contains(FUNIONID)) {
                StringBuffer refDataSql = new StringBuffer();
                refDataSql.append("select top 1 FID from ").append(cfsCubeName).append(" where FUnionID = ?");
                IRowSet data = BgDBUtils.executeQuery((Context)ctx, (String)refDataSql.toString(), (Object[])new Object[]{oldUnionID});
                if (data.next()) {
                    return true;
                }
            }
        }
        return false;
    }

    public String getNewTemplateId(Connection conn, String newUnionID, String oldTemplateId, String tableName, Map<String, String> newUnitMap, String oldUnionID) {
        StringBuffer sql = new StringBuffer();
        String newOrgUnitId = "";
        String newTemplateId = "";
        try {
            Map<String, String> oldUnitMap = this.getNewVersionOrgUnit(oldUnionID, conn);
            sql.append(" select FID").append(" from ").append(tableName).append(" where FORGTREEID = ? ").append(" and FNUMBER = (select FNumber from ").append(tableName).append(" where FID = ?) ").append(" and FBGSCHEMEID =(select FBGSCHEMEID from ").append(tableName).append(" where FID = ?)");
            if ("T_MBG_BgCslAdjTemplate".equals(tableName)) {
                IRowSet rowSet;
                sql.append(" and FORGUNITID = ?");
                StringBuffer buffer = new StringBuffer();
                buffer.append("select FORGUNITID from T_MBG_BgCslAdjTemplate where FID = ?");
                IRowSet result = BgDBUtils.executeQuery((Connection)conn, (String)buffer.toString(), (Object[])new Object[]{oldTemplateId});
                if (result.next()) {
                    String oldUnitId = result.getString("FORGUNITID");
                    newOrgUnitId = this.getOrgUnitId(oldUnitMap, newUnitMap, oldUnitId);
                }
                if ((rowSet = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{newUnionID, oldTemplateId, oldTemplateId, newOrgUnitId})).next()) {
                    newTemplateId = rowSet.getString("FID");
                }
            } else {
                IRowSet rowSet = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{newUnionID, oldTemplateId, oldTemplateId});
                if (rowSet.next()) {
                    newTemplateId = rowSet.getString("FID");
                }
            }
            return newTemplateId;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return newTemplateId;
        }
    }

    public Map onStartingUnionBefore(Context ctx, String oldUnionID, String newUnionID, Timestamp date) throws Exception {
        return this.onStartingUnion(ctx, oldUnionID, newUnionID, date);
    }

    public Map onStartingUnionAfter(Context ctx, String oldUnionID, String newUnionID, Timestamp date, boolean isSuccess) throws BOSException, EASBizException {
        return null;
    }
}

