/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.bgcsl.BgCslFormCollection;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslViewlistFormServerHelper {
    private static final Logger logger = Logger.getLogger((String)BgCslViewlistFormServerHelper.class.getName());

    public static Map<String, OrgUnitInfo> queryBgViewOrgUnit(Context ctx, String permNumber, BgCslFormInfo bgForm, String orgViewId, boolean isAdjust, boolean isOnlyCurrOrg, String currOrgId, boolean isOnlyLeaf, Set<String> orgNumber) throws BOSException, EASBizException {
        if (bgForm == null) {
            return null;
        }
        String orgTreeId = "";
        if (bgForm.getOrgTree() != null) {
            orgTreeId = bgForm.getOrgTree().getId().toString();
        }
        BOSUuid orgUnitId = currOrgId != null ? BOSUuid.read((String)currOrgId) : bgForm.getOrgUnit().getId();
        FullOrgUnitInfo currOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
        HashMap<String, Object> orgMap = new HashMap<String, OrgUnitInfo>();
        if (currOrg == null) {
            return orgMap;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tempOrgIds = null;
        String sql = "select org.fid, org.fnumber, org.fname_" + ctx.getLocale() + " fname, org.fsimplename, org.flevel, org.flongnumber, org.FIsLeaf, org.FDisplayName_" + ctx.getLocale() + " FDisplayName \nfrom T_MBg_bgcslform bgForm \n inner join T_ORG_BaseUnit org on org.FID = bgForm.forgunitid \n inner join t_org_Structure s on s.FUNITID = org.fid and s.FTREEID = ? \n where bgForm.FBgSchemeId = ? and bgForm.FBgCslTemplateId = ? and bgForm.FBgPeriodId = ? and bgForm.FCurrencyId = ? and bgForm.FBgVersionId = ? ";
        if (isOnlyLeaf) {
            sql = sql + " and org.FIsLeaf = 1 ";
        }
        IRowSet rs = null;
        HashMap<String, String> orgNumbers = new HashMap<String, String>();
        HashSet parentNumbers = new HashSet();
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            if (orgNumber != null && orgNumber.size() < 200 && !orgNumber.isEmpty()) {
                tempOrgIds = BgDBUtils.insertKey((TempTablePool)pool, (Connection)conn, orgNumber, (String)"Nvarchar(80)");
                sql = sql + " and exists(Select FID FROM " + tempOrgIds + " temIds Where temIds.FID = org.FNumber)";
            }
            rs = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{orgTreeId, bgForm.getBgScheme().getId().toString(), bgForm.getBgCslTemplate().getId().toString(), bgForm.getBgPeriod().getId().toString(), bgForm.getCurrency().getId().toString(), bgForm.getBgVersion().getId().toString()});
            while (rs.next()) {
                OrgUnitInfo cost = new OrgUnitInfo();
                cost.setId(BOSUuid.read((String)rs.getString("fid")));
                cost.setNumber(rs.getString("fnumber"));
                cost.setName(rs.getString("fname"));
                cost.setLevel(rs.getInt("flevel"));
                cost.setSimpleName(rs.getString("fsimplename"));
                cost.setLongNumber(rs.getString("flongnumber"));
                cost.setIsLeaf(rs.getBoolean("FIsLeaf"));
                cost.setDisplayName(rs.getString("FDisplayName"));
                orgMap.put(cost.getId().toString(), cost);
                orgNumbers.put(cost.getNumber(), cost.getId().toString());
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)conn);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tempOrgIds);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)conn);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempOrgIds);
        if (orgMap != null && !orgMap.isEmpty()) {
            IObjectPK[] orgPKs = new IObjectPK[orgMap.size()];
            int index = 0;
            Iterator it = orgMap.keySet().iterator();
            while (it.hasNext()) {
                orgPKs[index++] = new ObjectStringPK((String)it.next());
            }
            if (permNumber != null) {
                Set orgIds = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), orgPKs, permNumber);
                HashMap<String, OrgUnitInfo> tempMap = orgMap;
                orgMap = new HashMap();
                if (orgIds != null && !orgIds.isEmpty()) {
                    Iterator it2 = orgIds.iterator();
                    while (it2.hasNext()) {
                        String orgId = String.valueOf(it2.next());
                        if (!tempMap.containsKey(orgId)) continue;
                        orgMap.put(orgId, tempMap.get(orgId));
                    }
                }
            }
        }
        return orgMap;
    }

    public static BgCslFormCollection getBgForm(Context ctx, BgCslFormInfo _bgForm, Set curOrgNums, SelectorItemCollection sic, Integer valueType) throws BOSException {
        BgCslFormCollection bgCslFormCollection;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        Connection conn = null;
        String tempIds = null;
        try {
            BgCslFormCollection col;
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(sic);
            evi.setFilter(new FilterInfo());
            HashSet state = new HashSet();
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)_bgForm.getBgScheme().getId().toString()));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgcslTemplate.id", (Object)_bgForm.getBgCslTemplate().getId().toString()));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)_bgForm.getBgPeriod().getId().toString()));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("currency.id", (Object)_bgForm.getCurrency().getId().toString()));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)_bgForm.getBgVersion().getId().toString()));
            if (curOrgNums.size() > 10) {
                conn = EJBFactory.getConnection((Context)ctx);
                tempIds = BgDBUtils.insertKey((TempTablePool)pool, (Connection)conn, (Collection)curOrgNums, (String)"NVarchar(80)");
                evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)("Select FID FROM " + tempIds), CompareType.INNER));
            } else {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)curOrgNums, CompareType.INCLUDE));
            }
            bgCslFormCollection = col = BgCslFormFactory.getLocalInstance(ctx).getBgCslFormCollection(evi);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tempIds);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempIds);
        return bgCslFormCollection;
    }
}

