/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.excel;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.ui.Excel2007ExportController;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportEvent;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportListener;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.bgcsl.excel.ExcelClient;
import com.kingdee.eas.ma.bgcsl.excel.ExcelConstants;
import com.kingdee.eas.ma.bgcsl.excel.ExcelServerManager;
import com.kingdee.eas.ma.bgcsl.excel.budget.BgExcelHelper;
import com.kingdee.eas.ma.bgcsl.excel.budget.CslAdjHelper;
import com.kingdee.eas.ma.bgcsl.excel.utils.ExcelJacobUtil;
import com.kingdee.eas.ma.bgcsl.excel.utils.ExcelUtil;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormExportProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExcelClientHelper {
    private static final Logger logger = Logger.getLogger(ExcelClientHelper.class);
    private static ExcelClientHelper instance;
    private static boolean isStarted;
    private DimensionCacheHelper cacheHelper = new DimensionCacheHelper(null);

    public static ExcelClientHelper getInstance() {
        if (instance == null) {
            instance = new ExcelClientHelper();
        }
        return instance;
    }

    public static void setStarted(boolean isStarted) {
        ExcelClientHelper.isStarted = isStarted;
    }

    public void openExcel(String reportId, CoreUI ownerUI) throws Exception {
        if (StringUtils.isEmpty((String)reportId)) {
            return;
        }
        ReportBaseInfo reportInfo = this.getReportInfoById(reportId);
        if (reportInfo == null) {
            return;
        }
        this.doOpenExcel(reportInfo, ownerUI);
    }

    protected ReportBaseInfo getReportInfoById(String reportId) throws Exception {
        if (StringUtils.isEmpty((String)reportId)) {
            return null;
        }
        Object reportInfo = null;
        reportInfo = BOSUuid.read((String)reportId).getType().equals((Object)new BgFormInfo().getBOSType()) ? BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectStringPK(reportId), BgNFSHelper.getSelectors()) : CslAdjHelper.getReportInfoById(reportId);
        return reportInfo;
    }

    private void doOpenExcel(ReportBaseInfo reportInfo, CoreUI ownerUI) throws Exception {
        Book book;
        String file;
        if (reportInfo == null) {
            return;
        }
        String basePath = ExcelConstants.EXCEL_EXPORT_PATH;
        File f = new File(basePath);
        if (!f.exists() && !f.isDirectory()) {
            f.mkdir();
        }
        if (new File(file = ExcelUtil.getExportFile(reportInfo)).exists()) {
            File temmf = new File(basePath);
            if (temmf.isDirectory()) {
                File[] fs;
                for (File temp : fs = temmf.listFiles()) {
                    if (!temp.isFile()) continue;
                    try {
                        temp.delete();
                        logger.info((Object)("[\u5220\u9664Excel\u4e34\u65f6\u6587\u4ef6\u6210\u529f]\uff1a" + temp.getName()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (new File(file).exists()) {
                MsgBox.showInfo((String)ExcelConstants.MSG_EXCEL_OPENED);
                return;
            }
        }
        if ((book = this.getBook(reportInfo, ownerUI)) == null) {
            return;
        }
        int count = book.getSheetCount();
        String[] sns = new String[count];
        for (int i = 0; i < count; ++i) {
            sns[i] = book.getSheetName(i);
            BgExcelHelper.stopSheetProtection(book.getSheet(i));
        }
        this.exportToExcel2007(book, sns, file, reportInfo);
    }

    public boolean checkJDK() {
        String osArch = System.getProperty("os.arch");
        String sunArch = System.getProperty("sun.arch.data.model");
        String jdkVersion = System.getProperty("java.specification.version");
        if (osArch.indexOf("64") > -1 && sunArch.equals("64")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslAdjFormResource", (String)"checkJDK"));
            return false;
        }
        return true;
    }

    protected Book getBook(ReportBaseInfo reportInfo, CoreUI ownerUI) throws Exception {
        Book book = null;
        if (reportInfo instanceof BgFormInfo) {
            BgFormInfo bgFormInfo = (BgFormInfo)reportInfo;
            if (bgFormInfo.getBgTemplate().getFormType().getValue() == 0 || bgFormInfo.getBgTemplate().getFormType().getValue() == 8) {
                book = this.getFixBgForm(bgFormInfo);
            } else if (bgFormInfo.getBgTemplate().getFormType().getValue() == 2) {
                book = this.getViewListBgFormBook(bgFormInfo, ownerUI);
            }
        } else {
            book = CslAdjHelper.getBook(reportInfo, ownerUI);
        }
        return book;
    }

    private Book getFixBgForm(BgFormInfo bgFormInfo) throws Exception {
        Book book = bgFormInfo.getBook();
        Map dataMap = BgFormFactory.getRemoteInstance().getBgDataInfo(bgFormInfo, null);
        this.refillFixBook(book, dataMap);
        return book;
    }

    private Book getViewListBgFormBook(BgFormInfo bgFormInfo, CoreUI ownerUI) {
        LinkedHashMap<String, BgFormInfo> bgFormInfoMap = new LinkedHashMap<String, BgFormInfo>();
        bgFormInfoMap.put(bgFormInfo.getId().toString(), bgFormInfo);
        MBGViewListFormExportProvider viewlistExportProcessor = new MBGViewListFormExportProvider(bgFormInfoMap, (CoreUIObject)ownerUI);
        Book book = viewlistExportProcessor.getBook(bgFormInfo.getId().toString());
        return book;
    }

    private void doAfterExport(String path, ReportBaseInfo reportInfo) {
        try {
            this.refreshTemp();
            if (!isStarted) {
                Thread t = new Thread(new ExcelClient());
                t.start();
                isStarted = true;
            }
            HashMap<String, String> initProps = new HashMap<String, String>();
            initProps.put("reportId", reportInfo.getId().toString());
            initProps.put("url", "http://localhost:" + ExcelServerManager.port);
            initProps.put("sessionId", this.getSessionId());
            initProps.put("reportType", "groupRpt");
            initProps.put("isRpt", "1");
            initProps.put("rptSourceType", reportInfo.getSourceType().getValue() + "");
            initProps.put("isFromMergeReportCenter", String.valueOf(false));
            long ct1 = System.currentTimeMillis();
            ExcelJacobUtil.openExcel(path, initProps);
            logger.info((Object)("*****************ExcelJacobUtil.openExcel use: " + (System.currentTimeMillis() - ct1) + "ms"));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MsgBox.showError((String)"Fail to open Excel client, Please contact the administrator!");
        }
    }

    private String getSessionId() {
        return System.currentTimeMillis() + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTemp() {
        InputStream is = null;
        BufferedInputStream bis = null;
        File file = null;
        OutputStream fos = null;
        try {
            is = this.getClass().getResourceAsStream("EAS_AddIn.xlam");
            bis = new BufferedInputStream(is);
            file = new File(ExcelUtil.getExcelDir());
            if (!file.exists() && !file.isDirectory()) {
                file.mkdir();
            }
            if (!(file = new File(ExcelUtil.getExcelDir() + "\\EAS_AddIn.xlam")).exists() || file.isDirectory()) {
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            byte[] buf = new byte[2048];
            int len = 0;
            while ((len = bis.read(buf)) != -1) {
                ((FileOutputStream)fos).write(buf, 0, len);
            }
            fos.flush();
            ((FileOutputStream)fos).close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                if (bis != null) {
                    bis.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        String a = "";
        String sourcePath = ExcelClientHelper.class.getResource("EAS_AddIn.xlam").getFile();
        System.out.println(sourcePath);
    }

    private void refillFixBook(Book book, Map dataMap) throws EASBizException, BOSException {
        Sheet _sheet = null;
        Cell _cell = null;
        String formula = null;
        BgNDataInfo bgData = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            _sheet = book.getSheet(s);
            for (int r = 0; r <= _sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= _sheet.getMaxColIndex(); ++c) {
                    _cell = _sheet.getCell(r, c, false);
                    formula = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                    if (!StringUtils.isEmpty((String)formula)) {
                        bgData = (BgNDataInfo)dataMap.get(formula);
                        if (bgData == null) continue;
                        if (this.cacheHelper.getBudgetScens().contains(bgData.getBgScenario())) {
                            if (bgData.getAdjustValue() != null) {
                                BgNFSHelper.setValue((Cell)_cell, (Object)bgData.getAdjustValue());
                                continue;
                            }
                            BgNFSHelper.setValue((Cell)_cell, (Object)bgData.getBudgetValue());
                            continue;
                        }
                        BgNFSHelper.setValue((Cell)_cell, (Object)bgData.getBizActual());
                        continue;
                    }
                    if (_cell == null || !BgExcelHelper.checkCellText(_cell).booleanValue()) continue;
                    BgExcelHelper.setCellTextFormat(_cell);
                }
            }
        }
    }

    private boolean exportToExcel2007(Book book, String[] selectedSheets, String file, ReportBaseInfo reportInfo) {
        if (selectedSheets.length == 0) {
            return false;
        }
        try {
            Book tempBook = SpreadHelper.copyBook((Book)book);
            for (int i = 0; i < book.getSheetCount(); ++i) {
                boolean b = false;
                for (int j = 0; j < selectedSheets.length; ++j) {
                    if (!selectedSheets[j].equals(book.getSheet(i).getSheetName())) continue;
                    b = true;
                    break;
                }
                if (b) continue;
                tempBook.removeSheet(book.getSheet(i).getSheetName());
            }
            BookDataWrapper bookDataWrapper = new BookDataWrapper(tempBook);
            bookDataWrapper.setExportFormula(true);
            bookDataWrapper.setExportCustomerFomulas(false);
            bookDataWrapper.setExportHideCols(true);
            bookDataWrapper.setExportHideRows(true);
            Excel2007ExportController.export((String)file, (AbstractDataWrapper)bookDataWrapper, (boolean)false, (ExportListener[])new ExportListener[]{new ExportListener2007(file, reportInfo)});
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    static {
        isStarted = false;
    }

    private class ExportListener2007
    implements ExportListener {
        private Object biz;
        private String path;

        public ExportListener2007(String path, Object biz) {
            this.path = path;
            this.biz = biz;
        }

        public void complete(ExportEvent e) {
            if (this.biz != null && this.biz instanceof ReportBaseInfo) {
                ExcelClientHelper.this.doAfterExport(this.path, (ReportBaseInfo)this.biz);
            }
        }

        public void delEvent(ExportEvent e) {
        }
    }
}

