/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.excel;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExcelServerManager {
    private static final Logger logger = Logger.getLogger(ExcelServerManager.class);
    public static int port = 5555;
    private static ServerSocket server = null;
    private static Set<String> excelClientPool = new HashSet<String>();

    public static void initServer() {
        if (server == null) {
            ExcelServerManager.newServerSocket();
        }
    }

    private static void newServerSocket() {
        try {
            server = new ServerSocket(port);
        }
        catch (IOException e) {
            logger.warn((Object)("Port " + port + " is in use!"));
            ++port;
            ExcelServerManager.newServerSocket();
        }
    }

    public static Set<String> getExcelClientPool() {
        return excelClientPool;
    }

    public static ServerSocket getServer() {
        ExcelServerManager.initServer();
        return server;
    }

    public static void addExcelClient(String sessionId) {
        if (!excelClientPool.contains(sessionId)) {
            excelClientPool.add(sessionId);
        }
    }

    public static void removeExcelClient(String sessionId) {
        if (excelClientPool.contains(sessionId)) {
            excelClientPool.remove(sessionId);
        }
    }

    public static void destroyServer() throws IOException {
        if (server != null) {
            server.close();
        }
        server = null;
        excelClientPool.clear();
    }

    public static void closeServer() throws IOException {
        if (excelClientPool.size() == 0) {
            ExcelServerManager.destroyServer();
        }
    }

    public static void main(String[] args) throws IOException {
        ServerSocket ss = ExcelServerManager.getServer();
        ServerSocket ss2 = ExcelServerManager.getServer();
        System.out.println("ss.equals(ss2):" + ss.equals(ss2));
        System.out.println("ss.getLocalPort():" + ss.getLocalPort());
        System.out.println("ss2.getLocalPort():" + ss2.getLocalPort());
        ExcelServerManager.closeServer();
    }
}

