/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.excel.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportCalculator;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RelatedPartyRelationshipsFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLSysParamanager;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptGuideUI;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.MnsRptCalculate;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.RptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CslRptCalcUtil {
    private static final Logger logger = Logger.getLogger(CslRptCalcUtil.class);

    public void calculateSheets(Book book, CslReportInfo cslRptInfo) throws Exception {
        if (cslRptInfo.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION) || cslRptInfo.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT)) {
            if (!this.isDynaCslRpt(cslRptInfo)) {
                int precision = RptCalcHelper.getPrecisionByCry(null, (CurrencyInfo)cslRptInfo.getCurrency());
                new CslRptCalcUtil().consolidationRptCalculate(null, book, cslRptInfo, precision);
            }
        } else if (cslRptInfo.getSourceType().equals((Object)RptSrcTypeEnum.MANUSCRIPT)) {
            MnsRptCalculate msnRptCalculate = new MnsRptCalculate(null);
            msnRptCalculate.setCslRptInfo(cslRptInfo);
            msnRptCalculate.setBook(book);
            msnRptCalculate.setCalcType(0);
            boolean isSupportCrossMerger = this.isSupportCrossMerger(cslRptInfo);
            msnRptCalculate.setSupportCrossMerger(isSupportCrossMerger);
            if (isSupportCrossMerger) {
                MnsRptGuideUI mnsRptGuideUI = new MnsRptGuideUI(null, cslRptInfo);
                if (!mnsRptGuideUI.hasDefaultSolution()) {
                    mnsRptGuideUI.setSysDefaultSolutionInfo();
                }
                msnRptCalculate.setMnsRptParamInfo(mnsRptGuideUI.getMnsRptParamInfo());
                msnRptCalculate.setFillCompanyList(mnsRptGuideUI.getCompanyList());
            }
            BookProperties bookProp = BookProperties.loadFromBook((Book)cslRptInfo.getBook());
            int dataElementRelat = bookProp.getDataElementRelating();
            msnRptCalculate.setDataElementRelating(dataElementRelat);
            VariableEntry entry = bookProp.getVariables().get("isSupport", book.getName());
            boolean isSupport = entry == null ? false : Boolean.valueOf(entry.getValue());
            msnRptCalculate.setSupportHandElim(isSupport);
            msnRptCalculate.setIncludeUnAuditElim(false);
            msnRptCalculate.setClientSource("EXCEL");
            try {
                msnRptCalculate.prepareCalculate();
                msnRptCalculate.calculate();
                msnRptCalculate.afterCalculate();
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isSupportCrossMerger(CslReportInfo cslRptInfo) {
        return CSLParamUtil.isSupportCrossMerger(null, (String)cslRptInfo.getOrgTree().getId().toString());
    }

    public void consolidationRptCalculate(Context ctx, Book book, CslReportInfo cslRptInfo, int precision) throws EASBizException {
        HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
        HashMap<String, HashMap> tableFormulas = new HashMap<String, HashMap>();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            if (!sheet.isEnableCalculation()) continue;
            tables.put(sheet.getID(), sheet);
            HashMap cellFormula = CslRptCalcUtil.constructTableMap(sheet);
            tableFormulas.put(sheet.getID(), cellFormula);
        }
        if (tableFormulas.size() > 0) {
            ICSLReportCalculator calculator = null;
            try {
                calculator = ctx == null ? CSLReportCalculatorFactory.getRemoteInstance() : CSLReportCalculatorFactory.getLocalInstance((Context)ctx);
                Map sumResult = calculator.calculateCSLReport((IObjectPK)new ObjectUuidPK(cslRptInfo.getId()), tableFormulas);
                CslRptCalcUtil.refreshTableData(tables, sumResult, precision);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SumRptException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static HashMap constructTableMap(Sheet sheet) {
        if (sheet == null) {
            return null;
        }
        HashMap<Point, ItemFormula> result = new HashMap<Point, ItemFormula>();
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < colCount; ++columnIndex) {
                ItemFormula curFormula = (ItemFormula)sheet.getRange(rowIndex, columnIndex).getUserObject("ITEM");
                if (curFormula == null || !curFormula.isValidity()) continue;
                curFormula.setCell(null);
                Point position = new Point(columnIndex, rowIndex);
                result.put(position, curFormula);
            }
        }
        return result;
    }

    public static void refreshTableData(Map sheets, Map sheetData, int precision) {
        RptCalcHelper.refreshTableData((Map)sheets, (Map)sheetData, (int)precision);
    }

    private OrgUnitCollection getOrgUnits(OrgTreeInfo orgTreeInfo, OrgUnitInfo parentCompanyInfo) throws EASBizException, BOSException {
        IOrgUnitCommon orgUtil = OrgUnitCommonFactory.getRemoteInstance();
        CSLContextHelper.getSysParamanager().refreshParams();
        boolean isByLevel = CSLContextHelper.getSysParamanager().getMergeType() != 0;
        OrgUnitCollection units = null;
        units = isByLevel ? orgUtil.getUnionDebtChildren(parentCompanyInfo, orgTreeInfo) : orgUtil.getUnionDebtAllOrgUnit(parentCompanyInfo, orgTreeInfo);
        int elimMethod = Integer.parseInt(CSLSysParamanager.getSysParamValue((OrgTreeInfo)orgTreeInfo, (String)"GR_CSL_ELIMMETHOD_001"));
        if (elimMethod == 2) {
            units = RelatedPartyRelationshipsFactory.getRemoteInstance().getHKRelationOrgUnits(units);
        }
        return units;
    }

    private boolean isDynaCslRpt(CslReportInfo cslRptInfo) {
        return cslRptInfo != null && (RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)cslRptInfo.getSourceType()) || RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE.equals((Object)cslRptInfo.getSourceType())) && DynaEnumRptTypeEnum.DYNAMIC.equals((Object)cslRptInfo.getTemplate().getDynaRptType());
    }
}

