/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.excel.utils;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormStateEnum;
import com.kingdee.eas.ma.bgcsl.excel.ExcelConstants;
import com.kingdee.eas.ma.bgcsl.excel.budget.BgExcelHelper;
import com.kingdee.eas.ma.bgcsl.excel.budget.CslAdjHelper;
import com.kingdee.eas.ma.bgcsl.excel.excel.BookInfo;
import com.kingdee.eas.ma.bgcsl.excel.excel.CellInfo;
import com.kingdee.eas.ma.bgcsl.excel.excel.SheetInfo;
import com.kingdee.eas.ma.bgcsl.excel.excel.ValidationInfo;
import com.kingdee.eas.ma.bgcsl.excel.json.JSONUtils;
import com.kingdee.eas.ma.bgcsl.excel.utils.CalculatorUtils;
import com.kingdee.eas.ma.bgcsl.excel.utils.StyleUtils;
import com.kingdee.eas.ma.mbg.BgExamineFacadeFactory;
import com.kingdee.eas.ma.mbg.BgExamineResult;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.IBgExamineFacade;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExcelUtil {
    private static final Logger logger = Logger.getLogger(ExcelUtil.class);
    private static final String SUCCESS = "success";
    private static final String ERROR = "error";

    public static String formatString(String str) {
        return str.replace("&34&", "\"").replace("&92&", "\\");
    }

    public static String getExportFile(ReportBaseInfo info) {
        String fileName = info.getName();
        return ExcelConstants.EXCEL_EXPORT_PATH + fileName + ".xlsx";
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("os.name"));
    }

    public Object initSheet(String json) throws Exception {
        logger.error((Object)("initSheet json :" + json));
        Map paramMap = JSONUtils.convertJsonToObject(json, Map.class);
        String reportId = (String)paramMap.get("reportId");
        String templateId = (String)paramMap.get("templateId");
        String sheetName = (String)paramMap.get("sheetName");
        String reportType = (String)paramMap.get("reportType");
        boolean isRpt = "1".equals(paramMap.get("isRpt"));
        String id = "";
        id = isRpt ? reportId : templateId;
        Map<String, Object> reportMap = this.getRptInfo(id, reportType, sheetName);
        Book book = (Book)reportMap.get("book");
        book.setAutoCalculate(false);
        Sheet sheet = book.getSheetByName(sheetName);
        if (sheet != null) {
            CellInfo[] cells = StyleUtils.getCellContent(sheet);
            BgExcelHelper.stopSheetProtection(sheet);
            SheetInfo sheetInfo = new SheetInfo();
            sheetInfo.setId(sheet.getID());
            if (cells != null) {
                sheetInfo.setCells(cells);
            }
            if (sheet.getIndex() == 0) {
                sheetInfo.setIsActive(0);
            } else {
                sheetInfo.setIsActive(1);
            }
            return sheetInfo;
        }
        return null;
    }

    public SaveRptResult saveRpt(String json) throws Exception {
        SaveRptResult resultInfo = new SaveRptResult();
        BookInfo clientBook = JSONUtils.convertJsonToObject(json, BookInfo.class);
        String reportId = clientBook.getReportId();
        if (BOSUuid.read((String)reportId).getType().equals((Object)new BgFormInfo().getBOSType())) {
            this.saveBgForm(reportId, resultInfo, clientBook);
        } else {
            this.saveCslAdjForm(reportId, resultInfo, clientBook);
        }
        return resultInfo;
    }

    protected SaveRptResult saveBgForm(String reportId, SaveRptResult resultInfo, BookInfo clientBook) throws Exception {
        Book book = null;
        if (!StringUtils.isEmpty((String)reportId)) {
            BgFormInfo rptInfo = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectStringPK(reportId), BgNFSHelper.getSelectors());
            String errMsg = "";
            if (BgFormStateEnum.Approved.equals((Object)rptInfo.getState())) {
                resultInfo.setResult("FAIL");
                resultInfo.setMsg(RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"216_RptReportProcessUI"));
                return resultInfo;
            }
            book = rptInfo.getBook();
            boolean isAutoCalcBook = book.isAutoCalculate();
            book.setAutoCalculate(false);
            this.excelToBook(clientBook, book);
            rptInfo.setBook(book);
            book.setAutoCalculate(isAutoCalcBook);
            BgNFSHelper.setBudget((IObjectValue)rptInfo);
            BgFormFactory.getRemoteInstance().save((CoreBaseInfo)rptInfo);
            reportId = rptInfo.getId().toString();
        }
        if (book == null) {
            return resultInfo;
        }
        SheetInfo[] sheetInfo = new SheetInfo[book.getSheetCount()];
        for (int i = 0; i < book.getSheetCount(); ++i) {
            SheetInfo tmpSI = new SheetInfo();
            tmpSI.setId(book.getSheet(i).getID());
            tmpSI.setSheetName(book.getSheet(i).getSheetName());
            sheetInfo[i] = tmpSI;
        }
        resultInfo.setReportId(reportId);
        resultInfo.setResult("SUCCESS");
        resultInfo.setMsg(ExcelConstants.MSG_SAVE_SUCCESS);
        if (sheetInfo != null) {
            resultInfo.setSheetInfo(sheetInfo);
        }
        return resultInfo;
    }

    protected SaveRptResult saveCslAdjForm(String reportId, SaveRptResult resultInfo, BookInfo clientBook) throws Exception {
        Book book = null;
        if (!StringUtils.isEmpty((String)reportId)) {
            BgCslAdjFormInfo rptInfo = (BgCslAdjFormInfo)CslAdjHelper.getReportInfoById(reportId);
            if (BgCslFormStateEnum.AUDITED.equals((Object)rptInfo.getState())) {
                resultInfo.setResult("FAIL");
                resultInfo.setMsg(RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"216_RptReportProcessUI"));
                return resultInfo;
            }
            book = rptInfo.getBook();
            boolean isAutoCalcBook = book.isAutoCalculate();
            book.setAutoCalculate(false);
            this.excelToBook(clientBook, book);
            rptInfo.setBook(book);
            book.setAutoCalculate(isAutoCalcBook);
            BgCslAdjFormFactory.getRemoteInstance().save((CoreBaseInfo)rptInfo);
            reportId = rptInfo.getId().toString();
        }
        if (book == null) {
            return resultInfo;
        }
        SheetInfo[] sheetInfo = new SheetInfo[book.getSheetCount()];
        for (int i = 0; i < book.getSheetCount(); ++i) {
            SheetInfo tmpSI = new SheetInfo();
            tmpSI.setId(book.getSheet(i).getID());
            tmpSI.setSheetName(book.getSheet(i).getSheetName());
            sheetInfo[i] = tmpSI;
        }
        resultInfo.setReportId(reportId);
        resultInfo.setResult("SUCCESS");
        resultInfo.setMsg(ExcelConstants.MSG_SAVE_SUCCESS);
        if (sheetInfo != null) {
            resultInfo.setSheetInfo(sheetInfo);
        }
        return resultInfo;
    }

    private void excelToBook(BookInfo clientBook, Book book) throws Exception {
        this.refreshSheet(book, clientBook);
        Sheet curRptSheet = null;
        Cell curRptCell = null;
        boolean isEnableCalculation = false;
        for (SheetInfo curSheet : clientBook.getSheets()) {
            curRptSheet = StringUtils.isEmpty((String)curSheet.getId()) ? book.getSheetByName(curSheet.getSheetName()) : book.getSheetByID(curSheet.getId());
            isEnableCalculation = curRptSheet.isEnableCalculation();
            curRptSheet.setEnableCalculation(false);
            if (curSheet.getIsActive() == 0) {
                book.setActiveSheet(curRptSheet.getIndex());
            }
            CalculatorUtils.clearSheetOldData(curRptSheet);
            for (CellInfo cell : curSheet.getCells()) {
                String text;
                if (!(StringUtils.isEmpty((String)cell.getFormula()) && StringUtils.isEmpty((String)cell.getCellValue()) && StringUtils.isEmpty((String)cell.getItemformula()) && StringUtils.isEmpty((String)cell.getExt()) && cell.getComment() == null && cell.getHyperLink() == null)) {
                    curRptCell = curRptSheet.getCell(cell.getRow() - 1, cell.getCol() - 1, true);
                }
                if (curRptCell != null && !StringUtils.isEmpty((String)cell.getFormula()) && !cell.getFormula().toUpperCase(Locale.ENGLISH).equals("NULL") && curRptCell != null) {
                    curRptCell.setFormula(ExcelUtil.formatString(cell.getFormula()));
                }
                if (!(StringUtils.isEmpty((String)cell.getItemformula()) || cell.getItemformula().toUpperCase(Locale.ENGLISH).equals("NULL") || BgNFSHelper.checkHasItemFormula((Cell)curRptCell))) {
                    UserObjectHelper.setItemFormula((Cell)curRptCell, (ItemFormula)new ItemFormula(ExcelUtil.formatString(cell.getItemformula())));
                }
                if (!StringUtils.isEmpty((String)cell.getCellValue()) && !cell.getCellValue().toUpperCase(Locale.ENGLISH).equals("NULL") && curRptCell != null) {
                    String cv = cell.getCellValue();
                    if (!StringUtils.isEmpty((String)cv) && cv.matches("^-?([1-9]\\d*|0)(\\.\\d+)?$") && !"-0".equals(cv)) {
                        curRptCell.setValue(new Variant((Object)new BigDecimal(cv), 10));
                    } else {
                        curRptCell.setValue(new Variant((Object)ExcelUtil.formatString(cv)));
                    }
                }
                if (!StringUtils.isEmpty((String)cell.getExt()) && !cell.getExt().toUpperCase(Locale.ENGLISH).equals("NULL")) {
                    ItemFormula vif = new ItemFormula();
                    String[] exts = ExcelUtil.formatString(cell.getExt()).split("#:#");
                    for (int e = 0; e < exts.length; ++e) {
                        String[] es = exts[e].split("#_#");
                        if (es.length == 2) {
                            vif.putExt(es[0], es[1]);
                            continue;
                        }
                        if (es.length != 1) continue;
                        vif.putExt(es[0], "");
                    }
                    if (!BgNFSHelper.checkHasItemFormula((Cell)curRptCell)) {
                        UserObjectHelper.setItemFormula((Cell)curRptCell, (ItemFormula)vif);
                    }
                }
                if (cell.getComment() != null && curRptCell != null) {
                    text = cell.getComment().getText();
                    curRptCell.setComment(new Comment("", text));
                }
                if (cell.getHyperLink() == null || curRptCell == null) continue;
                text = cell.getHyperLink().getText();
                String linkTo = cell.getHyperLink().getLinkTo();
                curRptCell.setHyperLink(new HyperLink(text, "#" + linkTo));
            }
            if (curSheet.getValidationList() != null && curSheet.getValidationList().size() > 0) {
                this.buildValidation(curRptSheet, curSheet);
            }
            curRptSheet.setEnableCalculation(isEnableCalculation);
        }
    }

    public SheetInfo calcSheet(String json, boolean isFill) throws Exception {
        SheetInfo resultSheet = null;
        BookInfo clientBook = JSONUtils.convertJsonToObject(json, BookInfo.class);
        String reportId = clientBook.getReportId();
        if (!StringUtils.isEmpty((String)reportId) && clientBook.getSheets().length > 0) {
            ReportBaseInfo rptInfo = this.getReportInfoById(reportId);
            Book book = rptInfo.getBook();
            SheetInfo clientSheet = clientBook.getSheets()[0];
            resultSheet = CalculatorUtils.calcClientSheet(book, clientSheet.getId(), clientSheet, rptInfo, isFill);
        }
        return resultSheet;
    }

    public String checkAll(String json) throws Exception {
        String result = null;
        BookInfo clientBook = JSONUtils.convertJsonToObject(json, BookInfo.class);
        String reportId = clientBook.getReportId();
        if (!StringUtils.isEmpty((String)reportId)) {
            ReportBaseInfo rptInfo = this.getReportInfoById(reportId);
            if (rptInfo == null) {
                return null;
            }
            Book book = rptInfo.getBook();
            boolean isAutoCalcBook = book.isAutoCalculate();
            book.setAutoCalculate(false);
            this.excelToBook(clientBook, book);
            rptInfo.setBook(book);
            book.setAutoCalculate(isAutoCalcBook);
            IBgExamineFacade iBgExamineFacade = BgExamineFacadeFactory.getRemoteInstance();
            Object resultObj = iBgExamineFacade.examine(reportId);
            BgExamineResult checkResult = null;
            if (resultObj instanceof BgExamineResult) {
                checkResult = (BgExamineResult)resultObj;
            } else if (resultObj instanceof List && !((List)resultObj).isEmpty()) {
                checkResult = (BgExamineResult)((List)resultObj).get(0);
            }
            if (checkResult != null && !checkResult.result) {
                result = EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"examineNoPass");
            }
        } else {
            return RptUtil.getResourceSince51((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Please_Save_First");
        }
        if (!StringUtils.isEmpty(result)) {
            result = this.formatCheckResult(result);
        }
        return result;
    }

    private void refreshSheet(Book rptBook, BookInfo clientBook) {
        int i;
        ArrayList<String> idList = new ArrayList<String>();
        for (int i2 = 0; i2 < clientBook.getSheets().length; ++i2) {
            String sheetId = clientBook.getSheets()[i2].getId();
            String sheetName = clientBook.getSheets()[i2].getSheetName();
            if (StringUtils.isEmpty((String)sheetId)) {
                rptBook.insertSheet(i2, new Sheet(rptBook, sheetName));
                sheetId = sheetName;
            } else {
                Sheet sheet = rptBook.getSheetByID(sheetId);
                sheet.setName(sheetName);
            }
            idList.add(sheetId);
        }
        ArrayList<String> removeList = new ArrayList<String>();
        String tempId = "";
        int j = rptBook.getSheetCount();
        for (i = 0; i < j; ++i) {
            tempId = rptBook.getSheet(i).getID();
            if (idList.contains(tempId)) continue;
            removeList.add(tempId);
        }
        for (i = 0; i < removeList.size(); ++i) {
            rptBook.removeSheet(rptBook.getSheetByID((String)removeList.get(i)));
        }
    }

    private Map<String, Object> getRptInfo(String reportId, String reportType, String sheetName) throws Exception {
        Book book = null;
        String name = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportBaseInfo reportInfo = this.getReportInfoById(reportId);
        if (reportInfo == null) {
            return map;
        }
        book = reportInfo.getBook();
        name = reportInfo.getName();
        book.setCalculate(false);
        Sheet sheet = book.getSheetByName(sheetName);
        if (reportInfo instanceof BgCslAdjFormInfo && sheet != null) {
            CslAdjHelper.convertPeriod((BgCslAdjFormInfo)reportInfo, sheet);
        }
        map.put("name", name);
        map.put("book", book);
        return map;
    }

    protected ReportBaseInfo getReportInfoById(String reportId) throws Exception {
        Object reportInfo = null;
        reportInfo = BOSUuid.read((String)reportId).getType().equals((Object)new BgFormInfo().getBOSType()) ? BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectStringPK(reportId), BgNFSHelper.getSelectors()) : CslAdjHelper.getReportInfoById(reportId);
        return reportInfo;
    }

    public SelectorItemCollection getCslReportSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataCollect.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("dynaRptType"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.isGrouping"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.longnumber"));
        sic.add(new SelectorItemInfo("company.accountPeriodType"));
        sic.add(new SelectorItemInfo("company.accountTable"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("company.isBizUnit"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.sheet.sheetid"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.dynaRptType"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("template.sumType"));
        sic.add(new SelectorItemInfo("template.group"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("reportDate"));
        sic.add(new SelectorItemInfo("template.includeOtherDC"));
        sic.add(new SelectorItemInfo("template.checkOpenPeriod"));
        sic.add(new SelectorItemInfo("template.isSupportInnerExch"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("dataCollect.*"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        return sic;
    }

    public SelectorItemCollection getReportSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.longnumber"));
        sic.add(new SelectorItemInfo("company.accountPeriodType"));
        sic.add(new SelectorItemInfo("company.accountTable"));
        sic.add(new SelectorItemInfo("company.baseCurrency"));
        sic.add(new SelectorItemInfo("company.isBizUnit"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.precision"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.sheet.sheetid"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.company.id"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.precision"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("template.DynaRpttype"));
        sic.add(new SelectorItemInfo("template.group"));
        sic.add(new SelectorItemInfo("k3Template.group"));
        sic.add(new SelectorItemInfo("template.checkOpenPeriod"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("cslReport.id"));
        sic.add(new SelectorItemInfo("LastUpdateUser.Name"));
        sic.add(new SelectorItemInfo("LastUpdateUser.Number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.company.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("LastUpdateUser.Name"));
        sic.add(new SelectorItemInfo("LastUpdateUser.Number"));
        sic.add(new SelectorItemInfo("datacollect.id"));
        sic.add(new SelectorItemInfo("datacollect.number"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("template.includeOtherDC"));
        sic.add(new SelectorItemInfo("cslReport.commitor.id"));
        return sic;
    }

    private SelectorItemCollection getTemplateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.longnumber"));
        sic.add(new SelectorItemInfo("company.accountPeriodType"));
        sic.add(new SelectorItemInfo("company.accountTable"));
        sic.add(new SelectorItemInfo("company.baseCurrency"));
        sic.add(new SelectorItemInfo("company.isBizUnit"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.sheet.sheetid"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.company.id"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.precision"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        return sic;
    }

    private String formatCheckResult(String result) {
        result = result.replaceAll("<br>", "\n");
        result = result.replaceAll("<[a|A]([^>]*)>", "");
        result = result.replaceAll("</a>", "");
        result = result.replaceAll("&lt;", "<");
        result = result.replaceAll("&gt;", ">");
        result = result.replaceAll("====================================================================", "==========================================");
        return result;
    }

    public static String getExcelDir() {
        return ExcelConstants.EXCEL_EXPORT_PATH;
    }

    private void buildValidation(Sheet sheet, SheetInfo curSheet) {
        List<ValidationInfo> viList = curSheet.getValidationList();
        for (int i = 0; i < viList.size(); ++i) {
            ValidationInfo vi = viList.get(i);
            Validation val = new Validation(new MessagedValidate(), null);
            MessagedValidate mv = val.getMessagedValidate();
            mv.setType(vi.getTypeString());
            mv.setQualifier(vi.getOperatorString());
            val.setBlocks(SheetBaseMath.getSortedBlocks((Sheet)sheet, (String)vi.getAddress(), (boolean)false));
            mv.setImeMode((int)vi.getiMEMode());
            mv.setCellRangeList(vi.isInCellDropdown());
            mv.setUseBlank(!vi.isIgnoreBlank());
            mv.setInputHide(!vi.isShowInput());
            mv.setErrorHide(!vi.isShowError());
            mv.setMin(vi.getFormula1());
            mv.setMax(vi.getFormula2());
            mv.setInputTitle(vi.getInputTitle());
            mv.setInputMessage(vi.getInputMessage());
            mv.setErrorStyle(vi.getAlertStyleString());
            mv.setErrorTitle(vi.getErrorTitle());
            mv.setErrorMessage(vi.getErrorMessage());
            sheet.getValidations().addValidation(val);
        }
    }

    public class SaveRptResult {
        private String reportId;
        private String result;
        private String msg;
        private SheetInfo[] sheetInfo;

        public String getReportId() {
            return this.reportId;
        }

        public void setReportId(String reportId) {
            this.reportId = reportId;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public SheetInfo[] getSheetInfo() {
            return this.sheetInfo;
        }

        public void setSheetInfo(SheetInfo[] sheetInfo) {
            this.sheetInfo = sheetInfo;
        }
    }
}

