/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.provider;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormEditUI;
import com.kingdee.eas.ma.bgcsl.common.BgCslFormHelper;
import com.kingdee.eas.ma.mbg.client.BgNProcessUI;
import com.kingdee.eas.ma.mbg.client.utils.BudgetUtilForClient;

public class BgCslFormProvider
extends IBookProvider {
    private BgNProcessUI own = null;
    private String[] sheetIds = null;

    public BgCslFormProvider(BgNProcessUI ui) {
        this.own = ui;
    }

    public IObjectValue createNewReport() throws Exception {
        return null;
    }

    public String getBizFactoryName() {
        return "com.kingdee.eas.ma.bgcsl.BgCslFormFactory";
    }

    public ICoreBase getBizInterface() throws Exception {
        return BgCslFormFactory.getRemoteInstance();
    }

    public Book loadBook() throws Exception {
        Book book = null;
        if (this.getBgCslFormInfo() == null) {
            this.setEditValue(this.createNewReport());
        }
        if (this.getBgCslFormInfo().getData() != null) {
            book = this.getBgCslFormInfo().getBook();
        }
        if (OprtState.ADDNEW.equals(this.own.getOprtState()) && book != null) {
            this.sheetIds = new String[book.getSheetCount()];
            int in = book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                this.sheetIds[i] = book.getSheet(i).getID();
            }
        }
        if (book != null) {
            BudgetUtilForClient.prepareReportInfo4Display((ReportBaseInfo)this.getBgCslFormInfo(), (Book)book);
        }
        return book;
    }

    public void restoreSheetId(Book book) {
        if (book != null && this.sheetIds != null && book.getSheetCount() == this.sheetIds.length) {
            int in = book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                book.getSheet(i).setID(this.sheetIds[i]);
            }
        }
    }

    public void restoreBook(Book book) throws Exception {
        BudgetUtilForClient.prepareReportInfo4Save((ReportBaseInfo)this.getBgCslFormInfo(), (Book)book);
        this.getBgCslFormInfo().setBook(book);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getEditUIName() {
        return BgCslFormEditUI.class.getName();
    }

    public IObjectValue queryEditData(IObjectPK pk) throws Exception {
        return super.queryEditData(pk);
    }

    public BgCslFormInfo getBgCslFormInfo() {
        BgCslFormInfo info = null;
        if (this.getEditValue() instanceof BgCslFormInfo) {
            info = (BgCslFormInfo)this.getEditValue();
        }
        return info;
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = BgCslFormHelper.getSelector();
        return sic;
    }

    public BgNProcessUI getOwn() {
        return this.own;
    }
}

