/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.bgcsl.BgCslFormCollection;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.utils.BgCslCourseDisplayInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTemplateStatusEnum;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgTemplateObject;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslFormCourseHelper {
    private static Logger logger = Logger.getLogger((String)BgCslFormCourseHelper.class.getName());
    public static final String RESOURCE = "com.kingdee.eas.ma.bgcsl.BgCslFormCourseResource";
    public static final String BGPERIOD_INFO = "BGPERIOD_INFO";
    public static final String BGVERSION_INFO = "BGVERSION_INFO";
    public static final String BGSCHEME_ID = "BGSCHEME_ID";
    public static final String BGPERIOD_ID = "BGPERIOD_ID";
    public static final String CURRENCY_ID = "CURRENCY_ID";
    public static final String BGVERSION_ID = "BGVERSION_ID";
    public static final String TEMPLATE_ID = "TEMPLATE_ID";
    public static final String STATE = "STATE";
    public static final Color COUNT_COLOR = new Color(255, 255, 255);
    public static final Color CANTEDIT_COLOR = new Color(255, 255, 255);
    public static final Color EDIT_COLOR = new Color(255, 232, 210);
    public static final Color APPROVING_COLOR = new Color(64, 128, 128);
    public static final Color BASISAPPROVED_COLOR = new Color(128, 128, 255);
    public static final Color REPORT_COLOR = new Color(228, 243, 235);
    public static final Color CERTIFICATE_COLOR = new Color(181, 220, 188);
    public static final Color BACK_COLOR = new Color(255, 189, 189);
    public static final Color APPROVED_COLOR = new Color(102, 204, 255);
    public static final Color ITEM_COLOR = new Color(0, 128, 0);
    public static final Color CAUSE_COLOR = Color.RED;
    public static final int SEL_CURRORGUNIT = 1;
    public static final int SEL_IMMORGUNIT = 2;
    public static final int SEL_ALLORGUNIT = 3;
    public static final String CURR_ORGTREE_ID = "CURR_ORGTREE_ID";
    public static final String CURR_ORGUNIT_VIEW_ID = "CURR_ORGUNIT_VIEW_ID";
    public static final String CURR_USER_ID = "CURR_USER_ID";
    public static final String CURR_ORGUNIT_ID = "CURR_ORGUNIT_ID";
    public static final String CURR_CTRLORGUNIT_ID = "CURR_CTRLORGUNIT_ID";
    public static final String SEL_ORGUNIT_ID = "SEL_ORGUNIT_ID";
    public static final String SEL_ORGUNIT_TYPE = "SEL_ORGUNIT_TYPE";
    public static final String SEL_ORGUNIT_INFO = "SEL_ORGUNIT_INFO";
    public static final String SEL_BGSCHEME_IDS = "SEL_BGSCHEME_IDS";
    public static final String SEL_BGPERIOD_IDS = "SEL_BGPERIOD_IDS";
    public static final String SEL_CURRENCY_IDS = "SEL_CURRENCY_IDS";
    public static final String SEL_BGVERSION_IDS = "SEL_BGVERSION_IDS";
    public static final String SEL_BGTEMPLATE_IDS = "SEL_BGTEMPLATE_IDS";
    public static final String SEL_CSLTEMPLATE_IDS = "SEL_CSLTEMPLATE_IDS";
    public static final String SEL_ORDER_FILED = "SEL_ORDER_FILED";
    public static final String IS_FORBID = "IS_FORBID";
    public static final int QUERY_BGFORM_ID = 0;
    public static final int QUERY_BGFORM_NAME = 1;
    public static final int QUERY_BGFORM_STATE = 2;
    public static final int QUERY_ORGUNIT_ID = 3;
    public static final int QUERY_ORGUNIT_NAME = 4;
    public static final int QUERY_BGSCHEME_ID = 5;
    public static final int QUERY_BGSCHEME_NAME = 6;
    public static final int QUERY_BGTEMPLATE_ID = 7;
    public static final int QUERY_BGTEMPLATE_NAME = 8;
    public static final int QUERY_BGPERIOD_ID = 9;
    public static final int QUERY_BGPERIOD_NAME = 10;
    public static final int QUERY_CURRENCY_ID = 11;
    public static final int QUERY_CURRENCY_NAME = 12;
    public static final String RESULT_key2BgformMap = "key2BgformMap";
    public static final String RESULT_bgFormAtt = "bgFormAtt";
    public static final String RESULT_keyMap = "keyMap";
    public static final String RESULT_isShowAliasMap = "isShowAliasMap";
    public static final String RESULT_aliasMap = "aliasMap";
    public static final String RESULT_virtualMap = "virtualMap";
    public static final String COL_ID = "id";
    public static final String COL_SELECT = "select";
    public static final String COL_ORGUNIT = "orgUnit";
    public static final String COL_NUMBER = "number";
    public static final String COL_NAME = "name";
    public static final String COL_BGTEMPLATE = "bgTemplate";
    public static final String COL_BGSPECIALITEMSNUMBER = "bgSpecialItemsNumber";
    public static final String COL_BGSPECIALITEMS = "bgSpecialItems";
    public static final String COL_PERIOD = "period";
    public static final String COL_BGVERSION = "bgVersion";
    public static final String COL_STATE = "state";
    public static final String COL_DESCRIPTION = "description";
    public static final String COL_CREATOR = "creator";
    public static final String COL_CREATETIME = "createTime";
    public static final String COL_AUDITOR = "auditor";
    public static final String COL_AUDITTIME = "auditTime";
    public static final String COL_BGTEMPLATETYPE = "bgTemplateType";
    public static final String COL_ORGTYPE = "orgType";
    public static final String COL_ORGUNITID = "orgUnitId";
    public static final String KEY_BGORGUNIT = "KEY_BGORGUNIT";
    public static final String KEY_CSLORGUNIT = "KEY_CSLORGUNIT";

    public static int getFormType(KDTable tblMain, int rowIndex, String formTypeField) {
        if (tblMain.getRow(rowIndex) != null) {
            BgTemFormTypeEnum _enum;
            IRow row = tblMain.getRow(rowIndex);
            int type = -1;
            if (row.getCell(formTypeField) != null && row.getCell(formTypeField).getValue() instanceof BizEnumValueInfo) {
                BizEnumValueInfo _enum2 = (BizEnumValueInfo)row.getCell(formTypeField).getValue();
                if (_enum2 != null) {
                    return _enum2.getInt();
                }
            } else if (row.getCell(formTypeField) != null && row.getCell(formTypeField).getValue() instanceof BgTemFormTypeEnum && (_enum = (BgTemFormTypeEnum)row.getCell(formTypeField).getValue()) != null) {
                return _enum.getValue();
            }
        }
        return -1;
    }

    public static String combineBgTemplateIDS(BgTemplateInfo[] infos) {
        if (infos == null || infos.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int size = infos.length;
        for (int i = 0; i < size; ++i) {
            sb.append(infos[i].getId().toString()).append(BgBaseConstants.SEP_ONE_STR);
        }
        return sb.toString();
    }

    public static BgTemplateInfo[] getBgTemplateInfos(String ids) throws BOSException {
        if (StringUtils.isEmpty((String)ids)) {
            return null;
        }
        String[] tmps = ids.split(BgBaseConstants.SEP_ONE_STR);
        BgTemplateInfo[] infos = new BgTemplateInfo[tmps.length];
        BOSUuid id = null;
        BgTemplateInfo info = null;
        int size = tmps.length;
        for (int i = 0; i < size; ++i) {
            id = BOSUuid.read((String)tmps[i]);
            info = new BgTemplateInfo();
            info.setId(id);
            infos[i] = info;
        }
        return infos;
    }

    public static BgTemplateInfo[] tempObj2TempArray(BgTemplateObject obj) {
        if (obj == null) {
            return null;
        }
        BgTemplateCollection tmpCol = obj.getResult();
        if (tmpCol == null || tmpCol.size() == 0) {
            return null;
        }
        int size = tmpCol.size();
        BgTemplateInfo[] bgTemplates = new BgTemplateInfo[size];
        for (int i = 0; i < size; ++i) {
            bgTemplates[i] = tmpCol.get(i);
        }
        return bgTemplates;
    }

    public static BgTemplateObject tempArray2TempObj(BgTemplateInfo[] tmps) {
        if (tmps == null) {
            return null;
        }
        if (tmps == null || tmps.length == 0) {
            return null;
        }
        BgTemplateCollection col = new BgTemplateCollection();
        int size = tmps.length;
        for (int i = 0; i < size; ++i) {
            col.add(tmps[i]);
        }
        BgTemplateObject obj = new BgTemplateObject(col);
        return obj;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<BgFormInfo, Boolean> assemblyToBgForm(Map<String, BgFormInfo> _bgFormMap, Map<String, Object[]> keyMap) throws EASBizException, BOSException {
        void var14_18;
        LinkedHashMap<BgFormInfo, Boolean> bgFormMap = new LinkedHashMap<BgFormInfo, Boolean>();
        if (EmptyUtil.isEmpty(keyMap)) {
            return bgFormMap;
        }
        HashMap<String, Boolean> tempBgFormMap = new HashMap<String, Boolean>();
        boolean att = false;
        Object[] obj = null;
        boolean hasAtt = false;
        String _bgFormMapKey = null;
        String orgId = null;
        String key = null;
        BgFormInfo _bgFormInfo = null;
        BgFormInfo newBgFormInfo = null;
        BgFormCollection formCollection = new BgFormCollection();
        for (Map.Entry<String, BgFormInfo> entry : _bgFormMap.entrySet()) {
            _bgFormMapKey = entry.getKey();
            _bgFormInfo = entry.getValue();
            if (!keyMap.containsKey(_bgFormMapKey)) continue;
            obj = keyMap.get(_bgFormMapKey);
            if (_bgFormMapKey.split("_").length == 6) {
                _bgFormInfo.setBgTemplate((BgTemplateInfo)obj[1]);
                formCollection.add(_bgFormInfo);
                tempBgFormMap.put(_bgFormInfo.getId().toString(), hasAtt);
            }
            keyMap.remove(_bgFormMapKey);
        }
        for (Map.Entry<String, BgFormInfo> entry : keyMap.entrySet()) {
            key = entry.getKey();
            obj = (Object[])entry.getValue();
            orgId = key.split("_")[0];
            newBgFormInfo = BgCslFormCourseHelper.createNewBgFormInfo();
            newBgFormInfo.setBgScheme((BgSchemeInfo)obj[0]);
            newBgFormInfo.setBgTemplate((BgTemplateInfo)obj[1]);
            newBgFormInfo.setBgPeriod((BgPeriodInfo)obj[2]);
            newBgFormInfo.setCurrency((CurrencyInfo)obj[3]);
            newBgFormInfo.setBgVersion((BgVersionInfo)obj[4]);
            newBgFormInfo.setOrgUnit((FullOrgUnitInfo)obj[5]);
            formCollection.add(newBgFormInfo);
        }
        Object[] formList = formCollection.toArray();
        BgCslFormCourseHelper.sortBgForms(formList);
        boolean bl = false;
        int size = formList.length;
        while (var14_18 < size) {
            _bgFormInfo = (BgFormInfo)formList[var14_18];
            if (_bgFormInfo.getId() != null) {
                bgFormMap.put(_bgFormInfo, (Boolean)tempBgFormMap.get(_bgFormInfo.getId().toString()));
            } else {
                bgFormMap.put(_bgFormInfo, false);
            }
            ++var14_18;
        }
        return bgFormMap;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<BgCslFormInfo, Boolean> assemblyToCslForm(Map<String, BgCslFormInfo> _bgFormMap, Map<String, Object[]> keyMap) throws EASBizException, BOSException {
        void var14_18;
        LinkedHashMap<BgCslFormInfo, Boolean> bgFormMap = new LinkedHashMap<BgCslFormInfo, Boolean>();
        if (EmptyUtil.isEmpty(keyMap)) {
            return bgFormMap;
        }
        HashMap<String, Boolean> tempBgFormMap = new HashMap<String, Boolean>();
        boolean att = false;
        Object[] obj = null;
        boolean hasAtt = false;
        String _bgFormMapKey = null;
        String orgId = null;
        String key = null;
        BgCslFormInfo _bgFormInfo = null;
        BgCslFormInfo newBgFormInfo = null;
        BgCslFormCollection formCollection = new BgCslFormCollection();
        for (Map.Entry<String, BgCslFormInfo> entry : _bgFormMap.entrySet()) {
            _bgFormMapKey = entry.getKey();
            _bgFormInfo = entry.getValue();
            if (!keyMap.containsKey(_bgFormMapKey)) continue;
            obj = keyMap.get(_bgFormMapKey);
            if (_bgFormMapKey.split("_").length == 6) {
                _bgFormInfo.setBgCslTemplate((BgCslTemplateInfo)obj[1]);
                formCollection.add(_bgFormInfo);
                tempBgFormMap.put(_bgFormInfo.getId().toString(), hasAtt);
            }
            keyMap.remove(_bgFormMapKey);
        }
        for (Map.Entry<String, BgCslFormInfo> entry : keyMap.entrySet()) {
            key = entry.getKey();
            obj = (Object[])entry.getValue();
            orgId = key.split("_")[0];
            newBgFormInfo = BgCslFormCourseHelper.createNewCslFormInfo();
            newBgFormInfo.setBgScheme((BgSchemeInfo)obj[0]);
            newBgFormInfo.setBgCslTemplate((BgCslTemplateInfo)obj[1]);
            newBgFormInfo.setBgPeriod((BgPeriodInfo)obj[2]);
            newBgFormInfo.setCurrency((CurrencyInfo)obj[3]);
            newBgFormInfo.setBgVersion((BgVersionInfo)obj[4]);
            newBgFormInfo.setOrgUnit((FullOrgUnitInfo)obj[5]);
            formCollection.add(newBgFormInfo);
        }
        Object[] formList = formCollection.toArray();
        BgCslFormCourseHelper.sortCslForms(formList);
        boolean bl = false;
        int size = formList.length;
        while (var14_18 < size) {
            _bgFormInfo = (BgCslFormInfo)formList[var14_18];
            if (_bgFormInfo.getId() != null) {
                bgFormMap.put(_bgFormInfo, (Boolean)tempBgFormMap.get(_bgFormInfo.getId().toString()));
            } else {
                bgFormMap.put(_bgFormInfo, false);
            }
            ++var14_18;
        }
        return bgFormMap;
    }

    public static String getRrefixPeriodName(BgCslCourseDisplayInfo info) {
        String n = info.getPeriodName();
        if (StringUtils.isEmpty((String)info.getPeriodNumber())) {
            return n;
        }
        String p = info.getPeriodNumber().substring(0, 4);
        n = n + "(" + p + ")";
        return n;
    }

    public static String getRrefixPeriodName(BgPeriodInfo info) {
        String n = info.getName();
        if (StringUtils.isEmpty((String)info.getNumber())) {
            return n;
        }
        String p = info.getNumber().substring(0, 4);
        n = n + "(" + p + ")";
        return n;
    }

    private static BgFormInfo createNewBgFormInfo() {
        BgFormInfo info = new BgFormInfo();
        info.setOrgUnit(new FullOrgUnitInfo());
        return info;
    }

    private static BgCslFormInfo createNewCslFormInfo() {
        BgCslFormInfo info = new BgCslFormInfo();
        info.setOrgUnit(new FullOrgUnitInfo());
        return info;
    }

    private static void sortBgForms(Object[] formList) {
        Arrays.sort(formList, new Comparator(){

            public int compare(Object o1, Object o2) {
                BgFormInfo f1 = (BgFormInfo)o1;
                BgFormInfo f2 = (BgFormInfo)o2;
                int r = f1.getOrgUnit().getNumber().compareTo(f2.getOrgUnit().getNumber());
                if (r != 0) {
                    return r;
                }
                if (f1.getId() == null && f2.getId() == null) {
                    int t = f1.getBgTemplate().getNumber().compareTo(f2.getBgTemplate().getNumber());
                    if (t == 0 && f1.getBgPeriod().getNumber() != null && f2.getBgPeriod().getNumber() != null) {
                        int s = f1.getBgPeriod().getNumber().compareTo(f2.getBgPeriod().getNumber());
                        if (s == 0 && f1.getBgVersion().getNumber() != null && f2.getBgVersion().getNumber() != null) {
                            int v = f1.getBgVersion().getNumber().compareTo(f2.getBgVersion().getNumber());
                            return v;
                        }
                        return s;
                    }
                    return t;
                }
                if (f1.getId() != null && f2.getId() != null) {
                    int f = f1.getNumber().compareTo(f2.getNumber());
                    if (f == 0 && f1.getBgPeriod().getNumber() != null && f2.getBgPeriod().getNumber() != null) {
                        int s = f1.getBgPeriod().getNumber().compareTo(f2.getBgPeriod().getNumber());
                        if (s == 0 && f1.getBgVersion().getNumber() != null && f2.getBgVersion().getNumber() != null) {
                            int v = f1.getBgVersion().getNumber().compareTo(f2.getBgVersion().getNumber());
                            return v;
                        }
                        return s;
                    }
                    return f;
                }
                return f1.getId() != null ? -1 : 1;
            }
        });
    }

    private static void sortCslForms(Object[] formList) {
        Arrays.sort(formList, new Comparator(){

            public int compare(Object o1, Object o2) {
                BgCslFormInfo f1 = (BgCslFormInfo)o1;
                BgCslFormInfo f2 = (BgCslFormInfo)o2;
                int r = f1.getOrgUnit().getNumber().compareTo(f2.getOrgUnit().getNumber());
                if (r != 0) {
                    return r;
                }
                if (f1.getId() == null && f2.getId() == null) {
                    int t = f1.getBgCslTemplate().getNumber().compareTo(f2.getBgCslTemplate().getNumber());
                    if (t == 0 && f1.getBgPeriod().getNumber() != null && f2.getBgPeriod().getNumber() != null) {
                        int s = f1.getBgPeriod().getNumber().compareTo(f2.getBgPeriod().getNumber());
                        if (s == 0 && f1.getBgVersion().getNumber() != null && f2.getBgVersion().getNumber() != null) {
                            int v = f1.getBgVersion().getNumber().compareTo(f2.getBgVersion().getNumber());
                            return v;
                        }
                        return s;
                    }
                    return t;
                }
                if (f1.getId() != null && f2.getId() != null) {
                    int f = f1.getNumber().compareTo(f2.getNumber());
                    if (f == 0 && f1.getBgPeriod().getNumber() != null && f2.getBgPeriod().getNumber() != null) {
                        int s = f1.getBgPeriod().getNumber().compareTo(f2.getBgPeriod().getNumber());
                        if (s == 0 && f1.getBgVersion().getNumber() != null && f2.getBgVersion().getNumber() != null) {
                            int v = f1.getBgVersion().getNumber().compareTo(f2.getBgVersion().getNumber());
                            return v;
                        }
                        return s;
                    }
                    return f;
                }
                return f1.getId() != null ? -1 : 1;
            }
        });
    }

    public static BgTemFormTypeEnum getBgFormType(Context ctx, String formId) throws EASBizException, BOSException {
        if (formId == null) {
            return null;
        }
        if (BgCslFormCourseHelper.isCslForm(formId).booleanValue()) {
            BgCslFormInfo bgForm = null;
            bgForm = ctx != null ? BgCslFormFactory.getLocalInstance(ctx).getBgCslFormInfo("select bgCslTemplate.id, state, bgCslTemplate.formType where id = '" + formId + "'") : BgCslFormFactory.getRemoteInstance().getBgCslFormInfo("select bgCslTemplate.id, state, bgCslTemplate.formType where id = '" + formId + "'");
            return bgForm.getBgCslTemplate().getFormType();
        }
        BgFormInfo bgForm = null;
        bgForm = ctx != null ? BgFormFactory.getLocalInstance((Context)ctx).getBgFormInfo("select bgTemplate.id, state, bgTemplate.formType where id = '" + formId + "'") : BgFormFactory.getRemoteInstance().getBgFormInfo("select bgTemplate.id, state, bgTemplate.formType where id = '" + formId + "'");
        return bgForm.getBgTemplate().getFormType();
    }

    public static Map<String, FullOrgUnitInfo> queryOrgInfo(Context ctx, String orgViewId, String tmpOrgGroup) throws BOSException {
        HashMap<String, FullOrgUnitInfo> orgMap = new HashMap<String, FullOrgUnitInfo>();
        if (tmpOrgGroup == null) {
            return orgMap;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo(COL_ID, (Object)("select FID from " + tmpOrgGroup), CompareType.INNER));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(COL_ID);
        evi.getSelector().add(COL_NUMBER);
        evi.getSelector().add(COL_NAME);
        FullOrgUnitCollection col = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(evi);
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                orgMap.put(col.get(i).getId().toString(), col.get(i));
            }
        }
        return orgMap;
    }

    public static void copyArrayToSet(Set<String> set, String[] array) {
        if (array != null) {
            int in = array.length;
            for (int i = 0; i < in; ++i) {
                if (array[i] == null) continue;
                set.add(array[i].toString());
            }
        }
    }

    public static Set<String> copyArrayToSet(String[] array) {
        HashSet<String> set = new HashSet<String>();
        if (array != null) {
            int in = array.length;
            for (int i = 0; i < in; ++i) {
                if (array[i] == null) continue;
                set.add(array[i].toString());
            }
        }
        return set;
    }

    public static BgVersionCollection queryBgVersion(Context ctx, Set bgPeriodIds) throws BOSException, EASBizException {
        if (ctx == null || bgPeriodIds == null) {
            return new BgVersionCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(COL_ID);
        sic.add(COL_NUMBER);
        sic.add(COL_NAME);
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        if (!bgPeriodIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)bgPeriodIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        BgVersionCollection bgPeriodCol = BgVersionFactory.getLocalInstance((Context)ctx).getBgVersionCollection(view);
        return bgPeriodCol;
    }

    public static BgPeriodCollection queryBgPeriod(Context ctx, Set bgPeriodIds) throws BOSException, EASBizException {
        if (ctx == null || bgPeriodIds == null) {
            return new BgPeriodCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(COL_ID);
        sic.add(COL_NUMBER);
        sic.add(COL_NAME);
        sic.add("alias");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        if (!bgPeriodIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)bgPeriodIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        BgPeriodCollection bgPeriodCol = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(view);
        return bgPeriodCol;
    }

    public static CurrencyCollection queryCurrency(Context ctx, Set currencyIds) throws BOSException, EASBizException {
        if (ctx == null || currencyIds == null) {
            return new CurrencyCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(COL_ID);
        sic.add(COL_NUMBER);
        sic.add(COL_NAME);
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        if (!currencyIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)currencyIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        CurrencyCollection currencyCol = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
        return currencyCol;
    }

    public static Map<String, IDimDataQuery> queryBgFormFromDB(Context ctx, EntityViewInfo view) throws BOSException, EASBizException {
        HashMap<String, IDimDataQuery> _bgFormMap = new HashMap<String, IDimDataQuery>();
        if (view == null) {
            return _bgFormMap;
        }
        BgFormInfo bgFormInfo2 = null;
        BgFormCollection bgFormColl = null;
        StringBuffer _key = null;
        try {
            bgFormColl = BgFormFactory.getLocalInstance((Context)ctx).getBgFormCollection(view);
            if (bgFormColl != null) {
                for (BgFormInfo bgFormInfo2 : bgFormColl) {
                    _key = BgCslFormCourseHelper.getKey(bgFormInfo2);
                    _bgFormMap.put(_key.toString(), (IDimDataQuery)bgFormInfo2);
                }
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        return _bgFormMap;
    }

    private static StringBuffer getKey(BgFormInfo bgFormInfo) {
        StringBuffer key = new StringBuffer(bgFormInfo.getOrgUnit().getId().toString()).append("_").append(bgFormInfo.getBgTemplate().getId().toString()).append("_").append(bgFormInfo.getBgPeriod().getId().toString()).append("_").append(bgFormInfo.getCurrency().getId().toString()).append("_").append(bgFormInfo.getBgVersion().getId().toString());
        if (bgFormInfo.getBgSpecialItems() != null && bgFormInfo.getBgSpecialItems().size() > 0) {
            key.append("_").append(bgFormInfo.getBgSpecialItems().get(0).getId().toString());
        } else {
            key.append("_").append("null");
        }
        return key;
    }

    private static StringBuffer getKey(IDimDataQuery formInfo) {
        StringBuffer key = new StringBuffer(formInfo.getBizOrgUnit().getId().toString()).append("_").append(formInfo.getBizTemplateId().toString()).append("_").append(formInfo.getBizPeriod().getId().toString()).append("_").append(formInfo.getBizCurrency().getId().toString()).append("_").append(formInfo.getBizVersion().getId().toString());
        if (formInfo instanceof BgCslFormInfo) {
            if (!((BgCslFormInfo)formInfo).getBgSpecialItems().isEmpty()) {
                key.append("_").append(((BgCslFormInfo)formInfo).getBgSpecialItems().get(0).getId().toString());
            } else {
                key.append("_").append("null");
            }
        }
        return key;
    }

    private static StringBuffer getKey(String orgID, String bgTemplateID, String bgPeriodID, String currencyID, String bgversionId) {
        return BgCslFormCourseHelper.getKey(orgID, bgTemplateID, bgPeriodID, currencyID, bgversionId, null);
    }

    private static StringBuffer getKeyContainSpeceilItem(String orgID, String bgTemplateID, String bgPeriodID, String currencyID, String bgversionId) {
        StringBuffer key = new StringBuffer(orgID).append("_").append(bgTemplateID).append("_").append(bgPeriodID).append("_").append(currencyID).append("_").append(bgversionId);
        return key;
    }

    public static Map<String, Object[]> getKeyMap(Map<String, FullOrgUnitInfo> orgMap, Map<String, Map<String, CoreBaseInfo>> bgTemplateMap, BgPeriodCollection bgPeriodCol, CurrencyCollection currencyCol, BgVersionCollection bgVersionCol, Map<String, IDimDataQuery> _bgFormMap) {
        HashMap<String, Object[]> keyMap = new HashMap<String, Object[]>();
        Boolean isEmpty = EmptyUtil.isEmpty(orgMap) || EmptyUtil.isEmpty(bgTemplateMap) || EmptyUtil.isEmpty((AbstractObjectCollection)bgVersionCol) || EmptyUtil.isEmpty((AbstractObjectCollection)bgPeriodCol) || EmptyUtil.isEmpty((AbstractObjectCollection)currencyCol);
        if (isEmpty.booleanValue()) {
            return keyMap;
        }
        Object[] tmpValue = null;
        String _orgId2 = null;
        String _bgTemplateId = null;
        String tempKey2 = null;
        String specialItemId = null;
        StringBuffer _key = null;
        Map<String, CoreBaseInfo> _tmpTmMap = null;
        BgPeriodInfo bgPeriodInfo = null;
        CurrencyInfo currencyInfo = null;
        Object bgSchemeInfo = null;
        CoreBaseInfo templateInfo = null;
        BgVersionInfo bgVersionInfo = null;
        BgFormInfo tempBgFormInfo = null;
        BgCslFormInfo tempBgCslFormInfo = null;
        String[] mapkey = null;
        for (String _orgId2 : orgMap.keySet()) {
            for (Map.Entry<String, Map<String, CoreBaseInfo>> entry : bgTemplateMap.entrySet()) {
                _tmpTmMap = entry.getValue();
                for (Map.Entry<String, CoreBaseInfo> _entrytm : _tmpTmMap.entrySet()) {
                    mapkey = _entrytm.getKey().split(":");
                    _bgTemplateId = mapkey[1];
                    templateInfo = _entrytm.getValue();
                    specialItemId = null;
                    if (!mapkey[0].equals(_orgId2) && templateInfo instanceof BgTemplateInfo) continue;
                    int ips = bgPeriodCol.size();
                    for (int ip = 0; ip < ips; ++ip) {
                        bgPeriodInfo = bgPeriodCol.get(ip);
                        int ics = currencyCol.size();
                        for (int ic = 0; ic < ics; ++ic) {
                            currencyInfo = currencyCol.get(ic);
                            for (int i = 0; i < bgVersionCol.size(); ++i) {
                                bgVersionInfo = bgVersionCol.get(i);
                                boolean isExistForm = false;
                                for (String tempKey2 : _bgFormMap.keySet()) {
                                    IDimDataQuery bgFormInfo = _bgFormMap.get(tempKey2);
                                    boolean isSameProperty = false;
                                    if (bgFormInfo instanceof BgFormInfo) {
                                        tempBgFormInfo = (BgFormInfo)bgFormInfo;
                                        if (tempBgFormInfo.getOrgUnit().getId().toString().equals(_orgId2) && tempBgFormInfo.getBgTemplate().getId().toString().equals(_bgTemplateId) && tempBgFormInfo.getBgPeriod().getId().toString().equals(bgPeriodInfo.getId().toString()) && tempBgFormInfo.getBgVersion().getId().toString().equals(bgVersionInfo.getId().toString()) && tempBgFormInfo.getCurrency().getId().toString().equals(currencyInfo.getId().toString())) {
                                            isExistForm = true;
                                            isSameProperty = true;
                                        }
                                        if (!tempBgFormInfo.getBgSpecialItems().isEmpty()) {
                                            specialItemId = tempBgFormInfo.getBgSpecialItems().get(0).getId().toString();
                                        }
                                    } else if (bgFormInfo instanceof BgCslFormInfo) {
                                        tempBgCslFormInfo = (BgCslFormInfo)bgFormInfo;
                                        if (tempBgCslFormInfo.getOrgUnit().getId().toString().equals(_orgId2) && tempBgCslFormInfo.getBgCslTemplate().getId().toString().equals(_bgTemplateId) && tempBgCslFormInfo.getBgPeriod().getId().toString().equals(bgPeriodInfo.getId().toString()) && tempBgCslFormInfo.getBgVersion().getId().toString().equals(bgVersionInfo.getId().toString()) && tempBgCslFormInfo.getCurrency().getId().toString().equals(currencyInfo.getId().toString())) {
                                            isExistForm = true;
                                            isSameProperty = true;
                                        }
                                        if (!tempBgCslFormInfo.getBgSpecialItems().isEmpty()) {
                                            specialItemId = tempBgCslFormInfo.getBgSpecialItems().get(0).getId().toString();
                                        }
                                    }
                                    if (isSameProperty) {
                                        _key = BgCslFormCourseHelper.getKey(_orgId2, _bgTemplateId, bgPeriodInfo.getId().toString(), currencyInfo.getId().toString(), bgVersionInfo.getId().toString(), specialItemId);
                                        tmpValue = new Object[]{bgSchemeInfo, templateInfo, bgPeriodInfo, currencyInfo, bgVersionInfo, orgMap.get(_orgId2)};
                                        keyMap.put(_key.toString(), tmpValue);
                                    }
                                    specialItemId = null;
                                }
                                if (isExistForm) continue;
                                _key = BgCslFormCourseHelper.getKey(_orgId2, _bgTemplateId, bgPeriodInfo.getId().toString(), currencyInfo.getId().toString(), bgVersionInfo.getId().toString(), specialItemId);
                                tmpValue = new Object[]{bgSchemeInfo, templateInfo, bgPeriodInfo, currencyInfo, bgVersionInfo, orgMap.get(_orgId2)};
                                keyMap.put(_key.toString(), tmpValue);
                            }
                        }
                    }
                }
            }
        }
        return keyMap;
    }

    private static StringBuffer getKey(String orgID, String bgTemplateID, String bgPeriodID, String currencyID, String bgversionId, String bgSpecialItemId) {
        StringBuffer key = new StringBuffer(orgID).append("_").append(bgTemplateID).append("_").append(bgPeriodID).append("_").append(currencyID).append("_").append(bgversionId);
        if (bgSpecialItemId != null) {
            key.append("_").append(bgSpecialItemId);
        } else {
            key.append("_").append("null");
        }
        return key;
    }

    public static Set<String> queryImmOrgUnit(Context ctx, String orgLongNumber, String orgViewId, int level) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgLongNumber) || StringUtils.isEmpty((String)orgViewId)) {
            return new HashSet<String>();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashSet<String> orgUnitSet = new HashSet<String>();
        String _orgUnitId = null;
        String sql = "select forgunitid from T_MBG_BGORGUNIT where  fviewid = ? and FLongnumber like ? " + (level > 0 ? "and FLevel = ?" : "");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, orgViewId);
            pstmt.setString(2, orgLongNumber + "!%");
            if (level > 0) {
                pstmt.setInt(3, level);
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _orgUnitId = rst.getString(1);
                orgUnitSet.add(_orgUnitId);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return orgUnitSet;
    }

    public static Set queryAllOrgUnit(Context ctx, String currOrgUnitId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)currOrgUnitId)) {
            return new HashSet();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashSet<String> orgUnitSet = new HashSet<String>();
        String _number = null;
        String _longNumber = null;
        String _orgUnitId = null;
        String sql1 = "select FNumber, FLongNumber from T_ORG_CostCenter where FID = ?";
        Object[] _numbers = null;
        StringBuffer sql = new StringBuffer("select FID from T_ORG_CostCenter where FLongnumber like ? ");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql1);
            pstmt.setString(1, BOSUuid.read((String)currOrgUnitId).toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgUnitSet.add(currOrgUnitId);
                _number = rst.getString(1);
                _longNumber = rst.getString(2);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!StringUtils.isEmpty(_number) && !StringUtils.isEmpty(_longNumber) && _longNumber != null && (_numbers = _longNumber.split("!")) != null) {
                int in = _numbers.length;
                for (int i = 0; i < in; ++i) {
                    sql.append(" or FNumber = ? ");
                }
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, _longNumber + "!%");
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (int)2, (Object[])_numbers);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _orgUnitId = rst.getString(1);
                    orgUnitSet.add(_orgUnitId);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return orgUnitSet;
    }

    public static Map queryBgSchemeInfo(Context ctx, String userId, Set queryOrgUnitIds, Set bgSchemeRootIds, boolean _isBgPermissionUsed) throws BOSException, EASBizException {
        if (ctx == null || queryOrgUnitIds == null || bgSchemeRootIds == null) {
            return new HashMap();
        }
        HashMap _bgSchemeMap = new HashMap();
        Map<String, BgSchemeInfo> _tmpMap = null;
        String _orgId = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(COL_ID);
        sic.add(COL_NAME);
        sic.add(COL_NUMBER);
        sic.add("dateFrom");
        sic.add("dateTo");
        sic.add("isFormal");
        sic.add(COL_PERIOD);
        sic.add(COL_STATE);
        sic.add("isSubmitByScheme");
        sic.add("isFiling");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        if (!queryOrgUnitIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("orgunit.id", (Object)queryOrgUnitIds, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)bgSchemeRootIds, CompareType.INCLUDE));
        view.setFilter(filter);
        BgSchemeCollection bgSchemeCol = BgSchemeFactory.getLocalInstance((Context)ctx).getBgSchemeCollection(view);
        BgSchemeInfo info = null;
        int j = bgSchemeCol.size();
        for (int i = 0; i < j; ++i) {
            info = bgSchemeCol.get(i);
            _orgId = info.getOrgUnit().getId().toString();
            if (_bgSchemeMap.containsKey(_orgId)) {
                _tmpMap = (Map)_bgSchemeMap.get(_orgId);
            } else {
                _tmpMap = new HashMap();
                _bgSchemeMap.put(_orgId, _tmpMap);
            }
            _tmpMap.put(info.getId().toString(), info);
        }
        return _bgSchemeMap;
    }

    public static Map<String, Map<String, CoreBaseInfo>> queryBgTemplateInfo(Context ctx, String userId, String currentOrgUnitID, String tmpOrgTable, Set<String> bgSchemeRootIds, Set<String> bgTemplateIds, boolean isPermission, boolean isForbid) throws BOSException, EASBizException {
        if (ctx == null || userId == null || bgSchemeRootIds == null || bgSchemeRootIds.isEmpty() || tmpOrgTable == null || bgTemplateIds == null) {
            return new HashMap<String, Map<String, CoreBaseInfo>>();
        }
        HashMap<String, Map<String, CoreBaseInfo>> _bgTemplateMap = new HashMap<String, Map<String, CoreBaseInfo>>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Map<String, BgTemplateInfo> tmpMap = null;
        BgTemplateInfo templateInfo = null;
        BgTypeInfo typeInfo = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        String _schemeId = null;
        String _tempId = null;
        String _tempNumber = null;
        String _tempName = null;
        String _roodID = null;
        String _bgTypeID = null;
        String _bgTypeNumber = null;
        String _bgTypeName = null;
        String _formType = null;
        String _templateStatus = null;
        String _bgOrgUnitId = null;
        String _tempNodeOrgUnitId = null;
        StringBuffer sql = BgCslFormCourseHelper.queryBgTemplateSql(ctx, isForbid);
        sql.append(" and n.FOrgUnitId IN (select FID from " + tmpOrgTable + ")");
        if (!bgSchemeRootIds.isEmpty()) {
            sql.append(" and t.FBgSchemeId IN ( ");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)bgSchemeRootIds.size());
            sql.append(" )");
            _tmpList.addAll(bgSchemeRootIds);
        }
        if (!bgTemplateIds.isEmpty()) {
            sql.append(" and t.frootid in ( select frootid from T_MBg_BgTemplate where fid in (");
            for (String object : bgTemplateIds) {
                sql.append("'").append(object.toString()).append("',");
            }
            sql = sql.deleteCharAt(sql.lastIndexOf(","));
            sql.append("))");
        } else {
            EntityViewInfo queryTemplateView = BgCslFormCourseHelper.getQueryTemplateView(ctx, bgSchemeRootIds.toArray()[0].toString(), tmpOrgTable, false, true);
            BgTemplateCollection bgTemplateCollection = BgTemplateFactory.getLocalInstance((Context)ctx).getBgTemplateCollection(queryTemplateView);
            if (bgTemplateCollection != null && !bgTemplateCollection.isEmpty()) {
                sql.append(" and t.frootid in ( select frootid from T_MBg_BgTemplate where fid in (");
                for (int i = 0; i < bgTemplateCollection.size(); ++i) {
                    BgTemplateInfo bgTemplateInfo = bgTemplateCollection.get(i);
                    String string = bgTemplateInfo.getId().toString();
                    sql.append("'").append(string).append("',");
                }
                sql = sql.deleteCharAt(sql.lastIndexOf(","));
                sql.append("))");
            } else {
                sql.append(" and t.frootid in ( select frootid from T_MBg_BgTemplate where fid in ('").append("#").append("'))");
            }
        }
        sql.append(" and t.FIsReadonly = 0 ");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _schemeId = rst.getString(1);
                _tempId = rst.getString(2);
                _tempName = rst.getString(3);
                _tempNumber = rst.getString(4);
                _formType = rst.getString(5);
                _templateStatus = rst.getString(6);
                _roodID = rst.getString(7);
                _bgTypeID = rst.getString(8);
                _bgTypeNumber = rst.getString(9);
                _bgTypeName = rst.getString(10);
                _bgOrgUnitId = rst.getString(11);
                _tempNodeOrgUnitId = rst.getString(12);
                if (_bgTemplateMap.containsKey(_schemeId)) {
                    tmpMap = (Map)_bgTemplateMap.get(_schemeId);
                } else {
                    tmpMap = new HashMap();
                    _bgTemplateMap.put(_schemeId, tmpMap);
                }
                templateInfo = new BgTemplateInfo();
                templateInfo.setId(BOSUuid.read((String)_tempId));
                templateInfo.setName(_tempName);
                templateInfo.setNumber(_tempNumber);
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)_bgOrgUnitId));
                templateInfo.setOrgUnit(fullOrgUnitInfo);
                if (!StringUtils.isEmpty((String)_formType)) {
                    templateInfo.setFormType(BgTemFormTypeEnum.getEnum((int)Integer.valueOf(_formType)));
                }
                if (!StringUtils.isEmpty((String)_templateStatus)) {
                    templateInfo.setTemplateStatus(BgTemplateStatusEnum.getEnum((int)Integer.valueOf(_templateStatus)));
                }
                typeInfo = new BgTypeInfo();
                if (!StringUtils.isEmpty((String)_bgTypeID)) {
                    typeInfo.setId(BOSUuid.read((String)_bgTypeID));
                    typeInfo.setName(_bgTypeName);
                    typeInfo.setNumber(_bgTypeNumber);
                }
                templateInfo.setBgType(typeInfo);
                tmpMap.put(_tempNodeOrgUnitId + ":" + _tempId, templateInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _bgTemplateMap;
    }

    public static StringBuffer queryBgTemplateSql(Context ctx, boolean isForbid) {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FBgSchemeId, n.FBgTemplateId, t.FName, t.FNumber,t.FFormType,t.FTemplateStatus , t.frootid , y.FID, y.FNumber, y.FName_").append(ctx.getLocale()).append(", t.FOrgUnitId , n.FOrgUnitId from T_MBG_BgTemplateNode n ").append(" left join T_MBg_BgTemplate t on n.FBgTemplateId = t.FID").append(" left join T_MBg_BgType y on t.FBgTypeId = y.FID").append(" where (y.FID IS NULL or y.FID <> 'bgMAAAAKIcA7rHKd') ");
        if (isForbid) {
            sql.append(" and t.FTemplateStatus = 0 ");
        }
        return sql;
    }

    public static List<String[]> queryBgPeriodIds(Context ctx, Set<String> bgPeriodIds) throws BOSException, EASBizException {
        if (ctx == null || bgPeriodIds == null) {
            return new ArrayList<String[]>();
        }
        int index = 0;
        int batchSize = 50;
        int size = bgPeriodIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> _bgPeriodIds = new ArrayList<String>();
        ArrayList<String[]> _bgPeriods = new ArrayList<String[]>();
        _bgPeriodIds.addAll(bgPeriodIds);
        String _id = null;
        String _number = null;
        String[] _strs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName_").append(ctx.getLocale()).append(", FNumber from T_MBg_BgPeriod where FID IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?) order by FNumber");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_bgPeriodIds.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _id = rst.getString(1);
                    String _name = rst.getString(2);
                    _number = rst.getString(3);
                    _strs = new String[]{_id, _name, _number};
                    _bgPeriods.add(_strs);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return _bgPeriods;
    }

    public static List<String[]> queryCurrencyIds(Context ctx, Set<String> currencyIds) throws BOSException, EASBizException {
        if (ctx == null || currencyIds == null) {
            return new ArrayList<String[]>();
        }
        int index = 0;
        int batchSize = 10;
        int size = currencyIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> _currencyIds = new ArrayList<String>();
        ArrayList<String[]> _currencys = new ArrayList<String[]>();
        _currencyIds.addAll(currencyIds);
        String _id = null;
        String _number = null;
        String[] _strs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName_").append(ctx.getLocale()).append(", FNumber from T_BD_Currency where FID IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?) order by FNumber");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_currencyIds.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _id = rst.getString(1);
                    String _name = rst.getString(2);
                    _number = rst.getString(3);
                    _strs = new String[]{_id, _name, _number};
                    _currencys.add(_strs);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return _currencys;
    }

    public static EntityViewInfo getQueryTemplateView(Context ctx, String bgSchemeInfoId, String tmpOrgTable, boolean isDisplaySelfTemp, boolean isDisplayForbidTemp) throws BOSException, EASBizException {
        if (bgSchemeInfoId == null) {
            return new EntityViewInfo();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.Fid , t.FName, t.Fnumber  ").append("from T_MBG_BgTemplateNode n ").append("left join T_MBG_BgTemplate t on t.Fid = n.FBgTemplateID ").append("left join T_MBG_BgType y on y.FID = t.FBgTypeID ").append("where t.FBgSchemeID = ? ").append("and n.FOrgUnitId in (select FID from " + tmpOrgTable + ") ");
        tmpList.add(bgSchemeInfoId);
        if (!isDisplaySelfTemp) {
            sql.append(" and (t.FBgTypeId is null or y.FNumber <> 'SelfDefineAnalysisTemplateGroup')");
        }
        if (!isDisplayForbidTemp) {
            sql.append("  and t.FtemplateStatus = 0 ");
        }
        HashSet<String> idSet = new HashSet<String>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                idSet.add(rst.getString(1));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(COL_ID, idSet, CompareType.INCLUDE));
        if (filterInfo.getMaskString() == null) {
            filterInfo.setMaskString(" #0 ");
        } else {
            filterInfo.setMaskString(" ( " + filterInfo.getMaskString() + " ) and #" + (filterInfo.getFilterItems().size() - 1));
        }
        view.setFilter(filterInfo);
        return view;
    }

    public static Boolean isOrgGroup(Context ctx, String orgUnitId) throws EASBizException, BOSException {
        Boolean isOrgGroup = false;
        if (StringUtils.isEmpty((String)orgUnitId)) {
            return isOrgGroup;
        }
        isOrgGroup = ctx == null ? Boolean.valueOf(OrgStructureFactory.getRemoteInstance().exists("select unit.id where unit.id = '" + orgUnitId + "' and unit.isgrouping = 1")) : Boolean.valueOf(OrgStructureFactory.getLocalInstance((Context)ctx).exists("select unit.id where unit.id = '" + orgUnitId + "' and unit.isgrouping = 1"));
        return isOrgGroup;
    }

    public static Set<String> getOrgGroupIds(Context ctx, Set<String> orgUnitIds) throws EASBizException, BOSException {
        if (orgUnitIds == null || orgUnitIds.isEmpty()) {
            return orgUnitIds;
        }
        OrgStructureCollection colls = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("unit.id"));
        viewInfo.setFilter(new FilterInfo());
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo(COL_ID, orgUnitIds, CompareType.INCLUDE));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("unit.isgrouping", (Object)1, CompareType.EQUALS));
        colls = ctx == null ? OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(viewInfo) : OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(viewInfo);
        HashSet<String> orgGroupIds = new HashSet<String>();
        if (colls != null) {
            OrgStructureInfo info = null;
            for (int index = 0; index < colls.size(); ++index) {
                info = colls.get(index);
                orgGroupIds.add(info.getUnit().getId().toString());
            }
        }
        return orgGroupIds;
    }

    public static Boolean isCslForm(String formId) throws EASBizException, BOSException {
        Boolean isCslForm = false;
        if (StringUtils.isEmpty((String)formId)) {
            return isCslForm;
        }
        isCslForm = BOSUuid.getBOSObjectType((String)formId, (boolean)true).equals((Object)new BgCslFormInfo().getBOSType());
        return isCslForm;
    }

    public static SelectorItemCollection getBgFormSelectorItem() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(COL_ID);
        sic.add(COL_NUMBER);
        sic.add(COL_NAME);
        sic.add(COL_STATE);
        sic.add("courseOrgId");
        sic.add("lastUpdateTime");
        sic.add(COL_AUDITTIME);
        sic.add(COL_DESCRIPTION);
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.dateFrom");
        sic.add("bgScheme.dateTo");
        sic.add("bgScheme.isFormal");
        sic.add("bgScheme.period");
        sic.add("bgScheme.state");
        sic.add("bgScheme.isFiling");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.formType");
        sic.add("bgTemplate.root.id");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("orgUnit.longnumber");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("bgVersion.id");
        sic.add("bgVersion.name");
        sic.add("bgVersion.number");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("auditor.id");
        sic.add("auditor.name");
        sic.add("bgSpecialItems.memberDisplayName");
        sic.add("bgSpecialItems.dimensionNumber");
        return sic;
    }

    public static Map<String, IDimDataQuery> queryCslFormFromDB(Context ctx, EntityViewInfo view) throws BOSException, EASBizException {
        LinkedHashMap<String, IDimDataQuery> _bgFormMap = new LinkedHashMap<String, IDimDataQuery>();
        if (view == null) {
            return _bgFormMap;
        }
        BgCslFormInfo bgCslFormInfo = null;
        BgCslFormCollection bgCslFormColl = null;
        StringBuffer _key = null;
        try {
            bgCslFormColl = BgCslFormFactory.getLocalInstance(ctx).getBgCslFormCollection(view);
            if (bgCslFormColl != null) {
                Iterator iter = bgCslFormColl.iterator();
                while (iter.hasNext()) {
                    bgCslFormInfo = (BgCslFormInfo)iter.next();
                    _key = BgCslFormCourseHelper.getKey(bgCslFormInfo);
                    _bgFormMap.put(_key.toString(), bgCslFormInfo);
                }
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        return _bgFormMap;
    }

    public static Map<String, Map<String, CoreBaseInfo>> queryCslTemplateInfo(Context ctx, String orgTreeId, String userId, String currentOrgUnitID, Set<String> bgSchemeIds, Set<String> bgTemplateIds, boolean isForbid, boolean isPermission) throws BOSException, EASBizException {
        if (ctx == null || userId == null || bgSchemeIds == null || bgSchemeIds.isEmpty() || bgTemplateIds == null || orgTreeId == null) {
            return new HashMap<String, Map<String, CoreBaseInfo>>();
        }
        HashMap<String, Map<String, CoreBaseInfo>> _bgTemplateMap = new HashMap<String, Map<String, CoreBaseInfo>>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = BgCslFormCourseHelper.getCslTemplateSelectors();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)orgTreeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", bgSchemeIds, CompareType.INCLUDE));
        if (isForbid) {
            filter.getFilterItems().add(new FilterItemInfo("templateStatus", (Object)0, CompareType.EQUALS));
        }
        if (!bgTemplateIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo(COL_ID, bgTemplateIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        BgCslTemplateCollection colls = BgCslTemplateFactory.getLocalInstance(ctx).getBgCslTemplateCollection(view);
        if (colls == null || colls.isEmpty()) {
            return _bgTemplateMap;
        }
        BgCslTemplateInfo templateInfo = null;
        BgSchemeInfo schemeInfo = null;
        FullOrgUnitInfo orgUnitInfo = null;
        String tmpKey = null;
        for (int index = 0; index < colls.size(); ++index) {
            templateInfo = colls.get(index);
            schemeInfo = templateInfo.getBgScheme();
            orgUnitInfo = schemeInfo.getOrgUnit();
            tmpKey = orgUnitInfo.getId().toString() + ":" + templateInfo.getId().toString();
            if (!_bgTemplateMap.containsKey(schemeInfo.getId().toString())) {
                _bgTemplateMap.put(schemeInfo.getId().toString(), new HashMap());
            }
            if (((Map)_bgTemplateMap.get(schemeInfo.getId().toString())).containsKey(tmpKey)) continue;
            ((Map)_bgTemplateMap.get(schemeInfo.getId().toString())).put(tmpKey, templateInfo);
        }
        return _bgTemplateMap;
    }

    public static SelectorItemCollection getCslFormSelectorItem() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(COL_ID);
        sic.add(COL_NUMBER);
        sic.add(COL_NAME);
        sic.add(COL_STATE);
        sic.add("lastUpdateTime");
        sic.add(COL_AUDITTIME);
        sic.add(COL_DESCRIPTION);
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.dateFrom");
        sic.add("bgScheme.dateTo");
        sic.add("bgScheme.isFormal");
        sic.add("bgScheme.period");
        sic.add("bgScheme.state");
        sic.add("bgScheme.isFiling");
        sic.add("bgCslTemplate.id");
        sic.add("bgCslTemplate.number");
        sic.add("bgCslTemplate.name");
        sic.add("bgCslTemplate.formType");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("orgUnit.longnumber");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("bgVersion.id");
        sic.add("bgVersion.name");
        sic.add("bgVersion.number");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("auditor.id");
        sic.add("auditor.name");
        sic.add("bgSpecialItems.memberDisplayName");
        sic.add("bgSpecialItems.dimensionNumber");
        return sic;
    }

    public static SelectorItemCollection getCslTemplateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(COL_ID));
        sic.add(new SelectorItemInfo(COL_NAME));
        sic.add(new SelectorItemInfo(COL_NUMBER));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo(COL_DESCRIPTION));
        sic.add(new SelectorItemInfo(COL_CREATETIME));
        sic.add(new SelectorItemInfo("bgType.id"));
        sic.add(new SelectorItemInfo("bgType.number"));
        sic.add(new SelectorItemInfo("bgType.name"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("bgScheme.number"));
        sic.add(new SelectorItemInfo("bgScheme.name"));
        sic.add(new SelectorItemInfo("bgScheme.orgUnit.id"));
        sic.add(new SelectorItemInfo("bgScheme.orgUnit.number"));
        sic.add(new SelectorItemInfo("bgScheme.orgUnit.name"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("cu.number"));
        sic.add(new SelectorItemInfo("cu.name"));
        sic.add(new SelectorItemInfo("formType"));
        return sic;
    }
}

