/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bgcsl.BgCslOrgSeqFacadeFactory;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class BgCslOrgSeqHelper {
    public static final String OrgUnit_ID = "OrgUnitID";
    public static final String OrgUnit_Name = "OrgUnitName";
    public static final String OrgUnit_Number = "OrgUnitNumber";
    public static final String OrgUnit_SimpleName = "OrgUnitSimpleName";
    public static final String OrgUnit_LongNumber = "OrgUnitLongNumber";
    public static final String OrgUnit_IsGrouping = "OrgUnitIsGrouping";
    public static final String Seq = "Seq";
    public static final String BgCslOrgSeq_ID = "bgCslOrgSeqID";
    public static final String OrgUnitList = "orgUnitList";
    public static final String Entry_ID = "EntryID";
    public static final String isModified = "isModified";

    public static List getOrderOrgUnitList(Context ctx, MbgWorkPaperInfo info, List orgList) {
        if (info == null || info.getBgScheme() == null || info.getOrgUnit() == null || info.getOrgTree() == null) {
            return orgList;
        }
        String orgTreeID = info.getOrgTree().getId().toString();
        String bgSchemeID = info.getBgScheme().getId().toString();
        String orgGroupID = info.getOrgUnit().getId().toString();
        try {
            HashMap orderOrgMap = BgCslOrgSeqFacadeFactory.getLocalInstance(ctx).getOrgList(orgTreeID, orgGroupID, bgSchemeID);
            if (orderOrgMap != null && orderOrgMap.containsKey(OrgUnitList)) {
                List orderList = (List)orderOrgMap.get(OrgUnitList);
                return BgCslOrgSeqHelper.transToFullOrgUnit(orderList);
            }
        }
        catch (EASBizException e) {
            return orgList;
        }
        catch (BOSException e) {
            return orgList;
        }
        return orgList;
    }

    private static List<FullOrgUnitInfo> transToFullOrgUnit(List orderList) {
        ArrayList<FullOrgUnitInfo> returnList = new ArrayList<FullOrgUnitInfo>();
        HashMap map = null;
        FullOrgUnitInfo orgUnit = null;
        for (int i = 0; i < orderList.size(); ++i) {
            map = (HashMap)orderList.get(i);
            orgUnit = new FullOrgUnitInfo();
            orgUnit.setId(BOSUuid.read((String)((String)map.get(OrgUnit_ID))));
            orgUnit.setNumber((String)map.get(OrgUnit_Number));
            orgUnit.setName((String)map.get(OrgUnit_Name));
            orgUnit.setSimpleName((String)map.get(OrgUnit_SimpleName));
            orgUnit.setLongNumber((String)map.get(OrgUnit_LongNumber));
            orgUnit.setIsGrouping(map.get(OrgUnit_IsGrouping) instanceof Boolean ? (Boolean)map.get(OrgUnit_IsGrouping) : false);
            returnList.add(orgUnit);
        }
        return returnList;
    }

    public static OrgStructureInfo getOrgStructureByUnit(Context ctx, String unitInfoID, String treeInfoID) throws BOSException {
        IOrgStructure iStruc = OrgStructureFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeInfoID));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitInfoID));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("longnumber"));
        OrgStructureCollection structInfos = iStruc.getOrgStructureCollection(view);
        if (structInfos.size() != 0) {
            return structInfos.get(0);
        }
        return null;
    }

    public static HashMap getOrgCollection(Context ctx, String orgTreeID, String orgGroupID, String bgSchemeID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgSchemeID) || StringUtils.isEmpty((String)orgGroupID) || StringUtils.isEmpty((String)orgTreeID)) {
            return null;
        }
        String language = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append(" select Entry.FParentID as BgCslOrgSeqID, Entry.FID as EntryID, OrgUnit.FID as OrgUnitID, ");
        sql.append(" OrgUnit.FName_").append(language).append(" as OrgUnitName ,");
        sql.append(" OrgUnit.FSimpleName as OrgUnitSimpleName ,");
        sql.append(" OrgUnit.FNumber as OrgUnitNumber, ");
        sql.append(" OrgUnit.FLongNumber as OrgUnitLongNumber, ");
        sql.append(" OrgUnit.FIsGrouping OrgUnitGrouping, ");
        sql.append(" Entry.FSeq as Seq ");
        sql.append(" from T_ORG_BaseUnit as OrgUnit ");
        sql.append(" inner join T_MBG_BgCslOrgSeqEntry as Entry on Entry.FOrgUnitID = OrgUnit.FID ");
        sql.append(" inner join T_MBG_BgCslOrgSeq as BgCslOrgSeq on BgCslOrgSeq.FID = Entry.FParentID ");
        sql.append(" where BgCslOrgSeq.FOrgTreeID = '").append(orgTreeID).append("' ");
        sql.append(" and BgCslOrgSeq.FOrgUnitGroupID = '").append(orgGroupID).append("' ");
        sql.append(" and BgCslOrgSeq.FBgSchemeID = '").append(bgSchemeID).append("' ");
        sql.append(" order by Entry.FSeq asc ");
        IRowSet iRowSet2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String bgCslOrgSeqID = "";
        LinkedList orgUnitList = new LinkedList();
        if (iRowSet2.size() > 0) {
            boolean first = true;
            try {
                while (iRowSet2.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    if (first) {
                        bgCslOrgSeqID = iRowSet2.getString("BgCslOrgSeqID");
                        first = false;
                    }
                    row.put(Entry_ID, iRowSet2.getString(Entry_ID));
                    row.put(OrgUnit_ID, iRowSet2.getString(OrgUnit_ID));
                    row.put(OrgUnit_Name, iRowSet2.getString(OrgUnit_Name));
                    row.put(OrgUnit_SimpleName, iRowSet2.getString(OrgUnit_SimpleName));
                    row.put(OrgUnit_Number, iRowSet2.getString(OrgUnit_Number));
                    row.put(OrgUnit_LongNumber, iRowSet2.getString(OrgUnit_LongNumber));
                    row.put(OrgUnit_IsGrouping, iRowSet2.getBoolean("OrgUnitGrouping"));
                    row.put(Seq, new Integer(iRowSet2.getInt(Seq)));
                    orgUnitList.add(row);
                }
            }
            catch (SQLException e) {
                throw new BOSException();
            }
        }
        if (StringUtils.isEmpty((String)bgCslOrgSeqID)) {
            String sql1 = "select FID from T_MBG_BgCslOrgSeq where FOrgTreeID = '" + orgTreeID + "' and FOrgUnitGroupID = '" + orgGroupID + "' and FBgSchemeID = '" + bgSchemeID + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql1);
            if (rowSet.size() == 0) {
                bgCslOrgSeqID = Uuid.create().toString();
                sql1 = "insert into T_MBG_BgCslOrgSeq(FID, FOrgTreeID, FOrgUnitGroupID, FBgSchemeID)values('" + bgCslOrgSeqID + "', '" + orgTreeID + "', '" + orgGroupID + "', '" + bgSchemeID + "')";
                DbUtil.execute((Context)ctx, (String)sql1);
            } else {
                try {
                    rowSet.next();
                    bgCslOrgSeqID = rowSet.getString("FID");
                }
                catch (SQLException e) {
                    throw new BOSException();
                }
            }
        }
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        returnValue.put(BgCslOrgSeq_ID, bgCslOrgSeqID);
        returnValue.put(OrgUnitList, orgUnitList);
        return returnValue;
    }

    public static List getSysOrgUnitList(Context ctx, String orgUnitGroupID, String treeID) throws BOSException, EASBizException {
        LinkedList sysOrgUnitList = new LinkedList();
        if (ctx == null || StringUtils.isEmpty((String)orgUnitGroupID) || StringUtils.isEmpty((String)treeID)) {
            return sysOrgUnitList;
        }
        String language = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append(" Select unit.FID unitId,  unit.FNAME_").append(language).append(" unitName, unit.FNumber unitNumber, unit.FSimpleName unitSimpleName, unit.FLongNumber unitLongNumber, unit.FIsGrouping unitGrouping").append(" From T_ORG_STRUCTURE stru ").append(" INNER JOIN T_ORG_TREE tree ON stru.FTREEID = tree.FID ").append(" INNER JOIN T_ORG_BASEUNIT unit ON stru.FUNITID = unit.FID ").append(" WHERE tree.FID = ? ").append(" AND stru.FPARENTID = ? ").append(" AND (unit.FISGROUPING  = 1 or unit.FISCOSTORGUNIT  = 1) ").append(" ORDER BY unit.FNUMBER ASC ");
        OrgStructureInfo strucInfo = BgCslOrgSeqHelper.getOrgStructureByUnit(ctx, orgUnitGroupID, treeID);
        IRowSet rowSet = null;
        if (strucInfo != null) {
            Object[] params = new Object[]{treeID, strucInfo.getId().toString()};
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        }
        if (rowSet != null) {
            HashMap<String, Object> orgUnit = null;
            try {
                while (rowSet.next()) {
                    orgUnit = new HashMap<String, Object>();
                    orgUnit.put(OrgUnit_ID, rowSet.getString("unitId"));
                    orgUnit.put(OrgUnit_Name, rowSet.getString("unitName"));
                    orgUnit.put(OrgUnit_Number, rowSet.getString("unitNumber"));
                    orgUnit.put(OrgUnit_SimpleName, rowSet.getString("unitSimpleName"));
                    orgUnit.put(OrgUnit_LongNumber, rowSet.getString("unitLongNumber"));
                    orgUnit.put(OrgUnit_IsGrouping, rowSet.getBoolean("unitGrouping"));
                    sysOrgUnitList.add(orgUnit);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return sysOrgUnitList;
    }
}

