/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bgcsl.utils.BgNWorkTemplateHelper;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgCslSchemeDimensionHelper
extends BgSchemeDimensionHelper {
    private static final long serialVersionUID = -3049713064525975872L;
    private String bgSchemeOrgId = null;
    private OrgTreeInfo currentOrgTree = null;

    public OrgTreeInfo getCurrentOrgTreeId() {
        return this.currentOrgTree;
    }

    public void setCurrentOrgTreeId(OrgTreeInfo currentOrgTree) {
        this.currentOrgTree = currentOrgTree;
    }

    public BgCslSchemeDimensionHelper(Context ctx, String bgSchemeId, String bgSchemeOrgId) throws EASBizException, BOSException {
        super(ctx, bgSchemeId);
        this.bgSchemeOrgId = bgSchemeOrgId;
    }

    public BgCslSchemeDimensionHelper(String bgSchemeId) throws EASBizException, BOSException {
        super(null, bgSchemeId);
    }

    public BgCslSchemeDimensionHelper(Context ctx, String bgSchemeId) throws EASBizException, BOSException {
        super(ctx, bgSchemeId);
    }

    public BgCslSchemeDimensionHelper(String bgSchemeId, OrgTreeInfo currentOrgTree) throws EASBizException, BOSException {
        this(null, bgSchemeId, false, currentOrgTree);
    }

    public BgCslSchemeDimensionHelper(Context ctx, String bgSchemeId, OrgTreeInfo currentOrgTree) throws EASBizException, BOSException {
        this(ctx, bgSchemeId, false, currentOrgTree);
    }

    public BgCslSchemeDimensionHelper(Context ctx, String str, boolean isNumber, OrgTreeInfo currentOrgTree) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.currentOrgTree = currentOrgTree;
        this.init(str, isNumber);
    }

    public boolean isBgCsl() {
        return true;
    }

    protected void initOrgViewId(BgDimensionInfo dimension, BOSUuid orgViewId) {
        if (this.currentOrgTree != null && this.currentOrgTree.getId() != null) {
            dimension.setViewId(this.currentOrgTree.getId().toString());
        } else {
            super.initOrgViewId(dimension, orgViewId);
        }
    }

    public BgDimensionInfo getDimension(String dimNumber) {
        BgDimensionInfo dimension = super.getDimension(dimNumber);
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber) && this.currentOrgTree != null && this.currentOrgTree.getId() != null) {
            dimension.setAlias(EASResource.getString((String)BgNWorkTemplateHelper.RES, (String)"bizOrgUnit"));
            dimension.setName(EASResource.getString((String)BgNWorkTemplateHelper.RES, (String)"bizOrgUnit"));
            dimension.setViewId(this.currentOrgTree.getId().toString());
        }
        return dimension;
    }

    public String getBgSchemeOrgId(Context ctx) throws BOSException, EASBizException {
        if (this.bgSchemeOrgId == null) {
            IBgScheme is = null;
            is = ctx == null ? BgSchemeFactory.getRemoteInstance() : BgSchemeFactory.getLocalInstance((Context)ctx);
            this.bgSchemeOrgId = is.getBgSchemeInfo("select orgUnit.id where id = '" + this.getBgSchemeId() + "'").getOrgUnit().getId().toString();
        }
        return this.bgSchemeOrgId;
    }

    public void checkCombination(String strItemCombi, boolean isMustAllDim, boolean ischeckAccount, Map<String, Set<String>> filterValueMap) throws BgTemplateException {
        BgTemplateException ex = null;
        ex = this.isBgCsl() ? (ischeckAccount ? new BgTemplateException(BgTemplateException.NEEDALLDIMCSL) : new BgTemplateException(BgTemplateException.NEEDALLDIMNOINDEXCSL)) : (ischeckAccount ? new BgTemplateException(BgTemplateException.NEEDALLDIM) : new BgTemplateException(BgTemplateException.NEEDALLDIMNOINDEX));
        if (StringUtils.isEmpty((String)strItemCombi)) {
            throw ex;
        }
        if (ischeckAccount) {
            // empty if block
        }
        List dimNumbers = this.getAccAndOtherDim(true);
        if (!ischeckAccount) {
            dimNumbers.remove(DimensionConstants.DEF_INDEX_SRCNUMBER);
            dimNumbers.remove(DimensionConstants.DEF_CSL_SRCNUMBER);
            dimNumbers.remove(DimensionConstants.DEF_CSL_Consolidation);
        }
        if (isMustAllDim && filterValueMap != null && !filterValueMap.isEmpty()) {
            Set<String> filterSrcSet = filterValueMap.keySet();
            String filterSrc = null;
            Iterator ite = dimNumbers.iterator();
            while (ite.hasNext()) {
                filterSrc = (String)ite.next();
                if (filterSrcSet.contains(filterSrc)) continue;
                ite.remove();
            }
        }
        String[] items = DimensionFormulaHelper.splitCombinations((String)strItemCombi);
        if (isMustAllDim) {
            for (int s = 0; s < items.length; ++s) {
                dimNumbers.remove(items[s]);
            }
            if (dimNumbers.size() > 0) {
                Object[] o = dimNumbers.toArray();
                String dimNumber = o[0].toString();
                String exce = this.getDimension(dimNumber).getName();
                throw new BgTemplateException(BgTemplateException.LACKOFDIMENSION, (Object[])new String[]{exce});
            }
        }
        if (dimNumbers.size() != 0) {
            for (int s = 0; s < items.length; ++s) {
                if (dimNumbers.contains(DimensionFormulaHelper.getSrcNumber((String)items[s]))) continue;
                throw ex;
            }
        }
    }
}

