/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.mbg.utils.IBgSetOrgUnitAdapter;
import com.kingdee.eas.ma.mbg.utils.IGetBgSchemeNumber;
import com.kingdee.util.PropertyContainer;
import java.util.Date;

public class MbgWorkRptReportPropertyAdapter
implements IReportPropertyAdapter,
IGetBgSchemeNumber,
IBgSetOrgUnitAdapter {
    private static final long serialVersionUID = -1424425780375012957L;
    public static final String Scheme_Name = "Scheme.Name";
    public static final String Scheme_Id = "Scheme.Id";
    public static final String Scheme_Number = "Scheme_Number";
    public static final String BG_COST_CENTER_NUMBER = "BgCostCenterNum";
    public static final String BG_PERIOD_TYPE = "BG_PERIOD_TYPE";
    public static final String BG_PERIOD_YEAR = "BG_PERIOD_YEAR";
    public static final String BG_PERIOD_MONTH = "BG_PERIOD_MONTH";
    public static final String BG_PERIOD_ID = "BG_PERIOD_ID";
    public static final String BG_PERIOD_NUMBER = "BG_PERIOD_NUMBER";
    public static final String BG_VERSION_NUMBER = "BG_VERSION_NUMBER";
    public static final String BG_ORG_ID = "BG_ORG_ID";
    public static final String BG_FORM_ID = "BG_FORM_ID";
    public static final String BG_ORG_NUMBER = "BG_ORG_NUMBER";
    public static final String BG_ORG_NAME = "BG_ORG_NAME";
    public static final String BG_SCHEME_NUMBER = "BG_SCHEME_NUMBER";
    public static final String Bg_Begin_Date = "bg_begin_date";
    public static final String Bg_End_Date = "bg_end_date";
    public static final String BG_TEMPLATE_ID = "BG_TEMPLATE_ID";
    public static final String BG_Create_Date = "bg_create_date";
    public static final String BG_ORGTREE_ID = "BG_ORGTREE_ID";
    private FullOrgUnitInfo orgUnit = null;
    private PropertyContainer p;
    private String orgTreeNumber = null;

    public void setOrgTreeNumber(String orgTreeNumber) {
        this.orgTreeNumber = orgTreeNumber;
    }

    public MbgWorkRptReportPropertyAdapter(MbgWorkPaperInfo report) {
        this.setProperties(report);
    }

    private void setProperties(MbgWorkPaperInfo report) {
        if (this.p == null) {
            this.p = new PropertyContainer();
        }
        if (report.getBgScheme() != null && report.getBgScheme().getId() != null) {
            this.p.setString(Scheme_Name, report.getBgScheme().getName());
            this.p.setString(Scheme_Id, report.getBgScheme().getId().toString());
            this.p.setString(Scheme_Number, report.getBgScheme().getNumber());
            this.p.setString(BG_SCHEME_NUMBER, report.getBgScheme().getNumber());
        }
        this.p.setString("CSLReport_OrgTree_Number", this.orgTreeNumber);
        this.p.setString("CSLReport_OrgUnit_Group", report.getOrgUnit().getNumber());
        this.p.setString("OrgUnit.Number", report.getOrgUnit().getNumber());
        if (report.getSourceType() != null) {
            this.p.setInt("Report.SourceType", report.getSourceType().getValue());
        }
        if (report.getOrgTree() != null) {
            this.p.setString("CSLReport_OrgTree_ID", report.getOrgTree().getId().toString());
        }
        if (report.getBgVersion() != null) {
            this.p.setString(BG_VERSION_NUMBER, report.getBgVersion().getNumber());
        }
        if (report.getOrgTree() != null && report.getOrgTree().getId() != null) {
            this.p.setString(BG_ORGTREE_ID, report.getOrgTree().getId().toString());
        }
        BgPeriodInfo period = report.getBgPeriod();
        if (report.getBgPeriod() != null) {
            if (report.getBgPeriod().getBeginDate() != null) {
                this.p.setString(Bg_Begin_Date, String.valueOf(report.getBgPeriod().getBeginDate()));
            }
            if (report.getBgPeriod().getEndDate() != null) {
                this.p.setString(Bg_End_Date, String.valueOf(report.getBgPeriod().getEndDate()));
            }
        }
        this.p.setDate(BG_Create_Date, report.getCreateTime() != null ? new Date(report.getCreateTime().getTime()) : new Date());
        if (period != null) {
            String id = period.getId().toString();
            BgPeriodEnum periodType = period.getPeriodType();
            int year = period.getYear();
            int halfYear = period.getHalfYear();
            int month = period.getMonth();
            int quart = period.getQuarter();
            this.p.setString(BG_PERIOD_ID, id);
            this.p.setString(BG_PERIOD_NUMBER, period.getNumber());
            if (period.getPeriodType() != null) {
                this.p.setInt(BG_PERIOD_TYPE, period.getPeriodType().getValue());
                this.p.setInt(BG_PERIOD_YEAR, period.getYear());
            }
            if (periodType != null) {
                if (periodType.getValue() == 1) {
                    report.setPeriodType(RptPeriodTypeEnum.YEARLY);
                    report.setYear(year);
                    report.setPeriod((short)1);
                } else if (periodType.getValue() == 2) {
                    report.setPeriodType(RptPeriodTypeEnum.SEMIYEARLY);
                    report.setYear(year);
                    report.setPeriod((short)halfYear);
                    this.p.setInt(BG_PERIOD_MONTH, period.getHalfYear());
                } else if (periodType.getValue() == 3) {
                    report.setPeriodType(RptPeriodTypeEnum.QUARTERLY);
                    report.setYear(year);
                    report.setPeriod((short)quart);
                    this.p.setInt(BG_PERIOD_MONTH, period.getQuarter());
                } else if (periodType.getValue() == 4) {
                    report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    report.setYear(year);
                    report.setPeriod((short)month);
                    this.p.setInt(BG_PERIOD_MONTH, period.getMonth());
                } else if (periodType.getValue() == 5 || periodType.getValue() == 6) {
                    report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    report.setYear(year);
                    report.setPeriod((short)month);
                    this.p.setInt(BG_PERIOD_MONTH, period.getWeek());
                }
            }
        }
        if (report.getCurrency() != null) {
            this.p.setString("Currency.Number", report.getCurrency().getNumber());
        }
        this.p.setInt("Report.Year", report.getYear());
        this.p.setInt("Report.Period", (int)report.getPeriod());
    }

    public Object getReportProperty(String name) {
        return this.p.get(name);
    }

    public void initReportProperties(IObjectValue vo, Context ctx) {
        if (vo instanceof MbgWorkPaperInfo) {
            this.setProperties((MbgWorkPaperInfo)vo);
        }
    }

    public String getBgSchemeNumber() {
        return this.p.getString(Scheme_Number);
    }

    public void setOrgUnit(FullOrgUnitInfo orgUnit) {
        this.p.setString(BG_ORG_ID, orgUnit == null ? "" : orgUnit.getId().toString());
        this.p.setString(BG_ORG_NUMBER, orgUnit == null ? "" : orgUnit.getNumber());
        this.p.setString(BG_ORG_NAME, orgUnit == null ? "" : orgUnit.getName());
        this.orgUnit = orgUnit;
    }
}

