/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.utils.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.bgcsl.utils.data.UnionBaseDataUtils;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UnionAdjDataUtils
extends UnionBaseDataUtils {
    private static final Logger logger = Logger.getLogger(UnionAdjDataUtils.class);

    public UnionAdjDataUtils(TempTablePool pool) {
        super(pool);
    }

    public void audit(Context ctx, Connection conn, BgSchemeInfo schemeInfo, IDimDataQuery dimDataQuery, Map<String, String> auditParams, Map<String, Map<String, String[]>> result) throws BOSException, EASBizException {
        if (ctx == null || conn == null || schemeInfo == null || dimDataQuery == null || this.pool == null) {
            return;
        }
        String cfsCube = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
        String adjCube = BgCubeUtils.getCFSAdjustCubeName((String)schemeInfo.getRefCube());
        String adjEntryCube = BgCubeUtils.getCFSAdjustEntryCubeName((String)schemeInfo.getRefCube());
        if (auditParams == null) {
            auditParams = new HashMap<String, String>();
        }
        String audOrgUnitId = auditParams.containsKey("ORGUNIT_AUDIT_ID") ? auditParams.get("ORGUNIT_AUDIT_ID") : dimDataQuery.getBizOrgUnit().getId().toString();
        String audUserId = auditParams.containsKey("USER_ID") ? auditParams.get("USER_ID") : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String unionId = dimDataQuery.getBizUnionId().toString();
        String orgUnitid = dimDataQuery.getBizOrgUnit().getId().toString();
        int versionId = dimDataQuery.getBizVersion().getVersionId();
        boolean onlyDealCurBgForm = dimDataQuery.isOnlyDealCurBgForm();
        Map mbgMemberMap = null;
        List refFields = schemeInfo.getRefFields(conn, 64);
        StringBuffer sql = new StringBuffer();
        try {
            mbgMemberMap = this.parseMember(ctx, conn, schemeInfo, dimDataQuery);
            if (mbgMemberMap != null && !mbgMemberMap.isEmpty()) {
                sql.append("update " + adjCube + " set FValue = (select FValue from " + cfsCube + " where FUnionId = " + adjCube + ".FUnionId and FOrgUnitId = " + adjCube + ".FOrgUnitId and FFormula = " + adjCube + ".FFormula and FVersion = " + adjCube + ".FVersion) where FUnionId = ? and FOrgUnitId = ? and F100 = ? and FVersion = ? and FState = ? ");
                if (onlyDealCurBgForm) {
                    sql.append(" and exists (select FDataID from " + adjEntryCube + " where FFormId = '" + dimDataQuery.getId().toString() + "' and FDataId = " + adjCube + ".FID)");
                } else {
                    sql.append(" and exists (select FNumber from " + this.tmpBgIndex + " where FNumber = " + adjCube + ".F2)  and exists (select FID from " + this.tmpBgPeriod + " where FID = " + adjCube + ".FBgPeriodID)  and exists (select FID from " + this.tmpBgElement + " where FID = " + adjCube + ".FBgElementID)  and exists (select FID from " + this.tmpCurrency + " where FID = " + adjCube + ".FCurrencyID)  and exists (select FID from " + this.tmpScenario + " where FID = " + adjCube + ".FScenario) ");
                }
                sql.append(" and exists (select FID from " + cfsCube + " where FUnionId = " + adjCube + ".FUnionId and FOrgUnitId = " + adjCube + ".FOrgUnitId and FFormula = " + adjCube + ".FFormula and FVersion = " + adjCube + ".FVersion and FState = ?)");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, orgUnitid, BgCslDimConstants.csl08, versionId, 1, 9});
                sql.setLength(0);
                sql.append("update " + adjCube + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ?  where FUnionId = ? and FOrgUnitId = ?  and F100 IN ('" + BgCslDimConstants.csl05 + "','" + BgCslDimConstants.csl06 + "','" + BgCslDimConstants.csl07 + "','" + BgCslDimConstants.csl08 + "') ");
                if (onlyDealCurBgForm) {
                    sql.append(" and exists (select FDataID from " + adjEntryCube + " where FFormId = '" + dimDataQuery.getId().toString() + "' and FDataId = " + adjCube + ".FID)");
                } else {
                    sql.append(" and exists (select FNumber from " + this.tmpBgIndex + " where FNumber = " + adjCube + ".F2)  and exists (select FID from " + this.tmpBgPeriod + " where FID = " + adjCube + ".FBgPeriodID)  and exists (select FID from " + this.tmpBgElement + " where FID = " + adjCube + ".FBgElementID)  and exists (select FID from " + this.tmpCurrency + " where FID = " + adjCube + ".FCurrencyID)  and exists (select FID from " + this.tmpScenario + " where FID = " + adjCube + ".FScenario) ");
                }
                sql.append(" and FVersion = ? and FState = ? ");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{5, audOrgUnitId, audUserId, unionId, orgUnitid, versionId, 1});
                sql.setLength(0);
                sql.append("update " + cfsCube + " set FValue = (select FValue from " + adjCube + " where FUnionId = " + cfsCube + ".FUnionId and FOrgUnitId = " + cfsCube + ".FOrgUnitId and FFormula = " + cfsCube + ".FFormula and FVersion = " + cfsCube + ".FVersion), FState = ?  where FUnionId = ? and FOrgUnitId = ?  and F100 IN ('" + BgCslDimConstants.csl05 + "','" + BgCslDimConstants.csl06 + "','" + BgCslDimConstants.csl07 + "','" + BgCslDimConstants.csl08 + "') ");
                sql.append(" and exists (select FNumber from " + this.tmpBgIndex + " where FNumber = " + cfsCube + ".F2)  and exists (select FID from " + this.tmpBgPeriod + " where FID = " + cfsCube + ".FBgPeriodID)  and exists (select FID from " + this.tmpBgElement + " where FID = " + cfsCube + ".FBgElementID)  and exists (select FID from " + this.tmpCurrency + " where FID = " + cfsCube + ".FCurrencyID)  and exists (select FID from " + this.tmpScenario + " where FID = " + cfsCube + ".FScenario) ");
                sql.append(" and FVersion = ? and FState IN (1,5) and exists (select FID from " + adjCube + " where FUnionId = " + cfsCube + ".FUnionId  and FOrgUnitId = " + cfsCube + ".FOrgUnitId and FFormula = " + cfsCube + ".FFormula and FVersion = " + cfsCube + ".FVersion)");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{5, unionId, orgUnitid, versionId});
                sql.setLength(0);
                sql.append("Insert Into " + cfsCube + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FUnionID, FOrgUnitID , FFormula, FValue, FTmpValue");
                for (String field : refFields) {
                    sql.append(", " + field);
                }
                sql.append(", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FAudOrgUnitID, FAudUserID, FReportOrgUnitID) Select FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FUnionID, FOrgUnitID , FFormula, FValue, FTmpValue");
                for (String field : refFields) {
                    sql.append(", " + field);
                }
                sql.append(", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FAudOrgUnitID, FAudUserID, FReportOrgUnitID from " + adjCube + " where FUnionId = ? and FOrgUnitId = ?  and F100 IN ('" + BgCslDimConstants.csl05 + "','" + BgCslDimConstants.csl06 + "','" + BgCslDimConstants.csl07 + "','" + BgCslDimConstants.csl08 + "') ");
                if (onlyDealCurBgForm) {
                    sql.append(" and exists (select FDataID from " + adjEntryCube + " where FFormId = '" + dimDataQuery.getId().toString() + "' and FDataId = " + adjCube + ".FID)");
                } else {
                    sql.append(" and exists (select FNumber from " + this.tmpBgIndex + " where FNumber = " + adjCube + ".F2)  and exists (select FID from " + this.tmpBgPeriod + " where FID = " + adjCube + ".FBgPeriodID)  and exists (select FID from " + this.tmpBgElement + " where FID = " + adjCube + ".FBgElementID)  and exists (select FID from " + this.tmpCurrency + " where FID = " + adjCube + ".FCurrencyID)  and exists (select FID from " + this.tmpScenario + " where FID = " + adjCube + ".FScenario) ");
                }
                sql.append(" and FVersion = ? and FState = ?  and not exists (select FID from " + cfsCube + " where FUnionID = " + adjCube + ".FUnionID and FOrgUnitID = " + adjCube + ".FOrgUnitID and FFormula = " + adjCube + ".FFormula and FVersion = " + adjCube + ".FVersion)");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, orgUnitid, versionId, 5});
            }
            sql.setLength(0);
            sql.append("update T_MBG_BgCslAdjForm set FState = ?, FAuditorID = ?, FAuditedTime = ? where FID = ? and FState = ?");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{2, audUserId, new Timestamp(System.currentTimeMillis()), dimDataQuery.getId().toString(), 1});
        }
        catch (SQLException ex) {
            logger.error((Object)"cslAdjForm audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            this.clear();
        }
    }

    public void unAudit(Context ctx, Connection conn, BgSchemeInfo schemeInfo, IDimDataQuery dimDataQuery, Map<String, String> auditParams, Map<String, Map<String, String[]>> result) throws BOSException, EASBizException {
        if (ctx == null || conn == null || schemeInfo == null || dimDataQuery == null || this.pool == null) {
            return;
        }
        String cfsCube = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
        String adjCube = BgCubeUtils.getCFSAdjustCubeName((String)schemeInfo.getRefCube());
        String adjEntryCube = BgCubeUtils.getCFSAdjustEntryCubeName((String)schemeInfo.getRefCube());
        if (auditParams == null) {
            auditParams = new HashMap<String, String>();
        }
        String audOrgUnitId = auditParams.containsKey("ORGUNIT_AUDIT_ID") ? auditParams.get("ORGUNIT_AUDIT_ID") : dimDataQuery.getBizOrgUnit().getId().toString();
        String audUserId = auditParams.containsKey("USER_ID") ? auditParams.get("USER_ID") : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String unionId = dimDataQuery.getBizUnionId().toString();
        String orgUnitid = dimDataQuery.getBizOrgUnit().getId().toString();
        int versionId = dimDataQuery.getBizVersion().getVersionId();
        boolean onlyDealCurBgForm = dimDataQuery.isOnlyDealCurBgForm();
        Map mbgMemberMap = null;
        HashMap<String, String[]> dataStateMap = new HashMap<String, String[]>();
        result.put("CHECK_GETDATA", dataStateMap);
        StringBuffer sql = new StringBuffer();
        IRowSet rst = null;
        try {
            mbgMemberMap = this.parseMember(ctx, conn, schemeInfo, dimDataQuery);
            if (mbgMemberMap != null && !mbgMemberMap.isEmpty()) {
                sql.append("select top 1 FID from " + cfsCube + " where FUnionId = ? and FOrgUnitId = ?  and exists (select FNumber from " + this.tmpBgIndex + " where FNumber = " + cfsCube + ".F2)  and F100 = '" + BgCslDimConstants.csl08 + "'  and exists (select FID from " + this.tmpBgPeriod + " where FID = " + cfsCube + ".FBgPeriodID)  and exists (select FID from " + this.tmpBgElement + " where FID = " + cfsCube + ".FBgElementID)  and exists (select FID from " + this.tmpCurrency + " where FID = " + cfsCube + ".FCurrencyID)  and exists (select FID from " + this.tmpScenario + " where FID = " + cfsCube + ".FScenario)  and FVersion = ? and FState IN (" + 9 + "," + 11 + "," + 13 + ")");
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, orgUnitid, versionId});
                if (rst.next()) {
                    dataStateMap.put(dimDataQuery.getId().toString(), new String[]{dimDataQuery.getNumber(), dimDataQuery.getName()});
                }
                SQLUtils.cleanup((ResultSet)rst);
                if (dataStateMap.isEmpty()) {
                    sql.setLength(0);
                    sql.append("update " + adjCube + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ?  where FUnionId = ? and FOrgUnitId = ?  and F100 IN ('" + BgCslDimConstants.csl05 + "','" + BgCslDimConstants.csl06 + "','" + BgCslDimConstants.csl07 + "','" + BgCslDimConstants.csl08 + "') ");
                    if (onlyDealCurBgForm) {
                        sql.append(" and exists (select FDataID from " + adjEntryCube + " where FFormId = '" + dimDataQuery.getId().toString() + "' and FDataId = " + adjCube + ".FID)");
                    } else {
                        sql.append(" and exists (select FNumber from " + this.tmpBgIndex + " where FNumber = " + adjCube + ".F2)  and exists (select FID from " + this.tmpBgPeriod + " where FID = " + adjCube + ".FBgPeriodID)  and exists (select FID from " + this.tmpBgElement + " where FID = " + adjCube + ".FBgElementID)  and exists (select FID from " + this.tmpCurrency + " where FID = " + adjCube + ".FCurrencyID)  and exists (select FID from " + this.tmpScenario + " where FID = " + adjCube + ".FScenario) ");
                    }
                    sql.append(" and FVersion = ? and FState = ?");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{1, null, null, unionId, orgUnitid, versionId, 5});
                    sql.setLength(0);
                    sql.append("update " + cfsCube + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ?  where FUnionId = ? and FOrgUnitId = ?  and F100 IN ('" + BgCslDimConstants.csl05 + "','" + BgCslDimConstants.csl06 + "','" + BgCslDimConstants.csl07 + "','" + BgCslDimConstants.csl08 + "') ");
                    sql.append(" and exists (select FNumber from " + this.tmpBgIndex + " where FNumber = " + cfsCube + ".F2)  and exists (select FID from " + this.tmpBgPeriod + " where FID = " + cfsCube + ".FBgPeriodID)  and exists (select FID from " + this.tmpBgElement + " where FID = " + cfsCube + ".FBgElementID)  and exists (select FID from " + this.tmpCurrency + " where FID = " + cfsCube + ".FCurrencyID)  and exists (select FID from " + this.tmpScenario + " where FID = " + cfsCube + ".FScenario) ");
                    sql.append(" and FVersion = ? and FState = ?");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{1, null, null, unionId, orgUnitid, versionId, 5});
                }
            }
            sql.setLength(0);
            sql.append("update T_MBG_BgCslAdjForm set FState = ?, FAuditorID = ?, FAuditedTime = ? where FID = ? and FState = ?");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{1, audUserId, new Timestamp(System.currentTimeMillis()), dimDataQuery.getId().toString(), 2});
        }
        catch (SQLException ex) {
            logger.error((Object)"cslAdjForm audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
            this.clear();
        }
    }

    protected void getScenrioTmpTable(Connection conn, List<Object> tmpList) throws SQLException {
        BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + this.tmpScenario + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ") "), tmpList);
    }
}

