/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.utils.data;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.data.AuditParam;
import com.kingdee.eas.ma.mbg.utils.data.BackBiz;
import com.kingdee.eas.ma.mbg.utils.data.BizMbgDataControlUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class UnionBack
extends BackBiz {
    private static final Logger logger = Logger.getLogger(UnionBack.class);

    public UnionBack(BizMbgDataControlUtils utils) {
        super(utils);
    }

    protected List<String> filterBillIds(List<String> billIds) {
        ArrayList<String> _billIds = new ArrayList<String>();
        if (billIds == null || billIds.isEmpty()) {
            return _billIds;
        }
        String bosType = null;
        for (String billId : billIds) {
            bosType = BOSUuid.read((String)billId).getType().toString();
            if (!"655ADD42".equals(bosType) && !"9E7BD5E2".equals(bosType)) continue;
            _billIds.add(billId);
        }
        return _billIds;
    }

    protected String getMethodName(AuditParam param) {
        return "csl_bgform_back";
    }

    protected String getLogItemName(AuditParam param) {
        return "csl_bgform_back";
    }

    protected String getCubeName(AuditParam param) {
        return BgCubeUtils.getCFSCubeName((String)param.bgScheme.getRefCube());
    }

    protected String getEntryName(AuditParam param) {
        return BgCubeUtils.getCFSEntryCubeName((String)param.bgScheme.getRefCube());
    }

    protected void queryAudOrgUnit(Context ctx, Connection conn, AuditParam param) throws Exception {
    }

    protected BgOrgUnitInfo queryOrgUnit(Context ctx, Connection conn, AuditParam param, BOSUuid orgUnitId) throws Exception {
        return null;
    }

    protected List<String> getParentOrgUnitIds(Context ctx, Connection conn, AuditParam param) throws Exception {
        ArrayList<String> pOrgUnitIds = new ArrayList<String>();
        return pOrgUnitIds;
    }

    protected List<String> getChildOrgUnitIds(Context ctx, Connection conn, BgOrgUnitInfo bgOrgUnit, AuditParam param) throws Exception {
        ArrayList<String> cOrgUnitIds = new ArrayList<String>();
        return cOrgUnitIds;
    }

    protected List<IDimDataQuery> getModels(Connection conn, IDimDataQuery model, AuditParam param) throws Exception {
        ArrayList<IDimDataQuery> models = new ArrayList<IDimDataQuery>();
        models.add(model);
        return models;
    }

    protected boolean checkAllData(Context ctx, Connection conn, IDimDataQuery model, List<IDimDataQuery> models, List<String> cOrgUnitIds, List<String> pOrgUnitIds, AuditParam param, Map<String, Object> result, boolean isOnlyDealCurBgForm) throws Exception {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasData(Connection conn, AuditParam param, BOSUuid orgUnitId, Map<String, Object> result) throws Exception {
        boolean hasData = true;
        if (conn == null || param == null || orgUnitId == null) {
            return hasData;
        }
        IRowSet rst = null;
        try {
            for (String cubeName : param.cubes) {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select top 1 FOrgUnitId from " + cubeName + " where FUnionID = ? and FOrgUnitId = ?"), (Object[])new Object[]{param.unionId, orgUnitId.toString()});
                if (rst.next()) {
                    hasData = true;
                    break;
                }
                hasData = false;
            }
        }
        finally {
            SQLUtils.cleanup(rst);
        }
        return hasData;
    }

    protected List<String> getAudOrgUnitIds(Context ctx, Connection conn, BgOrgUnitInfo bgOrgUnit, AuditParam param) throws Exception {
        ArrayList<String> audOrgUnitIds = new ArrayList<String>();
        return audOrgUnitIds;
    }

    protected void updateBaseData(Context ctx, Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param) throws Exception {
        if (ctx == null || conn == null || model == null || orgUnitIds == null || pOrgUnitIds == null || param == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        int[] dataStates = this.getDataStates(param);
        try {
            for (String cubeName : param.cubes) {
                sql.setLength(0);
                sql.append("update " + cubeName + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ?, FReportOrgUnitID = ?  where FUnionID = ? and FOrgUnitID = ? and exists (select FDataId from " + param.cubeEntry + " where FFormId = ? and FDataId = " + cubeName + ".FID)  and FState IN " + this.getSqlStates(dataStates) + " and FScenario IN (select FScenarioId from T_MBG_BgScenario) ");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{param.audState, null, null, null, param.unionId, model.getBizOrgUnit().getId().toString(), model.getId().toString()});
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    protected void updateViewData(Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param) throws Exception {
        if (conn == null || model == null || orgUnitIds == null || pOrgUnitIds == null || param == null) {
            return;
        }
        Object[] sqlParams = null;
        StringBuffer sql = new StringBuffer();
        int[] dataStates = this.getDataStates(param);
        try {
            for (String cubeName : param.cubes) {
                sql.setLength(0);
                sql.append("update " + cubeName + " set FState = ? , FAudOrgUnitID = ?, FAudUserID = ?, FReportOrgUnitID = ? where FUnionId = ? and FOrgUnitId = ?  and exists (select FNumber from " + param.getTmpBgIndex() + " where " + param.getField("FNumber") + " = " + cubeName + ".F2)  and exists (select " + param.getField("FID") + " from " + param.getTmpBgPeriod() + " where " + param.getField("FID") + " = " + cubeName + ".FBgPeriodID)  and exists (select " + param.getField("FID") + " from " + param.getTmpBgElement() + " where " + param.getField("FID") + " = " + cubeName + ".FBgElementID)  and exists (select " + param.getField("FID") + " from " + param.getTmpCurrency() + " where FID = " + cubeName + ".FCurrencyID)  and exists (select " + param.getField("FID") + " from " + param.getTmpScenario() + " where FID = " + cubeName + ".FScenario)  and FVersion = ?  and FState IN " + this.getSqlStates(dataStates));
                sqlParams = new Object[]{param.audState, null, null, null, param.unionId, model.getBizOrgUnit().getId().toString(), model.getBizVersion().getVersionId()};
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    protected void updateFormData(Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, AuditParam param) throws Exception {
        if (conn == null || model == null || param == null) {
            return;
        }
        String sql = "update T_MBG_BgCslForm set FState = ?, FAuditorID = ?, FAuditedTime = ? where FID = ?";
        Object[] sqlParams = new Object[]{param.audFormState, param.audUserId, new Timestamp(System.currentTimeMillis()), model.getId().toString()};
        try {
            BgDBUtils.executeUpdate((Connection)conn, (String)sql, (Object[])sqlParams);
        }
        catch (SQLException ex) {
            logger.error((Object)"audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    protected void updateAuditRecord(Context ctx, Connection conn, Locale locale, IDimDataQuery model, Map<String, String> auditParams, AuditParam param) throws Exception {
    }

    protected String getScenSql() {
        return " and FScenario IN (select FScenarioId from T_MBG_BgScenario) ";
    }

    protected void insertParamForScen(Connection conn, AuditParam param, List<Object> tmpList) throws Exception {
        BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + param.getTmpScenario() + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
    }
}

