/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.biz.app.AbstractBizCalcSetUIHandler;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgOrgView;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.MbgUpdateFacadeFactory;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BizCalcSetUIHandler
extends AbstractBizCalcSetUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        String OUID = (String)request.get(BgBaseConstants.ORGUNIT_ID);
        MbgUpdateFacadeFactory.getLocalInstance((Context)context).checkUpdated();
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance((Context)context);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Date date = null;
        try {
            date = sdf.parse(sdf.format(new Date()));
        }
        catch (ParseException e) {
            date = new Date();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)OUID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isFormal", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dateFrom", (Object)date, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dateTo", (Object)date, CompareType.GREATER_EQUALS));
        view.setFilter(filter);
        BgSchemeCollection colls = iBgScheme.getBgSchemeCollection(view);
        if (colls != null && !colls.isEmpty()) {
            BgSchemeInfo schemeInfo = colls.get(0);
            if ((schemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeInfo.getId()), BgSchemeUtils.getBizSelectors())) != null) {
                BOSUuid bgOrgViewId = schemeInfo.getEditOrgViewId();
                IBgOrgView iBgOrgView = BgOrgViewFactory.getLocalInstance((Context)context);
                iBgOrgView.getBgOrgViewInfo((IObjectPK)new ObjectUuidPK(bgOrgViewId), BgOrgUnitUtils.getBgOrgViewSelectors());
                if (iBgOrgView.checkHasOrg(bgOrgViewId)) {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("parent", null));
                    filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId.toString()));
                    view.setFilter(filter);
                    view.getSelector().add("id");
                    BgOrgUnitCollection orgUnitColls = BgOrgUnitFactory.getLocalInstance((Context)context).getBgOrgUnitCollection(view);
                    if (!orgUnitColls.isEmpty()) {
                        String id = null;
                        for (int i = 0; i < orgUnitColls.size(); ++i) {
                            if (orgUnitColls.get(i).getId() == null) continue;
                            id = orgUnitColls.get(i).getId().toString();
                        }
                        iBgOrgView.getDirectOrgUnits(bgOrgViewId.toString(), id, false, true, true, false);
                    }
                }
            }
        }
    }
}

