/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizScopeCollection;
import com.kingdee.eas.ma.biz.BizScopeFactory;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.IBizScope;
import com.kingdee.eas.ma.biz.app.AbstractBizCalcSubsetControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCalcSubsetControllerBean
extends AbstractBizCalcSubsetControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.biz.app.BizCalcSubsetControllerBean");

    @Override
    protected void _saveData(Context ctx, Map subsetMap) throws BOSException, EASBizException {
        if (ctx == null || subsetMap == null || subsetMap.isEmpty()) {
            return;
        }
        String subsetName = null;
        BizCalcSubsetInfo subsetInfo = null;
        for (Object obj : subsetMap.keySet()) {
            subsetName = obj.toString();
            subsetInfo = (BizCalcSubsetInfo)subsetMap.get(subsetName);
            this.addnew(ctx, subsetInfo);
        }
    }

    @Override
    protected Set _getSubsetById(Context ctx, String bizCalcId) throws BOSException, EASBizException {
        if (ctx == null || bizCalcId == null) {
            return null;
        }
        HashSet<String> subSet = new HashSet<String>();
        Connection conn = null;
        IRowSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select FID from T_MBG_BizCalcSubset where FBizCalcID = ?");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bizCalcId});
            StringBuffer msg = new StringBuffer();
            if (rst.next()) {
                subSet.add(rst.getString(0));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return subSet;
    }

    protected IObjectPK[] _saveBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        if (ctx == null || colls == null || colls.isEmpty()) {
            return null;
        }
        BizCalcInfo calcInfo = ((BizCalcSubsetInfo)colls.getObject(0)).getBizCalc();
        if (calcInfo.getId() != null) {
            String calcId = calcInfo.getId().toString();
            this.deleteScopes(ctx, calcId);
            this.deleteSubsets(ctx, calcId);
        }
        IObjectPK[] objectPKArray = super._saveBatchData(ctx, colls);
        BizScopeCollection scopeColl = null;
        CoreBaseCollection scopeAllColl = new CoreBaseCollection();
        BizCalcSubsetInfo subsetInfo = null;
        BizScopeInfo scopeInfo = null;
        for (int i = 0; i < colls.size(); ++i) {
            subsetInfo = (BizCalcSubsetInfo)colls.getObject(i);
            scopeColl = ((BizCalcSubsetInfo)colls.getObject(i)).getScope();
            if (scopeColl == null || scopeColl.size() == 0) continue;
            for (int j = 0; j < scopeColl.size(); ++j) {
                scopeInfo = (BizScopeInfo)scopeColl.getObject(j);
                scopeInfo.setBizCalcSubset(subsetInfo);
                scopeAllColl.addObject((IObjectValue)scopeInfo);
            }
        }
        if (scopeAllColl == null || scopeAllColl.size() == 0) {
            return objectPKArray;
        }
        IBizScope iBizScope = BizScopeFactory.getLocalInstance(ctx);
        iBizScope.saveBatchData(scopeAllColl);
        return objectPKArray;
    }

    protected void deleteScopes(Context ctx, String bizCalcId) throws BOSException {
        if (ctx == null || StringUtils.isEmpty((String)bizCalcId)) {
            return;
        }
        Connection connection = null;
        String sql = "delete from T_MBG_BizScope where FBizCalcSubsetID in (select FID from T_MBG_BizCalcSubset where FBizCalcID = ?)";
        try {
            connection = this.getConnection(ctx);
            BgDBUtils.executeUpdate((Connection)connection, (String)sql, (Object[])new Object[]{bizCalcId});
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
    }

    protected void deleteSubsets(Context ctx, String bizCalcId) throws BOSException {
        if (ctx == null || StringUtils.isEmpty((String)bizCalcId)) {
            return;
        }
        Connection connection = null;
        String sql = "delete from T_MBG_BizCalcSubset where FBizCalcID = ?";
        try {
            connection = this.getConnection(ctx);
            BgDBUtils.executeUpdate((Connection)connection, (String)sql, (Object[])new Object[]{bizCalcId});
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
    }
}

