/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.biz.BizCalcFacadeFactory;
import com.kingdee.eas.ma.biz.execute.impl.BizCalcParameter;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class MbgBizCalcService {
    private static Logger logger = Logger.getLogger(MbgBizCalcService.class);
    private static final int POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private static final int PLAN_STATE_STOP = -1;
    private static final int PLAN_STATE_RUN = 1;
    private static final int PLAN_STATE_END = 9;
    private static final String PLAN_ID = "98765432";
    private ExecutorService service = Executors.newFixedThreadPool(POOL_SIZE / 2 >= 2 ? 2 : POOL_SIZE / 2);
    private ServiceParam serviceParam = null;
    private Context context = null;
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    protected void setContext(Context context) {
        this.context = context;
    }

    protected Context getContext() {
        return this.context;
    }

    public MbgBizCalcService(Context context) {
        this.setContext(context);
        this.initialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.outLog("begin execute MbgBizCalcService:" + this.outputTime());
        if (this.getContext() == null) {
            return;
        }
        if (this.checkRunCondition()) {
            return;
        }
        List<MbgBizCalcPlan> calcPlans = null;
        List<MbgBizCalcPlanEntry> calcEntrys = null;
        MbgBizCalcServiceThread thread = null;
        Object result = null;
        List futures = null;
        ArrayList<MbgBizCalcServiceThread> plans = new ArrayList<MbgBizCalcServiceThread>();
        try {
            this.createBizCalcPlan();
            calcPlans = this.queryBizCalcPlan();
            for (MbgBizCalcPlan calcPlan : calcPlans) {
                calcPlan.bgScheme = BgViewServerHelper.getBgSchemeInfo((Context)this.getContext(), (BOSUuid)BOSUuid.read((String)calcPlan.scheme));
                if (this.checkPlanCondition()) break;
                if (calcPlan.state == -1) {
                    this.createBizCalcPlanEntry(calcPlan);
                }
                if ((calcEntrys = this.queryBizCalcPlanEntry(calcPlan)).isEmpty()) {
                    this.closeBizCalcPlan(calcPlan);
                    continue;
                }
                plans.clear();
                for (MbgBizCalcPlanEntry calcEntry : calcEntrys) {
                    if (this.checkPlanEntryCondition()) break;
                    if (calcEntry.state != -1 || (thread = this.getService(calcPlan, calcEntry)) == null) continue;
                    plans.add(thread);
                }
                futures = this.service.invokeAll(plans);
                boolean isClose = true;
                for (Future future : futures) {
                    result = future.get();
                    if (!(result instanceof Boolean) || ((Boolean)result).booleanValue()) continue;
                    isClose = false;
                    break;
                }
                if (!isClose) continue;
                this.closeBizCalcPlan(calcPlan);
            }
            this.service.shutdown();
        }
        catch (Exception ex) {
            logger.error((Object)"MbgBizCalcService execute error:", (Throwable)ex);
        }
        this.outLog("end run MbgBizCalcService:" + this.outputTime());
    }

    protected void initialized() {
        try {
            this.initialService();
        }
        catch (Exception ex) {
            logger.error((Object)"MbgBizCalcService initialized error:", (Throwable)ex);
        }
    }

    protected boolean checkRunCondition() {
        boolean check = this.checkRunTime();
        if (check) {
            // empty if block
        }
        return check;
    }

    protected boolean checkPlanCondition() {
        boolean check = this.checkRunTime();
        if (check) {
            // empty if block
        }
        return check;
    }

    protected boolean checkPlanEntryCondition() {
        boolean check = this.checkRunTime();
        if (check) {
            // empty if block
        }
        return check;
    }

    protected boolean checkRunTime() {
        boolean check = false;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int currHours = calendar.get(11);
        if (this.serviceParam.beginHours > currHours || currHours > this.serviceParam.endHours) {
            check = true;
        }
        this.outLog("checkRunTime:" + check);
        return check;
    }

    protected MbgBizCalcServiceThread getService(MbgBizCalcPlan calcPlan, MbgBizCalcPlanEntry calcEntry) {
        if (this.getContext() == null || calcPlan == null || calcEntry == null) {
            return null;
        }
        MbgBizCalcServiceThread thread = new MbgBizCalcServiceThread(this.getContext());
        thread.setPlanId(calcPlan.id);
        thread.setBgSchemeId(calcPlan.scheme);
        thread.setBgScheme(calcPlan.bgScheme);
        thread.setOrgUnitId(calcEntry.orgUnitId);
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialService() throws Exception {
        IRowSet rst;
        Connection conn;
        block7: {
            this.serviceParam = new ServiceParam();
            this.serviceParam.AIS = this.getContext().getAIS();
            this.serviceParam.address = InetAddress.getLocalHost().getHostAddress();
            this.outLog("begin initial service " + this.serviceParam.address + " - " + this.serviceParam.AIS);
            conn = null;
            rst = null;
            try {
                String[] tmpStr;
                String hours;
                conn = BgDBUtils.getConnection((Context)this.getContext());
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FValue from T_MBG_BgParam where FKey = 'C0100'");
                if (!rst.next() || StringUtils.isEmpty((String)(hours = rst.getString("FValue"))) || (tmpStr = hours.split("-")) == null || tmpStr.length < 2) break block7;
                try {
                    int beginHours = Integer.valueOf(tmpStr[0]);
                    int endHours = Integer.valueOf(tmpStr[1]);
                    if (beginHours >= 0 && beginHours <= 23 && endHours >= 0 && endHours <= 23 && endHours > beginHours) {
                        this.serviceParam.beginHours = beginHours;
                        this.serviceParam.endHours = endHours;
                    }
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)"MbgBizCalcService initialized error:", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"MbgBizCalcService initialized error:", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, null, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
    }

    private void createBizCalcPlanTable(Connection conn) {
        if (conn == null) {
            return;
        }
        this.outLog("begin create BizCalc Plan Table.");
        try {
            int re = BgDBUtils.existTable((Connection)conn, (String)"T_MBG_BizCalcServicePlan");
            if (re == BgDBUtils.NO) {
                StringBuffer sql = new StringBuffer();
                sql.append("Create Table T_MBG_BizCalcServicePlan (FID VARCHAR(44) DEFAULT '' NOT NULL, FAIS NVARCHAR(256) DEFAULT '' NOT NULL, FScheme VARCHAR(44) DEFAULT '' NOT NULL, FAddress NVARCHAR(128) DEFAULT '' NOT NULL, FState INT DEFAULT 0 NOT NULL, FCreateTime DateTime, FLastRunTime DateTime, CONSTRAINT PK_MBG_BizCalcPlan PRIMARY KEY (FID))");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
                BgDBUtils.executeUpdate((Connection)conn, (String)"CREATE INDEX IX_MBG_BizCalcPlan ON T_MBG_BizCalcServicePlan(FAIS, FScheme, FState)");
            }
            if ((re = BgDBUtils.existTable((Connection)conn, (String)"T_MBG_BizCalcServicePlanEntry")) == BgDBUtils.NO) {
                BgDBUtils.executeUpdate((Connection)conn, (String)"Create Table T_MBG_BizCalcServicePlanEntry (FPlanID VARCHAR(44) DEFAULT '' NOT NULL, FOrgUnitId VARCHAR(44), FState INT DEFAULT 0 NOT NULL, FCreateTime DateTime, FLastRunTime DateTime)");
                BgDBUtils.executeUpdate((Connection)conn, (String)"CREATE INDEX IX_MBG_BizCPlanEny ON T_MBG_BizCalcServicePlanEntry(FPlanID, FState)");
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"MbgBizCalcService createBizCalcPlanTable error:", (Throwable)ex);
        }
        this.outLog("end create BizCalc Plan Table.");
    }

    private void createBizCalcPlan() {
        if (this.serviceParam == null) {
            return;
        }
        this.outLog("begin create BizCalc Plan." + this.outputTime());
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.getContext());
            this.createBizCalcPlanTable(conn);
            StringBuffer sql = new StringBuffer();
            sql.append("Insert Into T_MBG_BizCalcServicePlan (FID, FAIS, FScheme, FAddress, FState, FCreateTime, FLastRunTime) Select NEWBOSID('98765432'), '" + this.serviceParam.AIS + "', FID, '" + this.serviceParam.address + "', " + -1 + ", NOW(), NOW() from T_MBG_BgScheme where FID IN (Select FBgSchemeId from T_MBG_BizCalc where FIsBgExe = 1) and FISFILING = 0 and not exists (select FScheme from T_MBG_BizCalcServicePlan where FScheme = T_MBG_BgScheme.FID and FAIS = ? and (FState = ? OR FState = ?))");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{this.serviceParam.AIS, -1, 1});
        }
        catch (SQLDataException ex) {
            logger.error((Object)"MbgBizCalcService createBizCalcPlan error:", (Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"MbgBizCalcService createBizCalcPlan error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.outLog("end create BizCalc Plan." + this.outputTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBizCalcPlanEntry(MbgBizCalcPlan calcPlan) {
        this.outLog("begin create BizCalc Entry Plan." + this.outputTime());
        if (calcPlan == null || calcPlan.id == null || calcPlan.bgScheme == null) {
            return;
        }
        Connection conn = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into T_MBG_BizCalcServicePlanEntry (FPlanID, FOrgUnitId, FState, FCreateTime, FLastRunTime) Select '" + calcPlan.id + "', FOrgUnitID , " + -1 + ", NOW(), NOW() from T_MBG_BgOrgUnit where FViewId = ? and FIsLeaf = 1 and FIsVirtual = 0 and FOrgUnitID in (select FOrgUnitID from " + calcPlan.bgScheme.getRefCube() + ")");
        try {
            conn = BgDBUtils.getConnection((Context)this.getContext());
            if (calcPlan.bgScheme != null && calcPlan.bgScheme.getEditOrgViewId() != null) {
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{calcPlan.bgScheme.getEditOrgViewId().toString()});
                BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BizCalcServicePlan set FState = ?, FLastRunTime = ? where FID = ?", (Object[])new Object[]{1, this.serviceParam.runTime, calcPlan.id});
                calcPlan.state = 1;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"MbgBizCalcService createBizCalcPlanEntry error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.outLog("end create BizCalc Entry Plan." + this.outputTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected List<MbgBizCalcPlan> queryBizCalcPlan() {
        this.outLog("begin query BizCalc Plan." + this.outputTime());
        ArrayList<MbgBizCalcPlan> calcPlans = new ArrayList<MbgBizCalcPlan>();
        MbgBizCalcPlan calcPlan = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.getContext());
            pstmt = conn.prepareStatement("select FID, FScheme, FState from T_MBG_BizCalcServicePlan where FAIS = ? and (FState = ? OR FState = ?) order by FCreateTime desc");
            pstmt.setString(1, this.getContext().getAIS());
            pstmt.setInt(2, -1);
            pstmt.setInt(3, 1);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                calcPlan = new MbgBizCalcPlan();
                calcPlan.id = rst.getString("FID");
                calcPlan.scheme = rst.getString("FScheme");
                calcPlan.state = rst.getInt("FState");
                calcPlans.add(calcPlan);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"MbgBizCalcService queryBizCalcPlan error:", (Throwable)ex);
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLDataException ex2) {
            logger.error((Object)"MbgBizCalcService queryBizCalcPlan error:", (Throwable)ex2);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        this.outLog("end query BizCalc Plan." + this.outputTime());
        return calcPlans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeBizCalcPlan(MbgBizCalcPlan calcPlan) {
        if (calcPlan == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.getContext());
            BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BizCalcServicePlan set FState = ?, FLastRunTime = ? where FID = ?", (Object[])new Object[]{9, this.serviceParam.runTime, calcPlan.id});
            calcPlan.state = 9;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.serviceParam.runTime);
            calendar.add(6, -30);
            pstmt = conn.prepareStatement("delete from T_MBG_BizCalcServicePlanEntry where FPlanID in (select FID from T_MBG_BizCalcServicePlan where FLastRunTime <= ?)");
            pstmt.setTimestamp(1, new Timestamp(calendar.getTime().getTime()));
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        catch (Exception ex) {
            logger.error((Object)"MbgBizCalcService closeBizCalcPlan error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected List<MbgBizCalcPlanEntry> queryBizCalcPlanEntry(MbgBizCalcPlan calcPlan) {
        ArrayList<MbgBizCalcPlanEntry> calcEntrys = new ArrayList<MbgBizCalcPlanEntry>();
        if (calcPlan == null) {
            return calcEntrys;
        }
        MbgBizCalcPlanEntry calcEntry = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.getContext());
            pstmt = conn.prepareStatement("select FOrgUnitId, FState from T_MBG_BizCalcServicePlanEntry where FPlanID = ? and (FState = ? OR FState = ?)");
            pstmt.setString(1, calcPlan.id);
            pstmt.setInt(2, -1);
            pstmt.setInt(3, 1);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                calcEntry = new MbgBizCalcPlanEntry();
                calcEntry.planId = calcPlan.id;
                calcEntry.orgUnitId = rst.getString("FOrgUnitId");
                calcEntry.state = rst.getInt("FState");
                calcEntrys.add(calcEntry);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"MbgBizCalcService queryBizCalcPlan error:", (Throwable)ex);
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLDataException ex2) {
            logger.error((Object)"MbgBizCalcService queryBizCalcPlan error:", (Throwable)ex2);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return calcEntrys;
    }

    protected String outputTime() {
        return format.format(System.currentTimeMillis());
    }

    protected void outLog(String log) {
        logger.debug((Object)log);
    }

    private class MbgBizCalcServiceThread
    extends Thread
    implements Callable<Object> {
        private Context ctx = null;
        private String planId = null;
        private String bgSchemeId = null;
        private BgSchemeInfo bgScheme = null;
        private String orgUnitId = null;

        protected void setCtx(Context ctx) {
            this.ctx = ctx;
        }

        protected Context getCtx() {
            return this.ctx;
        }

        public void setPlanId(String planId) {
            this.planId = planId;
        }

        public String getPlanId() {
            return this.planId;
        }

        public void setBgSchemeId(String bgSchemeId) {
            this.bgSchemeId = bgSchemeId;
        }

        public String getBgSchemeId() {
            return this.bgSchemeId;
        }

        public void setBgScheme(BgSchemeInfo bgScheme) {
            this.bgScheme = bgScheme;
        }

        public BgSchemeInfo getBgScheme() {
            return this.bgScheme;
        }

        public void setOrgUnitId(String orgUnitId) {
            this.orgUnitId = orgUnitId;
        }

        public String getOrgUnitId() {
            return this.orgUnitId;
        }

        public MbgBizCalcServiceThread(Context ctx) {
            this.setCtx(ctx);
        }

        @Override
        public void run() {
            super.run();
            try {
                this.executeBizCalc();
            }
            catch (Exception ex) {
                logger.error((Object)"MbgBizCalcServiceThread run error:", (Throwable)ex);
            }
        }

        @Override
        public Object call() throws Exception {
            boolean re = true;
            try {
                this.executeBizCalc();
            }
            catch (Exception ex) {
                re = false;
            }
            return re;
        }

        protected boolean executeBizCalc() throws Exception {
            MbgBizCalcService.this.outLog("begin run plan: bgSchemeId : " + this.getBgSchemeId() + " ; orgUnitId : " + this.getOrgUnitId() + " ; " + this.getId() + " - " + MbgBizCalcService.this.outputTime());
            boolean result = false;
            try {
                if (!this.check()) {
                    boolean bl = result;
                    return bl;
                }
                BizCalcParameter parameter = new BizCalcParameter();
                parameter.setBgSchemeId(BOSUuid.read((String)this.getBgSchemeId()));
                parameter.setOrgUnitId(BOSUuid.read((String)this.getOrgUnitId()));
                parameter.getControlManager().setBackCalc(true);
                parameter.getControlManager().setBizCalc(true);
                BizCalcFacadeFactory.getLocalInstance(this.getCtx()).executeBGUpdate(parameter);
                result = true;
            }
            catch (Exception ex) {
                logger.error((Object)"MbgBizCalcServiceThread run error:", (Throwable)ex);
            }
            finally {
                if (result) {
                    this.closeBizCalcPlanEntry();
                }
            }
            MbgBizCalcService.this.outLog("end run plan: " + this.getId() + " - " + MbgBizCalcService.this.outputTime());
            return result;
        }

        private boolean check() {
            return this.getCtx() != null && this.getPlanId() != null && this.getBgSchemeId() != null && this.getBgScheme() != null && this.getOrgUnitId() != null;
        }

        private void closeBizCalcPlanEntry() {
            if (MbgBizCalcService.this.getContext() == null) {
                return;
            }
            Connection conn = null;
            try {
                conn = BgDBUtils.getConnection((Context)MbgBizCalcService.this.getContext());
                BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BizCalcServicePlanEntry set FState = ?, FLastRunTime = ? where FPlanID = ? and FOrgUnitId = ?", (Object[])new Object[]{9, new Timestamp(System.currentTimeMillis()), this.getPlanId(), this.getOrgUnitId()});
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"MbgBizCalcService closeBizCalcPlan error:", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(conn);
                    throw throwable;
                }
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private class MbgBizCalcPlanEntry {
        public String planId = null;
        public String orgUnitId = null;
        public int state = -1;

        private MbgBizCalcPlanEntry() {
        }
    }

    private class MbgBizCalcPlan {
        public String id = null;
        public String scheme = null;
        public int state = -1;
        public BgSchemeInfo bgScheme = null;

        private MbgBizCalcPlan() {
        }
    }

    private class ServiceParam {
        public String AIS = null;
        public String address = null;
        public Timestamp runTime = new Timestamp(System.currentTimeMillis());
        public int beginHours = 0;
        public int endHours = 6;

        private ServiceParam() {
        }
    }
}

