/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.app.utils.BizCalcServelHelper;
import com.kingdee.eas.ma.biz.execute.calc.face.ICalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcImpl;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.execute.impl.BizCalcParameter;
import com.kingdee.eas.ma.biz.execute.impl.BizCalcQuery;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizMemberQuery;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAdjustBillBizCalcHelper {
    private static Logger logger = Logger.getLogger((String)BgAdjustBillBizCalcHelper.class.getName());
    private Context ctx = null;
    private Map<String, String> versionMap = null;
    private Map<String, Map<String, String>> formulaCacheMap = new HashMap<String, Map<String, String>>();
    private BizMemberQuery bizMemberQuery = null;

    public BgAdjustBillBizCalcHelper(Context ctx) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.init();
    }

    private void init() throws EASBizException, BOSException {
        this.versionMap = BgVersionHelper.getVersionMap((Context)this.ctx);
    }

    public void executeBizAdjust(Set billIds) throws BOSException, EASBizException {
        if (billIds == null || billIds.isEmpty()) {
            return;
        }
        for (Object id : billIds) {
            this.executeBizAdjust(String.valueOf(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBizAdjust(String adjustBillId) throws BOSException, EASBizException {
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        HashSet<String> billIds = new HashSet<String>();
        billIds.add(adjustBillId);
        try {
            conn = this.getConnection(this.ctx);
            Map<String, Map<String, Set<String>>> formulas = this.queryAdjustFormula(this.ctx, conn, billIds);
            for (String bgSchemeId : formulas.keySet()) {
                this.innerExecuteBizAdjust(conn, pool, adjustBillId, bgSchemeId, formulas.get(bgSchemeId));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(conn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)conn);
    }

    protected void innerExecuteBizAdjust(Connection conn, TempTablePool pool, String adjustBillId, String bgSchemeId, Map<String, Set<String>> formulas) throws BOSException, EASBizException {
        if (formulas == null || formulas.isEmpty()) {
            return;
        }
        Map<String, Set<String>> formulaMembers = this.parseMembers(formulas);
        Set<String> bgPeriodNumber = formulaMembers.get(DimensionConstants.DEF_PERIOD_SRCNUMBER);
        BizCalcQuery bizQuery = BizCalcQuery.getInstance(this.ctx);
        List<BOSUuid> calcIds = this.getCalcIds(bgSchemeId);
        if (calcIds == null || calcIds.isEmpty()) {
            return;
        }
        List<BizCalcInfo> bizCalcInfos = null;
        Map<String, String> variateMap = null;
        try {
            bizCalcInfos = bizQuery.queryBizCalc(conn, BOSUuid.read((String)bgSchemeId), null, null, calcIds, false, bgPeriodNumber, null);
            if (bizCalcInfos == null || bizCalcInfos.isEmpty()) {
                return;
            }
            this.bizMemberQuery = BizMemberQuery.getInstance(this.ctx, bgSchemeId);
            variateMap = bizQuery.queryVariate(conn, BOSUuid.read((String)bgSchemeId));
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(this.ctx, bgSchemeId);
        BgSchemeCollection col = BgSchemeFactory.getLocalInstance((Context)this.ctx).getBgSchemeCollection("select orgUnit.id, refCube where id = '" + bgSchemeId + "'");
        String cubeName = col.get(0).getRefCube();
        String orgId = col.get(0).getOrgUnit().getId().toString();
        Map<String, BgOrgUnitInfo> bgOrgUnitMap = this.queryOrgUnit(schemeHelper, formulas);
        this.parseMembers(bizCalcInfos, formulaMembers);
        this.queryMember(schemeHelper, orgId, formulaMembers);
        HashMap<String, Map<String, ICalcData>> bgDataMap = new HashMap<String, Map<String, ICalcData>>();
        Map<String, ICalcData> tmpDataMap = null;
        for (String orgUnitId : formulas.keySet()) {
            tmpDataMap = this.innerExecuteBizAdjust(adjustBillId, this.getProcessType(orgUnitId), schemeHelper, bgOrgUnitMap.get(this.getOrgId(orgUnitId)), formulas.get(orgUnitId), bizCalcInfos, variateMap, bgPeriodNumber);
            if (tmpDataMap == null || tmpDataMap.isEmpty()) continue;
            bgDataMap.put(orgUnitId, tmpDataMap);
        }
        DbUtil.execute((Context)this.ctx, (String)("Update " + cubeName + " Set FAudOrgUnitID = FOrgUnitId, FAudUserID = ?, FDetail = 1 Where FState = ? AND FAudOrgUnitID IS NULL"), (Object[])new Object[]{ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString(), 9});
    }

    protected Map<String, BgOrgUnitInfo> queryOrgUnit(BgSchemeDimensionHelper schemeHelper, Map<String, Set<String>> formulas) throws BOSException, EASBizException {
        HashMap<String, BgOrgUnitInfo> bgOrgUnitMap = new HashMap<String, BgOrgUnitInfo>();
        HashSet<String> orgUnitIds = new HashSet<String>();
        for (String key : formulas.keySet()) {
            orgUnitIds.add(this.getOrgId(key));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("orgUnitId");
        evi.getSelector().add("viewId");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", orgUnitIds, CompareType.INCLUDE));
        BgOrgUnitCollection col = BgOrgUnitFactory.getLocalInstance((Context)this.ctx).getBgOrgUnitCollection(evi);
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                bgOrgUnitMap.put(col.get(i).getId().toString(), col.get(i));
            }
        }
        return bgOrgUnitMap;
    }

    private Map<String, Map<String, BgDimensionMember>> queryMember(BgSchemeDimensionHelper schemeHelper, String orgId, Map<String, Set<String>> formulaMembers) throws BOSException, EASBizException {
        HashMap<String, Map<String, BgDimensionMember>> memberMap = new HashMap<String, Map<String, BgDimensionMember>>();
        for (String srcNumber : formulaMembers.keySet()) {
            memberMap.put(srcNumber, DimensionFormulaFacadeFactory.getLocalInstance((Context)this.ctx).queryMembers(orgId, schemeHelper, ((BgDimensionInfo)schemeHelper.getDimensionBySrcNumber().get(srcNumber)).getNumber(), formulaMembers.get(srcNumber), false, null));
        }
        return memberMap;
    }

    private void parseMembers(List<BizCalcInfo> bizCalcInfos, Map<String, Set<String>> formulaMembers) {
        for (BizCalcInfo bizInfo : bizCalcInfos) {
            this.parseMembers(bizInfo, formulaMembers);
        }
    }

    private void parseMembers(BizCalcInfo bizInfo, Map<String, Set<String>> formulaMembers) {
        BizCalcSubsetInfo subSet = null;
        for (int i = 0; i < bizInfo.getBizCalcSubset().size(); ++i) {
            subSet = bizInfo.getBizCalcSubset().get(i);
            this.parseMembers(subSet, formulaMembers);
        }
    }

    private void parseMembers(BizCalcSubsetInfo subSet, Map<String, Set<String>> formulaMembers) {
    }

    private Map<String, Set<String>> parseMembers(Map<String, Set<String>> formulas) {
        HashMap<String, Set<String>> members = new HashMap<String, Set<String>>();
        HashMap<String, String> subMap = new HashMap<String, String>();
        for (Set<String> subSet : formulas.values()) {
            for (String formula : subSet) {
                subMap.clear();
                this.splitFormula(formula, subMap);
                for (String srcNumber : subMap.keySet()) {
                    this.addMember(members, srcNumber, (String)subMap.get(srcNumber));
                }
            }
        }
        return members;
    }

    private void splitFormula(String formula, Map<String, String> subMap) {
        String[] itemComs;
        if (this.formulaCacheMap.containsKey(formula)) {
            subMap.putAll(this.formulaCacheMap.get(formula));
            return;
        }
        subMap.put(DimensionConstants.DEF_VERSION_SRCNUMBER, this.getVersionNumber(formula));
        formula = this.getFormula(formula);
        String[] formulaParams = BgNFSHelper.parseFormulaPara((String)formula);
        subMap.put(DimensionConstants.DEF_PERIOD_SRCNUMBER, formulaParams[1]);
        subMap.put(DimensionConstants.DEF_ELEMENT_SRCNUMBER, formulaParams[2]);
        subMap.put(DimensionConstants.DEF_CURRENCY_SRCNUMBER, formulaParams[5]);
        subMap.put(DimensionConstants.DEF_SCENARIO_SRCNUMBER, formulaParams[3]);
        for (String onItem : itemComs = DimensionFormulaHelper.splitCombinations((String)formulaParams[0])) {
            subMap.put(DimensionFormulaHelper.getSrcNumber((String)onItem), DimensionFormulaHelper.getMemberNumber((String)onItem));
        }
        this.formulaCacheMap.put(formula, new HashMap<String, String>(subMap));
    }

    private void addMember(Map<String, Set<String>> members, String srcNumber, String number) {
        if (!members.containsKey(srcNumber)) {
            members.put(srcNumber, new HashSet());
        }
        members.get(srcNumber).add(number);
    }

    private String getFormula(String formulaKey) {
        return formulaKey.substring(0, formulaKey.lastIndexOf("_"));
    }

    private String getVersionNumber(String formulaKey) {
        return formulaKey.substring(formulaKey.lastIndexOf("_") + 1);
    }

    protected Map<String, ICalcData> innerExecuteBizAdjust(String adjustBillId, int processType, BgSchemeDimensionHelper schemeHelper, BgOrgUnitInfo bgOrgUnit, Set<String> formulas, List<BizCalcInfo> bizCalcInfos, Map<String, String> variateMap, Set<String> bgPeriodNums) throws BOSException, EASBizException {
        HashSet<String> allowFormula = new HashSet<String>(formulas);
        ArrayList<BOSUuid> calcIds = new ArrayList<BOSUuid>();
        for (BizCalcInfo bizInfo : bizCalcInfos) {
            if (!this.matchFormula(bizInfo, allowFormula, bgOrgUnit.getNumber(), processType, bgOrgUnit.getViewID(), schemeHelper, variateMap, bgPeriodNums)) continue;
            calcIds.add(bizInfo.getId());
        }
        if (calcIds.isEmpty()) {
            return null;
        }
        Map bgDataMap = null;
        try {
            BizCalcParameter parameter = new BizCalcParameter();
            parameter.setOrgUnitId(BOSUuid.read((String)bgOrgUnit.getOrgUnitID()));
            parameter.setBgSchemeId(BOSUuid.read((String)schemeHelper.getBgSchemeId()));
            parameter.setCalcIds(calcIds);
            parameter.setValueType(1);
            BizCalcServelHelper.beforeCheck(this.ctx, parameter);
            BizCalcImpl calc = new BizCalcImpl(this.ctx, parameter, true);
            Map calcMap = calc.calc();
            if (calcMap != null && !calcMap.isEmpty()) {
                bgDataMap = (Map)calcMap.get(bgOrgUnit.getOrgUnitID());
            }
            if (bgDataMap != null && !bgDataMap.isEmpty()) {
                String formulaStr = null;
                String versionNumber = null;
                for (String formula : bgDataMap.keySet().toArray(new String[0])) {
                    formulaStr = this.getFormula(formula);
                    if (allowFormula.contains(this.getFormulaKey(new Object[]{formulaStr, versionNumber = this.versionMap.get(this.getVersionNumber(formula))}))) continue;
                    bgDataMap.remove(formula);
                }
            }
            if (bgDataMap != null && !bgDataMap.isEmpty()) {
                calc.setDimParam(calc.transParameter(parameter));
                calc.getDimParam().setBillId(BOSUuid.read((String)adjustBillId));
                calc.setSaveDatas(new ArrayList<ICalcData>(bgDataMap.values()));
                calc.updataCalcData();
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return bgDataMap;
    }

    private boolean matchFormula(BizCalcInfo bizInfo, Set<String> allowFormula, String orgUnitNumber, int processType, String bgOrgViewId, BgSchemeDimensionHelper schemeHelper, Map<String, String> variateMap, Set<String> bgPeriodNums) throws BOSException, EASBizException {
        boolean isMatch = false;
        BizCalcSubsetInfo subSet = null;
        Map<String, Set<String>> scopeData = null;
        List<IExpress> expresses = null;
        BinaryExpr binaryExpr = null;
        MdxMemberExpr leftExpr = null;
        BgSchemeInfo bgSchemeInfo = BgViewServerHelper.getBgSchemeCubeInfo((Context)this.ctx, (BOSUuid)BOSUuid.read((String)schemeHelper.getBgSchemeId()));
        MbgDimCollection mbgDims = DimUtils.getDimensionColls((Context)this.ctx);
        for (int i = 0; i < bizInfo.getBizCalcSubset().size(); ++i) {
            subSet = bizInfo.getBizCalcSubset().get(i);
            if (!subSet.checkHasOrgScope(this.ctx, orgUnitNumber, bgOrgViewId, schemeHelper.getBgSchemeId(), null)) continue;
            try {
                scopeData = subSet.getScopeData(variateMap, bgPeriodNums, null, true, true, this.ctx, bgSchemeInfo, mbgDims);
            }
            catch (Exception e1) {
                logger.error((Object)"", (Throwable)e1);
                throw new BOSException((Throwable)e1);
            }
            if (scopeData != null && scopeData.containsKey(DimensionConstants.DEF_PROCESS_FIELD) && !scopeData.get(DimensionConstants.DEF_PROCESS_FIELD).contains(BgProcessEnum.getEnum((int)processType).getName())) continue;
            try {
                expresses = subSet.getExpres();
                if (expresses == null || expresses.isEmpty()) {
                    return isMatch;
                }
                for (IExpress topExpress : expresses) {
                    if (!(topExpress instanceof BinaryExpr)) continue;
                    binaryExpr = (BinaryExpr)topExpress;
                    leftExpr = (MdxMemberExpr)binaryExpr.left;
                    if (!this.matchFormula(schemeHelper, leftExpr, binaryExpr.right, scopeData, allowFormula)) continue;
                    isMatch = true;
                }
                continue;
            }
            catch (ParseException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return isMatch;
    }

    private boolean matchFormula(BgSchemeDimensionHelper schemeHelper, MdxMemberExpr leftExpr, IExpress rightExpr, Map<String, Set<String>> scopeData, Set<String> allowFormula) throws BOSException, EASBizException {
        boolean isMatch = false;
        HashMap<String, String> memberMap = new HashMap<String, String>();
        for (String formula : allowFormula.toArray(new String[0])) {
            memberMap.clear();
            this.splitFormula(formula, memberMap);
            IExpress matchExpress = this.matchFormula(memberMap, rightExpr, scopeData);
            if (matchExpress == null) continue;
            for (IExpress param : leftExpr.params) {
                if (!(param instanceof MemberExpr)) continue;
                MemberExpr memberExpr = (MemberExpr)param;
                memberMap.put(memberExpr.srcNumber, memberExpr.number);
            }
            if (!this.isInScope(schemeHelper, memberMap, scopeData)) continue;
            isMatch = true;
            allowFormula.add(this.buildFormula(memberMap, schemeHelper));
        }
        return isMatch;
    }

    private String buildFormula(Map<String, String> memberMap, BgSchemeDimensionHelper schemeHelper) {
        String bgElement = null;
        String currency = null;
        String bgPeriod = null;
        String scenriao = null;
        String versionNumber = null;
        HashMap<Integer, String> bgItems = new HashMap<Integer, String>();
        String number = null;
        for (String srcNumber : memberMap.keySet()) {
            number = memberMap.get(srcNumber);
            if (DimensionConstants.DEF_ELEMENT_SRCNUMBER.equals(srcNumber)) {
                bgElement = number;
                continue;
            }
            if (DimensionConstants.DEF_CURRENCY_SRCNUMBER.equals(srcNumber)) {
                currency = number;
                continue;
            }
            if (DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNumber)) {
                bgPeriod = number;
                continue;
            }
            if (DimensionConstants.DEF_SCENARIO_SRCNUMBER.equals(srcNumber)) {
                scenriao = number;
                continue;
            }
            if (DimensionConstants.DEF_VERSION_SRCNUMBER.equals(srcNumber)) {
                versionNumber = number;
                continue;
            }
            bgItems.put(DimensionCommonHelper.getField((String)schemeHelper.getRefFieldBySrcNumber(srcNumber)), DimensionFormulaHelper.getCombination((String)srcNumber, (String)number));
        }
        return this.getFormulaKey(new Object[]{BgViewHelper.parseItemFormula(bgElement, currency, bgPeriod, scenriao, bgItems), versionNumber});
    }

    private boolean isInScope(BgSchemeDimensionHelper schemeHelper, Map<String, String> memberMap, Map<String, Set<String>> scopeData) {
        if (scopeData != null && !scopeData.isEmpty()) {
            String srcNumber = null;
            String dimNumber = null;
            String memberNumber = null;
            for (String refField : scopeData.keySet()) {
                if (DimensionConstants.DEF_ORGUNIT_FIELD.equals(refField) || DimensionConstants.DEF_PROCESS_FIELD.equals(refField)) continue;
                srcNumber = schemeHelper.getSrcNumberByRefField(refField);
                dimNumber = ((BgDimensionInfo)schemeHelper.getDimensionBySrcNumber().get(srcNumber)).getNumber();
                memberNumber = memberMap.get(srcNumber);
                if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber) || !DimensionConstants.necessary.contains(dimNumber)) {
                    memberNumber = DimensionFormulaHelper.getCombination((String)srcNumber, (String)memberNumber);
                }
                if (scopeData.get(refField).contains(memberNumber)) continue;
                return false;
            }
        }
        return true;
    }

    private IExpress matchFormula(Map<String, String> memberMap, IExpress rightExpr, Map<String, Set<String>> scopeData) {
        IExpress result;
        block4: {
            block5: {
                block3: {
                    result = null;
                    if (!(rightExpr instanceof MdxMemberExpr)) break block3;
                    result = this.matchFormula(memberMap, (MdxMemberExpr)rightExpr, scopeData);
                    break block4;
                }
                if (!(rightExpr instanceof BinaryExpr)) break block5;
                BinaryExpr be = (BinaryExpr)rightExpr;
                result = this.matchFormula(memberMap, be.left, scopeData);
                if (result != null) break block4;
                result = this.matchFormula(memberMap, be.right, scopeData);
                break block4;
            }
            if (rightExpr instanceof FunctionExpr) {
                FunctionExpr funcExpr = (FunctionExpr)rightExpr;
                if (funcExpr.params != null && !funcExpr.params.isEmpty()) {
                    for (Object param : funcExpr.params) {
                        if (param instanceof IExpress && (result = this.matchFormula(memberMap, (IExpress)param, scopeData)) != null) break;
                    }
                }
            }
        }
        return result;
    }

    private IExpress matchFormula(Map<String, String> memberMap, MdxMemberExpr rightExpr, Map<String, Set<String>> scopeData) {
        if (rightExpr.params == null || rightExpr.params.isEmpty()) {
            return null;
        }
        for (IExpress param : rightExpr.params) {
            if (param instanceof MemberExpr) {
                MemberExpr memberExpr = (MemberExpr)param;
                if (memberExpr.number.equals(memberMap.get(memberExpr.srcNumber))) continue;
                return null;
            }
            return null;
        }
        return rightExpr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Map<String, Set<String>>> queryAdjustFormula(Context ctx, Connection conn, Set adjustBillIds) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement prepareStatement;
        HashMap<String, Map<String, Set<String>>> adjustFormula;
        block10: {
            adjustFormula = new HashMap<String, Map<String, Set<String>>>();
            if (ctx == null) return null;
            if (adjustBillIds == null) return null;
            if (adjustBillIds.isEmpty()) {
                return null;
            }
            String tmpTable = null;
            HashSet<String> ids = new HashSet<String>();
            for (Object id : adjustBillIds) {
                if (id == null || StringUtils.isEmpty((String)id.toString())) continue;
                ids.add(id.toString());
            }
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            prepareStatement = null;
            rst = null;
            int processType = 1;
            try {
                tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (BILLID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (BILLID) values (?)"), ids);
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT v.FNumber versionNumber, en.FFormula, en.FOrgUnit orgId,b.FBgScheme schemeId FROM ");
                sql.append(" T_MBG_BgAdjustBillEntry en, ");
                sql.append(" T_MBG_BgAdjustBill b, ");
                sql.append(" T_MBG_BgVersion v WHERE b.FID = en.FBgAdjustBill ");
                sql.append(" AND v.FID = b.FBgVersionID ");
                sql.append(" AND b.FID IN (SELECT BILLID FROM " + tmpTable + ")");
                prepareStatement = conn.prepareStatement(sql.toString());
                rst = prepareStatement.executeQuery();
                String orgId = null;
                String bgSchemeId = null;
                String orgKey = null;
                while (rst.next()) {
                    bgSchemeId = rst.getString("schemeId");
                    orgId = rst.getString("orgId");
                    orgKey = this.getFormulaKey(new Object[]{orgId, processType});
                    if (!adjustFormula.containsKey(bgSchemeId)) {
                        adjustFormula.put(bgSchemeId, new HashMap());
                    }
                    if (!((Map)adjustFormula.get(bgSchemeId)).containsKey(orgKey)) {
                        ((Map)adjustFormula.get(bgSchemeId)).put(orgKey, new HashSet());
                    }
                    ((Set)((Map)adjustFormula.get(bgSchemeId)).get(orgKey)).add(this.getFormulaKey(new Object[]{rst.getString("FFormula"), rst.getString("versionNumber")}));
                }
                if (tmpTable == null) break block10;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    SQLUtils.cleanup(rst, prepareStatement);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)prepareStatement);
        return adjustFormula;
    }

    private List<BOSUuid> getCalcIds(String bgSchemeId) throws BOSException {
        ArrayList<BOSUuid> calcIds = new ArrayList<BOSUuid>();
        if (this.ctx == null || StringUtils.isEmpty((String)bgSchemeId)) {
            return calcIds;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(this.ctx);
            pstmt = conn.prepareStatement("Select FID FROM T_MBG_BizCalc Where FOrgTreeID IS NULL AND FBgSchemeID = ? AND FState = ?");
            pstmt.setString(1, bgSchemeId);
            pstmt.setInt(2, 2);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                calcIds.add(BOSUuid.read((String)rst.getString("FID")));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return calcIds;
    }

    private String getFormulaKey(Object[] formulas) {
        StringBuffer formulaKey = new StringBuffer();
        for (Object obj : formulas) {
            if (formulaKey.length() > 0) {
                formulaKey.append("_");
            }
            formulaKey.append(obj);
        }
        return formulaKey.toString();
    }

    private String getOrgId(String key) {
        return key.substring(0, key.indexOf("_"));
    }

    private int getProcessType(String key) {
        return Integer.parseInt(key.substring(key.indexOf("_") + 1));
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }
}

