/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.calc.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.IContextHandler;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizScopeCollection;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.ICalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.FormulaProxy;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FormulaExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.DimensionMemberTypeEnum;
import com.kingdee.eas.ma.mbg.MbgExamCalcObj;
import com.kingdee.eas.ma.mbg.MbgFunctionFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgReportFacadeFactory;
import com.kingdee.eas.ma.mbg.app.BgExamineFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.data.IMbgDataFacade;
import com.kingdee.eas.ma.mbg.app.data.MbgDataFacade;
import com.kingdee.eas.ma.mbg.app.formula.ExpressionUtils;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.cube.MbgData;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.impl.DimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.ExpressValues;
import com.kingdee.eas.ma.mbg.utils.Arrays;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.log4j.Logger;

public class BizCalcExpreUtils {
    private static Logger logger = Logger.getLogger(BizCalcExpreUtils.class);
    public static final String ACCT_ITEM_STR = "@";
    public static final String ACCT_ITEMS_STR = "@|@";
    public static final String ACCT_ORG_COMPANY = "company";
    public static final int ACCT_INDEX_SIZE = 10;
    public static final int ACCT_ITEM_INDEX = 0;
    public static final int ACCT_DIMNUM_INDEX = 1;
    public static final int ACCT_PERIOD_INDEX = 2;
    public static final int ACCT_CURRENCY_INDEX = 3;
    public static final int ACCT_VALUE_INDEX = 4;
    public static final int ACCT_DIM_INDEX = 5;
    public static final int ACCT_SCOPE_INDEX = 6;
    public static final int ACCT_FORMULA_INDEX = 7;
    public static final int ACCT_RULE_INDEX = 8;
    public static final int ACCT_ZEROUPDATE_INDEX = 9;
    public static final int ELIM_INDEX_SIZE = 2;
    public static final int ELIM_BGPERIOD = 0;
    public static final int ELIM_CURENCY = 1;
    public static final String BILLID = "billId";
    public static final String BGFORMINFO = "bgFormInfo";
    private Context ctx = null;
    private TempTablePool pool = null;
    private Connection conn = null;
    private IDimensionParameter parameter = null;
    private OrgUnitInfo currOrgUnit = null;
    private boolean flag = false;
    private List<BgExamineInfo> examine = null;
    private Map<BOSUuid, List<MbgExamCalcObj>> examCalcObjs = null;
    private OrgUnitInfo currCompany = null;
    private OrgUnitInfo currProfitCenter = null;
    private Map<String, BgPeriodInfo> periodMap = new HashMap<String, BgPeriodInfo>();
    private Map<String, List<Object[]>> expObjMap = new HashMap<String, List<Object[]>>();
    private Map<String, List<Object[]>> mgbExpObjMap = new HashMap<String, List<Object[]>>();
    private Set<String> noPostExpr = new HashSet<String>();
    private Map<String, List<String[]>> accgroupMap = new LinkedHashMap<String, List<String[]>>();
    private Set<String> acctItems = new HashSet<String>();
    private Map<String, Integer> orgTree = new HashMap<String, Integer>();
    private Map<String, String> defaultMap = new HashMap<String, String>();
    private Map<String, Map<String, Set<String>>> cfsMemberMap = new HashMap<String, Map<String, Set<String>>>();
    private Map<String, Map<String, Object[]>> bgFormulaMap = new HashMap<String, Map<String, Object[]>>();
    private String[] costStrs = null;
    private boolean orgSelectState = true;
    private boolean dimSelectState = true;
    private boolean beginPeriodState = true;
    private boolean currencyState = true;
    private boolean supportDimState = true;
    private Map<String, MbgDimInfo> asstDimMap = null;

    protected Context getCtx() {
        return this.ctx;
    }

    protected TempTablePool getPool() {
        if (this.pool == null) {
            this.pool = TempTablePool.getInstance((Context)this.getCtx());
        }
        return this.pool;
    }

    protected Connection getConn() {
        try {
            if (this.conn.isClosed()) {
                return null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.conn;
    }

    protected IDimensionParameter getParameter() {
        return this.parameter;
    }

    protected void setCurrOrgUnit(OrgUnitInfo currOrgUnit) {
        this.currOrgUnit = currOrgUnit;
    }

    protected OrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }

    public boolean isFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public List<BgExamineInfo> getExamine() {
        return this.examine;
    }

    public void setExamine(List<BgExamineInfo> examine) {
        this.examine = examine;
    }

    public Map<BOSUuid, List<MbgExamCalcObj>> getExamCalcObjs() {
        return this.examCalcObjs;
    }

    public void setExamCalcObjs(Map<BOSUuid, List<MbgExamCalcObj>> examCalcObjs) {
        this.examCalcObjs = examCalcObjs;
    }

    public void setCurrCompany(OrgUnitInfo currCompany) {
        this.currCompany = currCompany;
    }

    protected OrgUnitInfo getCurrCompany() {
        return this.currCompany;
    }

    protected void setCurrProfitCenter(OrgUnitInfo currProfitCenter) {
        this.currProfitCenter = currProfitCenter;
    }

    protected OrgUnitInfo getCurrProfitCenter() {
        return this.currProfitCenter;
    }

    protected Map<String, BgPeriodInfo> getPeriodMap() {
        return this.periodMap;
    }

    public Map<String, List<Object[]>> getExpObjMap() {
        return this.expObjMap;
    }

    protected Map<String, List<Object[]>> getMbgExpObjMap() {
        return this.mgbExpObjMap;
    }

    public Set<String> getNoPostExpr() {
        return this.noPostExpr;
    }

    protected Map<String, List<String[]>> getAccGroupMap() {
        return this.accgroupMap;
    }

    protected Set<String> getAcctItems() {
        return this.acctItems;
    }

    protected Map<String, Integer> getOrgTree() {
        return this.orgTree;
    }

    protected Map<String, String> getDefaultMap() {
        return this.defaultMap;
    }

    public Map<String, Map<String, Set<String>>> getCfsMemberMap() {
        return this.cfsMemberMap;
    }

    public Map<String, Map<String, Object[]>> getBgFormulaMap() {
        return this.bgFormulaMap;
    }

    public BizCalcExpreUtils(Context ctx, Connection conn, IDimensionParameter parameter) {
        this.ctx = ctx;
        if (parameter instanceof DimensionParameter && parameter.getBillId() != null && parameter.getDataManager() != null) {
            this.ctx.put((Object)BILLID, (Object)parameter.getBillId().toString());
            this.ctx.put((Object)BGFORMINFO, (Object)parameter.getDataManager().getDimDataQuery());
        }
        this.conn = conn;
        this.parameter = parameter;
        parameter.setExpressValues(parameter.getExpressValues() != null ? parameter.getExpressValues() : new ExpressValues());
        parameter.getExpressValues().conn = conn;
        parameter.getExpressValues().ctx = ctx;
        parameter.getExpressValues().parameter = parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calc(List<ICalcMember> members) throws Exception {
        if (!BizExprUtils.hasExp(members)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin expression calculate!");
        try {
            this.beforeCalc();
            this.calcExpr(members);
        }
        catch (Exception ex) {
            logger.error((Object)"mdx expression calc error:", (Throwable)ex);
        }
        finally {
            this.afterCalc();
        }
        logger.debug((Object)"invoke end expression calculate!");
        logger.debug((Object)("invoke interface process allUse = " + (System.currentTimeMillis() - startTime) + " ms;"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BigDecimal> calcs(List<BgExamineFacadeControllerBean.ExprDimQuery> querys) {
        if (this.checkCalcs(querys)) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin expression calculate!");
        try {
            this.beforeCalc();
            this.calcsExpr(querys);
        }
        catch (Exception ex) {
            logger.error((Object)"mdx expression calc error:", (Throwable)ex);
        }
        logger.debug((Object)"invoke end expression calculate!");
        logger.debug((Object)("invoke interface process allUse = " + (System.currentTimeMillis() - startTime) + " ms;"));
        return null;
    }

    public boolean isSupportDimState() {
        return this.supportDimState;
    }

    public void setSupportDimState(boolean supportDimState) {
        this.supportDimState = supportDimState;
    }

    public boolean isOrgSelectState() {
        return this.orgSelectState;
    }

    public void setOrgSelectState(boolean orgSelectState) {
        this.orgSelectState = orgSelectState;
    }

    public boolean isDimSelectState() {
        return this.dimSelectState;
    }

    public void setDimSelectState(boolean dimSelectState) {
        this.dimSelectState = dimSelectState;
    }

    public boolean isBeginPeriodState() {
        return this.beginPeriodState;
    }

    public void setBeginPeriodState(boolean beginPeriodState) {
        this.beginPeriodState = beginPeriodState;
    }

    public boolean isCurrencyState() {
        return this.currencyState;
    }

    public void setCurrencyState(boolean currencyState) {
        this.currencyState = currencyState;
    }

    public void checkInfoState(Expression expression) {
        boolean flag = false;
        List<BgExamineInfo> _examine = null;
        BgExamineInfo examine = null;
        Map<BOSUuid, List<MbgExamCalcObj>> examCalcObjs = null;
        List<MbgExamCalcObj> calcObjs = null;
        MbgExamCalcObj calcObject = null;
        if (this.isFlag()) {
            _examine = this.getExamine();
            examCalcObjs = this.getExamCalcObjs();
            block0: for (int i = 0; i < _examine.size(); ++i) {
                examine = _examine.get(i);
                if (!examCalcObjs.containsKey(examine.getId())) continue;
                calcObjs = examCalcObjs.get(examine.getId());
                for (int j = 0; j < calcObjs.size(); ++j) {
                    calcObject = calcObjs.get(j);
                    flag = this.setAcctInfoSelectState(expression, calcObject.members);
                    if (flag) continue block0;
                }
            }
        }
    }

    public boolean setAcctInfoSelectState(Expression expression, Map<String, IExpress> members) {
        IExpress expr2 = null;
        boolean flag = false;
        for (IExpress expr2 : members.values()) {
            if (!(expr2 instanceof FormulaExpr) || !"ACCT".equalsIgnoreCase(((FormulaExpr)expr2).formulaName) && !"ACCTITEM".equalsIgnoreCase(((FormulaExpr)expr2).formulaName)) continue;
            String str1 = ((FormulaExpr)expr2).params.toString().substring(((FormulaExpr)expr2).params.toString().indexOf(",") + 1, ((FormulaExpr)expr2).params.toString().length());
            String str2 = ((FunctionExpr)expression).parameters.toString().substring(((FunctionExpr)expression).parameters.toString().indexOf(",") + 1, ((FunctionExpr)expression).parameters.toString().length());
            flag = str1.equalsIgnoreCase(str2);
            break;
        }
        if (!flag) {
            return false;
        }
        Object calcObj = null;
        for (IExpress expr2 : members.values()) {
            if (!(expr2 instanceof MdxMemberExpr)) continue;
            String exprPlanString = expr2.toPlanString();
            String[] exprString = exprPlanString.split(",");
            for (int i = 0; i < exprString.length; ++i) {
                if (!exprString[i].contains(DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER) && !exprString[i].contains(DimensionBaseConstants.DEF_PERIOD_SRCNUMBER) && !exprString[i].contains(DimensionBaseConstants.DEF_ELEMENT_SRCNUMBER) && !exprString[i].contains(DimensionBaseConstants.DEF_CURRENCY_SRCNUMBER) && !exprString[i].contains(DimensionBaseConstants.DEF_VERSION_SRCNUMBER) && !exprString[i].contains(DimensionBaseConstants.DEF_SCHEME_SRCNUMBER) && !exprString[i].contains(DimensionBaseConstants.DEF_PROCESS_SRCNUMBER) && !exprString[i].contains(DimensionBaseConstants.DEF_SCENARIO_SRCNUMBER) && !exprString[i].contains(DimensionBaseConstants.DEF_INDEX_SRCNUMBER)) continue;
            }
            if (!exprPlanString.contains(DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER)) {
                this.orgSelectState = false;
            }
            if (!exprPlanString.contains(DimensionBaseConstants.DEF_INDEX_SRCNUMBER)) {
                this.dimSelectState = false;
            }
            if (!exprPlanString.contains(DimensionBaseConstants.DEF_PERIOD_SRCNUMBER)) {
                this.beginPeriodState = false;
            }
            if (exprPlanString.contains(DimensionBaseConstants.DEF_CURRENCY_SRCNUMBER)) continue;
            this.currencyState = false;
        }
        return true;
    }

    protected boolean checkCalcs(List<BgExamineFacadeControllerBean.ExprDimQuery> querys) {
        boolean re = true;
        if (querys == null || querys.isEmpty()) {
            return re;
        }
        for (BgExamineFacadeControllerBean.ExprDimQuery query : querys) {
            if (query.expr == null || query.formulaMaps.isEmpty()) continue;
            re = false;
            break;
        }
        return re;
    }

    public void beforeCalc() throws Exception {
        long startTime = System.currentTimeMillis();
        this.setCurrOrgUnit(this.getOrgUnitInfo(this.getParameter().getOrgUnitId()));
        this.setCurrCompany(this.getCompanyInfo());
        this.setCurrProfitCenter(this.getProfitCenterInfo());
        this.queryCostStr();
        this.queryAccountGroup();
        this.queryOrgTree();
        this.queryDefaultExtDimMap();
        this.getParameter().getExpressValues().currOrgUnit.put(this.currOrgUnit.getNumber(), this.currOrgUnit);
        this.getParameter().getExpressValues().currCompany.put(this.currOrgUnit.getNumber(), this.currCompany);
        this.getParameter().getExpressValues().currProfitCenter.put(this.currOrgUnit.getNumber(), this.currProfitCenter);
        this.getParameter().getExpressValues().accgroupMap.put(this.currOrgUnit.getNumber(), this.accgroupMap);
        this.getParameter().getExpressValues().costStrs.put(this.currOrgUnit.getNumber(), this.costStrs);
        this.getParameter().getExpressValues().orgTree.clear();
        this.getParameter().getExpressValues().orgTree.putAll(this.getOrgTree());
        logger.debug((Object)(" BizCalcExpreUtils beforeCalc process allUse = " + (System.currentTimeMillis() - startTime) + " ms;"));
    }

    private void queryCostStr() throws SQLException {
        if (this.getConn() == null) {
            return;
        }
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)this.getConn(), (String)"select Top 1 FID, FNumber, FRealtiondataobject from T_BD_AsstActType Where FRealtiondataobject = 'T_ORG_CostCenter'");
            if (rst.next()) {
                this.costStrs = new String[3];
                this.costStrs[0] = rst.getString("FID");
                this.costStrs[1] = rst.getString("FNumber");
                this.costStrs[2] = rst.getString("FRealtiondataobject");
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryDefaultExtDimMap() throws SQLException {
        if (this.getConn() == null) {
            return;
        }
        List viewIds = this.getParameter().getDataManager().getBgScheme().getExtDimViewIds();
        StringBuffer query = new StringBuffer();
        query.append("Select distinct m.FRefField, m.FSrcNumber, t.FNumber from T_MBG_MbgMember t left join T_MBG_MbgDim m on t.FDimId = m.FID where");
        if (viewIds != null && !viewIds.isEmpty()) {
            query.append(" t.FViewId IN (");
            int in = viewIds.size();
            for (int i = 0; i < in; ++i) {
                query.append("'" + viewIds.get(i) + "',");
            }
            query = query.delete(query.length() - 1, query.length());
            query.append(") and");
        }
        query.append(" t.FIsSystemDefault = 1");
        if (this.getParameter().getValueType() == 64 || this.getParameter().getValueType() == 128) {
            query.append(" and t.FIsleaf = 0");
        } else {
            query.append(" and t.FIsleaf = 1");
        }
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)this.getConn(), (String)query.toString());
            while (rst.next()) {
                this.getDefaultMap().put(rst.getString("FRefField"), rst.getString("FSrcNumber") + ":" + rst.getString("FNumber"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryOrgTree() throws Exception {
        if (this.getConn() == null) {
            return;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = this.getConn().prepareStatement("select fnumber , flayertype from T_ORG_TREE");
            rst = pstmt.executeQuery();
            String number = null;
            while (rst.next()) {
                number = rst.getString(1);
                int flayerType = rst.getInt(2);
                this.getOrgTree().put(number, flayerType);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, (Statement)pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    protected void calcExpr(List<ICalcMember> members) throws Exception {
        if (members == null || members.isEmpty()) {
            return;
        }
        HashSet<String> acctNums = new HashSet<String>();
        com.kingdee.eas.ma.mbg.dimension.face.IDimension bgIndexDim = this.getParameter().getBgIndexDimension();
        if (bgIndexDim == null) {
            return;
        }
        int in = bgIndexDim.getDimensionMember().size();
        for (int i = 0; i < in; ++i) {
            acctNums.add(((com.kingdee.eas.ma.mbg.dimension.face.IMember)bgIndexDim.getDimensionMember().get(i)).getDimNumber());
        }
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        HashSet<String> periodNums = new HashSet<String>();
        HashSet<String> currencyNums = new HashSet<String>();
        com.kingdee.eas.ma.mbg.dimension.face.IDimension periodDim = this.getParameter().getPeriodDimension();
        int in2 = periodDim.getDimensionMember().size();
        for (int i = 0; i < in2; ++i) {
            member = (com.kingdee.eas.ma.mbg.dimension.face.IMember)periodDim.getDimensionMember().get(i);
            periodNums.add(member.getNumber());
        }
        com.kingdee.eas.ma.mbg.dimension.face.IDimension currencyDim = this.getParameter().getCurrencyDimension();
        if (currencyDim != null) {
            int jn = currencyDim.getDimensionMember().size();
            for (int j = 0; j < jn; ++j) {
                member = (com.kingdee.eas.ma.mbg.dimension.face.IMember)currencyDim.getDimensionMember().get(j);
                currencyNums.add(member.getNumber());
            }
        } else if (this.getParameter().getDataManager().getDefCurrency() != null) {
            currencyNums.add(this.getParameter().getDataManager().getDefCurrency()[0]);
        }
        ICalcMember _calcMember = null;
        BizCalcMember calcMember = null;
        BizCalcSubsetInfo subCalc = null;
        IExpress expr = null;
        List<IExpress> express = null;
        ArrayList<BinaryExpr> calcExprs = null;
        HashMap<String, Map<String, String>> exprCalcMap = new HashMap<String, Map<String, String>>();
        Map<String, String> exprKeyMap = null;
        Object dimNumber = null;
        Object iDimension = null;
        Object dimensionMember = null;
        Map<String, Set<String>> curExtNumberMap = this.getCurExtNumberMap();
        int in3 = members.size();
        for (int i = 0; i < in3; ++i) {
            _calcMember = members.get(i);
            if (!(_calcMember instanceof BizCalcMember)) continue;
            calcMember = (BizCalcMember)_calcMember;
            int jn = calcMember.getCalc().getBizCalcSubset().size();
            for (int j = 0; j < jn; ++j) {
                subCalc = calcMember.getCalc().getBizCalcSubset().get(j);
                if (!subCalc.hasFormula) continue;
                express = subCalc.getExpres();
                calcExprs = new ArrayList<BinaryExpr>();
                int xn = express.size();
                for (int x = 0; x < xn; ++x) {
                    expr = express.get(x);
                    if (expr == null) continue;
                    calcExprs.addAll(this.getCalcExprs(expr));
                }
                if (calcExprs == null || calcExprs.isEmpty()) continue;
                Map<String, Set<String>> scopesMap = this.getScope(subCalc);
                for (BinaryExpr _expr : calcExprs) {
                    if (!(_expr.left instanceof MdxMemberExpr) || _expr.operType.getSID() != 20) continue;
                    MdxMemberExpr mdxMember = (MdxMemberExpr)_expr.left;
                    Map<String, String> dimNumMap = this.getDimNumber(mdxMember);
                    if (scopesMap.containsKey(DimensionBaseConstants.DEF_ORGUNIT_FIELD)) {
                        BizScopeCollection bizScopeColls = BizCalcExpreUtils.transNumToScopeColls(scopesMap.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD));
                        Set orgScopeSet = MbgFunctionFacadeFactory.getLocalInstance((Context)this.getCtx()).getOrgScopeByBizScope((IObjectCollection)bizScopeColls, this.getParameter().getBgOrgViewId().toString(), this.getParameter().getBgSchemeId().toString(), this.getParameter().getUnionId());
                        if (!orgScopeSet.contains(this.getCurrOrgUnit().getNumber())) continue;
                    }
                    if (scopesMap.containsKey(DimensionBaseConstants.DEF_VERSION_FIELD) && this.getParameter().getDataManager().getDimDataQuery() != null && this.getParameter().getDataManager().getDimDataQuery().getBizVersion() != null && !scopesMap.get(DimensionBaseConstants.DEF_VERSION_FIELD).contains(this.getParameter().getDataManager().getDimDataQuery().getBizVersion().getNumber())) continue;
                    String calcStr = _expr.toString();
                    FormulaExpr formulaExpr = null;
                    List<FormulaExpr> formulas = this.getFormulaExpr(_expr);
                    this.syncFormulaExpr(formulas);
                    int zn = formulas.size();
                    for (int z = 0; z < zn; ++z) {
                        formulaExpr = formulas.get(z);
                        if (exprCalcMap.containsKey(calcStr)) {
                            exprKeyMap = (Map)exprCalcMap.get(calcStr);
                        } else {
                            exprKeyMap = new HashMap();
                            exprCalcMap.put(calcStr, exprKeyMap);
                        }
                        exprKeyMap.put(TableToolkit.int2pos((int)z), formulaExpr.toString());
                        formulaExpr.getProps().put("initExpression", _expr.getOriginalExpr());
                        formulaExpr.getProps().put("FORMULA", calcStr);
                        formulaExpr.getProps().put("CODERULE", TableToolkit.int2pos((int)z));
                        formulaExpr.getProps().put("IncludePosted", subCalc.isIncludePost());
                        formulaExpr.getProps().put("IS_ZERO_UPDATE", subCalc.isIsZeroUpdate());
                        if (BizExprUtils.hasAcctExp(formulaExpr)) {
                            new Acct().builder(formulaExpr, acctNums, periodNums, currencyNums, dimNumMap, scopesMap, null, null, curExtNumberMap);
                            continue;
                        }
                        if (BizExprUtils.hasAcctItemExp(formulaExpr)) {
                            new AcctItem().builder(formulaExpr, acctNums, periodNums, currencyNums, dimNumMap, scopesMap, null);
                            continue;
                        }
                        if (!BizExprUtils.hasMbgFormulaExp(formulaExpr)) continue;
                        new MbgFormula().builder(formulaExpr, acctNums, periodNums, currencyNums, dimNumMap, scopesMap, null, curExtNumberMap);
                    }
                }
            }
        }
        long startTime = System.currentTimeMillis();
        this.calcValue(exprCalcMap);
        logger.debug((Object)(" BizCalcExpreUtils calcValue process allUse = " + (System.currentTimeMillis() - startTime) + " ms;"));
    }

    public BigDecimal calcExpressValue(Map<String, String> memberMap, String express, ExpressValues expressValues) throws Exception {
        if (StringUtils.isEmpty((String)express) || memberMap == null) {
            return null;
        }
        String orgMemberNumber = null;
        if (memberMap.containsKey(DimensionConstants.DEF_ORGUNIT_SRCNUMBER)) {
            orgMemberNumber = memberMap.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
        } else if (expressValues.currOrgUnit != null && !expressValues.currOrgUnit.keySet().isEmpty()) {
            ArrayList lst = new ArrayList(expressValues.currOrgUnit.keySet());
            orgMemberNumber = (String)lst.get(0);
        }
        if (StringUtils.isEmpty((String)orgMemberNumber)) {
            return null;
        }
        this.expObjMap.clear();
        this.asstDimMap = (Map)expressValues.asstDimMap.get(orgMemberNumber);
        this.currCompany = (OrgUnitInfo)expressValues.currCompany.get(orgMemberNumber);
        this.currOrgUnit = (OrgUnitInfo)expressValues.currOrgUnit.get(orgMemberNumber);
        this.currProfitCenter = (OrgUnitInfo)expressValues.currProfitCenter.get(orgMemberNumber);
        this.costStrs = (String[])expressValues.costStrs.get(orgMemberNumber);
        this.getPeriodMap().putAll(expressValues.periodMap);
        this.getAccGroupMap().putAll((Map)expressValues.accgroupMap.get(orgMemberNumber));
        HashSet<String> acctNums = new HashSet<String>();
        HashSet<String> periodNums = new HashSet<String>();
        HashSet<String> currencyNums = new HashSet<String>();
        HashMap<String, String> dimNumMap = new HashMap<String, String>();
        HashMap<String, Set<String>> curExtNumberMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> scopesMap = new HashMap<String, Set<String>>();
        String field = null;
        for (String srcNumber : memberMap.keySet()) {
            field = (String)this.parameter.getDataManager().getSrcFieldMap().get(srcNumber);
            if (field == null) continue;
            if (DimensionConstants.DEF_PERIOD_FIELD.equals(field)) {
                periodNums.add(memberMap.get(srcNumber));
                continue;
            }
            if (DimensionConstants.DEF_CURRENCY_FIELD.equals(field)) {
                currencyNums.add(memberMap.get(srcNumber));
                continue;
            }
            if (DimensionConstants.DEF_BGINDEX_FIELD.equals(field)) {
                acctNums.add(DimUtils.getDimNumber((String)srcNumber, (String)memberMap.get(srcNumber)));
                dimNumMap.put(field, DimUtils.getDimNumber((String)srcNumber, (String)memberMap.get(srcNumber)));
                curExtNumberMap.put(field, new HashSet());
                ((Set)curExtNumberMap.get(field)).add(DimUtils.getDimNumber((String)srcNumber, (String)memberMap.get(srcNumber)));
                continue;
            }
            if (DimUtils.checkBaseDimensionByField((String)field)) continue;
            dimNumMap.put(field, DimUtils.getDimNumber((String)srcNumber, (String)memberMap.get(srcNumber)));
            curExtNumberMap.put(field, new HashSet());
            ((Set)curExtNumberMap.get(field)).add(DimUtils.getDimNumber((String)srcNumber, (String)memberMap.get(srcNumber)));
        }
        if (currencyNums.isEmpty() && this.parameter.getDataManager().getDefCurrency() != null) {
            currencyNums.add(this.parameter.getDataManager().getDefCurrency()[0]);
        }
        FormulaExpr formulaExpr = FormulaProxy.getFormulaExpr(express);
        formulaExpr.getProps().put("FORMULA", express);
        formulaExpr.getProps().put("CODERULE", TableToolkit.int2pos((int)0));
        if (BizExprUtils.hasAcctExp(formulaExpr)) {
            new Acct().builder(formulaExpr, acctNums, periodNums, currencyNums, dimNumMap, scopesMap, null, null, curExtNumberMap);
        } else if (BizExprUtils.hasAcctItemExp(formulaExpr)) {
            new AcctItem().builder(formulaExpr, acctNums, periodNums, currencyNums, dimNumMap, scopesMap, null);
        } else if (BizExprUtils.hasMbgFormulaExp(formulaExpr)) {
            new MbgFormula().builder(formulaExpr, acctNums, periodNums, currencyNums, dimNumMap, scopesMap, null, curExtNumberMap);
        }
        BigDecimal value = null;
        List<Object[]> keyObjs = null;
        Map valueObjs = null;
        for (String exprKey : this.expObjMap.keySet()) {
            if (!expressValues.expObjMap.containsKey(orgMemberNumber) && !((Map)expressValues.expObjMap.get(orgMemberNumber)).containsKey(exprKey)) continue;
            keyObjs = this.expObjMap.get(exprKey);
            valueObjs = (Map)expressValues.expObjMap.get(orgMemberNumber);
            List list = (List)valueObjs.get(exprKey);
            if (list == null) continue;
            for (Object[] keyObj : keyObjs) {
                for (Object[] valueObj : list) {
                    if (!this.getMemberKey(keyObj).equals(this.getMemberKey(valueObj)) || valueObj[4] == null) continue;
                    return (BigDecimal)valueObj[4];
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calcValue(Map<String, Map<String, String>> exprCalcMap) throws BOSException {
        Object[] calcObj = null;
        List<Object[]> tmpObjs = null;
        Object[] mbgCalcObj = null;
        List<Object[]> mbgTmpObjs = null;
        Map<String, String> exprKeyMap = null;
        if (!this.getExpObjMap().isEmpty() || !this.getNoPostExpr().isEmpty()) {
            Object[] formulaObj;
            Iterator<String> ite;
            int in;
            BigDecimal value = null;
            Variant varient = null;
            Variant[] varients = null;
            ArrayList<String> _formulas = new ArrayList<String>();
            HashMap<String, String> mbgExpTmpMap = new HashMap<String, String>();
            if (this.getMbgExpObjMap() != null && this.getMbgExpObjMap().size() > 0) {
                Iterator<String> it = this.getMbgExpObjMap().keySet().iterator();
                while (it.hasNext()) {
                    String key = it.next().toString();
                    String[] keys = key.split("\\$");
                    if (StringUtils.isEmpty((String)keys[0])) continue;
                    mbgExpTmpMap.put(keys[0], key);
                }
            }
            if (!this.getNoPostExpr().isEmpty()) {
                _formulas.clear();
                _formulas.addAll(this.getNoPostExpr());
                Collections.sort(_formulas);
                long startTime = System.currentTimeMillis();
                varients = ReportFactory.getLocalInstance((Context)this.getCtx()).calcFormulas(_formulas, (IContextHandler)new ContextHandler());
                logger.debug((Object)(" BizCalcExpreUtils ReportFactory.getLocalInstance(getCtx()).calcFormulas process allUse = " + (System.currentTimeMillis() - startTime) + " ms;"));
                in = _formulas.size();
                for (int i = 0; i < in; ++i) {
                    varient = varients[i];
                    if (varient != null && varient.getValue() instanceof BigDecimal) {
                        value = (BigDecimal)varient.getValue();
                        if (logger.isDebugEnabled()) {
                            logger.error((Object)("formula = '" + (String)_formulas.get(i) + "; value = " + value.toPlainString()));
                        }
                        if ((tmpObjs = this.getExpObjMap().get(_formulas.get(i))) != null) {
                            int jn = tmpObjs.size();
                            for (int j = 0; j < jn; ++j) {
                                calcObj = tmpObjs.get(j);
                                if (calcObj == null) continue;
                                calcObj[4] = value;
                            }
                        }
                        if (this.getMbgExpObjMap().size() > 0 && mbgExpTmpMap.containsKey(_formulas.get(i))) {
                            String key = (String)mbgExpTmpMap.get(_formulas.get(i));
                            mbgTmpObjs = this.getMbgExpObjMap().get(key);
                            if (mbgTmpObjs != null) {
                                int jn = mbgTmpObjs.size();
                                for (int j = 0; j < jn; ++j) {
                                    mbgCalcObj = mbgTmpObjs.get(j);
                                    if (mbgCalcObj == null) continue;
                                    mbgCalcObj[4] = value;
                                }
                            }
                        }
                        mbgTmpObjs = null;
                    }
                    ite = this.getBgFormulaMap().keySet().iterator();
                    while (ite.hasNext()) {
                        Map<String, Object[]> tmpMap = this.getBgFormulaMap().get(ite.next());
                        for (String bgFormula : tmpMap.keySet()) {
                            formulaObj = tmpMap.get(bgFormula);
                            if (formulaObj == null || formulaObj[0] == null || !((String)_formulas.get(i)).equalsIgnoreCase((String)formulaObj[0])) continue;
                            formulaObj[1] = value;
                        }
                    }
                }
            }
            _formulas.clear();
            _formulas.addAll(this.getExpObjMap().keySet());
            _formulas.removeAll(this.getNoPostExpr());
            Collections.sort(_formulas);
            if (!_formulas.isEmpty()) {
                long startTime = System.currentTimeMillis();
                varients = MbgReportFacadeFactory.getLocalInstance((Context)this.getCtx()).calcFormulas(_formulas, null);
                logger.debug((Object)(" BizCalcExpreUtils MbgReportFacadeFactory.getLocalInstance(getCtx()).calcFormulas process allUse = " + (System.currentTimeMillis() - startTime) + " ms;"));
                in = _formulas.size();
                for (int i = 0; i < in; ++i) {
                    varient = varients[i];
                    if (varient != null && varient.getValue() instanceof BigDecimal) {
                        int jn;
                        value = (BigDecimal)varient.getValue();
                        if (logger.isDebugEnabled()) {
                            logger.error((Object)("formula = '" + (String)_formulas.get(i) + "; value = " + value.toPlainString()));
                        }
                        tmpObjs = this.getExpObjMap().get(_formulas.get(i));
                        if (this.getMbgExpObjMap().size() > 0 && mbgExpTmpMap.containsKey(_formulas.get(i))) {
                            String key = (String)mbgExpTmpMap.get(_formulas.get(i));
                            if (mbgTmpObjs != null && !mbgTmpObjs.isEmpty()) {
                                mbgTmpObjs.addAll((Collection<Object[]>)this.getMbgExpObjMap().get(key));
                            } else {
                                mbgTmpObjs = this.getMbgExpObjMap().get(key);
                            }
                        }
                        if (tmpObjs != null) {
                            jn = tmpObjs.size();
                            for (int j = 0; j < jn; ++j) {
                                calcObj = tmpObjs.get(j);
                                if (calcObj == null) continue;
                                calcObj[4] = value;
                            }
                        }
                        if (mbgTmpObjs != null) {
                            jn = mbgTmpObjs.size();
                            for (int j = 0; j < jn; ++j) {
                                mbgCalcObj = mbgTmpObjs.get(j);
                                if (mbgCalcObj == null) continue;
                                mbgCalcObj[4] = value;
                            }
                        }
                        mbgTmpObjs = null;
                    }
                    ite = this.getBgFormulaMap().keySet().iterator();
                    while (ite.hasNext()) {
                        Map<String, Object[]> tmpMap = this.getBgFormulaMap().get(ite.next());
                        for (String bgFormula : tmpMap.keySet()) {
                            formulaObj = tmpMap.get(bgFormula);
                            if (formulaObj == null || formulaObj[0] == null || !((String)_formulas.get(i)).equalsIgnoreCase((String)formulaObj[0])) continue;
                            formulaObj[1] = value;
                        }
                    }
                }
            }
            HashMap<String, Map<String, Map<String, BigDecimal>>> calcExprMap = new HashMap<String, Map<String, Map<String, BigDecimal>>>();
            Map memberMap = null;
            Map codeValueMap = null;
            Map<String, BigDecimal> memValueMap = null;
            HashMap<String, Map<String, BigDecimal>> calcValueMap = new HashMap<String, Map<String, BigDecimal>>();
            String calcStr = null;
            String memberKey = null;
            String script = null;
            String key2 = null;
            this.getCalcExprMap(calcExprMap, this.getExpObjMap());
            if (this.getMbgExpObjMap().size() > 0) {
                this.getCalcExprMap(calcExprMap, this.getMbgExpObjMap());
            }
            for (String key1 : this.getExpObjMap().keySet()) {
                if (!this.getParameter().getExpressValues().expObjMap.containsKey(this.getCurrOrgUnit().getNumber())) {
                    this.getParameter().getExpressValues().expObjMap.put(this.getCurrOrgUnit().getNumber(), new HashMap());
                }
                ((Map)this.getParameter().getExpressValues().expObjMap.get(this.getCurrOrgUnit().getNumber())).put(key1, new ArrayList());
                for (Object[] objs : this.getExpObjMap().get(key1)) {
                    ((List)((Map)this.getParameter().getExpressValues().expObjMap.get(this.getCurrOrgUnit().getNumber())).get(key1)).add(java.util.Arrays.copyOf(objs, objs.length));
                }
            }
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("js");
            SimpleScriptContext context = new SimpleScriptContext();
            Object result = null;
            Map.Entry entry2 = null;
            Map.Entry mEntry2 = null;
            Map.Entry vEntry2 = null;
            Map.Entry<String, String> eEntry2 = null;
            for (Map.Entry entry2 : calcExprMap.entrySet()) {
                calcStr = (String)entry2.getKey();
                memberMap = (Map)entry2.getValue();
                if (StringUtils.isEmpty((String)calcStr)) continue;
                if (calcValueMap.containsKey(calcStr)) {
                    memValueMap = (Map)calcValueMap.get(calcStr);
                } else {
                    memValueMap = new HashMap();
                    calcValueMap.put(calcStr, memValueMap);
                }
                script = calcStr.substring(calcStr.indexOf(61) + 1);
                exprKeyMap = exprCalcMap.get(calcStr);
                for (Map.Entry<String, String> eEntry2 : exprKeyMap.entrySet()) {
                    script = BizExprUtils.replace(script, eEntry2.getValue(), eEntry2.getKey());
                }
                for (Map.Entry mEntry2 : memberMap.entrySet()) {
                    memberKey = (String)mEntry2.getKey();
                    codeValueMap = (Map)mEntry2.getValue();
                    for (Map.Entry vEntry2 : codeValueMap.entrySet()) {
                        context.setAttribute((String)vEntry2.getKey(), vEntry2.getValue(), 100);
                    }
                    for (String key2 : exprKeyMap.keySet()) {
                        if (codeValueMap.containsKey(key2)) continue;
                        context.setAttribute(key2, null, 100);
                    }
                    try {
                        result = engine.eval(script, (ScriptContext)context);
                    }
                    catch (ScriptException ex) {
                        result = null;
                    }
                    finally {
                        if (result instanceof Double) {
                            Double _value = (Double)result;
                            if (!_value.isNaN() && !_value.isInfinite()) {
                                memValueMap.put(memberKey, BigDecimal.valueOf(_value));
                            }
                            continue;
                        }
                        if (!(result instanceof Number)) continue;
                        memValueMap.put(memberKey, BigDecimal.valueOf(((Number)result).doubleValue()));
                    }
                }
            }
            this.updateValueExpression(calcValueMap, this.getExpObjMap());
            if (this.getMbgExpObjMap().size() > 0) {
                this.updateValueExpression(calcValueMap, this.getMbgExpObjMap());
            }
        }
    }

    private void updateValueExpression(Map<String, Map<String, BigDecimal>> calcValueMap, Map<String, List<Object[]>> expObjMap) {
        boolean hasAcctItem = this.hasAcctItem(expObjMap);
        for (List<Object[]> objs : expObjMap.values()) {
            for (Object[] obj : objs) {
                String calcStr = (String)obj[7];
                String memberKey = this.getMemberKey(obj);
                Map<String, BigDecimal> memValueMap = calcValueMap.get(calcStr);
                if (memValueMap == null) continue;
                if (hasAcctItem && !this.checkIsZeroUpdate(obj, expObjMap, memValueMap)) {
                    obj[4] = null;
                    continue;
                }
                obj[4] = memValueMap.get(memberKey);
            }
        }
    }

    private boolean hasAcctItem(Map<String, List<Object[]>> expObjMap) {
        for (String formula : expObjMap.keySet()) {
            if (formula.indexOf("ACCTITEM") < 0) continue;
            return true;
        }
        return false;
    }

    private boolean checkIsZeroUpdate(Object[] obj, Map<String, List<Object[]>> expObjMap, Map<String, BigDecimal> memValueMap) {
        String calcStr = (String)obj[7];
        String memberKey = this.getMemberKey(obj);
        return !this.isAllAcctItemValueZero(calcStr, expObjMap) || !obj[9].equals(Boolean.FALSE) || !(memValueMap.get(memberKey) instanceof BigDecimal) || BgNConstants.ZERO.compareTo(memValueMap.get(memberKey)) != 0;
    }

    private boolean isAllAcctItemValueZero(String calcStr, Map<String, List<Object[]>> expObjMap) {
        boolean isAllAcctItemValueZero = true;
        for (String formula : expObjMap.keySet()) {
            List<Object[]> objs = expObjMap.get(formula);
            if (formula.indexOf("ACCTITEM") < 0) continue;
            for (Object[] obj : objs) {
                if (!((String)obj[7]).equals(calcStr) || obj[4] == null || !(obj[4] instanceof BigDecimal) || BgNConstants.ZERO.compareTo((BigDecimal)obj[4]) == 0) continue;
                isAllAcctItemValueZero = false;
            }
        }
        return isAllAcctItemValueZero;
    }

    private void getCalcExprMap(Map<String, Map<String, Map<String, BigDecimal>>> calcExprMap, Map<String, List<Object[]>> expObjMap) {
        for (List<Object[]> objs : expObjMap.values()) {
            for (Object[] obj : objs) {
                Map<String, BigDecimal> codeValueMap;
                Map<Object, Object> memberMap;
                String calcStr = (String)obj[7];
                String memberKey = this.getMemberKey(obj);
                if (calcExprMap.containsKey(calcStr)) {
                    memberMap = calcExprMap.get(calcStr);
                } else {
                    memberMap = new HashMap();
                    calcExprMap.put(calcStr, memberMap);
                }
                if (memberMap.containsKey(memberKey)) {
                    codeValueMap = (Map)memberMap.get(memberKey);
                } else {
                    codeValueMap = new HashMap();
                    memberMap.put(memberKey, codeValueMap);
                }
                codeValueMap.put((String)obj[8], (BigDecimal)obj[4]);
            }
        }
    }

    private String getMemberKey(Object[] obj) {
        if (obj == null) {
            return null;
        }
        String objKey = obj[1] + "_" + obj[2] + "_" + obj[3];
        return objKey;
    }

    protected void calcsExpr(List<BgExamineFacadeControllerBean.ExprDimQuery> querys) throws Exception {
        if (querys == null || querys.isEmpty()) {
            return;
        }
        FormulaExpr formulaExpr2 = null;
        Map orgDimMap = null;
        Map mbgDimMap = null;
        Map<String, String> dimNumMap = null;
        String schemeNum = this.getParameter().getDataManager().getBgScheme().getNumber();
        String orgUnitNum = this.getParameter().getDataManager().getOrgUnit().getNumber();
        Set acctNums = null;
        Set<String> periodNums = null;
        Set<String> currencyNums = null;
        HashMap<String, Map<String, String>> exprCalcMap = new HashMap<String, Map<String, String>>();
        for (BgExamineFacadeControllerBean.ExprDimQuery query : querys) {
            if (query.expr == null || query.formulaMaps.isEmpty()) continue;
            Map<String, String> exprKeyMap = null;
            String calcStr = null;
            int z = -1;
            for (FormulaExpr formulaExpr2 : query.formulaMaps.values()) {
                calcStr = formulaExpr2.toPlanString();
                if (exprCalcMap.containsKey(calcStr)) {
                    exprKeyMap = (Map)exprCalcMap.get(calcStr);
                } else {
                    exprKeyMap = new HashMap();
                    exprCalcMap.put(calcStr, exprKeyMap);
                }
                exprKeyMap.put(TableToolkit.int2pos((int)(++z)), formulaExpr2.toString());
                if (!query.dimNumMap.containsKey(schemeNum) || !(orgDimMap = (Map)query.dimNumMap.get(schemeNum)).containsKey(orgUnitNum)) continue;
                mbgDimMap = (Map)orgDimMap.get(orgUnitNum);
                acctNums = (Set)mbgDimMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD);
                periodNums = this.clearSrcNumber((Set)mbgDimMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
                currencyNums = this.clearSrcNumber((Set)mbgDimMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
                dimNumMap = this.getDimNumber(query.expr);
                if (dimNumMap == null) continue;
                formulaExpr2.getProps().put("FORMULA", calcStr);
                formulaExpr2.getProps().put("CODERULE", TableToolkit.int2pos((int)z));
                if (BizExprUtils.hasAcctExp(formulaExpr2)) {
                    new Acct().builder(formulaExpr2, acctNums, periodNums, currencyNums, dimNumMap, query.exprDataMap, query, null, null);
                    continue;
                }
                if (!BizExprUtils.hasAcctItemExp(formulaExpr2)) continue;
                new AcctItem().builder(formulaExpr2, acctNums, periodNums, currencyNums, dimNumMap, query.exprDataMap, query);
            }
        }
        this.calcValue(exprCalcMap);
    }

    private Set<String> clearSrcNumber(Set<String> dimNumberSet) {
        HashSet<String> tmpSet = new HashSet<String>();
        if (dimNumberSet == null || dimNumberSet.isEmpty()) {
            return tmpSet;
        }
        for (String dimNumber : dimNumberSet) {
            tmpSet.add(DimUtils.getNumber((String)dimNumber));
        }
        return tmpSet;
    }

    public static BizScopeCollection transNumToScopeColls(Set<String> set) {
        BizScopeCollection scopeColls = new BizScopeCollection();
        if (set == null || set.isEmpty()) {
            return scopeColls;
        }
        String curMemNum2 = null;
        String funName = null;
        String curNum = null;
        BizScopeInfo scopeInfo = null;
        for (String curMemNum2 : set) {
            scopeInfo = new BizScopeInfo();
            if (curMemNum2.indexOf(ACCT_ITEM_STR) != -1) {
                funName = BizExprUtils.getFunctionNameByScopeMemNum(curMemNum2);
                curNum = BizExprUtils.getDimMemByScopeFunction(curMemNum2);
                scopeInfo.setBgMemberNum(curMemNum2);
                scopeInfo.setBizDataType(BgMemberSelectTypeEnum.Function);
                if (funName != null && funName.equals("Descendants")) {
                    scopeInfo.setFillType(DimensionMemberTypeEnum.AllSubordinate);
                } else if (funName != null && funName.equals("IDescendants")) {
                    scopeInfo.setFillType(DimensionMemberTypeEnum.IncludeAddSub);
                } else if (funName != null && funName.equals("Children")) {
                    scopeInfo.setFillType(DimensionMemberTypeEnum.DirectSubordinate);
                } else if (funName != null && funName.equals("IChildrens")) {
                    scopeInfo.setFillType(DimensionMemberTypeEnum.IncludeDirectSub);
                } else if (funName != null && funName.equals("Siblings")) {
                    scopeInfo.setFillType(DimensionMemberTypeEnum.AllEqual);
                } else if (funName != null && funName.equals("ISiblings")) {
                    scopeInfo.setFillType(DimensionMemberTypeEnum.IncludeAddEqual);
                }
                scopeColls.add(scopeInfo);
            } else {
                scopeInfo.setBgMemberNum(curMemNum2);
                scopeInfo.setBizDataType(BgMemberSelectTypeEnum.Member);
                scopeInfo.setFillType(DimensionMemberTypeEnum.Normal);
            }
            scopeColls.add(scopeInfo);
        }
        return scopeColls;
    }

    private String getDimNumber(String acctNum, boolean isAsstCost) {
        if (acctNum == null) {
            return null;
        }
        String dimNumber = "";
        String[] tmpStrs = acctNum.split(",");
        if (tmpStrs != null) {
            for (String number : tmpStrs) {
                if (number.indexOf("|") > 0) {
                    String[] tmpSeps = number.split("\\|");
                    if (tmpSeps == null || this.costStrs != null && this.costStrs[1].equals(tmpSeps[0]) && !isAsstCost) continue;
                    dimNumber = dimNumber + "," + tmpSeps[1];
                    continue;
                }
                dimNumber = dimNumber + "," + number;
            }
            if (dimNumber.length() > 0) {
                dimNumber = dimNumber.substring(1);
            }
        }
        return dimNumber;
    }

    private List<BinaryExpr> getCalcExprs(IExpress expr) {
        List<IExpress> expres;
        if (expr == null) {
            return null;
        }
        ArrayList<BinaryExpr> calcExprs = new ArrayList<BinaryExpr>();
        if (expr instanceof BinaryExpr && BizExprUtils.hasExp((BinaryExpr)expr)) {
            calcExprs.add((BinaryExpr)expr);
        } else if (expr instanceof ConditionExpr && (expres = ((ConditionExpr)expr).getAllExpresss()) != null) {
            for (IExpress _expr : expres) {
                if (!(_expr instanceof BinaryExpr) || !BizExprUtils.hasExp((BinaryExpr)_expr)) continue;
                calcExprs.add((BinaryExpr)_expr);
            }
        }
        return calcExprs;
    }

    private List<FormulaExpr> getFormulaExpr(BinaryExpr expr) {
        ArrayList<FormulaExpr> fromulas = new ArrayList<FormulaExpr>();
        if (expr == null) {
            return fromulas;
        }
        this.getFormulaExpr(expr, fromulas);
        return fromulas;
    }

    private void getFormulaExpr(BinaryExpr expr, List<FormulaExpr> fromulas) {
        if (expr == null || fromulas == null) {
            return;
        }
        this.getFormulaExpr(expr.left, fromulas);
        this.getFormulaExpr(expr.right, fromulas);
    }

    private void getFormulaExpr(IExpress expr, List<FormulaExpr> fromulas) {
        FormulaExpr formulaExpr = null;
        if (expr instanceof BinaryExpr) {
            this.getFormulaExpr((BinaryExpr)expr, fromulas);
        } else if (expr instanceof FormulaExpr) {
            formulaExpr = (FormulaExpr)expr;
            fromulas.add(formulaExpr);
        } else if (expr instanceof ConditionExpr) {
            this.getFormulaExpr((ConditionExpr)expr, fromulas);
        }
    }

    private void getFormulaExpr(ConditionExpr expr, List<FormulaExpr> fromulas) {
        if (expr == null || fromulas == null) {
            return;
        }
        for (IExpress _expr : expr.getAllExpresss()) {
            this.getFormulaExpr(_expr, fromulas);
        }
    }

    private void syncFormulaExpr(List<FormulaExpr> exprs) {
        StringExpr parm;
        if (exprs == null || exprs.isEmpty()) {
            return;
        }
        boolean checkDouble = false;
        for (FormulaExpr formula : exprs) {
            parm = (StringExpr)formula.params.get(1);
            if (!ACCT_ITEMS_STR.equals(parm.value)) continue;
            checkDouble = true;
        }
        if (checkDouble) {
            for (FormulaExpr formula : exprs) {
                parm = (StringExpr)formula.params.get(1);
                if (!ACCT_ITEM_STR.equals(parm.value)) continue;
                parm.value = ACCT_ITEMS_STR;
            }
        }
    }

    private Map<String, Set<String>> getScope(BizCalcSubsetInfo subCalc) throws Exception {
        if (subCalc == null || subCalc.getScope() == null || subCalc.getScope().isEmpty()) {
            return new HashMap<String, Set<String>>();
        }
        return subCalc.getScopeData(this.parameter.getDataManager().getVariate(), DimUtils.getPeriodStandardNumber((IDimensionParameter)this.getParameter()), this.parameter.getPeriodCheckScope(), true, true, this.ctx, this.parameter.getDataManager().getBgScheme(), this.parameter.getDataManager().getDimensions());
    }

    private Map<String, String> getDimNumber(MdxMemberExpr expr) {
        HashMap<String, String> dimNumMap = new HashMap<String, String>();
        if (expr == null || expr.params == null || expr.params.isEmpty()) {
            return dimNumMap;
        }
        IExpress param = null;
        int in = expr.params.size();
        for (int i = 0; i < in; ++i) {
            param = expr.params.get(i);
            if (!(param instanceof MemberExpr)) continue;
            if (DimUtils.checkBaseDimensionByField((String)((MemberExpr)param).field)) {
                dimNumMap.put(((MemberExpr)param).field, ((MemberExpr)param).number);
                continue;
            }
            dimNumMap.put(((MemberExpr)param).field, ((MemberExpr)param).getDimNumber());
        }
        return dimNumMap;
    }

    protected void afterCalc() throws Exception {
        BgFormInfo tmp;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension scenDim;
        int i;
        int in;
        String[] tmpStrs;
        if (this.getExpObjMap().isEmpty()) {
            return;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        HashSet<String> editScens = new HashSet<String>();
        HashSet<String> quscens = new HashSet<String>();
        String editScenNum = this.getParameter().getEditScenNumber();
        if (!StringUtils.isEmpty((String)editScenNum) && (tmpStrs = editScenNum.split(",")) != null) {
            in = tmpStrs.length;
            for (i = 0; i < in; ++i) {
                editScens.add(tmpStrs[i]);
            }
        }
        if ((scenDim = this.getParameter().getScenarioDimension()) != null) {
            in = scenDim.getDimensionMember().size();
            for (i = 0; i < in; ++i) {
                member = (com.kingdee.eas.ma.mbg.dimension.face.IMember)scenDim.getDimensionMember().get(i);
                quscens.add(member.getNumber());
            }
        } else if (this.getParameter().getDataManager().getDefScenario() != null) {
            quscens.add(this.getParameter().getDataManager().getDefScenario()[0]);
        }
        HashSet<String> queles = new HashSet<String>();
        com.kingdee.eas.ma.mbg.dimension.face.IDimension eleDim = this.getParameter().getElementDimension();
        if (eleDim != null) {
            int in2 = eleDim.getDimensionMember().size();
            for (int i2 = 0; i2 < in2; ++i2) {
                member = (com.kingdee.eas.ma.mbg.dimension.face.IMember)eleDim.getDimensionMember().get(i2);
                queles.add(member.getNumber());
            }
        } else if (this.getParameter().getDataManager().getDefElement() != null) {
            queles.add(this.getParameter().getDataManager().getDefElement()[0]);
        }
        HashSet<String> quvers = new HashSet<String>();
        com.kingdee.eas.ma.mbg.dimension.face.IDimension verDim = this.getParameter().getVersionDimension();
        if (verDim != null) {
            int in3 = verDim.getDimensionMember().size();
            for (int i3 = 0; i3 < in3; ++i3) {
                member = (com.kingdee.eas.ma.mbg.dimension.face.IMember)verDim.getDimensionMember().get(i3);
                quvers.add(member.getNumber());
            }
        } else if (this.getParameter().getDataManager().getDefVersion() != null) {
            quvers.add(this.getParameter().getDataManager().getDefVersion()[0]);
        }
        Map<String, String> defaultMap = this.getDefaultMap();
        List<String> extFields = this.getExtFields();
        HashSet<String> eles = new HashSet<String>();
        HashSet<String> scens = new HashSet<String>();
        HashSet<String> versions = new HashSet<String>();
        TreeMap<String, String> dimsMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(1);
                String str2 = o2.substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        Map srcFieldMap = MbgQingAnalyseHelper.getSrcFieldMap((Context)this.ctx, (IDimensionParameter)this.getParameter());
        Map verNumInnMap = (Map)this.parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_VERSION_FIELD);
        Map scenNumInnMap = (Map)this.parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_SCENARIO_FIELD);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)this.getCtx());
        String userId = user != null ? user.getId().toString() : null;
        int valueType = MbgDataFacade.getDataType((int)this.getParameter().getValueType());
        if (this.getParameter().getDataManager() != null && this.getParameter().getDataManager().getDimDataQuery() != null && this.getParameter().getDataManager().getDimDataQuery() instanceof BgFormInfo && BgFormStateEnum.Adjusted == (tmp = (BgFormInfo)this.getParameter().getDataManager().getDimDataQuery()).getState()) {
            valueType = DimensionConstants.ADJUST_DATA_TYPE;
            if (tmp.getAdjust().getId() != null) {
                this.getParameter().setBillId(tmp.getAdjust().getId());
            }
        }
        IMbgDataFacade facade = MbgDataFacade.getInstance((Context)this.getCtx(), (String)userId, (String)this.getParameter().getBgSchemeId().toString(), (int)valueType);
        facade.setBillId(this.getParameter().getBillId() != null ? this.getParameter().getBillId().toString() : null);
        facade.setUnionId(this.getParameter().getUnionId() != null ? this.getParameter().getUnionId().toString() : null);
        facade.setIgnoreDataState(true);
        this.getMbgDataFacade(this.getParameter().getOrgUnitId(), this.getParameter().getUnionId(), editScens, quscens, queles, quvers, defaultMap, extFields, eles, scens, versions, dimsMap, srcFieldMap, verNumInnMap, scenNumInnMap, facade, this.getExpObjMap());
        if (this.getMbgExpObjMap().size() > 0) {
            this.getMbgDataFacade(this.getParameter().getOrgUnitId(), this.getParameter().getUnionId(), editScens, quscens, queles, quvers, defaultMap, extFields, eles, scens, versions, dimsMap, srcFieldMap, verNumInnMap, scenNumInnMap, facade, this.getMbgExpObjMap());
        }
    }

    private void getMbgDataFacade(BOSUuid orgUnitId, BOSUuid unionId, Set<String> editScens, Set<String> quscens, Set<String> queles, Set<String> quvers, Map<String, String> defaultMap, List<String> extFields, Set<String> eles, Set<String> scens, Set<String> versions, Map<String, String> dimsMap, Map<String, String> srcFieldMap, Map<String, String> verNumInnMap, Map<String, String> scenNumInnMap, IMbgDataFacade facade, Map<String, List<Object[]>> expObjMap) {
        String formulaStr = null;
        String _orgUnitId = null;
        String _unionId = null;
        String[] param = null;
        String[] tmpStrs = null;
        String[] fields = null;
        Object[] calcObj = null;
        Set tmpSet = null;
        List<Object[]> calcObjs2 = null;
        BigDecimal value = null;
        Map dimNumMap = null;
        Map scopesMap = null;
        HashMap<String, Set> addScopeMap = new HashMap<String, Set>();
        List result = new ArrayList();
        MbgData mbgData = null;
        _orgUnitId = orgUnitId != null ? orgUnitId.toString() : null;
        _unionId = unionId != null ? unionId.toString() : null;
        Map<String, Set<String>> curExtNumberMap = this.getCurExtNumberMap();
        for (List<Object[]> calcObjs2 : expObjMap.values()) {
            if (calcObjs2 == null || calcObjs2.isEmpty()) continue;
            int xn = calcObjs2.size();
            for (int x = 0; x < xn; ++x) {
                String item;
                calcObj = calcObjs2.get(x);
                dimNumMap = (Map)calcObj[5];
                scopesMap = (Map)calcObj[6];
                value = null;
                if (calcObj[4] instanceof BigDecimal) {
                    value = (BigDecimal)calcObj[4];
                }
                if (value == null) continue;
                eles.clear();
                if (dimNumMap.containsKey(DimensionBaseConstants.DEF_ELEMENT_FIELD)) {
                    eles.add((String)dimNumMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD));
                } else if (scopesMap.containsKey(DimensionBaseConstants.DEF_ELEMENT_FIELD)) {
                    tmpSet = (Set)scopesMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD);
                    if (tmpSet != null) {
                        eles.addAll(tmpSet);
                    }
                } else {
                    eles.addAll(queles);
                }
                if (eles.isEmpty()) continue;
                scens.clear();
                if (dimNumMap.containsKey(DimensionBaseConstants.DEF_SCENARIO_FIELD)) {
                    scens.add((String)dimNumMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD));
                } else if (scopesMap.containsKey(DimensionBaseConstants.DEF_SCENARIO_FIELD)) {
                    tmpSet = (Set)scopesMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD);
                    if (tmpSet != null) {
                        scens.addAll(tmpSet);
                    }
                } else {
                    scens.addAll(quscens);
                }
                if (!editScens.isEmpty()) {
                    scens.retainAll(editScens);
                }
                if (scens.isEmpty()) continue;
                versions.clear();
                if (dimNumMap.containsKey(DimensionBaseConstants.DEF_VERSION_FIELD)) {
                    versions.add((String)dimNumMap.get(DimensionBaseConstants.DEF_VERSION_FIELD));
                } else if (scopesMap.containsKey(DimensionBaseConstants.DEF_VERSION_FIELD)) {
                    tmpSet = (Set)scopesMap.get(DimensionBaseConstants.DEF_VERSION_FIELD);
                    if (tmpSet != null) {
                        versions.addAll(tmpSet);
                    }
                } else {
                    versions.addAll(quvers);
                }
                if (versions.isEmpty() || dimNumMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD) != null && (item = (String)calcObj[1]) != null && item.startsWith("Acc:") && !item.startsWith((String)dimNumMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD))) continue;
                for (String verNum : versions) {
                    for (String eleNum : eles) {
                        for (String scenNum : scens) {
                            int in;
                            param = new String[]{(String)calcObj[1], (String)calcObj[2], eleNum, scenNum, (String)calcObj[3]};
                            tmpStrs = param[0].split(",");
                            dimsMap.clear();
                            if (tmpStrs != null) {
                                in = tmpStrs.length;
                                for (int i = 0; i < in; ++i) {
                                    if (!srcFieldMap.containsKey(DimUtils.getSrcNumber((String)tmpStrs[i]))) continue;
                                    dimsMap.put(srcFieldMap.get(DimUtils.getSrcNumber((String)tmpStrs[i])), tmpStrs[i]);
                                }
                            }
                            for (String field : extFields) {
                                if (dimNumMap.containsKey(field)) {
                                    dimsMap.put(field, (String)dimNumMap.get(field));
                                    continue;
                                }
                                if (dimsMap.containsKey(field)) continue;
                                if (curExtNumberMap.containsKey(field) && scopesMap != null && scopesMap.containsKey(field)) {
                                    tmpSet = curExtNumberMap.get(field);
                                    String number2 = null;
                                    for (String number2 : tmpSet) {
                                        if (!((Set)scopesMap.get(field)).contains(number2)) continue;
                                        if (!addScopeMap.containsKey(field)) {
                                            addScopeMap.put(field, new HashSet());
                                        }
                                        ((Set)addScopeMap.get(field)).add(number2);
                                    }
                                    continue;
                                }
                                if (defaultMap.containsKey(field)) {
                                    dimsMap.put(field, defaultMap.get(field));
                                    continue;
                                }
                                if (scopesMap == null || !scopesMap.containsKey(field)) continue;
                                tmpSet = (Set)scopesMap.get(field);
                                if (addScopeMap.containsKey(field)) continue;
                                addScopeMap.put(field, tmpSet);
                            }
                            if (addScopeMap.isEmpty()) {
                                param[0] = DimUtils.getDimNumber(dimsMap);
                                formulaStr = BgNFSHelper.getFormulaFromParam((String[])param);
                                mbgData = new MbgData();
                                mbgData.setOrgUnitId(_orgUnitId);
                                mbgData.setUnionId(_unionId);
                                mbgData.setFormula(formulaStr);
                                mbgData.setDimNumber(param[0]);
                                mbgData.setBgPeriodNum(param[1]);
                                mbgData.setBgElementNum(eleNum);
                                mbgData.setBgScenarioNum(scenNum);
                                mbgData.setVersionNum(verNum);
                                mbgData.setCurrencyNum(param[4]);
                                mbgData.setValue(value);
                                facade.addMbgData((IMbgData)mbgData);
                                if (!logger.isDebugEnabled() || value == null) continue;
                                continue;
                            }
                            if (result.isEmpty()) {
                                Map.Entry sEntry2 = null;
                                for (Map.Entry sEntry2 : addScopeMap.entrySet()) {
                                    result = Arrays.Cartesian(result, (String)((String)sEntry2.getKey()), (Collection)((Collection)sEntry2.getValue()));
                                }
                            }
                            if (result.isEmpty()) continue;
                            fields = (String[])result.get(0);
                            in = result.size();
                            for (int i = 1; i < in; ++i) {
                                tmpStrs = (String[])result.get(i);
                                for (int j = 0; j < tmpStrs.length; ++j) {
                                    dimsMap.put(fields[j], tmpStrs[j]);
                                }
                                param[0] = DimUtils.getDimNumber(dimsMap);
                                formulaStr = BgNFSHelper.getFormulaFromParam((String[])param);
                                mbgData = new MbgData();
                                mbgData.setOrgUnitId(_orgUnitId);
                                mbgData.setUnionId(_unionId);
                                mbgData.setFormula(formulaStr);
                                mbgData.setDimNumber(param[0]);
                                mbgData.setBgPeriodNum(param[1]);
                                mbgData.setBgElementNum(eleNum);
                                mbgData.setBgScenarioNum(scenNum);
                                mbgData.setVersionNum(verNum);
                                mbgData.setCurrencyNum(param[4]);
                                mbgData.setValue(value);
                                facade.addMbgData((IMbgData)mbgData);
                                if (logger.isDebugEnabled() && value == null) continue;
                            }
                        }
                    }
                }
            }
        }
    }

    private List<String> getExtFields() {
        ArrayList<String> extFields = new ArrayList<String>();
        Set dimNums = this.getParameter().getDataManager().getBgScheme().getExtDimNums(this.getParameter().getValueType());
        if (!dimNums.isEmpty()) {
            List dims = this.getParameter().getDims();
            if (!dims.isEmpty()) {
                for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dim : dims) {
                    if (!dimNums.contains(dim.getNumber())) continue;
                    extFields.add(dim.getField());
                }
            } else if (!this.getParameter().getDimensionMap().isEmpty()) {
                for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dim : this.getParameter().getDimensionMap().values()) {
                    if (!dimNums.contains(dim.getNumber())) continue;
                    extFields.add(dim.getField());
                }
            }
            DimUtils.sortFields(extFields);
        }
        return extFields;
    }

    protected String getOrgUnitNumber(BOSUuid orgUnitId, Map<String, String> dimNumMap) throws Exception {
        String orgUnitNumber = null;
        if (!dimNumMap.isEmpty() && dimNumMap.containsKey(DimensionConstants.DEF_ORGUNIT_FIELD) && dimNumMap.get(DimensionConstants.DEF_ORGUNIT_FIELD).indexOf(":") > 0) {
            orgUnitNumber = dimNumMap.get(DimensionConstants.DEF_ORGUNIT_FIELD).split(":")[1];
        }
        if (StringUtils.isEmpty(orgUnitNumber)) {
            if (this.getParameter().getExpressValues() != null) {
                if (!StringUtils.isEmpty((String)this.getParameter().getLocalOrgNum())) {
                    orgUnitNumber = this.getParameter().getLocalOrgNum();
                } else if (this.getCurrOrgUnit() != null && !StringUtils.isEmpty((String)this.getCurrOrgUnit().getNumber())) {
                    orgUnitNumber = this.getCurrOrgUnit().getNumber();
                } else if (orgUnitId != null && StringUtils.isEmpty((String)orgUnitNumber)) {
                    orgUnitNumber = this.getOrgUnitInfo(orgUnitId).getNumber();
                }
            } else if (orgUnitId != null) {
                orgUnitNumber = this.getOrgUnitInfo(orgUnitId).getNumber();
            }
        }
        return orgUnitNumber;
    }

    protected OrgUnitInfo getOrgUnitInfo(BOSUuid orgUnitId) throws Exception {
        return FullOrgUnitFactory.getLocalInstance((Context)this.getCtx()).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
    }

    protected OrgUnitInfo getCompanyInfo() throws Exception {
        Object orgUnit = null;
        OrgUnitCollection colls = OrgUnitRelationFactory.getLocalInstance((Context)this.getCtx()).getToUnit(this.getParameter().getOrgUnitId().toString(), 5, 1);
        orgUnit = colls != null && !colls.isEmpty() ? colls.get(0) : BgNFSHelper.getCompanyByOrgUnit((Context)this.getCtx(), (BOSUuid)this.getCurrOrgUnit().getId());
        return orgUnit;
    }

    protected OrgUnitInfo getProfitCenterInfo() throws Exception {
        Object orgUnit = null;
        OrgUnitCollection colls = OrgUnitRelationFactory.getLocalInstance((Context)this.getCtx()).getToUnit(this.getParameter().getOrgUnitId().toString(), 5, 6);
        orgUnit = colls != null && !colls.isEmpty() ? colls.get(0) : BgNFSHelper.getProfitCenterInfo((Context)this.getCtx(), (BOSUuid)this.getCurrOrgUnit().getId());
        return orgUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryAccountGroup() throws Exception {
        if (this.getConn() == null || this.getCurrCompany() == null) {
            return;
        }
        String tableName = "V_BD_AccountView";
        int re = BgDBUtils.existColumn((Connection)this.getConn(), (String)"V_BD_AccountView", (String)"fcaa");
        if (re == BgDBUtils.NO) {
            tableName = "T_BD_AccountView";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct v.FNUMBER, type.fid, type.FNUMBER  from " + tableName + " v inner join T_BD_AsstActGroupDetail d on v.fcaa = d.FASSTACCOUNTID inner join T_BD_AsstActType type on type.fid = d.FASSTACTTYPEID where v.FCompanyID = ? ");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String[] acctGroup = null;
        List<Object> groups = null;
        String acctNumber = null;
        String groupNumber = null;
        String groupId = null;
        try {
            pstmt = this.getConn().prepareStatement(sql.toString());
            pstmt.setString(1, this.getCurrCompany().getId().toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                acctNumber = rst.getString(1);
                groupId = rst.getString(2);
                groupNumber = rst.getString(3);
                if (this.getAccGroupMap().containsKey(acctNumber)) {
                    groups = this.getAccGroupMap().get(acctNumber);
                } else {
                    groups = new ArrayList();
                    this.getAccGroupMap().put(acctNumber, groups);
                }
                acctGroup = new String[]{groupId, groupNumber};
                groups.add(acctGroup);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryAcctItems() throws Exception {
        if (this.getConn() == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FNUMBER from T_CSL_RptItem");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = this.getConn().prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                this.getAcctItems().add(rst.getString("FNUMBER"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, MbgDimInfo> queryAsstActType(BOSUuid bgSchemeId) throws Exception {
        if (this.asstDimMap != null) {
            return this.asstDimMap;
        }
        this.asstDimMap = new HashMap<String, MbgDimInfo>();
        this.getParameter().getExpressValues().asstDimMap.put(this.getCurrOrgUnit().getNumber(), this.asstDimMap);
        if (this.getConn() == null || bgSchemeId == null) {
            return this.asstDimMap;
        }
        MbgDimInfo mbgDim = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = this.getConn().prepareStatement("select FNumber, FRefField, FSrcNumber, FAsstactTypeId from T_MBG_MbgDim where exists (select FDimNumber from T_MBG_BgDimSettings where FDimNumber = T_MBG_MbgDim.FNumber and FBgSchemeId = ?) and FAsstactTypeId is not null");
            pstmt.setString(1, bgSchemeId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                mbgDim = new MbgDimInfo();
                mbgDim.setNumber(rst.getString("FNumber"));
                mbgDim.setRefField(rst.getString("FRefField"));
                mbgDim.setSrcNumber(rst.getString("FSrcNumber"));
                mbgDim.setAsstActType(new AsstActTypeInfo());
                mbgDim.getAsstActType().setId(BOSUuid.read((String)rst.getString("FAsstactTypeId")));
                this.asstDimMap.put(rst.getString("FAsstactTypeId"), mbgDim);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = this.getConn().prepareStatement("SELECT d.FNumber, d.FRefField, d.FSrcNumber, n.FAsstactTypeId  FROM t_mbg_AsstActnode n left join t_mbg_mbgdim d on d.FID  = n.FMbgDimID where exists (select FDimNumber from T_MBG_BgDimSettings where FDimNumber = d.FNumber and FBgSchemeId = ?) and n.FAsstactTypeId is not null");
            pstmt.setString(1, bgSchemeId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                mbgDim = new MbgDimInfo();
                mbgDim.setNumber(rst.getString("FNumber"));
                mbgDim.setRefField(rst.getString("FRefField"));
                mbgDim.setSrcNumber(rst.getString("FSrcNumber"));
                mbgDim.setAsstActType(new AsstActTypeInfo());
                mbgDim.getAsstActType().setId(BOSUuid.read((String)rst.getString("FAsstactTypeId")));
                this.asstDimMap.put(rst.getString("FAsstactTypeId"), mbgDim);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, (Statement)pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return this.asstDimMap;
    }

    public Map<String, Set<String>> getCurExtNumberMap() {
        String dimNumber = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension iDimension = null;
        List dimensionMember = null;
        HashMap<String, Set<String>> curExtNumberMap = new HashMap<String, Set<String>>();
        Map dimensionMap = this.getParameter().getDimensionMap();
        if (dimensionMap != null) {
            for (String number : dimensionMap.keySet()) {
                if (DimUtils.checkBaseDimension((String)number) || DimensionConstants.DEF_CSL_NUMBER.equals(number) || DimensionConstants.DEF_INDEX_NUMBER.equals(number)) continue;
                iDimension = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)dimensionMap.get(number);
                dimensionMember = iDimension.getDimensionMember();
                curExtNumberMap.put(iDimension.getField(), new HashSet());
                for (int i = 0; i < dimensionMember.size(); ++i) {
                    if (dimensionMember.get(i) == null) continue;
                    dimNumber = ((com.kingdee.eas.ma.mbg.dimension.face.IMember)dimensionMember.get(i)).getSrcNumber() + DimensionConstants.COLON_SEPARATOR + ((com.kingdee.eas.ma.mbg.dimension.face.IMember)dimensionMember.get(i)).getNumber();
                    ((Set)curExtNumberMap.get(iDimension.getField())).add(dimNumber);
                }
            }
        }
        if (this.getParameter().getQuerys() != null && !this.getParameter().getQuerys().isEmpty()) {
            for (int x = 0; x < this.getParameter().getQuerys().size(); ++x) {
                IQueryData query = (IQueryData)this.getParameter().getQuerys().get(x);
                for (IDimension cDim : query.getMbgDimMap().values()) {
                    if (cDim.getField() == null || DimUtils.checkBaseDimension((String)cDim.getNumber()) || DimensionConstants.DEF_CSL_NUMBER.equals(cDim.getNumber()) || DimensionConstants.DEF_INDEX_NUMBER.equals(cDim.getNumber())) continue;
                    if (!curExtNumberMap.containsKey(cDim.getField())) {
                        curExtNumberMap.put(cDim.getField(), new HashSet());
                    }
                    if (cDim.getMembers() == null || cDim.getMembers().isEmpty()) continue;
                    for (IMember mem : cDim.getMembers()) {
                        dimNumber = mem.getSrcNumber() + DimensionConstants.COLON_SEPARATOR + mem.getNumber();
                        ((Set)curExtNumberMap.get(cDim.getField())).add(dimNumber);
                    }
                }
            }
        }
        return curExtNumberMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkElim(List parameter, Object[] calcObj) {
        if (parameter == null || calcObj == null) {
            return;
        }
        BgPeriodInfo bgPeriod = null;
        String bgPeriodNum = (String)calcObj[0];
        if (!this.getPeriodMap().containsKey(bgPeriodNum) && this.getConn() != null) {
            IRowSet rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)this.getConn(), (String)"select FNumber, FBeginDate, FEndDate, FPeriodType from T_MBG_BgPeriodDisp where FTYPEID IN (select FMemberId from T_MBG_BgDimSettingsMember where FBgDimSettingsId in (select FID from T_MBG_BgDimSettings where FbgSchemeId = ? and FDimNumber = ?))", (Object[])new Object[]{this.getParameter().getBgSchemeId().toString(), DimensionBaseConstants.DEF_PERIOD_NUMBER});
                while (rst.next()) {
                    bgPeriod = new BgPeriodInfo();
                    bgPeriod.setNumber(rst.getString("FNumber"));
                    bgPeriod.setBeginDate((Date)rst.getDate("FBeginDate"));
                    bgPeriod.setEndDate((Date)rst.getDate("FEndDate"));
                    bgPeriod.setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt("FPeriodType")));
                    this.getPeriodMap().put(bgPeriod.getNumber(), bgPeriod);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            catch (SQLException ex) {
                logger.error((Object)"checkAcct query period sql error:", (Throwable)ex);
            }
            finally {
                SQLUtils.cleanup(rst);
            }
        }
        bgPeriod = this.getPeriodMap().get(bgPeriodNum);
        this.getParameter().getExpressValues().periodMap.putAll(this.getPeriodMap());
        if (bgPeriod == null) {
            return;
        }
        int periodType = bgPeriod.getPeriodType().getValue();
        if ((periodType == 8 || periodType == 16 || periodType == 10 || periodType == 11 || periodType == 12 || periodType == 13 || periodType == 14 || periodType == 15 || periodType == 17) && this.getParameter().getDataManager().getDimDataQuery() != null && this.getParameter().getDataManager().getDimDataQuery().getBizPeriod() != null) {
            bgPeriod = this.getPeriodMap().get(this.getParameter().getDataManager().getDimDataQuery().getBizPeriod().getNumber());
        }
        if (bgPeriod == null) {
            return;
        }
        CalendarHelper helper = new CalendarHelper();
        int sYear = helper.getCurrentlyYear(bgPeriod.getBeginDate());
        int sMonth = helper.getCurrentlyMonth(bgPeriod.getBeginDate());
        int eMonth = helper.getCurrentlyMonth(bgPeriod.getEndDate());
        IntExpr beginYear = (IntExpr)parameter.get(8);
        if (beginYear.value == null) {
            beginYear.value = BigInteger.valueOf(0L);
        }
        if (beginYear.value.intValue() <= 0) {
            beginYear.value = BigInteger.valueOf(sYear + beginYear.value.intValue());
        }
        IntExpr beginMonth = (IntExpr)parameter.get(9);
        if (beginMonth.value == null) {
            beginMonth.value = BigInteger.valueOf(0L);
        }
        if (beginMonth.value.intValue() <= 0) {
            beginMonth.value = BigInteger.valueOf(sMonth + beginMonth.value.intValue());
        }
        IntExpr endMonth = (IntExpr)parameter.get(10);
        if (endMonth.value == null) {
            endMonth.value = BigInteger.valueOf(0L);
        }
        if (endMonth.value.intValue() <= 0) {
            endMonth.value = BigInteger.valueOf(eMonth + endMonth.value.intValue());
        }
        StringExpr currencyParam = (StringExpr)parameter.get(3);
        if (StringUtils.isEmpty((String)currencyParam.value)) {
            currencyParam.value = (String)calcObj[1];
        }
        currencyParam = (StringExpr)parameter.get(4);
        if (StringUtils.isEmpty((String)currencyParam.value)) {
            currencyParam.value = (String)calcObj[1];
        }
    }

    public void processBgFormulaMap(FormulaExpr formulaExpr, String formulaStr) {
        Object[] forObj;
        if ((String)formulaExpr.getProps().get("FORMULA") != null && !this.getBgFormulaMap().containsKey(formulaExpr.getProps().get("FORMULA"))) {
            this.getBgFormulaMap().put((String)formulaExpr.getProps().get("FORMULA"), new HashMap());
        }
        if ((String)formulaExpr.getProps().get("FORMULA") != null && !this.getBgFormulaMap().get(formulaExpr.getProps().get("FORMULA").toString()).containsKey(formulaExpr.toString())) {
            this.getBgFormulaMap().get(formulaExpr.getProps().get("FORMULA").toString()).put(formulaExpr.toString(), new Object[2]);
            forObj = this.getBgFormulaMap().get(formulaExpr.getProps().get("FORMULA").toString()).get(formulaExpr.toString());
            forObj[0] = formulaStr;
        }
        if ((String)formulaExpr.getProps().get("initExpression") != null && !this.getBgFormulaMap().containsKey(formulaExpr.getProps().get("initExpression"))) {
            this.getBgFormulaMap().put((String)formulaExpr.getProps().get("initExpression"), new HashMap());
        }
        if ((String)formulaExpr.getProps().get("initExpression") != null && !this.getBgFormulaMap().get(formulaExpr.getProps().get("initExpression").toString()).containsKey(formulaExpr.toString())) {
            this.getBgFormulaMap().get(formulaExpr.getProps().get("initExpression").toString()).put(formulaExpr.toString(), new Object[2]);
            forObj = this.getBgFormulaMap().get(formulaExpr.getProps().get("initExpression").toString()).get(formulaExpr.toString());
            forObj[0] = formulaStr;
        }
    }

    public class ElimData {
        public void builder(Set<String> periodNums, Set<String> currencyNums, FunctionExpr funExpr) throws Exception {
            if (funExpr == null || currencyNums == null || currencyNums.isEmpty() || periodNums == null || periodNums.isEmpty()) {
                return;
            }
            FormulaExpr formulaExpr = new FormulaExpr();
            formulaExpr.formulaName = funExpr.funcionName;
            formulaExpr.params = funExpr.parameters;
            if (!BizExprUtils.hasElimExp(formulaExpr)) {
                return;
            }
            HashSet<String> calcPNums = new HashSet<String>();
            HashSet<String> calcCNums = new HashSet<String>();
            ArrayList<String> periods = new ArrayList<String>();
            ArrayList<String> currencys = new ArrayList<String>();
            calcPNums.addAll(periodNums);
            periods.addAll(calcPNums);
            Collections.sort(periods);
            calcCNums.addAll(currencyNums);
            currencys.addAll(calcCNums);
            Collections.sort(currencys);
            ArrayList<Object[]> calcObjs = new ArrayList<Object[]>();
            Object[] calcObj = null;
            for (String periodNum : periods) {
                for (String currencyNum : currencys) {
                    calcObj = new Object[]{periodNum, currencyNum};
                    calcObjs.add(calcObj);
                }
            }
            Expression expression = null;
            int xn = calcObjs.size();
            for (int x = 0; x < xn; ++x) {
                final Object[] tmpObj = (Object[])calcObjs.get(x);
                expression = ExpressionUtils.clone((FormulaExpr)formulaExpr);
                expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                    public Expression handle(Expression expr) {
                        return ElimData.this.checkExpression(expr, tmpObj);
                    }
                });
                if (funExpr == null || !(expression instanceof FunctionExpr)) continue;
                funExpr.parameters = ((FunctionExpr)expression).parameters;
            }
        }

        protected Expression checkExpression(Expression expression, Object[] calcObj) {
            if (expression instanceof FunctionExpr) {
                expression = this.checkFunctionExpr((FunctionExpr)expression, calcObj);
            } else if (expression instanceof BinaryOperationExpr) {
                expression = this.checkBinaryOperationExpr((BinaryOperationExpr)expression, calcObj);
            }
            return expression;
        }

        protected Expression checkFunctionExpr(FunctionExpr funExpr, Object[] calcObj) {
            if ("ELIMDATA".equalsIgnoreCase(funExpr.funcionName)) {
                BizCalcExpreUtils.this.checkElim(funExpr.parameters, calcObj);
            }
            return funExpr;
        }

        protected BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, Object[] calcObj) {
            boExpr.left = this.checkExpression(boExpr.left, calcObj);
            boExpr.right = this.checkExpression(boExpr.right, calcObj);
            return boExpr;
        }
    }

    class MbgFormula {
        MbgFormula() {
        }

        public void builder(FormulaExpr formulaExpr, Set<String> acctNums, Set<String> periodNums, Set<String> currencyNums, final Map<String, String> dimNumMap, Map<String, Set<String>> scopesMap, BgExamineFacadeControllerBean.ExprDimQuery query, final Map<String, Set<String>> curExtNumberMap) throws Exception {
            if (!BizExprUtils.hasMbgFormulaExp(formulaExpr) || BizCalcExpreUtils.this.getParameter().getDataManager().getDimDataQuery() == null) {
                return;
            }
            HashSet<String> calcNums = new HashSet<String>();
            HashSet<String> calcPNums = new HashSet<String>();
            HashSet<String> calcCNums = new HashSet<String>();
            HashSet<String> tmpSet = new HashSet<String>();
            ArrayList<String> accts = new ArrayList<String>();
            ArrayList<String> periods = new ArrayList<String>();
            ArrayList<String> currencys = new ArrayList<String>();
            if (dimNumMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD)) {
                calcNums.add(dimNumMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD));
            }
            if (scopesMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD)) {
                calcNums.addAll((Collection)scopesMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD));
            }
            if (calcNums.isEmpty()) {
                calcNums.addAll(acctNums);
            }
            accts.addAll(calcNums);
            Collections.sort(accts);
            if (dimNumMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) {
                calcPNums.add(dimNumMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
            }
            if (scopesMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) {
                calcPNums.addAll((Collection)scopesMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
            }
            if (calcPNums.isEmpty()) {
                calcPNums.addAll(periodNums);
            }
            periods.addAll(calcPNums);
            Collections.sort(periods);
            HashMap<String, Set<Object>> tmpScopMap = new HashMap<String, Set<Object>>();
            if (curExtNumberMap != null && !curExtNumberMap.isEmpty()) {
                HashSet tmSet = null;
                Set<String> dimExtSrcNumberSet = null;
                boolean isExistExtDimmember = false;
                if (scopesMap instanceof Map) {
                    for (String field : scopesMap.keySet()) {
                        if (!(DimUtils.checkBaseDimensionByField((String)field) || DimensionConstants.DEF_CSL_FIELD.equals(field) || DimensionConstants.DEF_BGINDEX_FIELD.equals(field))) {
                            dimExtSrcNumberSet = scopesMap.get(field);
                            if (dimExtSrcNumberSet != null && !dimExtSrcNumberSet.isEmpty()) {
                                isExistExtDimmember = true;
                            }
                            if (curExtNumberMap.containsKey(field)) {
                                tmSet = new HashSet(curExtNumberMap.get(field));
                                tmSet.retainAll(dimExtSrcNumberSet);
                                if (tmpScopMap.containsKey(field) || tmSet.isEmpty()) continue;
                                tmpScopMap.put(field, tmSet);
                                continue;
                            }
                            tmpScopMap.put(field, scopesMap.get(field));
                            continue;
                        }
                        tmpScopMap.put(field, scopesMap.get(field));
                    }
                }
                if ((tmpScopMap == null || tmpScopMap.isEmpty()) && isExistExtDimmember && !BizExprUtils.hasMbgFormulaExp(formulaExpr)) {
                    return;
                }
            }
            if (dimNumMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD)) {
                calcCNums.add(dimNumMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
            }
            if (scopesMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD)) {
                calcCNums.addAll((Collection)scopesMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
            }
            if (calcCNums.isEmpty()) {
                calcCNums.addAll(currencyNums);
            }
            if (BizCalcExpreUtils.this.isFlag() && currencyNums != null && !currencyNums.isEmpty()) {
                calcCNums.clear();
                calcCNums.addAll(currencyNums);
            }
            currencys.addAll(calcCNums);
            Collections.sort(currencys);
            Object[] calcObj = null;
            String formulaStr = null;
            String refield2 = null;
            String number = null;
            Set<String> tmpScopeSet = null;
            List extFields = BizCalcExpreUtils.this.getExtFields();
            LinkedHashMap extDimMap = new LinkedHashMap();
            if (!extFields.isEmpty()) {
                Iterator<Object> it = extFields.iterator();
                while (it.hasNext()) {
                    extDimMap.put(it.next(), new HashSet());
                }
                for (String refield2 : dimNumMap.keySet()) {
                    if (!extDimMap.containsKey(refield2)) continue;
                    ((Set)extDimMap.get(refield2)).add(dimNumMap.get(refield2));
                }
                for (String refield2 : scopesMap.keySet()) {
                    tmpScopeSet = scopesMap.get(refield2);
                    if (!extDimMap.containsKey(refield2)) continue;
                    ((Set)extDimMap.get(refield2)).addAll(tmpScopeSet);
                }
                for (String refield2 : curExtNumberMap.keySet()) {
                    tmpScopeSet = curExtNumberMap.get(refield2);
                    if (!extDimMap.containsKey(refield2)) continue;
                    ((Set)extDimMap.get(refield2)).addAll(tmpScopeSet);
                }
                for (String refield2 : extDimMap.keySet()) {
                    if (!((Set)extDimMap.get(refield2)).isEmpty()) continue;
                    ((Set)extDimMap.get(refield2)).add(BizCalcExpreUtils.this.getDefaultMap().get(refield2));
                }
            }
            ArrayList<Set<String>> refieldList = new ArrayList<Set<String>>();
            refieldList.addAll(extDimMap.values());
            Set<String> mbgDimSets = this.getItemCombination(refieldList);
            for (String acctNum : accts) {
                number = DimUtils.getNumber((String)acctNum);
                if (extDimMap == null || extDimMap.isEmpty() || extDimMap == null || extDimMap.isEmpty()) continue;
                for (String filed : extDimMap.keySet()) {
                    Set tSet = (Set)extDimMap.get(filed);
                    Iterator itr = tSet.iterator();
                    while (itr.hasNext()) {
                        tmpSet.add(acctNum + "," + (String)itr.next());
                    }
                }
            }
            if (!tmpSet.isEmpty()) {
                accts.clear();
                accts.addAll(tmpSet);
            }
            ArrayList<Object[]> calcObjs = new ArrayList<Object[]>();
            List<Object> tmpObjs = null;
            for (String acctNum : accts) {
                for (String periodNum : periods) {
                    for (String currencyNum : currencys) {
                        calcObj = new Object[10];
                        calcObj[0] = acctNum;
                        calcObj[1] = BizCalcExpreUtils.this.getDimNumber(acctNum, false);
                        calcObj[2] = periodNum;
                        calcObj[3] = currencyNum;
                        calcObj[5] = dimNumMap;
                        calcObj[6] = scopesMap;
                        calcObj[7] = formulaExpr.getProps().get("FORMULA");
                        calcObj[8] = formulaExpr.getProps().get("CODERULE");
                        calcObj[9] = true;
                        calcObjs.add(calcObj);
                    }
                }
            }
            final IDimDataQuery iDimDataQuery = this.transWorkPaperToBgForm();
            if (iDimDataQuery == null) {
                return;
            }
            Expression expression = null;
            int xn = calcObjs.size();
            for (int x = 0; x < xn; ++x) {
                final Object[] tmpObj = (Object[])calcObjs.get(x);
                expression = ExpressionUtils.clone((FormulaExpr)formulaExpr);
                if (expression != null && expression instanceof FunctionExpr && ("MBGADJUST".equalsIgnoreCase(((FunctionExpr)expression).funcionName) || "MBGADJUSTDATE".equalsIgnoreCase(((FunctionExpr)expression).funcionName))) {
                    expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                        public Expression handle(Expression expr) {
                            return MbgFormula.this.checkExpression(expr, tmpObj, dimNumMap, curExtNumberMap, iDimDataQuery);
                        }
                    });
                }
                formulaStr = BgNExpressionHelper.checkExpression(null, null, (String)expression.toString(), (IObjectValue)((IObjectValue)iDimDataQuery), (String)BizCalcExpreUtils.this.getCurrOrgUnit().getNumber(), (boolean)true, (boolean)false);
                if (BizCalcExpreUtils.this.getExpObjMap().containsKey(formulaStr)) {
                    tmpObjs = BizCalcExpreUtils.this.getExpObjMap().get(formulaStr);
                } else {
                    tmpObjs = new ArrayList();
                    BizCalcExpreUtils.this.getExpObjMap().put(formulaStr, tmpObjs);
                }
                if (tmpObjs != null) {
                    tmpObjs.add(tmpObj);
                }
                BizCalcExpreUtils.this.processBgFormulaMap(formulaExpr, formulaStr);
                if (query == null) continue;
                Map<String, List<Object>> expressObjs = null;
                String key = formulaExpr.toString();
                if (query.calcObjs.containsKey(key)) {
                    expressObjs = (Map)query.calcObjs.get(key);
                } else {
                    expressObjs = new HashMap();
                    query.calcObjs.put(key, expressObjs);
                }
                if (expressObjs.containsKey(formulaStr)) {
                    tmpObjs = (List)expressObjs.get(formulaStr);
                } else {
                    tmpObjs = new ArrayList();
                    expressObjs.put(formulaStr, tmpObjs);
                }
                if (tmpObjs == null) continue;
                tmpObjs.add(tmpObj);
            }
        }

        private IDimDataQuery transWorkPaperToBgForm() {
            BgFormInfo info = null;
            IDimDataQuery iDimDataQuery = BizCalcExpreUtils.this.getParameter().getDataManager().getDimDataQuery();
            if (iDimDataQuery != null && iDimDataQuery.getClass().getName().indexOf("com.kingdee.eas.ma.bgcsl") >= 0) {
                if (BizCalcExpreUtils.this.getParameter().getDataManager().getOrgUnit() != null && BizCalcExpreUtils.this.getParameter().getDataManager().getBgScheme() != null && iDimDataQuery.getBizCurrency() != null && iDimDataQuery.getBizPeriod() != null && iDimDataQuery.getBizVersion() != null) {
                    info = new BgFormInfo();
                    info.setOrgUnit(BizCalcExpreUtils.this.getParameter().getDataManager().getOrgUnit().castToFullOrgUnitInfo());
                    info.setBgScheme(BizCalcExpreUtils.this.getParameter().getDataManager().getBgScheme());
                    info.setCurrency(iDimDataQuery.getBizCurrency());
                    info.setBgPeriod(iDimDataQuery.getBizPeriod());
                    info.setBgVersion(iDimDataQuery.getBizVersion());
                    return info;
                }
                return null;
            }
            return iDimDataQuery;
        }

        private Set<String> getItemCombination(List<Set<String>> refieldList) {
            if (refieldList == null || refieldList.isEmpty()) {
                return new HashSet<String>();
            }
            while (refieldList.size() > 1) {
                Set<String> dimFirstSet = refieldList.get(0);
                Set<String> dimSecondSet = refieldList.get(1);
                Set<String> newDimSet = this.getItemCombination(dimFirstSet, dimSecondSet);
                refieldList.remove(0);
                refieldList.set(0, newDimSet);
            }
            return refieldList.get(0);
        }

        private Set<String> getItemCombination(Set<String> dimFirstSet, Set<String> dimSecondSet) {
            HashSet<String> result = new HashSet<String>();
            if (dimFirstSet.isEmpty() || dimSecondSet.isEmpty()) {
                return null;
            }
            String dimNum12 = null;
            String dimNum22 = null;
            for (String dimNum12 : dimFirstSet) {
                for (String dimNum22 : dimSecondSet) {
                    result.add(dimNum12 + "," + dimNum22);
                }
            }
            return result;
        }

        protected Expression checkExpression(Expression expression, Object[] calcObj, Map<String, String> dimNumMap, Map<String, Set<String>> scopesMap, IDimDataQuery iDimDataQuery) {
            if (expression instanceof FunctionExpr) {
                expression = this.checkFunctionExpr((FunctionExpr)expression, calcObj, dimNumMap, scopesMap, iDimDataQuery);
            } else if (expression instanceof BinaryOperationExpr) {
                expression = this.checkBinaryOperationExpr((BinaryOperationExpr)expression, calcObj, dimNumMap, scopesMap, iDimDataQuery);
            }
            return expression;
        }

        protected Expression checkFunctionExpr(FunctionExpr funExpr, Object[] calcObj, Map<String, String> dimNumMap, Map<String, Set<String>> scopesMap, IDimDataQuery iDimDataQuery) {
            if ("MBGADJUSTDATE".equalsIgnoreCase(funExpr.funcionName)) {
                this.checkMbgAdjustDate(funExpr.parameters, calcObj, dimNumMap, scopesMap, iDimDataQuery);
            } else if ("MBGADJUST".equalsIgnoreCase(funExpr.funcionName)) {
                this.checkMbgAdjust(funExpr.parameters, calcObj, dimNumMap, scopesMap, iDimDataQuery);
            }
            return funExpr;
        }

        protected BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, Object[] calcObj, Map<String, String> dimNumMap, Map<String, Set<String>> scopesMap, IDimDataQuery iDimDataQuery) {
            boExpr.left = this.checkExpression(boExpr.left, calcObj, dimNumMap, scopesMap, iDimDataQuery);
            boExpr.right = this.checkExpression(boExpr.right, calcObj, dimNumMap, scopesMap, iDimDataQuery);
            return boExpr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkMbgAdjustDate(List parameter, Object[] calcObj, Map<String, String> dimNumMap, Map<String, Set<String>> scopesMap, IDimDataQuery iDimDataQuery) {
            String num;
            if (parameter == null || calcObj == null) {
                return;
            }
            TreeMap<String, String> dimsMap = null;
            if (dimNumMap != null && !dimNumMap.isEmpty()) {
                dimsMap = new TreeMap<String, String>(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        String str1 = o1.substring(1);
                        String str2 = o2.substring(1);
                        return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
                    }
                });
                for (String filed : dimNumMap.keySet()) {
                    dimsMap.put(filed, dimNumMap.get(filed));
                }
                if (scopesMap != null && !scopesMap.isEmpty()) {
                    for (String filed : scopesMap.keySet()) {
                        if (dimNumMap.containsKey(filed)) continue;
                        Set<String> tSet = scopesMap.get(filed);
                        Iterator<String> itr = tSet.iterator();
                        while (itr.hasNext()) {
                            dimsMap.put(filed, itr.next());
                        }
                    }
                }
            }
            StringExpr orgUnitParam = (StringExpr)parameter.get(0);
            if (StringUtils.isEmpty((String)orgUnitParam.value) && BizCalcExpreUtils.this.getCurrOrgUnit() != null) {
                orgUnitParam.value = BizCalcExpreUtils.this.getCurrOrgUnit().getNumber();
            }
            StringExpr schemeParam = (StringExpr)parameter.get(1);
            if (StringUtils.isEmpty((String)schemeParam.value) && iDimDataQuery.getBizBgScheme() != null) {
                schemeParam.value = iDimDataQuery.getBizBgScheme().getNumber();
            }
            StringExpr bgScenarioParam = (StringExpr)parameter.get(2);
            if (StringUtils.isEmpty((String)bgScenarioParam.value)) {
                // empty if block
            }
            String dimNum = (String)calcObj[0];
            StringExpr acctItem = (StringExpr)parameter.get(3);
            if (StringUtils.isEmpty((String)acctItem.value) || BizCalcExpreUtils.ACCT_ITEM_STR.equals(acctItem.value)) {
                String[] dimNumbers = dimNum.split(",");
                HashMap<String, String> srcDimMap = new HashMap<String, String>();
                for (int i = 0; i < dimNumbers.length; ++i) {
                    srcDimMap.put(dimNumbers[i].split(":")[0], dimNumbers[i]);
                }
                String newValue = dimNum;
                if (dimsMap != null && !dimsMap.isEmpty()) {
                    String field2 = null;
                    num = null;
                    for (String field2 : dimsMap.keySet()) {
                        num = (String)dimsMap.get(field2);
                        if (DimUtils.checkBaseDimensionByField((String)field2) || DimensionConstants.DEF_PROCESS_FIELD.equals(field2) || DimensionConstants.DEF_BGINDEX_FIELD.equals(field2) || srcDimMap.containsKey(num.split(":")[0])) continue;
                        newValue = newValue + "," + num;
                    }
                }
                acctItem.value = newValue;
            } else if (!StringUtils.isEmpty((String)acctItem.value) && acctItem.value.indexOf(",@") > 0) {
                String newValue = acctItem.value.substring(0, acctItem.value.indexOf(",@"));
                String[] dimNumbers = dimNum.split(",");
                HashMap<String, String> srcDimMap = new HashMap<String, String>();
                for (int i = 0; i < dimNumbers.length; ++i) {
                    srcDimMap.put(dimNumbers[i].split(":")[0], dimNumbers[i]);
                }
                if (dimsMap != null && !dimsMap.isEmpty()) {
                    String field3 = null;
                    num = null;
                    for (String field3 : dimsMap.keySet()) {
                        num = (String)dimsMap.get(field3);
                        if (DimUtils.checkBaseDimensionByField((String)field3) || DimensionConstants.DEF_PROCESS_FIELD.equals(field3) || DimensionConstants.DEF_BGINDEX_FIELD.equals(field3)) continue;
                        if (srcDimMap.containsKey(num.split(":")[0])) {
                            newValue = newValue + "," + (String)srcDimMap.get(num.split(":")[0]);
                            continue;
                        }
                        newValue = newValue + "," + num;
                    }
                }
                acctItem.value = newValue;
            }
            BgPeriodInfo bgPeriod = null;
            String bgPeriodNum = (String)calcObj[2];
            if (!BizCalcExpreUtils.this.getPeriodMap().containsKey(bgPeriodNum) && BizCalcExpreUtils.this.getConn() != null) {
                IRowSet rst = null;
                try {
                    rst = BgDBUtils.executeQuery((Connection)BizCalcExpreUtils.this.getConn(), (String)"select FNumber, FBeginDate, FEndDate, FPeriodType from T_MBG_BgPeriodDisp where FTYPEID IN (select FMemberId from T_MBG_BgDimSettingsMember where FBgDimSettingsId in (select FID from T_MBG_BgDimSettings where FbgSchemeId = ? and FDimNumber = ?))", (Object[])new Object[]{BizCalcExpreUtils.this.getParameter().getBgSchemeId().toString(), DimensionBaseConstants.DEF_PERIOD_NUMBER});
                    while (rst.next()) {
                        bgPeriod = new BgPeriodInfo();
                        bgPeriod.setNumber(rst.getString("FNumber"));
                        bgPeriod.setBeginDate((Date)rst.getDate("FBeginDate"));
                        bgPeriod.setEndDate((Date)rst.getDate("FEndDate"));
                        bgPeriod.setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt("FPeriodType")));
                        BizCalcExpreUtils.this.getPeriodMap().put(bgPeriod.getNumber(), bgPeriod);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                catch (SQLException ex) {
                    logger.error((Object)"checkAcct query period sql error:", (Throwable)ex);
                }
                finally {
                    SQLUtils.cleanup(rst);
                }
            }
            bgPeriod = BizCalcExpreUtils.this.getPeriodMap().get(bgPeriodNum);
            BizCalcExpreUtils.this.getParameter().getExpressValues().periodMap.putAll(BizCalcExpreUtils.this.getPeriodMap());
            if (bgPeriod == null) {
                return;
            }
            int periodType = bgPeriod.getPeriodType().getValue();
            if ((periodType == 8 || periodType == 16 || periodType == 10 || periodType == 11 || periodType == 12 || periodType == 13 || periodType == 14 || periodType == 15 || periodType == 17) && BizCalcExpreUtils.this.getParameter().getDataManager().getDimDataQuery() != null && BizCalcExpreUtils.this.getParameter().getDataManager().getDimDataQuery().getBizPeriod() != null) {
                bgPeriod = BizCalcExpreUtils.this.getPeriodMap().get(BizCalcExpreUtils.this.getParameter().getDataManager().getDimDataQuery().getBizPeriod().getNumber());
            }
            if (bgPeriod == null) {
                return;
            }
            CalendarHelper helper = new CalendarHelper();
            int sYear = helper.getCurrentlyYear(bgPeriod.getBeginDate());
            int sMonth = helper.getCurrentlyMonth(bgPeriod.getBeginDate());
            int eYear = helper.getCurrentlyYear(bgPeriod.getEndDate());
            int eMonth = helper.getCurrentlyMonth(bgPeriod.getEndDate());
            StringExpr beginDateParam = (StringExpr)parameter.get(4);
            if (StringUtils.isEmpty((String)beginDateParam.value)) {
                beginDateParam.value = bgPeriod.getBeginDate().toString();
            }
            StringExpr endDateParam = (StringExpr)parameter.get(5);
            if (StringUtils.isEmpty((String)endDateParam.value)) {
                endDateParam.value = bgPeriod.getEndDate().toString();
            }
            StringExpr bgVersionParam = (StringExpr)parameter.get(6);
            if (StringUtils.isEmpty((String)bgVersionParam.value)) {
                bgVersionParam.value = iDimDataQuery.getBizVersion().getNumber();
            }
            StringExpr currencyParam = (StringExpr)parameter.get(7);
            if (StringUtils.isEmpty((String)currencyParam.value)) {
                currencyParam.value = (String)calcObj[3];
            }
            StringExpr bgElementParam = (StringExpr)parameter.get(8);
            if (StringUtils.isEmpty((String)bgElementParam.value)) {
                // empty if block
            }
            StringExpr typeParam = (StringExpr)parameter.get(9);
            if (StringUtils.isEmpty((String)typeParam.value)) {
                typeParam.value = "all";
            }
            StringExpr bgProcessParam = (StringExpr)parameter.get(12);
            if (StringUtils.isEmpty((String)bgProcessParam.value)) {
                bgProcessParam.value = iDimDataQuery.getProcessType().getName();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkMbgAdjust(List parameter, Object[] calcObj, Map<String, String> dimNumMap, Map<String, Set<String>> scopesMap, IDimDataQuery iDimDataQuery) {
            String num;
            if (parameter == null || calcObj == null) {
                return;
            }
            TreeMap<String, String> dimsMap = null;
            if (dimNumMap != null && !dimNumMap.isEmpty()) {
                dimsMap = new TreeMap<String, String>(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        String str1 = o1.substring(1);
                        String str2 = o2.substring(1);
                        return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
                    }
                });
                for (String filed : dimNumMap.keySet()) {
                    dimsMap.put(filed, dimNumMap.get(filed));
                }
                if (scopesMap != null && !scopesMap.isEmpty()) {
                    for (String filed : scopesMap.keySet()) {
                        if (dimsMap.containsKey(filed)) continue;
                        Set<String> tSet = scopesMap.get(filed);
                        Iterator<String> itr = tSet.iterator();
                        while (itr.hasNext()) {
                            dimsMap.put(filed, itr.next());
                        }
                    }
                }
            }
            StringExpr orgUnitParam = (StringExpr)parameter.get(0);
            if (StringUtils.isEmpty((String)orgUnitParam.value) && BizCalcExpreUtils.this.getCurrOrgUnit() != null) {
                orgUnitParam.value = BizCalcExpreUtils.this.getCurrOrgUnit().getNumber();
            }
            StringExpr schemeParam = (StringExpr)parameter.get(1);
            if (StringUtils.isEmpty((String)schemeParam.value) && iDimDataQuery.getBizBgScheme() != null) {
                schemeParam.value = iDimDataQuery.getBizBgScheme().getNumber();
            }
            StringExpr bgScenarioParam = (StringExpr)parameter.get(2);
            if (StringUtils.isEmpty((String)bgScenarioParam.value)) {
                // empty if block
            }
            String dimNum = (String)calcObj[0];
            StringExpr acctItem = (StringExpr)parameter.get(3);
            if (StringUtils.isEmpty((String)acctItem.value) || BizCalcExpreUtils.ACCT_ITEM_STR.equals(acctItem.value)) {
                String[] dimNumbers = dimNum.split(",");
                HashMap<String, String> srcDimMap = new HashMap<String, String>();
                for (int i = 0; i < dimNumbers.length; ++i) {
                    srcDimMap.put(dimNumbers[i].split(":")[0], dimNumbers[i]);
                }
                String newValue = dimNum;
                if (dimsMap != null && !dimsMap.isEmpty()) {
                    String field2 = null;
                    num = null;
                    for (String field2 : dimsMap.keySet()) {
                        num = (String)dimsMap.get(field2);
                        if (DimUtils.checkBaseDimensionByField((String)field2) || DimensionConstants.DEF_PROCESS_FIELD.equals(field2) || DimensionConstants.DEF_BGINDEX_FIELD.equals(field2) || srcDimMap.containsKey(num.split(":")[0])) continue;
                        newValue = newValue + "," + num;
                    }
                }
                acctItem.value = newValue;
            } else if (!StringUtils.isEmpty((String)acctItem.value) && acctItem.value.indexOf(",@") > 0) {
                String newValue = acctItem.value.substring(0, acctItem.value.indexOf(",@"));
                String[] dimNumbers = dimNum.split(",");
                HashMap<String, String> srcDimMap = new HashMap<String, String>();
                for (int i = 0; i < dimNumbers.length; ++i) {
                    srcDimMap.put(dimNumbers[i].split(":")[0], dimNumbers[i]);
                }
                if (dimsMap != null && !dimsMap.isEmpty()) {
                    String field3 = null;
                    num = null;
                    for (String field3 : dimsMap.keySet()) {
                        num = (String)dimsMap.get(field3);
                        if (DimUtils.checkBaseDimensionByField((String)field3) || DimensionConstants.DEF_PROCESS_FIELD.equals(field3) || DimensionConstants.DEF_BGINDEX_FIELD.equals(field3)) continue;
                        if (srcDimMap.containsKey(num.split(":")[0])) {
                            newValue = newValue + "," + (String)srcDimMap.get(num.split(":")[0]);
                            continue;
                        }
                        newValue = newValue + "," + num;
                    }
                }
                acctItem.value = newValue;
            }
            BgPeriodInfo bgPeriod = null;
            String bgPeriodNum = (String)calcObj[2];
            if (!BizCalcExpreUtils.this.getPeriodMap().containsKey(bgPeriodNum) && BizCalcExpreUtils.this.getConn() != null) {
                IRowSet rst = null;
                try {
                    rst = BgDBUtils.executeQuery((Connection)BizCalcExpreUtils.this.getConn(), (String)"select FNumber, FBeginDate, FEndDate, FPeriodType from T_MBG_BgPeriodDisp where FTYPEID IN (select FMemberId from T_MBG_BgDimSettingsMember where FBgDimSettingsId in (select FID from T_MBG_BgDimSettings where FbgSchemeId = ? and FDimNumber = ?))", (Object[])new Object[]{BizCalcExpreUtils.this.getParameter().getBgSchemeId().toString(), DimensionBaseConstants.DEF_PERIOD_NUMBER});
                    while (rst.next()) {
                        bgPeriod = new BgPeriodInfo();
                        bgPeriod.setNumber(rst.getString("FNumber"));
                        bgPeriod.setBeginDate((Date)rst.getDate("FBeginDate"));
                        bgPeriod.setEndDate((Date)rst.getDate("FEndDate"));
                        bgPeriod.setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt("FPeriodType")));
                        BizCalcExpreUtils.this.getPeriodMap().put(bgPeriod.getNumber(), bgPeriod);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                catch (SQLException ex) {
                    logger.error((Object)"checkAcct query period sql error:", (Throwable)ex);
                }
                finally {
                    SQLUtils.cleanup(rst);
                }
            }
            bgPeriod = BizCalcExpreUtils.this.getPeriodMap().get(bgPeriodNum);
            BizCalcExpreUtils.this.getParameter().getExpressValues().periodMap.putAll(BizCalcExpreUtils.this.getPeriodMap());
            if (bgPeriod == null) {
                return;
            }
            int periodType = bgPeriod.getPeriodType().getValue();
            if ((periodType == 8 || periodType == 16 || periodType == 10 || periodType == 11 || periodType == 12 || periodType == 13 || periodType == 14 || periodType == 15 || periodType == 17) && BizCalcExpreUtils.this.getParameter().getDataManager().getDimDataQuery() != null && BizCalcExpreUtils.this.getParameter().getDataManager().getDimDataQuery().getBizPeriod() != null) {
                bgPeriod = BizCalcExpreUtils.this.getPeriodMap().get(BizCalcExpreUtils.this.getParameter().getDataManager().getDimDataQuery().getBizPeriod().getNumber());
            }
            if (bgPeriod == null) {
                return;
            }
            CalendarHelper helper = new CalendarHelper();
            int sYear = helper.getCurrentlyYear(bgPeriod.getBeginDate());
            int sMonth = helper.getCurrentlyMonth(bgPeriod.getBeginDate());
            int eYear = helper.getCurrentlyYear(bgPeriod.getEndDate());
            int eMonth = helper.getCurrentlyMonth(bgPeriod.getEndDate());
            StringExpr beginPeriodParam = (StringExpr)parameter.get(4);
            if (StringUtils.isEmpty((String)beginPeriodParam.value)) {
                beginPeriodParam.value = bgPeriod.getNumber();
            }
            StringExpr endPeriodParam = (StringExpr)parameter.get(5);
            if (StringUtils.isEmpty((String)endPeriodParam.value)) {
                endPeriodParam.value = bgPeriod.getNumber();
            }
            StringExpr bgVersionParam = (StringExpr)parameter.get(6);
            if (StringUtils.isEmpty((String)bgVersionParam.value)) {
                bgVersionParam.value = iDimDataQuery.getBizVersion().getNumber();
            }
            StringExpr currencyParam = (StringExpr)parameter.get(7);
            if (StringUtils.isEmpty((String)currencyParam.value)) {
                currencyParam.value = (String)calcObj[3];
            }
            StringExpr bgElementParam = (StringExpr)parameter.get(8);
            if (StringUtils.isEmpty((String)bgElementParam.value)) {
                // empty if block
            }
            StringExpr typeParam = (StringExpr)parameter.get(9);
            if (StringUtils.isEmpty((String)typeParam.value)) {
                typeParam.value = "all";
            }
            StringExpr dateParam = (StringExpr)parameter.get(10);
            if (StringUtils.isEmpty((String)dateParam.value)) {
                // empty if block
            }
            StringExpr bgProcessParam = (StringExpr)parameter.get(11);
            if (StringUtils.isEmpty((String)bgProcessParam.value)) {
                bgProcessParam.value = iDimDataQuery.getProcessType().getName();
            }
        }
    }

    class AcctItem {
        AcctItem() {
        }

        public void builder(FormulaExpr formulaExpr, Set<String> acctNums, Set<String> periodNums, Set<String> currencyNums, Map<String, String> dimNumMap, Map<String, Set<String>> scopesMap, BgExamineFacadeControllerBean.ExprDimQuery query) throws Exception {
            if (!BizExprUtils.hasAcctItemExp(formulaExpr)) {
                return;
            }
            HashSet<String> calcNums = new HashSet<String>();
            HashSet<String> calcPNums = new HashSet<String>();
            HashSet<String> calcCNums = new HashSet<String>();
            HashSet<String> tmpSet = new HashSet<String>();
            ArrayList<String> accts = new ArrayList<String>();
            ArrayList<String> periods = new ArrayList<String>();
            ArrayList<String> currencys = new ArrayList<String>();
            if (dimNumMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD)) {
                calcNums.add(dimNumMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD));
            }
            if (scopesMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD)) {
                calcNums.addAll((Collection)scopesMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD));
            }
            if (calcNums.isEmpty()) {
                calcNums.addAll(acctNums);
            }
            accts.addAll(calcNums);
            Collections.sort(accts);
            if (dimNumMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) {
                calcPNums.add(dimNumMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
            }
            if (scopesMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) {
                calcPNums.addAll((Collection)scopesMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
            }
            if (calcPNums.isEmpty()) {
                calcPNums.addAll(periodNums);
            }
            periods.addAll(calcPNums);
            Collections.sort(periods);
            if (dimNumMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD)) {
                calcCNums.add(dimNumMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
            }
            if (scopesMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD)) {
                calcCNums.addAll((Collection)scopesMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
            }
            if (calcCNums.isEmpty()) {
                calcCNums.addAll(currencyNums);
            }
            if (BizCalcExpreUtils.this.isFlag() && currencyNums != null && !currencyNums.isEmpty()) {
                calcCNums.clear();
                calcCNums.addAll(currencyNums);
            }
            currencys.addAll(calcCNums);
            Collections.sort(currencys);
            Object[] calcObj = null;
            String formulaStr = null;
            String refield2 = null;
            String number = null;
            Set<String> tmpScopeSet = null;
            List extFields = BizCalcExpreUtils.this.getExtFields();
            LinkedHashMap extDimMap = new LinkedHashMap();
            if (!extFields.isEmpty()) {
                Iterator<Object> it = extFields.iterator();
                while (it.hasNext()) {
                    extDimMap.put(it.next(), new HashSet());
                }
                for (String refield2 : dimNumMap.keySet()) {
                    if (!extDimMap.containsKey(refield2)) continue;
                    ((Set)extDimMap.get(refield2)).add(dimNumMap.get(refield2));
                }
                for (String refield2 : scopesMap.keySet()) {
                    tmpScopeSet = scopesMap.get(refield2);
                    if (!extDimMap.containsKey(refield2)) continue;
                    ((Set)extDimMap.get(refield2)).addAll(tmpScopeSet);
                }
                for (String refield2 : extDimMap.keySet()) {
                    if (!((Set)extDimMap.get(refield2)).isEmpty()) continue;
                    ((Set)extDimMap.get(refield2)).add(BizCalcExpreUtils.this.getDefaultMap().get(refield2));
                }
            }
            ArrayList<Set<String>> refieldList = new ArrayList<Set<String>>();
            refieldList.addAll(extDimMap.values());
            Set<String> mbgDimSets = this.getItemCombination(refieldList);
            for (String acctNum : accts) {
                number = DimUtils.getNumber((String)acctNum);
                if (!BizCalcExpreUtils.this.getAcctItems().contains(number)) continue;
                for (String mbgDimNum : mbgDimSets) {
                    tmpSet.add(acctNum + "," + mbgDimNum);
                }
            }
            if (!tmpSet.isEmpty()) {
                accts.clear();
                accts.addAll(tmpSet);
            }
            ArrayList<Object[]> calcObjs = new ArrayList<Object[]>();
            List<Object> tmpObjs = null;
            for (String acctNum : accts) {
                for (String periodNum : periods) {
                    for (String currencyNum : currencys) {
                        calcObj = new Object[10];
                        calcObj[0] = acctNum;
                        calcObj[1] = BizCalcExpreUtils.this.getDimNumber(acctNum, false);
                        calcObj[2] = periodNum;
                        calcObj[3] = currencyNum;
                        calcObj[5] = dimNumMap;
                        calcObj[6] = scopesMap;
                        calcObj[7] = formulaExpr.getProps().get("FORMULA");
                        calcObj[8] = formulaExpr.getProps().get("CODERULE");
                        calcObj[9] = formulaExpr.getProps().get("IS_ZERO_UPDATE");
                        calcObjs.add(calcObj);
                    }
                }
            }
            Expression expression = null;
            int xn = calcObjs.size();
            for (int x = 0; x < xn; ++x) {
                final Object[] tmpObj = (Object[])calcObjs.get(x);
                expression = ExpressionUtils.clone((FormulaExpr)formulaExpr);
                expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                    public Expression handle(Expression expr) {
                        return AcctItem.this.checkExpression(expr, tmpObj);
                    }
                });
                formulaStr = '=' + expression.toString();
                if (BizCalcExpreUtils.this.getExpObjMap().containsKey(formulaStr)) {
                    tmpObjs = BizCalcExpreUtils.this.getExpObjMap().get(formulaStr);
                } else {
                    tmpObjs = new ArrayList();
                    BizCalcExpreUtils.this.getExpObjMap().put(formulaStr, tmpObjs);
                }
                if (tmpObjs != null) {
                    tmpObjs.add(tmpObj);
                }
                BizCalcExpreUtils.this.processBgFormulaMap(formulaExpr, formulaStr);
                if (query == null) continue;
                Map<String, List<Object>> expressObjs = null;
                String key = formulaExpr.toString();
                if (query.calcObjs.containsKey(key)) {
                    expressObjs = (Map)query.calcObjs.get(key);
                } else {
                    expressObjs = new HashMap();
                    query.calcObjs.put(key, expressObjs);
                }
                if (expressObjs.containsKey(formulaStr)) {
                    tmpObjs = (List)expressObjs.get(formulaStr);
                } else {
                    tmpObjs = new ArrayList();
                    expressObjs.put(formulaStr, tmpObjs);
                }
                if (tmpObjs == null) continue;
                tmpObjs.add(tmpObj);
            }
        }

        private Set<String> getItemCombination(List<Set<String>> refieldList) {
            if (refieldList == null || refieldList.isEmpty()) {
                return new HashSet<String>();
            }
            while (refieldList.size() > 1) {
                Set<String> dimFirstSet = refieldList.get(0);
                Set<String> dimSecondSet = refieldList.get(1);
                Set<String> newDimSet = this.getItemCombination(dimFirstSet, dimSecondSet);
                refieldList.remove(0);
                refieldList.set(0, newDimSet);
            }
            return refieldList.get(0);
        }

        private Set<String> getItemCombination(Set<String> dimFirstSet, Set<String> dimSecondSet) {
            HashSet<String> result = new HashSet<String>();
            if (dimFirstSet.isEmpty() || dimSecondSet.isEmpty()) {
                return null;
            }
            String dimNum12 = null;
            String dimNum22 = null;
            for (String dimNum12 : dimFirstSet) {
                for (String dimNum22 : dimSecondSet) {
                    result.add(dimNum12 + "," + dimNum22);
                }
            }
            return result;
        }

        protected Expression checkExpression(Expression expression, Object[] calcObj) {
            if (expression instanceof FunctionExpr) {
                expression = this.checkFunctionExpr((FunctionExpr)expression, calcObj);
            } else if (expression instanceof BinaryOperationExpr) {
                expression = this.checkBinaryOperationExpr((BinaryOperationExpr)expression, calcObj);
            }
            return expression;
        }

        protected Expression checkFunctionExpr(FunctionExpr funExpr, Object[] calcObj) {
            BizCalcExpreUtils.this.checkInfoState((Expression)funExpr);
            if ("ACCTITEM".equalsIgnoreCase(funExpr.funcionName)) {
                this.checkAcctItem(funExpr.parameters, calcObj);
            }
            return funExpr;
        }

        protected BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, Object[] calcObj) {
            boExpr.left = this.checkExpression(boExpr.left, calcObj);
            boExpr.right = this.checkExpression(boExpr.right, calcObj);
            return boExpr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkAcctItem(List parameter, Object[] calcObj) {
            if (parameter == null || calcObj == null) {
                return;
            }
            StringExpr CSParam = (StringExpr)parameter.get(0);
            if (CSParam == null || StringUtils.isEmpty((String)CSParam.value)) {
                return;
            }
            StringExpr compantParam = (StringExpr)parameter.get(1);
            if (compantParam == null || StringUtils.isEmpty((String)compantParam.value)) {
                if ((Integer)BizCalcExpreUtils.this.getParameter().getExpressValues().orgTree.get(CSParam.value) == 1 && compantParam != null) {
                    compantParam.value = BizCalcExpreUtils.this.getCurrCompany().getNumber();
                } else if ((Integer)BizCalcExpreUtils.this.getParameter().getExpressValues().orgTree.get(CSParam.value) == 6 && compantParam != null) {
                    compantParam.value = BizCalcExpreUtils.this.getCurrProfitCenter().getNumber();
                }
            }
            BgPeriodInfo bgPeriod = null;
            String bgPeriodNum = (String)calcObj[2];
            if (!BizCalcExpreUtils.this.getPeriodMap().containsKey(bgPeriodNum) && BizCalcExpreUtils.this.getConn() != null) {
                IRowSet rst = null;
                try {
                    rst = BgDBUtils.executeQuery((Connection)BizCalcExpreUtils.this.getConn(), (String)"select FNumber, FBeginDate, FEndDate , FPeriodType from T_MBG_BgPeriodDisp");
                    while (rst.next()) {
                        bgPeriod = new BgPeriodInfo();
                        bgPeriod.setNumber(rst.getString("FNumber"));
                        bgPeriod.setBeginDate((Date)rst.getDate("FBeginDate"));
                        bgPeriod.setEndDate((Date)rst.getDate("FEndDate"));
                        bgPeriod.setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt("FPeriodType")));
                        BizCalcExpreUtils.this.getPeriodMap().put(bgPeriod.getNumber(), bgPeriod);
                    }
                }
                catch (SQLException ex) {
                    try {
                        logger.error((Object)"checkAcct query period sql error:", (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst);
                        throw throwable;
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            bgPeriod = BizCalcExpreUtils.this.getPeriodMap().get(bgPeriodNum);
            BizCalcExpreUtils.this.getParameter().getExpressValues().periodMap.putAll(BizCalcExpreUtils.this.getPeriodMap());
            if (bgPeriod == null) {
                return;
            }
            CalendarHelper helper = new CalendarHelper();
            int iYear = helper.getCurrentlyYear(bgPeriod.getBeginDate());
            int sMonth = helper.getCurrentlyMonth(bgPeriod.getBeginDate());
            int eMonth = helper.getCurrentlyMonth(bgPeriod.getEndDate());
            if (parameter.get(7) instanceof IntExpr) {
                IntExpr year = (IntExpr)parameter.get(7);
                if (year.value == null || year.value.intValue() == 0) {
                    year.value = BigInteger.valueOf(iYear);
                } else if (year.value != null && year.value.intValue() < 0) {
                    year.value = BigInteger.valueOf(iYear + year.value.intValue());
                }
            }
            if (parameter.get(8) instanceof IntExpr) {
                IntExpr beginMonth = (IntExpr)parameter.get(8);
                if (beginMonth.value == null || beginMonth.value.intValue() == 0) {
                    beginMonth.value = BigInteger.valueOf(sMonth);
                } else if (beginMonth.value != null && beginMonth.value.intValue() < 0) {
                    beginMonth.value = BigInteger.valueOf(sMonth + beginMonth.value.intValue());
                }
            }
            if (parameter.get(9) instanceof IntExpr) {
                IntExpr endMonth = (IntExpr)parameter.get(9);
                if (endMonth.value == null || endMonth.value.intValue() == 0) {
                    endMonth.value = BigInteger.valueOf(eMonth);
                } else if (endMonth.value != null && endMonth.value.intValue() < 0) {
                    endMonth.value = BigInteger.valueOf(eMonth + endMonth.value.intValue());
                }
            }
            if (!BizCalcExpreUtils.this.isFlag() || !BizCalcExpreUtils.this.isDimSelectState()) {
                String dimNum = (String)calcObj[0];
                StringExpr acctItemFrom = (StringExpr)parameter.get(4);
                if (StringUtils.isEmpty((String)acctItemFrom.value) || BizCalcExpreUtils.ACCT_ITEM_STR.equals(acctItemFrom.value)) {
                    acctItemFrom.value = (dimNum = dimNum.split(",")[0]).split(":").length == 2 ? dimNum.split(":")[1] : dimNum.split(":")[0];
                }
                StringExpr acctItemTo = (StringExpr)parameter.get(5);
                if (StringUtils.isEmpty((String)acctItemTo.value) || BizCalcExpreUtils.ACCT_ITEM_STR.equals(acctItemTo.value)) {
                    acctItemTo.value = (dimNum = dimNum.split(",")[0]).split(":").length == 2 ? dimNum.split(":")[1] : dimNum.split(":")[0];
                }
            }
            StringExpr currencySParam = (StringExpr)parameter.get(2);
            if (StringUtils.isEmpty((String)currencySParam.value)) {
                currencySParam.value = (String)calcObj[3];
            }
            StringExpr currencyEParam = (StringExpr)parameter.get(3);
            if (StringUtils.isEmpty((String)currencyEParam.value)) {
                currencyEParam.value = (String)calcObj[3];
            }
        }
    }

    public class Acct {
        /*
         * WARNING - void declaration
         */
        public void builder(FormulaExpr formulaExpr, Set<String> acctNums, Set<String> periodNums, Set<String> currencyNums, final Map<String, String> dimNumMap, final Map<String, Set<String>> scopesMap, BgExamineFacadeControllerBean.ExprDimQuery query, FunctionExpr funExpr, Map<String, Set<String>> curExtNumberMap) throws Exception {
            if (funExpr != null && formulaExpr == null) {
                formulaExpr = new FormulaExpr();
                formulaExpr.formulaName = funExpr.funcionName;
                formulaExpr.params = funExpr.parameters;
            }
            if (!BizExprUtils.hasAcctExp(formulaExpr)) {
                return;
            }
            HashSet<String> calcNums = new HashSet<String>();
            HashSet<String> calcPNums = new HashSet<String>();
            HashSet<String> calcCNums = new HashSet<String>();
            HashSet<String> tmpAccts = new HashSet<String>();
            HashSet<String> tmpSet = new HashSet<String>();
            HashSet<String> _accts = new HashSet<String>();
            ArrayList<String> accts = new ArrayList<String>();
            ArrayList<String> periods = new ArrayList<String>();
            ArrayList<String> currencys = new ArrayList<String>();
            List<String[]> asstGroups = null;
            ArrayList<String> mbgAccts = new ArrayList<String>();
            HashSet<String> _mbgAccts = new HashSet<String>();
            HashSet mbgTmpAccts = new HashSet();
            HashSet<String> mbgTmpSet = new HashSet<String>();
            if (dimNumMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD)) {
                calcNums.add(dimNumMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD));
            }
            if (scopesMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD)) {
                calcNums.addAll((Collection)scopesMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD));
            }
            if (calcNums.isEmpty()) {
                calcNums.addAll(acctNums);
            }
            accts.addAll(calcNums);
            Collections.sort(accts);
            if (dimNumMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) {
                calcPNums.add(DimUtils.getNumber((String)dimNumMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD)));
            }
            if (scopesMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) {
                calcPNums.addAll((Collection)scopesMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
            }
            Iterator itP = calcPNums.iterator();
            while (itP.hasNext()) {
                String number = (String)itP.next();
                if (number == null || !number.startsWith(BizCalcExpreUtils.ACCT_ITEM_STR)) continue;
                itP.remove();
            }
            if (calcPNums.isEmpty()) {
                calcPNums.addAll(periodNums);
            }
            periods.addAll(calcPNums);
            Collections.sort(periods);
            if (dimNumMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD)) {
                calcCNums.add(DimUtils.getNumber((String)dimNumMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD)));
            }
            if (scopesMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD)) {
                calcCNums.addAll((Collection)scopesMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
            }
            if (calcCNums.isEmpty()) {
                calcCNums.addAll(currencyNums);
            }
            if (BizCalcExpreUtils.this.isFlag() && currencyNums != null && !currencyNums.isEmpty()) {
                calcCNums.clear();
                calcCNums.addAll(currencyNums);
            }
            currencys.addAll(calcCNums);
            Collections.sort(currencys);
            final HashMap<String, Set<String>> tmpScopMap = new HashMap<String, Set<String>>();
            if (curExtNumberMap != null && !curExtNumberMap.isEmpty()) {
                HashSet tmSet = null;
                Set<String> dimExtSrcNumberSet = null;
                boolean isExistExtDimmember = false;
                if (scopesMap instanceof Map) {
                    for (String field : scopesMap.keySet()) {
                        if (!(DimUtils.checkBaseDimensionByField((String)field) || DimensionConstants.DEF_CSL_FIELD.equals(field) || DimensionConstants.DEF_BGINDEX_FIELD.equals(field))) {
                            dimExtSrcNumberSet = scopesMap.get(field);
                            if (dimExtSrcNumberSet != null && !dimExtSrcNumberSet.isEmpty()) {
                                isExistExtDimmember = true;
                            }
                            if (curExtNumberMap.containsKey(field)) {
                                tmSet = new HashSet(curExtNumberMap.get(field));
                                tmSet.retainAll(dimExtSrcNumberSet);
                                if (tmpScopMap.containsKey(field) || tmSet.isEmpty()) continue;
                                tmpScopMap.put(field, tmSet);
                                continue;
                            }
                            tmpScopMap.put(field, scopesMap.get(field));
                            continue;
                        }
                        tmpScopMap.put(field, scopesMap.get(field));
                    }
                }
                if ((tmpScopMap == null || tmpScopMap.isEmpty()) && isExistExtDimmember) {
                    return;
                }
            }
            Map<String, MbgDimInfo> asstDimMap = BizCalcExpreUtils.this.queryAsstActType(BizCalcExpreUtils.this.getParameter().getBgSchemeId());
            String number = null;
            Object[] calcObj = null;
            String formulaStr = null;
            String tmpAcct = null;
            String mgbTmpAcct = null;
            MbgDimInfo mbgDim = null;
            com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
            Boolean isAsstCost = false;
            String costUnitNumber = BizCalcExpreUtils.this.getOrgUnitNumber(BizCalcExpreUtils.this.getParameter().getOrgUnitId(), dimNumMap);
            StringExpr acctItem = (StringExpr)formulaExpr.params.get(1);
            if (BizCalcExpreUtils.ACCT_ITEMS_STR.equals(acctItem.value)) {
                _accts.clear();
                for (String string : accts) {
                    number = DimUtils.getNumber((String)string);
                    tmpAccts.clear();
                    tmpSet.clear();
                    if (!BizCalcExpreUtils.this.getAccGroupMap().containsKey(number)) continue;
                    tmpAccts.add(string);
                    asstGroups = BizCalcExpreUtils.this.getAccGroupMap().get(number);
                    for (String[] asstGroup : asstGroups) {
                        if (asstDimMap.containsKey(asstGroup[0])) {
                            mbgDim = asstDimMap.get(asstGroup[0]);
                            if (dimNumMap.containsKey(mbgDim.getRefField())) {
                                for (Object tmpStr : tmpAccts) {
                                    tmpAcct = (String)tmpStr + "," + asstGroup[1] + "|" + dimNumMap.get(mbgDim.getRefField());
                                    tmpSet.add(tmpAcct);
                                }
                            } else if (scopesMap.containsKey(mbgDim.getRefField())) {
                                Object tmpStr;
                                Iterator tmpScopes = scopesMap.get(mbgDim.getRefField());
                                if (!tmpScopMap.isEmpty() && tmpScopMap.containsKey(mbgDim.getRefField())) {
                                    tmpScopes = (Set)tmpScopMap.get(mbgDim.getRefField());
                                } else if (!tmpScopMap.isEmpty() && !tmpScopMap.containsKey(mbgDim.getRefField())) {
                                    return;
                                }
                                tmpStr = tmpAccts.iterator();
                                while (tmpStr.hasNext()) {
                                    String tmpStr2 = (String)tmpStr.next();
                                    Iterator iterator = tmpScopes.iterator();
                                    while (iterator.hasNext()) {
                                        String tmpScope = (String)iterator.next();
                                        tmpAcct = tmpStr2 + "," + asstGroup[1] + "|" + tmpScope;
                                        tmpSet.add(tmpAcct);
                                    }
                                }
                            } else if (BizCalcExpreUtils.this.getParameter().getDimensionMap().containsKey(mbgDim.getNumber())) {
                                dimension = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)BizCalcExpreUtils.this.getParameter().getDimensionMap().get(mbgDim.getNumber());
                                if (dimension != null) {
                                    for (Object tmpStr : tmpAccts) {
                                        int xn = dimension.getDimensionMember().size();
                                        for (int x = 0; x < xn; ++x) {
                                            tmpAcct = (String)tmpStr + "," + asstGroup[1] + "|" + ((com.kingdee.eas.ma.mbg.dimension.face.IMember)dimension.getDimensionMember().get(x)).getDimNumber();
                                            tmpSet.add(tmpAcct);
                                        }
                                    }
                                    if (BizCalcExpreUtils.this.costStrs != null && BizCalcExpreUtils.this.costStrs[1].equals(asstGroup[1])) {
                                        isAsstCost = true;
                                    }
                                }
                            } else {
                                tmpSet.addAll(tmpAccts);
                            }
                        } else if (BizCalcExpreUtils.this.costStrs != null && BizCalcExpreUtils.this.costStrs[1].equals(asstGroup[1])) {
                            for (Object tmpStr : tmpAccts) {
                                tmpAcct = (String)tmpStr + "," + asstGroup[1] + "|" + costUnitNumber;
                                tmpSet.add(tmpAcct);
                            }
                        } else {
                            tmpSet.addAll(tmpAccts);
                        }
                        tmpAccts.clear();
                        tmpAccts.addAll(tmpSet);
                        tmpSet.clear();
                    }
                    _accts.addAll(tmpAccts);
                }
                accts.clear();
                accts.addAll(_accts);
            } else if (acctItem.value.indexOf("|@") > -1) {
                _accts.clear();
                _mbgAccts.clear();
                String[] numbers = acctItem.value.split("\\|");
                number = numbers[0];
                if (BizCalcExpreUtils.ACCT_ITEM_STR.equals(number)) {
                    for (String acctNum : accts) {
                        number = DimUtils.getNumber((String)acctNum);
                        this.processAcctItem(number, accts, _accts, _mbgAccts, acctItem, asstDimMap, dimNumMap, scopesMap, tmpScopMap, isAsstCost);
                    }
                } else {
                    String string = number;
                    if (number.indexOf(":") > 0) {
                        number = number.split(":")[0];
                    }
                    if (BizCalcExpreUtils.this.getAccGroupMap().containsKey(number)) {
                        String[] acct = ((String)accts.get(0)).split(":");
                        String mark = acct[0];
                        tmpAccts.add(mark + ":" + string);
                        mbgTmpAccts.add(accts.get(0));
                        Map<String, String> accItemAsstMap = this.getAccItemAsstGroup(acctItem.value);
                        asstGroups = BizCalcExpreUtils.this.getAccGroupMap().get(number);
                        for (String[] asstGroup : asstGroups) {
                            if (asstDimMap.containsKey(asstGroup[0])) {
                                mbgDim = asstDimMap.get(asstGroup[0]);
                                if (dimNumMap.containsKey(mbgDim.getRefField())) {
                                    if (accItemAsstMap.containsKey(asstGroup[1])) {
                                        for (Object tmpStr : tmpAccts) {
                                            tmpAcct = tmpStr + "," + asstGroup[1] + "|" + (String)accItemAsstMap.get(asstGroup[1]);
                                            tmpSet.add(tmpAcct);
                                        }
                                        for (Object tmpStr : mbgTmpAccts) {
                                            mgbTmpAcct = tmpStr + "," + asstGroup[1] + "|" + (String)accItemAsstMap.get(asstGroup[1]);
                                            mbgTmpSet.add(mgbTmpAcct);
                                        }
                                    } else {
                                        for (Object tmpStr : tmpAccts) {
                                            tmpAcct = tmpStr + "," + asstGroup[1] + "|" + dimNumMap.get(mbgDim.getRefField());
                                            tmpSet.add(tmpAcct);
                                        }
                                        for (Object tmpStr : mbgTmpAccts) {
                                            mgbTmpAcct = tmpStr + "," + asstGroup[1] + "|" + dimNumMap.get(mbgDim.getRefField());
                                            mbgTmpSet.add(mgbTmpAcct);
                                        }
                                    }
                                } else if (scopesMap.containsKey(mbgDim.getRefField())) {
                                    String tmpScope;
                                    Iterator iterator;
                                    Object tmpStr;
                                    Iterator tmpScopes = scopesMap.get(mbgDim.getRefField());
                                    if (!tmpScopMap.isEmpty() && tmpScopMap.containsKey(mbgDim.getRefField())) {
                                        tmpScopes = (Set)tmpScopMap.get(mbgDim.getRefField());
                                    } else if (!tmpScopMap.isEmpty() && !tmpScopMap.containsKey(mbgDim.getRefField())) {
                                        return;
                                    }
                                    for (String string2 : tmpAccts) {
                                        iterator = tmpScopes.iterator();
                                        while (iterator.hasNext()) {
                                            tmpScope = (String)iterator.next();
                                            tmpAcct = string2 + "," + asstGroup[1] + "|" + tmpScope;
                                            tmpSet.add(tmpAcct);
                                        }
                                    }
                                    tmpStr = mbgTmpAccts.iterator();
                                    while (tmpStr.hasNext()) {
                                        String string3 = (String)tmpStr.next();
                                        iterator = tmpScopes.iterator();
                                        while (iterator.hasNext()) {
                                            tmpScope = (String)iterator.next();
                                            mgbTmpAcct = string3 + "," + asstGroup[1] + "|" + tmpScope;
                                            mbgTmpSet.add(mgbTmpAcct);
                                        }
                                    }
                                } else if (BizCalcExpreUtils.this.getParameter().getDimensionMap().containsKey(mbgDim.getNumber())) {
                                    dimension = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)BizCalcExpreUtils.this.getParameter().getDimensionMap().get(mbgDim.getNumber());
                                    if (dimension != null) {
                                        for (Object tmpStr : tmpAccts) {
                                            int xn = dimension.getDimensionMember().size();
                                            for (int i = 0; i < xn; ++i) {
                                                tmpAcct = (String)tmpStr + "," + asstGroup[1] + "|" + ((com.kingdee.eas.ma.mbg.dimension.face.IMember)dimension.getDimensionMember().get(i)).getDimNumber();
                                                tmpSet.add(tmpAcct);
                                            }
                                        }
                                        for (Object tmpStr : mbgTmpAccts) {
                                            int xn = dimension.getDimensionMember().size();
                                            for (int i = 0; i < xn; ++i) {
                                                mgbTmpAcct = (String)tmpStr + "," + asstGroup[1] + "|" + ((com.kingdee.eas.ma.mbg.dimension.face.IMember)dimension.getDimensionMember().get(i)).getDimNumber();
                                                mbgTmpSet.add(mgbTmpAcct);
                                            }
                                        }
                                        if (BizCalcExpreUtils.this.costStrs != null && BizCalcExpreUtils.this.costStrs[1].equals(asstGroup[1])) {
                                            isAsstCost = true;
                                        }
                                    }
                                } else {
                                    tmpSet.addAll(tmpAccts);
                                    mbgTmpSet.addAll(mbgTmpAccts);
                                }
                            } else if (BizCalcExpreUtils.this.costStrs != null) {
                                if (accItemAsstMap.containsKey(asstGroup[1])) {
                                    for (Object tmpStr : tmpAccts) {
                                        tmpAcct = (String)tmpStr + "," + asstGroup[1] + "|" + (String)accItemAsstMap.get(asstGroup[1]);
                                        tmpSet.add(tmpAcct);
                                    }
                                    for (Object tmpStr : mbgTmpAccts) {
                                        mgbTmpAcct = (String)tmpStr + "," + asstGroup[1] + "|" + (String)accItemAsstMap.get(asstGroup[1]);
                                        mbgTmpSet.add(mgbTmpAcct);
                                    }
                                } else if (BizCalcExpreUtils.this.costStrs[1].equals(asstGroup[1])) {
                                    for (Object tmpStr : tmpAccts) {
                                        tmpAcct = (String)tmpStr + "," + asstGroup[1] + "|" + costUnitNumber;
                                        tmpSet.add(tmpAcct);
                                    }
                                    for (Object tmpStr : mbgTmpAccts) {
                                        mgbTmpAcct = tmpStr + "," + asstGroup[1] + "|" + costUnitNumber;
                                        mbgTmpSet.add(mgbTmpAcct);
                                    }
                                } else {
                                    tmpSet.addAll(tmpAccts);
                                    mbgTmpSet.addAll(mbgTmpAccts);
                                }
                            } else {
                                tmpSet.addAll(tmpAccts);
                                mbgTmpSet.addAll(mbgTmpAccts);
                            }
                            tmpAccts.clear();
                            mbgTmpAccts.clear();
                            tmpAccts.addAll(tmpSet);
                            mbgTmpAccts.addAll(mbgTmpSet);
                            tmpSet.clear();
                            mbgTmpSet.clear();
                        }
                        _accts.addAll(tmpAccts);
                        _mbgAccts.addAll(mbgTmpAccts);
                    }
                }
                accts.clear();
                mbgAccts.clear();
                accts.addAll(_accts);
                mbgAccts.addAll(_mbgAccts);
            }
            ArrayList<Object[]> calcObjs = new ArrayList<Object[]>();
            Object var37_43 = null;
            ArrayList<Object[]> mgbCalcObjs = new ArrayList<Object[]>();
            List<Object[]> mgbTmpObjs = null;
            for (String acctNum : accts) {
                number = DimUtils.getNumber((String)acctNum);
                for (String periodNum : periods) {
                    for (String string : currencys) {
                        calcObj = new Object[10];
                        calcObj[0] = acctNum;
                        calcObj[1] = BizCalcExpreUtils.this.getDimNumber(acctNum, isAsstCost);
                        calcObj[2] = periodNum;
                        calcObj[3] = string;
                        calcObj[5] = dimNumMap;
                        calcObj[6] = tmpScopMap.isEmpty() ? scopesMap : tmpScopMap;
                        calcObj[7] = formulaExpr.getProps().get("FORMULA");
                        calcObj[8] = formulaExpr.getProps().get("CODERULE");
                        calcObj[9] = Boolean.TRUE;
                        calcObjs.add(calcObj);
                    }
                }
            }
            if (mbgAccts.size() > 0) {
                for (String acctNum : mbgAccts) {
                    for (String periodNum : periods) {
                        for (String string : currencys) {
                            calcObj = new Object[10];
                            calcObj[0] = acctNum;
                            calcObj[1] = BizCalcExpreUtils.this.getDimNumber(acctNum, isAsstCost);
                            calcObj[2] = periodNum;
                            calcObj[3] = string;
                            calcObj[5] = dimNumMap;
                            calcObj[6] = tmpScopMap.isEmpty() ? scopesMap : tmpScopMap;
                            calcObj[7] = formulaExpr.getProps().get("FORMULA");
                            calcObj[8] = formulaExpr.getProps().get("CODERULE");
                            calcObj[9] = Boolean.TRUE;
                            mgbCalcObjs.add(calcObj);
                        }
                    }
                }
            }
            Expression expression = null;
            Object[] mbgTmpObj = null;
            int xn = calcObjs.size();
            for (int x = 0; x < xn; ++x) {
                void var37_50;
                void var45_74;
                void var37_47;
                Boolean bl;
                final Object[] tmpObj = (Object[])calcObjs.get(x);
                if (mgbCalcObjs.size() > 0 && !BizCalcExpreUtils.this.isFlag()) {
                    mbgTmpObj = this.getMbgTmpObj(mgbCalcObjs, tmpObj, funExpr);
                }
                expression = ExpressionUtils.clone((FormulaExpr)formulaExpr);
                expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                    public Expression handle(Expression expr) {
                        return Acct.this.checkExpression(expr, tmpObj, dimNumMap, tmpScopMap.isEmpty() ? scopesMap : tmpScopMap);
                    }
                });
                formulaStr = '=' + expression.toString();
                if (funExpr != null && expression instanceof FunctionExpr) {
                    funExpr.parameters = ((FunctionExpr)expression).parameters;
                }
                if (BizCalcExpreUtils.this.getExpObjMap().containsKey(formulaStr)) {
                    List<Object[]> list = BizCalcExpreUtils.this.getExpObjMap().get(formulaStr);
                } else {
                    ArrayList arrayList = new ArrayList();
                    BizCalcExpreUtils.this.getExpObjMap().put(formulaStr, arrayList);
                }
                if (mbgTmpObj != null) {
                    String string = mbgTmpObj[1].toString();
                    String[] mbgNums = string.split(",");
                    String mbgNum = mbgNums[0];
                    if (BizCalcExpreUtils.this.getMbgExpObjMap().containsKey(formulaStr + "$" + mbgNum)) {
                        mgbTmpObjs = BizCalcExpreUtils.this.getMbgExpObjMap().get(formulaStr + "$" + mbgNum);
                    } else {
                        mgbTmpObjs = new ArrayList<Object[]>();
                        BizCalcExpreUtils.this.getMbgExpObjMap().put(formulaStr + "$" + mbgNum, mgbTmpObjs);
                    }
                }
                if (formulaExpr.getProps().containsKey("IncludePosted") && (bl = (Boolean)formulaExpr.getProps().get("IncludePosted")) != null && !bl.booleanValue()) {
                    BizCalcExpreUtils.this.getNoPostExpr().add(formulaStr);
                }
                if (var37_47 != null) {
                    var37_47.add(tmpObj);
                }
                if (mgbTmpObjs != null) {
                    mgbTmpObjs.add(mbgTmpObj);
                }
                BizCalcExpreUtils.this.processBgFormulaMap(formulaExpr, formulaStr);
                if (query == null) continue;
                Object var45_71 = null;
                String key = formulaExpr.toString();
                if (query.calcObjs.containsKey(key)) {
                    Map map = (Map)query.calcObjs.get(key);
                } else {
                    HashMap hashMap = new HashMap();
                    query.calcObjs.put(key, hashMap);
                }
                if (var45_74.containsKey(formulaStr)) {
                    List list = (List)var45_74.get(formulaStr);
                } else {
                    ArrayList arrayList = new ArrayList();
                    var45_74.put(formulaStr, arrayList);
                }
                if (var37_50 == null) continue;
                var37_50.add(tmpObj);
            }
        }

        private void processAcctItem(String number, List<String> accts, Set<String> _accts, Set<String> _mbgAccts, StringExpr acctItem, Map<String, MbgDimInfo> asstDimMap, Map<String, String> dimNumMap, Map<String, Set<String>> scopesMap, Map<String, Set<String>> tmpScopMap, Boolean isAsstCost) throws Exception {
            String tmpAcct = null;
            String mgbTmpAcct = null;
            MbgDimInfo mbgDim = null;
            com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
            HashSet<String> tmpAccts = new HashSet<String>();
            HashSet<String> mbgTmpAccts = new HashSet<String>();
            HashSet<String> tmpSet = new HashSet<String>();
            HashSet<String> mbgTmpSet = new HashSet<String>();
            String costUnitNumber = BizCalcExpreUtils.this.getOrgUnitNumber(BizCalcExpreUtils.this.getParameter().getOrgUnitId(), dimNumMap);
            if (BizCalcExpreUtils.this.getAccGroupMap().containsKey(number)) {
                String[] acct = accts.get(0).split(":");
                String mark = acct[0];
                tmpAccts.add(mark + ":" + number);
                mbgTmpAccts.add(mark + ":" + number);
                Map<String, String> accItemAsstMap = this.getAccItemAsstGroup(acctItem.value);
                List<String[]> asstGroups = BizCalcExpreUtils.this.getAccGroupMap().get(number);
                for (String[] asstGroup : asstGroups) {
                    if (asstDimMap.containsKey(asstGroup[0])) {
                        mbgDim = asstDimMap.get(asstGroup[0]);
                        if (dimNumMap.containsKey(mbgDim.getRefField())) {
                            if (accItemAsstMap.containsKey(asstGroup[1])) {
                                for (String string : tmpAccts) {
                                    tmpAcct = string + "," + asstGroup[1] + "|" + accItemAsstMap.get(asstGroup[1]);
                                    tmpSet.add(tmpAcct);
                                }
                                for (String string : mbgTmpAccts) {
                                    mgbTmpAcct = string + "," + asstGroup[1] + "|" + accItemAsstMap.get(asstGroup[1]);
                                    mbgTmpSet.add(mgbTmpAcct);
                                }
                            } else {
                                for (String string : tmpAccts) {
                                    tmpAcct = string + "," + asstGroup[1] + "|" + dimNumMap.get(mbgDim.getRefField());
                                    tmpSet.add(tmpAcct);
                                }
                                for (String string : mbgTmpAccts) {
                                    mgbTmpAcct = string + "," + asstGroup[1] + "|" + dimNumMap.get(mbgDim.getRefField());
                                    mbgTmpSet.add(mgbTmpAcct);
                                }
                            }
                        } else if (scopesMap.containsKey(mbgDim.getRefField())) {
                            Set<String> tmpScopes = scopesMap.get(mbgDim.getRefField());
                            if (!tmpScopMap.isEmpty() && tmpScopMap.containsKey(mbgDim.getRefField())) {
                                tmpScopes = tmpScopMap.get(mbgDim.getRefField());
                            } else if (!tmpScopMap.isEmpty() && !tmpScopMap.containsKey(mbgDim.getRefField())) {
                                return;
                            }
                            for (String tmpStr2 : tmpAccts) {
                                for (String tmpScope : tmpScopes) {
                                    tmpAcct = tmpStr2 + "," + asstGroup[1] + "|" + tmpScope;
                                    tmpSet.add(tmpAcct);
                                }
                            }
                            for (String tmpStr : mbgTmpAccts) {
                                for (String tmpScope : tmpScopes) {
                                    mgbTmpAcct = tmpStr + "," + asstGroup[1] + "|" + tmpScope;
                                    mbgTmpSet.add(mgbTmpAcct);
                                }
                            }
                        } else if (BizCalcExpreUtils.this.getParameter().getDimensionMap().containsKey(mbgDim.getNumber())) {
                            dimension = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)BizCalcExpreUtils.this.getParameter().getDimensionMap().get(mbgDim.getNumber());
                            if (dimension != null) {
                                for (String string : tmpAccts) {
                                    int xn = dimension.getDimensionMember().size();
                                    for (int x = 0; x < xn; ++x) {
                                        tmpAcct = string + "," + asstGroup[1] + "|" + ((com.kingdee.eas.ma.mbg.dimension.face.IMember)dimension.getDimensionMember().get(x)).getDimNumber();
                                        tmpSet.add(tmpAcct);
                                    }
                                }
                                for (String string : mbgTmpAccts) {
                                    int xn = dimension.getDimensionMember().size();
                                    for (int x = 0; x < xn; ++x) {
                                        mgbTmpAcct = string + "," + asstGroup[1] + "|" + ((com.kingdee.eas.ma.mbg.dimension.face.IMember)dimension.getDimensionMember().get(x)).getDimNumber();
                                        mbgTmpSet.add(mgbTmpAcct);
                                    }
                                }
                                if (BizCalcExpreUtils.this.costStrs != null && BizCalcExpreUtils.this.costStrs[1].equals(asstGroup[1])) {
                                    isAsstCost = true;
                                }
                            }
                        } else {
                            tmpSet.addAll(tmpAccts);
                            mbgTmpSet.addAll(mbgTmpAccts);
                        }
                    } else if (BizCalcExpreUtils.this.costStrs != null) {
                        if (accItemAsstMap.containsKey(asstGroup[1])) {
                            for (String string : tmpAccts) {
                                tmpAcct = string + "," + asstGroup[1] + "|" + accItemAsstMap.get(asstGroup[1]);
                                tmpSet.add(tmpAcct);
                            }
                            for (String string : mbgTmpAccts) {
                                mgbTmpAcct = string + "," + asstGroup[1] + "|" + accItemAsstMap.get(asstGroup[1]);
                                mbgTmpSet.add(mgbTmpAcct);
                            }
                        } else if (BizCalcExpreUtils.this.costStrs[1].equals(asstGroup[1])) {
                            for (String string : tmpAccts) {
                                tmpAcct = string + "," + asstGroup[1] + "|" + costUnitNumber;
                                tmpSet.add(tmpAcct);
                            }
                            for (String string : mbgTmpAccts) {
                                mgbTmpAcct = string + "," + asstGroup[1] + "|" + costUnitNumber;
                                mbgTmpSet.add(mgbTmpAcct);
                            }
                        } else {
                            tmpSet.addAll(tmpAccts);
                            mbgTmpSet.addAll(mbgTmpAccts);
                        }
                    } else {
                        tmpSet.addAll(tmpAccts);
                        mbgTmpSet.addAll(mbgTmpAccts);
                    }
                    tmpAccts.clear();
                    mbgTmpAccts.clear();
                    tmpAccts.addAll(tmpSet);
                    mbgTmpAccts.addAll(mbgTmpSet);
                    tmpSet.clear();
                    mbgTmpSet.clear();
                }
                _accts.addAll(tmpAccts);
                _mbgAccts.addAll(mbgTmpAccts);
            }
        }

        private Map<String, String> getAccItemAsstGroup(String acctItem) {
            HashMap<String, String> acctAsstMap = new HashMap<String, String>();
            if (StringUtils.isEmpty((String)acctItem)) {
                return acctAsstMap;
            }
            String[] numbers = acctItem.split("\\|");
            if (numbers.length > 2) {
                for (int i = 1; i < numbers.length; ++i) {
                    if (!BizCalcExpreUtils.ACCT_ITEM_STR.equals(numbers[i + 1])) {
                        acctAsstMap.put(numbers[i], numbers[i + 1]);
                    }
                    ++i;
                }
            }
            return acctAsstMap;
        }

        private Object[] getMbgTmpObj(List<Object[]> mgbCalcObjs, Object[] tmpObj, FunctionExpr funExpr) {
            String dimNum = tmpObj[1].toString();
            String[] nums = dimNum.split(",");
            String num = null;
            boolean isOK = false;
            if (nums.length >= 2) {
                num = nums[nums.length - 1];
            } else if (nums.length == 1) {
                num = nums[0];
                isOK = true;
            }
            int yn = mgbCalcObjs.size();
            for (int y = 0; y < yn; ++y) {
                Object[] mgbTmpObj = mgbCalcObjs.get(y);
                String mbgDimNum = mgbTmpObj[1].toString();
                String[] mbgNums = mbgDimNum.split(",");
                String mbgNum = null;
                if (mbgNums.length >= 2) {
                    mbgNum = mbgNums[mbgNums.length - 1];
                } else if (mbgNums.length == 1) {
                    mbgNum = mbgNums[0];
                }
                if (num == null && mbgNum == null) {
                    return mgbTmpObj;
                }
                if ((num.equals(mbgNum) || isOK) && funExpr == null && tmpObj[7].equals(mgbTmpObj[7]) && tmpObj[8].equals(mgbTmpObj[8]) && tmpObj[3].equals(mgbTmpObj[3]) && tmpObj[2].equals(mgbTmpObj[2])) {
                    return mgbTmpObj;
                }
                if (!num.equals(mbgNum) && !isOK || funExpr == null || !tmpObj[3].equals(mgbTmpObj[3]) || !tmpObj[2].equals(mgbTmpObj[2])) continue;
                return mgbTmpObj;
            }
            return tmpObj;
        }

        protected Expression checkExpression(Expression expression, Object[] calcObj, Map<String, String> dimNumMap, Map<String, Set<String>> scopesMap) {
            if (expression instanceof FunctionExpr) {
                expression = this.checkFunctionExpr((FunctionExpr)expression, calcObj, dimNumMap, scopesMap);
            } else if (expression instanceof BinaryOperationExpr) {
                expression = this.checkBinaryOperationExpr((BinaryOperationExpr)expression, calcObj, dimNumMap, scopesMap);
            }
            return expression;
        }

        protected Expression checkFunctionExpr(FunctionExpr funExpr, Object[] calcObj, Map<String, String> dimNumMap, Map<String, Set<String>> scopesMap) {
            BizCalcExpreUtils.this.checkInfoState((Expression)funExpr);
            if ("ACCT".equalsIgnoreCase(funExpr.funcionName)) {
                this.checkAcct(funExpr.parameters, calcObj, dimNumMap, scopesMap);
            }
            return funExpr;
        }

        protected BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, Object[] calcObj, Map<String, String> dimNumMap, Map<String, Set<String>> scopesMap) {
            boExpr.left = this.checkExpression(boExpr.left, calcObj, dimNumMap, scopesMap);
            boExpr.right = this.checkExpression(boExpr.right, calcObj, dimNumMap, scopesMap);
            return boExpr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkAcct(List parameter, Object[] calcObj, Map<String, String> dimNumMap, Map<String, Set<String>> scopesMap) {
            if (parameter == null || calcObj == null) {
                return;
            }
            StringExpr orgUnitParam = (StringExpr)parameter.get(0);
            StringExpr orgUnitType = (StringExpr)parameter.get(8);
            if (StringUtils.isEmpty((String)orgUnitParam.value)) {
                orgUnitParam.value = BizCalcExpreUtils.this.getCurrCompany() != null && BizCalcExpreUtils.ACCT_ORG_COMPANY.equalsIgnoreCase(orgUnitType.value) ? BizCalcExpreUtils.this.getCurrCompany().getNumber() : BizCalcExpreUtils.this.getCurrOrgUnit().getNumber();
            }
            if (!BizCalcExpreUtils.this.isFlag() || !BizCalcExpreUtils.this.isDimSelectState() || BizCalcExpreUtils.this.isSupportDimState()) {
                String[] sepStrs;
                String[] tmpStrs;
                String dimNum = (String)calcObj[0];
                StringExpr acctItem = (StringExpr)parameter.get(1);
                if (StringUtils.isEmpty((String)acctItem.value) || BizCalcExpreUtils.ACCT_ITEM_STR.equals(acctItem.value)) {
                    acctItem.value = dimNum = dimNum.split(":")[1];
                } else if (BizCalcExpreUtils.ACCT_ITEMS_STR.equals(acctItem.value)) {
                    tmpStrs = dimNum.split(",");
                    dimNum = "";
                    for (String tmpStr : tmpStrs) {
                        if (tmpStr.indexOf("|") > 0) {
                            sepStrs = tmpStr.split("\\|");
                            if (sepStrs == null) continue;
                            dimNum = dimNum + "|" + sepStrs[0] + "|" + DimUtils.getNumber((String)sepStrs[1]);
                            continue;
                        }
                        dimNum = dimNum + "|" + DimUtils.getNumber((String)tmpStr);
                    }
                    acctItem.value = dimNum.substring(1);
                } else if (acctItem.value.indexOf("|@") > -1) {
                    tmpStrs = dimNum.split(",");
                    dimNum = "";
                    for (String tmpStr : tmpStrs) {
                        if (tmpStr.indexOf("|") > 0) {
                            sepStrs = tmpStr.split("\\|");
                            if (sepStrs == null) continue;
                            dimNum = dimNum + "|" + sepStrs[0] + "|" + DimUtils.getNumber((String)sepStrs[1]);
                            continue;
                        }
                        dimNum = dimNum + "|" + DimUtils.getNumber((String)tmpStr);
                    }
                    acctItem.value = dimNum.substring(1);
                } else if (acctItem.value.indexOf("@|") == 0 && !BizCalcExpreUtils.ACCT_ITEMS_STR.equals(acctItem.value)) {
                    tmpStrs = dimNum.split(",");
                    dimNum = "";
                    for (String tmpStr : tmpStrs) {
                        if (tmpStr.indexOf("|") > 0) {
                            sepStrs = tmpStr.split("\\|");
                            if (sepStrs == null) continue;
                            dimNum = dimNum + "|" + sepStrs[0] + "|" + DimUtils.getNumber((String)sepStrs[1]);
                            continue;
                        }
                        String suffix = acctItem.value;
                        dimNum = dimNum + "|" + DimUtils.getNumber((String)tmpStr) + suffix.substring(1);
                    }
                    acctItem.value = dimNum.substring(1);
                }
            }
            BgPeriodInfo bgPeriod = null;
            String bgPeriodNum = (String)calcObj[2];
            if (!BizCalcExpreUtils.this.getPeriodMap().containsKey(bgPeriodNum) && BizCalcExpreUtils.this.getConn() != null) {
                IRowSet rst = null;
                try {
                    rst = BgDBUtils.executeQuery((Connection)BizCalcExpreUtils.this.getConn(), (String)"select FNumber, FBeginDate, FEndDate, FPeriodType from T_MBG_BgPeriodDisp where FTYPEID IN (select FMemberId from T_MBG_BgDimSettingsMember where FBgDimSettingsId in (select FID from T_MBG_BgDimSettings where FbgSchemeId = ? and FDimNumber = ?))", (Object[])new Object[]{BizCalcExpreUtils.this.getParameter().getBgSchemeId().toString(), DimensionBaseConstants.DEF_PERIOD_NUMBER});
                    while (rst.next()) {
                        bgPeriod = new BgPeriodInfo();
                        bgPeriod.setNumber(rst.getString("FNumber"));
                        bgPeriod.setBeginDate((Date)rst.getDate("FBeginDate"));
                        bgPeriod.setEndDate((Date)rst.getDate("FEndDate"));
                        bgPeriod.setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt("FPeriodType")));
                        BizCalcExpreUtils.this.getPeriodMap().put(bgPeriod.getNumber(), bgPeriod);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                catch (SQLException ex) {
                    logger.error((Object)"checkAcct query period sql error:", (Throwable)ex);
                }
                finally {
                    SQLUtils.cleanup(rst);
                }
            }
            bgPeriod = BizCalcExpreUtils.this.getPeriodMap().get(bgPeriodNum);
            BizCalcExpreUtils.this.getParameter().getExpressValues().periodMap.putAll(BizCalcExpreUtils.this.getPeriodMap());
            if (bgPeriod == null) {
                return;
            }
            int periodType = bgPeriod.getPeriodType().getValue();
            if ((periodType == 8 || periodType == 16 || periodType == 10 || periodType == 11 || periodType == 12 || periodType == 13 || periodType == 14 || periodType == 15 || periodType == 17) && BizCalcExpreUtils.this.getParameter().getDataManager().getDimDataQuery() != null && BizCalcExpreUtils.this.getParameter().getDataManager().getDimDataQuery().getBizPeriod() != null) {
                bgPeriod = BizCalcExpreUtils.this.getPeriodMap().get(BizCalcExpreUtils.this.getParameter().getDataManager().getDimDataQuery().getBizPeriod().getNumber());
            }
            if (bgPeriod == null) {
                return;
            }
            CalendarHelper helper = new CalendarHelper();
            int sYear = helper.getCurrentlyYear(bgPeriod.getBeginDate());
            int sMonth = helper.getCurrentlyMonth(bgPeriod.getBeginDate());
            int eYear = helper.getCurrentlyYear(bgPeriod.getEndDate());
            int eMonth = helper.getCurrentlyMonth(bgPeriod.getEndDate());
            IntExpr beginYear = (IntExpr)parameter.get(3);
            if (beginYear.value == null) {
                beginYear.value = BigInteger.valueOf(0L);
            }
            if (beginYear.value.intValue() <= 0) {
                beginYear.value = BigInteger.valueOf(sYear + beginYear.value.intValue());
            }
            IntExpr beginMonth = (IntExpr)parameter.get(4);
            if (beginMonth.value == null) {
                beginMonth.value = BigInteger.valueOf(0L);
            }
            if (beginMonth.value.intValue() <= 0) {
                beginMonth.value = BigInteger.valueOf(sMonth + beginMonth.value.intValue());
            }
            IntExpr endYear = (IntExpr)parameter.get(5);
            if (endYear.value == null) {
                endYear.value = BigInteger.valueOf(0L);
            }
            if (endYear.value.intValue() <= 0) {
                endYear.value = BigInteger.valueOf(eYear + endYear.value.intValue());
            }
            IntExpr endMonth = (IntExpr)parameter.get(6);
            if (endMonth.value == null) {
                endMonth.value = BigInteger.valueOf(0L);
            }
            if (endMonth.value.intValue() <= 0) {
                endMonth.value = BigInteger.valueOf(eMonth + endMonth.value.intValue());
            }
            StringExpr currencyParam = (StringExpr)parameter.get(7);
            if (StringUtils.isEmpty((String)currencyParam.value)) {
                currencyParam.value = (String)calcObj[3];
            }
        }

        public boolean isAtBehind(List parameter) {
            boolean flag = false;
            StringExpr acctItem = (StringExpr)parameter.get(1);
            if (acctItem.value.indexOf("|@") > -1) {
                flag = true;
            }
            return flag;
        }
    }

    class ContextHandler
    implements IContextHandler {
        private static final long serialVersionUID = -7382902029322799046L;

        ContextHandler() {
        }

        public void handlerContext(Context ctx, ReportInfo report, ReportVariables variables) {
            if (variables == null) {
                return;
            }
            if (!variables.contains("IncludePosted", "sheet1")) {
                variables.add(VariablesHelper.createReservedEntry((String)"IncludePosted", (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"13_BgActualRecordVariableProvider"), (String)"sheet1", (String)"Y", (int)1));
            }
        }
    }
}

