/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr;

import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.NameExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.OperationExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.VariateExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.expr.oper.AbstractOper;
import com.kingdee.eas.ma.biz.expr.oper.OperationType;
import com.kingdee.eas.ma.biz.utils.BizAlgoParam;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.biz.utils.BizMemberScope;
import com.kingdee.eas.ma.mbg.MbgFunctionHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BinaryExpr
extends OperationExpr {
    public IExpress left = null;
    public IExpress right = null;
    public BizCalcMember calcMember = null;
    public String calcNumber = null;
    public int calcSeq = 0;
    public int calcSubSeq = 0;
    public int exprSeq = 0;
    public int subSeq = 0;
    public Map<String, Set<String>> scopes = null;
    public IExpress condition = null;
    public boolean isExists = true;
    public Set<String> refFieldSet = null;
    public IExpress otherExpr = null;
    public boolean isIgnoreOrg = true;
    public boolean hasCalc = true;
    public Set<String> orgNumbers = null;

    public BinaryExpr(AbstractOper operType) {
        super(operType);
    }

    @Override
    public void setLeft() {
        if (this.left != null) {
            this.left.setLeft();
        }
        if (this.right != null) {
            this.right.setLeft();
        }
    }

    @Override
    public void setRemoveProcessType(boolean isRemove) {
        if (this.left != null) {
            this.left.setRemoveProcessType(isRemove);
        }
        if (this.right != null) {
            this.right.setRemoveProcessType(isRemove);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.left instanceof BinaryExpr) {
            BinaryExpr _left = (BinaryExpr)this.left;
            if (OperationType.comparePRI(this.operType.getSID(), _left.operType.getSID()) > 0) {
                str.append("(" + this.left.toString() + ")");
            } else {
                str.append(this.left.toString());
            }
        } else if (this.left != null) {
            str.append(this.left.toString());
        }
        str.append(" " + this.operType.getOper() + " ");
        if (this.operType.getSID() == 20) {
            str.append(this.right.toString());
        } else if (this.right instanceof BinaryExpr) {
            BinaryExpr _right = (BinaryExpr)this.right;
            if (OperationType.comparePRI(this.operType.getSID(), _right.operType.getSID()) >= 0) {
                str.append("(" + this.right.toString() + ")");
            } else {
                str.append(this.right.toString());
            }
        } else {
            str.append(this.right.toString());
        }
        return str.toString();
    }

    @Override
    public String toPlanString() {
        StringBuffer str = new StringBuffer();
        if (this.left instanceof BinaryExpr) {
            BinaryExpr _left = (BinaryExpr)this.left;
            if (OperationType.comparePRI(this.operType.getSID(), _left.operType.getSID()) > 0) {
                str.append("(" + this.left.toPlanString() + ")");
            } else {
                str.append(this.left.toPlanString());
            }
        } else {
            str.append(this.left.toPlanString());
        }
        str.append("" + this.operType.getOper() + "");
        if (this.operType.getSID() == 20) {
            str.append(this.right.toPlanString());
        } else if (this.right instanceof BinaryExpr) {
            BinaryExpr _right = (BinaryExpr)this.right;
            if (OperationType.comparePRI(this.operType.getSID(), _right.operType.getSID()) > 0) {
                str.append("(" + this.right.toPlanString() + ")");
            } else {
                str.append(this.right.toPlanString());
            }
        } else {
            str.append(this.right.toPlanString());
        }
        return str.toString();
    }

    @Override
    public String toMdx() {
        String mdx = null;
        mdx = this.operType.getSID() == 20 ? this.toCalMdx() : this.toMemberMdx();
        return mdx;
    }

    private String toCalMdx() {
        this.checkExpr(this.left);
        this.checkExpr(this.right);
        this.left.setLeft();
        StringBuffer mdx = new StringBuffer();
        StringBuffer scopeMdx = null;
        mdx.append(" CELL CALCULATION ");
        mdx.append(BizExprUtils.getCalcNumber(this.calcNumber, this.calcSeq, this.calcSubSeq, this.exprSeq, this.subSeq));
        mdx.append(" FOR ");
        mdx.append("(");
        if (this.scopes != null && !this.scopes.isEmpty()) {
            Map.Entry<String, Set<String>> entry2 = null;
            Set<String> tmpScope = null;
            String field = null;
            String[] tmpStrs = null;
            for (Map.Entry<String, Set<String>> entry2 : this.scopes.entrySet()) {
                String tmpfun;
                String isDetail;
                String functionName;
                field = entry2.getKey();
                tmpScope = entry2.getValue();
                boolean isMemberFun = false;
                boolean isRemoveFun = false;
                scopeMdx = new StringBuffer();
                if (this.isIgnoreOrg && DimensionBaseConstants.DEF_ORGUNIT_FIELD.equalsIgnoreCase(field) || DimensionBaseConstants.DEF_PROCESS_FIELD.equalsIgnoreCase(field) || field == null || tmpScope == null || tmpScope.isEmpty()) continue;
                scopeMdx.append("{");
                if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equalsIgnoreCase(field)) {
                    tmpScope = new HashSet<String>(this.orgNumbers);
                    tmpScope.retainAll(this.calcMember.getCalc().getBizCalcSubset().get(this.calcSubSeq).getScopeOrg());
                }
                if (DimUtils.checkBaseDimensionByField((String)field)) {
                    for (String scopeNum : tmpScope) {
                        if (scopeNum == null) continue;
                        isMemberFun = scopeNum.indexOf("@") != -1;
                        isRemoveFun = scopeNum.indexOf("Remove") != -1;
                        functionName = null;
                        isDetail = scopeNum;
                        if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equalsIgnoreCase(field)) {
                            isMemberFun = false;
                            isRemoveFun = false;
                        }
                        if (isRemoveFun) {
                            functionName = BizExprUtils.getFunctionNameByScopeMemNum(scopeNum);
                            scopeMdx.append(BizExprUtils.getRemoveFunByScopeMemNum(scopeNum, field, this.calcMember)).append(" ");
                            continue;
                        }
                        if (isMemberFun) {
                            functionName = BizExprUtils.getFunctionNameByScopeMemNum(scopeNum);
                            scopeNum = BizExprUtils.getScopeNumByScopeMemNum(scopeNum);
                            isDetail = BizExprUtils.getIsDetailByScopeMemNum(isDetail);
                        }
                        if (scopeNum != null) {
                            tmpStrs = scopeNum.split(":");
                        }
                        if (tmpStrs == null) continue;
                        if (isMemberFun) {
                            tmpfun = BizExprUtils.getMdxField(field) + BizExprUtils.getMdxNumber(field, tmpStrs[0], scopeNum, this.calcMember.getMdxNumMap(), this.calcMember.getNumInnMap(), this.calcMember.isOrgLongNumber);
                            scopeMdx.append(BizExprUtils.getMdxFunctionStr(functionName, tmpfun, BizExprUtils.getMdxField(field), isDetail)).append(",");
                            continue;
                        }
                        scopeMdx.append("");
                        scopeMdx.append(BizExprUtils.getMdxField(field));
                        scopeMdx.append(BizExprUtils.getMdxNumber(field, tmpStrs[0], scopeNum, this.calcMember.getMdxNumMap(), this.calcMember.getNumInnMap(), this.calcMember.isOrgLongNumber)).append("").append(",");
                    }
                    this.processConditionScope(mdx, field, scopeMdx, false);
                } else {
                    for (String scopeNum : tmpScope) {
                        if (scopeNum == null) continue;
                        isMemberFun = scopeNum.indexOf("@") != -1;
                        isRemoveFun = scopeNum.indexOf("Remove") != -1;
                        functionName = null;
                        isDetail = scopeNum;
                        if (isRemoveFun) {
                            functionName = BizExprUtils.getFunctionNameByScopeMemNum(scopeNum);
                            scopeMdx.append(BizExprUtils.getRemoveFunByScopeMemNum(scopeNum, field, this.calcMember)).append(" ");
                            continue;
                        }
                        if (isMemberFun) {
                            functionName = BizExprUtils.getFunctionNameByScopeMemNum(scopeNum);
                            scopeNum = BizExprUtils.getScopeNumByScopeMemNum(scopeNum);
                            isDetail = BizExprUtils.getIsDetailByScopeMemNum(isDetail);
                        }
                        if (scopeNum != null) {
                            tmpStrs = scopeNum.split(":");
                        }
                        if (tmpStrs == null) continue;
                        if (isMemberFun) {
                            tmpfun = BizExprUtils.getMdxField(field) + BizExprUtils.getMdxNumber(field, tmpStrs[0], scopeNum, this.calcMember.getMdxNumMap(), this.calcMember.getNumInnMap(), this.calcMember.isOrgLongNumber);
                            scopeMdx.append(BizExprUtils.getMdxFunctionStr(functionName, tmpfun, BizExprUtils.getMdxField(field), isDetail)).append(",");
                            continue;
                        }
                        scopeMdx.append("{");
                        scopeMdx.append(BizExprUtils.getMdxField(field));
                        scopeMdx.append(BizExprUtils.getMdxNumber(field, tmpStrs[0], scopeNum, this.calcMember.getMdxNumMap(), this.calcMember.getNumInnMap(), this.calcMember.isOrgLongNumber)).append("}").append(",");
                    }
                    this.processConditionScope(mdx, field, scopeMdx, false);
                }
                mdx.append("} * ");
            }
            this.processConditionScope(mdx, field, scopeMdx, true);
            this.processIsMemberConditon(mdx);
            String leftMdx = this.left.toMdx();
            if (StringUtils.isEmpty((String)leftMdx)) {
                return "";
            }
            mdx.append("{(" + leftMdx + ")}");
        } else {
            this.processConditionScope(mdx, null, scopeMdx, true);
            this.processIsMemberConditon(mdx);
            mdx.append("{");
            mdx.append(this.left.toMdx());
            mdx.append("}");
        }
        mdx.append(")");
        mdx.append(" AS ");
        if (this.condition == null || this.condition.toString().indexOf("ISMEMBER") != -1) {
            mdx.append("'");
            this.checkExpr(this.right);
            this.synExprParam(this.right);
            mdx.append(this.right.toMdx());
            mdx.append("'");
        } else if (this.condition instanceof FunctionExpr) {
            ((FunctionExpr)this.condition).calcMember = this.calcMember;
            ((FunctionExpr)this.condition).isExists = this.isExists;
            mdx.append(this.condition.toMdx());
            this.checkExpr(this.right);
            if (this.right instanceof FunctionExpr) {
                ((FunctionExpr)this.right).calcMember = this.calcMember;
            }
            mdx.append(this.right.toMdx());
            mdx.append(" End");
            mdx.append("'");
        } else if (this.condition instanceof BinaryExpr) {
            ((BinaryExpr)this.condition).calcMember = this.calcMember;
            ((BinaryExpr)this.condition).isExists = this.isExists;
            mdx.append("'");
            mdx.append("Case When ");
            mdx.append(this.condition.toMdx());
            mdx.append(" Then ");
            this.checkExpr(this.right);
            if (this.right instanceof FunctionExpr) {
                ((FunctionExpr)this.right).calcMember = this.calcMember;
            }
            mdx.append(this.right.toMdx());
            mdx.append("+ 0 ");
            if (this.otherExpr != null) {
                mdx.append(" when ");
                ((BinaryExpr)this.condition).calcMember = this.calcMember;
                ((BinaryExpr)this.condition).isExists = !this.isExists;
                mdx.append(this.condition.toMdx());
                mdx.append(" Then ");
                this.checkExpr(this.otherExpr);
                if (this.otherExpr instanceof FunctionExpr) {
                    ((FunctionExpr)this.otherExpr).calcMember = this.calcMember;
                }
                mdx.append(this.otherExpr.toMdx());
                mdx.append("+ 0 ");
            }
            mdx.append(" End");
            mdx.append("'");
        }
        return mdx.toString();
    }

    private String toMemberMdx() {
        if (this.isEmptyMdx(this.left)) {
            return this.toEmptyMdx(this.right);
        }
        if (this.isEmptyMdx(this.right)) {
            return this.toEmptyMdx(this.left);
        }
        StringBuffer mdx = new StringBuffer();
        this.checkExpr(this.left);
        this.synExprParam(this.left);
        if (this.left instanceof BinaryExpr) {
            BinaryExpr _left = (BinaryExpr)this.left;
            if (OperationType.comparePRI(this.operType.getSID(), _left.operType.getSID()) >= 0) {
                mdx.append("(" + this.left.toMdx() + ")");
            } else {
                mdx.append(this.left.toMdx());
            }
        } else if (this.left != null) {
            mdx.append(this.left.toMdx());
        }
        if (this.isExists) {
            if ("==".equals(this.operType.getOper())) {
                mdx.append(" = ");
            } else {
                mdx.append(" " + this.operType.getOper() + " ");
            }
        } else {
            String oper = BizExprUtils.transOperationType(this.operType.getOper());
            mdx.append(" " + oper + " ");
        }
        this.checkExpr(this.right);
        this.synExprParam(this.right);
        if (this.operType.getSID() == 20) {
            mdx.append(this.right.toMdx());
        } else if (this.right instanceof BinaryExpr) {
            BinaryExpr _right = (BinaryExpr)this.right;
            if (OperationType.comparePRI(this.operType.getSID(), _right.operType.getSID()) >= 0) {
                mdx.append("(" + this.right.toMdx() + ")");
            } else {
                mdx.append(this.right.toMdx());
            }
        } else {
            mdx.append(this.right.toMdx());
        }
        return mdx.toString();
    }

    private boolean isEmptyMdx(IExpress expr) {
        return expr instanceof NameExpr && ((NameExpr)expr).name == null;
    }

    private String toEmptyMdx(IExpress expr) {
        StringBuffer mdx = new StringBuffer();
        this.checkExpr(expr);
        this.synExprParam(expr);
        if (this.operType.getSID() == 13) {
            mdx.append("IsEmpty(");
        } else if (this.operType.getSID() == 18) {
            mdx.append("NOT IsEmpty(");
        }
        if (expr instanceof BinaryExpr) {
            BinaryExpr _left = (BinaryExpr)expr;
            if (OperationType.comparePRI(this.operType.getSID(), _left.operType.getSID()) >= 0) {
                mdx.append("(" + expr.toMdx() + ")");
            } else {
                mdx.append(expr.toMdx());
            }
        } else if (expr != null) {
            mdx.append(expr.toMdx());
        }
        mdx.append(")");
        return mdx.toString();
    }

    private String conditionToMdx(StringBuffer mdx) {
        StringBuffer conditionMdx = new StringBuffer();
        String[] tmpStrs = null;
        String funName = MbgFunctionHelper.getOtherFunctionName((String)this.condition.toString());
        conditionMdx.append("'");
        conditionMdx.append("Case When ");
        conditionMdx.append("Count");
        conditionMdx.append("(");
        conditionMdx.append(" Intersect");
        conditionMdx.append("(");
        String dimNumber = BizExprUtils.getDimMemByScopeFunction(this.condition.toString());
        String srcNumber = dimNumber.substring(0, 3);
        String field = this.calcMember.getSrcFieldMap().get(srcNumber);
        if (dimNumber != null) {
            tmpStrs = dimNumber.split(":");
        }
        if (tmpStrs != null) {
            String tmpfun = BizExprUtils.getMdxField(field) + BizExprUtils.getMdxNumber(field, tmpStrs[0], dimNumber, this.calcMember.getMdxNumMap(), this.calcMember.getNumInnMap(), this.calcMember.isOrgLongNumber);
            conditionMdx.append(BizExprUtils.getMdxFunctionStr(funName, tmpfun, BizExprUtils.getMdxField(field), null)).append(",");
            conditionMdx.append("{");
            conditionMdx.append(BizExprUtils.getMdxField(field)).append(".currentmember");
            conditionMdx.append("}");
            conditionMdx.append(")");
        }
        conditionMdx.append(")");
        if (this.isExists) {
            conditionMdx.append("> 0 ");
        } else {
            conditionMdx.append("= 0 ");
        }
        conditionMdx.append("Then ");
        mdx.append(conditionMdx);
        this.checkExpr(this.right);
        if (this.right instanceof FunctionExpr) {
            ((FunctionExpr)this.right).calcMember = this.calcMember;
        }
        mdx.append(this.right.toMdx());
        mdx.append(" End");
        mdx.append("'");
        return conditionMdx.toString();
    }

    private void checkExpr(IExpress expr) {
        if (expr instanceof BinaryExpr) {
            BinaryExpr binaryExpr = (BinaryExpr)expr;
            binaryExpr.calcMember = this.calcMember;
            this.checkExpr(binaryExpr);
        } else if (expr instanceof MdxMemberExpr) {
            MdxMemberExpr memberExpr = (MdxMemberExpr)expr;
            memberExpr.calcMember = this.calcMember;
        } else if (expr instanceof VariateExpr) {
            VariateExpr variateExpr = (VariateExpr)expr;
            if (variateExpr.expr != null) {
                variateExpr.expr.calcMember = this.calcMember;
            }
        } else if (expr instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)expr;
            functionExpr.calcMember = this.calcMember;
        } else if (expr instanceof ConditionExpr) {
            ConditionExpr functionExpr = (ConditionExpr)expr;
            functionExpr.calcMember = this.calcMember;
        }
    }

    private void checkExpr(BinaryExpr expr) {
        FunctionExpr functionExpr;
        VariateExpr variateExpr;
        MdxMemberExpr memberExpr;
        BinaryExpr binaryExpr;
        if (expr.left instanceof BinaryExpr) {
            binaryExpr = (BinaryExpr)expr.left;
            binaryExpr.calcMember = this.calcMember;
        } else if (expr.left instanceof MdxMemberExpr) {
            memberExpr = (MdxMemberExpr)expr.left;
            memberExpr.calcMember = this.calcMember;
        } else if (expr.left instanceof VariateExpr) {
            variateExpr = (VariateExpr)expr.left;
            if (variateExpr.expr != null) {
                variateExpr.expr.calcMember = this.calcMember;
            }
        } else if (expr.left instanceof FunctionExpr) {
            functionExpr = (FunctionExpr)expr.left;
            functionExpr.calcMember = this.calcMember;
        }
        if (expr.right instanceof BinaryExpr) {
            binaryExpr = (BinaryExpr)expr.right;
            binaryExpr.calcMember = this.calcMember;
        } else if (expr.right instanceof MdxMemberExpr) {
            memberExpr = (MdxMemberExpr)expr.right;
            memberExpr.calcMember = this.calcMember;
        } else if (expr.right instanceof VariateExpr) {
            variateExpr = (VariateExpr)expr.right;
            if (variateExpr.expr != null) {
                variateExpr.expr.calcMember = this.calcMember;
            }
        } else if (expr.right instanceof FunctionExpr) {
            functionExpr = (FunctionExpr)expr.right;
            functionExpr.calcMember = this.calcMember;
        }
    }

    private void processConditionScope(StringBuffer mdx, String field, StringBuffer scopeMdx, boolean isAfterScope) {
        String[] tmpStrs = null;
        if (this.condition instanceof FunctionExpr && this.condition.toString().indexOf("ISMEMBER") == -1) {
            StringBuffer conditionScope;
            StringBuffer intersectScopeMdx = null;
            String funName = MbgFunctionHelper.getOtherFunctionName((String)((FunctionExpr)this.condition).functionName);
            String dimNumber = ((FunctionExpr)this.condition).params.get(0).toString().replace("\"", "");
            String srcNumber = dimNumber.substring(0, 3);
            String refField = this.calcMember.getSrcFieldMap().get(srcNumber);
            if (dimNumber != null) {
                tmpStrs = dimNumber.split(":");
            }
            String tmpfun = new String();
            if (tmpStrs != null) {
                tmpfun = BizExprUtils.getMdxField(refField) + BizExprUtils.getMdxNumber(refField, tmpStrs[0], dimNumber, this.calcMember.getMdxNumMap(), this.calcMember.getNumInnMap(), this.calcMember.isOrgLongNumber);
            }
            if ((conditionScope = BizExprUtils.getMdxFunctionStr(funName, tmpfun, BizExprUtils.getMdxField(refField), null)).indexOf("{") != 0 && conditionScope.indexOf("}") != conditionScope.length() - 1) {
                conditionScope = new StringBuffer("{").append(conditionScope).append("}");
            }
            if (isAfterScope && this.refFieldSet != null && !this.refFieldSet.isEmpty()) {
                for (String reField : this.refFieldSet) {
                    scopeMdx = new StringBuffer();
                    if (reField.equals(refField) && this.isExists) {
                        scopeMdx.append("{");
                        scopeMdx.append(conditionScope);
                        scopeMdx.append("}*");
                        mdx.append(scopeMdx);
                        continue;
                    }
                    if (!reField.equals(refField) || this.isExists) continue;
                    scopeMdx.append("{");
                    scopeMdx.append(BizExprUtils.getMdxField(refField) + ".Members");
                    scopeMdx.append("-");
                    scopeMdx.append(conditionScope);
                    scopeMdx.append("}*");
                    mdx.append(scopeMdx);
                }
            } else {
                if (scopeMdx.length() > 0) {
                    scopeMdx.delete(scopeMdx.length() - 1, scopeMdx.length());
                }
                intersectScopeMdx = new StringBuffer("{Intersect(").append(scopeMdx);
                intersectScopeMdx.append("}");
                intersectScopeMdx.append(",");
                intersectScopeMdx.append(conditionScope);
                intersectScopeMdx.append(")");
                if (field.equals(refField) && this.isExists) {
                    mdx.append(intersectScopeMdx);
                } else if (field.equals(refField) && !this.isExists) {
                    scopeMdx.append("}");
                    scopeMdx = scopeMdx.append("-").append(intersectScopeMdx);
                    scopeMdx.append("}");
                    scopeMdx = new StringBuffer("{").append(scopeMdx);
                    mdx.append(scopeMdx);
                } else {
                    mdx.append(scopeMdx);
                }
            }
        } else if (this.condition instanceof BinaryExpr) {
            if (!isAfterScope) {
                if (scopeMdx.length() > 0) {
                    scopeMdx.delete(scopeMdx.length() - 1, scopeMdx.length());
                }
                mdx.append(scopeMdx);
            }
        } else if (!isAfterScope) {
            if (scopeMdx.length() > 0) {
                scopeMdx.delete(scopeMdx.length() - 1, scopeMdx.length());
            }
            mdx.append(scopeMdx);
        }
    }

    private void fillCalcMemberToExpr(Object expr, BizCalcMember calcMember2) {
        if (expr instanceof BinaryExpr) {
            ((BinaryExpr)expr).calcMember = calcMember2;
            this.fillCalcMemberToExpr(((BinaryExpr)expr).left, calcMember2);
            this.fillCalcMemberToExpr(((BinaryExpr)expr).right, calcMember2);
        } else if (expr instanceof MdxMemberExpr) {
            ((MdxMemberExpr)expr).calcMember = calcMember2;
        } else if (expr instanceof VariateExpr) {
            ((VariateExpr)expr).expr.calcMember = calcMember2;
        } else if (expr instanceof FunctionExpr) {
            ((FunctionExpr)expr).calcMember = calcMember2;
        }
    }

    private StringBuffer processParams(List params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        String refField = null;
        String tmpStr = null;
        String curNum = null;
        String srcNum = null;
        String src = null;
        String memNum = null;
        String selectType = null;
        String isDetail = null;
        Object param = params.get(0);
        Object tmpStrs = null;
        FunctionExpr expr = null;
        if (!(param instanceof FunctionExpr)) {
            str.append("{");
            int in = params.size();
            for (int i = 0; i < in; ++i) {
                tmpStr = params.get(i).toString();
                curNum = tmpStr.replace("\"", "");
                selectType = curNum.substring(0, curNum.indexOf(":"));
                srcNum = curNum.substring(curNum.indexOf("[") + 1, curNum.indexOf("]"));
                memNum = srcNum.split(":")[1];
                src = srcNum.split(":")[0];
                refField = this.calcMember.getSrcFieldMap().get(src);
                if (!StringUtils.isEmpty((String)tmpStr)) {
                    str.append(BizExprUtils.getMdxField(refField) + BizExprUtils.getMdxNumber(refField, src, srcNum, this.calcMember.getMdxNumMap(), this.calcMember.getNumInnMap(), this.calcMember.isOrgLongNumber));
                }
                str.append(",");
            }
            if (str.length() > 1) {
                str.delete(str.length() - 1, str.length());
            }
            str.append("}");
            if (!this.isExists) {
                str = new StringBuffer("{").append(new StringBuffer(BizExprUtils.getMdxField(refField)).append(".members").append("-").append(str)).append("}");
            }
        } else {
            MemberExpr memberExpr = null;
            int in = params.size();
            for (int i = 0; i < in; ++i) {
                str.append("{");
                expr = (FunctionExpr)params.get(i);
                if (expr.params.get(0) instanceof MemberExpr) {
                    memberExpr = (MemberExpr)expr.params.get(0);
                    refField = memberExpr.field;
                    if (refField == null) {
                        refField = this.calcMember.getSrcFieldMap().get(memberExpr.srcNumber);
                    }
                }
                if (params.size() > 1) {
                    isDetail = expr.params.get(1).toString();
                }
                if (memberExpr == null || this.calcMember == null) continue;
                String tmpfun = BizExprUtils.getMdxField(refField) + BizExprUtils.getMdxNumber(refField, memberExpr.srcNumber, memberExpr.getDimNumber(), this.calcMember.getMdxNumMap(), this.calcMember.getNumInnMap(), this.calcMember.isOrgLongNumber);
                str.append(BizExprUtils.getMdxFunctionStr(expr.functionName, tmpfun, BizExprUtils.getMdxField(refField), isDetail)).append(",");
            }
            if (str.length() > 1) {
                str.delete(str.length() - 1, str.length());
            }
            str.append("}");
            if (!this.isExists) {
                str = new StringBuffer("{").append(new StringBuffer(BizExprUtils.getMdxField(refField)).append(".members").append("-").append(str)).append("}");
            }
        }
        return str;
    }

    private void processIsMemberConditon(StringBuffer sb) {
        if (this.condition == null || this.condition.toString().indexOf("ISMEMBER") == -1) {
            return;
        }
        StringBuffer rst = new StringBuffer();
        rst = this.processParams(((FunctionExpr)this.condition).params);
        sb.append(rst).append(" * ");
    }

    @Override
    public IExpress clone() throws CloneNotSupportedException {
        BinaryExpr clone = (BinaryExpr)super.clone();
        if (this.left != null) {
            clone.left = this.left.clone();
        }
        clone.right = this.right.clone();
        return clone;
    }

    public BizAlgoParam buildParam() {
        BizAlgoParam param = new BizAlgoParam();
        String mdx = null;
        mdx = this.operType.getSID() == 20 ? this.toCalMdx(param) : this.toMemberMdx(param);
        return param;
    }

    @Override
    public String build() {
        String mdx = null;
        mdx = this.operType.getSID() == 20 ? this.toCalMdx() : this.toMemberMdx();
        return mdx;
    }

    private String toCalMdx(BizAlgoParam bizAlgoParam) {
        this.checkExpr(this.left);
        this.checkExpr(this.right);
        StringBuffer mdx = new StringBuffer();
        StringBuffer scopeMdx = null;
        StringBuffer rightExpr = new StringBuffer();
        String scopeName = BizExprUtils.getCalcNumber(this.calcNumber, this.calcSeq, this.calcSubSeq, this.exprSeq, this.subSeq);
        bizAlgoParam.setScopeName(scopeName);
        if (this.scopes != null && !this.scopes.isEmpty()) {
            Map.Entry<String, Set<String>> entry2 = null;
            Set<String> tmpScope = null;
            String field = null;
            String[] tmpStrs = null;
            for (Map.Entry<String, Set<String>> entry2 : this.scopes.entrySet()) {
                String tmpfun;
                String isDetail;
                String functionName;
                field = entry2.getKey();
                tmpScope = entry2.getValue();
                boolean isMemberFun = false;
                boolean isRemoveFun = false;
                if (this.isIgnoreOrg && DimensionBaseConstants.DEF_ORGUNIT_FIELD.equalsIgnoreCase(field) || DimensionBaseConstants.DEF_PROCESS_FIELD.equalsIgnoreCase(field) || field == null || tmpScope == null || tmpScope.isEmpty()) continue;
                scopeMdx = new StringBuffer();
                String mdxFiled = BizExprUtils.replaceAllNull(BizExprUtils.getMdxField(field));
                if (DimUtils.checkBaseDimensionByField((String)field)) {
                    scopeMdx.append("{");
                    for (String scopeNum : tmpScope) {
                        if (scopeNum == null) continue;
                        isMemberFun = scopeNum.indexOf("@") != -1;
                        isRemoveFun = scopeNum.indexOf("Remove") != -1;
                        functionName = null;
                        isDetail = scopeNum;
                        if (isRemoveFun) {
                            functionName = BizExprUtils.getFunctionNameByScopeMemNum(scopeNum);
                            scopeMdx.append(BizExprUtils.getRemoveFunByScopeMemNum(scopeNum, field, this.calcMember)).append(" ");
                            continue;
                        }
                        if (isMemberFun) {
                            functionName = BizExprUtils.getFunctionNameByScopeMemNum(scopeNum);
                            scopeNum = BizExprUtils.getScopeNumByScopeMemNum(scopeNum);
                            isDetail = BizExprUtils.getIsDetailByScopeMemNum(isDetail);
                        }
                        if (scopeNum != null) {
                            tmpStrs = scopeNum.split(":");
                        }
                        if (tmpStrs == null) continue;
                        if (isMemberFun) {
                            tmpfun = BizExprUtils.getMdxField(field) + BizExprUtils.getMdxNumber(field, tmpStrs[0], scopeNum, this.calcMember.getMdxNumMap(), this.calcMember.getNumInnMap(), this.calcMember.isOrgLongNumber);
                            scopeMdx.append(BizExprUtils.getMdxFunctionStr(functionName, tmpfun, BizExprUtils.getMdxField(field), isDetail)).append(",");
                            continue;
                        }
                        scopeMdx.append("");
                        scopeMdx.append(BizExprUtils.getMdxField(field));
                        scopeMdx.append(BizExprUtils.getMdxNumber(field, tmpStrs[0], scopeNum, this.calcMember.getMdxNumMap(), this.calcMember.getNumInnMap(), this.calcMember.isOrgLongNumber)).append("").append(",");
                    }
                    this.processConditionScope(mdx, field, scopeMdx, false);
                    scopeMdx.append("}");
                    bizAlgoParam.addMemberScope(new BizMemberScope(mdxFiled, BizExprUtils.replaceAll(scopeMdx.toString())));
                    continue;
                }
                scopeMdx.append("{");
                for (String scopeNum : tmpScope) {
                    if (scopeNum == null) continue;
                    isMemberFun = scopeNum.indexOf("@") != -1;
                    isRemoveFun = scopeNum.indexOf("Remove") != -1;
                    functionName = null;
                    isDetail = scopeNum;
                    if (isRemoveFun) {
                        functionName = BizExprUtils.getFunctionNameByScopeMemNum(scopeNum);
                        scopeMdx.append(BizExprUtils.getRemoveFunByScopeMemNum(scopeNum, field, this.calcMember)).append(" ");
                        continue;
                    }
                    if (isMemberFun) {
                        functionName = BizExprUtils.getFunctionNameByScopeMemNum(scopeNum);
                        scopeNum = BizExprUtils.getScopeNumByScopeMemNum(scopeNum);
                        isDetail = BizExprUtils.getIsDetailByScopeMemNum(isDetail);
                    }
                    if (scopeNum != null) {
                        tmpStrs = scopeNum.split(":");
                    }
                    if (tmpStrs == null) continue;
                    if (isMemberFun) {
                        tmpfun = BizExprUtils.getMdxField(field) + BizExprUtils.getMdxNumber(field, tmpStrs[0], scopeNum, this.calcMember.getMdxNumMap(), this.calcMember.getNumInnMap(), this.calcMember.isOrgLongNumber);
                        scopeMdx.append(BizExprUtils.getMdxFunctionStr(functionName, tmpfun, BizExprUtils.getMdxField(field), isDetail)).append(",");
                        continue;
                    }
                    scopeMdx.append("");
                    scopeMdx.append(BizExprUtils.getMdxField(field));
                    scopeMdx.append(BizExprUtils.getMdxNumber(field, tmpStrs[0], scopeNum, this.calcMember.getMdxNumMap(), this.calcMember.getNumInnMap(), this.calcMember.isOrgLongNumber)).append("").append(",");
                }
                this.processConditionScope(mdx, field, scopeMdx, false);
                scopeMdx.append("}");
                bizAlgoParam.addMemberScope(new BizMemberScope(mdxFiled, BizExprUtils.replaceAll(scopeMdx.toString())));
            }
            this.processConditionScope(mdx, field, scopeMdx, true);
            this.processIsMemberConditon(mdx);
        } else {
            this.processConditionScope(mdx, null, scopeMdx, true);
            this.processIsMemberConditon(mdx);
        }
        this.getUniqueName(this.left, bizAlgoParam);
        if (this.left instanceof MdxMemberExpr) {
            bizAlgoParam.setLeafFeature(((MdxMemberExpr)this.left).leafFeature);
        }
        if (this.condition == null || this.condition.toString().indexOf("ISMEMBER") != -1) {
            this.checkExpr(this.right);
            rightExpr.append(this.right.build());
        } else if (this.condition instanceof FunctionExpr) {
            ((FunctionExpr)this.condition).calcMember = this.calcMember;
            ((FunctionExpr)this.condition).isExists = this.isExists;
            rightExpr.append(this.condition.build());
            this.checkExpr(this.right);
            rightExpr.append(this.right.build());
            rightExpr.append(" End");
            rightExpr.append("'");
        } else if (this.condition instanceof BinaryExpr) {
            ((BinaryExpr)this.condition).calcMember = this.calcMember;
            ((BinaryExpr)this.condition).isExists = this.isExists;
            rightExpr.append("'");
            rightExpr.append("Case When ");
            rightExpr.append(this.condition.build());
            rightExpr.append(" Then ");
            this.checkExpr(this.right);
            rightExpr.append(this.right.build());
            rightExpr.append("+ 0 ");
            if (this.otherExpr != null) {
                rightExpr.append(" when ");
                ((BinaryExpr)this.condition).calcMember = this.calcMember;
                ((BinaryExpr)this.condition).isExists = !this.isExists;
                rightExpr.append(this.condition.build());
                rightExpr.append(" Then ");
                this.checkExpr(this.otherExpr);
                rightExpr.append(this.otherExpr.build());
                rightExpr.append("+ 0 ");
            }
            rightExpr.append(" End");
            rightExpr.append("'");
        }
        String expression = BizExprUtils.replaceAll(rightExpr.toString());
        bizAlgoParam.setExpression(expression);
        return null;
    }

    private String toMemberMdx(BizAlgoParam bizAlgoParam) {
        StringBuffer mdx = new StringBuffer();
        this.checkExpr(this.left);
        if (this.left instanceof BinaryExpr) {
            BinaryExpr _left = (BinaryExpr)this.left;
            if (OperationType.comparePRI(this.operType.getSID(), _left.operType.getSID()) >= 0) {
                mdx.append("(" + this.left.toMdx() + ")");
            } else {
                mdx.append(this.left.toMdx());
            }
        } else {
            mdx.append(this.left.toMdx());
        }
        if (this.isExists) {
            mdx.append(" " + this.operType.getOper() + " ");
        } else {
            String oper = BizExprUtils.transOperationType(this.operType.getOper());
            mdx.append(" " + oper + " ");
        }
        this.checkExpr(this.right);
        if (this.operType.getSID() == 20) {
            mdx.append(this.right.toMdx());
        } else if (this.right instanceof BinaryExpr) {
            BinaryExpr _right = (BinaryExpr)this.right;
            if (OperationType.comparePRI(this.operType.getSID(), _right.operType.getSID()) >= 0) {
                mdx.append("(" + this.right.toMdx() + ")");
            } else {
                mdx.append(this.right.toMdx());
            }
        } else {
            mdx.append(this.right.toMdx());
        }
        return mdx.toString();
    }

    protected void synExprParam(IExpress expr) {
        if (expr instanceof FunctionExpr) {
            ((FunctionExpr)expr).calcMember = this.calcMember;
            ((FunctionExpr)expr).isExists = this.isExists;
        } else if (expr instanceof ConditionExpr) {
            ((ConditionExpr)expr).calcMember = this.calcMember;
            ((ConditionExpr)expr).isExists = this.isExists;
        } else if (expr instanceof BinaryExpr) {
            ((BinaryExpr)expr).calcMember = this.calcMember;
            ((BinaryExpr)expr).isExists = this.isExists;
            ((BinaryExpr)expr).calcNumber = this.calcNumber;
            ((BinaryExpr)expr).calcSeq = this.calcSeq;
            ((BinaryExpr)expr).calcSubSeq = this.calcSubSeq;
            ((BinaryExpr)expr).exprSeq = this.exprSeq;
            ((BinaryExpr)expr).scopes = this.scopes;
            ((BinaryExpr)expr).refFieldSet = this.refFieldSet;
            ((BinaryExpr)expr).isIgnoreOrg = this.isIgnoreOrg;
        }
    }

    protected String getUniqueName(IExpress left, BizAlgoParam bizAlgoParam) {
        String uniqueName = null;
        String tmpMdx = null;
        String mdxFiled = null;
        String accountUniqueName = null;
        if (left instanceof MdxMemberExpr) {
            int i;
            MdxMemberExpr mdxMemberExpr = (MdxMemberExpr)left;
            List<IExpress> params = mdxMemberExpr.params;
            IExpress param = null;
            int in = params.size();
            for (i = 0; i < in; ++i) {
                param = params.get(i);
                if (param == null || !(param instanceof MemberExpr)) continue;
                ((MemberExpr)param).calcMember = this.calcMember;
                if (StringUtils.isEmpty((String)((MemberExpr)param).field) || !((MemberExpr)param).field.equals(DimensionConstants.DEF_BGINDEX_FIELD)) continue;
                accountUniqueName = BizExprUtils.replaceAll(param.build());
                break;
            }
            in = params.size();
            for (i = 0; i < in; ++i) {
                param = params.get(i);
                if (param == null || !(param instanceof MemberExpr)) continue;
                ((MemberExpr)param).calcMember = this.calcMember;
                if (StringUtils.isEmpty((String)((MemberExpr)param).field)) continue;
                if (!StringUtils.isEmpty((String)accountUniqueName)) {
                    if (((MemberExpr)param).field.equals(DimensionConstants.DEF_BGINDEX_FIELD)) {
                        uniqueName = accountUniqueName;
                        continue;
                    }
                    mdxFiled = BizExprUtils.replaceAllNull(BizExprUtils.getMdxField(((MemberExpr)param).field));
                    tmpMdx = BizExprUtils.replaceAll(param.build());
                    bizAlgoParam.addMemberScope(new BizMemberScope(mdxFiled, tmpMdx));
                    continue;
                }
                if (i == 0) {
                    uniqueName = BizExprUtils.replaceAll(param.build());
                    continue;
                }
                mdxFiled = BizExprUtils.replaceAllNull(BizExprUtils.getMdxField(((MemberExpr)param).field));
                tmpMdx = BizExprUtils.replaceAll(param.build());
                if (tmpMdx.indexOf("{") < 0 && tmpMdx.indexOf("}") < 0) {
                    tmpMdx = "{" + tmpMdx + "}";
                }
                bizAlgoParam.addMemberScope(new BizMemberScope(mdxFiled, tmpMdx));
            }
        }
        bizAlgoParam.setUniqueName(uniqueName);
        return uniqueName;
    }

    protected boolean checkLeftHasScop(IExpress left) {
        boolean hasScope = false;
        if (left instanceof MdxMemberExpr) {
            MdxMemberExpr mdxMemberExpr = (MdxMemberExpr)left;
            List<IExpress> params = mdxMemberExpr.params;
            if (params.size() > 1) {
                hasScope = true;
            }
        }
        return hasScope;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String toPTOString(Map<String, List<String>> allPeriodMap, String bgPeriodNumber) {
        String rStr;
        StringBuffer str = new StringBuffer();
        if (this.left instanceof BinaryExpr) {
            BinaryExpr _left = (BinaryExpr)this.left;
            if (OperationType.comparePRI(this.operType.getSID(), _left.operType.getSID()) > 0) {
                str.append("(" + this.left.toPTOString(allPeriodMap, bgPeriodNumber) + ")");
            } else {
                str.append(this.left.toPTOString(allPeriodMap, bgPeriodNumber));
            }
            if (str.length() == 0) {
                return "";
            }
            str.append(" " + this.operType.getOper() + " ");
        } else if (this.left != null) {
            str.append(this.left.toPTOString(allPeriodMap, bgPeriodNumber));
            if (str.length() != 0) {
                str.append(" " + this.operType.getOper() + " ");
            }
        }
        if (this.operType.getSID() == 20) {
            rStr = this.right.toPTOString(allPeriodMap, bgPeriodNumber);
            if (StringUtils.isEmpty((String)rStr)) return "";
            str.append(rStr);
            return str.toString();
        } else if (this.right instanceof BinaryExpr) {
            BinaryExpr _right = (BinaryExpr)this.right;
            String rStr2 = this.right.toPTOString(allPeriodMap, bgPeriodNumber);
            if (StringUtils.isEmpty((String)rStr2)) {
                return "";
            }
            if (OperationType.comparePRI(this.operType.getSID(), _right.operType.getSID()) >= 0) {
                str.append("(" + this.right.toPTOString(allPeriodMap, bgPeriodNumber) + ")");
                return str.toString();
            } else {
                str.append(this.right.toPTOString(allPeriodMap, bgPeriodNumber));
            }
            return str.toString();
        } else {
            rStr = this.right.toPTOString(allPeriodMap, bgPeriodNumber);
            if (StringUtils.isEmpty((String)rStr)) {
                return "";
            }
            str.append(rStr);
        }
        return str.toString();
    }
}

