/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.biz.BizCalcFacadeFactory;
import com.kingdee.eas.ma.biz.execute.face.IBizParameter;
import com.kingdee.eas.ma.biz.execute.impl.BizCalcParameter;
import org.apache.log4j.Logger;

public class BizCalcFacadeImpl
implements Runnable {
    private static final Logger logger = Logger.getLogger(BizCalcFacadeImpl.class);
    private Context ctx = null;
    private IBizParameter parameter = null;

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setParameter(IBizParameter parameter) {
        this.parameter = parameter;
    }

    public IBizParameter getParameter() {
        return this.parameter;
    }

    @Override
    public void run() {
        if (this.getParameter() == null) {
            return;
        }
        try {
            if (this.getCtx() != null) {
                BizCalcFacadeFactory.getLocalInstance(this.getCtx()).executeBGUpdate(this.getParameter());
            } else {
                BizCalcFacadeFactory.getRemoteInstance().executeBGUpdate(this.getParameter());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"bizDataFacadeImpl run error:", (Throwable)ex);
        }
    }

    public IBizParameter transParameter(BOSUuid bgSchemeId, BOSUuid orgUnitId, BOSUuid billId, boolean isAdjust) {
        if (bgSchemeId == null || orgUnitId == null) {
            return null;
        }
        BizCalcParameter parameter = new BizCalcParameter();
        parameter.setOrgUnitId(orgUnitId);
        parameter.setBgSchemeId(bgSchemeId);
        parameter.setBillId(billId);
        parameter.getControlManager().setAdjust(isAdjust);
        return parameter;
    }
}

