/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.parse;

import com.kingdee.eas.ma.biz.BizCalcParseException;
import com.kingdee.eas.ma.biz.expr.oper.AbstractOper;
import com.kingdee.eas.ma.biz.parse.AbstractBizChecker;
import com.kingdee.eas.ma.biz.parse.BizParseExceptionHandler;
import com.kingdee.eas.ma.biz.parse.BizParseParam;
import com.kingdee.eas.ma.biz.parse.Parse2RPN;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class BizCalcExprChecker
extends AbstractBizChecker {
    private BizParseParam param = null;
    private Integer currLine = null;
    private String text = null;
    private String bizName = null;
    private String subsetName = null;
    private static Set<String> ILLEGAL_OPER = new HashSet<String>();

    public BizCalcExprChecker(BizParseParam param) {
        Collections.addAll(ILLEGAL_OPER, ">", ">=", "<", "<=", "==", "<>", "NOT", "AND", "OR");
        this.param = param;
        this.text = param.getText();
        this.currLine = param.getCurrLine();
        this.bizName = param.getBizName();
        this.subsetName = param.getSubsetName();
    }

    @Override
    public boolean check(Stack expr) {
        if (!this.checkToken(expr)) {
            return false;
        }
        Parse2RPN rpnParser = new Parse2RPN("", this.currLine, (Stack)expr.clone());
        try {
            rpnParser.parse();
            String type = rpnParser.getExprReturnType();
            if (!type.equals("numeric")) {
                return false;
            }
        }
        catch (BizCalcParseException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected boolean checkToken(Stack expr) {
        if (!super.checkToken(expr)) {
            return false;
        }
        for (int i = 0; i < expr.size(); ++i) {
            Object obj = expr.get(i);
            if (!(obj instanceof AbstractOper) || !((AbstractOper)obj).getOper().equals("=") && !ILLEGAL_OPER.contains(((AbstractOper)obj).getOper())) continue;
            return false;
        }
        return true;
    }

    private void recordException(NumericExceptionSubItem excSubItem, String charSeq) {
        BizParseExceptionHandler.recordException(excSubItem, charSeq, this.param);
    }
}

