/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.parse;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcParseException;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizScopeCollection;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.parse.Parse2Cond;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.parse.BizAssignExprChecker;
import com.kingdee.eas.ma.biz.parse.BizExprParser;
import com.kingdee.eas.ma.biz.parse.BizParseDimMemHelper;
import com.kingdee.eas.ma.biz.parse.BizParseExceptionHandler;
import com.kingdee.eas.ma.biz.parse.BizParseHelper;
import com.kingdee.eas.ma.biz.parse.BizParseParam;
import com.kingdee.eas.ma.biz.parse.expr.IBizExpr;
import com.kingdee.eas.ma.biz.parse.expr.impl.BizAssignmentExpr;
import com.kingdee.eas.ma.biz.parse.expr.impl.BizConditionExpr;
import com.kingdee.eas.ma.biz.parse.operand.impl.Operand;
import com.kingdee.eas.ma.biz.utils.BizCalcCommonHelper;
import com.kingdee.eas.ma.mbg.BgExamineParseException;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class BizFormulaVerifyHelper {
    private LinkedHashMap<String, LinkedHashMap<String, String>> bizCalcFormulaMap = null;
    private Map<String, Map<String, Set<String>>> bizScopeSrcMap = null;
    private Map<String, Map<String, BizScopeCollection>> bizScopeMap = null;
    private Map<String, Map<String, String>> memberMap = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private boolean showBizNameInException = false;
    private String text = null;
    private String bizName = null;
    private String subsetName = null;
    private Set<String> scopeSrc = null;
    private Map<String, Map<String, Map<Integer, List<IBizExpr>>>> exprMap = new LinkedHashMap<String, Map<String, Map<Integer, List<IBizExpr>>>>();
    private Map<String, Map<String, Map<Integer, List<Exception>>>> allExceptions = new LinkedHashMap<String, Map<String, Map<Integer, List<Exception>>>>();
    private Map<String, String> bizBgVariateMap = new HashMap<String, String>();
    private Map<String, Set<String>> childOrgMap = new HashMap<String, Set<String>>();
    private int currLine = 1;
    private int currPos = 0;
    private char currChar = '\u0000';
    private char lastNotBlankChar = '\u0000';
    private final char SEMICOLON = (char)59;
    private final char STACK_OPERATOR = '\u0000';

    public BizFormulaVerifyHelper(LinkedHashMap<String, LinkedHashMap<String, String>> bizCalcFormulaMap, Map<String, Map<String, Set<String>>> bizScopeSrcMap, Map<String, Map<String, BizScopeCollection>> bizScopeMap, BgSchemeDimensionHelper schemeHelper, boolean showBizNameInException, Map<String, Map<String, String>> memberMap) {
        this.bizCalcFormulaMap = bizCalcFormulaMap;
        this.bizScopeSrcMap = bizScopeSrcMap;
        this.bizScopeMap = bizScopeMap;
        this.schemeHelper = schemeHelper;
        this.showBizNameInException = showBizNameInException;
        this.memberMap = memberMap;
    }

    public static Map<String, Map<String, String>> getMemberMaps(Collection<BizCalcInfo> bizCalcs) {
        HashMap<String, Map<String, String>> memberMaps = new HashMap<String, Map<String, String>>();
        for (BizCalcInfo info : bizCalcs) {
            Map<String, String> map = info.getMemberMaps();
            if (map == null) continue;
            memberMaps.put(info.getNumber(), map);
        }
        return memberMaps;
    }

    public void batchParse() throws EASBizException, BOSException {
        if (this.bizCalcFormulaMap == null || this.bizScopeSrcMap == null || this.schemeHelper == null) {
            return;
        }
        Iterator<String> iterator = this.bizCalcFormulaMap.keySet().iterator();
        while (iterator.hasNext()) {
            String bizName;
            this.bizName = bizName = iterator.next();
            Map subset = this.bizCalcFormulaMap.get(bizName);
            if (this.exprMap.get(bizName) == null) {
                this.exprMap.put(bizName, new LinkedHashMap());
            }
            if (this.allExceptions.get(bizName) == null) {
                this.allExceptions.put(bizName, new LinkedHashMap());
            }
            for (String subsetName : subset.keySet()) {
                this.scopeSrc = this.bizScopeSrcMap.get(bizName) != null ? this.bizScopeSrcMap.get(bizName).get(subsetName) : null;
                this.subsetName = subsetName;
                this.text = (String)subset.get(subsetName);
                if (this.exprMap.get(bizName).get(subsetName) == null) {
                    this.exprMap.get(bizName).put(subsetName, new LinkedHashMap());
                }
                if (this.allExceptions.get(bizName).get(subsetName) == null) {
                    this.allExceptions.get(bizName).put(subsetName, new LinkedHashMap());
                }
                this.parse();
            }
        }
        BizParseDimMemHelper dimMemHelper = new BizParseDimMemHelper(this.exprMap, this.bizBgVariateMap, this.schemeHelper, this.bizScopeSrcMap, this.bizScopeMap, this.memberMap, this.childOrgMap, this.allExceptions);
        dimMemHelper.verifyMemberIsExist();
    }

    private boolean checkDoubleMatchAnnotation(String script) {
        int b;
        int a;
        return StringUtils.isEmpty((String)script) || script.length() <= 3 || (a = org.apache.commons.lang.StringUtils.countMatches((String)script, (String)"/*")) == (b = org.apache.commons.lang.StringUtils.countMatches((String)script, (String)"*/"));
    }

    private void parse() throws EASBizException, BOSException {
        if (this.text == null) {
            return;
        }
        this.init();
        this.getChar();
        while (this.currChar != '\u0000') {
            String script = this.readScript();
            if (!this.checkDoubleMatchAnnotation(script)) {
                this.currLine = this.currLine + org.apache.commons.lang.StringUtils.countMatches((String)script, (String)String.valueOf('\n')) - 1;
                this.recordException(BgExamineParseException.ERROR_ANNO_NO_END, script.contains("*/") ? script.substring(0, script.indexOf("*/") + 2) : script);
                continue;
            }
            if (this.isLikeIF(script)) {
                this.recordException(BizCalcParseException.ERROR_IF_LEFT, script.contains("*/") ? script.substring(script.indexOf("*/") + 2, script.length()) : script);
                continue;
            }
            if (StringUtils.isEmpty((String)script) || script.trim().equals(String.valueOf(';')) || BizParseHelper.isAnnotation(org.apache.commons.lang.StringUtils.strip((String)script, (String)String.valueOf(';')))) {
                this.currLine += org.apache.commons.lang.StringUtils.countMatches((String)script, (String)String.valueOf('\n'));
                this.getChar();
                continue;
            }
            if (!StringUtils.isEmpty((String)script) && !script.endsWith(String.valueOf(';'))) {
                this.currLine += org.apache.commons.lang.StringUtils.countMatches((String)script, (String)String.valueOf('\n'));
                this.recordException(BizCalcParseException.EXPR_NO_END, script.contains("*/") ? script.substring(script.indexOf("*/") + 2, script.length()) : script);
                continue;
            }
            BizExprParser parser = new BizExprParser(this.createParam(script));
            if (parser.parse()) {
                this.currLine = parser.getCurrLine();
                Stack exprStack = parser.getExprStack();
                BizAssignExprChecker exprCheck = new BizAssignExprChecker(this.createParam(script));
                if (exprCheck.check(exprStack)) {
                    if (exprStack.size() == 3 && exprStack.get(2) instanceof Operand && BizParseHelper.isIf(((Operand)exprStack.get(2)).getOperand())) {
                        Parse2Cond condParser = new Parse2Cond(((Operand)exprStack.get(2)).getOperand());
                        try {
                            condParser.parse();
                            ConditionExpr _expr = (ConditionExpr)condParser.getExpr();
                            for (IExpress result : _expr.getAllExpresss()) {
                                Operand _operand = new Operand(result.getOriginalExpr().trim());
                                Stack _stack = new Stack();
                                _stack.push(exprStack.get(0));
                                _stack.push(exprStack.get(1));
                                _stack.push(_operand);
                                BizConditionExpr _condExpr = new BizConditionExpr(_stack, null);
                                BizExprParser _parser = new BizExprParser(this.createParam(_condExpr.toString()));
                                _parser.parse();
                                _condExpr = new BizConditionExpr(_parser.getExprStack(), _condExpr.toString().replaceAll("\r", "").replaceAll("\n", ""));
                                if (_expr.conditions.contains(result)) {
                                    _condExpr.setCondition(true);
                                }
                                this.recordExpr(_condExpr);
                            }
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    } else {
                        BizAssignmentExpr expr = new BizAssignmentExpr(exprStack);
                        this.recordExpr(expr);
                    }
                }
            } else {
                this.currLine = parser.getCurrLine();
            }
            this.getChar();
        }
    }

    private void parseBgVariate() throws EASBizException, BOSException {
    }

    private void recordExpr(IBizExpr expr) {
        List<IBizExpr> lineList = this.exprMap.get(this.bizName).get(this.subsetName).get(this.currLine);
        if (lineList == null) {
            lineList = new ArrayList<IBizExpr>();
            this.exprMap.get(this.bizName).get(this.subsetName).put(this.currLine, lineList);
        }
        lineList.add(expr);
    }

    private String readScript() {
        StringBuffer script = new StringBuffer();
        int count = 0;
        boolean isAcct = false;
        boolean isMbgRefBgTem = false;
        int index = 0;
        StringBuffer convertScript = new StringBuffer();
        while ((!this.isSemicolon(this.currChar) || isAcct || isMbgRefBgTem) && this.currChar != '\u0000' && count >= 0) {
            char quo;
            if (this.currChar == '/' && this.preViewNextChar() == '*') {
                script.append(this.readAnnotation());
                this.getChar();
                continue;
            }
            if (this.currChar == '{') {
                ++count;
            }
            if (this.currChar == '}') {
                --count;
            }
            script.append(this.currChar);
            convertScript.append(this.currChar);
            if (convertScript.toString().contains("Acct")) {
                isAcct = true;
                quo = '\"';
                if (quo == this.currChar) {
                    ++index;
                }
                if (index > 1) {
                    isAcct = false;
                    index = 0;
                    convertScript = new StringBuffer();
                }
            }
            if (convertScript.toString().contains("MbgRefBgTem")) {
                isMbgRefBgTem = true;
                quo = '\"';
                if (quo == this.currChar) {
                    ++index;
                }
                if (index > 1) {
                    isMbgRefBgTem = false;
                    index = 0;
                    convertScript = new StringBuffer();
                }
            }
            this.getChar();
        }
        if (this.isSemicolon(this.currChar)) {
            script.append(this.currChar);
        }
        return script.toString();
    }

    private String readAnnotation() {
        StringBuffer annoStr = new StringBuffer();
        while (this.currChar != '\u0000') {
            if (this.currChar == '/' && annoStr.length() > 1 && annoStr.charAt(annoStr.length() - 1) == '*') {
                annoStr.append(this.currChar);
                break;
            }
            annoStr.append(this.currChar);
            this.getChar();
        }
        return annoStr.toString();
    }

    private void init() {
        this.currLine = 1;
        this.currPos = 0;
        this.currChar = '\u0000';
    }

    private void getChar() {
        if (this.currPos == this.text.length()) {
            this.currChar = '\u0000';
            return;
        }
        this.currChar = this.text.charAt(this.currPos++);
        if (this.currChar == '%' || this.currChar == '$') {
            return;
        }
    }

    private char preViewNextChar() {
        if (this.currPos == this.text.length()) {
            return '\u0000';
        }
        return this.text.charAt(this.currPos);
    }

    private boolean isSemicolon(char c) {
        return ';' == c;
    }

    private boolean isLikeIF(String script) {
        for (int i = 0; i < script.length(); ++i) {
            char c = script.charAt(i);
            if (BizParseHelper.isBlank(c)) continue;
            if (c == '/' && i + 1 < script.length() && script.charAt(i + 1) == '*') {
                if ((i = script.indexOf("*/", i) + 1) > 0) continue;
                return false;
            }
            if (c == 'I') {
                return script.charAt(i + 1) == 'F';
            }
            return false;
        }
        return false;
    }

    private void recordException(NumericExceptionSubItem excSubItem, String charSeq) {
        BizParseExceptionHandler.recordException(excSubItem, charSeq, this.createParam(""));
    }

    private BizParseParam createParam(String text) {
        BizParseParam param = new BizParseParam();
        param.setCurrLine(this.currLine);
        param.setBizName(this.bizName);
        param.setSubsetName(this.subsetName);
        param.setText(text);
        param.setExprMap(this.exprMap);
        param.setAllExceptions(this.allExceptions);
        return param;
    }

    public Map<String, Map<String, Map<Integer, List<Exception>>>> getAllExceptions() {
        return this.allExceptions;
    }

    public String getErrorMsg() {
        StringBuffer errorMsg = new StringBuffer();
        if (this.allExceptions.size() > 0) {
            for (String bizName : this.allExceptions.keySet()) {
                Map<String, Map<Integer, List<Exception>>> subsetException = this.allExceptions.get(bizName);
                for (String subsetName : subsetException.keySet()) {
                    Map<Integer, List<Exception>> lineException = subsetException.get(subsetName);
                    ArrayList<Integer> keyList = new ArrayList<Integer>(lineException.keySet());
                    Collections.sort(keyList);
                    for (Integer line : keyList) {
                        List<Exception> Exceptions = lineException.get(line);
                        for (Exception exception : Exceptions) {
                            if (this.showBizNameInException) {
                                errorMsg.append(new BizCalcParseException(BizCalcParseException.ERROR_SHOWBIZNAME, new Object[]{bizName, exception.getMessage().replaceAll("#0#", "{}")}).getMessage()).append("\r\n");
                                continue;
                            }
                            errorMsg.append(exception.getMessage().replaceAll("#0#", "{}")).append("\r\n");
                        }
                    }
                }
            }
            return errorMsg.toString();
        }
        return null;
    }

    public static void buildParseParam(Collection<BizCalcInfo> calcList, LinkedHashMap<String, LinkedHashMap<String, String>> bizCalcFormulaMap, Map<String, Map<String, Set<String>>> bizScopeSrcMap, Map<String, Map<String, BizScopeCollection>> bizScopeMap, BgSchemeDimensionHelper schemeHelper) {
        BizCalcSubsetInfo subSetInfo = null;
        BizCalcInfo bizCalcInfo2 = null;
        String bizNumber = null;
        for (BizCalcInfo bizCalcInfo2 : calcList) {
            bizNumber = bizCalcInfo2.getNumber();
            if (!bizScopeMap.containsKey(bizNumber)) {
                bizScopeMap.put(bizNumber, new HashMap());
            }
            Iterator it1 = bizCalcInfo2.getBizCalcSubset().iterator();
            while (it1.hasNext()) {
                subSetInfo = (BizCalcSubsetInfo)it1.next();
                if (!bizCalcFormulaMap.containsKey(bizNumber)) {
                    bizCalcFormulaMap.put(bizNumber, new LinkedHashMap());
                }
                bizCalcFormulaMap.get(bizNumber).put(subSetInfo.getName(), subSetInfo.getBizFormula());
                if (subSetInfo.getScope().isEmpty()) continue;
                if (!bizScopeSrcMap.containsKey(bizNumber)) {
                    bizScopeSrcMap.put(bizNumber, new HashMap());
                }
                bizScopeSrcMap.get(bizNumber).put(subSetInfo.getName(), BizCalcCommonHelper.processScope(subSetInfo.getScope(), schemeHelper));
                bizScopeMap.get(bizNumber).put(subSetInfo.getName(), subSetInfo.getScope());
            }
        }
    }
}

