/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParseHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgScriptParseHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.ScriptFormater;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizPtoUtils {
    private static Logger logger = Logger.getLogger(BizPtoUtils.class);
    public static String REF_PERIODS = "REF_PERIODS";

    public static boolean checkBeginAndEndPeriodType(String beginPeriodStr, String endPeriodStr) {
        boolean isSameType = true;
        if (!StringUtils.isEmpty((String)beginPeriodStr) && beginPeriodStr.length() > 4 && !StringUtils.isEmpty((String)endPeriodStr) && endPeriodStr.length() > 4) {
            String beginType = beginPeriodStr.substring(0, 4);
            String endType = endPeriodStr.substring(0, 4);
            String beginStr = beginPeriodStr.substring(5, beginPeriodStr.length());
            String endStr = endPeriodStr.substring(5, endPeriodStr.length());
            String end1 = beginPeriodStr.substring(beginPeriodStr.length() - 1, beginPeriodStr.length());
            String end2 = endPeriodStr.substring(endPeriodStr.length() - 1, endPeriodStr.length());
            boolean b1 = BgPeriodNVariableHelper.checkCanConvert((String)beginPeriodStr);
            boolean b2 = BgPeriodNVariableHelper.checkCanConvert((String)endPeriodStr);
            int t1 = BgNPeriodHelper.parserBgPeriodType((String)beginPeriodStr);
            int t2 = BgNPeriodHelper.parserBgPeriodType((String)endPeriodStr);
            if (!beginType.equals(endType)) {
                isSameType = false;
            } else if (!b1 && !b2) {
                if (t1 != t2) {
                    isSameType = false;
                }
            } else if ((b1 || b2) && !end1.equals(end2)) {
                isSameType = false;
            }
        }
        return isSameType;
    }

    public static boolean checkBeginPeriodBeforeEndPeriod(String beginPeriodStr, String endPeriodStr) {
        boolean beginBeforeEnd = true;
        if (!StringUtils.isEmpty((String)beginPeriodStr) && beginPeriodStr.length() > 4 && !StringUtils.isEmpty((String)endPeriodStr) && endPeriodStr.length() > 4) {
            String beginStr = beginPeriodStr.substring(5, beginPeriodStr.length());
            String endStr = endPeriodStr.substring(5, endPeriodStr.length());
            boolean b1 = BgPeriodNVariableHelper.checkCanConvert((String)beginPeriodStr);
            boolean b2 = BgPeriodNVariableHelper.checkCanConvert((String)endPeriodStr);
            if (!b1 && !b2 && beginStr.compareTo(endStr) > 0) {
                beginBeforeEnd = false;
            }
        }
        return beginBeforeEnd;
    }

    public static List<IExpress> transPtoExpress(Connection conn, IDimensionParameter parameter, List<IExpress> express) throws Exception {
        if (express == null || express.isEmpty()) {
            return express;
        }
        Map allPeriodMap = parameter.getAllPeriodMap();
        List<String> refPeriods = BizPtoUtils.getRefPeriods(parameter);
        return BizPtoUtils.transPtoExpress(express, refPeriods, allPeriodMap);
    }

    public static List<String> sortRefPeriods(Connection conn, List<String> refPeriods) throws BOSException {
        if (refPeriods != null && !refPeriods.isEmpty()) {
            if (conn != null) {
                StringBuffer sql = new StringBuffer("select FNumber from t_mbg_bgperiod where FNumber IN (");
                MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") order by Flongnumber asc ");
                refPeriods = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])refPeriods.toArray(), (int)50));
            } else {
                Collections.sort(refPeriods);
            }
        }
        return refPeriods;
    }

    public static List<IExpress> transPtoExpress(List<IExpress> express, List<String> refPeriods, Map<String, List<String>> allPeriodMap) throws Exception {
        if (refPeriods == null || allPeriodMap.isEmpty()) {
            return express;
        }
        ArrayList<IExpress> expressLst = new ArrayList<IExpress>();
        BinaryExpr binaryExpr = null;
        IExpress iExpress = null;
        String exprStr = "";
        String newExprStr = "";
        for (int i = 0; i < express.size(); ++i) {
            iExpress = express.get(i);
            exprStr = iExpress.getOriginalExpr();
            if (iExpress instanceof BinaryExpr && !StringUtils.isEmpty((String)exprStr) && exprStr.indexOf("PTO") >= 0) {
                binaryExpr = (BinaryExpr)iExpress;
                boolean hasCalc = binaryExpr.hasCalc;
                if (BizPtoUtils.hasNullPeriod(binaryExpr.right)) {
                    if (refPeriods == null || refPeriods.isEmpty()) continue;
                    for (int r = 0; r < refPeriods.size(); ++r) {
                        newExprStr = binaryExpr.toPTOString(allPeriodMap, refPeriods.get(r));
                        if (StringUtils.isEmpty((String)newExprStr)) continue;
                        List<IExpress> lst = BizPtoUtils.reParseExpress(newExprStr);
                        for (IExpress exp : lst) {
                            exp.setOriginalExpr(exprStr);
                            if (!(exp instanceof BinaryExpr)) continue;
                            ((BinaryExpr)exp).hasCalc = hasCalc;
                        }
                        expressLst.addAll(lst);
                    }
                    continue;
                }
                newExprStr = binaryExpr.toPTOString(allPeriodMap, null);
                if (StringUtils.isEmpty((String)newExprStr)) continue;
                List<IExpress> lst = BizPtoUtils.reParseExpress(newExprStr);
                for (IExpress exp : lst) {
                    exp.setOriginalExpr(exprStr);
                    if (!(exp instanceof BinaryExpr)) continue;
                    ((BinaryExpr)exp).hasCalc = hasCalc;
                }
                expressLst.addAll(lst);
                continue;
            }
            expressLst.add(iExpress);
        }
        return expressLst;
    }

    public static List<IExpress> reParseExpress(String formulaStr) throws Exception {
        ArrayList<IExpress> expressLst = new ArrayList<IExpress>();
        List<String> scripts = MbgScriptParseHelper.parse(formulaStr, new ScriptFormater());
        if (scripts != null) {
            String script = null;
            IExpress expre = null;
            int jn = scripts.size();
            for (int j = 0; j < jn; ++j) {
                script = scripts.get(j);
                expre = MbgExprParseHelper.parse(script, null);
                if (expre == null) continue;
                expressLst.add(expre);
            }
        }
        return expressLst;
    }

    public static boolean hasNullPeriod(IExpress expr) {
        if (expr == null) {
            return false;
        }
        boolean check = false;
        if (expr instanceof BinaryExpr) {
            check = BizPtoUtils.hasNullPeriod((BinaryExpr)expr);
        } else if (expr instanceof ConditionExpr) {
            check = BizPtoUtils.hasNullPeriod((ConditionExpr)expr);
        } else if (expr instanceof MdxMemberExpr) {
            check = BizPtoUtils.hasNullPeriod((MdxMemberExpr)expr);
        }
        return check;
    }

    public static boolean hasNullPeriod(BinaryExpr expr) {
        if (expr == null) {
            return false;
        }
        boolean check = false;
        if (expr.left instanceof BinaryExpr) {
            check = BizPtoUtils.hasNullPeriod((BinaryExpr)expr.left);
        } else if (expr.left instanceof ConditionExpr) {
            check = BizPtoUtils.hasNullPeriod((ConditionExpr)expr.left);
        } else if (expr.left instanceof MdxMemberExpr) {
            check = BizPtoUtils.hasNullPeriod((MdxMemberExpr)expr.left);
        }
        if (expr.right instanceof BinaryExpr) {
            check = BizPtoUtils.hasNullPeriod((BinaryExpr)expr.right);
        } else if (expr.right instanceof ConditionExpr) {
            check = BizPtoUtils.hasNullPeriod((ConditionExpr)expr.right);
        } else if (expr.right instanceof MdxMemberExpr) {
            check = BizPtoUtils.hasNullPeriod((MdxMemberExpr)expr.right);
        }
        return check;
    }

    public static boolean hasNullPeriod(ConditionExpr expr) {
        IExpress _expr;
        if (expr == null) {
            return false;
        }
        boolean check = false;
        Iterator<IExpress> iterator = expr.getAllExpresss().iterator();
        while (iterator.hasNext() && !(check = BizPtoUtils.hasNullPeriod(_expr = iterator.next()))) {
        }
        return check;
    }

    public static boolean hasNullPeriod(MdxMemberExpr expr) {
        boolean check = false;
        List<IExpress> express = null;
        HashMap<String, Boolean> checkPeriod = new HashMap<String, Boolean>();
        checkPeriod.put("BgP1", Boolean.FALSE);
        checkPeriod.put("BgP2", Boolean.FALSE);
        String exprStr = expr.toString();
        if (exprStr.trim().startsWith("PTO")) {
            express = expr.params;
            for (int i = 0; i < express.size(); ++i) {
                if (!(express.get(i) instanceof MemberExpr)) continue;
                MemberExpr m = (MemberExpr)express.get(i);
                if (StringUtils.isEmpty((String)m.srcNumber)) continue;
                if (m.srcNumber.equals("BgP1")) {
                    checkPeriod.put("BgP1", Boolean.TRUE);
                    continue;
                }
                if (!m.srcNumber.equals("BgP2")) continue;
                checkPeriod.put("BgP2", Boolean.TRUE);
            }
            if (!((Boolean)checkPeriod.get("BgP1")).booleanValue() || !((Boolean)checkPeriod.get("BgP2")).booleanValue()) {
                check = true;
            }
        }
        return check;
    }

    public static List<String> getBegin2EndPeriod(String beginPeriodStr, String endPeriodStr, Map<String, List<String>> periodMap) {
        return BizPtoUtils.parseBgPeriod(periodMap, beginPeriodStr, endPeriodStr);
    }

    public static Map<String, List<String>> queryBgPeriodInfo() throws Exception {
        HashMap<String, List<String>> periodMap = new HashMap<String, List<String>>();
        List<String> periodNum = null;
        String periodkey = null;
        String sql = "select p.FNumber, t.FNumber, t.FPeriodType from T_MBG_BgPeriodDisp t join T_MBG_BgPeriodType p on t.FTypeId = p.FID ORDER BY p.FNumber, t.FNumber ASC";
        IRowSet rst = null;
        try {
            ISQLExecutor iSql = null;
            iSql = SQLExecutorFactory.getRemoteInstance((String)sql);
            rst = iSql.executeSQL();
            while (rst.next()) {
                periodkey = rst.getString(1) + "_" + rst.getInt("FPeriodType");
                if (periodMap.containsKey(periodkey)) {
                    periodNum = (List)periodMap.get(periodkey);
                } else {
                    periodNum = new ArrayList();
                    periodMap.put(periodkey, periodNum);
                }
                periodNum.add(rst.getString(2));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"queryBgPeriodInfo error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return periodMap;
    }

    public static Map<String, List<String>> queryBgPeriodInfo(Connection conn) throws Exception {
        HashMap<String, List<String>> periodMap = new HashMap<String, List<String>>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        List<String> periodNum = null;
        String periodkey = null;
        try {
            pstmt = conn.prepareStatement("select p.FNumber, t.FNumber, t.FPeriodType from T_MBG_BgPeriodDisp t join T_MBG_BgPeriodType p on t.FTypeId = p.FID ORDER BY p.FNumber, t.FNumber ASC");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                periodkey = rst.getString(1) + "_" + rst.getInt("FPeriodType");
                if (periodMap.containsKey(periodkey)) {
                    periodNum = (List)periodMap.get(periodkey);
                } else {
                    periodNum = new ArrayList();
                    periodMap.put(periodkey, periodNum);
                }
                periodNum.add(rst.getString(2));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryBgPeriodInfo error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return periodMap;
    }

    public static List<String> parseBgPeriod(Map<String, List<String>> periodMap, String beginBgPeriodNumber, String endBgPeriodNumber) {
        ArrayList<String> bgPeriodList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)beginBgPeriodNumber) || StringUtils.isEmpty((String)endBgPeriodNumber) || periodMap.isEmpty()) {
            return bgPeriodList;
        }
        if (beginBgPeriodNumber.equals(endBgPeriodNumber)) {
            bgPeriodList.add(beginBgPeriodNumber);
            return bgPeriodList;
        }
        int type = BgNPeriodHelper.parserBgPeriodType((String)beginBgPeriodNumber);
        List<String> _tmpList = periodMap.get(beginBgPeriodNumber.split("\\.")[0] + "_" + type);
        if (_tmpList == null) {
            return bgPeriodList;
        }
        boolean include = false;
        String numbr = null;
        int size = _tmpList.size();
        for (int index = 0; index < size; ++index) {
            numbr = _tmpList.get(index);
            if (beginBgPeriodNumber.equals(numbr)) {
                include = true;
            }
            if (include) {
                bgPeriodList.add(numbr);
            }
            if (!endBgPeriodNumber.equals(numbr)) continue;
            include = false;
            break;
        }
        return bgPeriodList;
    }

    public static List<String> getRefPeriods(IDimensionParameter parameter) {
        ArrayList<String> refPeriods = new ArrayList<String>();
        com.kingdee.eas.ma.mbg.dimension.face.IDimension periodDim = parameter.getPeriodDimension();
        if (periodDim != null) {
            int in = periodDim.getDimensionMember().size();
            for (int i = 0; i < in; ++i) {
                if (refPeriods.contains(((IMember)periodDim.getDimensionMember().get(i)).getNumber())) continue;
                refPeriods.add(((IMember)periodDim.getDimensionMember().get(i)).getNumber());
            }
        }
        if (parameter.getQuerys() != null && !parameter.getQuerys().isEmpty()) {
            List querys = parameter.getQuerys();
            for (IQueryData queryData : querys) {
                Map mbgDimMap = queryData.getMbgDimMap();
                IDimension dimension = (IDimension)mbgDimMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                if (dimension == null) continue;
                List dimMembers = dimension.getMembers();
                int in = dimMembers.size();
                for (int i = 0; i < in; ++i) {
                    if (refPeriods.contains(((com.kingdee.eas.ma.mbg.cube.member.IMember)dimMembers.get(i)).getNumber())) continue;
                    refPeriods.add(((com.kingdee.eas.ma.mbg.cube.member.IMember)dimMembers.get(i)).getNumber());
                }
            }
        }
        return refPeriods;
    }
}

