/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.utils.data.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.execute.calc.face.ICalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcData;
import com.kingdee.eas.ma.biz.utils.data.face.IMbgDataFacade;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgActualRecordStateEnum;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgPastDataInfo;
import com.kingdee.eas.ma.mbg.BgPastRecordInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.MbgDataTempTableUtils;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.CubeConstants;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgParamUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgDataFacadeImpl
implements IMbgDataFacade {
    private static final Logger logger = Logger.getLogger(MbgDataFacadeImpl.class);
    private Context ctx = null;
    private Connection conn = null;
    private int valueType = 1;
    private BgSchemeInfo bgScheme = null;
    private BOSUuid orgUnitId = null;
    private BOSUuid bgTemplateId = null;
    private BOSUuid bgSchemeIntegrationId = null;
    private BOSUuid billId = null;
    private String editScen = null;
    private Set<String> filter = new HashSet<String>();
    private boolean isAdjust = false;
    private boolean isAudit = false;
    private boolean isOnlyEditState = false;
    private BgProcessEnum processType = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private TempTablePool pool = null;
    private List<ICalcData> calcDatas = new ArrayList<ICalcData>(1000);
    private List<ICalcData> divDatas = new ArrayList<ICalcData>();
    private Set<String> formulaSet = new HashSet<String>();
    private Map<String, BgScenarioInfo> bgScenarioMap = null;
    private int INDEX_ADDNEW = 0;
    private int INDEX_UPDATE = 1;
    private int INDEX_DELETE = 2;
    private BgSchemeAccIntHelper accIntHelper = null;
    private String cubeName = null;
    private String cubeEntryName = null;
    private IObjectValue model = null;
    private UserInfo user = null;

    @Override
    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public Context getCtx() {
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConn() throws SQLDataException {
        MbgDataFacadeImpl mbgDataFacadeImpl = this;
        synchronized (mbgDataFacadeImpl) {
            if (this.conn == null) {
                this.conn = BgDBUtils.getConnection((Context)this.getCtx());
            }
        }
        return this.conn;
    }

    @Override
    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    @Override
    public int getValueType() {
        return this.valueType;
    }

    public boolean isDecompose() {
        return DimensionCommonHelper.isDecompose((int)this.getValueType());
    }

    @Override
    public void setBgScheme(BgSchemeInfo bgScheme) {
        this.bgScheme = bgScheme;
    }

    @Override
    public BgSchemeInfo getBgScheme() {
        return this.bgScheme;
    }

    @Override
    public void setOrgUnitId(BOSUuid orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    @Override
    public BOSUuid getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setBgTemplateId(BOSUuid bgTemplateId) {
        this.bgTemplateId = bgTemplateId;
    }

    public BOSUuid getBgTemplateId() {
        return this.bgTemplateId;
    }

    public BOSUuid getBgSchemeIntegrationId() {
        return this.bgSchemeIntegrationId;
    }

    public void setBgSchemeIntegrationId(BOSUuid bgSchemeIntegrationId) {
        this.bgSchemeIntegrationId = bgSchemeIntegrationId;
    }

    @Override
    public void setBillId(BOSUuid billId) {
        this.billId = billId;
    }

    @Override
    public BOSUuid getBillId() {
        return this.billId;
    }

    @Override
    public void setEditScen(String editScen) {
        this.editScen = editScen;
    }

    @Override
    public String getEditScen() {
        return this.editScen;
    }

    protected Set<String> getFilter() {
        return this.filter;
    }

    @Override
    public void setAdjust(boolean isAdjust) {
        this.isAdjust = isAdjust;
    }

    @Override
    public boolean isAdjust() {
        return this.isAdjust;
    }

    @Override
    public boolean isAudit() {
        return this.isAudit;
    }

    @Override
    public void setAudit(boolean isAudit) {
        this.isAudit = isAudit;
    }

    public void setOnlyEditState(boolean isOnlyEditState) {
        this.isOnlyEditState = isOnlyEditState;
    }

    public boolean isOnlyEditState() {
        return this.isOnlyEditState;
    }

    @Override
    public BgProcessEnum getProcessType() {
        return this.processType;
    }

    @Override
    public void setProcessType(BgProcessEnum processType) {
        this.processType = processType;
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        if (this.schemeHelper == null) {
            try {
                this.schemeHelper = new BgSchemeDimensionHelper(this.getCtx(), this.getBgScheme().getId().toString());
            }
            catch (Exception ex) {
                logger.error((Object)"create SchemeHelper error:", (Throwable)ex);
                SysUtil.abort();
            }
        }
        return this.schemeHelper;
    }

    protected TempTablePool getPool() {
        if (this.pool == null) {
            this.pool = TempTablePool.getInstance((Context)this.getCtx());
        }
        return this.pool;
    }

    protected List<ICalcData> getCalcDatas() {
        return this.calcDatas;
    }

    protected List<ICalcData> getDivDatas() {
        return this.divDatas;
    }

    public Set<String> getFormulaSet() {
        if (this.formulaSet.isEmpty()) {
            for (ICalcData calcData : this.getCalcDatas()) {
                this.formulaSet.add(calcData.getFormula());
            }
        }
        return this.formulaSet;
    }

    @Override
    public void addMbgData(ICalcData calcData) {
        if (calcData != null) {
            this.getCalcDatas().add(calcData);
        }
    }

    @Override
    public void addMbgData(Collection<ICalcData> calcData) {
        if (calcData != null && !calcData.isEmpty()) {
            this.getCalcDatas().addAll(calcData);
        }
    }

    @Override
    public void save() throws BOSException, EASBizException {
        if (!this.verify()) {
            return;
        }
        Map<String, ICalcData>[] allObjs = null;
        try {
            allObjs = this.compareBgDataInfo();
            this.addNewData(allObjs[this.INDEX_ADDNEW]);
            this.updateData(allObjs[this.INDEX_UPDATE]);
            this.deleteData(allObjs[this.INDEX_DELETE]);
            this.updateDivData();
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (BOSException ex) {
            logger.error((Object)"MbgDataFacadeImpl save error:", (Throwable)ex);
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)"MbgDataFacadeImpl save error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)this.getConn());
        }
    }

    protected boolean verify() {
        if (this.getCalcDatas().isEmpty()) {
            return false;
        }
        return this.getOrgUnitId() != null && this.getBgScheme() != null;
    }

    protected Map<String, ICalcData>[] compareBgDataInfo() throws BOSException, EASBizException, SQLException {
        HashMap<String, ICalcData> newObjs = new HashMap<String, ICalcData>();
        HashMap<String, ICalcData> updObjs = new HashMap<String, ICalcData>();
        HashMap<String, ICalcData> delObjs = new HashMap<String, ICalcData>();
        HashMap[] allObjs = new HashMap[3];
        allObjs[this.INDEX_ADDNEW] = newObjs;
        allObjs[this.INDEX_UPDATE] = updObjs;
        allObjs[this.INDEX_DELETE] = delObjs;
        IMember member = null;
        ICalcData calcData = null;
        ICalcData oldData = null;
        String _orgUnitId = this.getOrgUnitId().toString();
        String orgUnitId = null;
        String _bgTemplateId = this.getBgTemplateId() != null ? this.getBgTemplateId().toString() : null;
        HashSet<String> orgUnitIds = new HashSet<String>();
        HashSet<String> formulas = new HashSet<String>(this.getCalcDatas().size());
        HashSet<String> versions = new HashSet<String>();
        int in = this.getCalcDatas().size();
        for (int i = 0; i < in; ++i) {
            calcData = this.getCalcDatas().get(i);
            if (StringUtils.isEmpty((String)calcData.getOrgUnitId())) {
                calcData.setOrgUnitId(_orgUnitId);
            }
            orgUnitIds.add(calcData.getOrgUnitId());
            formulas.add(calcData.getFormula());
            versions.add(calcData.getBgVersionNumber());
        }
        DimensionCacheHelper cacheHelper = new DimensionCacheHelper(this.ctx);
        cacheHelper.setMemberCacheHelper(new ViewListMemberCacheHelper());
        cacheHelper.getMemberCacheHelper().setCtx(this.getCtx());
        cacheHelper.getMemberCacheHelper().setSchemeHelper(this.getSchemeHelper());
        DimensionMemberCheckHelper helper = null;
        HashMap<String, DimensionMemberCheckHelper> checkHelpers = new HashMap<String, DimensionMemberCheckHelper>();
        for (String tmpOrgUnitId : orgUnitIds) {
            helper = DimensionMemberCheckHelper.getLocalIntance((Context)this.getCtx(), (DimensionCacheHelper)cacheHelper, (String)tmpOrgUnitId, (String)_bgTemplateId, (BgSchemeDimensionHelper)this.getSchemeHelper(), formulas, versions, (boolean)this.isDecompose());
            checkHelpers.put(tmpOrgUnitId, helper);
        }
        String keyStr = null;
        Map<String, ICalcData> dataMap = this.queryData();
        Map<String, ICalcData> schemeDataMap = this.querySchemeData(orgUnitIds);
        Map<String, IMember> versionMap = this.queryVersionData();
        boolean checkRemoveDataZero = BgParamUtils.removeDataSetZero((Context)this.ctx);
        int in2 = this.getCalcDatas().size();
        for (int i = 0; i < in2; ++i) {
            calcData = this.getCalcDatas().get(i);
            keyStr = calcData.getDimDataKey();
            oldData = dataMap.containsKey(keyStr) ? dataMap.get(keyStr) : (schemeDataMap.containsKey(keyStr) ? schemeDataMap.get(keyStr) : null);
            if (calcData.getValue() == null && oldData != null && (oldData.getState() == 9 || oldData.getState() == 11 || oldData.getState() == 13)) {
                calcData.setValue(BgNConstants.ZERO);
            }
            if (checkRemoveDataZero && calcData.getValue() == null && oldData != null && (oldData.getState() == 1 || oldData.getState() == 5 || oldData.getState() == 3)) {
                calcData.setValue(BgNConstants.ZERO);
            }
            if (calcData.getValue() == null) {
                if (oldData == null || oldData.getState() != 1 && oldData.getState() != 5 && oldData.getState() != 3) continue;
                if (oldData.getDataId() != null) {
                    calcData.setDataId(oldData.getDataId());
                }
                calcData.setState(oldData.getState());
                delObjs.put(keyStr, calcData);
                continue;
            }
            if (versionMap.containsKey(calcData.getBgVersionNumber())) {
                member = versionMap.get(calcData.getBgVersionNumber());
                if (!member.isLeaf()) {
                    calcData.setSaved(false);
                    continue;
                }
            } else {
                calcData.setSaved(false);
                continue;
            }
            orgUnitId = calcData.getOrgUnitId() != null ? calcData.getOrgUnitId() : _orgUnitId;
            helper = (DimensionMemberCheckHelper)checkHelpers.get(orgUnitId);
            if (helper != null && !helper.canSave(calcData.getFormula(), this.getEditScen(), null)) {
                calcData.setSaved(false);
                continue;
            }
            if (oldData != null) {
                if (this.isOnlyEditState() && oldData.getState() != 1) {
                    calcData.setSaved(false);
                    continue;
                }
                calcData.setDataId(oldData.getDataId());
                calcData.setState(oldData.getState());
                calcData.setOldValue(oldData.getValue());
            }
            if (oldData != null) {
                if (this.compareBgDataInfo(calcData, oldData)) continue;
                updObjs.put(keyStr, calcData);
                continue;
            }
            newObjs.put(keyStr, calcData);
        }
        return allObjs;
    }

    protected String getValueField() {
        return this.isAdjust() ? "FTmpValue" : "FValue";
    }

    protected Map<String, ICalcData> queryData() throws BOSException, EASBizException {
        HashMap<String, ICalcData> dataMap = new HashMap<String, ICalcData>();
        if (this.getBillId() == null) {
            return dataMap;
        }
        String keyStr = null;
        BizCalcData calcData = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer query = new StringBuffer();
        query.append("select t.FID, t.FOrgUnitId, t.FFormula, t.FVersion, t." + this.getValueField() + " AS FValue, t.FState from " + DimensionConstants.CUBE_NAME + " t where exists (select FDataId From " + this.getCubeEntryName() + " where FDataId = t.FID and FFormId = ?)");
        try {
            Set<String> cubes = this.getCubeName(null);
            for (String cubeName : cubes) {
                pstmt = this.getConn().prepareStatement(query.toString().replace(DimensionConstants.CUBE_NAME, cubeName));
                pstmt.setString(1, this.getBillId().toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    calcData = new BizCalcData();
                    calcData.setDataId(rst.getString("FID"));
                    calcData.setOrgUnitId(this.getAccIntHelper().convertStringForOrg(rst.getString("FOrgUnitId")));
                    calcData.setFormula(rst.getString("FFormula"));
                    calcData.setBgVersion(rst.getInt("FVersion"));
                    calcData.setValue(rst.getBigDecimal("FValue"));
                    calcData.setState(rst.getInt("FState"));
                    keyStr = calcData.getDimDataKey();
                    dataMap.put(keyStr, calcData);
                    this.getFormulaSet().add(calcData.getFormula());
                    this.getFilter().add(keyStr);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"queryData error", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt);
        }
        return dataMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, ICalcData> querySchemeData(Set<String> orgUnitIds) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        String tmpTableName;
        TempTablePool pool;
        HashMap<String, ICalcData> schemeDataMap;
        block23: {
            schemeDataMap = new HashMap<String, ICalcData>();
            if (BgDBUtils.isMSSQL((Context)this.ctx)) {
                return this.querySchemeDataByMSSQL(orgUnitIds);
            }
            ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(this.getCalcDatas().size());
            Object[] sqlParam = null;
            ICalcData calcData = null;
            String keyStr = null;
            HashSet<String> formulas = new HashSet<String>();
            int in = this.getCalcDatas().size();
            for (int i = 0; i < in; ++i) {
                calcData = this.getCalcDatas().get(i);
                keyStr = calcData.getDimDataKey();
                if (this.getFilter().contains(keyStr)) continue;
                sqlParam = new Object[2];
                formulas.add(calcData.getFormula());
                sqlParam[0] = calcData.getFormula();
                sqlParam[1] = calcData.getBgVersion();
                sqlParams.add(sqlParam);
            }
            pool = this.getPool();
            tmpTableName = null;
            String tmpOrgTableName = null;
            pstmt = null;
            rst = null;
            try {
                boolean isUseAccInt = BgSchemeConvertToAccIntUtils.isUseAccInt((BgSchemeInfo)this.getBgScheme(), (String)this.getCubeName());
                boolean isUseTmp = orgUnitIds.size() > 200;
                int oneBatchCount = 10;
                if (orgUnitIds.size() < 10) {
                    oneBatchCount = orgUnitIds.size();
                }
                StringBuffer orgSql = new StringBuffer();
                List<Object> paramList = new ArrayList();
                if (isUseTmp) {
                    tmpOrgTableName = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FIntId Int)");
                    this.getAccIntHelper().insertToTmpTable(this.conn, tmpOrgTableName, orgUnitIds, DimensionConstants.DEF_ORGUNIT_FIELD, true);
                    if (isUseAccInt) {
                        orgSql.append("select FIntID from " + tmpOrgTableName);
                        paramList.add(Integer.MIN_VALUE);
                    } else {
                        orgSql.append("select FID from " + tmpOrgTableName);
                        paramList.add("#");
                    }
                } else {
                    MbgSqlHelper.addPlaceHolder((StringBuffer)orgSql, (int)oneBatchCount);
                    paramList = MbgSqlHelper.getBatchParams(null, (Object[])orgUnitIds.toArray(), (int)oneBatchCount);
                }
                tmpTableName = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FFormula NVARCHAR(300), FVersion INT DEFAULT 0)");
                BgDBUtils.insertValue1((Connection)this.getConn(), (String)("INSERT INTO " + tmpTableName + "(FFormula, FVersion) VALUES (?,?) "), sqlParams);
                StringBuffer sql = new StringBuffer();
                sql.append("select /*+ index(BGDATA " + DimensionConstants.INDEX_NAME + ")*/ bgData.FID, bgData.FOrgUnitId, bgData.FFormula, bgData.FVersion, bgData." + this.getValueField() + " AS FValue, bgData.FState from " + DimensionConstants.CUBE_NAME + " bgData where bgData.FOrgUnitId IN (" + orgSql + ") and exists (select * from " + tmpTableName + " where FFormula = bgData.FFormula and FVersion = bgData.FVersion)");
                Set cubeNames = this.getAccIntHelper().getSplitTablesByFormula(formulas);
                for (String cube : cubeNames) {
                    pstmt = this.getConn().prepareStatement(sql.toString().replace(DimensionConstants.INDEX_NAME, cube.toUpperCase().replace("T_MBG_" + CubeConstants.BASE_REPLACE_KEY.toUpperCase(), "IX_MBG_BO")).replace(DimensionConstants.CUBE_NAME, cube));
                    for (int i = 0; i < paramList.size(); ++i) {
                        if (!isUseTmp) {
                            if (isUseAccInt) {
                                Object[] ps = (Object[])paramList.get(i);
                                for (int p = 0; p < ps.length; ++p) {
                                    this.getAccIntHelper().setParam(pstmt, p + 1, (String)ps[p], DimensionConstants.DEF_ORGUNIT_FIELD);
                                }
                            } else {
                                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i)));
                            }
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            calcData = new BizCalcData();
                            calcData.setDataId(rst.getString("FID"));
                            calcData.setOrgUnitId(this.getAccIntHelper().convertStringForOrg(rst.getString("FOrgUnitId")));
                            calcData.setFormula(rst.getString("FFormula"));
                            calcData.setBgVersion(rst.getInt("FVersion"));
                            calcData.setValue(rst.getBigDecimal("FValue"));
                            calcData.setState(rst.getInt("FState"));
                            schemeDataMap.put(calcData.getDimDataKey(), calcData);
                        }
                    }
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                }
                if (tmpOrgTableName == null) break block23;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"querySchemeData error:", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                    catch (Exception ex2) {
                        logger.error((Object)"querySchemeData error", (Throwable)ex2);
                        throw new BOSException((Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    if (tmpOrgTableName != null) {
                        pool.releaseTable(tmpOrgTableName);
                    }
                    if (tmpTableName != null) {
                        pool.releaseTable(tmpTableName);
                    }
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpOrgTableName);
        }
        if (tmpTableName != null) {
            pool.releaseTable(tmpTableName);
        }
        SQLUtils.cleanup(rst, pstmt);
        return schemeDataMap;
    }

    protected Map<String, ICalcData> querySchemeDataByMSSQL(Set<String> orgUnitIds) throws BOSException, EASBizException {
        HashMap<String, ICalcData> schemeDataMap = new HashMap();
        ICalcData calcData = null;
        String keyStr = null;
        BgVersionInfo version = null;
        Map versionMap = BgVersionHelper.getVersionObjMap((Context)this.ctx);
        HashSet<String> formulas = new HashSet<String>();
        int in = this.getCalcDatas().size();
        for (int i = 0; i < in; ++i) {
            calcData = this.getCalcDatas().get(i);
            keyStr = calcData.getDimDataKey();
            if (this.getFilter().contains(keyStr)) continue;
            version = (BgVersionInfo)versionMap.get(calcData.getBgVersionNumber());
            formulas.add(calcData.getFormula());
        }
        schemeDataMap = this.querySchemeData(this.ctx, this.getBgScheme(), orgUnitIds, formulas, version, this.getValueType(), null);
        return schemeDataMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, ICalcData> querySchemeData(Context ctx, BgSchemeInfo schemeInfo, Set<String> orgUnitIds, Collection<String> formulas, BgVersionInfo version, int valueType, MbgDataTempTableUtils utils) throws BOSException, EASBizException {
        Object rst;
        PreparedStatement pstmt;
        Connection conn;
        HashMap<String, ICalcData> schemeMap;
        block13: {
            schemeMap = new HashMap<String, ICalcData>();
            if (ctx == null) return schemeMap;
            if (schemeInfo == null) return schemeMap;
            if (orgUnitIds == null) return schemeMap;
            if (orgUnitIds.isEmpty()) return schemeMap;
            if (formulas == null) return schemeMap;
            if (formulas.isEmpty()) return schemeMap;
            if (version == null) {
                return schemeMap;
            }
            String cubeName = BgCubeUtils.getCubeName((String)schemeInfo.getRefCube(), (int)valueType);
            HashSet<String> bgPeriodNums = new HashSet<String>();
            HashSet<String> bgElementNums = new HashSet<String>();
            HashSet<String> currencyNums = new HashSet<String>();
            HashSet<String> bgScenarioNums = new HashSet<String>();
            HashSet<String> mbgMemSet = null;
            HashMap<String, HashSet<String>> dimMemMap = new HashMap<String, HashSet<String>>();
            ArrayList<String> tmpNums = new ArrayList<String>();
            String dimNumber2222222 = null;
            String srcNumber = null;
            String field = null;
            String tmpIndex = null;
            String tmpPeriod = null;
            String tmpElement = null;
            String tmpCurrency = null;
            String tmpScenario = null;
            Object tmpVersion = null;
            String tmpOrg = null;
            String[] tmpStrs = null;
            String[] params = null;
            StringBuffer sql = new StringBuffer();
            BizCalcData calcData = null;
            conn = null;
            pstmt = null;
            rst = null;
            if (utils == null) {
                utils = new MbgDataTempTableUtils(ctx);
            }
            MBgTemplateHelper.startLog((String)"Start querySchemeData");
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                HashMap<String, String> srcFieldMap = new HashMap<String, String>();
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FSrcNumber, FRefField from T_MBG_MbgDim");
                while (rst.next()) {
                    srcFieldMap.put(rst.getString("FSrcNumber"), rst.getString("FRefField"));
                }
                SQLUtils.cleanup((ResultSet)rst);
                srcFieldMap.put(DimensionBaseConstants.DEF_INDEX_SRCNUMBER, DimensionBaseConstants.DEF_BGINDEX_FIELD);
                MBgTemplateHelper.logTime((String)"End Query Src Map");
                for (String formula : formulas) {
                    params = BgNFSHelper.parseFormulaPara((String)formula);
                    for (String dimNumber2222222 : params[0].split(",")) {
                        srcNumber = DimUtils.getSrcNumber((String)dimNumber2222222);
                        field = (String)srcFieldMap.get(srcNumber);
                        mbgMemSet = (HashSet<String>)dimMemMap.get(field);
                        if (mbgMemSet == null) {
                            mbgMemSet = new HashSet<String>();
                            dimMemMap.put(field, mbgMemSet);
                        }
                        mbgMemSet.add(dimNumber2222222);
                    }
                    bgPeriodNums.add(params[1]);
                    bgElementNums.add(params[2]);
                    currencyNums.add(params[5]);
                    bgScenarioNums.add(params[3]);
                }
                TempTablePool pool = this.getPool();
                tmpOrg = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("INSERT INTO " + tmpOrg + "(FID) VALUES (?) "), orgUnitIds);
                tmpIndex = utils.getIndexTable();
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpIndex + " (FNumber) values (?)"), (Collection)((Collection)dimMemMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD)));
                tmpPeriod = utils.getPeriodTable();
                tmpNums.clear();
                tmpNums.addAll(bgPeriodNums);
                BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpPeriod + " (FID) select FID from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
                tmpElement = utils.getElementTable();
                tmpNums.clear();
                tmpNums.addAll(bgElementNums);
                BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpElement + " (FID) select FID from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
                tmpCurrency = utils.getCurrencyTable();
                tmpNums.clear();
                tmpNums.addAll(currencyNums);
                BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpCurrency + " (FID) select FID from T_BD_Currency where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
                tmpScenario = utils.getScenarioTable();
                tmpNums.clear();
                tmpNums.addAll(bgScenarioNums);
                BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpScenario + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpNums);
                MBgTemplateHelper.logTime((String)"End Build TempTable");
                sql.append("select /*+ index(BGDATA IX_MBG_BO" + this.getCubeName().substring(this.getCubeName().length() - 8) + ")*/ FID, FOrgUnitId, FFormula, FVersion, FValue, FState from " + cubeName + " where FOrgUnitId in   (select FID from " + tmpOrg + " where FID = " + cubeName + ".FOrgUnitId)  and exists (select FNumber from " + tmpIndex + " where FNumber = " + cubeName + ".F2)  and exists (select FID from " + tmpPeriod + " where FID = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + tmpElement + " where FID = " + cubeName + ".FBgElementID)  and exists (select FID from " + tmpCurrency + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + tmpScenario + " where FID = " + cubeName + ".FScenario)  and FVersion = ?");
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setInt(1, version.getVersionId());
                rst = pstmt.executeQuery();
                MBgTemplateHelper.logTime((String)"End Execute Query");
                while (rst.next()) {
                    calcData = new BizCalcData();
                    calcData.setDataId(rst.getString("FID"));
                    calcData.setOrgUnitId(rst.getString("FOrgUnitId"));
                    calcData.setFormula(rst.getString("FFormula"));
                    calcData.setBgVersion(rst.getInt("FVersion"));
                    calcData.setValue(rst.getBigDecimal("FValue"));
                    calcData.setState(rst.getInt("FState"));
                    schemeMap.put(calcData.getDimDataKey(), calcData);
                }
                MBgTemplateHelper.logTime((String)"End Get Result");
                if (tmpOrg == null) break block13;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"query DataState Error:", (Throwable)ex);
                    throw new BgFormException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    catch (Exception ex2) {
                        throw new BOSException((Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    if (tmpOrg != null) {
                        this.pool.releaseTable(tmpOrg);
                    }
                    utils.onRelease();
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            this.pool.releaseTable(tmpOrg);
        }
        utils.onRelease();
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return schemeMap;
    }

    protected Map<String, IMember> queryVersionData() throws BOSException, SQLException {
        return MbgDataHelper.getBgVersionMember((Connection)this.getConn(), (Locale)this.getCtx().getLocale());
    }

    public BgSchemeAccIntHelper getAccIntHelper() {
        if (this.accIntHelper == null) {
            this.accIntHelper = new BgSchemeAccIntHelper(this.getCtx(), this.getSchemeHelper(), this.getCubeName());
        }
        return this.accIntHelper;
    }

    public String getCubeName() {
        if (this.cubeName == null) {
            this.cubeName = BgCubeUtils.getCubeName((String)this.getBgScheme().getRefCube(), (int)this.getValueType());
        }
        return this.cubeName;
    }

    @Override
    public Set<String> getCubeName(Set<String> accNumbers) throws BOSException, EASBizException {
        boolean isUseAccInt = this.getAccIntHelper().isUseAccInt();
        return BgSchemeConvertToAccIntUtils.getSplitTablesByAcc((boolean)isUseAccInt, (String)this.getCubeName(), accNumbers, (Map)this.getAccIntHelper().getSplitMap());
    }

    @Override
    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    @Override
    public String getCubeEntryName() {
        if (this.cubeEntryName == null) {
            this.cubeEntryName = BgCubeUtils.getCubeEntryName((String)this.getBgScheme().getRefCube(), (int)this.getValueType());
        }
        return this.cubeEntryName;
    }

    @Override
    public void setCubeEntryName(String cubeEntryName) {
        this.cubeEntryName = cubeEntryName;
    }

    protected boolean compareBgDataInfo(ICalcData newData, ICalcData oldData) {
        if (newData == null || oldData == null || newData == oldData) {
            return true;
        }
        return newData.getValue().setScale(8, 4).compareTo(oldData.getValue()) == 0;
    }

    protected void addNewData(Map<String, ICalcData> calcMap) throws BOSException, EASBizException {
        boolean isDaliyActual;
        boolean bl = isDaliyActual = this.getValueType() == 16 || this.getValueType() == 32 || this.getValueType() == 2048;
        if (isDaliyActual) {
            this.addNewDataByDAC(calcMap);
        } else {
            this.addNewDataByBA(calcMap);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addNewDataByBA(Map<String, ICalcData> calcMap) throws BOSException, EASBizException {
        if (calcMap == null) return;
        if (calcMap.isEmpty()) {
            return;
        }
        ICalcData calcData2222 = null;
        HashSet<String> bgPeriod = new HashSet<String>();
        HashSet<String> bgElement = new HashSet<String>();
        HashSet<String> currency = new HashSet<String>();
        for (ICalcData calcData2222 : calcMap.values()) {
            bgPeriod.add(calcData2222.getBgPeriodNumber());
            bgElement.add(calcData2222.getBgElementNumber());
            currency.add(calcData2222.getCurrencyNumber());
        }
        List refFields = this.getBgScheme().getRefFields(this.getConn(), this.getValueType());
        int batchIndex = 0;
        int fixParam = 19;
        if (this.getBgSchemeIntegrationId() != null) {
            fixParam = 20;
        }
        String tableName = null;
        String entryName = null;
        String tmpId = null;
        String field = null;
        String srcNumber = null;
        String[] tmpStrs = null;
        BgScenarioInfo scenario = null;
        BgVersionInfo version = null;
        Timestamp _time = new Timestamp(System.currentTimeMillis());
        String _orgUnitId = this.getOrgUnitId().toString();
        String _userId = this.getCurrUser() != null ? this.getCurrUser().getId().toString() : null;
        String _billId = this.getBillId() != null ? this.getBillId().toString() : null;
        int state = this.getCurrDataState();
        boolean isBgForm = this.getBillId() != null && this.getBillId().getType().equals((Object)new BgFormInfo().getBOSType());
        HashMap valueMap = new HashMap();
        Map srcFields = DimUtils.getDimSourceMap((Connection)this.getConn(), (Locale)this.getCtx().getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TMP_Table_Name(FID VARCHAR(44) NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(300) DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
        int in = refFields.size();
        for (int i = 0; i < in; ++i) {
            sql.append((String)refFields.get(i) + " NVARCHAR(80) DEFAULT '' NOT NULL, ");
        }
        sql.append("FBgItemCombination NVARCHAR(300) DEFAULT '' NOT NULL, FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 1 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 0 NOT NULL,FDataSource NUMERIC(21,8)");
        if (this.getBgSchemeIntegrationId() != null) {
            sql.append(",FIntegrationId VARCHAR(44)");
        }
        sql.append(",FExists INT Default 0 NOT NULL");
        sql.append(")");
        PreparedStatement pstmt = null;
        PreparedStatement psten = null;
        TempTablePool pool = this.getPool();
        try {
            int i;
            Map bgPeriodMap = MbgDataHelper.getBgPeriodMap((Connection)this.getConn(), bgPeriod);
            Map bgElementMap = MbgDataHelper.getBgElementMap((Connection)this.getConn(), bgElement);
            Map currencyMap = MbgDataHelper.getCurrencyMap((Connection)this.getConn(), currency);
            this.bgScenarioMap = MbgDataHelper.getBgScenarioMap((Connection)this.getConn(), (Locale)this.getCtx().getLocale());
            Map bgVersionMap = MbgDataHelper.getBgVersionMap((Connection)this.getConn(), (Locale)this.getCtx().getLocale());
            tableName = pool.createTempTable(sql.toString());
            if (this.getBillId() != null) {
                entryName = pool.createTempTable("Create Table TMP_Table_Name1(FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL)");
            }
            sql = new StringBuffer();
            sql.append("Insert Into " + tableName + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate,FDataSource");
            if (this.getBgSchemeIntegrationId() != null) {
                sql.append(",FIntegrationId");
            }
            int in2 = refFields.size();
            for (i = 0; i < in2; ++i) {
                sql.append(", " + (String)refFields.get(i));
            }
            sql.append(") Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
            if (this.getBgSchemeIntegrationId() != null) {
                sql.append(",?");
            }
            in2 = refFields.size();
            for (i = 0; i < in2; ++i) {
                sql.append(",?");
            }
            sql.append(")");
            pstmt = this.getConn().prepareStatement(sql.toString());
            if (this.getBillId() != null && !StringUtils.isEmpty((String)entryName)) {
                psten = this.getConn().prepareStatement("Insert Into " + entryName + " (FFormID, FDataID) Values (?,?)");
            }
            boolean isUseAccInt = this.getAccIntHelper().isUseAccInt();
            Map splitCalcMap = this.getAccIntHelper().splitBgDatas(this.getConn(), calcMap, this.getFormulaSet());
            for (String bgDataTable : splitCalcMap.keySet()) {
                int i22;
                int in32;
                MbgSqlHelper.execute((Connection)this.getConn(), (String)("Delete FROM " + tableName));
                for (ICalcData calcData2222 : ((Map)splitCalcMap.get(bgDataTable)).values()) {
                    if (calcData2222.getValue() == null) continue;
                    valueMap.clear();
                    tmpStrs = calcData2222.getDimNumber().split(",");
                    if (tmpStrs != null) {
                        in32 = tmpStrs.length;
                        for (i22 = 0; i22 < in32; ++i22) {
                            srcNumber = DimUtils.getSrcNumber((String)tmpStrs[i22]);
                            if (!srcFields.containsKey(srcNumber)) continue;
                            valueMap.put(srcFields.get(srcNumber), tmpStrs[i22]);
                        }
                    }
                    pstmt.setString(1, calcData2222.createId());
                    pstmt.setString(2, _userId);
                    pstmt.setTimestamp(3, _time);
                    pstmt.setString(4, _userId);
                    pstmt.setTimestamp(5, _time);
                    this.getAccIntHelper().setParam(pstmt, 6, calcData2222.getOrgUnitId() != null ? calcData2222.getOrgUnitId() : _orgUnitId, DimensionConstants.DEF_ORGUNIT_FIELD);
                    pstmt.setString(7, calcData2222.getFormula());
                    if (this.isAdjust()) {
                        pstmt.setBigDecimal(8, BigDecimal.ZERO);
                        pstmt.setBigDecimal(9, calcData2222.getValue().setScale(8, 4));
                    } else {
                        pstmt.setBigDecimal(8, calcData2222.getValue().setScale(8, 4));
                        pstmt.setBigDecimal(9, calcData2222.getValue().setScale(8, 4));
                    }
                    pstmt.setString(10, calcData2222.getDimNumber());
                    tmpId = (String)bgPeriodMap.get(calcData2222.getBgPeriodNumber());
                    if (tmpId == null) {
                        logger.debug((Object)("bgPeriod number error:" + calcData2222.getBgPeriodNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{calcData2222.getBgPeriodNumber()});
                    }
                    this.getAccIntHelper().setParam(pstmt, 11, tmpId, DimensionConstants.DEF_PERIOD_FIELD);
                    tmpId = (String)bgElementMap.get(calcData2222.getBgElementNumber());
                    if (tmpId == null) {
                        logger.debug((Object)("bgElement number error:" + calcData2222.getBgElementNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOELEMENT, (Object[])new String[]{calcData2222.getBgElementNumber()});
                    }
                    this.getAccIntHelper().setParam(pstmt, 12, tmpId, DimensionConstants.DEF_ELEMENT_FIELD);
                    tmpId = (String)currencyMap.get(calcData2222.getCurrencyNumber());
                    if (tmpId == null) {
                        logger.debug((Object)("currency number error:" + calcData2222.getCurrencyNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOCURRENCY, (Object[])new String[]{calcData2222.getCurrencyNumber()});
                    }
                    pstmt.setString(13, tmpId);
                    scenario = this.bgScenarioMap.get(calcData2222.getBgScenarioNumber());
                    if (scenario == null) {
                        logger.debug((Object)("scenario number error:" + calcData2222.getBgScenarioNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOBGSCENARIO, (Object[])new String[]{calcData2222.getBgScenarioNumber()});
                    }
                    pstmt.setInt(14, scenario.getScenarioId());
                    version = (BgVersionInfo)bgVersionMap.get(calcData2222.getBgVersionNumber());
                    if (version == null) {
                        logger.debug((Object)("version number error:" + calcData2222.getBgVersionNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOBGVERSION, (Object[])new String[]{calcData2222.getBgVersionNumber()});
                    }
                    pstmt.setInt(15, version.getVersionId());
                    if (BgScenarioType.ActualData.equals((Object)scenario.getType()) && isBgForm) {
                        pstmt.setInt(16, 9);
                    } else {
                        pstmt.setInt(16, state);
                    }
                    pstmt.setInt(17, 1);
                    pstmt.setInt(18, calcData2222.getBgDataSource());
                    if (this.getBgSchemeIntegrationId() != null) {
                        pstmt.setString(19, this.getBgSchemeIntegrationId().toString());
                    }
                    in32 = refFields.size();
                    for (i22 = 0; i22 < in32; ++i22) {
                        field = (String)refFields.get(i22);
                        if (valueMap.containsKey(field)) {
                            this.getAccIntHelper().setParam(pstmt, fixParam + i22, (String)valueMap.get(field), field);
                            continue;
                        }
                        pstmt.setString(fixParam + i22, null);
                    }
                    pstmt.addBatch();
                    if (!(this.isAdjust() || state != 11 && state != 13 && state != 9 || 0 != scenario.getType().getValue())) {
                        this.getDivDatas().add(calcData2222);
                    }
                    if (psten != null && calcData2222.getOrgUnitId().equals(this.getOrgUnitId().toString())) {
                        psten.setString(1, _billId);
                        psten.setString(2, calcData2222.getDataId());
                        psten.addBatch();
                    }
                    if (++batchIndex < 50) continue;
                    pstmt.executeBatch();
                    if (psten != null) {
                        psten.executeBatch();
                    }
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                    if (psten != null) {
                        psten.executeBatch();
                    }
                }
                StringBuffer fields = new StringBuffer();
                fields.append("FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate,FDataSource");
                if (this.getBgSchemeIntegrationId() != null) {
                    fields.append(",FIntegrationId");
                }
                in32 = refFields.size();
                for (i22 = 0; i22 < in32; ++i22) {
                    fields.append(", " + (String)refFields.get(i22));
                }
                String insertAudit = "";
                String selectAudit = "";
                if (1 == this.getValueType() && (state == 9 || state == 11 || state == 13)) {
                    insertAudit = ",FAudOrgUnitID, FAudUserID, FDetail,FAudFormId";
                    selectAudit = ",FOrgUnitID, FLastUpdateUserID, 1,'" + _billId + "'";
                    if (state == 11 || state == 13) {
                        insertAudit = insertAudit + ",FReportOrgUnitID";
                        selectAudit = selectAudit + ",FOrgUnitID";
                    }
                }
                BgDBUtils.executeUpdate((Connection)this.getConn(), (String)("Update " + tableName + " t0 Set FExists = 1 Where exists (select FID from " + bgDataTable + " where FOrgUnitID = t0.FOrgUnitID and FFormula = t0.FFormula and FVersion = t0.FVersion)"));
                sql = new StringBuffer("Insert Into " + bgDataTable + "(" + fields + insertAudit + ") Select " + fields + selectAudit + " from " + tableName + " where FExists = 0");
                BgDBUtils.executeUpdate((Connection)this.getConn(), (String)sql.toString());
                if (entryName != null) {
                    BgDBUtils.executeUpdate((Connection)this.getConn(), (String)("Insert Into " + this.getCubeEntryName() + " (FFormID, FDataID) Select FFormID, FDataID from " + entryName));
                }
                if (!this.isAdjust()) continue;
                sql = new StringBuffer();
                sql.append("Insert Into T_MBG_BgTmpData (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FBgSchemeRootId, FOrgUnitID, FFormula, FValue, FOldValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState) ");
                sql.append("select FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, '" + this.getBgScheme().getId() + "', FOrgUnitID, FFormula, FTmpValue, FValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, " + 5 + " from " + tableName + " where not exists (select FID from T_MBG_BgTmpData where FOrgUnitID = " + tableName + ".FOrgUnitID and FFormula = " + tableName + ".FFormula and FVersion = " + tableName + ".FVersion)");
                BgDBUtils.executeUpdate((Connection)this.getConn(), (String)sql.toString());
                sql.setLength(0);
                sql.append("Insert Into T_MBG_BgTmpDataEntry (FFormID, FDataID) select ?, FID from " + tableName + " where not exists (select FDataID from T_MBG_BgTmpDataEntry where FFormID = ? and FDataID = " + tableName + ".FID)");
                BgDBUtils.executeUpdate((Connection)this.getConn(), (String)sql.toString(), (Object[])new Object[]{_billId, _billId});
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"addNewData error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(psten);
                if (pool == null) throw throwable;
                if (!StringUtils.isEmpty(entryName)) {
                    pool.releaseTable(entryName);
                }
                if (StringUtils.isEmpty(tableName)) throw throwable;
                pool.releaseTable(tableName);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)psten);
        if (pool == null) return;
        if (!StringUtils.isEmpty((String)entryName)) {
            pool.releaseTable(entryName);
        }
        if (StringUtils.isEmpty((String)tableName)) return;
        pool.releaseTable(tableName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addNewDataByDAC(Map<String, ICalcData> calcMap) throws BOSException, EASBizException {
        if (calcMap == null) return;
        if (calcMap.isEmpty()) {
            return;
        }
        ICalcData calcData2222 = null;
        HashSet<String> bgPeriod = new HashSet<String>();
        HashSet<String> bgElement = new HashSet<String>();
        HashSet<String> currency = new HashSet<String>();
        for (ICalcData calcData2222 : calcMap.values()) {
            bgPeriod.add(calcData2222.getBgPeriodNumber());
            bgElement.add(calcData2222.getBgElementNumber());
            currency.add(calcData2222.getCurrencyNumber());
        }
        List refFields = this.getBgScheme().getRefFields(this.getConn(), this.getValueType());
        int batchIndex = 0;
        int fixParam = 18;
        if (this.getBgSchemeIntegrationId() != null) {
            fixParam = 19;
        }
        String tableName = null;
        String entryName = null;
        String tmpId = null;
        String field = null;
        String srcNumber = null;
        String[] tmpStrs = null;
        BgScenarioInfo scenario = null;
        BgVersionInfo version = null;
        Timestamp _time = new Timestamp(System.currentTimeMillis());
        String _orgUnitId = this.getOrgUnitId().toString();
        String _userId = this.getCurrUser() != null ? this.getCurrUser().getId().toString() : null;
        String _billId = this.getBillId() != null ? this.getBillId().toString() : null;
        int state = this.getCurrDataState();
        HashMap valueMap = new HashMap();
        Map srcFields = DimUtils.getDimSourceMap((Connection)this.getConn(), (Locale)this.getCtx().getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TMP_Table_Name(FID VARCHAR(44) NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(300) DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
        int in = refFields.size();
        for (int i = 0; i < in; ++i) {
            sql.append((String)refFields.get(i) + " NVARCHAR(80) DEFAULT '' NOT NULL, ");
        }
        sql.append("FBgItemCombination NVARCHAR(300) DEFAULT '' NOT NULL, FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 1 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 0 NOT NULL,FDataSource NUMERIC(21,8)");
        if (this.getBgSchemeIntegrationId() != null) {
            sql.append(",FIntegrationId VARCHAR(44)");
        }
        sql.append(")");
        PreparedStatement pstmt = null;
        PreparedStatement psten = null;
        TempTablePool pool = this.getPool();
        try {
            int i;
            Map bgPeriodMap = MbgDataHelper.getBgPeriodMap((Connection)this.getConn(), bgPeriod);
            Map bgElementMap = MbgDataHelper.getBgElementMap((Connection)this.getConn(), bgElement);
            Map currencyMap = MbgDataHelper.getCurrencyMap((Connection)this.getConn(), currency);
            Map bgScenarioMap = MbgDataHelper.getBgScenarioMap((Connection)this.getConn(), (Locale)this.getCtx().getLocale());
            Map bgVersionMap = MbgDataHelper.getBgVersionMap((Connection)this.getConn(), (Locale)this.getCtx().getLocale());
            tableName = pool.createTempTable(sql.toString());
            if (this.getBillId() != null) {
                entryName = pool.createTempTable("Create Table TMP_Table_Name1(FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL)");
            }
            sql = new StringBuffer();
            sql.append("Insert Into " + tableName + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate, FDataSource");
            if (this.getBgSchemeIntegrationId() != null) {
                sql.append(",FIntegrationId");
            }
            int in2 = refFields.size();
            for (i = 0; i < in2; ++i) {
                sql.append(", " + (String)refFields.get(i));
            }
            sql.append(") Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
            if (this.getBgSchemeIntegrationId() != null) {
                sql.append(",?");
            }
            in2 = refFields.size();
            for (i = 0; i < in2; ++i) {
                sql.append(",?");
            }
            sql.append(")");
            pstmt = this.getConn().prepareStatement(sql.toString());
            if (this.getBillId() != null && !StringUtils.isEmpty((String)entryName)) {
                psten = this.getConn().prepareStatement("Insert Into " + entryName + " (FFormID, FDataID) Values (?,?)");
            }
            Map splitCalcMap = this.getAccIntHelper().splitBgDatas(this.getConn(), calcMap, this.getFormulaSet());
            for (String bgDataTable : splitCalcMap.keySet()) {
                int i22;
                int in32;
                MbgSqlHelper.execute((Connection)this.getConn(), (String)("Delete FROM " + tableName));
                for (ICalcData calcData2222 : ((Map)splitCalcMap.get(bgDataTable)).values()) {
                    if (calcData2222.getValue() == null) continue;
                    valueMap.clear();
                    tmpStrs = calcData2222.getDimNumber().split(",");
                    if (tmpStrs != null) {
                        in32 = tmpStrs.length;
                        for (i22 = 0; i22 < in32; ++i22) {
                            srcNumber = DimUtils.getSrcNumber((String)tmpStrs[i22]);
                            if (!srcFields.containsKey(srcNumber)) continue;
                            valueMap.put(srcFields.get(srcNumber), tmpStrs[i22]);
                        }
                    }
                    pstmt.setString(1, calcData2222.createId());
                    pstmt.setString(2, _userId);
                    pstmt.setTimestamp(3, _time);
                    pstmt.setString(4, _userId);
                    pstmt.setTimestamp(5, _time);
                    this.getAccIntHelper().setParam(pstmt, 6, calcData2222.getOrgUnitId() != null ? calcData2222.getOrgUnitId() : _orgUnitId, DimensionConstants.DEF_ORGUNIT_FIELD);
                    pstmt.setString(7, calcData2222.getFormula());
                    pstmt.setBigDecimal(8, calcData2222.getValue().setScale(8, 4));
                    pstmt.setString(9, calcData2222.getDimNumber());
                    tmpId = (String)bgPeriodMap.get(calcData2222.getBgPeriodNumber());
                    if (tmpId == null) {
                        logger.debug((Object)("bgPeriod number error:" + calcData2222.getBgPeriodNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOPERIOD, (Object[])new String[]{calcData2222.getBgPeriodNumber()});
                    }
                    this.getAccIntHelper().setParam(pstmt, 10, tmpId, DimensionConstants.DEF_PERIOD_FIELD);
                    tmpId = (String)bgElementMap.get(calcData2222.getBgElementNumber());
                    if (tmpId == null) {
                        logger.debug((Object)("bgElement number error:" + calcData2222.getBgElementNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOELEMENT, (Object[])new String[]{calcData2222.getBgElementNumber()});
                    }
                    this.getAccIntHelper().setParam(pstmt, 11, tmpId, DimensionConstants.DEF_ELEMENT_FIELD);
                    tmpId = (String)currencyMap.get(calcData2222.getCurrencyNumber());
                    if (tmpId == null) {
                        logger.debug((Object)("currency number error:" + calcData2222.getCurrencyNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOCURRENCY, (Object[])new String[]{calcData2222.getCurrencyNumber()});
                    }
                    pstmt.setString(12, tmpId);
                    scenario = (BgScenarioInfo)bgScenarioMap.get(calcData2222.getBgScenarioNumber());
                    if (scenario == null) {
                        logger.debug((Object)("scenario number error:" + calcData2222.getBgScenarioNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOBGSCENARIO, (Object[])new String[]{calcData2222.getBgScenarioNumber()});
                    }
                    pstmt.setInt(13, scenario.getScenarioId());
                    version = (BgVersionInfo)bgVersionMap.get(calcData2222.getBgVersionNumber());
                    if (version == null) {
                        logger.debug((Object)("version number error:" + calcData2222.getBgVersionNumber()));
                        throw new BgFormException(BgFormException.SUBMITNOBGVERSION, (Object[])new String[]{calcData2222.getBgVersionNumber()});
                    }
                    pstmt.setInt(14, version.getVersionId());
                    pstmt.setInt(15, state);
                    pstmt.setInt(16, 1);
                    pstmt.setInt(17, calcData2222.getBgDataSource());
                    if (this.getBgSchemeIntegrationId() != null) {
                        pstmt.setString(18, this.getBgSchemeIntegrationId().toString());
                    }
                    in32 = refFields.size();
                    for (i22 = 0; i22 < in32; ++i22) {
                        field = (String)refFields.get(i22);
                        if (valueMap.containsKey(field)) {
                            this.getAccIntHelper().setParam(pstmt, fixParam + i22, (String)valueMap.get(field), field);
                            continue;
                        }
                        pstmt.setString(fixParam + i22, null);
                    }
                    pstmt.addBatch();
                    if (psten != null) {
                        psten.setString(1, _billId);
                        psten.setString(2, calcData2222.getDataId());
                        psten.addBatch();
                    }
                    if (++batchIndex < 50) continue;
                    pstmt.executeBatch();
                    if (psten != null) {
                        psten.executeBatch();
                    }
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                    if (psten != null) {
                        psten.executeBatch();
                    }
                }
                StringBuffer fields = new StringBuffer();
                fields.append("FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate,FDataSource ");
                if (this.getBgSchemeIntegrationId() != null) {
                    fields.append(",FIntegrationId");
                }
                in32 = refFields.size();
                for (i22 = 0; i22 < in32; ++i22) {
                    fields.append(", " + (String)refFields.get(i22));
                }
                String insertAudit = "";
                String selectAudit = "";
                if (state == 9) {
                    insertAudit = ",FAudOrgUnitID, FAudUserID,FAudFormId";
                    selectAudit = ",FOrgUnitID, FLastUpdateUserID,'" + _billId + "'";
                }
                sql = new StringBuffer("Insert Into " + bgDataTable + "(").append(fields).append(insertAudit).append(") Select ").append(fields).append(selectAudit).append(" from " + tableName);
                BgDBUtils.executeUpdate((Connection)this.getConn(), (String)sql.toString());
                BgDBUtils.executeUpdate((Connection)this.getConn(), (String)("Insert Into " + this.getCubeEntryName() + " (FFormID, FDataID) Select FFormID, FDataID from " + entryName));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"addNewData error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(psten);
                if (pool == null) throw throwable;
                if (!StringUtils.isEmpty(entryName)) {
                    pool.releaseTable(entryName);
                }
                if (StringUtils.isEmpty(tableName)) throw throwable;
                pool.releaseTable(tableName);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)psten);
        if (pool == null) return;
        if (!StringUtils.isEmpty((String)entryName)) {
            pool.releaseTable(entryName);
        }
        if (StringUtils.isEmpty((String)tableName)) return;
        pool.releaseTable(tableName);
    }

    protected void updateData(Map<String, ICalcData> calcMap) throws BOSException, EASBizException {
        boolean isDaliyActual;
        boolean bl = isDaliyActual = this.getValueType() == 2048 || this.getValueType() == 16 || this.getValueType() == 32;
        if (isDaliyActual) {
            this.updateDataByDAC(calcMap);
        } else {
            this.updateDataByBA(calcMap);
        }
    }

    protected void updateDataByBA(Map<String, ICalcData> calcMap) throws BOSException, EASBizException {
        if (calcMap == null || calcMap.isEmpty()) {
            return;
        }
        Map splitCalcMap = this.getAccIntHelper().splitBgDatas(this.getConn(), calcMap, this.getFormulaSet());
        String entry = "Create Table TMP_Table_Name1(FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL)";
        ICalcData calcData2 = null;
        BgScenarioInfo scenario = null;
        int batchIndex = 0;
        String tmpEntryName = null;
        String _billId = this.getBillId() != null ? this.getBillId().toString() : null;
        String _orgUnitId = this.getOrgUnitId().toString();
        String _userId = this.getCurrUser() != null ? this.getCurrUser().getId().toString() : null;
        Timestamp _time = new Timestamp(System.currentTimeMillis());
        PreparedStatement pstmt = null;
        PreparedStatement psten = null;
        TempTablePool pool = this.getPool();
        try {
            if (this.bgScenarioMap == null) {
                this.bgScenarioMap = MbgDataHelper.getBgScenarioMap((Connection)this.getConn(), (Locale)this.getCtx().getLocale());
            }
            if (this.getBillId() != null) {
                tmpEntryName = pool.createTempTable(entry);
            }
            if (this.getBillId() != null && !StringUtils.isEmpty((String)tmpEntryName)) {
                psten = this.getConn().prepareStatement("Insert Into " + tmpEntryName + " (FFormID, FDataID) Values (?,?)");
            }
            for (String bgDataTable : splitCalcMap.keySet()) {
                if (this.getBillId() != null) {
                    MbgSqlHelper.execute((Connection)this.getConn(), (String)("Delete FROM " + tmpEntryName));
                }
                String sql = "Update " + bgDataTable + " Set FValue = ?, FTmpValue = ?, FLastUpdateUserId = ?, FlastUpdateTime = ?, FIsUpdate = 1 where FID = ?";
                if (this.isAdjust()) {
                    sql = "Update " + bgDataTable + " Set FTmpValue = ?, FLastUpdateUserId = ?, FlastUpdateTime = ?, FIsUpdate = 1 where FID = ?";
                }
                if (this.getBgSchemeIntegrationId() != null) {
                    sql = "Update " + bgDataTable + " Set FValue = ?, FTmpValue = ?, FLastUpdateUserId = ?, FlastUpdateTime = ?,FIntegrationId = ?, FIsUpdate = 1 where FID = ?";
                }
                pstmt = this.getConn().prepareStatement(sql);
                if (this.isAdjust()) {
                    for (ICalcData calcData2 : ((Map)splitCalcMap.get(bgDataTable)).values()) {
                        pstmt.setBigDecimal(1, calcData2.getValue());
                        pstmt.setString(2, _userId);
                        pstmt.setTimestamp(3, _time);
                        pstmt.setString(4, calcData2.getDataId());
                        pstmt.addBatch();
                        if (psten != null && _orgUnitId.equals(calcData2.getOrgUnitId())) {
                            psten.setString(1, _billId);
                            psten.setString(2, calcData2.getDataId());
                            psten.addBatch();
                        }
                        if (++batchIndex < 50) continue;
                        pstmt.executeBatch();
                        if (psten != null) {
                            psten.executeBatch();
                        }
                        batchIndex = 0;
                    }
                } else {
                    for (ICalcData calcData2 : ((Map)splitCalcMap.get(bgDataTable)).values()) {
                        if (this.getBgSchemeIntegrationId() != null) {
                            pstmt.setBigDecimal(1, calcData2.getValue());
                            pstmt.setBigDecimal(2, calcData2.getValue());
                            pstmt.setString(3, _userId);
                            pstmt.setTimestamp(4, _time);
                            pstmt.setString(5, this.getBgSchemeIntegrationId().toString());
                            pstmt.setString(6, calcData2.getDataId());
                        } else {
                            pstmt.setBigDecimal(1, calcData2.getValue());
                            pstmt.setBigDecimal(2, calcData2.getValue());
                            pstmt.setString(3, _userId);
                            pstmt.setTimestamp(4, _time);
                            pstmt.setString(5, calcData2.getDataId());
                        }
                        pstmt.addBatch();
                        scenario = this.bgScenarioMap.get(calcData2.getBgScenarioNumber());
                        if ((calcData2.getState() == 11 | calcData2.getState() == 13 || calcData2.getState() == 9) && 0 == scenario.getType().getValue()) {
                            this.getDivDatas().add(calcData2);
                        }
                        if (psten != null && _orgUnitId.equals(calcData2.getOrgUnitId())) {
                            psten.setString(1, _billId);
                            psten.setString(2, calcData2.getDataId());
                            psten.addBatch();
                        }
                        if (++batchIndex < 50) continue;
                        pstmt.executeBatch();
                        if (psten != null) {
                            psten.executeBatch();
                        }
                        batchIndex = 0;
                    }
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                    if (psten != null) {
                        psten.executeBatch();
                    }
                }
                if (this.getBillId() != null) {
                    BgDBUtils.executeUpdate((Connection)this.getConn(), (String)("Insert Into " + this.getCubeEntryName() + " (FFormID, FDataID) Select FFormID, FDataID from " + tmpEntryName + " where NOT EXISTS (Select FDataID From " + this.getCubeEntryName() + " Where FFormID = ? And FDataID = " + tmpEntryName + ".FDataID)"), (Object[])new Object[]{_billId});
                }
                if (this.isAdjust()) {
                    StringBuffer tmpSql = new StringBuffer();
                    tmpSql.append("update T_MBG_BgTmpData set FValue = (select FTmpValue from " + bgDataTable + " where FOrgUnitId = T_MBG_BgTmpData.FOrgUnitId and FFormula = T_MBG_BgTmpData.FFormula and FVersion = T_MBG_BgTmpData.FVersion) where FID IN (select FDataID from " + tmpEntryName + ")");
                    BgDBUtils.executeUpdate((Connection)this.getConn(), (String)tmpSql.toString());
                    tmpSql.setLength(0);
                    tmpSql.append("Insert Into T_MBG_BgTmpData (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FBgSchemeRootId, FOrgUnitID, FFormula, FValue, FOldValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FProcessType) ");
                    tmpSql.append("select FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, '" + this.getBgScheme().getId() + "', FOrgUnitID, FFormula, FTmpValue, FValue,FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, " + 5 + "," + this.getProcessType().getValue() + " from " + bgDataTable + " where FID IN (select FDataID from " + tmpEntryName + ") and not exists (select FID from T_MBG_BgTmpData where FOrgUnitID = " + bgDataTable + ".FOrgUnitID and FFormula = " + bgDataTable + ".FFormula and FVersion = " + bgDataTable + ".FVersion)");
                    BgDBUtils.executeUpdate((Connection)this.getConn(), (String)tmpSql.toString());
                    tmpSql.setLength(0);
                    tmpSql.append("Insert Into T_MBG_BgTmpDataEntry (FFormID, FDataID) Select FFormID, FDataID from " + tmpEntryName + " where NOT EXISTS (Select FDataID From T_MBG_BgTmpDataEntry Where FFormID = " + tmpEntryName + ".FFormID And FDataID = " + tmpEntryName + ".FDataID) ");
                    BgDBUtils.executeUpdate((Connection)this.getConn(), (String)tmpSql.toString());
                }
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"updateData error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(pstmt);
            SQLUtils.cleanup(psten);
            if (pool != null && tmpEntryName != null) {
                pool.releaseTable(tmpEntryName);
            }
        }
    }

    protected void updateDataByDAC(Map<String, ICalcData> calcMap) throws BOSException, EASBizException {
        if (calcMap == null || calcMap.isEmpty()) {
            return;
        }
        boolean isAddIntegrationId = this.getCtx().get((Object)"INTEGRATION_ID") != null;
        Map splitCalcMap = this.getAccIntHelper().splitBgDatas(this.getConn(), calcMap, this.getFormulaSet());
        String entry = "Create Table TMP_Table_Name1(FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL)";
        ICalcData calcData2 = null;
        int batchIndex = 0;
        String tmpEntryName = null;
        String _billId = this.getBillId() != null ? this.getBillId().toString() : null;
        String _orgUnitId = this.getOrgUnitId().toString();
        String _userId = this.getCurrUser() != null ? this.getCurrUser().getId().toString() : null;
        Timestamp _time = new Timestamp(System.currentTimeMillis());
        PreparedStatement pstmt = null;
        PreparedStatement psten = null;
        TempTablePool pool = this.getPool();
        try {
            if (this.getBillId() != null) {
                tmpEntryName = pool.createTempTable(entry);
            }
            if (this.getBillId() != null && !StringUtils.isEmpty((String)tmpEntryName)) {
                psten = this.getConn().prepareStatement("Insert Into " + tmpEntryName + " (FFormID, FDataID) Values (?,?)");
            }
            for (String bgDataTable : splitCalcMap.keySet()) {
                MbgSqlHelper.execute((Connection)this.getConn(), (String)("Delete FROM " + tmpEntryName));
                String sql = "Update " + bgDataTable + " Set FValue = ?, FLastUpdateUserId = ?, FlastUpdateTime = ?, FIsUpdate = 1 where FID = ?";
                if (this.getBgSchemeIntegrationId() != null) {
                    sql = "Update " + bgDataTable + " Set FValue = ?, FLastUpdateUserId = ?, FlastUpdateTime = ?,FIntegrationId = ?,FIsUpdate = 1 where FID = ?";
                }
                pstmt = this.getConn().prepareStatement(sql.toString());
                for (ICalcData calcData2 : ((Map)splitCalcMap.get(bgDataTable)).values()) {
                    if (isAddIntegrationId) {
                        pstmt.setBigDecimal(1, calcData2.getValue());
                        pstmt.setString(2, _userId);
                        pstmt.setTimestamp(3, _time);
                        pstmt.setString(4, this.getBgSchemeIntegrationId().toString());
                        pstmt.setString(5, calcData2.getDataId());
                    } else {
                        pstmt.setBigDecimal(1, calcData2.getValue());
                        pstmt.setString(2, _userId);
                        pstmt.setTimestamp(3, _time);
                        pstmt.setString(4, calcData2.getDataId());
                    }
                    pstmt.addBatch();
                    if (psten != null && _orgUnitId.equals(calcData2.getOrgUnitId())) {
                        psten.setString(1, _billId);
                        psten.setString(2, calcData2.getDataId());
                        psten.addBatch();
                    }
                    if (++batchIndex < 50) continue;
                    pstmt.executeBatch();
                    if (psten != null) {
                        psten.executeBatch();
                    }
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                    if (psten != null) {
                        psten.executeBatch();
                    }
                }
                if (this.getBillId() == null) continue;
                BgDBUtils.executeUpdate((Connection)this.getConn(), (String)("Insert Into " + this.getCubeEntryName() + " (FFormID, FDataID) Select FFormID, FDataID from " + tmpEntryName + " where NOT EXISTS (Select FDataID From " + this.getCubeEntryName() + " Where FFormID = ? And FDataID = " + tmpEntryName + ".FDataID)"), (Object[])new Object[]{_billId});
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"updateData error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(pstmt);
            SQLUtils.cleanup(psten);
            if (pool != null && tmpEntryName != null) {
                pool.releaseTable(tmpEntryName);
            }
        }
    }

    protected void deleteData(Map<String, ICalcData> calcMap) throws BOSException, EASBizException {
        if (calcMap == null || calcMap.isEmpty()) {
            return;
        }
        Map splitCalcMap = this.getAccIntHelper().splitBgDatas(this.getConn(), calcMap, this.getFormulaSet());
        ICalcData calcData2 = null;
        ArrayList<String> dataIds = new ArrayList<String>();
        ArrayList<String> tmpDataIds = new ArrayList<String>();
        String tableName = null;
        Statement pstmt = null;
        TempTablePool pool = this.getPool();
        try {
            tableName = pool.createTempTable("Create Table TEML_KSQL_0(FID VARCHAR(44))");
            if (!StringUtils.isEmpty((String)tableName)) {
                for (String bgDataTable : splitCalcMap.keySet()) {
                    MbgSqlHelper.execute((Connection)this.getConn(), (String)("Delete FROM " + tableName));
                    dataIds.clear();
                    for (ICalcData calcData2 : ((Map)splitCalcMap.get(bgDataTable)).values()) {
                        if (calcData2.getState() == 1 || calcData2.getState() == 3) {
                            dataIds.add(calcData2.getDataId());
                            continue;
                        }
                        if (calcData2.getState() != 5) continue;
                        dataIds.add(calcData2.getDataId());
                        tmpDataIds.add(calcData2.getDataId());
                    }
                    BgDBUtils.insertKey((Connection)this.getConn(), (String)("Insert into " + tableName + " (FID) Values (?)"), dataIds);
                    if (this.getBillId() != null) {
                        BgDBUtils.executeUpdate((Connection)this.getConn(), (String)("delete from " + this.getCubeEntryName() + " where exists (select FID from " + tableName + " where FID = " + this.getCubeEntryName() + ".FDataId)"));
                    }
                    BgDBUtils.executeUpdate((Connection)this.getConn(), (String)("delete from " + bgDataTable + " where exists (select FID from " + tableName + " where FID = " + bgDataTable + ".FID) and FState IN (" + 1 + ", " + 5 + ", " + 3 + ")"));
                }
                if (tmpDataIds.isEmpty()) {
                    return;
                }
                BgDBUtils.executeUpdate((Connection)this.getConn(), (String)("Delete From " + tableName));
                BgDBUtils.insertKey((Connection)this.getConn(), (String)("Insert into " + tableName + " (FID) Values (?)"), tmpDataIds);
                if (this.getBillId() != null) {
                    BgDBUtils.executeUpdate((Connection)this.getConn(), (String)("delete from T_Mbg_BgTmpDataEntry where exists (select FID from " + tableName + " where FID = T_Mbg_BgTmpDataEntry.FDataId)"));
                }
                BgDBUtils.executeUpdate((Connection)this.getConn(), (String)("delete from T_Mbg_BgTmpData where exists (select FID from " + tableName + " where FID = T_Mbg_BgTmpData.FID) and FState = " + 5));
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"deleteData error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(pstmt);
            if (pool != null && tableName != null) {
                pool.releaseTable(tableName);
            }
        }
    }

    protected void setModel(IObjectValue model) {
        this.model = model;
    }

    protected IObjectValue getModel() {
        return this.model;
    }

    protected UserInfo getCurrUser() {
        if (this.user == null) {
            this.user = ContextUtil.getCurrentUserInfo((Context)this.getCtx());
            if (this.user == null) {
                this.user = new UserInfo();
                this.user.setId(BOSUuid.read((String)"256c221a-0106-1000-e000-10d7c0a813f413B7DE7F"));
            }
        }
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCurrDataState() {
        int state = 1;
        if (this.isAudit()) {
            state = 9;
        } else if (this.isAdjust()) {
            state = 5;
        } else if (this.getBillId() != null) {
            if (this.getModel() == null) {
                String sql = null;
                BOSObjectType type = this.getBillId().getType();
                BgFormInfo bgForm = new BgFormInfo();
                BOSObjectType bgType = bgForm.getBOSType();
                BgActualRecordInfo acRecord = new BgActualRecordInfo();
                BOSObjectType acType = acRecord.getBOSType();
                if (type.equals((Object)bgType)) {
                    sql = "select FID, FState from T_MBG_BgForm where FID = ?";
                } else if (type.equals((Object)acType)) {
                    sql = "select FID, FState from T_MBG_BgActualRecord where FID = ?";
                }
                if (!StringUtils.isEmpty((String)sql)) {
                    IRowSet rst = null;
                    try {
                        rst = BgDBUtils.executeQuery((Connection)this.getConn(), (String)sql, (Object[])new Object[]{this.getBillId().toString()});
                        if (rst.next()) {
                            if (type.equals((Object)bgType)) {
                                this.setModel((IObjectValue)bgForm);
                                bgForm.setId(BOSUuid.read((String)rst.getString("FID")));
                                bgForm.setState(BgFormStateEnum.getEnum((int)rst.getInt("FState")));
                            } else if (type.equals((Object)acType)) {
                                this.setModel((IObjectValue)acRecord);
                                acRecord.setId(BOSUuid.read((String)rst.getString("FID")));
                                acRecord.setState(BgActualRecordStateEnum.getEnum((int)rst.getInt("FState")));
                            }
                            state = this.getModel().getInt("state");
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"query model state error:", (Throwable)ex);
                    }
                    finally {
                        SQLUtils.cleanup(rst);
                    }
                }
            }
            state = state == 2 ? 9 : (state == 50 ? 11 : (state == 51 ? 13 : 1));
        }
        return state;
    }

    protected void updateDivData() throws BOSException, EASBizException {
        if (this.getBillId() == null || this.getDivDatas().isEmpty()) {
            return;
        }
        int batchIndex = 0;
        String bgRecordId = BOSUuid.create((BOSObjectType)new BgPastRecordInfo().getBOSType()).toString();
        BgPastDataInfo pastData = new BgPastDataInfo();
        String _billId = this.getBillId().toString();
        String _userId = this.getCurrUser() != null ? this.getCurrUser().getId().toString() : null;
        Timestamp _time = new Timestamp(System.currentTimeMillis());
        BigDecimal oldValue = null;
        BigDecimal divValue = null;
        boolean hasDivData = false;
        for (ICalcData divData : this.getDivDatas()) {
            BigDecimal bigDecimal = oldValue = divData.getOldValue() != null ? divData.getOldValue() : BgNConstants.ZERO;
            if (divData.getValue().setScale(8, 4).compareTo(oldValue) == 0) continue;
            hasDivData = true;
            break;
        }
        if (!hasDivData) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into T_MBG_BgPastRecord (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FSeq, FPastSource, FBgFormID, FVersionNo) Values (?,?,?,?,?,?,?,?,?,?)");
        PreparedStatement pstmt = null;
        try {
            Set actScenario = BgScenarioHelper.getAcScenarioNumbers((Context)this.getCtx());
            pstmt = this.getConn().prepareStatement(sql.toString());
            pstmt.setString(1, bgRecordId);
            pstmt.setString(2, _userId);
            pstmt.setTimestamp(3, _time);
            pstmt.setString(4, _userId);
            pstmt.setTimestamp(5, _time);
            pstmt.setString(6, null);
            pstmt.setInt(7, 0);
            pstmt.setInt(8, 12);
            pstmt.setString(9, _billId);
            pstmt.setBigDecimal(10, BgNConstants.ONE);
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            sql = new StringBuffer();
            sql.append("Insert Into T_MBG_BgPastData (FID, FPastValue, FBalance, FAdjValue, FPastRecordID, FFormula, FBgDataID, FAdjustorId, FAdjustTime) Values (?,?,?,?,?,?,?,?,?)");
            pstmt = this.getConn().prepareStatement(sql.toString());
            for (ICalcData divData : this.getDivDatas()) {
                if (actScenario.contains(divData.getBgScenarioNumber())) continue;
                oldValue = divData.getOldValue() != null ? divData.getOldValue() : BgNConstants.ZERO;
                divValue = divData.getValue().subtract(oldValue);
                if (divData.getValue().setScale(8, 4).compareTo(oldValue) == 0) continue;
                pstmt.setString(1, BOSUuid.create((BOSObjectType)pastData.getBOSType()).toString());
                pstmt.setBigDecimal(2, divValue);
                pstmt.setBigDecimal(3, oldValue);
                pstmt.setBigDecimal(4, divData.getValue());
                pstmt.setString(5, bgRecordId);
                pstmt.setString(6, divData.getFormula());
                pstmt.setString(7, divData.getDataId());
                pstmt.setString(8, _userId);
                pstmt.setTimestamp(9, _time);
                pstmt.addBatch();
                if (++batchIndex < 50) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"deleteData error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }
}

