/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgDataFactory;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgDataStateEnum;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgData;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeFacadeFactory;
import com.kingdee.eas.ma.view.BgDataEntryFactory;
import com.kingdee.eas.ma.view.BgDataEntryInfo;
import com.kingdee.eas.ma.view.IBgDataEntry;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgDataSynStateBizHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgDataSynStateBizHelper.class);
    public static final String OPERATOR_BACK_PLAN = "OPERATOR_BACK_PLAN";
    public static final String OPERATOR_BASISAPPROVED = "OPERATOR_BASISAPPROVED";
    public static final String OPERATOR_APPROVED = "OPERATOR_APPROVED";
    public static final String OPERATOT_UNAPPROVED = "OPERATOT_UNAPPROVED";
    public static final String OPERATOT_REPORT = "OPERATOT_REPORT";
    public static final String OPERATOT_BACK = "OPERATOT_BACK";
    public static final String OPERATOT_ADJUST = "OPERATOT_ADJUST";
    public static final String OPERATOT_APPROVING = "OPERATOT_APPROVING";
    public static final String OPERATOT_SUBMIT = "OPERATOT_SUBMIT";
    public static final String OPERATOT_SAVEBUDGET = "OPERATOT_SAVEBUDGET";
    private static int MAX_BATCH_COUNT = 100;

    public static ICoreBase getBgDataUpdateInterface(Context ctx) throws BOSException {
        if (null != ctx) {
            return BgDataFactory.getLocalInstance(ctx);
        }
        return BgDataFactory.getRemoteInstance();
    }

    public static ICoreBase getBgDataEntryInterface(Context ctx) throws BOSException {
        if (null != ctx) {
            return BgDataEntryFactory.getLocalInstance((Context)ctx);
        }
        return BgDataEntryFactory.getRemoteInstance();
    }

    protected static SelectorItemCollection getUpdateSelector() {
        SelectorItemCollection sels = new SelectorItemCollection();
        sels.add("id");
        sels.add("dataState");
        return sels;
    }

    public static SelectorItemCollection getValueUpdaeSelector() {
        SelectorItemCollection sels = new SelectorItemCollection();
        sels.add("id");
        sels.add("bgValue");
        sels.add("formula");
        sels.add("orgUnit.id");
        sels.add("bgScheme.rootId");
        return sels;
    }

    public static void updateDataStateBatchByFromIdSet(Context ctx, Collection ids, boolean updFlag, String operator) throws EASBizException, BOSException, SQLException {
        BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet(ctx, ids, null, updFlag, operator);
    }

    public static void updateDataStateByFormID(Context ctx, String bgFormId, boolean updFlag, String operator) throws EASBizException, BOSException, SQLException {
        if (ctx == null || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        ArrayList<String> bgFormIds = new ArrayList<String>();
        bgFormIds.add(bgFormId);
        BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet(ctx, bgFormIds, updFlag, operator);
    }

    public static void updateDataStateBatchByFromIdSet(Context ctx, Collection ids, BgDataStateEnum bgDataState, boolean updFlag, String operator) throws EASBizException, BOSException, SQLException {
        if (ids == null) {
            return;
        }
        if (ctx == null) {
            return;
        }
        BgBillIntegrateSchemeFacadeFactory.getLocalInstance((Context)ctx).synBillState(ids, operator);
        Connection conn = null;
        PreparedStatement pstmt = null;
        int index = 0;
        try {
            conn = BgDataSynStateBizHelper.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgData set FDataState = ? where FID = ?");
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                BgFormInfo bgForm = new BgFormInfo();
                bgForm.setId(BOSUuid.read((String)it.next().toString()));
                CoreBaseCollection dataState = null;
                bgForm = BgDataSynStateBizHelper.getBgFormInfo(ctx, bgForm.getId(), true, false);
                if (bgDataState == null) {
                    bgDataState = BgDataSynStateBizHelper.getDataStateByFormState(bgForm.getState());
                }
                if ((dataState = BgDataSynStateBizHelper.getBgDataMapByBgForm(ctx, bgForm, BgDataSynStateBizHelper.getUpdateSelector())) == null) continue;
                for (BgDataInfo tempData : dataState) {
                    if (!BgDataSynStateBizHelper.comparDataState(bgDataState, tempData.getDataState(), updFlag)) continue;
                    pstmt.setInt(1, bgDataState.getValue());
                    pstmt.setString(2, tempData.getId().toString());
                    pstmt.addBatch();
                    if (200 >= ++index) continue;
                    pstmt.executeBatch();
                    pstmt.clearBatch();
                    index = 0;
                }
            }
            if (index > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static BgDataStateEnum getDataStateByFormState(BgFormStateEnum bgFormState) {
        if (bgFormState == null) {
            return null;
        }
        if (BgFormStateEnum.Edited.equals((Object)bgFormState)) {
            return BgDataStateEnum.Edited;
        }
        if (BgFormStateEnum.Approved.equals((Object)bgFormState)) {
            return BgDataStateEnum.Approved;
        }
        if (BgFormStateEnum.BasisApproved.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Adjusted.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Cancelled.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Approving.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.History.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Collect.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.REFERRING.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Decomposer.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Report.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Certificate.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.Back.equals((Object)bgFormState)) {
            return BgDataStateEnum.Edited;
        }
        if (BgFormStateEnum.PeriodAdjusted.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.UnReport.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        if (BgFormStateEnum.CANTEDIT.equals((Object)bgFormState)) {
            return BgDataStateEnum.Edited;
        }
        if (!BgFormStateEnum.UnCertificate.equals((Object)bgFormState) && !BgFormStateEnum.Count.equals((Object)bgFormState) && BgFormStateEnum.AdjustApproving.equals((Object)bgFormState)) {
            return BgDataStateEnum.UnEditeable;
        }
        return null;
    }

    public static void updateDataState(Context ctx, BgDataInfo bgData, SelectorItemCollection sels) throws EASBizException, BOSException {
        BgDataSynStateBizHelper.getBgDataUpdateInterface(ctx).updatePartial((CoreBaseInfo)bgData, sels);
    }

    protected static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            logger.warn((Object)sqle.getMessage());
            throw new SQLDataException(sqle);
        }
    }

    public static boolean updateDataState(Context ctx, String id, String dataState) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        if (conn != null) {
            block5: {
                boolean bl;
                try {
                    conn = BgDataSynStateBizHelper.getConnection(ctx);
                    pstmt = conn.prepareStatement("update T_BG_BgData set FDataState = ? where FID = ?");
                    pstmt.setString(1, dataState);
                    pstmt.setString(2, id);
                    int sum = -1;
                    sum = pstmt.executeUpdate();
                    if (sum <= 0) break block5;
                    bl = true;
                }
                catch (SQLException e) {
                    try {
                        logger.warn((Object)e.getMessage());
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
                return bl;
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        return false;
    }

    public static void updateDataStateBatch(Context ctx, CoreBaseCollection cols) throws EASBizException, BOSException {
        if (cols == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int index = 0;
        try {
            conn = BgDataSynStateBizHelper.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgData set FDataState = ? where FID = ?");
            Iterator it = cols.iterator();
            while (it.hasNext()) {
                if (conn == null) continue;
                BgDataInfo tempData = (BgDataInfo)it.next();
                pstmt.setInt(1, tempData.getDataState().getValue());
                pstmt.setString(2, tempData.getId().toString());
                pstmt.addBatch();
                if (MAX_BATCH_COUNT >= ++index) continue;
                pstmt.executeBatch();
                pstmt.clearBatch();
                index = 0;
            }
            if (index > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected static boolean comparDataState(BgDataStateEnum updateDataState, BgDataStateEnum oriDataState, boolean updFlag) {
        if (updateDataState == null) {
            return false;
        }
        if (oriDataState == null) {
            return true;
        }
        if (updateDataState.equals((Object)oriDataState) || updateDataState.getValue() == oriDataState.getValue()) {
            return false;
        }
        return updFlag ? updateDataState.getValue() > oriDataState.getValue() : updateDataState.getValue() < oriDataState.getValue();
    }

    public static CoreBaseCollection getFilterUpdBgDataCol(CoreBaseCollection cols, BgDataStateEnum bgDataState, boolean updFlag) {
        CoreBaseCollection temp = new CoreBaseCollection();
        for (BgDataInfo tempInfo : cols) {
            if (tempInfo.getDataState() == null || !BgDataSynStateBizHelper.comparDataState(bgDataState, tempInfo.getDataState(), updFlag)) continue;
            tempInfo.setDataState(bgDataState);
            temp.add((CoreBaseInfo)tempInfo);
        }
        return temp;
    }

    public static void updateDataStateByFormID(Context ctx, String formID, BgDataStateEnum bgDataState, boolean updFlag) throws EASBizException, BOSException, SQLException {
        if (ctx == null) {
            return;
        }
        if (formID == null) {
            return;
        }
        BgFormInfo bgForm = new BgFormInfo();
        bgForm.setId(BOSUuid.read((String)formID));
        CoreBaseCollection dataState = null;
        bgForm = BgDataSynStateBizHelper.getBgFormInfo(ctx, bgForm.getId(), true, false);
        dataState = BgDataSynStateBizHelper.getBgDataMapByBgForm(ctx, bgForm, BgDataSynStateBizHelper.getUpdateSelector());
        if (bgDataState != null && dataState != null) {
            BgDataSynStateBizHelper.updateDataStateBatch(ctx, BgDataSynStateBizHelper.getFilterUpdBgDataCol(dataState, bgDataState, updFlag));
        }
    }

    public static void updateDataStateByFormID(Context ctx, String bgFormId, BgDataStateEnum bgDataState, boolean updFlag, String operator) throws EASBizException, BOSException, SQLException {
        if (ctx == null || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        ArrayList<String> bgFormIds = new ArrayList<String>();
        bgFormIds.add(bgFormId);
        BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet(ctx, bgFormIds, bgDataState, updFlag, operator);
    }

    public static void updateDataStateByFormID(Context ctx, String formID, boolean updFlag) throws EASBizException, BOSException, SQLException {
        if (ctx == null) {
            return;
        }
        if (formID == null) {
            return;
        }
        BgFormInfo bgForm = new BgFormInfo();
        bgForm.setId(BOSUuid.read((String)formID));
        CoreBaseCollection dataState = null;
        bgForm = BgDataSynStateBizHelper.getBgFormInfo(ctx, bgForm.getId(), true, false);
        dataState = BgDataSynStateBizHelper.getBgDataMapByBgForm(ctx, bgForm, BgDataSynStateBizHelper.getUpdateSelector());
        BgDataStateEnum bgDataState = BgDataSynStateBizHelper.getDataStateByFormState(bgForm.getState());
        if (bgDataState != null && dataState != null) {
            BgDataSynStateBizHelper.updateDataStateBatch(ctx, BgDataSynStateBizHelper.getFilterUpdBgDataCol(dataState, bgDataState, updFlag));
        }
    }

    public static void updateDataStateBatchByFromIdSet(Context ctx, Set ids, BgDataStateEnum bgDataState, boolean updFlag) throws EASBizException, BOSException, SQLException {
        if (ids == null) {
            return;
        }
        if (ctx == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int index = 0;
        try {
            conn = BgDataSynStateBizHelper.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgData set FDataState = ? where FID = ?");
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                BgFormInfo bgForm = new BgFormInfo();
                bgForm.setId(BOSUuid.read((String)it.next().toString()));
                CoreBaseCollection dataState = null;
                dataState = BgDataSynStateBizHelper.getBgDataMapByBgForm(ctx, bgForm = BgDataSynStateBizHelper.getBgFormInfo(ctx, bgForm.getId(), true, false), BgDataSynStateBizHelper.getUpdateSelector());
                if (dataState == null || conn == null) continue;
                for (BgDataInfo tempData : dataState) {
                    if (!BgDataSynStateBizHelper.comparDataState(bgDataState, tempData.getDataState(), updFlag)) continue;
                    pstmt.setInt(1, bgDataState.getValue());
                    pstmt.setString(2, tempData.getId().toString());
                    pstmt.addBatch();
                    if (MAX_BATCH_COUNT >= ++index) continue;
                    pstmt.executeBatch();
                    pstmt.clearBatch();
                    index = 0;
                }
            }
            if (index > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static void updateDataStateBatchByFromIdSet(Context ctx, Set ids, boolean updFlag) throws EASBizException, BOSException, SQLException {
        if (ids == null) {
            return;
        }
        if (ctx == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = BgDataSynStateBizHelper.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgData set FDataState = ? where FID = ?");
            int index = 0;
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                BgFormInfo bgForm = new BgFormInfo();
                bgForm.setId(BOSUuid.read((String)it.next().toString()));
                CoreBaseCollection dataState = null;
                bgForm = BgDataSynStateBizHelper.getBgFormInfo(ctx, bgForm.getId(), true, false);
                dataState = BgDataSynStateBizHelper.getBgDataMapByBgForm(ctx, bgForm, BgDataSynStateBizHelper.getUpdateSelector());
                BgDataStateEnum bgDataState = BgDataSynStateBizHelper.getDataStateByFormState(bgForm.getState());
                if (dataState == null || conn == null) continue;
                for (BgDataInfo tempData : dataState) {
                    if (!BgDataSynStateBizHelper.comparDataState(bgDataState, tempData.getDataState(), updFlag)) continue;
                    pstmt.setInt(1, bgDataState.getValue());
                    pstmt.setString(2, tempData.getId().toString());
                    pstmt.addBatch();
                    if (MAX_BATCH_COUNT >= ++index) continue;
                    pstmt.executeBatch();
                    pstmt.clearBatch();
                    index = 0;
                }
            }
            if (index > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static void updateDataStateBatchByFromIdSet(Context ctx, List ids, boolean updFlag) throws EASBizException, BOSException, SQLException {
        if (ids == null) {
            return;
        }
        if (ctx == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int index = 0;
        try {
            conn = BgDataSynStateBizHelper.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgData set FDataState = ? where FID = ?");
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                BgFormInfo bgForm = new BgFormInfo();
                bgForm.setId(BOSUuid.read((String)it.next().toString()));
                CoreBaseCollection dataState = null;
                bgForm = BgDataSynStateBizHelper.getBgFormInfo(ctx, bgForm.getId(), true, false);
                dataState = BgDataSynStateBizHelper.getBgDataMapByBgForm(ctx, bgForm, BgDataSynStateBizHelper.getUpdateSelector());
                BgDataStateEnum bgDataState = BgDataSynStateBizHelper.getDataStateByFormState(bgForm.getState());
                if (dataState == null || conn == null) continue;
                for (BgDataInfo tempData : dataState) {
                    if (!BgDataSynStateBizHelper.comparDataState(bgDataState, tempData.getDataState(), updFlag)) continue;
                    pstmt.setInt(1, bgDataState.getValue());
                    pstmt.setString(2, tempData.getId().toString());
                    pstmt.addBatch();
                    if (MAX_BATCH_COUNT >= ++index) continue;
                    pstmt.executeBatch();
                    pstmt.clearBatch();
                    index = 0;
                }
            }
            if (index > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static void updateDataStateBatchByFromIdSet(Context ctx, List ids, BgDataStateEnum bgDataState, boolean updFlag) throws EASBizException, BOSException, SQLException {
        if (ids == null) {
            return;
        }
        if (ctx == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int index = 0;
        try {
            conn = BgDataSynStateBizHelper.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgData set FDataState = ? where FID = ?");
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                BgFormInfo bgForm = new BgFormInfo();
                bgForm.setId(BOSUuid.read((String)it.next().toString()));
                CoreBaseCollection dataState = null;
                dataState = BgDataSynStateBizHelper.getBgDataMapByBgForm(ctx, bgForm = BgDataSynStateBizHelper.getBgFormInfo(ctx, bgForm.getId(), true, false), BgDataSynStateBizHelper.getUpdateSelector());
                if (dataState == null || conn == null) continue;
                for (BgDataInfo tempData : dataState) {
                    if (!BgDataSynStateBizHelper.comparDataState(bgDataState, tempData.getDataState(), updFlag)) continue;
                    pstmt.setInt(1, bgDataState.getValue());
                    pstmt.setString(2, tempData.getId().toString());
                    pstmt.addBatch();
                    if (MAX_BATCH_COUNT >= ++index) continue;
                    pstmt.executeBatch();
                    pstmt.clearBatch();
                    index = 0;
                }
            }
            if (index > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgFormInfo getBgFormInfo(Context ctx, BOSUuid bgFormId, boolean loadData, boolean stateOnly) throws EASBizException, SQLDataException {
        PreparedStatement pstmt;
        Connection conn;
        BgFormInfo bgFormInfo;
        block18: {
            if (bgFormId == null) {
                return null;
            }
            bgFormInfo = null;
            conn = null;
            pstmt = null;
            ResultSet rst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Select bgf.FID, bgf.FNumber, bgf.FName, bgf.FControlUnitID, bgf.FOrgUnitID, bgf.FBgSchemeID, bgf.FBgTemplateId , bgt.FFormType ," + (loadData ? " bgf.FData, bgf.FAdjustMapData, " : "") + " bgf.FBgPeriodID, bgf.FCurrencyID, bgf.FMeasureUnitID, bgf.FDataSource, bgf.FVersionNo, bgf.FAdjustID, bgf.FState  From T_BG_BgForm bgf left join T_BG_BgTemplate bgt on bgf.FBgTemplateId = bgt.fid where bgf.FID = ?");
            StringBuffer sql2 = new StringBuffer();
            sql2.append("Select bgf.FID, bgf.FBgTemplateId ,bgf.FOrgUnitID, bgt.FFormType, bgf.FState  From T_BG_BgForm bgf left join T_BG_BgTemplate bgt on bgf.FBgTemplateId = bgt.fid where bgf.FID = ?");
            try {
                conn = BgDataSynStateBizHelper.getConnection(ctx);
                if (stateOnly) {
                    pstmt = conn.prepareStatement(sql2.toString());
                    pstmt.setString(1, bgFormId.toString());
                    rst = pstmt.executeQuery();
                    if (!rst.next()) break block18;
                    bgFormInfo = new BgFormInfo();
                    bgFormInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    bgFormInfo.setState(BgFormStateEnum.getEnum(rst.getInt("FState")));
                    if (rst.getString("FOrgUnitID") != null) {
                        bgFormInfo.setOrgUnit(new FullOrgUnitInfo());
                        bgFormInfo.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                    }
                    if (rst.getString("FBgTemplateId") != null) {
                        BgTemplateInfo template = new BgTemplateInfo();
                        template.setId(BOSUuid.read((String)rst.getString("FBgTemplateId")));
                        template.setFormType(rst.getInt("FFormType") > 0 ? BgTemFormTypeEnum.getEnum(rst.getInt("FFormType")) : null);
                        bgFormInfo.setBgTemplate(template);
                    }
                    break block18;
                }
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, bgFormId.toString());
                rst = pstmt.executeQuery();
                if (!rst.next()) break block18;
                bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgFormInfo.setNumber(rst.getString("FNumber"));
                bgFormInfo.setName(rst.getString("FName"));
                bgFormInfo.setVersionNo(rst.getBigDecimal("FVersionNo"));
                bgFormInfo.setState(BgFormStateEnum.getEnum(rst.getInt("FState")));
                bgFormInfo.setDataSource(BgFormDataSourceEnum.getEnum(rst.getInt("FDataSource")));
                if (loadData) {
                    bgFormInfo.setZipData(BgInfoHelper.getBytes((ResultSet)rst, (String)"FData"));
                    bgFormInfo.setAdjustMapData(BgInfoHelper.getBytes((ResultSet)rst, (String)"FAdjustMapData"));
                }
                if (rst.getString("FControlUnitID") != null) {
                    bgFormInfo.setCU(new CtrlUnitInfo());
                    bgFormInfo.getCU().setId(BOSUuid.read((String)rst.getString("FControlUnitID")));
                }
                if (rst.getString("FOrgUnitID") != null) {
                    bgFormInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgFormInfo.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                }
                if (rst.getString("FBgSchemeID") != null) {
                    bgFormInfo.setBgScheme(new BgSchemeInfo());
                    bgFormInfo.getBgScheme().setId(BOSUuid.read((String)rst.getString("FBgSchemeID")));
                }
                if (rst.getString("FBgTemplateId") != null) {
                    BgTemplateInfo template = new BgTemplateInfo();
                    template.setId(BOSUuid.read((String)rst.getString("FBgTemplateId")));
                    template.setFormType(rst.getInt("FFormType") > 0 ? BgTemFormTypeEnum.getEnum(rst.getInt("FFormType")) : null);
                    bgFormInfo.setBgTemplate(template);
                }
                if (rst.getString("FBgPeriodID") != null) {
                    bgFormInfo.setBgPeriod(new BgPeriodInfo());
                    bgFormInfo.getBgPeriod().setId(BOSUuid.read((String)rst.getString("FBgPeriodID")));
                }
                if (rst.getString("FCurrencyID") != null) {
                    bgFormInfo.setCurrency(new CurrencyInfo());
                    bgFormInfo.getCurrency().setId(BOSUuid.read((String)rst.getString("FCurrencyID")));
                }
                if (rst.getString("FMeasureUnitID") != null) {
                    bgFormInfo.setMeasureUnit(new MeasureUnitInfo());
                    bgFormInfo.getMeasureUnit().setId(BOSUuid.read((String)rst.getString("FMeasureUnitID")));
                }
                if (rst.getString("FAdjustID") != null) {
                    bgFormInfo.setAdjust(new BgFormInfo());
                    bgFormInfo.getAdjust().setId(BOSUuid.read((String)rst.getString("FAdjustID")));
                }
            }
            catch (SQLException ex) {
                try {
                    logger.warn((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (IOException ex2) {
                        logger.warn((Object)ex2.getMessage());
                        throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return bgFormInfo;
    }

    public static CoreBaseCollection getBgDataMapByBgForm(Context ctx, BgFormInfo bgForm, SelectorItemCollection sels) throws BOSException, EASBizException {
        EntityViewInfo view = null;
        FilterInfo filter = null;
        CoreBaseCollection bgDataCol = null;
        if (bgForm == null) {
            return null;
        }
        if (bgForm.getBgTemplate() == null) {
            return null;
        }
        if (bgForm.getBgTemplate().getFormType() != null) {
            if (!BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getBgTemplate().getFormType())) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bgFormId.id", (Object)bgForm.getId().toString()));
                view.setSelector(sels);
                view.setFilter(filter);
                bgDataCol = ((IBgData)BgDataSynStateBizHelper.getBgDataUpdateInterface(ctx)).getCollection(view);
            } else {
                bgDataCol = new CoreBaseCollection();
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bgForm.id", (Object)bgForm.getId().toString()));
                view.setSelector(BgDataSynStateBizHelper.getMixSelector("bgData", sels));
                view.setFilter(filter);
                CoreBaseCollection bgDataEntry = null;
                bgDataEntry = ((IBgDataEntry)BgDataSynStateBizHelper.getBgDataEntryInterface(ctx)).getCollection(view);
                if (bgDataEntry != null) {
                    for (BgDataEntryInfo bgDataEnt : bgDataEntry) {
                        bgDataCol.add((CoreBaseInfo)bgDataEnt.getBgData());
                    }
                }
            }
        } else {
            return null;
        }
        return bgDataCol;
    }

    public static SelectorItemCollection getMixSelector(String str, SelectorItemCollection sels) {
        StringBuffer strff = null;
        SelectorItemCollection newSels = null;
        if (str == null) {
            if (sels != null) {
                return sels;
            }
            return null;
        }
        newSels = new SelectorItemCollection();
        for (SelectorItemInfo sel : sels) {
            strff = new StringBuffer(str);
            strff.append(".");
            if (sel.getPropertyName() == null) continue;
            strff.append(sel.getPropertyName());
            newSels.add(strff.toString());
        }
        return newSels;
    }

    public static ICoreBase getTemplateUpdateInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return BgTemplateFactory.getRemoteInstance();
        }
        return BgTemplateFactory.getLocalInstance(ctx);
    }

    public static ICoreBase getBgFormUpdateInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return BgFormFactory.getRemoteInstance();
        }
        return BgFormFactory.getLocalInstance(ctx);
    }

    public static boolean isReportView(Context ctx, String id) throws EASBizException, BOSException {
        if (id == null) {
            return false;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        BgFormInfo bgform = null;
        SelectorItemCollection sels = new SelectorItemCollection();
        sels.add("bgTemplate.id");
        sels.add("state");
        sels.add("bgTemplate.formType");
        bgform = (BgFormInfo)BgDataSynStateBizHelper.getBgFormUpdateInterface(ctx).getValue((IObjectPK)pk, sels);
        return BgTemFormTypeEnum.VIEWFORM.equals((Object)bgform.getBgTemplate().getFormType());
    }

    public static CoreBaseCollection getBgDataColByOrgAndScheme(Context ctx, BgFormInfo BgForm2) throws EASBizException, UuidException, BOSException {
        BgFormInfo bgForm = null;
        CoreBaseCollection cols = null;
        bgForm = BgDataSynStateBizHelper.getBgFormInfo(ctx, BgForm2.getId(), false, true);
        cols = BgDataSynStateBizHelper.getBgDataMapByBgForm(ctx, bgForm, BgDataSynStateBizHelper.getValueUpdaeSelector());
        return cols;
    }

    public static void deleteBgData(Context ctx, String schemeId, String orgId, String formId, Set formulaSet) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)schemeId));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId));
        filter.getFilterItems().add(new FilterItemInfo("formula", (Object)formulaSet, CompareType.INCLUDE));
        IObjectPK[] pkids = BgDataSynStateBizHelper.getBgDataUpdateInterface(ctx).delete(filter);
        if (pkids != null && pkids.length > 0) {
            HashSet<String> tmpDel = new HashSet<String>();
            for (int i = 0; i < pkids.length; ++i) {
                IObjectPK s = pkids[i];
                if (s == null || s.equals((Object)"")) continue;
                tmpDel.add(s.toString());
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgData.id", tmpDel, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("bgForm.id", (Object)formId));
            BgDataSynStateBizHelper.getBgDataEntryInterface(ctx).delete(filter);
        }
    }
}

