/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.client.BgTemplateProcessUI;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.ma.view.client.BgReportViewAdjustProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class BgFormHelper {
    public static final int decimal = 10;
    public static final String STRRESOURCE = "com.kingdee.eas.ma.budget.client.BgFormResource";
    public static final String ADJUSTSOURCE = "com.kingdee.eas.ma.budget.client.BgFormAdjustResource";
    public static final String OrgUnitId = "orgUnitId";
    public static final String OrgUnitInfo = "orgUnitInfo";
    public static final String OrgUnitCU = "OrgUnitCU";
    public static final String LINK_ORGUNIT = "LINK_ORGUNIT";
    public static final String LINK_BGSCHEME = "LINK_BGSCHEME";
    public static final String LINK_BGTEMPLATE = "LINK_BGTEMPLATE";
    public static final String LINK_CURRENCY = "LINK_CURRENCY";
    public static final String LINK_BGPERIOD = "LINK_BGPERIOD";
    public static final String isOpenReport = "OpenReport";
    public static final String isBizActual = "isBizActual";
    public static final String OpenReportState = "OpenReportState";
    public static final String OpenReportModal = "OpenReportModal";
    public static final String budgetSheetTag = "RPTSHEET";
    public static final String ActualSheetTag = "ACTSHEET";
    public static final String BatchAddTag = "BatchAdd";
    public static final String bgFormInfo = "bgFormInfo";
    public static final String bgFormCol = "bgFormCol";
    public static final String bgFormInfoId = "bgFormInfoId";
    public static final String budgetAuditUI = "budgetAuditUI";
    public static final String formulaRecord = "formulaRecord";
    public static final String formulaFormId = "formulaFormId";
    public static final String formulaOrgUnit = "formulaOrgUnit";
    public static final String formulaScheme = "formulaScheme";
    public static final String bgFormPastRecord = "bgFormPastRecord";
    public static final String bgFormAdjust = "bgFormAdjust";
    public static final String bgRecordType = "bgRecordType";
    public static final String curBgFormProcessUI = "curBgFormProcessUI";
    public static final String bgFormAuditType = "bgFormAuditType";
    public static final String bgFormShowAudit = "bgFormShowAudit";
    public static final String bgFormType = "bgFormType";
    public static final String bgFormWorking = "bgFormWorking";
    public static final String budgetEditType = "budgetEditType";
    public static final String budgetAuditType = "budgetAuditType";
    public static final String budgetUnAuditType = "budgetUnAuditType";
    public static final String budgetAccreditType = "budgetAccreditType";
    public static final String ActualEditType = "ActualEditType";
    public static final String adjustHistory = "adjustHistory";
    public static final String hisOrgUnitID = "hisOrgUnitID";
    public static final String hisBgSchemeID = "hisBgSchemeID";
    public static final String hisFormula = "hisFormula";
    public static final String formulas = "formulas";
    public static final String EDIT_VALUE = "EDIT_VALUE";
    public static final String OPEN_FORMULA = "OPEN_FORMULA";
    public static final String isNewAdjustForm = "isNewAdjustForm";

    public static void refreshBgFormList(CoreUI ui) throws Exception {
        Container parent;
        if (ui == null) {
            return;
        }
        Object listUI = null;
        if (ui instanceof EditUI) {
            listUI = ui.getUIContext().get("Owner");
        } else if (ui instanceof ListUI) {
            listUI = ui;
        } else if (ui instanceof BgTemplateProcessUI) {
            listUI = ui.getUIContext().get("Owner");
        } else if (ui instanceof BgReportViewAdjustProcessUI) {
            listUI = ui.getUIContext().get("Owner");
        }
        if (listUI != null && listUI instanceof ListUI && (parent = ((ListUI)listUI).getParent()) != null && parent instanceof KDTabbedPane) {
            KDTabbedPane tabb = (KDTabbedPane)parent;
            int n = tabb.getTabCount();
            for (int i = 0; i < n; ++i) {
                Component component = tabb.getComponentAt(i);
                if (!ListUI.class.isAssignableFrom(component.getClass()) || StringUtils.isEmpty((String)component.getClass().getName()) || component.getClass().getName().indexOf("budget") < 0) continue;
                ((ListUI)component).refreshList();
            }
        }
    }

    public static CurrencyInfo getOrgBaseCurrency(BOSUuid orgUnitId) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        CompanyOrgUnitInfo company;
        if (orgUnitId == null) {
            return null;
        }
        CurrencyInfo currency = null;
        ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getRemoteInstance();
        if (icompany != null && (company = icompany.getCompanyOrgUnitInfo((IObjectPK)(pk = new ObjectUuidPK(orgUnitId)))) != null) {
            currency = company.getBaseCurrency();
        }
        return currency;
    }

    public static void setSelectObject(KDComboBox cbo, Object anObject) {
        if (anObject == null) {
            return;
        }
        if (CoreBaseInfo.class.isInstance(anObject)) {
            CoreBaseInfo newObject = (CoreBaseInfo)anObject;
            for (int i = 0; i < cbo.getItemCount(); ++i) {
                CoreBaseInfo obj = (CoreBaseInfo)cbo.getItemAt(i);
                if (obj == null || !newObject.getId().equals((Object)obj.getId())) continue;
                cbo.setSelectedIndex(i);
                break;
            }
        } else {
            cbo.setSelectedItem(anObject);
        }
    }

    public static boolean checkInProInst(String id) throws BOSException {
        boolean result = false;
        ProcessInstInfo[] procInsts = EnactmentServiceFactory.createRemoteEnactService().getProcessInstanceByHoldedObjectId(id);
        for (int i = 0; i < procInsts.length; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getNumberFormat(String str, int number) {
        if (str == null || number <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static void checkFormulaIsEctype(List formulas) throws EASBizException {
        int index;
        if (formulas == null || formulas.isEmpty()) {
            return;
        }
        String formulaString = null;
        String checkString = null;
        String sheetString = null;
        StringBuffer msg = null;
        String[] parameter = null;
        HashMap checkMap = new HashMap();
        int count = formulas.size();
        for (index = 0; index < count; ++index) {
            parameter = (String[])formulas.get(index);
            if (parameter == null || parameter[0] == null || parameter[1] == null || parameter[2] == null || parameter[3] == null) continue;
            formulaString = parameter[1];
            if (checkMap.containsKey(formulaString)) {
                checkString = formulaString;
                break;
            }
            checkMap.put(formulaString, null);
        }
        if (checkString != null) {
            msg = new StringBuffer(1024);
            count = formulas.size();
            for (index = 0; index < count; ++index) {
                parameter = (String[])formulas.get(index);
                if (parameter == null || parameter[0] == null || parameter[1] == null || parameter[2] == null || parameter[3] == null || !(formulaString = parameter[1]).equals(checkString)) continue;
                if (sheetString == null || !sheetString.equals(parameter[0])) {
                    sheetString = parameter[0];
                    msg.append(BgFormHelper.getMessage("left") + sheetString + BgFormHelper.getMessage("right") + BgFormHelper.getMessage("checkFormulade"));
                }
                msg.append(TableToolkit.xy2range((int)Integer.valueOf(parameter[3]), (int)Integer.valueOf(parameter[2])) + BgFormHelper.getMessage("andtwo"));
            }
            msg.delete(msg.length() - 1, msg.length());
            msg.append(BgFormHelper.getMessage("checkFormula") + BgFormHelper.getMessage("left") + checkString.replaceAll(",\"BgData\",true", "") + BgFormHelper.getMessage("right") + BgFormHelper.getMessage("checkFormulaEctype"));
            throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg.toString()});
        }
    }

    public static String getMessage(String msg) {
        return EASResource.getString((String)STRRESOURCE, (String)msg);
    }

    public static void ImportFormExcelFile(Component comp, KDTable table) {
        BgFormHelper.ImportFormExcelFile(comp, table, 0, 0);
    }

    public static void ImportFormExcelFile(Component comp, KDTable table, int left, int top) {
        File file;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"ReportProcessUI_Import"));
        fileChooser.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog(comp) == 0 && (file = fileChooser.getSelectedFile()) != null && file.isFile()) {
            KDSSheet sheet;
            String fileName = file.getPath();
            KDSBook books = POIXlsReader.parse((String)fileName);
            if (books == null) {
                MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)STRRESOURCE, (String)"openFileError"));
                SysUtil.abort();
            }
            if ((sheet = books.getSheet((Object)new Integer(0))) == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"badFileError"));
                SysUtil.abort();
            }
            BgFormHelper.writeToSheet(sheet, table, left, top);
        }
    }

    private static void writeToSheet(KDSSheet from, KDTable to, int left, int top) {
        if (from == null || to == null) {
            return;
        }
        KDSCell fromCell = null;
        int rowCount = from.getRowCount();
        int colCount = from.getColumnCount();
        block0: for (int i = top; i < rowCount; ++i) {
            IRow row = to.addRow();
            int k = left;
            for (int j = left; j <= colCount; ++j) {
                fromCell = from.getCell(i, j, false);
                if (fromCell == null || fromCell.getValue() == null || fromCell.getValue().toString().length() <= 0) continue;
                while (to.getColumn(k) != null && to.getColumn(k).getStyleAttributes().isHided()) {
                    ++k;
                }
                if (to.getColumn(k) == null) continue block0;
                row.getCell(k).setValue(fromCell.getValue());
                ++k;
            }
        }
    }
}

