/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.runtime.KScriptUtil;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.ma.budget.BgControlRuleInfo;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BgLocaleHelper {
    private static final Logger logger = Logger.getLogger(BgLocaleHelper.class);
    public static final Locale[] locales;

    public static void setLocalesProperty(IObjectValue obj, String property, String value, Locale currLocale) {
        if (obj == null || StringUtils.isEmpty((String)property) || currLocale == null) {
            return;
        }
        obj.put(property, (Object)value, LocaleUtils.locale_l1);
        obj.put(property, (Object)STConverter.tc2sc((String)value), LocaleUtils.locale_l2);
        obj.put(property, (Object)STConverter.sc2tc((String)value), LocaleUtils.locale_l3);
    }

    public static void copyMultiLangField(IObjectValue target, IObjectValue source, String property) {
        if (target != null && source != null && property != null) {
            for (int i = 0; i < locales.length; ++i) {
                Locale l = locales[i];
                if (source.get(property, l) == null) continue;
                target.put(property, source.get(property, l), l);
            }
            if (target.get(property, LocaleUtils.locale_l1) == null) {
                if (target.get(property, LocaleUtils.locale_l2) != null) {
                    target.put(property, target.get(property, LocaleUtils.locale_l2), LocaleUtils.locale_l1);
                } else if (target.get(property, LocaleUtils.locale_l3) != null) {
                    target.put(property, target.get(property, LocaleUtils.locale_l3), LocaleUtils.locale_l1);
                }
            }
            if (target.get(property, LocaleUtils.locale_l2) == null) {
                if (target.get(property, LocaleUtils.locale_l3) != null) {
                    target.put(property, (Object)STConverter.tc2sc((String)String.valueOf(target.get(property, LocaleUtils.locale_l2))), LocaleUtils.locale_l2);
                } else if (target.get(property, LocaleUtils.locale_l1) != null) {
                    target.put(property, target.get(property, LocaleUtils.locale_l1), LocaleUtils.locale_l2);
                }
            }
            if (target.get(property, LocaleUtils.locale_l3) == null) {
                if (target.get(property, LocaleUtils.locale_l2) != null) {
                    target.put(property, (Object)STConverter.sc2tc((String)String.valueOf(target.get(property, LocaleUtils.locale_l2))), LocaleUtils.locale_l3);
                } else if (target.get(property, LocaleUtils.locale_l1) != null) {
                    target.put(property, target.get(property, LocaleUtils.locale_l1), LocaleUtils.locale_l3);
                }
            }
        }
    }

    public static boolean isMultiField(String field) {
        if (field != null) {
            for (int i = 0; i < locales.length; ++i) {
                if (!field.toLowerCase(Locale.ENGLISH).endsWith("_" + locales[i].getDisplayName().toLowerCase(Locale.ENGLISH))) continue;
                return true;
            }
        }
        return false;
    }

    public static void appandSelectMultiLangeField(StringBuffer sql, String filed, String alias) {
        if (sql == null || filed == null || alias == null) {
            return;
        }
        for (int i = 0; i < locales.length; ++i) {
            sql.append(",").append(filed).append("_").append(locales[i].getDisplayName()).append(" ").append(alias).append("_").append(locales[i].getDisplayName());
        }
    }

    public static void resetAlias(BgControlSchemeInfo scheme, Context ctx) {
        if (scheme == null || StringUtils.isEmpty((String)scheme.getBoName()) || scheme.getRules().isEmpty()) {
            return;
        }
        IMetaDataLoader loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)scheme.getBoName()));
        if (entity != null) {
            for (int i = 0; i < scheme.getRules().size(); ++i) {
                BgControlRuleInfo rule = scheme.getRules().get(i);
                rule.setAliasActual(BgLocaleHelper.getAlias(entity, rule.getOqlActual()));
                rule.setAliasBizDate(BgLocaleHelper.getAlias(entity, rule.getOqlBizDate()));
                rule.setAliasCurrency(BgLocaleHelper.getAlias(entity, rule.getOqlCurrency()));
                rule.setAliasOrgUnit(BgLocaleHelper.getAlias(entity, rule.getOqlOrgUnit()));
                rule.setAliasPeriod(BgLocaleHelper.getAlias(entity, rule.getOqlPeriod()));
                if (StringUtils.isEmpty((String)rule.getOqlRequestExtendExpression())) {
                    rule.setAliasRequest(BgLocaleHelper.getAlias(entity, rule.getOqlRequest()));
                } else {
                    String[] request = rule.getOqlRequest().split("\\|");
                    String reqAlias = BgLocaleHelper.getAlias(entity, request[0]);
                    if (request.length == 2) {
                        try {
                            String[] exs = rule.getOqlRequestExtendExpression().split("\\,");
                            request[1] = request[1].replaceAll("\\.", "\\_");
                            for (int e = 0; e < exs.length; ++e) {
                                request[1] = KScriptUtil.replaceIdent((String)request[1], (String)exs[e].replaceAll("\\.", "\\_"), (String)BgLocaleHelper.getAlias(entity, exs[e]));
                            }
                            reqAlias = reqAlias + "|" + request[1].replaceAll("\\_", "\\.");
                        }
                        catch (com.kingdee.bos.kscript.ParserException e1) {
                            logger.error((Object)"", (Throwable)e1);
                            reqAlias = reqAlias + "|" + request[1];
                        }
                    }
                    rule.setAliasRequest(reqAlias);
                }
                rule.setAliasItemCombination(BgLocaleHelper.getAliasCombin(entity, rule.getOqlItemCombination()));
                if (StringUtils.isEmpty((String)rule.getOqlRuleCondition())) continue;
                try {
                    HashMap<String, String> code_alias = new HashMap<String, String>();
                    FilterInfo filter = new FilterInfo(rule.getOqlRuleCondition());
                    for (int f = 0; f < filter.getFilterItems().size(); ++f) {
                        String properyName = filter.getFilterItems().get(f).getPropertyName();
                        String propertyAlias = BgLocaleHelper.getAlias(entity, properyName);
                        if (propertyAlias == null) continue;
                        filter.getFilterItems().get(f).setString("propertyName", "propertyName_" + f);
                        code_alias.put("propertyName_" + f, BgLocaleHelper.getAlias(entity, properyName));
                    }
                    String alias = filter.toString();
                    for (String key : code_alias.keySet()) {
                        alias = alias.replaceAll(key, (String)code_alias.get(key));
                    }
                    rule.setAliasRuleCondition(alias);
                    continue;
                }
                catch (ParserException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
    }

    private static String getAliasCombin(EntityObjectInfo entity, String propertity) {
        if (entity == null || StringUtils.isEmpty((String)propertity)) {
            return null;
        }
        String[] props = propertity.split("@");
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < props.length; ++i) {
            if (i > 0) {
                res.append("@");
            }
            res.append(BgLocaleHelper.getAlias(entity, props[i]));
        }
        return res.toString();
    }

    private static String getAlias(EntityObjectInfo entity, String propertity) {
        if (entity == null || StringUtils.isEmpty((String)propertity)) {
            return null;
        }
        StringBuffer res = new StringBuffer();
        String limit = null;
        if (propertity.indexOf("|") > 0) {
            int index = propertity.indexOf("|");
            limit = propertity.substring(index + 1);
            propertity = propertity.substring(0, index);
        }
        String[] props = propertity.split("\\.");
        PropertyInfo prop = null;
        for (int i = 0; i < props.length; ++i) {
            prop = entity.getPropertyByName(props[i]);
            if (prop == null) continue;
            res.append(prop.getAlias()).append(".");
            if (!(prop instanceof LinkPropertyInfo)) break;
            entity = ((LinkPropertyInfo)prop).getRelationship().getSupplierObject();
        }
        if (res.length() > 0) {
            res.setLength(res.length() - 1);
        }
        if (limit != null) {
            res.append("|").append(limit);
        }
        return res.toString();
    }

    static {
        HashMap<String, Locale> list = new HashMap<String, Locale>();
        Field[] field = LocaleUtils.class.getFields();
        if (field != null) {
            for (int i = 0; i < field.length; ++i) {
                if (field[i].getType() != Locale.class || !field[i].getName().toLowerCase(Locale.ENGLISH).startsWith("locale_l")) continue;
                try {
                    Locale locale = (Locale)field[i].get(null);
                    list.put(locale.getDisplayName(), locale);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
        locales = new Locale[list.size()];
        int index = 0;
        Iterator it = list.values().iterator();
        while (it.hasNext()) {
            BgLocaleHelper.locales[index++] = (Locale)it.next();
        }
    }
}

