/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class BgPeriodNExprSetterHelper {
    private static final Logger logger = Logger.getLogger(BgPeriodNExprSetterHelper.class);
    public static final String RPTDATE_STR = "RPTDATE";
    public static final String BGRPTDATE_STR = "BGRPTDATE";
    public static final String BGGETORGNUM_STR = "BGGETORGNUM";
    public static final String BGFORMULA_STR = "BGFORMULA";
    public static final String BGACTUAL_STR = "BGACTUAL";
    public static final String BGACTUALEXT_STR = "BGACTUALEXT";
    public static final String BGACT_STR = "BGACT";
    public static final String BGBAL_STR = "BGBAL";
    public static final String BGACTUALS_STR = "BGACTUALS";
    public static final String BGREFBGTEM_STR = "BGREFBGTEM";
    public static final String BGREFBGFORM_STR = "BGREFBGFORM";
    public static final String BGADJUST_STR = "BGADJUST";
    public static final String BGAVLBAL_STR = "BGAVLBAL";
    public static final String ACCT_STR = "ACCT";

    public static String checkExpression(Cell cell, String expressions, final String nValue, final String convertType) {
        if (StringUtils.isEmpty((String)expressions) || nValue == null) {
            return null;
        }
        String _expressions = null;
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)expressions);
            if (cell != null && expression instanceof FunctionExpr) {
                BgPeriodNExprSetterHelper.checkFuncionName((FunctionExpr)expression, cell);
            }
            if (expression instanceof Ref3DExpr) {
                return expressions;
            }
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return BgPeriodNExprSetterHelper.checkExpression(expr, nValue, convertType);
                }
            });
            _expressions = '=' + expression.toString();
        }
        catch (Exception ex) {
            logger.error((Object)expressions);
            logger.error((Object)ex);
        }
        return _expressions;
    }

    private static void checkFuncionName(FunctionExpr expr, Cell cell) {
        String obj;
        if (expr == null || cell == null) {
            return;
        }
        String funcionName = expr.funcionName;
        if ((RPTDATE_STR.equalsIgnoreCase(funcionName) || BGRPTDATE_STR.equalsIgnoreCase(funcionName) || BGGETORGNUM_STR.equalsIgnoreCase(funcionName)) && ((obj = cell.getStyle().getNumberFormat()) == null || !"@".equals(obj))) {
            BgNFSHelper.setNumberFormat((Cell)cell, (String)"@");
        }
    }

    private static Expression checkExpression(Expression expression, String nValue, String convertType) {
        if (expression instanceof FunctionExpr) {
            expression = BgPeriodNExprSetterHelper.checkFunctionExpr((FunctionExpr)expression, nValue, convertType);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgPeriodNExprSetterHelper.checkBinaryOperationExpr((BinaryOperationExpr)expression, nValue, convertType);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = BgPeriodNExprSetterHelper.checkUnaryOperationExpr((UnaryOperationExpr)expression, nValue);
        }
        return expression;
    }

    private static Expression checkFunctionExpr(FunctionExpr funExpr, String nValue, String convertType) {
        String funcionName = funExpr.funcionName;
        try {
            if (BGFORMULA_STR.equalsIgnoreCase(funcionName) || BGACT_STR.equalsIgnoreCase(funcionName) || BGBAL_STR.equalsIgnoreCase(funcionName) || BGACTUALS_STR.equalsIgnoreCase(funcionName) || BGREFBGTEM_STR.equalsIgnoreCase(funcionName) || BGADJUST_STR.equalsIgnoreCase(funcionName) || BGAVLBAL_STR.equalsIgnoreCase(funcionName) || BGACTUALEXT_STR.equalsIgnoreCase(funcionName)) {
                FunctionExpr _expression = funExpr;
                Expression p0 = (Expression)funExpr.parameters.get(0);
                if (p0 instanceof StringExpr) {
                    StringExpr sp = (StringExpr)p0;
                    String valueStr = sp.value;
                    String[] pp = valueStr.split(";");
                    if (pp != null && pp.length > 1) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < pp.length; ++i) {
                            funExpr.parameters.set(0, new StringExpr(pp[i]));
                            if (sb.length() > 1) {
                                sb.append('+');
                            }
                            funExpr.output(sb);
                        }
                        _expression = ExcelFormulaPaserHelper.parse((String)sb.toString());
                        _expression = BgPeriodNExprSetterHelper.checkExpression((Expression)_expression, nValue, convertType);
                    }
                }
                if (_expression instanceof FunctionExpr) {
                    BgPeriodNExprSetterHelper.checkExpressionParam(_expression, nValue, convertType);
                }
                return _expression;
            }
            BgPeriodNExprSetterHelper.checkExpressionParam(funExpr, nValue, convertType);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return funExpr;
    }

    private static BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, String nValue, String convertType) {
        boExpr.left = BgPeriodNExprSetterHelper.checkExpression(boExpr.left, nValue, convertType);
        boExpr.right = BgPeriodNExprSetterHelper.checkExpression(boExpr.right, nValue, convertType);
        return boExpr;
    }

    private static UnaryOperationExpr checkUnaryOperationExpr(UnaryOperationExpr boExpr, String nValuel) {
        return boExpr;
    }

    private static void checkExpressionParam(FunctionExpr funExpr, String nValue, String convertType) {
        String funcionName = funExpr.funcionName;
        if (BGACTUAL_STR.equalsIgnoreCase(funcionName)) {
            BgPeriodNExprSetterHelper.checkBgActualParam(funExpr.parameters, nValue, convertType);
        } else if (BGFORMULA_STR.equalsIgnoreCase(funcionName) || BGACT_STR.equalsIgnoreCase(funcionName) || BGACTUALS_STR.equalsIgnoreCase(funcionName) || BGBAL_STR.equalsIgnoreCase(funcionName) || BGADJUST_STR.equalsIgnoreCase(funcionName)) {
            BgPeriodNExprSetterHelper.checkBgFormulaParam(funExpr.parameters, nValue, convertType);
        } else if (BGAVLBAL_STR.equalsIgnoreCase(funcionName)) {
            BgPeriodNExprSetterHelper.checkBgAvlBalFormulaParam(funExpr.parameters, nValue, convertType);
        } else if (BGREFBGTEM_STR.equalsIgnoreCase(funcionName)) {
            BgPeriodNExprSetterHelper.checkBgRefBgTemplateParam(funExpr.parameters, nValue, convertType);
        } else if (BGACTUALEXT_STR.equalsIgnoreCase(funcionName)) {
            BgPeriodNExprSetterHelper.checkBgActualExtFormulaParam(funExpr.parameters, nValue, convertType);
        }
    }

    private static void checkBgActualParam(List parameter, String nValue, String convertType) {
        if (parameter == null || parameter.size() != 6) {
            return;
        }
        StringExpr param4 = (StringExpr)parameter.get(4);
        StringExpr param5 = (StringExpr)parameter.get(5);
        if ("ALL".equals(convertType)) {
            param4.value = nValue;
            param5.value = nValue;
        } else if ("PART".equals(convertType)) {
            param4.value = BgPeriodNExprSetterHelper.getParamValue(param4.value, nValue);
            param5.value = BgPeriodNExprSetterHelper.getParamValue(param5.value, nValue);
        }
    }

    private static void checkBgRefBgTemplateParam(List parameter, String nValue, String convertType) {
        if (parameter == null || parameter.size() != 7) {
            return;
        }
        StringExpr param3 = (StringExpr)parameter.get(3);
        if ("ALL".equals(convertType)) {
            param3.value = nValue;
        } else if ("PART".equals(convertType)) {
            param3.value = BgPeriodNExprSetterHelper.getParamValue(param3.value, nValue);
        }
    }

    private static void checkBgFormulaParam(List parameter, String nValue, String convertType) {
        if (parameter == null || parameter.size() != 7) {
            return;
        }
        StringExpr param5 = (StringExpr)parameter.get(5);
        StringExpr param6 = (StringExpr)parameter.get(6);
        if ("ALL".equals(convertType)) {
            param5.value = nValue;
            param6.value = nValue;
        } else if ("PART".equals(convertType)) {
            param5.value = BgPeriodNExprSetterHelper.getParamValue(param5.value, nValue);
            param6.value = BgPeriodNExprSetterHelper.getParamValue(param6.value, nValue);
        }
    }

    private static void checkBgAvlBalFormulaParam(List parameter, String nValue, String convertType) {
        if (parameter == null || parameter.size() != 6) {
            return;
        }
        StringExpr param5 = (StringExpr)parameter.get(5);
        if ("ALL".equals(convertType)) {
            param5.value = nValue;
        } else if ("PART".equals(convertType)) {
            param5.value = BgPeriodNExprSetterHelper.getParamValue(param5.value, nValue);
        }
    }

    private static void checkBgActualExtFormulaParam(List parameter, String nValue, String convertType) {
        if (parameter == null || parameter.size() != 8) {
            return;
        }
        StringExpr param5 = (StringExpr)parameter.get(5);
        StringExpr param6 = (StringExpr)parameter.get(6);
        if ("ALL".equals(convertType)) {
            param5.value = nValue;
            param6.value = nValue;
        } else if ("PART".equals(convertType)) {
            param5.value = BgPeriodNExprSetterHelper.getParamValue(param5.value, nValue);
            param6.value = BgPeriodNExprSetterHelper.getParamValue(param6.value, nValue);
        }
    }

    private static String getParamValue(String param, String nValue) {
        if (StringUtils.isEmpty((String)param) || param.indexOf(".") == -1) {
            return nValue;
        }
        return nValue + param.substring(param.indexOf("."));
    }
}

