/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.analysiscolumn.impls;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgTendencyAnalysisFacadeFactory;
import com.kingdee.eas.ma.budget.BgTendencyAnalysisObjInfo;
import com.kingdee.eas.ma.budget.BgTendencyFilterParam;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgTendencyAnalysisFacade;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.AbstractFetchDataFactory;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.TendencyAnalysisElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FetchTendencyDataFactory
extends AbstractFetchDataFactory {
    private static Logger logger = Logger.getLogger((String)FetchTendencyDataFactory.class.getName());
    private IBgTendencyAnalysisFacade remoteInstance;
    private static List BASEDATA_LIST = Collections.unmodifiableList(Arrays.asList("col6", "col7"));
    private Map BASEDATA_MAP;
    private static List CIRCLEDATA_LIST = Collections.unmodifiableList(Arrays.asList("col8", "col9"));
    private Map CIRCLEDATA_MAP;

    protected FetchTendencyDataFactory() throws ClassNotFoundException {
    }

    @Override
    public void clearAllCache() {
        if (this.BASEDATA_MAP != null) {
            this.BASEDATA_MAP.clear();
        }
        if (this.CIRCLEDATA_MAP != null) {
            this.CIRCLEDATA_MAP.clear();
        }
    }

    @Override
    public String getAnalysisEleClassName() {
        return TendencyAnalysisElement.class.getName();
    }

    @Override
    public void initDataFactory(FilterParam filter1Params, FilterParam filter2Params) throws BOSException {
        logger.info((Object)"FetchTendencyDataFactory.initDataFactory invoke");
        BgTendencyFilterParam filter1Param = (BgTendencyFilterParam)filter1Params;
        BgTendencyFilterParam filter2Param = (BgTendencyFilterParam)filter2Params;
        List analysisColIndexList = filter2Param.getAnalysisElement();
        int num = analysisColIndexList.size();
        for (int i = 0; i < num; ++i) {
            String proName = analysisColIndexList.get(i).toString();
            if (BASEDATA_LIST.indexOf(proName) != -1) {
                this.getBaseData(filter1Param, null);
            }
            if (CIRCLEDATA_LIST.indexOf(proName) == -1) continue;
            this.getCircleData(filter1Param, null);
        }
    }

    @Override
    public void initSubOrgDataFactory(FilterParam filter1Params, FilterParam filter2Params, String[] bgItemAry) throws BOSException {
        logger.info((Object)"FetchTendencyDataFactory.initSubOrgDataFactory invoke");
        BgTendencyFilterParam newFilter1Params = (BgTendencyFilterParam)filter1Params;
        BgTendencyFilterParam newFilter2Params = (BgTendencyFilterParam)filter2Params;
        List analysisColIndexList = newFilter2Params.getAnalysisElement();
        int num = analysisColIndexList.size();
        for (int i = 0; i < num; ++i) {
            String proName = analysisColIndexList.get(i).toString();
            if (BASEDATA_LIST.indexOf(proName) != -1) {
                this.getBaseData(newFilter1Params, bgItemAry);
            }
            if (CIRCLEDATA_LIST.indexOf(proName) == -1) continue;
            this.getCircleData(newFilter1Params, bgItemAry);
        }
    }

    private void getBaseData(BgTendencyFilterParam filter1Params, String[] bgItemAry) throws BOSException {
        if (bgItemAry == null && (this.BASEDATA_MAP == null || this.BASEDATA_MAP.size() == 0)) {
            this.BASEDATA_MAP = this.getRemoteInstance().getBaseData(filter1Params);
        } else if (bgItemAry != null) {
            this.addSubOrgUnitData(filter1Params, this.BASEDATA_MAP, "baseData", bgItemAry);
        }
    }

    private void getCircleData(BgTendencyFilterParam filter1Params, String[] bgItemAry) {
        try {
            if (bgItemAry == null && (this.CIRCLEDATA_MAP == null || this.CIRCLEDATA_MAP.size() == 0)) {
                this.CIRCLEDATA_MAP = this.getRemoteInstance().getCircleData(filter1Params);
            } else if (bgItemAry != null) {
                this.addSubOrgUnitData(filter1Params, this.CIRCLEDATA_MAP, "circleData", bgItemAry);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    private void addSubOrgUnitData(BgTendencyFilterParam filter1Params, Map valueMap, String flag, String[] bgItemAry) throws BOSException {
        String bgItem = bgItemAry[0];
        CostCenterOrgUnitInfo[] lazyOrgInfoAry = filter1Params.getLazyLoadDataCostCenterOrgUnitInfoAry();
        BgTendencyAnalysisObjInfo info = (BgTendencyAnalysisObjInfo)valueMap.get(bgItem);
        if (info != null) {
            Map map = info.getOrgUnitIdMap();
            int num = lazyOrgInfoAry.length;
            for (int i = 0; i < num; ++i) {
                CostCenterOrgUnitInfo orgInfo = lazyOrgInfoAry[i];
                String orgUnitId = orgInfo.getId().toString();
                Object obj = map.get(orgUnitId);
                if (obj != null) continue;
                Map newDataMap = this.getDataForAll(filter1Params, flag);
                this.fillNewDataToValueMap(newDataMap, valueMap, lazyOrgInfoAry);
                break;
            }
        }
    }

    private void fillNewDataToValueMap(Map newDataMap, Map valueMap, CostCenterOrgUnitInfo[] lazyOrgInfoAry) {
        ArrayList bgItemList = new ArrayList(valueMap.keySet());
        int num = bgItemList.size();
        for (int i = 0; i < num; ++i) {
            String bgItem = bgItemList.get(i).toString();
            BgTendencyAnalysisObjInfo newInfo = (BgTendencyAnalysisObjInfo)newDataMap.get(bgItem);
            BgTendencyAnalysisObjInfo info = (BgTendencyAnalysisObjInfo)valueMap.get(bgItem);
            int jNum = lazyOrgInfoAry.length;
            for (int j = 0; j < jNum; ++j) {
                Map newOrgMap = newInfo.getOrgUnitIdMap();
                Map orgMap = info.getOrgUnitIdMap();
                String orgID = lazyOrgInfoAry[j].getId().toString();
                orgMap.put(orgID, newOrgMap.get(orgID));
            }
        }
    }

    private Map getDataForAll(BgTendencyFilterParam filter1Params, String flag) throws BOSException {
        IBgTendencyAnalysisFacade facade = this.getRemoteInstance();
        Map map = null;
        if (flag.equals("baseData")) {
            map = facade.getBaseData(filter1Params);
        } else if (flag.equals("circleData")) {
            map = facade.getCircleData(filter1Params);
        }
        return map;
    }

    private IBgTendencyAnalysisFacade getRemoteInstance() {
        try {
            if (this.remoteInstance == null) {
                this.remoteInstance = BgTendencyAnalysisFacadeFactory.getRemoteInstance();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return this.remoteInstance;
    }

    public Map getBASEDATA_MAP() {
        return this.BASEDATA_MAP;
    }

    public Map getCIRCLEDATA_MAP() {
        return this.CIRCLEDATA_MAP;
    }

    @Override
    public void initDataFactory(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Param, NewBgCompareAndAnalysisFilterParam filter2Param) throws EASBizException, BOSException {
    }
}

