/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgActualRecordException;
import com.kingdee.eas.ma.budget.BgActualRecordFacadeFactory;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgActualRecord;
import com.kingdee.eas.ma.budget.IBgActualRecordFacade;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.app.AbstractBgActualRecordControllerBean;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.app.BgCodeNumberNHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgActualRecordControllerBean
extends AbstractBgActualRecordControllerBean {
    private static final long serialVersionUID = -15990543019848274L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgActualRecordControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBgActualRecord ibgar = BgActualRecordFactory.getLocalInstance(ctx);
        BgActualRecordInfo info = ibgar.getBgActualRecordInfo(pk);
        String companyId = null;
        if (info.getState().getValue() != 1) {
            throw new BgActualRecordException(BgActualRecordException.CANTDELETEOFSTATE, new String[]{info.getNumber()});
        }
        companyId = info.getCompany() != null ? info.getCompany().getId().toString() : info.getCU().getId().toString();
        BgHelper.recycleNumber(ctx, (CoreBaseInfo)info, companyId);
        super._delete(ctx, pk);
        IBgActualRecordFacade iActual = BgActualRecordFacadeFactory.getLocalInstance(ctx);
        iActual.deleteBgActual(pk.toString());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        int state = 1;
        String sql = " select fstate from t_bg_bgactualrecord where fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{model.get("id").toString()});
        try {
            if (rs.next()) {
                state = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (model instanceof BgActualRecordInfo && ((BgActualRecordInfo)model).getBgForm() != null && ((BgActualRecordInfo)model).getBgForm().getId() != null) {
            String bgFormId = ((BgActualRecordInfo)model).getBgForm().getId().toString();
            String kSQL = "select fstate from T_BG_BgForm where fid = ? ";
            IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)kSQL, (Object[])new String[]{bgFormId});
            try {
                int _state;
                if (rst.next() && (_state = rst.getInt(1)) != 2) {
                    throw new BgCtrlException(BgCtrlException.NOTACROSS, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"1_BgActualRecordControllerBean", (Locale)ctx.getLocale())});
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (state == 2) {
            return super._save(ctx, model);
        }
        BgActualRecordInfo actual = (BgActualRecordInfo)model;
        IBgActualRecordFacade iActual = BgActualRecordFacadeFactory.getLocalInstance(ctx);
        String bgFormId = actual.getBgForm().getId().toString();
        Hashtable bgActualMap = this.getNumValue(ctx, actual);
        Hashtable bgPeriodMap = iActual.getBgPeridMapFromBgForm(bgFormId, bgActualMap);
        String bgActualRecordId = actual.getId().toString();
        iActual.writeBgActual(bgFormId, bgActualMap, bgPeriodMap, bgActualRecordId);
        return super._save(ctx, model);
    }

    private Hashtable getNumValueByPeriod(Context ctx, BgActualRecordInfo actual) throws BOSException, EASBizException {
        Map periodMap = this.getBgPeriodColl(ctx, actual.getBgPeriod());
        Hashtable<String, BigDecimal> result = new Hashtable<String, BigDecimal>();
        BigDecimal zero = new BigDecimal("0.00");
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        if (actual.getZipData() == null || actual.getZipData().length == 0) {
            throw new BgFormException(BgFormException.CHECKBLANK, new String[]{"data"});
        }
        try {
            _book = actual.getBook();
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            throw new BOSException((Throwable)e1);
        }
        BgNFSHelper.disableCal((Book)_book);
        int _sheetSize = _book.getSheetCount();
        for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell)) continue;
                    String formulaStr = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                    String[] params = BgNFSHelper.parseFormulaPara(null, (String)formulaStr);
                    String periodNum = null;
                    periodNum = params[1];
                    if (!periodMap.containsKey(periodNum) || formulaStr == null || formulaStr.trim().length() <= 0) continue;
                    Variant obj = _cell.getValue();
                    BigDecimal actualValue = zero;
                    try {
                        actualValue = obj != Variant.nullVariant ? (obj instanceof BigDecimal ? (BigDecimal)obj : (obj instanceof String ? new BigDecimal(obj.toString()) : new BigDecimal(obj.toString()))) : zero;
                    }
                    catch (NumberFormatException e) {
                        actualValue = zero;
                    }
                    if (actualValue == null) continue;
                    result.put(formulaStr, actualValue);
                }
            }
        }
        return result;
    }

    private Map getBgPeriodColl(Context ctx, BgPeriodInfo period) throws BOSException, EASBizException {
        HashMap<String, Object> periodMap = new HashMap<String, Object>();
        if (period == null || period.getId() == null) {
            return periodMap;
        }
        IBgPeriod iPeriod = BgPeriodFactory.getLocalInstance(ctx);
        period = iPeriod.getBgPeriodInfo("select longNumber ,periodType,beginDate,endDate where id = '" + period.getId() + "'");
        String longNumber = period.getLongNumber();
        int type = period.getPeriodType().getValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (type == 8) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)period.getId()));
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)this.rebuildDate(period.getBeginDate(), true), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)this.rebuildDate(period.getEndDate(), false), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodtype", (Object)new Integer(1)));
            filter.setMaskString("#0 or ( #1 and #2 and #3 )");
            SorterItemInfo sort1 = new SorterItemInfo("periodtype");
            sort1.setSortType(SortType.DESCEND);
            SorterItemInfo sort2 = new SorterItemInfo("longNumber");
            sort2.setSortType(SortType.ASCEND);
            view.getSorter().add(sort1);
            view.getSorter().add(sort2);
        } else {
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
            filter.setMaskString("#0 or #1");
            view.getSorter().add(new SorterItemInfo("longNumber"));
        }
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("beginDate"));
        view.getSelector().add(new SelectorItemInfo("endDate"));
        BgPeriodCollection coll = iPeriod.getBgPeriodCollection(view);
        if (coll != null) {
            BgPeriodInfo info = null;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                info = coll.get(i);
                periodMap.put(info.getNumber(), null);
            }
        }
        return periodMap;
    }

    private Date rebuildDate(Date date, boolean isMin) {
        int year = date.getYear();
        int month = date.getMonth();
        int _date = date.getDate();
        if (isMin) {
            return new Date(year, month, _date, 0, 0, 0);
        }
        return new Date(year, month, _date, 23, 59, 59);
    }

    private Hashtable getNumValue(Context ctx, BgActualRecordInfo actual) throws BOSException, EASBizException {
        if (actual.isIsEditByPeriod()) {
            return this.getNumValueByPeriod(ctx, actual);
        }
        Hashtable<String, BigDecimal> result = new Hashtable<String, BigDecimal>();
        BigDecimal zero = new BigDecimal("0.00");
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        if (actual.getZipData() == null || actual.getZipData().length == 0) {
            throw new BgFormException(BgFormException.CHECKBLANK, new String[]{"data"});
        }
        try {
            _book = actual.getBook();
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            throw new BOSException((Throwable)e1);
        }
        BgNFSHelper.disableCal((Book)_book);
        int _sheetSize = _book.getSheetCount();
        for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    String formulaStr;
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell) || (formulaStr = BgNFSHelper.getFormulaOfCell((Cell)_cell)) == null || formulaStr.trim().length() <= 0) continue;
                    Variant obj = _cell.getValue();
                    BigDecimal actualValue = zero;
                    try {
                        actualValue = obj != Variant.nullVariant ? (obj instanceof BigDecimal ? (BigDecimal)obj : (obj instanceof String ? new BigDecimal(obj.toString()) : new BigDecimal(obj.toString()))) : zero;
                    }
                    catch (NumberFormatException e) {
                        actualValue = zero;
                    }
                    if (actualValue == null) continue;
                    result.put(formulaStr, actualValue);
                }
            }
        }
        return result;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String companyId;
        BgActualRecordInfo actual = (BgActualRecordInfo)model;
        if (actual.getCU() == null) {
            actual.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        String id = actual.getId() == null ? "xxx" : actual.getId().toString();
        String bgFormId = actual.getBgForm().getId().toString();
        String periodId = actual.getBgPeriod().getId().toString();
        BgPeriodInfo period = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo("select beginDate ,endDate where id = '" + periodId + "'");
        this._checkBgPeriodAcross(ctx, id, bgFormId, period.getBeginDate(), period.getEndDate());
        if (StringUtils.isEmpty((String)actual.getName())) {
            BgHelper.setSNumberByPro(ctx, actual.getCU().getId().toString(), (CoreBaseInfo)actual, "name");
        }
        if (StringUtils.isEmpty((String)actual.getNumber())) {
            companyId = actual.getCompany().getId().toString();
            if (companyId == null) {
                companyId = actual.getCU().getId().toString();
            }
            BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)actual, (String)companyId, (String)"sourceType");
            if (StringUtils.isEmpty((String)actual.getNumber())) {
                BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)actual, (String)companyId);
            }
            if (StringUtils.isEmpty((String)actual.getNumber())) {
                actual.setNumber("BgActual-" + System.currentTimeMillis());
            }
        }
        if (StringUtils.isEmpty((String)actual.getName())) {
            companyId = actual.getCompany().getId().toString();
            if (companyId == null) {
                companyId = actual.getCU().getId().toString();
            }
            BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)actual, (String)companyId, (String)"sourceType", (String)"name");
            if (StringUtils.isEmpty((String)actual.getName())) {
                actual.setName("BgActual-" + System.currentTimeMillis());
            }
        }
        actual.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        actual.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        actual.setSourceType(RptSrcTypeEnum.BGFORMREPORT);
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    @Override
    protected void _checkBgPeriodAcross(Context ctx, String id, String bgFormId, Date begin, Date end) throws BOSException, EASBizException {
        String sql = "select a.FId from T_BG_Bgactualrecord a ,t_bg_bgperiod b  where a.fbgperiodid = b.fid and ((b.fbegindate <= ? and b.fenddate >= ? ) )  and a.FId <> ? and a.fbgformid = ?";
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setTimestamp(1, new Timestamp(end.getTime()));
            ps.setTimestamp(2, new Timestamp(begin.getTime()));
            ps.setString(3, id);
            ps.setString(4, bgFormId);
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new BgActualRecordException(BgActualRecordException.EXISTACROSSBGPERIOD);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
    }

    @Override
    protected IObjectValue _collectActualRecord(Context ctx, IObjectValue info, Hashtable schemeMap, List orgList, int[] parameter) throws BOSException, EASBizException {
        BgFormInfo bgForm = null;
        BgActualRecordInfo bgActual = null;
        KDF kdf = null;
        KDTable table = null;
        Object infoMap = null;
        Object adjustMap = null;
        boolean isBudget = parameter != null && parameter[0] == 1;
        boolean isGatherCell = parameter != null && parameter[1] == 1;
        boolean isGatherEnumErate = parameter != null && parameter[2] == 1;
        boolean isGatherEnumBgItem = parameter != null && parameter[3] == 1;
        boolean isGatherEnumFodian = parameter != null && parameter[4] == 1;
        boolean isGatherAdjust = parameter != null && parameter[5] == 1;
        try {
            IRowSet rs;
            bgActual = (BgActualRecordInfo)info;
            bgForm = bgActual.getBgForm();
            kdf = bgActual.getKDF();
            String bgPeriodId = bgActual.getBgPeriod().getId().toString();
            String bgPeriodLongNumber = bgActual.getBgPeriod().getLongNumber();
            if ((bgPeriodLongNumber == null || bgPeriodLongNumber.trim().length() == 0) && (rs = DbUtil.executeQuery((Context)ctx, (String)"select flongnumber from t_bg_bgperiod where fid = ? ", (Object[])new String[]{bgPeriodId})).next()) {
                bgPeriodLongNumber = rs.getString(1);
            }
            int n = kdf.getAllTable().size();
            for (int i = 0; i < n; ++i) {
                table = (KDTable)kdf.getTableByIndex(i);
                table.getScriptManager().setAutoRun(false);
                table.getScriptManager().setAutoAdjustFormula(true);
                table.setFormulaMode(1);
                if (isGatherEnumErate || isGatherEnumBgItem) {
                    BgFSHelper.updateAliasOfTemp(table);
                }
                this.collectFormDetail(ctx, table, schemeMap, orgList, bgPeriodLongNumber);
            }
            bgActual.setKDF(kdf);
        }
        catch (EASBizException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.OTHERERROR, new String[]{ex.getMessage()});
        }
        finally {
            kdf = null;
        }
        return bgActual;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void collectFormDetail(Context ctx, KDTable table, Hashtable schemeMap, List orgList, String bgPeriodLongNumber) throws BOSException, EASBizException {
        if (schemeMap == null) return;
        if (schemeMap.isEmpty()) {
            return;
        }
        int paramSize = 50;
        String formulaString = null;
        String sql = null;
        String valueString = null;
        String zeroString = "0.00";
        String paramSql = this.getParamSql(paramSize);
        ArrayList<String> _tmpList = new ArrayList<String>();
        sql = "select sum(a.FBizActual) cnt ,a.FFormula  from t_bg_bgactualdata a , t_bg_bgactualrecord b ,t_bg_bgperiod c  where b.fid = a.fbgactualrecordid and b.fbgperiodid = c.fid and  b.fstate=2 and a.FFormula in " + paramSql + " and ( c.flongnumber = ? or c.flongnumber like ? )";
        _tmpList.add(bgPeriodLongNumber);
        _tmpList.add(bgPeriodLongNumber + "!%");
        int index = 0;
        for (String orgId : schemeMap.keySet()) {
            String schemeId = (String)schemeMap.get(orgId);
            if (index == 0) {
                sql = sql + " and ( ( a.FOrgUnitId = ? and a.FBgSchemeId = ? )";
                _tmpList.add(orgId);
                _tmpList.add(schemeId);
            } else {
                sql = sql + " or ( a.FOrgUnitId = ? and a.FBgSchemeId = ? )";
                _tmpList.add(orgId);
                _tmpList.add(schemeId);
            }
            ++index;
        }
        if (schemeMap != null && !schemeMap.isEmpty()) {
            sql = sql + " ) ";
        }
        sql = sql + " group by a.FFormula having sum(a.FBizActual) != 0";
        BigDecimal result = null;
        HashMap<String, ICell> cellMap = new HashMap<String, ICell>();
        ICell cell = null;
        RptCell rptCell = null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sqlBgElement = " select fnumber from t_bg_bgelement where FApportionable = 1";
        HashMap<String, Object> bgElenmentMapCanCollect = new HashMap<String, Object>();
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sqlBgElement);
            rs = ps.executeQuery();
            while (rs.next()) {
                bgElenmentMapCanCollect.put(rs.getString(1), null);
            }
            SQLUtils.cleanup((ResultSet)rs);
            int rowCount = table.getBody().size();
            int colCount = table.getColumnCount();
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    cell = table.getCell(i, j);
                    if (!BgFSHelper.checkHasFormulaCanCollectOfCell(cell, bgElenmentMapCanCollect)) continue;
                    rptCell = (RptCell)cell.getUserObject();
                    formulaString = BgFSHelper.getFormulaOfCell(cell);
                    valueString = cell.getValue() != null ? cell.getValue().toString() : zeroString;
                    cell.setValue((Object)zeroString);
                    rptCell.getItemFormula().putExt("BG_ACTUAL_VALUE", zeroString);
                    cellMap.put(formulaString, cell);
                }
            }
            ps = conn.prepareStatement(sql);
            Vector keysVec = this.getBgitemCombinVec(cellMap, paramSize);
            for (int i2 = 0; i2 < keysVec.size(); ++i2) {
                Vector vec = (Vector)keysVec.get(i2);
                for (int n = 0; n < paramSize; ++n) {
                    String key = (String)vec.get(n);
                    ps.setString(n + 1, key);
                }
                BgNSQLHelper.setParams((PreparedStatement)ps, _tmpList, (int)(paramSize + 1));
                rs = ps.executeQuery();
                while (rs.next()) {
                    result = rs.getBigDecimal(1);
                    if (result == null) {
                        result = BgConstants.BIGZERO;
                    }
                    formulaString = rs.getString(2);
                    ((ICell)cellMap.get(formulaString)).setValue((Object)result.toString());
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
            this.saveCollectInfo(table, false, orgList, schemeMap);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    logger.error((Object)ex2);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
    }

    protected void saveCollectInfo(KDTable table, boolean isAdjust, List orgUnitList, Hashtable bgSchemeMap) {
        if (orgUnitList == null || orgUnitList.isEmpty()) {
            return;
        }
        if (bgSchemeMap == null || bgSchemeMap.isEmpty()) {
            return;
        }
        String[] orgUnitId = null;
        String[] bgSchemeId = null;
        if (!orgUnitList.isEmpty()) {
            OrgUnitInfo orgInfo = null;
            orgUnitId = new String[orgUnitList.size()];
            int n = orgUnitList.size();
            for (int i = 0; i < n; ++i) {
                orgInfo = (OrgUnitInfo)orgUnitList.get(i);
                orgUnitId[i] = orgInfo.getId().toString() + "_" + orgInfo.getName();
            }
        }
        if (!bgSchemeMap.isEmpty()) {
            int index = 0;
            String orgId2 = null;
            bgSchemeId = new String[bgSchemeMap.size()];
            for (String orgId2 : bgSchemeMap.keySet()) {
                bgSchemeId[index++] = orgId2 + "_" + (String)bgSchemeMap.get(orgId2);
            }
        }
        Map aliasMap = null;
        if (table.getUserObject() != null && table.getUserObject() instanceof HashMap) {
            aliasMap = (Map)table.getUserObject();
            aliasMap.put("IS_COLLECT_ADJUST", new Boolean(isAdjust));
            aliasMap.put("COLLECT_ORGUNIT", orgUnitId);
            aliasMap.put("COLLECT_SCHEME", bgSchemeId);
        }
    }

    private String getParamSql(int paramSize) {
        String sql = " ( ";
        if (paramSize <= 0) {
            return "";
        }
        for (int i = 0; i < paramSize; ++i) {
            sql = sql + " ? ,";
        }
        sql = sql.substring(0, sql.length() - 1);
        sql = sql + " ) ";
        return sql;
    }

    private Vector getBgitemCombinVec(Map cellMap, int GROUPSIZE) {
        int h = 0;
        String noFind = "#";
        Vector keysVec = new Vector();
        Vector<String> keyVec = null;
        Iterator it = cellMap.keySet().iterator();
        while (it.hasNext()) {
            if (h == 0) {
                keyVec = new Vector<String>();
            }
            String key = (String)it.next();
            if (keyVec != null) {
                keyVec.add(key);
            }
            if (++h != GROUPSIZE) continue;
            h = 0;
            keysVec.add(keyVec);
        }
        if (keyVec != null && keyVec.size() != GROUPSIZE) {
            for (int i = keyVec.size(); i < GROUPSIZE; ++i) {
                keyVec.add(noFind);
            }
            keysVec.add(keyVec);
        }
        return keysVec;
    }

    @Override
    protected IObjectValue _getActualRecordCollectValue(Context ctx, IObjectPK pk, SelectorItemCollection sic, Hashtable schemeMap, List orgList, int[] parameter) throws BOSException, EASBizException {
        BgActualRecordInfo value = this.getBgActualRecordInfo(ctx, pk, sic);
        return this._collectActualRecord(ctx, (IObjectValue)value, schemeMap, orgList, parameter);
    }

    @Override
    protected void _saveFromPeriodDeco(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        BgActualRecordInfo actual = (BgActualRecordInfo)info;
        IBgActualRecordFacade iActual = BgActualRecordFacadeFactory.getLocalInstance(ctx);
        String bgFormId = actual.getBgForm().getId().toString();
        Hashtable bgActualMap = this.getNumValue(ctx, actual);
        Hashtable bgPeriodMap = iActual.getBgPeridMapFromBgForm(bgFormId, bgActualMap);
        String bgActualRecordId = actual.getId().toString();
        iActual.writeBgActual(bgFormId, bgActualMap, bgPeriodMap, bgActualRecordId);
    }
}

