/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgActualRecordException;
import com.kingdee.eas.ma.budget.BgCtrlRecordCollection;
import com.kingdee.eas.ma.budget.BgCtrlRecordInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTraceTypeEnum;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.app.AbstractBgActualRecordFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgActualRecordFacadeControllerBean
extends AbstractBgActualRecordFacadeControllerBean {
    private static final long serialVersionUID = 3161731527723382064L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgActualRecordFacadeControllerBean");

    @Override
    protected void _writeBgActual(Context ctx, String bgFormId, Hashtable bgActualMap, Hashtable bgPeriodMap, String bgActualRecordID) throws BOSException, EASBizException {
        String orgUnitId = null;
        String bgSchemeId = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select forgunitid , fbgschemeid from t_bg_bgform where fid = '" + bgFormId + "'"));
        try {
            if (rs.next()) {
                orgUnitId = rs.getString(1);
                bgSchemeId = rs.getString(2);
            }
        }
        catch (SQLException e) {
            logger.debug((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (orgUnitId != null && bgSchemeId != null) {
            this._writeBgActual(ctx, orgUnitId, bgSchemeId, bgActualMap, bgPeriodMap, bgActualRecordID);
        }
    }

    @Override
    protected void _writeBgActual(Context ctx, String orgUnitId, String bgSchemeId, Hashtable bgActualMap, Hashtable bgPeriodMap, String bgActualRecordId) throws BOSException, EASBizException {
        this._deleteBgActual(ctx, bgActualRecordId);
        int batchNum = 100;
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(400);
            strBuffer.append("insert into t_bg_bgactualdata(fid,forgunitid,fbgschemeid,fbgactualrecordid,fbizactual,fformula,fbgperiodid) values(?,?,?,?,?,?,?) ");
            ps = connection.prepareStatement(strBuffer.toString());
            int count = 0;
            Iterator it = bgActualMap.keySet().iterator();
            while (it.hasNext()) {
                String id = BOSUuid.create((String)"BgActual").toString();
                String fformula = (String)it.next();
                BigDecimal bizActual = (BigDecimal)bgActualMap.get(fformula);
                String bgPeriodId = (String)bgPeriodMap.get(fformula);
                ps.setString(1, id);
                ps.setString(2, orgUnitId);
                ps.setString(3, bgSchemeId);
                ps.setString(4, bgActualRecordId);
                ps.setBigDecimal(5, bizActual);
                ps.setString(6, fformula);
                ps.setString(7, bgPeriodId);
                ps.addBatch();
                if (++count < batchNum) continue;
                ps.executeBatch();
                count = 0;
            }
            if (count != 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    @Override
    protected Hashtable _getBgPeridMapFromBgForm(Context ctx, String bgFormId, Hashtable bgFormulaMap) throws BOSException, EASBizException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String orgUnitId = null;
        String bgSchemeId = null;
        if (bgFormulaMap != null && !bgFormulaMap.isEmpty()) {
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement("select forgunitid , fbgschemeid from t_bg_bgform where fid = ?");
                pstmt.setString(1, bgFormId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    orgUnitId = rs.getString(1);
                    bgSchemeId = rs.getString(2);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                int SQL_COUNT = 200;
                StringBuffer sql = new StringBuffer("select fformula,fbgperiodid from t_bg_bgdata where forgunitid = ? and fbgschemeid = ? and fformula in (");
                BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
                pstmt = conn.prepareStatement(sql.toString());
                Object[] params = bgFormulaMap.keySet().toArray();
                int batch_count = (params.length - 1) / 200 + 1;
                for (int i = 0; i < batch_count; ++i) {
                    pstmt.setString(1, orgUnitId);
                    pstmt.setString(2, bgSchemeId);
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)3, (int)i, (int)200, (Object[])params);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        result.put(rs.getString(1), rs.getString(2));
                    }
                    SQLUtils.cleanup((ResultSet)rs);
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        return result;
    }

    @Override
    protected void _deleteBgActual(Context ctx, String bgActualRecordId) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)("delete from t_bg_bgactualdata where fbgactualrecordid = '" + bgActualRecordId + "'"));
    }

    @Override
    protected void _auditBgActual(Context ctx, String bgActualRecordId, String bgFormID) throws BOSException, EASBizException {
        String orgUnitId = null;
        String bgSchemeId = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)"select forgunitid , fbgschemeid from t_bg_bgform where fid = ? ", (Object[])new String[]{bgFormID});
            if (rs.next()) {
                orgUnitId = rs.getString(1);
                bgSchemeId = rs.getString(2);
            }
        }
        catch (SQLException e) {
            try {
                logger.debug((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        if (orgUnitId != null && bgSchemeId != null) {
            this._auditBgActual(ctx, bgActualRecordId, orgUnitId, bgSchemeId);
        }
    }

    @Override
    protected void _auditBgActual(Context ctx, String bgActualRecordId, String orgUnitId, String bgSchemeId) throws BOSException, EASBizException {
        String sql0 = "select fstate from t_bg_bgactualrecord where fid = ?";
        String sql1 = "select fformula,fbizactual from t_bg_bgactualdata where fbgactualrecordid = ?";
        String sql2 = "update t_bg_bgdata set fbizactual = fbizactual + ? where fformula = ? and forgunitid = ? and fbgschemeid = ?";
        String sql3 = "update t_bg_bgactualrecord set fstate = 2,FAuditorID=?,fauditedtime=? where fid = ?";
        IRowSet rs0 = null;
        IRowSet rs1 = null;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            int state;
            rs0 = DbUtil.executeQuery((Context)ctx, (String)sql0, (Object[])new String[]{bgActualRecordId});
            if (rs0.next() && (state = rs0.getInt(1)) != 1) {
                SQLUtils.cleanup((ResultSet)rs0);
                throw new BgActualRecordException(BgActualRecordException.HASAUDITED);
            }
            rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{bgActualRecordId});
            while (rs1.next()) {
                map.put(rs1.getString(1), rs1.getBigDecimal(2));
            }
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql2);
            for (String fformula : map.keySet()) {
                BigDecimal bizActual = (BigDecimal)map.get(fformula);
                ps.setBigDecimal(1, bizActual);
                ps.setString(2, fformula);
                ps.setString(3, orgUnitId);
                ps.setString(4, bgSchemeId);
                ps.addBatch();
            }
            ps.executeBatch();
            String auditorId = ctx.getCaller().toString();
            Timestamp auditorTime = new Timestamp(new java.util.Date().getTime());
            DbUtil.execute((Context)ctx, (String)sql3, (Object[])new Object[]{auditorId, auditorTime, bgActualRecordId});
            this.updateBgActualData(ctx, map, orgUnitId, bgSchemeId);
            map.clear();
            this._writeBgCtrlRecord(ctx, bgActualRecordId);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs0);
                SQLUtils.cleanup(rs1);
                SQLUtils.cleanup(ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs0);
        SQLUtils.cleanup((ResultSet)rs1);
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void updateBgActualData(Context ctx, Map formulaMap, String orgUnitId, String bgSchemeId) throws BOSException, EASBizException {
        HashMap<String, String> bgDataIdMap = new HashMap<String, String>();
        Object[] params = null;
        if (formulaMap != null && !formulaMap.isEmpty()) {
            params = formulaMap.keySet().toArray();
        }
        formulaMap.clear();
        StringBuffer sqlSelect = new StringBuffer("select a.fid, a.fformula, b.fkey from t_bg_bgdata a ,t_bg_bgitemcombination b ").append(" where a.fbgitemcombinid = b.fid and a.forgunitid = ? and a.fbgschemeid = ? and a.fformula in (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sqlSelect, (int)200).append(")");
        String sql2 = "update t_bg_bgactualdata set fbgdataid = ? , fbgitemname = ?  where fformula = ? and forgunitid = ? and fbgschemeid = ?";
        ResultSet rs = null;
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            if (params != null && params.length > 0) {
                ps = connection.prepareStatement(sqlSelect.toString());
                int batchCount = (params.length - 1) / 200 + 1;
                for (int i = 0; i < batchCount; ++i) {
                    ps.setString(1, orgUnitId);
                    ps.setString(2, bgSchemeId);
                    BgNSQLHelper.setParam4Batch((PreparedStatement)ps, (int)3, (int)i, (int)200, (Object[])params);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        bgDataIdMap.put(rs.getString(1), rs.getString(3));
                        formulaMap.put(rs.getString(1), rs.getString(2));
                    }
                    SQLUtils.cleanup((ResultSet)rs);
                }
                SQLUtils.cleanup(rs, (Statement)ps);
                params = null;
            }
            Map bgItemNameMap = this.getBgCombinItemNameMapByBgData(ctx, bgDataIdMap, orgUnitId);
            bgDataIdMap.clear();
            ps = connection.prepareStatement(sql2);
            for (String bgDataId : bgItemNameMap.keySet()) {
                String itemName = (String)bgItemNameMap.get(bgDataId);
                String formula = (String)formulaMap.get(bgDataId);
                ps.setString(1, bgDataId);
                ps.setString(2, itemName);
                ps.setString(3, formula);
                ps.setString(4, orgUnitId);
                ps.setString(5, bgSchemeId);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps, (Connection)connection);
    }

    @Override
    protected void _unAuditBgActual(Context ctx, String bgActualRecordId, String bgFormId) throws BOSException, EASBizException {
        String orgUnitId = null;
        String bgSchemeId = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select forgunitid , fbgschemeid from t_bg_bgform where fid = '" + bgFormId + "'"));
        try {
            if (rs.next()) {
                orgUnitId = rs.getString(1);
                bgSchemeId = rs.getString(2);
            }
        }
        catch (SQLException e) {
            logger.debug((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (orgUnitId != null && bgSchemeId != null) {
            this._unAuditBgActual(ctx, bgActualRecordId, orgUnitId, bgSchemeId);
        }
    }

    @Override
    protected void _unAuditBgActual(Context ctx, String bgActualRecordId, String orgUnitId, String bgSchemeId) throws BOSException, EASBizException {
        String sql0 = "select fstate from t_bg_bgactualrecord where fid = ?";
        String sql1 = "select fformula,fbizactual from t_bg_bgactualdata where fbgactualrecordid = ?";
        String sql2 = "update t_bg_bgdata set fbizactual = fbizactual - ? where fformula = ? and forgunitid = ? and fbgschemeid = ?";
        String sql3 = "update t_bg_bgactualrecord set fstate = 1,FAuditorID='',fauditedtime = null where fid = ?";
        String sql4 = "delete from t_bg_bgctrlrecord where fbillid = ? ";
        IRowSet rs0 = DbUtil.executeQuery((Context)ctx, (String)sql0, (Object[])new String[]{bgActualRecordId});
        IRowSet rs1 = null;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        int totalCount = 500;
        int startCount = 0;
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            int state;
            if (rs0.next() && (state = rs0.getInt(1)) != 2) {
                SQLUtils.cleanup((ResultSet)rs0);
                throw new BgActualRecordException(BgActualRecordException.HASUNAUDITED);
            }
            rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{bgActualRecordId});
            while (rs1.next()) {
                map.put(rs1.getString(1), rs1.getBigDecimal(2));
            }
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql2);
            for (String fformula : map.keySet()) {
                BigDecimal bizActual = (BigDecimal)map.get(fformula);
                ps.setBigDecimal(1, bizActual);
                ps.setString(2, fformula);
                ps.setString(3, orgUnitId);
                ps.setString(4, bgSchemeId);
                ps.addBatch();
                if (++startCount != totalCount) continue;
                ps.executeBatch();
                startCount = 0;
            }
            if (startCount > 0) {
                ps.executeBatch();
            }
            DbUtil.execute((Context)ctx, (String)sql3, (Object[])new String[]{bgActualRecordId});
            DbUtil.execute((Context)ctx, (String)sql4, (Object[])new String[]{bgActualRecordId});
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rs0);
                SQLUtils.cleanup(rs1);
                SQLUtils.cleanup(ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs0);
        SQLUtils.cleanup((ResultSet)rs1);
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private Map getBgCombinItemNameMapByBgData(Context ctx, Map bgDataIDMap, String orgUnitId) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuffer sql1 = new StringBuffer(" select b.fid ,a.fkey from t_bg_bgitemcombination a ,t_bg_bgdata b ").append("where a.fid = b.fbgitemcombinid and b.fid in (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql1, (int)200).append(")");
        String sql = " select fname_" + ctx.getLocale() + " from t_bg_bgitem where fnumber = ? and forgunitid = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            if (bgDataIDMap != null && !bgDataIDMap.isEmpty()) {
                ps = conn.prepareStatement(sql1.toString());
                Object[] params = bgDataIDMap.keySet().toArray();
                int batchCount = (params.length - 1) / 200 + 1;
                for (int i = 0; i < batchCount; ++i) {
                    BgNSQLHelper.setParam4Batch((PreparedStatement)ps, (int)i, (int)200, (Object[])params);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result.put(rs.getString(1), rs.getString(2));
                    }
                    SQLUtils.cleanup((ResultSet)rs);
                }
                SQLUtils.cleanup(rs, (Statement)ps);
            }
            HashMap<String, String> temp = new HashMap<String, String>();
            ps = conn.prepareStatement(sql);
            ps.setString(2, BgSHelper.getIsolateOrg(ctx, orgUnitId));
            for (String id : result.keySet()) {
                String key = (String)result.get(id);
                String[] strs = key.split("_");
                String nameStr = "";
                for (int i = 0; i < strs.length; ++i) {
                    String name = "";
                    String number = strs[i];
                    if (temp.containsKey(number)) {
                        name = (String)temp.get(number);
                    } else {
                        ps.setString(1, number);
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            name = rs.getString(1);
                        }
                        temp.put(number, name);
                        SQLUtils.cleanup((ResultSet)rs);
                    }
                    nameStr = nameStr + name + "_";
                }
                nameStr = nameStr.substring(0, nameStr.length() - 1);
                result.put(id, nameStr);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
        return result;
    }

    @Override
    protected void _writeBgCtrlRecord(Context ctx, String bgActualRecordId) throws BOSException, EASBizException {
        String sql1 = " select a.fname, a.fnumber ,a.flastupdatetime ,a.FIsEditByPeriod, b.Fnumber from t_bg_bgactualrecord a left join T_bg_bgperiod b on a.FbgPeriodId = b.fid where a.fid = ?";
        String sql2 = " select a.fbizactual, a.fbgdataid, a.fbgitemname, b.fnumber, a.fOrgUnitId  from t_bg_bgactualdata a ,t_bg_bgperiod b  where a.fbgperiodid = b.fid and a.fbgactualrecordid = ?";
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{bgActualRecordId});
        IRowSet rs2 = null;
        String billName = "";
        String billNumber = "";
        Date date = null;
        String periodNumber = null;
        int isEditByPeriod = 0;
        try {
            if (rs1.next()) {
                billName = rs1.getString(1);
                billNumber = rs1.getString(2);
                date = rs1.getDate(3);
            }
            periodNumber = rs1.getString(5);
            isEditByPeriod = rs1.getInt(4);
            rs2 = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new String[]{bgActualRecordId});
            BgCtrlRecordCollection ctrlRecordCol = new BgCtrlRecordCollection();
            while (rs2.next()) {
                BigDecimal bizActual = rs2.getBigDecimal(1);
                String bgDataId = rs2.getString(2);
                String bgItemName = rs2.getString(3);
                String bgPeriodNumber = rs2.getString(4);
                String orgunitId = rs2.getString("FOrgUnitId");
                BgCtrlRecordInfo bgCtrlRecordInfo = new BgCtrlRecordInfo();
                bgCtrlRecordInfo.setBgDataId(bgDataId);
                if (bizActual != null && bizActual.floatValue() == 0.0f) continue;
                bgCtrlRecordInfo.setActualAmount(bizActual);
                bgCtrlRecordInfo.setBillId(bgActualRecordId);
                bgCtrlRecordInfo.setBillName(billName);
                bgCtrlRecordInfo.setBillNumber(billNumber);
                String billType = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgActualResource", (String)"bgActualAddType", (Locale)ctx.getLocale());
                bgCtrlRecordInfo.setBillType(billType);
                bgCtrlRecordInfo.setBizDate(date);
                bgCtrlRecordInfo.setBgPeriodId(bgPeriodNumber);
                bgCtrlRecordInfo.setItemName(bgItemName);
                bgCtrlRecordInfo.setBillSourceOrgunitID(orgunitId);
                bgCtrlRecordInfo.setBgTraceType(BgTraceTypeEnum.BgActual);
                if (isEditByPeriod == 1 && BgNPeriodHelper.parserBgPeriodType((String)periodNumber) == 7) {
                    bgCtrlRecordInfo.setDayDate(BgPeriodHelper.getDay(periodNumber));
                } else if (isEditByPeriod == 1 && BgNPeriodHelper.parserBgPeriodType((String)periodNumber) != 7) {
                    bgCtrlRecordInfo.setDayDate(BgPeriodHelper.getDay(bgPeriodNumber));
                } else if (isEditByPeriod == 0 && BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNumber) == 7) {
                    bgCtrlRecordInfo.setDayDate(BgPeriodHelper.getDay(bgPeriodNumber));
                } else if (isEditByPeriod == 0 && BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNumber) != 7) {
                    bgCtrlRecordInfo.setDayDate(BgPeriodHelper.getDay(periodNumber));
                }
                ctrlRecordCol.add(bgCtrlRecordInfo);
            }
            if (ctrlRecordCol.size() > 0) {
                BgActualRecordFacadeControllerBean.addNewCtrlRecord(ctx, ctrlRecordCol);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rs1);
                SQLUtils.cleanup(rs2);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs1);
        SQLUtils.cleanup((ResultSet)rs2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addNewCtrlRecord(Context ctx, BgCtrlRecordCollection ctrlRecordCol) throws BOSException, EASBizException {
        StringBuffer kSql = new StringBuffer();
        kSql.append(" insert into T_BG_BgCtrlRecord");
        kSql.append("   (FId,");
        kSql.append("    FCreatorId,");
        kSql.append("    FCreateTime,");
        kSql.append("    FLastUpdateUserId,");
        kSql.append("    FLastUpdateTime,");
        kSql.append("    FControlUnitId,");
        kSql.append("    FBgDataId,");
        kSql.append("    FBillId,");
        kSql.append("    FBillName,");
        kSql.append("    FBillNumber,");
        kSql.append("    FBillAlias,");
        kSql.append("    FBillType,");
        kSql.append("    FBizDate,");
        kSql.append("    FActualAmount,");
        kSql.append("    FBillOperate,");
        kSql.append("    FBgPeriodId,");
        kSql.append("    FItemName,");
        kSql.append("    FBgTraceType,");
        kSql.append("    FOrgUnitId,");
        kSql.append("    FBgSchemeId,");
        kSql.append("    FItemFormula,");
        kSql.append("    FPayState,");
        kSql.append("    FISCollected,");
        kSql.append("    FDayDate, ");
        kSql.append("    FBillSourceOrgUnitId)");
        kSql.append(" values (newbosid('FF6153C2'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx) != null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : "";
        Date time = new Date(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(kSql.toString());
            int batchCounter = 0;
            boolean isRun = false;
            for (int i = 0; i < ctrlRecordCol.size(); ++i) {
                BgCtrlRecordInfo info = ctrlRecordCol.get(i);
                statement.setString(1, userId);
                statement.setDate(2, time);
                statement.setString(3, userId);
                statement.setDate(4, time);
                statement.setString(5, info.getOrgUnitId());
                statement.setString(6, info.getBgDataId());
                statement.setString(7, info.getBillId());
                statement.setString(8, info.getBillName());
                statement.setString(9, info.getBillNumber());
                statement.setString(10, info.getBillAlias());
                statement.setString(11, info.getBillType());
                statement.setDate(12, info.getBizDate() != null ? new Date(info.getBizDate().getTime()) : null);
                statement.setBigDecimal(13, info.getActualAmount());
                statement.setString(14, info.getBillOperate());
                statement.setString(15, info.getBgPeriodId());
                statement.setString(16, info.getItemName());
                statement.setInt(17, info.getBgTraceType().getValue());
                statement.setString(18, info.getOrgUnitId());
                statement.setString(19, info.getBgSchemeId());
                statement.setString(20, info.getItemFormula());
                statement.setInt(21, 0);
                statement.setInt(22, 1);
                statement.setDate(23, info.getDayDate() != null ? new Date(info.getDayDate().getTime()) : null);
                statement.setString(24, info.getBillSourceOrgunitID());
                statement.addBatch();
                isRun = true;
                if (++batchCounter < 200) continue;
                statement.executeBatch();
                batchCounter = 0;
            }
            if (isRun && batchCounter != 0) {
                statement.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    @Override
    protected IObjectCollection _getBgPeriodFromBgForm(Context ctx, String bgFormId) throws BOSException, EASBizException {
        String sql = "select distinct fbgperiodid from t_bg_bgdata where fbgformid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bgFormId});
        HashSet<String> bgPeriodIdSet = new HashSet<String>();
        try {
            while (rs.next()) {
                bgPeriodIdSet.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bgPeriodIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("longNumber"));
        IBgPeriod iPeriod = BgPeriodFactory.getLocalInstance(ctx);
        BgPeriodCollection coll = iPeriod.getBgPeriodCollection(view);
        return coll;
    }

    @Override
    protected boolean _checkDupNumber(Context ctx, String bgActualRecordId, String number) throws BOSException, EASBizException {
        boolean result = false;
        if (bgActualRecordId != null && bgActualRecordId.equals("")) {
            bgActualRecordId = "xxx";
        }
        if (bgActualRecordId == null || bgActualRecordId.toString().length() == 0) {
            bgActualRecordId = "xxx";
        }
        if (number == null || number.toString().length() == 0) {
            return false;
        }
        String sql = "select count(fid) cnt from t_bg_bgActualRecord where fid != ? and fnumber = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bgActualRecordId, number});
        try {
            int cnt;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected boolean _checkCanInputActual(Context ctx, String bgActualRecordId, String bgFormId, String bgPeriodId) throws BOSException, EASBizException {
        boolean result = true;
        if (bgActualRecordId != null && bgActualRecordId.equals("")) {
            bgActualRecordId = "xxx";
        }
        String sql = "select count(fid) cnt from t_bg_bgActualRecord where fid!=? and fbgformid = ? and fbgperiodId = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bgActualRecordId, bgFormId, bgPeriodId});
        try {
            int cnt;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _getCollectData(Context ctx, String formula, List mapInfo, String bgPeriodId) throws BOSException, EASBizException {
        ArrayList<String[]> reInfo = new ArrayList<String[]>();
        if (mapInfo == null) return reInfo;
        if (mapInfo.isEmpty()) return reInfo;
        if (formula == null) return reInfo;
        if (formula.trim().length() == 0) {
            return reInfo;
        }
        String noFindStr = "#";
        String bgFormId2222 = null;
        String[] mapStr = null;
        String[] parameter = null;
        List formulaHint = null;
        FormulaHint formulas = null;
        int index = 0;
        int n = 0;
        int batchNum = 10;
        int size = mapInfo.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fperiodType, flongnumber, fbegindate, fenddate   from t_bg_bgperiod where fid = ? ", (Object[])new String[]{bgPeriodId});
        int periodType = -1;
        String bgPeriodLongNumber = null;
        Date beginDate = null;
        Date endDate = null;
        try {
            if (rs.next()) {
                periodType = rs.getInt(1);
                bgPeriodLongNumber = rs.getString(2);
                beginDate = rs.getDate(3);
                endDate = rs.getDate(4);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, String> orgUnitMap = new HashMap<String, String>();
        HashMap tmpValueMap = new HashMap();
        n = mapInfo.size();
        for (index = 0; index < n; ++index) {
            mapStr = (String[])mapInfo.get(index);
            if (orgUnitMap.containsKey(mapStr[0])) continue;
            orgUnitMap.put(mapStr[0], mapStr[1]);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer(1024);
        if (periodType == 8) {
            if (beginDate == null) throw new NullPointerException("beginDate is null OR endDate is null!");
            if (endDate == null) {
                throw new NullPointerException("beginDate is null OR endDate is null!");
            }
            int year1 = beginDate.getYear() + 1900;
            int year2 = endDate.getYear() + 1900;
            String periodLongStr = "('" + bgPeriodLongNumber + "' ";
            for (int i = year1; i <= year2; ++i) {
                periodLongStr = periodLongStr + " , '" + i + "Y'";
            }
            periodLongStr = periodLongStr + ")";
            sql.append("select a.FBizActual, a.FOrgUnitId, a.FBgActualRecordId  from t_bg_bgactualdata a ,t_bg_bgactualrecord b ,t_bg_bgperiod d  where a.fbgactualrecordid = b.fid   and b.fbgperiodid = d.fid and b.fstate = 2  and a.FFormula = ? AND ( d.flongnumber in " + periodLongStr + " ) and (");
        } else {
            sql.append("select a.FBizActual, a.FOrgUnitId, a.FBgActualRecordId  from t_bg_bgactualdata a ,t_bg_bgactualrecord b ,t_bg_bgperiod d  where a.fbgactualrecordid = b.fid   and b.fbgperiodid = d.fid and b.fstate = 2  and a.FFormula = ? AND ( d.flongnumber = ? or d.flongnumber like ? ) and (");
        }
        for (index = 1; index < batchNum; ++index) {
            sql.append("(a.FORGUNITID = ? AND a.FBGSCHEMEID = ?) OR ");
        }
        sql.append("(a.FORGUNITID = ? AND a.FBGSCHEMEID = ?)) order by a.FORGUNITID");
        try {
            try {
                formulaHint = TableToolkit.parseFormula((String)formula, (boolean)false);
            }
            catch (ParserException ex) {
                logger.error((Object)ex.getMessage());
            }
            if (formulaHint != null) {
                formulas = (FormulaHint)formulaHint.get(0);
                parameter = formulas.getParams();
            }
            int decimal = 10;
            if (parameter != null && parameter[5] != null && parameter[5].trim() != null && parameter[5].trim().length() > 0) {
                ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                if (icurrency == null) {
                    throw new BgException(BgException.NOINSTANCE);
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)parameter[5], CompareType.EQUALS));
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("precision"));
                view.getSelector().addObjectCollection((IObjectCollection)sic);
                CurrencyCollection col = icurrency.getCurrencyCollection(view);
                if (col != null && !col.isEmpty()) {
                    decimal = col.get(0).getPrecision();
                }
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k;
                pstmt.setString(1, formula);
                if (periodType != 8) {
                    pstmt.setString(2, bgPeriodLongNumber);
                    pstmt.setString(3, bgPeriodLongNumber + "!%");
                    for (k = 1; k <= batchNum; ++k, ++pos) {
                        if (pos < size) {
                            mapStr = (String[])mapInfo.get(pos);
                            pstmt.setString(k * 2 + 2, mapStr[0]);
                            pstmt.setString(k * 2 + 3, mapStr[2]);
                            continue;
                        }
                        pstmt.setString(k * 2 + 2, noFindStr);
                        pstmt.setString(k * 2 + 3, noFindStr);
                    }
                } else {
                    for (k = 1; k <= batchNum; ++k, ++pos) {
                        if (pos < size) {
                            mapStr = (String[])mapInfo.get(pos);
                            pstmt.setString((k - 1) * 2 + 2, mapStr[0]);
                            pstmt.setString((k - 1) * 2 + 3, mapStr[2]);
                            continue;
                        }
                        pstmt.setString((k - 1) * 2 + 2, noFindStr);
                        pstmt.setString((k - 1) * 2 + 3, noFindStr);
                    }
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    mapStr = new String[3];
                    mapStr[0] = (String)orgUnitMap.get(rst.getString("FOrgUnitId"));
                    if (mapStr[0] == null) {
                        mapStr[0] = rst.getString("FOrgUnitId");
                    }
                    mapStr[1] = rst.getBigDecimal("FBizActual").setScale(decimal, 4).toString();
                    mapStr[2] = rst.getString("FBgActualRecordId");
                    reInfo.add(mapStr);
                }
                SQLUtils.cleanup((ResultSet)rst);
                if (tmpValueMap.isEmpty()) continue;
                for (String bgFormId2222 : tmpValueMap.keySet()) {
                    mapStr = (String[])tmpValueMap.get(bgFormId2222);
                    reInfo.add(mapStr);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    logger.error((Object)ex2);
                    throw ex2;
                }
                catch (BOSException ex3) {
                    logger.error((Object)ex3);
                    throw ex3;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return reInfo;
    }

    @Override
    protected Map _filterBgActualCollectInfo(Context ctx, BOSUuid bgFormId, Map info, BOSUuid bgActualBgPeriodId) throws BOSException, EASBizException {
        if (bgFormId == null || info == null || info.isEmpty()) {
            return new HashMap();
        }
        BgFormInfo CollectInfo = this.getCollectFormInfo(ctx, bgFormId);
        BOSUuid bgSchemeId = CollectInfo.getBgScheme().getRootId();
        BOSUuid bgTemplateId = CollectInfo.getBgTemplate().getRootId();
        BOSUuid bgPeriodId = CollectInfo.getBgPeriod().getId();
        BOSUuid currencyId = CollectInfo.getCurrency().getId();
        Map filterMap = null;
        Map childBgSchemeMap = null;
        Map childBgTempalteMap = null;
        try {
            childBgSchemeMap = this.getChildBgSchemeMap(ctx, bgSchemeId, info, false);
            childBgTempalteMap = this.getChildBgTemplateMap(ctx, bgTemplateId, info, false);
            filterMap = this.filterCollectInfo(ctx, childBgSchemeMap, childBgTempalteMap, info, bgPeriodId, currencyId, bgActualBgPeriodId.toString());
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        return filterMap;
    }

    private BgFormInfo getCollectFormInfo(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        if (bgFormId == null) {
            throw new BgException(BgException.CHECKBLANK, new String[]{"id"});
        }
        ObjectUuidPK pk = null;
        IBgForm ibgForm = null;
        BgFormInfo bgFormInfo = null;
        try {
            pk = new ObjectUuidPK(bgFormId);
            ibgForm = BgFormFactory.getLocalInstance(ctx);
            if (!ibgForm.exists((IObjectPK)pk)) {
                throw new BgException(BgException.NOOBJECT);
            }
            bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)pk, this.getBgFormSelectors());
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        return bgFormInfo;
    }

    private SelectorItemCollection getBgFormSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("bgScheme.id");
        sic.add("bgScheme.rootId");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.rootId");
        sic.add("bgPeriod.id");
        sic.add("currency.id");
        sic.add("state");
        return sic;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getChildBgSchemeMap(Context ctx, BOSUuid bgSchemeId, Map orgUnitMap, boolean self) throws BOSException, EASBizException {
        if (ctx == null) return new HashMap();
        if (bgSchemeId == null) {
            return new HashMap();
        }
        HashMap<String, String> bgSchemeMap = new HashMap<String, String>();
        ArrayList<String> _tmpList = new ArrayList<String>();
        BOSUuid orgUnitId2222222 = null;
        String childBgSchemeId = null;
        String childOrgUnitId = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FOrgUnitID from T_BG_BgScheme where FROOTID = ?");
        if (!self) {
            sql.append(" and FID <> ?");
            _tmpList.add(bgSchemeId.toString());
        }
        if (orgUnitMap != null && !orgUnitMap.isEmpty()) {
            StringBuffer orgStr = new StringBuffer();
            orgStr.append(" and FOrgUnitID in (");
            for (BOSUuid orgUnitId2222222 : orgUnitMap.keySet()) {
                orgStr.append("?,");
                _tmpList.add(orgUnitId2222222.toString());
            }
            orgStr.delete(orgStr.length() - 1, orgStr.length());
            orgStr.append(")");
            sql.append(orgStr);
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeId.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList, (int)2);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                childBgSchemeId = rst.getString(1);
                childOrgUnitId = rst.getString(2);
                bgSchemeMap.put(childBgSchemeId, childOrgUnitId);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    logger.error((Object)ex2);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgSchemeMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getChildBgTemplateMap(Context ctx, BOSUuid bgTemplateId, Map orgUnitMap, boolean self) throws BOSException, EASBizException {
        if (ctx == null) return new HashMap();
        if (bgTemplateId == null) {
            return new HashMap();
        }
        HashMap<String, String> bgTemplateMap = new HashMap<String, String>();
        ArrayList<String> _tmpList = new ArrayList<String>();
        BOSUuid orgUnitId2222222 = null;
        String childBgTemplateId = null;
        String childTemSchemeId = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FBgSchemeId, t.FBgTemplateId from T_BG_BgSchemeNode t left outer join T_BG_BgScheme s on t.FBgSchemeId = s.FId where t.FBgTemplateId in (select a.FID from T_BG_BgTemplate a where a.FRootId = ?");
        if (!self) {
            sql.append(" and a.FID <> ? ");
            _tmpList.add(bgTemplateId.toString());
        }
        sql.append(")");
        if (orgUnitMap != null && !orgUnitMap.isEmpty()) {
            StringBuffer orgStr = new StringBuffer();
            orgStr.append(" and s.FOrgUnitID in (");
            for (BOSUuid orgUnitId2222222 : orgUnitMap.keySet()) {
                orgStr.append("?,");
                _tmpList.add(orgUnitId2222222.toString());
            }
            orgStr.delete(orgStr.length() - 1, orgStr.length());
            orgStr.append(")");
            sql.append(orgStr);
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgTemplateId.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList, (int)2);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                childTemSchemeId = rst.getString(1);
                childBgTemplateId = rst.getString(2);
                bgTemplateMap.put(childTemSchemeId, childBgTemplateId);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    logger.error((Object)ex2);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgTemplateMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map filterCollectInfo(Context ctx, Map bgSchemeMap, Map bgTemplateMap, Map orgUnitMap, BOSUuid bgPeriodId, BOSUuid currencyId, String bgActualBgPeriodId) throws BOSException, EASBizException {
        if (ctx == null) return new HashMap();
        if (bgSchemeMap == null) return new HashMap();
        if (bgTemplateMap == null) return new HashMap();
        if (orgUnitMap == null) return new HashMap();
        if (bgSchemeMap.isEmpty()) return new HashMap();
        if (bgTemplateMap.isEmpty()) {
            return new HashMap();
        }
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        ArrayList<Object> _tmpList1 = new ArrayList<Object>();
        boolean isFilter = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String bgFormId = null;
        String bgSchemeId2222222 = null;
        String bgTemplateId = null;
        String orgUnitId = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sql1 = new StringBuffer();
        sql.append("select a.FID, a.FOrgUnitId, a.FBgSchemeId, a.FBgTemplateId  from T_BG_BgForm a ,t_bg_bgactualrecord b ,t_bg_bgperiod c where a.fid = b.fbgformid and b.fbgperiodid = c.fid  and (c.Flongnumber = ? or c.flongnumber like ? ) and (a.FBgPeriodID = ?) and (a.FCurrencyID = ?)");
        sql.append(" and (a.FSTATE = ? ) and (b.FSTATE = ?) and (");
        _tmpList1.add(bgPeriodId.toString());
        _tmpList1.add(currencyId.toString());
        _tmpList1.add(new Integer(2));
        _tmpList1.add(new Integer(2));
        for (String bgSchemeId2222222 : bgTemplateMap.keySet()) {
            bgTemplateId = (String)bgTemplateMap.get(bgSchemeId2222222);
            if (!bgSchemeMap.containsKey(bgSchemeId2222222) || !orgUnitMap.containsKey(BOSUuid.read((String)(orgUnitId = (String)bgSchemeMap.get(bgSchemeId2222222))))) continue;
            sql.append("(a.FOrgUnitId = ? and a.FBgSchemeId = ? and a.FBgTemplateId = ?) or ");
            isFilter = true;
            _tmpList1.add(orgUnitId);
            _tmpList1.add(bgSchemeId2222222);
            _tmpList1.add(bgTemplateId);
        }
        sql.delete(sql.length() - 4, sql.length());
        sql.append(")");
        sql1.append("select a.FID, a.FOrgUnitId, a.FBgSchemeId, a.FBgTemplateId  from T_BG_BgForm a ,t_bg_bgactualrecord b ,t_bg_bgperiod c where a.fid = b.fbgformid and b.fbgperiodid = c.fid  and (c.Flongnumber in @ ) and (a.FBgPeriodID = ?) and (a.FCurrencyID = ?)");
        sql1.append(" and (a.FSTATE = ? )");
        sql1.append(" and (b.FSTATE = ? )");
        sql1.append(" and (");
        _tmpList.add(new Integer(2));
        _tmpList.add(new Integer(2));
        for (String bgSchemeId2222222 : bgTemplateMap.keySet()) {
            bgTemplateId = (String)bgTemplateMap.get(bgSchemeId2222222);
            if (!bgSchemeMap.containsKey(bgSchemeId2222222) || !orgUnitMap.containsKey(BOSUuid.read((String)(orgUnitId = (String)bgSchemeMap.get(bgSchemeId2222222))))) continue;
            sql1.append("(a.FOrgUnitId = ? and a.FBgSchemeId = ? and a.FBgTemplateId = ?) or ");
            _tmpList.add(orgUnitId);
            _tmpList.add(bgSchemeId2222222);
            _tmpList.add(bgTemplateId);
            isFilter = true;
        }
        sql1.delete(sql1.length() - 4, sql1.length());
        sql1.append(")");
        if (!isFilter) {
            return new HashMap();
        }
        HashMap<String, String> filterMap = new HashMap<String, String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)"select fperiodType, flongnumber, fbegindate, fenddate   from t_bg_bgperiod where fid = ? ", (Object[])new String[]{bgActualBgPeriodId});
            String bgPeriodLongNumber = "";
            int periodType = -1;
            Date beginDate = null;
            Date endDate = null;
            if (rs.next()) {
                periodType = rs.getInt(1);
                bgPeriodLongNumber = rs.getString(2);
                beginDate = rs.getDate(3);
                endDate = rs.getDate(4);
            }
            conn = this.getConnection(ctx);
            if (periodType == 8) {
                if (beginDate == null) throw new NullPointerException("beginDate is null OR endDate is null!");
                if (endDate == null) {
                    throw new NullPointerException("beginDate is null OR endDate is null!");
                }
                String periodLongStr = "('" + bgPeriodLongNumber + "' ";
                int year1 = beginDate.getYear() + 1900;
                int year2 = endDate.getYear() + 1900;
                for (int i = year1; i <= year2; ++i) {
                    periodLongStr = periodLongStr + " , '" + i + "Y'";
                }
                periodLongStr = periodLongStr + ")";
                pstmt = conn.prepareStatement(sql1.toString().replaceFirst("@", periodLongStr));
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                pstmt.setString(1, bgPeriodId.toString());
                pstmt.setString(2, currencyId.toString());
                rst = pstmt.executeQuery();
            } else {
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, bgPeriodLongNumber);
                pstmt.setString(2, bgPeriodLongNumber + "!%");
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList1, (int)3);
                rst = pstmt.executeQuery();
            }
            while (rst.next()) {
                bgFormId = rst.getString(1);
                orgUnitId = rst.getString(2);
                bgSchemeId2222222 = rst.getString(3);
                filterMap.put(orgUnitId, bgSchemeId2222222);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    logger.error((Object)ex2);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return filterMap;
    }

    @Override
    protected Map _batchAntiAudit(Context ctx, List actualIds) throws BOSException, EASBizException {
        HashMap res = new HashMap();
        ArrayList<String> success = new ArrayList<String>();
        ArrayList<String> noaudited = new ArrayList<String>();
        res.put("success", success);
        res.put("noaudited", noaudited);
        if (actualIds == null || actualIds.isEmpty()) {
            return res;
        }
        List params = this.getActualInfo(ctx, actualIds);
        for (int i = 0; i < params.size(); ++i) {
            String[] param = (String[])params.get(i);
            try {
                this._unAuditBgActual(ctx, param[1], param[2], param[3]);
                success.add(param[0]);
                continue;
            }
            catch (BgActualRecordException e) {
                logger.error((Object)"", (Throwable)((Object)e));
                noaudited.add(param[0]);
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
        }
        return res;
    }

    @Override
    protected Map _batchAudit(Context ctx, List actualIds, BOSUuid userId) throws BOSException, EASBizException {
        HashMap res = new HashMap();
        ArrayList<String> success = new ArrayList<String>();
        ArrayList<String> audited = new ArrayList<String>();
        res.put("success", success);
        res.put("audited", audited);
        if (actualIds == null || actualIds.isEmpty()) {
            return res;
        }
        List params = this.getActualInfo(ctx, actualIds);
        for (int i = 0; i < params.size(); ++i) {
            String[] param = (String[])params.get(i);
            try {
                this._auditBgActual(ctx, param[1], param[2], param[3]);
                success.add(param[0]);
                continue;
            }
            catch (BgActualRecordException e) {
                logger.error((Object)"", (Throwable)((Object)e));
                audited.add(param[0]);
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
        }
        return res;
    }

    protected List getActualInfo(Context ctx, List actualIds) throws BOSException, EASBizException {
        ArrayList<String[]> res = new ArrayList<String[]>();
        if (actualIds == null || actualIds.isEmpty()) {
            return res;
        }
        int batchSize = 200;
        int size = actualIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String sql = this.makeParamSql(ctx, batchSize);
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, (String)actualIds.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    String[] params = new String[]{rst.getString(1), rst.getString(2), rst.getString(3), rst.getString(4)};
                    res.add(params);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return res;
    }

    private String makeParamSql(Context ctx, int length) {
        StringBuffer sql = new StringBuffer("select actual.fnumber,actual.fid,bgform.forgunitid,bgform.fbgschemeid ");
        sql.append("from t_bg_bgform bgform inner join t_bg_bgactualrecord actual ");
        sql.append("on bgform.fid=actual.fbgformid where actual.fid in (");
        for (int index = 1; index < length; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        return sql.toString();
    }
}

