/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgAdjustException;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgBudgetFacadeFactory;
import com.kingdee.eas.ma.budget.BgDataFactory;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgPastDataCollection;
import com.kingdee.eas.ma.budget.BgPastDataInfo;
import com.kingdee.eas.ma.budget.BgPastRecordCollection;
import com.kingdee.eas.ma.budget.BgPastRecordFactory;
import com.kingdee.eas.ma.budget.BgPastRecordInfo;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.IBgBudgetFacade;
import com.kingdee.eas.ma.budget.IBgData;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgPastRecord;
import com.kingdee.eas.ma.budget.app.AbstractBgAdjustFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgAdjustDataValue;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgAdjustFacadeControllerBean
extends AbstractBgAdjustFacadeControllerBean {
    private static final long serialVersionUID = -5089284514600683498L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgAdjustFacadeControllerBean");
    private IFullOrgUnit iFullOrgUnit = null;
    private IUser iUser = null;
    private IBgForm iBgForm = null;
    private IBgBudgetFacade ibgBudgetFacade = null;

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("adjust.id"));
        return sic;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean _submitAdjustForm(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        boolean re = false;
        IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
        if (ibgForm == null) throw new BgException(BgException.NOINSTANCE);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        if (!ibgForm.exists((IObjectPK)pk)) throw new BgFormException(BgFormException.NOBGFORMINFO);
        BgFormInfo bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)pk, this.getSelectors());
        if (bgFormInfo.getState().getValue() == 4) return true;
        throw new BgAdjustException(BgAdjustException.SUBMITWORKERROR);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List _getCollectAdjustData(Context ctx, List formulas, List orgUnitList) throws BOSException, EASBizException {
        ArrayList<BgAdjustDataValue> retList = new ArrayList<BgAdjustDataValue>();
        DateFormat format = BgNationalFormatUIUtil.getNationalDateTimeFormat(ctx);
        if (orgUnitList == null) return retList;
        if (orgUnitList.isEmpty()) return retList;
        if (formulas == null) return retList;
        if (formulas.isEmpty()) {
            return retList;
        }
        HashMap<String, FullOrgUnitInfo> orgUnitMap = new HashMap<String, FullOrgUnitInfo>();
        String[] collectParam = null;
        String orgUnitId = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int index = 0; index < orgUnitList.size(); ++index) {
            collectParam = (String[])orgUnitList.get(index);
            orgUnitId = collectParam[0];
            if (!orgUnitMap.containsKey(orgUnitId)) {
                orgUnitInfo = this.getOrgUnitInfo(ctx, orgUnitId);
            }
            orgUnitMap.put(orgUnitId, orgUnitInfo);
        }
        Connection conn = null;
        PreparedStatement adjustStmt = null;
        PreparedStatement formStmt = null;
        ResultSet adjustRet = null;
        ResultSet formRet = null;
        StringBuffer adjustSql = new StringBuffer();
        StringBuffer formSql = new StringBuffer();
        adjustSql.append("select FBgValue,FBizActual, FOrgUnitId, FBgFormId, FFormula from T_BG_BgTmpData where ( ");
        formSql.append("select FBgValue, FBizActual,FOrgUnitId, FBgFormId, FFormula from T_BG_BgData where ( ");
        for (int i = 0; i < formulas.size(); ++i) {
            adjustSql.append(" FFormula = ? ");
            formSql.append(" FFormula = ? ");
            if (i == formulas.size() - 1) continue;
            adjustSql.append(" OR ");
            formSql.append(" OR ");
        }
        adjustSql.append(")");
        formSql.append(")");
        adjustSql.append(" AND ( FORGUNITID=? AND FBGSCHEMEID=? ) ");
        formSql.append(" AND ( FORGUNITID=? AND FBGSCHEMEID=? ) ");
        try {
            conn = this.getConnection(ctx);
            adjustStmt = conn.prepareStatement(adjustSql.toString());
            formStmt = conn.prepareStatement(formSql.toString());
            for (int m = 0; m < formulas.size(); ++m) {
                adjustStmt.setString(m + 1, (String)formulas.get(m));
                formStmt.setString(m + 1, (String)formulas.get(m));
            }
            for (int n = 0; n < orgUnitList.size(); ++n) {
                int precision;
                String formula;
                int formulaCount = formulas.size();
                collectParam = (String[])orgUnitList.get(n);
                adjustStmt.setString(formulaCount + 1, collectParam[0]);
                adjustStmt.setString(formulaCount + 2, collectParam[2]);
                boolean isAdjusting = false;
                BgAdjustDataValue data = null;
                adjustRet = adjustStmt.executeQuery();
                while (adjustRet.next()) {
                    isAdjusting = true;
                    orgUnitInfo = (FullOrgUnitInfo)orgUnitMap.get(adjustRet.getString("FOrgUnitId"));
                    data = new BgAdjustDataValue();
                    data.setOrgUnitId(orgUnitInfo.getId().toString());
                    data.setOrgUnitNumber(orgUnitInfo.getNumber());
                    data.setOrgUnitLongNumber(orgUnitInfo.getLongNumber());
                    data.setOrgUnitName(orgUnitInfo.getName());
                    String adjustFormId = adjustRet.getString("FBgFormId");
                    data.setBgFormId(adjustFormId);
                    formula = adjustRet.getString("FFormula");
                    precision = this.getPrecision(ctx, formula);
                    BigDecimal bgVal = adjustRet.getBigDecimal("FBgValue");
                    BigDecimal oldValue = adjustRet.getBigDecimal("FBizActual");
                    this.getAdjustValueFromAdjustMap(ctx, formula, adjustFormId, data, precision, bgVal, oldValue, format);
                    if (data.getAdjValue() == null) {
                        this.getCollectData(conn, formula, adjustFormId, data);
                    }
                    data.setApproved(false);
                    this.fillFormulaInfo(ctx, formula, data, orgUnitInfo.getId().toString());
                    retList.add(data);
                }
                SQLUtils.cleanup((ResultSet)adjustRet);
                formStmt.setString(formulaCount + 1, collectParam[0]);
                formStmt.setString(formulaCount + 2, collectParam[2]);
                formRet = formStmt.executeQuery();
                while (formRet.next()) {
                    orgUnitInfo = (FullOrgUnitInfo)orgUnitMap.get(formRet.getString("FOrgUnitId"));
                    data = new BgAdjustDataValue();
                    data.setOrgUnitId(orgUnitInfo.getId().toString());
                    data.setOrgUnitNumber(orgUnitInfo.getNumber());
                    data.setOrgUnitLongNumber(orgUnitInfo.getLongNumber());
                    data.setOrgUnitName(orgUnitInfo.getName());
                    String bgFormId = formRet.getString("FBgFormId");
                    data.setBgFormId(bgFormId);
                    formula = formRet.getString("FFormula");
                    precision = this.getPrecision(ctx, formula);
                    this.getPastDataFromBgForm(ctx, formula, bgFormId, data, precision);
                    data.setApproved(true);
                    this.fillFormulaInfo(ctx, formula, data, orgUnitInfo.getId().toString());
                    boolean isXxx = false;
                    for (int x = 0; retList != null && x < retList.size(); ++x) {
                        BgAdjustDataValue xxx;
                        if (retList.get(x) == null || !(retList.get(x) instanceof BgAdjustDataValue) || (xxx = (BgAdjustDataValue)retList.get(x)).getFormula() == null || !xxx.getFormula().equals(formula) || xxx.getBgFormId() == null || !xxx.getBgFormId().equals(bgFormId)) continue;
                        isXxx = true;
                        break;
                    }
                    if (isXxx) continue;
                    retList.add(data);
                }
                SQLUtils.cleanup((ResultSet)formRet);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(formRet, formStmt);
                SQLUtils.cleanup(adjustRet, (Statement)adjustStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(formRet, (Statement)formStmt);
        SQLUtils.cleanup(adjustRet, (Statement)adjustStmt, (Connection)conn);
        return retList;
    }

    private void getCollectData(Connection conn, String formula, String bgFormId, BgAdjustDataValue data) throws BOSException {
        String sql = "select refform.fadjustmapdata from t_bg_refbgform refform,t_bg_bgcollectform bgcol where bgcol.fid=refform.fbgcollectid and bgcol.fstate <> 101 and refform.fbgformid = ?";
        PreparedStatement pmt = null;
        ResultSet res = null;
        try {
            Blob blob;
            HashMap map;
            pmt = conn.prepareStatement(sql);
            pmt.setString(1, bgFormId);
            res = pmt.executeQuery();
            if (res.next() && res.getBlob(1) != null && (map = BgHelper.buildHashMapByByte((blob = res.getBlob(1)).getBytes(1L, (int)blob.length()))) != null && map.get(formula) instanceof BgAdjustFormDiversityData) {
                BgAdjustFormDiversityData bafd = (BgAdjustFormDiversityData)map.get(formula);
                data.setNewValue(bafd.getNewValue());
                data.setOldValue(bafd.getOldValue());
                data.setAdjValue(data.getNewValue().subtract(data.getOldValue()));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, (Statement)pmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAdjustValueFromAdjustMap(Context ctx, String formula, String bgFormId, BgAdjustDataValue value, int decimal, BigDecimal bgVal, BigDecimal oldValue, DateFormat format) throws BOSException, IOException, ClassNotFoundException, EASBizException {
        HashMap adjustMap = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adjust.id", (Object)bgFormId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(4), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("adjustMapData"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditTime"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        BgFormCollection col = this.getBgFormInterface(ctx).getBgFormCollection(view);
        BgFormInfo bgFormInfo = null;
        byte[] data = null;
        if (col != null && !col.isEmpty()) {
            bgFormInfo = col.get(0);
            data = bgFormInfo.getAdjustMapData();
        }
        if (data == null || data.length == 0) {
            BigDecimal newVal = bgVal == null ? BgNConstants.ZERO : bgVal;
            BigDecimal oldVal = oldValue;
            value.setNewValue(newVal.setScale(4));
            value.setOldValue(oldVal.setScale(4));
            value.setAdjValue(newVal.subtract(oldVal).setScale(decimal, 4));
            if (bgFormInfo != null) {
                value.setAuditor(bgFormInfo.getAuditor() == null ? "" : bgFormInfo.getAuditor().getName());
                value.setAuditTime(bgFormInfo.getAuditTime() == null ? "" : bgFormInfo.getAuditTime().toLocaleString());
            }
        } else {
            InputStream is = null;
            ObjectInputStream ois = null;
            try {
                is = ZipUtil.unpack((byte[])data);
                ois = new ObjectInputStream(is);
                adjustMap = (HashMap)ois.readObject();
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
                try {
                    ois.close();
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            BgFormDiversityData divData = (BgFormDiversityData)adjustMap.get(formula);
            if (divData != null) {
                BigDecimal newVal = bgVal;
                BigDecimal oldVal = oldValue;
                value.setNewValue(newVal.setScale(decimal, 4));
                value.setOldValue(oldVal.setScale(decimal, 4));
                value.setAdjValue(newVal.subtract(oldVal).setScale(decimal, 4));
                try {
                    value.setAdjustor(this.getUserNameByUserId(ctx, divData.getAdjustor()));
                    value.setAdjusttime(divData.getAdjustTime() == null ? "" : format.format(divData.getAdjustTime()));
                    if (bgFormInfo != null) {
                        value.setAuditor(bgFormInfo.getAuditor() == null ? "" : bgFormInfo.getAuditor().getName());
                        value.setAuditTime(bgFormInfo.getAuditTime() == null ? "" : format.format(bgFormInfo.getAuditTime()));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
            } else {
                BigDecimal newVal = bgVal == null ? BgNConstants.ZERO : bgVal;
                BigDecimal oldVal = oldValue;
                value.setNewValue(newVal.setScale(4));
                value.setOldValue(oldVal.setScale(4));
                value.setAdjValue(newVal.subtract(oldVal).setScale(decimal, 4));
                if (bgFormInfo != null) {
                    value.setAdjustor(bgFormInfo.getAuditor() == null ? "" : bgFormInfo.getAuditor().getName());
                    value.setAdjusttime(bgFormInfo.getAuditTime() == null ? "" : bgFormInfo.getAuditTime().toLocaleString());
                    value.setAuditor(bgFormInfo.getAuditor() == null ? "" : bgFormInfo.getAuditor().getName());
                    value.setAuditTime(bgFormInfo.getAuditTime() == null ? "" : bgFormInfo.getAuditTime().toLocaleString());
                }
            }
        }
    }

    private void getPastDataFromBgForm(Context ctx, String formula, String bgFormId, BgAdjustDataValue value, int decimal) throws BOSException, EASBizException {
        SelectorItemCollection formSic = new SelectorItemCollection();
        formSic.add(new SelectorItemInfo("auditor.name"));
        formSic.add(new SelectorItemInfo("auditTime"));
        BgFormInfo bgFormInfo = this.getBgFormInterface(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), formSic);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgFormId", (Object)bgFormId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pastSource", (Object)BgPastSourceEnum.ADJUST, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("pastSource"));
        sic.add(new SelectorItemInfo("bgFormId"));
        sic.add(new SelectorItemInfo("pastDatas.id"));
        sic.add(new SelectorItemInfo("pastDatas.formula"));
        sic.add(new SelectorItemInfo("pastDatas.pastValue"));
        sic.add(new SelectorItemInfo("pastDatas.balance"));
        sic.add(new SelectorItemInfo("pastDatas.adjusttime"));
        sic.add(new SelectorItemInfo("pastDatas.adjustor.name"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemInfo sorter = new SorterItemInfo("createTime");
        sorter.setSortType(SortType.DESCEND);
        view.getSorter().add(sorter);
        IBgPastRecord ibgPastRecod = BgPastRecordFactory.getLocalInstance(ctx);
        BgPastRecordCollection col = ibgPastRecod.getBgPastRecordCollection(view);
        boolean isAdjusted = false;
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                BgPastRecordInfo bgPastRecordInfo = col.get(i);
                BgPastDataCollection pastDatas = bgPastRecordInfo.getPastDatas();
                for (int j = 0; j < pastDatas.size(); ++j) {
                    BgPastDataInfo data = pastDatas.get(j);
                    if (!data.getFormula().equals(formula)) continue;
                    isAdjusted = true;
                    if (value.getHistoryInfos() == null) {
                        BigDecimal oldValue = data.getBalance();
                        BigDecimal newValue = data.getAdjValue();
                        BigDecimal adjValue = data.getPastValue();
                        value.setOldValue(oldValue.setScale(decimal, 4));
                        value.setAdjValue(adjValue.setScale(decimal, 4));
                        if (newValue == null) {
                            value.setNewValue(oldValue.add(adjValue).setScale(decimal, 4));
                        } else {
                            value.setNewValue(newValue.setScale(decimal, 4));
                        }
                        value.setAdjustor(this.getUserNameByUserId(ctx, data.getAdjustor().getId().toString()));
                        value.setAdjusttime(data.getAdjusttime() == null ? "" : data.getAdjusttime().toString());
                        value.setAuditor(bgFormInfo.getAuditor() == null ? "" : bgFormInfo.getAuditor().getName());
                        value.setAuditTime(bgFormInfo.getAuditTime() == null ? "" : bgFormInfo.getAuditTime().toLocaleString());
                        value.setHistoryInfos(new ArrayList());
                        continue;
                    }
                    BgAdjustDataValue historyValue = null;
                    try {
                        historyValue = (BgAdjustDataValue)value.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new BOSException((Throwable)e);
                    }
                    BigDecimal oldValue = data.getBalance();
                    BigDecimal newValue = data.getAdjValue();
                    BigDecimal adjValue = data.getPastValue();
                    historyValue.setOldValue(oldValue.setScale(decimal, 4));
                    historyValue.setAdjValue(adjValue.setScale(decimal, 4));
                    if (newValue == null) {
                        historyValue.setNewValue(oldValue.add(adjValue).setScale(decimal, 4));
                    } else {
                        historyValue.setNewValue(newValue.setScale(decimal, 4));
                    }
                    historyValue.setAdjustor(this.getUserNameByUserId(ctx, data.getAdjustor().getId().toString()));
                    historyValue.setAdjusttime(data.getAdjusttime() == null ? "" : data.getAdjusttime().toString());
                    historyValue.setAuditor(bgFormInfo.getAuditor() == null ? "" : bgFormInfo.getAuditor().getName());
                    historyValue.setAuditTime(bgFormInfo.getAuditTime() == null ? "" : bgFormInfo.getAuditTime().toLocaleString());
                    value.getHistoryInfos().add(historyValue);
                }
            }
        }
        if (!isAdjusted) {
            EntityViewInfo bgDataView = new EntityViewInfo();
            FilterInfo bgDataFilter = new FilterInfo();
            bgDataFilter.getFilterItems().add(new FilterItemInfo("bgFormId.id", (Object)bgFormId, CompareType.EQUALS));
            bgDataFilter.getFilterItems().add(new FilterItemInfo("formula", (Object)formula, CompareType.EQUALS));
            bgDataView.setFilter(bgDataFilter);
            SelectorItemCollection bgDataSic = new SelectorItemCollection();
            bgDataSic.add(new SelectorItemInfo("bgValue"));
            bgDataView.getSelector().addObjectCollection((IObjectCollection)bgDataSic);
            IBgData iBgData = BgDataFactory.getLocalInstance(ctx);
            CoreBaseCollection _col = iBgData.getCollection(bgDataView);
            if (_col != null && _col.size() > 0) {
                BgDataInfo bgData = (BgDataInfo)_col.get(0);
                value.setOldValue(bgData.getBgValue().setScale(decimal, 4));
                value.setAdjValue(BgNConstants.ZERO);
                value.setNewValue(bgData.getBgValue().setScale(decimal, 4));
            }
        }
    }

    private int getPrecision(Context ctx, String formula) throws BOSException, BgException {
        List formulaHint = null;
        try {
            formulaHint = TableToolkit.parseFormula((String)formula, (boolean)false);
        }
        catch (ParserException ex) {
            logger.error((Object)ex.getMessage());
        }
        String[] parameter = null;
        if (formulaHint != null) {
            FormulaHint formulas = (FormulaHint)formulaHint.get(0);
            parameter = formulas.getParams();
        }
        int decimal = 10;
        if (parameter != null && parameter[5] != null && parameter[5].trim().length() > 0) {
            ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            if (icurrency == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)parameter[5], CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("precision"));
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            CurrencyCollection col = icurrency.getCurrencyCollection(view);
            if (col != null && !col.isEmpty()) {
                decimal = col.get(0).getPrecision();
            }
        }
        return decimal;
    }

    private void fillFormulaInfo(Context ctx, String formula, BgAdjustDataValue value, String orgUnitId) throws BOSException, EASBizException {
        List formulaHint = null;
        try {
            formulaHint = TableToolkit.parseFormula((String)formula, (boolean)false);
        }
        catch (ParserException ex) {
            logger.error((Object)ex.getMessage());
        }
        String[] parameter = null;
        if (formulaHint != null) {
            FormulaHint formulas = (FormulaHint)formulaHint.get(0);
            parameter = formulas.getParams();
            String itemCmbNumber = parameter[0];
            Map map = new HashMap<String, Object>();
            map.put(itemCmbNumber.replaceAll(",", "_"), null);
            try {
                map = this.getBudgetInterface(ctx).getSelectBgItemCombinName(map, orgUnitId);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            String itemCmbName = (String)map.get(itemCmbNumber.replaceAll(",", "_"));
            String elementNumber = parameter[2];
            IBgElement iBgElement = BgElementFactory.getLocalInstance(ctx);
            CoreBaseInfo element = null;
            try {
                element = iBgElement.getValue(" select name where number = '" + elementNumber + "' ");
            }
            catch (ObjectNotFoundException ex) {
                throw new BOSException((Throwable)ex);
            }
            String elementName = "";
            if (element != null) {
                elementName = ((BgElementInfo)element).getName();
            }
            value.setItemNumber(itemCmbNumber);
            value.setItemName(itemCmbName);
            value.setElementNumber(elementNumber);
            value.setElementName(elementName);
        }
        value.setFormula(formula);
    }

    private FullOrgUnitInfo getOrgUnitInfo(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("name"));
        return this.getOrgUnitInterface(ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId), sic);
    }

    private String getUserNameByUserId(Context ctx, String userId) throws BOSException, EASBizException {
        IUser iUser = this.getUserInterface(ctx);
        UserInfo user = iUser.getUserByID((IObjectPK)new ObjectUuidPK(userId));
        return user.getName();
    }

    private IFullOrgUnit getOrgUnitInterface(Context ctx) throws BOSException {
        if (this.iFullOrgUnit == null) {
            this.iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        }
        return this.iFullOrgUnit;
    }

    private IUser getUserInterface(Context ctx) throws BOSException {
        if (this.iUser == null) {
            this.iUser = UserFactory.getLocalInstance((Context)ctx);
        }
        return this.iUser;
    }

    private IBgForm getBgFormInterface(Context ctx) throws BOSException {
        if (this.iBgForm == null) {
            this.iBgForm = BgFormFactory.getLocalInstance(ctx);
        }
        return this.iBgForm;
    }

    private IBgBudgetFacade getBudgetInterface(Context ctx) throws Exception {
        if (this.ibgBudgetFacade == null) {
            this.ibgBudgetFacade = BgBudgetFacadeFactory.getLocalInstance(ctx);
        }
        return this.ibgBudgetFacade;
    }

    @Override
    protected Map _getHideField(Context ctx, BOSObjectType bizObjectType, String userId, String[] orgIds) throws BOSException, EASBizException {
        if (bizObjectType == null || orgIds == null || orgIds.length == 0) {
            return null;
        }
        if (userId == null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        HashMap res = new HashMap();
        IPermission iPer = PermissionFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < orgIds.length; ++i) {
            FieldPermission fp = iPer.getFieldPermission(bizObjectType, (IObjectPK)new ObjectStringPK(userId), (IObjectPK)new ObjectStringPK(orgIds[i]));
            if (fp == null) continue;
            ArrayList<String> hideFields = new ArrayList<String>();
            for (FieldAccessInfo fai : fp) {
                if (fai.isViewable()) continue;
                hideFields.add(fai.getFieldName());
            }
            res.put(orgIds[i], hideFields);
        }
        return res;
    }
}

