/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgCtrlTypeEnum;
import com.kingdee.eas.ma.budget.BgDataFactory;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BudgetCtrlConstants;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.app.BudgetCtrlHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BgBalCalculator {
    private static Logger logger = Logger.getLogger(BgBalCalculator.class);

    public static BigDecimal calcuBal(Context ctx, String bgDataId, boolean isCtrl, BgGetPeriodTypeForGetBlanceEnum balTypeEnum) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("formula"));
        BgDataInfo bgDataInfo = (BgDataInfo)BgDataFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bgDataId), sic);
        String orgUnitId = bgDataInfo.getOrgUnit().getId().toString();
        String bgSchemeId = bgDataInfo.getBgScheme().getId().toString();
        String formula = bgDataInfo.getFormula();
        return BgBalCalculator.calcuBal(ctx, orgUnitId, bgSchemeId, formula, isCtrl, balTypeEnum);
    }

    public static BigDecimal calcuBal(Context ctx, String orgUnitId, String bgSchemeId, String formula, boolean isCtrl, BgGetPeriodTypeForGetBlanceEnum balTypeEnum) throws BOSException, EASBizException {
        BgCtrlParamInfo ctrlParamInfo = new BgCtrlParamInfo();
        ctrlParamInfo.setOrgUnitId(orgUnitId);
        ctrlParamInfo.setBgSchemeId(bgSchemeId);
        ctrlParamInfo.setItemFormula(formula);
        return BgBalCalculator.calcuBal(ctx, ctrlParamInfo, isCtrl, balTypeEnum).getBalance();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgCtrlResultInfo calcuBal(Context ctx, BgCtrlParamInfo ctrlParamInfo, boolean isCtrl, BgGetPeriodTypeForGetBlanceEnum balTypeEnum) throws BOSException, EASBizException {
        boolean isGroupCtrl;
        BgCtrlResultInfo ctrlResultInfo = new BgCtrlResultInfo();
        ctrlResultInfo = BudgetCtrlHelper.fillCtrlParam2CtrlResult(ctrlParamInfo, ctrlResultInfo);
        String orgUnitId = ctrlParamInfo.getOrgUnitId();
        String bgSchemeId = ctrlParamInfo.getBgSchemeId();
        String formula = ctrlParamInfo.getItemFormula();
        BgPeriodEnum periodTypeEnum = ctrlParamInfo.getPeriodType();
        BgDataInfo bgDataInfo = null;
        String BOName = "";
        if (ctrlParamInfo.getString("BOName") != null) {
            BOName = ctrlParamInfo.getString("BOName");
        }
        if (BudgetCtrlUtil.isEmpty(bgDataInfo = BOName.equals("com.kingdee.eas.ma.nbudget.app.BudgetRequestBill") ? BgBalCalculator.getBgData1(ctx, orgUnitId, bgSchemeId, formula, isCtrl) : BgBalCalculator.getBgData(ctx, orgUnitId, bgSchemeId, formula, isCtrl)) || BudgetCtrlHelper.isEmptyBgData(ctx, bgDataInfo)) {
            ctrlResultInfo.setBgDataId(null);
            ctrlResultInfo.setBalance(null);
            return ctrlResultInfo;
        }
        String[] params = BgNFSHelper.parseFormulaPara((String)bgDataInfo.getFormula());
        String itemCombId = bgDataInfo.getBgItemCombinId();
        String bgPeriodId = bgDataInfo.getBgPeriod().getId().toString();
        String bgElementId = bgDataInfo.getBgElement().getId().toString();
        String currencyId = bgDataInfo.getCurrency().getId().toString();
        String bgDataId = bgDataInfo.getId().toString();
        BigDecimal bgValue = bgDataInfo.getBgValue();
        BigDecimal bizActual = bgDataInfo.getBizActual();
        boolean isControl = bgDataInfo.isIsControl();
        boolean isFlexible = bgDataInfo.isIsFlexible();
        BigDecimal flexParam = isFlexible ? bgDataInfo.getFlexParam() : BudgetCtrlConstants.ONE_AMOUNT;
        BgCtrlTypeEnum ctrlType = bgDataInfo.getCtrlType();
        if (ctrlType == null) {
            ctrlType = BgCtrlTypeEnum.NoCtrl;
        }
        String groupNo = (isGroupCtrl = bgDataInfo.isIsGroupCtrl()) ? bgDataInfo.getGroupNo() : null;
        boolean isAllowAccess = bgDataInfo.isIsAllowAccess();
        ctrlResultInfo.setBgDataId(bgDataId);
        ctrlResultInfo.setBgValue(bgValue);
        ctrlResultInfo.setBizActual(bizActual);
        ctrlResultInfo.setIsAllowAccess(isAllowAccess);
        ctrlResultInfo.setCtrlType(ctrlType);
        if (periodTypeEnum == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("periodType"));
            periodTypeEnum = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgPeriodId), sic).getPeriodType();
        }
        if (balTypeEnum != BgGetPeriodTypeForGetBlanceEnum.Is_BgTrace_Init_Bal && (!isControl || !isGroupCtrl && ctrlType == BgCtrlTypeEnum.PeriodCtrl || !isGroupCtrl && periodTypeEnum == BgPeriodEnum.PERSONAL)) {
            BigDecimal avlBalance = bgValue.multiply(flexParam).subtract(bizActual);
            ctrlResultInfo.setBalance(avlBalance);
            ctrlResultInfo.put("sumBudgetValue", bgValue.multiply(flexParam));
            ctrlResultInfo.put("sumActualValue", bizActual);
            ctrlResultInfo.put("bgData", bgDataInfo);
            return ctrlResultInfo;
        }
        BgPeriodInfo period = null;
        String periodID = null;
        List bgPeriods = null;
        List acPeriods = null;
        ArrayList<String> bgValPeriodIds = new ArrayList<String>();
        ArrayList<String> actValPeriodIds = new ArrayList<String>();
        HashSet<String> formulaStrs = new HashSet<String>();
        HashMap allPeriodMap = new HashMap();
        IRowSet rst = null;
        try {
            int i;
            bgPeriods = BgBalCalculator.getBgValPeriods(ctx, bgSchemeId, bgPeriodId, ctrlType, balTypeEnum);
            int in = bgPeriods.size();
            for (i = 0; i < in; ++i) {
                period = (BgPeriodInfo)bgPeriods.get(i);
                periodID = period.getId().toString();
                bgValPeriodIds.add(periodID);
                allPeriodMap.put(periodID, null);
                params[1] = period.getNumber();
                formulaStrs.add(BgNFSHelper.getFormulaFromParam((String[])params));
            }
            acPeriods = BgBalCalculator.getActValPeriods(ctx, bgSchemeId, bgPeriodId, ctrlType, balTypeEnum);
            in = acPeriods.size();
            for (i = 0; i < in; ++i) {
                period = (BgPeriodInfo)acPeriods.get(i);
                periodID = period.getId().toString();
                actValPeriodIds.add(periodID);
                allPeriodMap.put(periodID, null);
                params[1] = period.getNumber();
                formulaStrs.add(BgNFSHelper.getFormulaFromParam((String[])params));
            }
            StringBuffer SQL = new StringBuffer(2048);
            SQL.append(" select d.FBgValue,");
            SQL.append("        d.FIsFlexible,");
            SQL.append("        d.FFlexParam,");
            SQL.append("        d.FBizActual,");
            SQL.append("        d.FId,");
            SQL.append("        d.FBgPeriodId");
            SQL.append("   from T_BG_BgData d");
            SQL.append("  where d.FOrgUnitId = ?");
            SQL.append("    and d.FBgSchemeId = ?");
            if (!isGroupCtrl) {
                SQL.append(" and d.FBgElementId = ?");
            }
            SQL.append("    and d.FCurrencyId = ?");
            SQL.append("    and d.FBgPeriodId in " + BgHelper.tranSet2String(allPeriodMap.keySet()));
            if (isCtrl) {
                SQL.append("    and d.FDataState =9");
            }
            if (!isGroupCtrl) {
                ArrayList<String> sqlParams = new ArrayList<String>();
                sqlParams.add(orgUnitId);
                sqlParams.add(bgSchemeId);
                sqlParams.add(bgElementId);
                sqlParams.add(currencyId);
                sqlParams.add(itemCombId);
                sqlParams.addAll(formulaStrs);
                SQL.append(" and d.FBgItemCombinId = ?");
                SQL.append(" and d.FFormula IN (" + BgNSQLHelper.getParamSizeString((int)formulaStrs.size()) + ")");
                rst = DbUtil.executeQuery((Context)ctx, (String)SQL.toString(), (Object[])sqlParams.toArray());
            } else {
                SQL.append(" and d.FGroupNo = ?");
                rst = DbUtil.executeQuery((Context)ctx, (String)SQL.toString(), (Object[])new String[]{orgUnitId, bgSchemeId, currencyId, groupNo});
            }
            BigDecimal sumBgVal = BudgetCtrlConstants.ZERO_AMOUNT;
            BigDecimal sumBizActual = BudgetCtrlConstants.ZERO_AMOUNT;
            BigDecimal avlBalance = BudgetCtrlConstants.ZERO_AMOUNT;
            while (rst.next()) {
                String _periodId = rst.getString("FBgPeriodId");
                if (bgValPeriodIds.contains(_periodId)) {
                    BigDecimal _bgValue = rst.getBigDecimal("FBgValue");
                    BigDecimal _flexParam = rst.getBoolean("FIsFlexible") ? rst.getBigDecimal("FFlexParam") : BudgetCtrlConstants.ONE_AMOUNT;
                    sumBgVal = sumBgVal.add(_bgValue.multiply(_flexParam));
                }
                if (!actValPeriodIds.contains(_periodId)) continue;
                BigDecimal _bizActual = rst.getBigDecimal("FBizActual");
                sumBizActual = sumBizActual.add(_bizActual);
            }
            ctrlResultInfo.put("sumBudgetValue", sumBgVal);
            ctrlResultInfo.put("sumActualValue", sumBizActual);
            ctrlResultInfo.put("bgData", bgDataInfo);
            avlBalance = sumBgVal.subtract(sumBizActual);
            ctrlResultInfo.setBalance(avlBalance);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return ctrlResultInfo;
    }

    public static List getBgValPeriodIds(Context ctx, String bgSchemeId, String curPeriodId, BgCtrlTypeEnum ctrlTypeEnum, BgGetPeriodTypeForGetBlanceEnum balanceType) throws BOSException, EASBizException {
        return BgBalCalculator.getPeriodIds(ctx, bgSchemeId, curPeriodId, ctrlTypeEnum, balanceType, false);
    }

    public static List getBgValPeriods(Context ctx, String bgSchemeId, String curPeriodId, BgCtrlTypeEnum ctrlTypeEnum, BgGetPeriodTypeForGetBlanceEnum balanceType) throws BOSException, EASBizException {
        return BgBalCalculator.getPeriods(ctx, bgSchemeId, curPeriodId, ctrlTypeEnum, balanceType, false);
    }

    public static List getActValPeriodIds(Context ctx, String bgSchemeId, String curPeriodId, BgCtrlTypeEnum ctrlTypeEnum, BgGetPeriodTypeForGetBlanceEnum balanceType) throws BOSException, EASBizException {
        List actValPeriodIds = BgBalCalculator.getPeriodIds(ctx, bgSchemeId, curPeriodId, ctrlTypeEnum, balanceType, true);
        if (balanceType != BgGetPeriodTypeForGetBlanceEnum.Is_BgTrace_Init_Bal) {
            return actValPeriodIds;
        }
        if (actValPeriodIds.size() > 0) {
            actValPeriodIds.remove(actValPeriodIds.get(actValPeriodIds.size() - 1));
        }
        return actValPeriodIds;
    }

    public static List getActValPeriods(Context ctx, String bgSchemeId, String curPeriodId, BgCtrlTypeEnum ctrlTypeEnum, BgGetPeriodTypeForGetBlanceEnum balanceType) throws BOSException, EASBizException {
        List actValPeriods = BgBalCalculator.getPeriods(ctx, bgSchemeId, curPeriodId, ctrlTypeEnum, balanceType, true);
        if (balanceType != BgGetPeriodTypeForGetBlanceEnum.Is_BgTrace_Init_Bal) {
            return actValPeriods;
        }
        if (actValPeriods.size() > 0) {
            actValPeriods.remove(actValPeriods.get(actValPeriods.size() - 1));
        }
        return actValPeriods;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List getPeriods(Context ctx, String bgSchemeId, String curPeriodId, BgCtrlTypeEnum ctrlTypeEnum, BgGetPeriodTypeForGetBlanceEnum balanceType, boolean isForActual) throws BOSException, EASBizException {
        java.util.Date endDate;
        Date beginDate;
        int periodType;
        ArrayList<BgPeriodInfo> bgPeriods;
        block25: {
            java.util.Date curYearEndDate;
            java.util.Date curYearBeginDate;
            Date curPeriodEndDate;
            Date curPeriodBeginDate;
            Date schemeEndDate;
            Date schemeBeginDate;
            block27: {
                block26: {
                    bgPeriods = new ArrayList<BgPeriodInfo>();
                    periodType = -1;
                    beginDate = null;
                    endDate = null;
                    schemeBeginDate = null;
                    schemeEndDate = null;
                    curPeriodBeginDate = null;
                    curPeriodEndDate = null;
                    curYearBeginDate = null;
                    curYearEndDate = null;
                    String schemeQuery = "select TOP 1 FDateFrom, FDateTo, FPeriod from T_BG_BgScheme where FId = ?";
                    String curPeriodQuery = "select FBeginDate,FEndDate,FYear,FPeriodType from T_BG_BgPeriod where FId = ?";
                    IRowSet rst = null;
                    try {
                        rst = DbUtil.executeQuery((Context)ctx, (String)schemeQuery, (Object[])new String[]{bgSchemeId});
                        if (rst.next()) {
                            schemeBeginDate = rst.getDate("FDateFrom");
                            schemeEndDate = rst.getDate("FDateTo");
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        rst = DbUtil.executeQuery((Context)ctx, (String)curPeriodQuery, (Object[])new String[]{curPeriodId});
                        if (rst.next()) {
                            curPeriodBeginDate = rst.getDate("FBeginDate");
                            curPeriodEndDate = rst.getDate("FEndDate");
                            int curPeriodYear = rst.getInt("FYear");
                            GregorianCalendar beginCalendar = new GregorianCalendar();
                            beginCalendar.set(1, curPeriodYear);
                            beginCalendar.set(2, 0);
                            beginCalendar.set(5, 1);
                            beginCalendar.set(11, 0);
                            beginCalendar.set(12, 0);
                            beginCalendar.set(13, 0);
                            curYearBeginDate = beginCalendar.getTime();
                            GregorianCalendar endCalendar = new GregorianCalendar();
                            endCalendar.set(1, curPeriodYear);
                            endCalendar.set(2, 11);
                            endCalendar.set(5, 31);
                            endCalendar.set(11, 23);
                            endCalendar.set(12, 59);
                            endCalendar.set(13, 59);
                            curYearEndDate = endCalendar.getTime();
                            periodType = rst.getInt("FPeriodType");
                        }
                    }
                    catch (SQLException ex) {
                        try {
                            logger.error((Object)"budget error:", (Throwable)ex);
                            throw new BgException(BgException.DATABASEERROR, ex);
                            catch (Exception ex2) {
                                logger.error((Object)"budget error:", (Throwable)ex2);
                                throw new BOSException((Throwable)ex2);
                            }
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    if (ctrlTypeEnum == BgCtrlTypeEnum.NoCtrl || ctrlTypeEnum == BgCtrlTypeEnum.PeriodCtrl || periodType == 8) {
                        bgPeriods.add(BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo((IObjectPK)new ObjectStringPK(curPeriodId)));
                        return bgPeriods;
                    }
                    if (ctrlTypeEnum != BgCtrlTypeEnum.AddUpCtrl) break block26;
                    if (!isForActual) {
                        beginDate = schemeBeginDate;
                        endDate = curPeriodEndDate;
                        break block25;
                    } else if (balanceType == BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance || balanceType == BgGetPeriodTypeForGetBlanceEnum.Is_BgTrace_Init_Bal) {
                        beginDate = schemeBeginDate;
                        endDate = curPeriodEndDate;
                        break block25;
                    } else {
                        beginDate = schemeBeginDate;
                        endDate = schemeEndDate;
                    }
                    break block25;
                }
                if (ctrlTypeEnum != BgCtrlTypeEnum.TotalCtrl) break block27;
                if (!isForActual) {
                    beginDate = schemeBeginDate;
                    endDate = schemeEndDate;
                    break block25;
                } else if (balanceType == BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance || balanceType == BgGetPeriodTypeForGetBlanceEnum.Is_BgTrace_Init_Bal) {
                    beginDate = schemeBeginDate;
                    endDate = curPeriodEndDate;
                    break block25;
                } else {
                    beginDate = schemeBeginDate;
                    endDate = schemeEndDate;
                }
                break block25;
            }
            if (ctrlTypeEnum == BgCtrlTypeEnum.ThisYearCtrl) {
                if (!isForActual) {
                    beginDate = schemeBeginDate != null && schemeBeginDate.before(curYearBeginDate) ? curYearBeginDate : (curPeriodBeginDate != null && curPeriodBeginDate.before(schemeBeginDate) ? curPeriodBeginDate : schemeBeginDate);
                    endDate = curYearEndDate != null && curYearEndDate.after(schemeEndDate) ? schemeEndDate : curYearEndDate;
                } else if (balanceType == BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance || balanceType == BgGetPeriodTypeForGetBlanceEnum.Is_BgTrace_Init_Bal) {
                    beginDate = schemeBeginDate != null && schemeBeginDate.before(curYearBeginDate) ? curYearBeginDate : schemeBeginDate;
                    endDate = curPeriodEndDate;
                } else {
                    beginDate = schemeBeginDate != null && schemeBeginDate.before(curYearBeginDate) ? curYearBeginDate : schemeBeginDate;
                    endDate = curYearEndDate != null && curYearEndDate.after(schemeEndDate) ? schemeEndDate : curYearEndDate;
                }
            }
        }
        try {
            BgPeriodCollection bgPeriodCol = BgHelper.getBgPeriodCollOverDateRangeBySQL(ctx, periodType, beginDate, endDate);
            if (bgPeriodCol == null || bgPeriodCol.size() <= 0) return bgPeriods;
            for (int i = 0; i < bgPeriodCol.size(); ++i) {
                bgPeriods.add(bgPeriodCol.get(i));
            }
            return bgPeriods;
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List getPeriodIds(Context ctx, String bgSchemeId, String curPeriodId, BgCtrlTypeEnum ctrlTypeEnum, BgGetPeriodTypeForGetBlanceEnum balanceType, boolean isForActual) throws BOSException, EASBizException {
        java.util.Date endDate;
        Date beginDate;
        int periodType;
        ArrayList<String> bgPeriodIds;
        block25: {
            java.util.Date curYearEndDate;
            java.util.Date curYearBeginDate;
            Date curPeriodEndDate;
            Date curPeriodBeginDate;
            Date schemeEndDate;
            Date schemeBeginDate;
            block27: {
                block26: {
                    bgPeriodIds = new ArrayList<String>();
                    periodType = -1;
                    beginDate = null;
                    endDate = null;
                    schemeBeginDate = null;
                    schemeEndDate = null;
                    curPeriodBeginDate = null;
                    curPeriodEndDate = null;
                    curYearBeginDate = null;
                    curYearEndDate = null;
                    String schemeQuery = "select TOP 1 FDateFrom, FDateTo, FPeriod from T_BG_BgScheme where FId = ?";
                    String curPeriodQuery = "select FBeginDate,FEndDate,FYear,FPeriodType from T_BG_BgPeriod where FId = ?";
                    IRowSet rst = null;
                    try {
                        rst = DbUtil.executeQuery((Context)ctx, (String)schemeQuery, (Object[])new String[]{bgSchemeId});
                        if (rst.next()) {
                            schemeBeginDate = rst.getDate("FDateFrom");
                            schemeEndDate = rst.getDate("FDateTo");
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        rst = DbUtil.executeQuery((Context)ctx, (String)curPeriodQuery, (Object[])new String[]{curPeriodId});
                        if (rst.next()) {
                            curPeriodBeginDate = rst.getDate("FBeginDate");
                            curPeriodEndDate = rst.getDate("FEndDate");
                            int curPeriodYear = rst.getInt("FYear");
                            GregorianCalendar beginCalendar = new GregorianCalendar();
                            beginCalendar.set(1, curPeriodYear);
                            beginCalendar.set(2, 0);
                            beginCalendar.set(5, 1);
                            beginCalendar.set(11, 0);
                            beginCalendar.set(12, 0);
                            beginCalendar.set(13, 0);
                            curYearBeginDate = beginCalendar.getTime();
                            GregorianCalendar endCalendar = new GregorianCalendar();
                            endCalendar.set(1, curPeriodYear);
                            endCalendar.set(2, 11);
                            endCalendar.set(5, 31);
                            endCalendar.set(11, 23);
                            endCalendar.set(12, 59);
                            endCalendar.set(13, 59);
                            curYearEndDate = endCalendar.getTime();
                            periodType = rst.getInt("FPeriodType");
                        }
                    }
                    catch (SQLException ex) {
                        try {
                            logger.error((Object)"budget error:", (Throwable)ex);
                            throw new BgException(BgException.DATABASEERROR, ex);
                            catch (Exception ex2) {
                                logger.error((Object)"budget error:", (Throwable)ex2);
                                throw new BOSException((Throwable)ex2);
                            }
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    if (ctrlTypeEnum == BgCtrlTypeEnum.NoCtrl || ctrlTypeEnum == BgCtrlTypeEnum.PeriodCtrl || periodType == 8) {
                        bgPeriodIds.add(curPeriodId);
                        return bgPeriodIds;
                    }
                    if (ctrlTypeEnum != BgCtrlTypeEnum.AddUpCtrl) break block26;
                    if (!isForActual) {
                        beginDate = schemeBeginDate;
                        endDate = curPeriodEndDate;
                        break block25;
                    } else if (balanceType == BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance || balanceType == BgGetPeriodTypeForGetBlanceEnum.Is_BgTrace_Init_Bal) {
                        beginDate = schemeBeginDate;
                        endDate = curPeriodEndDate;
                        break block25;
                    } else {
                        beginDate = schemeBeginDate;
                        endDate = schemeEndDate;
                    }
                    break block25;
                }
                if (ctrlTypeEnum != BgCtrlTypeEnum.TotalCtrl) break block27;
                if (!isForActual) {
                    beginDate = schemeBeginDate;
                    endDate = schemeEndDate;
                    break block25;
                } else if (balanceType == BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance || balanceType == BgGetPeriodTypeForGetBlanceEnum.Is_BgTrace_Init_Bal) {
                    beginDate = schemeBeginDate;
                    endDate = curPeriodEndDate;
                    break block25;
                } else {
                    beginDate = schemeBeginDate;
                    endDate = schemeEndDate;
                }
                break block25;
            }
            if (ctrlTypeEnum == BgCtrlTypeEnum.ThisYearCtrl && schemeBeginDate != null) {
                if (!isForActual) {
                    beginDate = schemeBeginDate.before(curYearBeginDate) ? curYearBeginDate : (curPeriodBeginDate != null && curPeriodBeginDate.before(schemeBeginDate) ? curPeriodBeginDate : schemeBeginDate);
                    endDate = curYearEndDate != null && curYearEndDate.after(schemeEndDate) ? schemeEndDate : curYearEndDate;
                } else if (balanceType == BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance || balanceType == BgGetPeriodTypeForGetBlanceEnum.Is_BgTrace_Init_Bal) {
                    beginDate = schemeBeginDate.before(curYearBeginDate) ? curYearBeginDate : schemeBeginDate;
                    endDate = curPeriodEndDate;
                } else {
                    beginDate = schemeBeginDate.before(curYearBeginDate) ? curYearBeginDate : schemeBeginDate;
                    endDate = curYearEndDate != null && curYearEndDate.after(schemeEndDate) ? schemeEndDate : curYearEndDate;
                }
            }
        }
        try {
            BgPeriodCollection bgPeriodCol = BgHelper.getBgPeriodCollOverDateRangeBySQL(ctx, periodType, beginDate, endDate);
            if (bgPeriodCol == null || bgPeriodCol.size() <= 0) return bgPeriodIds;
            for (int i = 0; i < bgPeriodCol.size(); ++i) {
                bgPeriodIds.add(bgPeriodCol.get(i).getId().toString());
            }
            return bgPeriodIds;
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgDataInfo getBgData(Context ctx, String orgUnitId, String bgSchemeId, String formula, boolean isCtrl) throws BOSException, EASBizException {
        BgDataInfo bgDataInfo;
        IRowSet rst;
        block8: {
            if (BudgetCtrlUtil.isEmpty(orgUnitId) || BudgetCtrlUtil.isEmpty(bgSchemeId) || BudgetCtrlUtil.isEmpty(formula)) {
                return null;
            }
            StringBuffer SQL = new StringBuffer(2048);
            SQL.append(" select d.FId,");
            SQL.append("        d.FBgValue,");
            SQL.append("        d.FBizActual,");
            SQL.append("        d.FFormula,");
            SQL.append("        d.FBgPeriodId,");
            SQL.append("        d.FBgFormId,");
            SQL.append("        d.FBgElementId,");
            SQL.append("        d.FCurrencyId,");
            SQL.append("        d.FOrgUnitId,");
            SQL.append("        d.FBgSchemeId,");
            SQL.append("        d.FBgItemCombinId,");
            SQL.append("        d.FIsControl,");
            SQL.append("        d.FIsFlexible,");
            SQL.append("        d.FFlexparam,");
            SQL.append("        d.FCtrlType,");
            SQL.append("        d.FIsGroupCtrl,");
            SQL.append("        d.FGroupNo,");
            SQL.append("        d.FIsAllowAccess");
            SQL.append("   from T_BG_BgData d,");
            SQL.append("        T_BG_BgScheme s,");
            SQL.append("        T_BG_BgForm f");
            SQL.append("  where d.FBgFormId = f.fid");
            SQL.append("    and d.FBgSchemeId = s.fid");
            SQL.append("    and d.FOrgUnitId = ?");
            SQL.append("    and d.FBgSchemeId = ?");
            SQL.append("    and d.FFormula = ?");
            if (isCtrl) {
                SQL.append("    and d.FDataState =9");
                SQL.append("    and s.FIsFormal = 1");
            }
            rst = null;
            logger.info((Object)"------------kingdee logger by budget,get BgData SQL--------------");
            logger.info((Object)SQL.toString());
            logger.info((Object)"------------params--------------");
            logger.info((Object)("orgUnitId = " + orgUnitId));
            logger.info((Object)("bgSchemeId = " + bgSchemeId));
            logger.info((Object)("formula = " + formula));
            rst = DbUtil.executeQuery((Context)ctx, (String)SQL.toString(), (Object[])new String[]{orgUnitId, bgSchemeId, formula});
            if (rst.next()) break block8;
            BgDataInfo bgDataInfo2 = null;
            SQLUtils.cleanup((ResultSet)rst);
            return bgDataInfo2;
        }
        try {
            BgDataInfo info = new BgDataInfo();
            info.setId(BOSUuid.read((String)rst.getString("FId")));
            info.setBgValue(rst.getBigDecimal("FBgValue"));
            info.setBizActual(rst.getBigDecimal("FBizActual"));
            info.setFormula(rst.getString("FFormula"));
            BgPeriodInfo bgPeriod = new BgPeriodInfo();
            bgPeriod.setId(BOSUuid.read((String)rst.getString("FBgPeriodId")));
            info.setBgPeriod(bgPeriod);
            BgElementInfo element = new BgElementInfo();
            element.setId(BOSUuid.read((String)rst.getString("FBgElementId")));
            info.setBgElement(element);
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)rst.getString("FCurrencyId")));
            info.setCurrency(currency);
            FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
            orgUnit.setId(BOSUuid.read((String)rst.getString("FOrgUnitId")));
            info.setOrgUnit(orgUnit);
            BgSchemeInfo bgScheme = new BgSchemeInfo();
            bgScheme.setId(BOSUuid.read((String)rst.getString("FBgSchemeId")));
            info.setBgScheme(bgScheme);
            info.setBgItemCombinId(rst.getString("FBgItemCombinId"));
            info.setIsControl(rst.getBoolean("FIsControl"));
            info.setIsFlexible(rst.getBoolean("FIsFlexible"));
            info.setFlexParam(rst.getBigDecimal("FFlexparam"));
            info.setCtrlType(BgCtrlTypeEnum.getEnum(rst.getInt("FCtrlType")));
            info.setIsGroupCtrl(rst.getBoolean("FIsGroupCtrl"));
            info.setGroupNo(rst.getString("FGroupNo"));
            info.setIsAllowAccess(rst.getBoolean("FIsAllowAccess"));
            bgDataInfo = info;
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgDataInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgDataInfo getBgData1(Context ctx, String orgUnitId, String bgSchemeId, String formula, boolean isCtrl) throws BOSException, EASBizException {
        BgDataInfo bgDataInfo;
        IRowSet rst;
        block8: {
            if (BudgetCtrlUtil.isEmpty(orgUnitId) || BudgetCtrlUtil.isEmpty(bgSchemeId) || BudgetCtrlUtil.isEmpty(formula)) {
                return null;
            }
            StringBuffer SQL = new StringBuffer(2048);
            SQL.append(" select d.FId,");
            SQL.append("        d.FBgValue,");
            SQL.append("        d.FBizActual,");
            SQL.append("        d.FFormula,");
            SQL.append("        d.FBgPeriodId,");
            SQL.append("        d.FBgFormId,");
            SQL.append("        d.FBgElementId,");
            SQL.append("        d.FCurrencyId,");
            SQL.append("        d.FOrgUnitId,");
            SQL.append("        d.FBgSchemeId,");
            SQL.append("        d.FBgItemCombinId,");
            SQL.append("        d.FIsControl,");
            SQL.append("        d.FIsFlexible,");
            SQL.append("        d.FFlexparam,");
            SQL.append("        d.FCtrlType,");
            SQL.append("        d.FIsGroupCtrl,");
            SQL.append("        d.FGroupNo,");
            SQL.append("        d.FIsAllowAccess");
            SQL.append("   from T_BG_BgData d,");
            SQL.append("        T_BG_BgScheme s,");
            SQL.append("        T_BG_BgForm f");
            SQL.append("  where d.FBgFormId = f.fid");
            SQL.append("    and d.FBgSchemeId = s.fid");
            SQL.append("    and d.FOrgUnitId = ?");
            SQL.append("    and d.FBgSchemeId = ?");
            SQL.append("    and d.FFormula = ?");
            if (isCtrl) {
                SQL.append("    and d.FDataState =9");
            }
            rst = null;
            logger.info((Object)"------------kingdee logger by budget,get BgData1 SQL--------------");
            logger.info((Object)SQL.toString());
            logger.info((Object)"------------params--------------");
            logger.info((Object)("orgUnitId = " + orgUnitId));
            logger.info((Object)("bgSchemeId = " + bgSchemeId));
            logger.info((Object)("formula = " + formula));
            rst = DbUtil.executeQuery((Context)ctx, (String)SQL.toString(), (Object[])new String[]{orgUnitId, bgSchemeId, formula});
            if (rst.next()) break block8;
            BgDataInfo bgDataInfo2 = null;
            SQLUtils.cleanup((ResultSet)rst);
            return bgDataInfo2;
        }
        try {
            BgDataInfo info = new BgDataInfo();
            info.setId(BOSUuid.read((String)rst.getString("FId")));
            info.setBgValue(rst.getBigDecimal("FBgValue"));
            info.setBizActual(rst.getBigDecimal("FBizActual"));
            info.setFormula(rst.getString("FFormula"));
            BgPeriodInfo bgPeriod = new BgPeriodInfo();
            bgPeriod.setId(BOSUuid.read((String)rst.getString("FBgPeriodId")));
            info.setBgPeriod(bgPeriod);
            BgElementInfo element = new BgElementInfo();
            element.setId(BOSUuid.read((String)rst.getString("FBgElementId")));
            info.setBgElement(element);
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)rst.getString("FCurrencyId")));
            info.setCurrency(currency);
            FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
            orgUnit.setId(BOSUuid.read((String)rst.getString("FOrgUnitId")));
            info.setOrgUnit(orgUnit);
            BgSchemeInfo bgScheme = new BgSchemeInfo();
            bgScheme.setId(BOSUuid.read((String)rst.getString("FBgSchemeId")));
            info.setBgScheme(bgScheme);
            info.setBgItemCombinId(rst.getString("FBgItemCombinId"));
            info.setIsControl(rst.getBoolean("FIsControl"));
            info.setIsFlexible(rst.getBoolean("FIsFlexible"));
            info.setFlexParam(rst.getBigDecimal("FFlexparam"));
            info.setCtrlType(BgCtrlTypeEnum.getEnum(rst.getInt("FCtrlType")));
            info.setIsGroupCtrl(rst.getBoolean("FIsGroupCtrl"));
            info.setGroupNo(rst.getString("FGroupNo"));
            info.setIsAllowAccess(rst.getBoolean("FIsAllowAccess"));
            bgDataInfo = info;
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgDataInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgCtrlResultCollection calcuBalCol(Context ctx, BgCtrlParamInfo ctrlParamInfo, boolean isCtrl, BgGetPeriodTypeForGetBlanceEnum balTypeEnum) throws BOSException, EASBizException {
        BgCtrlResultCollection col = new BgCtrlResultCollection();
        BgCtrlResultInfo ctrlResultInfo = new BgCtrlResultInfo();
        BgCtrlResultInfo ctrlResultInfo2 = new BgCtrlResultInfo();
        ctrlResultInfo = BudgetCtrlHelper.fillCtrlParam2CtrlResult(ctrlParamInfo, ctrlResultInfo);
        ctrlResultInfo2 = BudgetCtrlHelper.fillCtrlParam2CtrlResult(ctrlParamInfo, ctrlResultInfo2);
        String orgUnitId = ctrlParamInfo.getOrgUnitId();
        String bgSchemeId = ctrlParamInfo.getBgSchemeId();
        String formula = ctrlParamInfo.getItemFormula();
        BgPeriodEnum periodTypeEnum = ctrlParamInfo.getPeriodType();
        String itemNum = null;
        String itemName = null;
        String[] item = new String[2];
        boolean isSelUp = false;
        BgDataInfo bgDataInfo = null;
        String BOName = "";
        if (ctrlParamInfo.getString("BOName") != null) {
            BOName = ctrlParamInfo.getString("BOName");
        }
        if (BudgetCtrlUtil.isEmpty(bgDataInfo = BOName.equals("com.kingdee.eas.ma.nbudget.app.BudgetRequestBill") ? BgBalCalculator.getBgData1(ctx, orgUnitId, bgSchemeId, formula, isCtrl) : BgBalCalculator.getBgData(ctx, orgUnitId, bgSchemeId, formula, isCtrl)) || BudgetCtrlHelper.isEmptyBgData(ctx, bgDataInfo)) {
            ctrlResultInfo.setBgDataId(null);
            ctrlResultInfo.setBalance(null);
            col.add(ctrlResultInfo);
            return col;
        }
        String[] params = BgNFSHelper.parseFormulaPara((String)bgDataInfo.getFormula());
        String itemCombId = bgDataInfo.getBgItemCombinId();
        String bgPeriodId = bgDataInfo.getBgPeriod().getId().toString();
        String bgElementId = bgDataInfo.getBgElement().getId().toString();
        String currencyId = bgDataInfo.getCurrency().getId().toString();
        String bgDataId = bgDataInfo.getId().toString();
        BigDecimal bgValue = bgDataInfo.getBgValue();
        BigDecimal bizActual = bgDataInfo.getBizActual();
        boolean isControl = bgDataInfo.isIsControl();
        boolean isFlexible = bgDataInfo.isIsFlexible();
        BigDecimal flexParam = isFlexible ? bgDataInfo.getFlexParam() : BudgetCtrlConstants.ONE_AMOUNT;
        BgCtrlTypeEnum ctrlType = bgDataInfo.getCtrlType();
        boolean isGroupCtrl = bgDataInfo.isIsGroupCtrl();
        String groupNo = isGroupCtrl ? bgDataInfo.getGroupNo() : null;
        boolean isAllowAccess = bgDataInfo.isIsAllowAccess();
        ctrlResultInfo.setBgDataId(bgDataId);
        ctrlResultInfo.setBgValue(bgValue);
        ctrlResultInfo.setBizActual(bizActual);
        ctrlResultInfo.setIsAllowAccess(isAllowAccess);
        ctrlResultInfo.setCtrlType(ctrlType);
        ctrlResultInfo2.setBgDataId(bgDataId);
        ctrlResultInfo2.setBgValue(bgValue);
        ctrlResultInfo2.setBizActual(bizActual);
        ctrlResultInfo2.setIsAllowAccess(isAllowAccess);
        ctrlResultInfo2.setCtrlType(ctrlType);
        if (periodTypeEnum == null) {
            IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("periodType"));
            periodTypeEnum = iBgPeriod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgPeriodId), sic).getPeriodType();
        }
        if (balTypeEnum != BgGetPeriodTypeForGetBlanceEnum.Is_BgTrace_Init_Bal && (!isControl || !isGroupCtrl && ctrlType == BgCtrlTypeEnum.PeriodCtrl || !isGroupCtrl && periodTypeEnum == BgPeriodEnum.PERSONAL)) {
            BigDecimal avlBalance = bgValue.multiply(flexParam).subtract(bizActual);
            ctrlResultInfo.setBalance(avlBalance);
            ctrlResultInfo.put("sumBudgetValue", bgValue.multiply(flexParam));
            ctrlResultInfo.put("sumActualValue", bizActual);
            ctrlResultInfo.put("bgData", bgDataInfo);
            col.add(ctrlResultInfo);
            return col;
        }
        List bgPeriods = null;
        List acPeriods = null;
        List<String> bgValPeriodIds = null;
        List<String> actValPeriodIds = null;
        HashMap allPeriodMap = null;
        BgPeriodInfo period = null;
        IRowSet rst = null;
        if (isGroupCtrl) {
            bgValPeriodIds = BgBalCalculator.getBgValPeriodIds(ctx, bgSchemeId, bgPeriodId, ctrlType, balTypeEnum);
            actValPeriodIds = BgBalCalculator.getActValPeriodIds(ctx, bgSchemeId, bgPeriodId, ctrlType, balTypeEnum);
            allPeriodMap = new HashMap();
            for (int i = 0; i < bgValPeriodIds.size(); ++i) {
                allPeriodMap.put(bgValPeriodIds.get(i), null);
            }
            for (int j = 0; j < actValPeriodIds.size(); ++j) {
                allPeriodMap.put(actValPeriodIds.get(j), null);
            }
            StringBuffer SQL = new StringBuffer(2048);
            SQL.append(" select d.FBgValue,");
            SQL.append("        d.FIsFlexible,");
            SQL.append("        d.FFlexParam,");
            SQL.append("        d.FBizActual,");
            SQL.append("        d.FId,");
            SQL.append("        d.FBgPeriodId");
            SQL.append("   from T_BG_BgData d");
            SQL.append("  where d.FOrgUnitId = ?");
            SQL.append("    and d.FBgSchemeId = ?");
            SQL.append("    and d.FCurrencyId = ?");
            SQL.append("    and d.FBgPeriodId in " + BgHelper.tranSet2String(allPeriodMap.keySet()));
            if (isCtrl) {
                SQL.append(" and d.FDataState =9");
            }
            SQL.append("    and d.FGroupNo = ?");
            rst = DbUtil.executeQuery((Context)ctx, (String)SQL.toString(), (Object[])new String[]{orgUnitId, bgSchemeId, currencyId, groupNo});
            BigDecimal sumBgVal = BudgetCtrlConstants.ZERO_AMOUNT;
            BigDecimal sumBizActual = BudgetCtrlConstants.ZERO_AMOUNT;
            BigDecimal avlBalance = BudgetCtrlConstants.ZERO_AMOUNT;
            while (rst.next()) {
                String _periodId = rst.getString("FBgPeriodId");
                if (bgValPeriodIds.contains(_periodId)) {
                    BigDecimal _bgValue = rst.getBigDecimal("FBgValue");
                    BigDecimal _flexParam = rst.getBoolean("FIsFlexible") ? rst.getBigDecimal("FFlexParam") : BudgetCtrlConstants.ONE_AMOUNT;
                    sumBgVal = sumBgVal.add(_bgValue.multiply(_flexParam));
                }
                if (!actValPeriodIds.contains(_periodId)) continue;
                BigDecimal _bizActual = rst.getBigDecimal("FBizActual");
                sumBizActual = sumBizActual.add(_bizActual);
            }
            ctrlResultInfo.put("sumBudgetValue", sumBgVal);
            ctrlResultInfo.put("sumActualValue", sumBizActual);
            ctrlResultInfo.put("bgData", bgDataInfo);
            avlBalance = sumBgVal.subtract(sumBizActual);
            ctrlResultInfo.setBalance(avlBalance);
            itemNum = ctrlResultInfo.getItemCombinNumber();
            itemName = ctrlResultInfo.getItemCombinName();
            item = BgBalCalculator.getUpItem(ctx, itemNum, itemName, orgUnitId);
            if (item != null) {
                isSelUp = true;
                ctrlResultInfo.setItemCombinNumber(item[0]);
                ctrlResultInfo.setItemCombinName(item[1]);
            }
            col.add(ctrlResultInfo);
        }
        bgValPeriodIds = new ArrayList();
        actValPeriodIds = new ArrayList();
        HashSet<String> formulaStrs = new HashSet<String>();
        allPeriodMap = new HashMap();
        String periodID = null;
        try {
            int i;
            bgPeriods = BgBalCalculator.getBgValPeriods(ctx, bgSchemeId, bgPeriodId, ctrlType, balTypeEnum);
            int in = bgPeriods.size();
            for (i = 0; i < in; ++i) {
                period = (BgPeriodInfo)bgPeriods.get(i);
                periodID = period.getId().toString();
                bgValPeriodIds.add(periodID);
                allPeriodMap.put(periodID, null);
                params[1] = period.getNumber();
                formulaStrs.add(BgNFSHelper.getFormulaFromParam((String[])params));
            }
            acPeriods = BgBalCalculator.getActValPeriods(ctx, bgSchemeId, bgPeriodId, ctrlType, balTypeEnum);
            in = acPeriods.size();
            for (i = 0; i < in; ++i) {
                period = (BgPeriodInfo)acPeriods.get(i);
                periodID = period.getId().toString();
                actValPeriodIds.add(periodID);
                allPeriodMap.put(periodID, null);
                params[1] = period.getNumber();
                formulaStrs.add(BgNFSHelper.getFormulaFromParam((String[])params));
            }
            StringBuffer SQL = new StringBuffer(2048);
            SQL.append(" select d.FBgValue,");
            SQL.append("        d.FIsFlexible,");
            SQL.append("        d.FFlexParam,");
            SQL.append("        d.FBizActual,");
            SQL.append("        d.FId,");
            SQL.append("        d.FBgPeriodId");
            SQL.append("   from T_BG_BgData d");
            SQL.append("  where d.FOrgUnitId = ?");
            SQL.append("    and d.FBgSchemeId = ?");
            if (!isGroupCtrl) {
                SQL.append("    and d.FBgElementId = ?");
            }
            SQL.append("    and d.FCurrencyId = ?");
            SQL.append("    and d.FBgPeriodId in " + BgHelper.tranSet2String(allPeriodMap.keySet()));
            if (isCtrl) {
                SQL.append("    and d.FDataState =9");
            }
            if (!isGroupCtrl) {
                ArrayList<String> sqlParams = new ArrayList<String>();
                sqlParams.add(orgUnitId);
                sqlParams.add(bgSchemeId);
                sqlParams.add(bgElementId);
                sqlParams.add(currencyId);
                sqlParams.add(itemCombId);
                sqlParams.addAll(formulaStrs);
                SQL.append(" and d.FBgItemCombinId = ?");
                SQL.append(" and d.FFormula IN (" + BgNSQLHelper.getParamSizeString((int)formulaStrs.size()) + ")");
                rst = DbUtil.executeQuery((Context)ctx, (String)SQL.toString(), (Object[])sqlParams.toArray());
            } else {
                SQL.append("    and d.FGroupNo = ?");
                rst = DbUtil.executeQuery((Context)ctx, (String)SQL.toString(), (Object[])new String[]{orgUnitId, bgSchemeId, currencyId, groupNo});
            }
            BigDecimal sumBgVal = BudgetCtrlConstants.ZERO_AMOUNT;
            BigDecimal sumBizActual = BudgetCtrlConstants.ZERO_AMOUNT;
            BigDecimal avlBalance = BudgetCtrlConstants.ZERO_AMOUNT;
            while (rst.next()) {
                String _periodId = rst.getString("FBgPeriodId");
                if (bgValPeriodIds.contains(_periodId)) {
                    BigDecimal _bgValue = rst.getBigDecimal("FBgValue");
                    BigDecimal _flexParam = rst.getBoolean("FIsFlexible") ? rst.getBigDecimal("FFlexParam") : BudgetCtrlConstants.ONE_AMOUNT;
                    sumBgVal = sumBgVal.add(_bgValue.multiply(_flexParam));
                }
                if (!actValPeriodIds.contains(_periodId)) continue;
                BigDecimal _bizActual = rst.getBigDecimal("FBizActual");
                sumBizActual = sumBizActual.add(_bizActual);
            }
            ctrlResultInfo.put("sumBudgetValue", sumBgVal);
            ctrlResultInfo.put("sumActualValue", sumBizActual);
            ctrlResultInfo.put("bgData", bgDataInfo);
            avlBalance = sumBgVal.subtract(sumBizActual);
            ctrlResultInfo.setBalance(avlBalance);
            col.add(ctrlResultInfo);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return col;
        SQLUtils.cleanup((ResultSet)rst);
        if (!isSelUp) return col;
        bgValPeriodIds = new ArrayList();
        actValPeriodIds = new ArrayList();
        formulaStrs = new HashSet<String>();
        allPeriodMap = new HashMap();
        periodID = null;
        try {
            int i;
            bgPeriods = BgBalCalculator.getBgValPeriods(ctx, bgSchemeId, bgPeriodId, ctrlType, balTypeEnum);
            int in = bgPeriods.size();
            for (i = 0; i < in; ++i) {
                period = (BgPeriodInfo)bgPeriods.get(i);
                periodID = period.getId().toString();
                bgValPeriodIds.add(periodID);
                allPeriodMap.put(periodID, null);
                params[1] = period.getNumber();
                formulaStrs.add(BgNFSHelper.getFormulaFromParam((String[])params));
            }
            acPeriods = BgBalCalculator.getActValPeriods(ctx, bgSchemeId, bgPeriodId, ctrlType, balTypeEnum);
            in = acPeriods.size();
            for (i = 0; i < in; ++i) {
                period = (BgPeriodInfo)acPeriods.get(i);
                periodID = period.getId().toString();
                actValPeriodIds.add(periodID);
                allPeriodMap.put(periodID, null);
                params[1] = period.getNumber();
                formulaStrs.add(BgNFSHelper.getFormulaFromParam((String[])params));
            }
            StringBuffer SQL = new StringBuffer(2048);
            SQL.append(" select d.FBgValue,");
            SQL.append("        d.FIsFlexible,");
            SQL.append("        d.FFlexParam,");
            SQL.append("        d.FBizActual,");
            SQL.append("        d.FId,");
            SQL.append("        d.FBgPeriodId");
            SQL.append("   from T_BG_BgData d");
            SQL.append("  where d.FOrgUnitId = ?");
            SQL.append("    and d.FBgSchemeId = ?");
            SQL.append("    and d.FBgElementId = ?");
            SQL.append("    and d.FCurrencyId = ?");
            SQL.append("    and d.FBgPeriodId in " + BgHelper.tranSet2String(allPeriodMap.keySet()));
            if (isCtrl) {
                SQL.append("    and d.FDataState =9");
            }
            SQL.append("    and d.FBgItemCombinId = ?");
            SQL.append(" and d.FFormula IN (" + BgNSQLHelper.getParamSizeString((int)formulaStrs.size()) + ")");
            ArrayList<String> sqlParams = new ArrayList<String>();
            sqlParams.add(orgUnitId);
            sqlParams.add(bgSchemeId);
            sqlParams.add(bgElementId);
            sqlParams.add(currencyId);
            sqlParams.add(itemCombId);
            sqlParams.addAll(formulaStrs);
            rst = DbUtil.executeQuery((Context)ctx, (String)SQL.toString(), (Object[])sqlParams.toArray());
            BigDecimal sumBgVal = BudgetCtrlConstants.ZERO_AMOUNT;
            BigDecimal sumBizActual = BudgetCtrlConstants.ZERO_AMOUNT;
            BigDecimal avlBalance = BudgetCtrlConstants.ZERO_AMOUNT;
            while (rst.next()) {
                String _periodId = rst.getString("FBgPeriodId");
                if (bgValPeriodIds.contains(_periodId)) {
                    BigDecimal _bgValue = rst.getBigDecimal("FBgValue");
                    BigDecimal _flexParam = rst.getBoolean("FIsFlexible") ? rst.getBigDecimal("FFlexParam") : BudgetCtrlConstants.ONE_AMOUNT;
                    sumBgVal = sumBgVal.add(_bgValue.multiply(_flexParam));
                }
                if (!actValPeriodIds.contains(_periodId)) continue;
                BigDecimal _bizActual = rst.getBigDecimal("FBizActual");
                sumBizActual = sumBizActual.add(_bizActual);
            }
            ctrlResultInfo2.put("sumBudgetValue", sumBgVal);
            ctrlResultInfo2.put("sumActualValue", sumBizActual);
            ctrlResultInfo2.put("bgData", bgDataInfo);
            avlBalance = sumBgVal.subtract(sumBizActual);
            ctrlResultInfo2.setBalance(avlBalance);
            ctrlResultInfo2.put("IS_REQUEST_BUDGET", Boolean.FALSE);
            col.add(ctrlResultInfo2);
            return col;
        }
        catch (SQLException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, ex);
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
                catch (Exception ex3) {
                    logger.error((Object)"budget error:", (Throwable)ex3);
                    throw new BOSException((Throwable)ex3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] getUpItem(Context ctx, String itemNum, String itemName, String orgUnitId) throws BOSException, EASBizException {
        String[] ex322222;
        IRowSet rst;
        String[] item;
        block18: {
            item = new String[2];
            if (itemNum == null) return null;
            if (itemName == null) {
                return null;
            }
            if (itemNum.split(",").length > 1) {
                IRowSet rst2;
                block17: {
                    String[] stringArray;
                    item[0] = itemNum.split(",")[0];
                    if (itemName.split("\u3001").length == itemNum.split(",").length) {
                        item[1] = itemName.split("\u3001")[0];
                    } else if (itemName.split("_").length == itemNum.split(",").length) {
                        item[1] = itemName.split("_")[0];
                    }
                    String sql = "select fnumber, fname_" + ctx.getLocale() + " as fname from t_bg_bgitem where fid in (select FParentId from t_bg_bgitem where fnumber = ? and fOrgUnitId = ? and fparentid <> fid)";
                    rst2 = null;
                    try {
                        rst2 = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{item[0], BgSHelper.getIsolateOrg(ctx, orgUnitId)});
                        if (rst2.next()) {
                            item[0] = rst2.getString("fnumber") + itemNum.substring(itemNum.indexOf(","));
                            item[1] = rst2.getString("fname") + itemName.substring(itemName.indexOf("_"));
                            break block17;
                        }
                        item[0] = itemNum;
                        item[1] = itemName;
                        stringArray = item;
                    }
                    catch (SQLException ex2) {
                        try {
                            logger.error((Object)"budget error:", (Throwable)ex2);
                            throw new BgException(BgException.DATABASEERROR, ex2);
                            catch (Exception ex322222) {
                                logger.error((Object)"budget error:", (Throwable)ex322222);
                                throw new BOSException((Throwable)ex322222);
                            }
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst2);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rst2);
                    return stringArray;
                }
                SQLUtils.cleanup((ResultSet)rst2);
                return item;
            }
            String sql = "select fnumber, fname_" + ctx.getLocale() + " as fname from t_bg_bgitem where fid in (select FParentId from t_bg_bgitem where fnumber = ? and fOrgUnitId = ? and fparentid <> fid)";
            rst = null;
            rst = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{itemNum, orgUnitId});
            if (!rst.next()) break block18;
            item[0] = rst.getString("fnumber");
            item[1] = rst.getString("fname");
            String[] ex322222 = item;
            SQLUtils.cleanup((ResultSet)rst);
            return ex322222;
        }
        try {
            item[0] = itemNum;
            item[1] = itemName;
            ex322222 = item;
        }
        catch (SQLException ex4) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex4);
                throw new BgException(BgException.DATABASEERROR, ex4);
                catch (Exception ex5) {
                    logger.error((Object)"budget error:", (Throwable)ex5);
                    throw new BOSException((Throwable)ex5);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return ex322222;
    }
}

