/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.app.AbstractBgBudgetFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgBudgetFacadeControllerBean
extends AbstractBgBudgetFacadeControllerBean {
    private static final long serialVersionUID = -8448140459945887960L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgBudgetFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _processBudgetBalance(Context ctx, List paraBalance) throws BOSException, EASBizException {
        ArrayList<String[]> balance = new ArrayList<String[]>();
        if (paraBalance == null) return balance;
        if (paraBalance.isEmpty()) {
            return balance;
        }
        String noFindStr = "#";
        String[] sBalance = null;
        String[] bgItems = null;
        String[] parameter = null;
        HashMap formulaMap = new HashMap();
        HashMap<String, String[]> balMap = new HashMap<String, String[]>();
        Map bgItemsMap = null;
        Map currencyMap = null;
        HashSet<String> bgItemsSet = new HashSet<String>();
        HashSet<String> currencySet = new HashSet<String>();
        Map bgPeriodMap = new HashMap();
        Map bgElementMap = new HashMap();
        HashSet<String> bgPeriodSet = new HashSet<String>();
        HashSet<String> elementSet = new HashSet<String>();
        CurrencyInfo currencyInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            int n = paraBalance.size();
            for (int i = 0; i < n; ++i) {
                sBalance = (String[])paraBalance.get(i);
                if (balMap.containsKey(sBalance[0])) continue;
                parameter = this.getFormulaInfo(formulaMap, sBalance[3]);
                balMap.put(sBalance[0], sBalance);
                bgItems = parameter[0].split(",");
                for (int j = 0; j < bgItems.length; ++j) {
                    bgItemsSet.add(bgItems[j]);
                }
                currencySet.add(parameter[5]);
                bgPeriodSet.add(parameter[1]);
                elementSet.add(parameter[2]);
            }
            bgItemsMap = this.getBudgetItemInfo(ctx, bgItemsSet);
            currencyMap = this.getBudgetCurrencyInfo(ctx, currencySet);
            bgPeriodMap = this.getPeriodInfo(ctx, bgPeriodSet);
            bgElementMap = this.getElementInfo(ctx, elementSet);
            int index = 0;
            int batchNum = 25;
            int size = paraBalance.size();
            int count = (size - 1) / batchNum + 1;
            int pos = 0;
            StringBuffer sql = new StringBuffer(2048);
            sql.append("select FID,FBgValue,FBizActual from T_BG_BgData where ");
            for (index = 0; index < batchNum; ++index) {
                if (index + 1 < batchNum) {
                    sql.append("(FOrgUnitId=? AND FBgSchemeId=? AND FFormula=?) OR ");
                    continue;
                }
                sql.append("(FOrgUnitId=? AND FBgSchemeId=? AND FFormula=?)");
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int k = 1; k <= batchNum; ++k, ++pos) {
                    if (pos < size) {
                        sBalance = (String[])paraBalance.get(pos);
                        pstmt.setString((k - 1) * 3 + 1, sBalance[1]);
                        pstmt.setString((k - 1) * 3 + 2, sBalance[2]);
                        pstmt.setString((k - 1) * 3 + 3, sBalance[3]);
                        continue;
                    }
                    pstmt.setString((k - 1) * 3 + 1, noFindStr);
                    pstmt.setString((k - 1) * 3 + 2, noFindStr);
                    pstmt.setString((k - 1) * 3 + 3, noFindStr);
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        if (!balMap.containsKey(rst.getString("FID"))) continue;
                        sBalance = (String[])balMap.get(rst.getString("FID"));
                        parameter = this.getFormulaInfo(formulaMap, sBalance[3]);
                        bgItems = parameter[0].split(",");
                        for (int x = 0; x < bgItems.length; ++x) {
                            sBalance[4] = x == 0 ? ((BgItemInfo)bgItemsMap.get(bgItems[x])).getName() : sBalance[4] + "|" + ((BgItemInfo)bgItemsMap.get(bgItems[x])).getName();
                        }
                        currencyInfo = (CurrencyInfo)currencyMap.get(parameter[5]);
                        sBalance[5] = rst.getBigDecimal("FBgValue").setScale(currencyInfo.getPrecision(), 4).toString();
                        sBalance[6] = rst.getBigDecimal("FBizActual").setScale(currencyInfo.getPrecision(), 4).toString();
                        String periodName = "";
                        Object period = bgPeriodMap.get(parameter[1]);
                        if (period != null) {
                            periodName = ((BgPeriodInfo)period).getName();
                        }
                        sBalance[10] = periodName;
                        String elmentName = "";
                        Object elment = bgElementMap.get(parameter[2]);
                        if (elment != null) {
                            elmentName = ((BgElementInfo)elment).getName();
                        }
                        sBalance[11] = elmentName;
                        sBalance[8] = this.getCostCenterNameByBgDataId(ctx, sBalance[0]);
                        balance.add(sBalance);
                    }
                    continue;
                }
                finally {
                    if (rst != null) {
                        rst.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
                catch (BOSException ex3) {
                    logger.error((Object)ex3.getMessage());
                    throw ex3;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return balance;
    }

    private String getCostCenterNameByBgDataId(Context ctx, String bgDataId) throws BOSException {
        if (bgDataId == null || bgDataId.length() == 0) {
            return "";
        }
        String SQL = " select b.fname_" + ctx.getLocale() + " from t_bg_bgdata a ,t_org_baseunit b  where a.fid = ? and a.forgunitid = b.fid ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SQL, (Object[])new Object[]{bgDataId});
        try {
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return "";
    }

    private Map getBudgetItemInfo(Context ctx, Set items) throws BOSException, EASBizException {
        if (ctx == null || items == null || items.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, BgItemInfo> itemsMap = new HashMap<String, BgItemInfo>();
        BgItemInfo info = null;
        BgItemCollection col = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)items, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        view.setFilter(filter);
        try {
            IBgItem bgItem = BgItemFactory.getLocalInstance(ctx);
            if (bgItem == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            col = bgItem.getBgItemCollection(view);
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                info = col.get(i);
                itemsMap.put(info.getNumber(), info);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        return itemsMap;
    }

    private Map getBudgetCurrencyInfo(Context ctx, Set currency) throws BOSException, EASBizException {
        if (ctx == null || currency == null || currency.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        CurrencyInfo info = null;
        CurrencyCollection col = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)currency, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("precision"));
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        view.setFilter(filter);
        try {
            ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            if (icurrency == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            col = icurrency.getCurrencyCollection(view);
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                info = col.get(i);
                currencyMap.put(info.getNumber(), info);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        return currencyMap;
    }

    private Map getPeriodInfo(Context ctx, Set period) throws BOSException, EASBizException {
        if (ctx == null || period == null || period.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, BgPeriodInfo> pMap = new HashMap<String, BgPeriodInfo>();
        BgPeriodInfo info = null;
        BgPeriodCollection col = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)period, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        view.setFilter(filter);
        try {
            IBgPeriod ip = BgPeriodFactory.getLocalInstance(ctx);
            if (ip == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            col = ip.getBgPeriodCollection(view);
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                info = col.get(i);
                pMap.put(info.getNumber(), info);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        return pMap;
    }

    private Map getElementInfo(Context ctx, Set element) throws BOSException, EASBizException {
        if (ctx == null || element == null || element.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, BgElementInfo> eMap = new HashMap<String, BgElementInfo>();
        BgElementInfo info = null;
        BgElementCollection col = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)element, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        view.setFilter(filter);
        try {
            IBgElement ie = BgElementFactory.getLocalInstance(ctx);
            if (ie == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            col = ie.getBgElementCollection(view);
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                info = col.get(i);
                eMap.put(info.getNumber(), info);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        return eMap;
    }

    protected String[] getFormulaInfo(Map map, String formulaString) {
        if (map == null || formulaString == null) {
            return null;
        }
        String[] parameter = null;
        List formulaHint = null;
        FormulaHint formulas = null;
        if (map.containsKey(formulaString)) {
            parameter = (String[])map.get(formulaString);
        } else {
            try {
                formulaHint = TableToolkit.parseFormula((String)formulaString, (boolean)false);
            }
            catch (ParserException ex) {
                logger.error((Object)ex.getMessage());
            }
            if (formulaHint != null) {
                formulas = (FormulaHint)formulaHint.get(0);
                parameter = formulas.getParams();
                map.put(formulaString, parameter);
                formulaHint.clear();
            }
        }
        return parameter;
    }

    @Override
    protected boolean _getAllowAccess(Context ctx, String boName) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _getAllowAccessNoWF(Context ctx, String boName) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected void _processDataWithSchemes(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String srcBgSchemeRootId = (String)paramMap.get("Source_BgScheme");
        String tarBgSchemeRootId = (String)paramMap.get("Target_BgScheme");
        OrgUnitInfo[] orgUnits = (OrgUnitInfo[])paramMap.get("BgOrgUnit");
        if (StringUtils.isEmpty((String)srcBgSchemeRootId) || StringUtils.isEmpty((String)tarBgSchemeRootId) || orgUnits == null || orgUnits.length <= 0) {
            return;
        }
        BigDecimal rateVal = BgHelper.getBigDecimal(paramMap.get("RateValue")).multiply(new BigDecimal("0.01"));
        Map srcSchemeMap = this.getSchemeIdFromRootId(ctx, orgUnits, srcBgSchemeRootId);
        Map tarSchemeMap = this.getSchemeIdFromRootId(ctx, orgUnits, tarBgSchemeRootId);
        Map commonMap = this.getCommonDataMap(ctx, srcSchemeMap, tarSchemeMap);
        ArrayList srcOrgs = new ArrayList();
        srcOrgs.addAll(srcSchemeMap.keySet());
        ArrayList srcBgSchemes = new ArrayList();
        srcBgSchemes.addAll(srcSchemeMap.values());
        Map dataMap = this.getDataMapByScheme(ctx, srcOrgs, srcBgSchemes);
        if (commonMap != null && !commonMap.isEmpty()) {
            String tarOrgScheme2 = null;
            String srcOrgId = null;
            String[] orgSchemeIds = null;
            String formula2 = null;
            BigDecimal newValue = null;
            BigDecimal oldValue = null;
            Map tarFormulaMap = null;
            Map srcFormulaMap = null;
            String tarBgFormId = null;
            BOSUuid bgFormId = null;
            HashMap resultMap = new HashMap();
            for (String tarOrgScheme2 : commonMap.keySet()) {
                orgSchemeIds = tarOrgScheme2.split(",");
                if (orgSchemeIds.length != 2 || StringUtils.isEmpty((String)orgSchemeIds[0]) || StringUtils.isEmpty((String)orgSchemeIds[1]) || StringUtils.isEmpty((String)(srcOrgId = (String)srcSchemeMap.get(orgSchemeIds[0]))) || !dataMap.containsKey(orgSchemeIds[0] + "," + srcOrgId)) continue;
                srcFormulaMap = (Map)dataMap.get(orgSchemeIds[0] + "," + srcOrgId);
                tarFormulaMap = (Map)commonMap.get(tarOrgScheme2);
                for (String formula2 : tarFormulaMap.keySet()) {
                    if (!srcFormulaMap.containsKey(formula2)) continue;
                    newValue = BgHelper.getBigDecimal(srcFormulaMap.get(formula2)).multiply(rateVal);
                    oldValue = BgHelper.getBigDecimal(((Object[])tarFormulaMap.get(formula2))[0]);
                    tarBgFormId = (String)((Object[])tarFormulaMap.get(formula2))[1];
                    if (StringUtils.isEmpty((String)tarBgFormId)) continue;
                    bgFormId = BOSUuid.read((String)tarBgFormId);
                    Map<String, BgFormDiversityData> valMap = null;
                    if (resultMap.containsKey(bgFormId)) {
                        valMap = (Map)resultMap.get(bgFormId);
                    } else {
                        valMap = new HashMap();
                        resultMap.put(bgFormId, valMap);
                    }
                    if (oldValue.compareTo(newValue) == 0) continue;
                    BgFormDiversityData diffData = new BgFormDiversityData();
                    diffData.setFormula(formula2);
                    diffData.setOldValue(oldValue);
                    diffData.setNewValue(newValue);
                    valMap.put(formula2, diffData);
                }
            }
            if (!resultMap.isEmpty()) {
                IBgFormFacade bgFormFacade = BgFormFacadeFactory.getLocalInstance(ctx);
                bgFormFacade.auditFormsInfo(resultMap);
            }
        }
    }

    private Map getSchemeIdFromRootId(Context ctx, OrgUnitInfo[] orgUnits, String bgSchemeRootId) throws BOSException {
        if (StringUtils.isEmpty((String)bgSchemeRootId) || orgUnits == null || orgUnits.length <= 0) {
            return null;
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select fOrgUnitid, fid from t_bg_bgScheme ");
        sql.append("where FRootId = ? ");
        sql.append("and FOrgUnitID in (");
        for (int i = 1; i < orgUnits.length; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeRootId);
            for (int i = 0; i < orgUnits.length; ++i) {
                pstmt.setString(2 + i, orgUnits[i].getId().toString());
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                returnMap.put(rst.getString("fOrgUnitid"), rst.getString("fid"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return returnMap;
    }

    private Map getDataMapByScheme(Context ctx, List orgIds, List bgSchemeIds) throws BOSException {
        int i;
        HashMap dataMap = new HashMap();
        if (orgIds == null || bgSchemeIds == null || orgIds.isEmpty() || bgSchemeIds.isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select forgunitid, fbgschemeid, fformula, fbgvalue from t_bg_bgdata ");
        sql.append(" where forgunitid in (");
        for (i = 1; i < orgIds.size(); ++i) {
            sql.append("?,");
        }
        sql.append("?) ");
        sql.append(" and fbgschemeid in (");
        for (i = 1; i < bgSchemeIds.size(); ++i) {
            sql.append("?,");
        }
        sql.append("?) ");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Connection conn = null;
        String orgUnitId = null;
        String bgSchemeId = null;
        String formula = null;
        Map<String, BigDecimal> formulaMap = null;
        try {
            int i2;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            for (i2 = 0; i2 < orgIds.size(); ++i2) {
                pstmt.setString(index, (String)orgIds.get(i2));
                ++index;
            }
            for (i2 = 0; i2 < bgSchemeIds.size(); ++i2) {
                pstmt.setString(index, (String)bgSchemeIds.get(i2));
                ++index;
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgUnitId = rst.getString("forgunitid");
                bgSchemeId = rst.getString("fbgschemeid");
                formula = rst.getString("fformula");
                if (dataMap.containsKey(orgUnitId + "," + bgSchemeId)) {
                    formulaMap = (Map)dataMap.get(orgUnitId + "," + bgSchemeId);
                } else {
                    formulaMap = new HashMap();
                    dataMap.put(orgUnitId + "," + bgSchemeId, formulaMap);
                }
                formulaMap.put(formula, rst.getBigDecimal("fbgvalue"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return dataMap;
    }

    private Map getCommonDataMap(Context ctx, Map srcSchemeMap, Map tarSchemeMap) throws BOSException {
        int i;
        HashMap commonMap = new HashMap();
        if (srcSchemeMap == null || tarSchemeMap == null) {
            return null;
        }
        ArrayList srcOrgUnitIds = new ArrayList();
        ArrayList tarOrgUnitIds = new ArrayList();
        ArrayList srcBgSchemeIds = new ArrayList();
        ArrayList tarBgSchemeIds = new ArrayList();
        srcOrgUnitIds.addAll(srcSchemeMap.keySet());
        tarOrgUnitIds.addAll(tarSchemeMap.keySet());
        srcBgSchemeIds.addAll(srcSchemeMap.values());
        tarBgSchemeIds.addAll(tarSchemeMap.values());
        if (srcOrgUnitIds.isEmpty() || tarOrgUnitIds.isEmpty() || srcBgSchemeIds.isEmpty() || tarBgSchemeIds.isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fformula, fbgvalue, forgunitid, fbgschemeid, fbgformid from t_bg_bgdata where ");
        sql.append("forgunitid in (");
        for (i = 1; i < tarOrgUnitIds.size(); ++i) {
            sql.append("?,");
        }
        sql.append("?) ");
        sql.append("and fbgschemeid in (");
        for (i = 1; i < tarBgSchemeIds.size(); ++i) {
            sql.append("?,");
        }
        sql.append("?) ");
        sql.append("and fformula in (select fformula as formula from t_bg_bgData ");
        sql.append("where forgunitid in (");
        for (i = 1; i < srcOrgUnitIds.size(); ++i) {
            sql.append("?,");
        }
        sql.append("?) ");
        sql.append("and fbgschemeid in (");
        for (i = 1; i < srcBgSchemeIds.size(); ++i) {
            sql.append("?,");
        }
        sql.append("?) ");
        sql.append(")");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Connection conn = null;
        String orgUnitId = null;
        String bgSchemeId = null;
        String formula = null;
        Map<String, Object[]> formulaMap = null;
        try {
            int i2;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int index = 1;
            for (i2 = 0; i2 < tarOrgUnitIds.size(); ++i2) {
                pstmt.setString(index, (String)tarOrgUnitIds.get(i2));
                ++index;
            }
            for (i2 = 0; i2 < tarBgSchemeIds.size(); ++i2) {
                pstmt.setString(index, (String)tarBgSchemeIds.get(i2));
                ++index;
            }
            for (i2 = 0; i2 < srcOrgUnitIds.size(); ++i2) {
                pstmt.setString(index, (String)srcOrgUnitIds.get(i2));
                ++index;
            }
            for (i2 = 0; i2 < srcBgSchemeIds.size(); ++i2) {
                pstmt.setString(index, (String)srcBgSchemeIds.get(i2));
                ++index;
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgUnitId = rst.getString("forgunitid");
                bgSchemeId = rst.getString("fbgschemeid");
                formula = rst.getString("fformula");
                if (commonMap.containsKey(orgUnitId + "," + bgSchemeId)) {
                    formulaMap = (Map)commonMap.get(orgUnitId + "," + bgSchemeId);
                } else {
                    formulaMap = new HashMap();
                    commonMap.put(orgUnitId + "," + bgSchemeId, formulaMap);
                }
                formulaMap.put(formula, new Object[]{rst.getBigDecimal("fbgvalue"), rst.getString("fbgformid")});
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return commonMap;
    }

    @Override
    protected Map _getSelectElementName(Context ctx, Map bgElement) throws BOSException, EASBizException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        int h = 1;
        int GROUPSIZE = 50;
        Vector<String> strVec = new Vector<String>();
        String str = "(''";
        for (String number : bgElement.keySet()) {
            str = str + ",'" + number + "'";
            if (++h != GROUPSIZE) continue;
            h = 1;
            str = str + " )";
            strVec.add(str);
            str = " ( ''";
        }
        if (h < GROUPSIZE && h != 1) {
            str = str + " )";
            strVec.add(str);
        }
        try {
            connection = this.getConnection(ctx);
            for (int i = 0; i < strVec.size(); ++i) {
                str = (String)strVec.get(i);
                String sql = "select fnumber, fname_" + ctx.getLocale() + "  from t_bg_bgelement where fnumber in " + str;
                ps = connection.prepareStatement(sql);
                rs = ps.executeQuery();
                while (rs.next()) {
                    bgElement.put(rs.getString(1), rs.getString(2));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.toString());
        }
        finally {
            SQLUtils.cleanup(rs, ps, (Connection)connection);
        }
        return bgElement;
    }

    @Override
    protected Map _getSelectBgItemName(Context ctx, Map bgItems, String orgUnitId) throws BOSException, EASBizException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        orgUnitId = BgSHelper.getIsolateOrg(ctx, orgUnitId);
        int h = 1;
        int GROUPSIZE = 50;
        Vector<String> strVec = new Vector<String>();
        String str = "(''";
        for (String number : bgItems.keySet()) {
            str = str + ",'" + number + "'";
            if (++h != GROUPSIZE) continue;
            h = 1;
            str = str + " )";
            strVec.add(str);
            str = " ( ''";
        }
        if (h < GROUPSIZE && h != 1) {
            str = str + " )";
            strVec.add(str);
        }
        try {
            connection = this.getConnection(ctx);
            for (int i = 0; i < strVec.size(); ++i) {
                str = (String)strVec.get(i);
                String sql = "select fnumber, fname_" + ctx.getLocale() + " from t_bg_bgItem where fnumber in " + str + " and forgUnitId='" + orgUnitId + "'";
                ps = connection.prepareStatement(sql);
                rs = ps.executeQuery();
                while (rs.next()) {
                    bgItems.put(rs.getString(1), rs.getString(2));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.toString());
        }
        finally {
            SQLUtils.cleanup(rs, ps, (Connection)connection);
        }
        return bgItems;
    }

    @Override
    protected Map _getSelectBgItemCombinName(Context ctx, Map bgItemCombinMap, String orgUnitId) throws BOSException, EASBizException {
        String[] numbers;
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, Object> bgItemMap = new HashMap();
        for (String key : bgItemCombinMap.keySet()) {
            numbers = key.split("_");
            for (int i = 0; i < numbers.length; ++i) {
                bgItemMap.put(numbers[i], null);
            }
        }
        bgItemMap = this._getSelectBgItemName(ctx, bgItemMap, BgSHelper.getIsolateOrg(ctx, orgUnitId));
        for (String key : bgItemCombinMap.keySet()) {
            numbers = key.split("_");
            String bgItemCombinName = "";
            for (int i = 0; i < numbers.length; ++i) {
                bgItemCombinName = bgItemCombinName + bgItemMap.get(numbers[i]) + "_";
            }
            bgItemCombinName = bgItemCombinName.substring(0, bgItemCombinName.length() - 1);
            result.put(key, bgItemCombinName);
        }
        return result;
    }
}

