/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.BgCompareAndAnalysisObjInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.util.AnalysisColumnTool;
import com.kingdee.eas.ma.budget.analysiscolumn.util.BgGetPeriodBlanceUtil;
import com.kingdee.eas.ma.budget.app.AbstractBgCompareAndAnalysisByBgItemFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCompareAndAnalysisByBgItemFacadeControllerBean
extends AbstractBgCompareAndAnalysisByBgItemFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)BgCompareAndAnalysisByBgItemFacadeControllerBean.class.getName());
    private static final long serialVersionUID = -8735142866921005555L;
    private static final String date_pattern = "yyyy-MM-dd HH:mm:ss";
    public static final String YEAR = "Y";
    public static final String MONTH = "M";
    public static final String HALF_YEAR = "HY";
    public static final String QUARTER = "Q";

    @Override
    protected Map _getData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisByBgItemFacadeControllerBean. _getData invoke");
        String bgFormID = filterParam.getBgFormID();
        Connection conn = null;
        BgFormInfo bgFormInfo = null;
        if (!StringUtils.isEmpty((String)bgFormID)) {
            try {
                conn = this.getConnection(ctx);
                bgFormInfo = BgInfoHelper.getBgFormInfo((Connection)conn, (String)bgFormID, (boolean)false);
                if (4 == bgFormInfo.getState().getValue()) {
                    bgFormID = bgFormInfo.getAdjust().getId().toString();
                }
            }
            catch (EASBizException ex) {
                throw ex;
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        HashMap<String, BgCompareAndAnalysisObjInfo> map = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        IRowSet rs = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> bgDataId = new ArrayList<String>();
        HashMap<String, BigDecimal> bgAdjustMap = new HashMap<String, BigDecimal>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("Select FID from T_BG_BgData where FBgFormId = ?");
            pstmt.setString(1, bgFormID);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgDataId.add(rst.getString("FID"));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            int index = 0;
            int batchNum = 200;
            int size = bgDataId.size();
            int count = (size - 1) / batchNum + 1;
            int pos = 0;
            StringBuffer query = new StringBuffer("select FBgDataId, sum(FPASTVALUE) from T_BG_BgPastData where fbgdataid in (");
            for (index = 1; index < batchNum; ++index) {
                query.append("?,");
            }
            query.append("?) ");
            query.append("and FPastRecordID in (select fid from T_BG_BgPastRecord where FPastSource in (1, 2, 3, 4, 6, 8)) group by FBgDataId");
            pstmt = conn.prepareStatement(query.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)bgDataId.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgAdjustMap.put(rst.getString(1), rst.getBigDecimal(2));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        String sql = this.commonSql(filterParam, false);
        sql = sql + " and fformula in (select fformula from t_bg_bgdata where fbgformid = '" + bgFormID + "')";
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String fid = rs.getString("FID");
                BigDecimal pastVal = null;
                pastVal = bgAdjustMap.containsKey(fid) ? (BigDecimal)bgAdjustMap.get(fid) : BgNConstants.ZERO;
                String formula = rs.getString("fformula");
                BigDecimal budget = rs.getBigDecimal("fbgvalue");
                BigDecimal actual = rs.getBigDecimal("fbizactual");
                String orgUnitId = rs.getString("forgunitid");
                if (map.keySet().contains(formula)) {
                    BgCompareAndAnalysisObjInfo info = (BgCompareAndAnalysisObjInfo)map.get(formula);
                    info.addData(budget, actual, orgUnitId, pastVal, null);
                    continue;
                }
                map.put(formula, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, pastVal, null, new HashMap()));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return map;
    }

    private String commonSql(NewBgCompareAndAnalysisFilterParam filterParam, String lastBgSchemeID) {
        if (StringUtils.isEmpty((String)lastBgSchemeID)) {
            lastBgSchemeID = filterParam.getBgSchemeInfo().getId().toString();
        }
        String bgSchemeID = lastBgSchemeID;
        String bgFormID = filterParam.getBgFormID();
        CostCenterOrgUnitInfo[] lazyLoadDataOrgUnitInfoAry = filterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
        CurrencyInfo cInfo = filterParam.getCurrencyInfo();
        String currencySql = "";
        if (cInfo != null) {
            String currencyId = cInfo.getId().toString();
            currencySql = " and a.fcurrencyid ='" + currencyId + "'";
        }
        StringBuffer sql = new StringBuffer(" select a.fbgvalue, a.FBizActual, a.forgunitid, a.fformula, sumPastVal, FBgSchemeId from t_bg_bgdata ");
        sql.append(this.getSumPastValSql());
        if (!"".equals(currencySql)) {
            sql.append(currencySql);
        }
        sql.append(" inner join t_bg_bgscheme c on c.fid = a.FBgSchemeId ");
        sql.append(" where");
        sql.append(" a.fbgschemeid in (select fid from t_bg_bgscheme where frootid in (select frootid from t_bg_bgscheme where fid in ('" + bgSchemeID.replaceAll(",", "','") + "' )))");
        sql.append(" and a.forgunitid in " + this.constructOrgUnitSql(lazyLoadDataOrgUnitInfoAry));
        return sql.toString();
    }

    private String commonSqlNoAdjust(NewBgCompareAndAnalysisFilterParam filterParam, String lastBgSchemeID) {
        if (StringUtils.isEmpty((String)lastBgSchemeID)) {
            lastBgSchemeID = filterParam.getBgSchemeInfo().getId().toString();
        }
        String bgSchemeID = lastBgSchemeID;
        CostCenterOrgUnitInfo[] lazyLoadDataOrgUnitInfoAry = filterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
        StringBuffer sql = new StringBuffer(" select FID, fbgvalue, FBizActual, forgunitid, fformula from t_bg_bgdata ");
        sql.append(" where 1 = 1 ");
        CurrencyInfo cInfo = filterParam.getCurrencyInfo();
        if (cInfo != null) {
            sql.append(" and fcurrencyid ='" + cInfo.getId().toString() + "'");
        }
        sql.append(" and fbgschemeid in (select fid from t_bg_bgscheme where frootid in (select frootid from t_bg_bgscheme where fid in ('" + bgSchemeID.replaceAll(",", "','") + "' )))");
        sql.append(" and forgunitid in " + this.constructOrgUnitSql(lazyLoadDataOrgUnitInfoAry));
        return sql.toString();
    }

    private String commonSql(NewBgCompareAndAnalysisFilterParam filterParam, boolean hasAdjust) {
        if (hasAdjust) {
            return this.commonSql(filterParam, null);
        }
        return this.commonSqlNoAdjust(filterParam, null);
    }

    private String getSumPastValSql() {
        String sql = "a left join (select fbgdataid , sum(FPASTVALUE) sumPastVal from T_BG_bgpastdata where FPastRecordID in (select fid from t_bg_bgpastrecord  where fpastSource not in (5,7,9)) group by fbgdataid) b on a.fid = b.fbgdataid";
        return sql;
    }

    private String constructOrgUnitSql(CostCenterOrgUnitInfo[] orgAry) {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = orgAry.length;
        for (int i = 0; i < num; ++i) {
            String tempOrgId = orgAry[i].getId().toString();
            sb.append(tempOrgId);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private String constructBgItemSql(Collection c) {
        ArrayList list = new ArrayList(c);
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = list.size();
        for (int i = 0; i < num; ++i) {
            String lastBgItem = list.get(i).toString();
            sb.append(lastBgItem);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    @Override
    protected Map _getThisYearData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisByBgItemFacadeControllerBean. _getThisYearData invoke");
        CostCenterOrgUnitInfo[] orgInfoAry = filterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
        Map mapWithBgItemList = this.getThisYearDataHelper(ctx, filterParam);
        HashSet filter = new HashSet();
        ArrayList al = new ArrayList(mapWithBgItemList.values());
        int num = al.size();
        for (int i = 0; i < num; ++i) {
            List tempList = (List)al.get(i);
            int jNum = tempList.size();
            for (int j = 0; j < jNum; ++j) {
                filter.add(tempList.get(j));
            }
        }
        String sqlItem = this.constructBgItemSql(filter);
        String sql = this.commonSql(filterParam, false);
        sql = sql + " and fformula in " + sqlItem;
        IRowSet rs = null;
        HashMap<String, BgCompareAndAnalysisObjInfo> map = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String formula = rs.getString("fformula");
                BigDecimal budget = rs.getBigDecimal("fbgvalue");
                BigDecimal actual = rs.getBigDecimal("fbizactual");
                String orgUnitId = rs.getString("forgunitid");
                if (map.keySet().contains(formula)) {
                    BgCompareAndAnalysisObjInfo info = (BgCompareAndAnalysisObjInfo)map.get(formula);
                    info.addData(budget, actual, orgUnitId, null, null);
                    continue;
                }
                map.put(formula, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, null, null, new HashMap()));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        HashMap<String, BgCompareAndAnalysisObjInfo> rtnMap = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        ArrayList originalBgItemList = new ArrayList(mapWithBgItemList.keySet());
        int num2 = originalBgItemList.size();
        for (int i = 0; i < num2; ++i) {
            String bgItem = originalBgItemList.get(i).toString();
            List relatedBgItemList = (List)mapWithBgItemList.get(bgItem);
            int kNum = orgInfoAry.length;
            for (int k = 0; k < kNum; ++k) {
                String orgUnitID = orgInfoAry[k].getId().toString();
                BigDecimal sumBgVal = new BigDecimal("0.00");
                BigDecimal sumActualVal = new BigDecimal("0.00");
                int jNum = relatedBgItemList.size();
                for (int j = 0; j < jNum; ++j) {
                    String relatedBgItem = relatedBgItemList.get(j).toString();
                    Object obj = map.get(relatedBgItem);
                    if (obj == null) continue;
                    BgCompareAndAnalysisObjInfo info = (BgCompareAndAnalysisObjInfo)obj;
                    BgCompareAndAnalysisObjInfo.DataObj dObj = (BgCompareAndAnalysisObjInfo.DataObj)info.getOrgUnitIdMap().get(orgUnitID);
                    if (dObj == null) {
                        sumBgVal = new BigDecimal("0.00");
                        sumActualVal = new BigDecimal("0.00");
                        continue;
                    }
                    sumBgVal = sumBgVal.add(dObj.getBudgetVal());
                    sumActualVal = sumActualVal.add(dObj.getActualVal());
                }
                if (rtnMap.keySet().contains(bgItem)) {
                    BgCompareAndAnalysisObjInfo info = (BgCompareAndAnalysisObjInfo)rtnMap.get(bgItem);
                    info.addData(sumBgVal, sumActualVal, orgUnitID, null, null);
                    continue;
                }
                rtnMap.put(bgItem, new BgCompareAndAnalysisObjInfo(orgUnitID, sumBgVal, sumActualVal, null, null, new HashMap()));
            }
        }
        return rtnMap;
    }

    private Map getThisYearDataHelper(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, BgSchemeAssignException {
        String bgFormID = filterParam.getBgFormID();
        String sql = "select fformula from t_bg_bgdata where fbgformid = '" + bgFormID + "'";
        IRowSet rs = null;
        HashMap<String, List> map = new HashMap<String, List>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String bgItem = rs.getString("fformula");
                List bgItemList = this.getThisYearFormula(bgItem);
                map.put(bgItem, bgItemList);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return map;
    }

    private List getThisYearFormula(String bgItem) {
        int number;
        ArrayList<String> bgItemList = new ArrayList<String>();
        String[] bgItemAry = BgFillHelper.parseStrFormulaToArray(bgItem);
        String periodParam = bgItemAry[1];
        int index = periodParam.indexOf(".");
        if (index == -1) {
            bgItemList.add(bgItem);
            return bgItemList;
        }
        int length = periodParam.length();
        int numberEnd = index + 3;
        String head = periodParam.substring(0, index + 1);
        String tail = periodParam.substring(numberEnd, length);
        for (int i = number = Integer.valueOf(periodParam.substring(index + 1, numberEnd)).intValue(); i >= 1; --i) {
            String tempStr = String.valueOf(i);
            if (tempStr.length() == 1) {
                bgItemList.add(AnalysisColumnTool.rebuildFormulaWithPeriodParam(bgItemAry, head + "0" + i + tail));
                continue;
            }
            bgItemList.add(AnalysisColumnTool.rebuildFormulaWithPeriodParam(bgItemAry, head + i + tail));
        }
        return bgItemList;
    }

    @Override
    protected Map _getSumData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisByBgItemFacadeControllerBean. _getSumData invoke");
        CostCenterOrgUnitInfo[] orgInfoAry = filterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
        String bgFormID = filterParam.getBgFormID();
        String bgSchemeID = filterParam.getBgSchemeInfo().getId().toString();
        Map relatedBgItemMap = this.getSumDataBgItem(ctx, bgFormID, bgSchemeID);
        HashSet filter = new HashSet(relatedBgItemMap.keySet());
        ArrayList al = new ArrayList(relatedBgItemMap.values());
        int num = al.size();
        for (int i = 0; i < num; ++i) {
            List tempList = (List)al.get(i);
            int jNum = tempList.size();
            for (int j = 0; j < jNum; ++j) {
                filter.add(tempList.get(j));
            }
        }
        String sqlItem = this.constructBgItemSql(filter);
        String sql = this.commonSql(filterParam, false);
        sql = sql + " and fformula in " + sqlItem;
        IRowSet rs = null;
        HashMap<String, BgCompareAndAnalysisObjInfo> map = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String formula = rs.getString("fformula");
                BigDecimal budget = rs.getBigDecimal("fbgvalue");
                BigDecimal actual = rs.getBigDecimal("fbizactual");
                String orgUnitId = rs.getString("forgunitid");
                if (map.keySet().contains(formula)) {
                    BgCompareAndAnalysisObjInfo info = (BgCompareAndAnalysisObjInfo)map.get(formula);
                    info.addData(budget, actual, orgUnitId, null, null);
                    continue;
                }
                map.put(formula, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, null, null, new HashMap()));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        HashMap<String, BgCompareAndAnalysisObjInfo> rtnMap = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        ArrayList originalBgItemList = new ArrayList(relatedBgItemMap.keySet());
        int num2 = originalBgItemList.size();
        for (int i = 0; i < num2; ++i) {
            String bgItem = originalBgItemList.get(i).toString();
            List relatedBgItemList = (List)relatedBgItemMap.get(bgItem);
            int kNum = orgInfoAry.length;
            for (int k = 0; k < kNum; ++k) {
                String orgUnitID = orgInfoAry[k].getId().toString();
                BigDecimal sumBgVal = new BigDecimal("0.00");
                BigDecimal sumActualVal = new BigDecimal("0.00");
                int jNum = relatedBgItemList.size();
                for (int j = 0; j < jNum; ++j) {
                    String relatedBgItem = relatedBgItemList.get(j).toString();
                    Object obj = map.get(relatedBgItem);
                    if (obj == null) continue;
                    BgCompareAndAnalysisObjInfo info = (BgCompareAndAnalysisObjInfo)obj;
                    BgCompareAndAnalysisObjInfo.DataObj dObj = (BgCompareAndAnalysisObjInfo.DataObj)info.getOrgUnitIdMap().get(orgUnitID);
                    if (dObj == null) {
                        sumBgVal = new BigDecimal("0.00");
                        sumActualVal = new BigDecimal("0.00");
                        continue;
                    }
                    sumBgVal = sumBgVal.add(dObj.getBudgetVal());
                    sumActualVal = sumActualVal.add(dObj.getActualVal());
                }
                if (rtnMap.keySet().contains(bgItem)) {
                    BgCompareAndAnalysisObjInfo info = (BgCompareAndAnalysisObjInfo)rtnMap.get(bgItem);
                    info.addData(sumBgVal, sumActualVal, orgUnitID, null, null);
                    continue;
                }
                rtnMap.put(bgItem, new BgCompareAndAnalysisObjInfo(orgUnitID, sumBgVal, sumActualVal, null, null, new HashMap()));
            }
        }
        return rtnMap;
    }

    private Map getSumDataBgItem(Context ctx, String bgFormID, String bgSchemeID) throws BOSException, EASBizException {
        String sql = "select fformula from t_bg_bgdata where fbgformid = '" + bgFormID + "'";
        Connection con = null;
        IRowSet rs = null;
        HashMap<String, List> map = new HashMap<String, List>();
        HashMap<String, String> hadPeriod = new HashMap<String, String>();
        String periodSql = "select fnumber, fid, fperiodtype from t_bg_bgperiod  where fenddate <= (select fdateto from t_bg_bgscheme where fid = '" + bgSchemeID + "') and fbegindate >= (select fdatefrom from t_bg_bgscheme where fid = '" + bgSchemeID + "') and fenddate <= (select fenddate from t_bg_bgPeriod where fid in (select fbgperiodId from t_bg_bgform where fid = '" + bgFormID + "'))";
        String periodNum = null;
        String periodId = null;
        HashMap formula = new HashMap();
        try {
            con = this.getConnection(ctx);
            rs = DbUtil.executeQuery((Context)ctx, (String)periodSql);
            while (rs.next()) {
                periodNum = rs.getString("fnumber");
                periodId = rs.getString("fperiodtype");
                hadPeriod.put(periodNum, periodId);
            }
            SQLUtils.cleanup((ResultSet)rs);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String bgItem = rs.getString("fformula");
                String[] bgItemAry = BgFillHelper.parseStrFormulaToArray(bgItem);
                List relatedBgItemList = this.getSumDataRelatedBgItem(con, bgItemAry, bgSchemeID, bgFormID, hadPeriod, formula);
                if (relatedBgItemList.size() == 0) {
                    relatedBgItemList.add(bgItem);
                }
                map.put(bgItem, relatedBgItemList);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, null, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, null, (Connection)con);
        return map;
    }

    private List getSumDataRelatedBgItem(Connection con, String[] bgItemAry, String bgSchemeID, String bgFormId, Map hadPeriod, Map formula) throws EASBizException {
        String periodNum = bgItemAry[1];
        if (!this.isInScheme(con, periodNum, bgSchemeID, hadPeriod)) {
            return new ArrayList();
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select fnumber from t_bg_bgperiod");
        sql.append(" where fperiodtype = (select fperiodtype from t_bg_bgperiod where fnumber = ? )");
        sql.append(" and fenddate <= (select fdateto from t_bg_bgscheme where fid = ?)");
        sql.append(" and fbegindate >= (select fdatefrom from t_bg_bgscheme where fid = ?)");
        sql.append(" and fenddate <= (select fenddate from t_bg_bgPeriod where fid in (");
        sql.append(" select fbgperiodId from t_bg_bgform where fid = ?))");
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> sList = new ArrayList<String>();
        try {
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, periodNum);
            ps.setString(2, bgSchemeID);
            ps.setString(3, bgSchemeID);
            ps.setString(4, bgFormId);
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(AnalysisColumnTool.rebuildFormulaWithPeriodParam(bgItemAry, rs.getString("fnumber")));
                sList.add(AnalysisColumnTool.rebuildFormulaWithPeriodParam(bgItemAry, rs.getString("fnumber")));
                formula.put(bgItemAry[1], sList);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return list;
    }

    private boolean isInScheme(Connection con, String periodNum, String bgSchemeID, Map hadPeriod) throws EASBizException {
        return hadPeriod.containsKey(periodNum);
    }

    private String getLastBgSchemeID(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        String currentBgSchemeID = filterParam.getBgSchemeInfo().getId().toString();
        String sql = "select fdatefrom , fdateto from t_bg_bgscheme where fid = '" + currentBgSchemeID + "'";
        java.util.Date sDate = null;
        java.util.Date eDate = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                Date tempSDate = rs.getDate("fdatefrom");
                Date tempEDate = rs.getDate("fdateto");
                sDate = new java.util.Date(tempSDate.getYear() - 1, 0, 1, 0, 0, 0);
                eDate = new java.util.Date(tempEDate.getYear() - 1, 11, 31, 23, 59, 59);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        CostCenterOrgUnitInfo[] orgUnitAry = filterParam.getCostCenterOrgUnitInfoAry();
        StringBuffer sqlSB = new StringBuffer("select fid ,fname_l2, fisFormal from t_bg_bgscheme where ");
        sqlSB.append(" ( (fdateto <= to_date('" + this.dateToStr(eDate) + "') ");
        sqlSB.append(" and fdateto >= to_date('" + this.dateToStr(sDate) + "') ) or");
        sqlSB.append("   ( fdatefrom <= to_date('" + this.dateToStr(eDate) + "')");
        sqlSB.append(" and fdatefrom >= to_date('" + this.dateToStr(sDate) + "') )");
        sqlSB.append(" ) and fisFormal = 1 ");
        sqlSB.append(" and forgunitid in " + this.constructOrgUnitSql(orgUnitAry));
        sqlSB.append(" order by fisformal desc,fnumber asc");
        String idList = currentBgSchemeID;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString());
            while (rs.next()) {
                String id = rs.getString("fid");
                idList = idList + "," + id;
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, ex, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return idList;
    }

    private String dateToStr(java.util.Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(date_pattern);
        return sdf.format(date);
    }

    @Override
    protected Map _getLastYearData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisByBgItemFacadeControllerBean. _getLastYearData invoke");
        String lastBgSchemeID = this.getLastBgSchemeID(ctx, filterParam);
        String[] bgschemeid = lastBgSchemeID.split(",");
        HashMap<String, Integer> mapSchemeNumberOrder = new HashMap<String, Integer>();
        int length = bgschemeid.length;
        for (int i = 0; i < length; ++i) {
            mapSchemeNumberOrder.put(bgschemeid[i], new Integer(i));
        }
        String currentBgSchemeID = filterParam.getBgSchemeInfo().getId().toString();
        if (lastBgSchemeID.equals("")) {
            return new HashMap();
        }
        lastBgSchemeID = currentBgSchemeID + "," + lastBgSchemeID;
        String bgFormID = filterParam.getBgFormID();
        Map mapWithLastAndCur = this.getLastYearDataHelper(ctx, bgFormID);
        String sql = this.commonSql(filterParam, lastBgSchemeID);
        sql = sql + "and fformula in " + this.constructBgItemSql(mapWithLastAndCur.keySet()) + " order by c.fnumber ";
        IRowSet rs = null;
        HashMap<String, BgCompareAndAnalysisObjInfo> map = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        try {
            HashMap<String, Boolean> mapIsCurrentSchemeItem = new HashMap<String, Boolean>();
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String lastSchemeid = null;
                String lastBgItem = rs.getString("fformula");
                String bgItem = mapWithLastAndCur.get(lastBgItem).toString();
                BigDecimal budget = rs.getBigDecimal("fbgvalue");
                BigDecimal actual = rs.getBigDecimal("fbizactual");
                String orgUnitId = rs.getString("forgunitid");
                String schemeid = rs.getString("fbgschemeid");
                if (map.containsKey(bgItem)) {
                    BgCompareAndAnalysisObjInfo info;
                    if (mapIsCurrentSchemeItem.containsKey(bgItem) && ((Boolean)mapIsCurrentSchemeItem.get(bgItem)).booleanValue()) {
                        if (!schemeid.equals(currentBgSchemeID)) continue;
                        info = (BgCompareAndAnalysisObjInfo)map.get(bgItem);
                        info.addData(budget, actual, orgUnitId, null, null);
                        continue;
                    }
                    if (schemeid.equals(currentBgSchemeID)) {
                        mapIsCurrentSchemeItem.put(bgItem, Boolean.TRUE);
                        map.put(bgItem, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, null, null, new HashMap(), schemeid));
                        continue;
                    }
                    info = (BgCompareAndAnalysisObjInfo)map.get(bgItem);
                    lastSchemeid = info.getSchemeid();
                    if (lastBgSchemeID.equals(schemeid)) {
                        info.addData(budget, actual, orgUnitId, null, null);
                        continue;
                    }
                    if (!mapSchemeNumberOrder.containsKey(lastSchemeid) || !mapSchemeNumberOrder.containsKey(schemeid) || (Integer)mapSchemeNumberOrder.get(lastSchemeid) <= (Integer)mapSchemeNumberOrder.get(schemeid)) continue;
                    map.put(bgItem, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, null, null, new HashMap(), schemeid));
                    continue;
                }
                if (schemeid.equals(currentBgSchemeID)) {
                    mapIsCurrentSchemeItem.put(bgItem, Boolean.TRUE);
                }
                map.put(bgItem, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, null, null, new HashMap(), schemeid));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return map;
    }

    private Map getLastYearDataHelper(Context ctx, String bgFormID) throws BOSException, BgSchemeAssignException {
        String sql = "select fformula from t_bg_bgdata where fbgformid = '" + bgFormID + "'";
        IRowSet rs = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String bgItem = rs.getString("fformula");
                String lastYearbgItem = this.getLastYearFormula(bgItem);
                if (lastYearbgItem == null) continue;
                map.put(lastYearbgItem, bgItem);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return map;
    }

    private String getLastYearFormula(String formula) {
        String[] formulaAry = BgFillHelper.parseStrFormulaToArray(formula);
        String periodParam = formulaAry[1];
        int yearIndex = periodParam.indexOf(YEAR);
        String returns = null;
        try {
            int lastYear = Integer.valueOf(periodParam.substring(0, yearIndex)) - 1;
            String newPeriodParam = lastYear + YEAR + periodParam.substring(yearIndex + 1, periodParam.length());
            returns = AnalysisColumnTool.rebuildFormulaWithPeriodParam(formulaAry, newPeriodParam);
        }
        catch (Exception e) {
            return null;
        }
        return returns;
    }

    @Override
    protected Map _getTheLastData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisByBgItemFacadeControllerBean. _getTheLastData invoke");
        CostCenterOrgUnitInfo[] lazyOrgInfo = filterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
        String bgFormID = filterParam.getBgFormID();
        Map valMap = this.getTheLastDataHelper(ctx, bgFormID);
        HashSet<String> filter = new HashSet<String>();
        ArrayList al = new ArrayList(valMap.values());
        int num = al.size();
        for (int i = 0; i < num; ++i) {
            String tempBgItem = al.get(i).toString();
            filter.add(tempBgItem);
        }
        String sqlItem = this.constructBgItemSql(filter);
        String sql = this.commonSql(filterParam, false);
        sql = sql + " and fformula in " + sqlItem;
        IRowSet rs = null;
        HashMap<String, BgCompareAndAnalysisObjInfo> map = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String formula = rs.getString("fformula");
                BigDecimal budget = rs.getBigDecimal("fbgvalue");
                BigDecimal actual = rs.getBigDecimal("fbizactual");
                String orgUnitId = rs.getString("forgunitid");
                if (map.keySet().contains(formula)) {
                    BgCompareAndAnalysisObjInfo info = (BgCompareAndAnalysisObjInfo)map.get(formula);
                    info.addData(null, actual, orgUnitId, null, null);
                    continue;
                }
                map.put(formula, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, null, null, new HashMap()));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        HashMap<String, BgCompareAndAnalysisObjInfo> rtnMap = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        ArrayList originalBgItemList = new ArrayList(valMap.keySet());
        int num2 = originalBgItemList.size();
        for (int i = 0; i < num2; ++i) {
            String bgItem = originalBgItemList.get(i).toString();
            String theLastBgItem = valMap.get(bgItem).toString();
            int kNum = lazyOrgInfo.length;
            for (int k = 0; k < kNum; ++k) {
                BgCompareAndAnalysisObjInfo info;
                String orgUnitID = lazyOrgInfo[k].getId().toString();
                BigDecimal bgVal = new BigDecimal("0.00");
                BigDecimal actualVal = new BigDecimal("0.00");
                Object obj = map.get(theLastBgItem);
                if (obj != null) {
                    info = (BgCompareAndAnalysisObjInfo)obj;
                    BgCompareAndAnalysisObjInfo.DataObj dObj = (BgCompareAndAnalysisObjInfo.DataObj)info.getOrgUnitIdMap().get(orgUnitID);
                    if (dObj == null) {
                        bgVal = new BigDecimal("0.00");
                        actualVal = new BigDecimal("0.00");
                    } else {
                        bgVal = dObj.getBudgetVal();
                        actualVal = dObj.getActualVal();
                    }
                }
                if (rtnMap.keySet().contains(bgItem)) {
                    info = (BgCompareAndAnalysisObjInfo)rtnMap.get(bgItem);
                    info.addData(bgVal, actualVal, orgUnitID, null, null);
                    continue;
                }
                rtnMap.put(bgItem, new BgCompareAndAnalysisObjInfo(orgUnitID, bgVal, actualVal, null, null, new HashMap()));
            }
        }
        return rtnMap;
    }

    private Map getTheLastDataHelper(Context ctx, String bgFormID) throws BOSException, EASBizException {
        String sql = "select fformula from t_bg_bgdata where fbgformid = '" + bgFormID + "'";
        IRowSet rs = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String bgItem = rs.getString("fformula");
                String theLastBgItem = this.getTheLastDataFormula(bgItem);
                if (theLastBgItem == null) continue;
                map.put(bgItem, theLastBgItem);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return map;
    }

    private String getTheLastDataFormula(String bgItem) {
        String[] bgItemAry = BgFillHelper.parseStrFormulaToArray(bgItem);
        String periodParam = bgItemAry[1];
        String lastBgItemPeriodNum = "";
        String returnS = null;
        try {
            if (periodParam.endsWith(YEAR)) {
                lastBgItemPeriodNum = Integer.valueOf(periodParam.substring(0, periodParam.indexOf(YEAR))) - 1 + YEAR;
                return AnalysisColumnTool.rebuildFormulaWithPeriodParam(bgItemAry, lastBgItemPeriodNum);
            }
            lastBgItemPeriodNum = BgCompareAndAnalysisByBgItemFacadeControllerBean.isOne(periodParam) ? BgCompareAndAnalysisByBgItemFacadeControllerBean.specialHandling(periodParam) : BgCompareAndAnalysisByBgItemFacadeControllerBean.commonHandling(periodParam);
            returnS = AnalysisColumnTool.rebuildFormulaWithPeriodParam(bgItemAry, lastBgItemPeriodNum);
        }
        catch (Exception e) {
            return null;
        }
        return returnS;
    }

    public static String commonHandling(String periodParam) {
        String lastBgItemPeriodNum = "";
        int index = periodParam.lastIndexOf(".");
        int length = periodParam.length();
        int numberEnd = index + 3;
        String head = periodParam.substring(0, index + 1);
        String tail = periodParam.substring(numberEnd, length);
        int number = Integer.valueOf(periodParam.substring(index + 1, numberEnd)) - 1;
        String tempStr = String.valueOf(number);
        lastBgItemPeriodNum = tempStr.length() == 1 ? head + "0" + number + tail : head + number + tail;
        return lastBgItemPeriodNum;
    }

    public static String specialHandling(String periodParam) {
        int firstIndex = periodParam.indexOf(".");
        String first = periodParam.substring(0, firstIndex - 1);
        int secondIndex = -1;
        if (periodParam.lastIndexOf(".") != periodParam.indexOf(".")) {
            secondIndex = periodParam.lastIndexOf(".");
        }
        String second = "";
        String third = "";
        if (secondIndex > 0) {
            second = periodParam.substring(firstIndex + 1, secondIndex - 1);
            third = periodParam.substring(secondIndex + 1, periodParam.length() - 2);
        }
        int firstInt = -1;
        int secondInt = -1;
        int thirdInt = -1;
        try {
            firstInt = Integer.valueOf(first);
            secondInt = Integer.valueOf(second);
            thirdInt = Integer.valueOf(third);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        thirdInt = 3;
        if (secondInt == 1) {
            secondInt = 12;
            --firstInt;
        } else {
            --secondInt;
        }
        String year = Integer.valueOf(periodParam.substring(0, periodParam.indexOf(YEAR))) - 1 + "";
        String theLastPeriodNum = "";
        if (periodParam.endsWith(HALF_YEAR)) {
            theLastPeriodNum = year + YEAR + ".02" + HALF_YEAR;
        } else if (periodParam.endsWith(QUARTER)) {
            theLastPeriodNum = year + YEAR + ".04" + QUARTER;
        } else if (periodParam.endsWith(MONTH)) {
            theLastPeriodNum = year + YEAR + ".12" + MONTH;
        } else if (periodParam.toLowerCase(Locale.ENGLISH).endsWith("Td".toLowerCase(Locale.ENGLISH))) {
            if (secondInt < 13) {
                second = "0" + secondInt;
            }
            if (thirdInt < 4) {
                third = "0" + thirdInt;
            }
            theLastPeriodNum = firstInt + YEAR + "." + second + MONTH + "." + third + "TD";
        }
        return theLastPeriodNum;
    }

    public static boolean isOne(String periodParam) {
        int numberEnd;
        int index = periodParam.lastIndexOf(".");
        int number = Integer.valueOf(periodParam.substring(index + 1, numberEnd = index + 3));
        return number == 1;
    }

    @Override
    protected Map _getBalanceData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return BgGetPeriodBlanceUtil.getBlance(ctx, filterParam, BgGetPeriodTypeForGetBlanceEnum.Is_User_Blance);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCurBgSchemeIDByOrg(Context ctx, String bgSchemeID, String orgID) throws BOSException, EASBizException {
        String sql = "select fid from t_bg_bgscheme where forgunitid = ? and frootid in (select frootid from t_bg_bgscheme where fid = ?)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _id = "";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, orgID);
            pstmt.setString(2, bgSchemeID);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                _id = rst.getString("fid");
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _id;
    }

    @Override
    protected Map _getPeriodBalanceData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return BgGetPeriodBlanceUtil.getBlance(ctx, filterParam, BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance);
    }

    @Override
    protected Map _getBeforeData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return BgGetPeriodBlanceUtil.getBeforeBlance(ctx, filterParam, BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance);
    }

    @Override
    protected Map _getHalfYareData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getLastMonthActualData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getLastMonthSumActualData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getQuarterData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return null;
    }
}

