/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.BgCompareAndAnalysisObjInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.util.AnalysisColumnTool;
import com.kingdee.eas.ma.budget.analysiscolumn.util.BgGetPeriodBlanceUtil;
import com.kingdee.eas.ma.budget.app.AbstractBgCompareAndAnalysisFacadeControllerBean;
import com.kingdee.eas.ma.budget.app.BgCompareAndAnalysisByBgItemFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCompareAndAnalysisFacadeControllerBean
extends AbstractBgCompareAndAnalysisFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)BgCompareAndAnalysisFacadeControllerBean.class.getName());
    private static final long serialVersionUID = 6183709615123160229L;
    private static final String date_pattern = "yyyy-MM-dd HH:mm:ss";
    private static NewBgCompareAndAnalysisFilterParam lastFilterParamCache;
    private static String lastSqlCache;

    private String constructBgItemSql(Collection c) {
        ArrayList list = new ArrayList(c);
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = list.size();
        for (int i = 0; i < num; ++i) {
            String lastBgItem = list.get(i).toString();
            sb.append(lastBgItem);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private String commonSql(NewBgCompareAndAnalysisFilterParam filterParam) {
        return this.commonSql(filterParam, null);
    }

    private String commonSql(NewBgCompareAndAnalysisFilterParam filterParam, String lastBgSchemeID) {
        if (StringUtils.isEmpty((String)lastBgSchemeID)) {
            lastBgSchemeID = filterParam.getBgSchemeInfo().getId().toString();
        }
        String bgSchemeID = lastBgSchemeID;
        String bgFormID = filterParam.getBgFormID();
        CostCenterOrgUnitInfo[] lazyLoadDataOrgUnitInfoAry = filterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
        CurrencyInfo cInfo = filterParam.getCurrencyInfo();
        String currencySql = "";
        if (cInfo != null) {
            String currencyId = cInfo.getId().toString();
            currencySql = " and a.fcurrencyid ='" + currencyId + "'";
        }
        StringBuffer sql = new StringBuffer(" select fbgvalue ,FBizActual,forgunitid, fformula ,sumPastVal,FBgSchemeId from t_bg_bgdata ");
        sql.append(this.getSumPastValSql());
        if (!"".equals(currencySql)) {
            sql.append(currencySql);
        }
        sql.append(" where");
        sql.append(" a.fbgtemplateid in (select fid from t_bg_bgtemplate where frootid = (select frootid from t_bg_bgtemplate where fid in (select fbgtemplateid from t_bg_bgform where fid = '" + bgFormID + "')))");
        sql.append(" and a.fbgschemeid in (select fid from t_bg_bgscheme where frootid in (select frootid from t_bg_bgscheme where fid in ('" + bgSchemeID.replaceAll(",", "','") + "' )))");
        sql.append(" and a.forgunitid in " + this.constructOrgUnitSql(lazyLoadDataOrgUnitInfoAry));
        return sql.toString();
    }

    @Override
    protected Map _getTheLastData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisByBgItemFacadeControllerBean. _getTheLastData invoke");
        CostCenterOrgUnitInfo[] lazyOrgInfo = filterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
        String bgFormID = filterParam.getBgFormID();
        if (bgFormID == null) {
            return new HashMap();
        }
        Map valMap = this.getTheLastDataHelper(ctx, bgFormID, filterParam);
        HashSet<String> filter = new HashSet<String>();
        ArrayList al = new ArrayList(valMap.values());
        int num = al.size();
        for (int i = 0; i < num; ++i) {
            String tempBgItem = al.get(i).toString();
            filter.add(tempBgItem);
        }
        String sqlItem = this.constructBgItemSql(filter);
        String sql = this.commonSql(filterParam);
        sql = sql + " and a.fformula in " + sqlItem;
        IRowSet rs = null;
        HashMap<String, BgCompareAndAnalysisObjInfo> map = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String formula = rs.getString("fformula");
                BigDecimal budget = rs.getBigDecimal("fbgvalue");
                BigDecimal actual = rs.getBigDecimal("fbizactual");
                String orgUnitId = rs.getString("forgunitid");
                formula = AnalysisColumnTool.rebuildFormulaWithPeriodParamNull(BgFillHelper.parseStrFormulaToArray(formula));
                if (map.keySet().contains(formula)) {
                    BgCompareAndAnalysisObjInfo info = (BgCompareAndAnalysisObjInfo)map.get(formula);
                    info.addData(null, actual, orgUnitId, null, null);
                    continue;
                }
                map.put(formula, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, null, null, new HashMap()));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        HashMap<String, BgCompareAndAnalysisObjInfo> rtnMap = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        ArrayList originalBgItemList = new ArrayList(valMap.keySet());
        int num2 = originalBgItemList.size();
        for (int i = 0; i < num2; ++i) {
            String bgItem = originalBgItemList.get(i).toString();
            String theLastBgItem = valMap.get(bgItem).toString();
            bgItem = AnalysisColumnTool.rebuildFormulaWithPeriodParamNull(BgFillHelper.parseStrFormulaToArray(bgItem));
            if (theLastBgItem != null && !theLastBgItem.equals("")) {
                theLastBgItem = AnalysisColumnTool.rebuildFormulaWithPeriodParamNull(BgFillHelper.parseStrFormulaToArray(theLastBgItem));
            }
            int kNum = lazyOrgInfo.length;
            for (int k = 0; k < kNum; ++k) {
                BgCompareAndAnalysisObjInfo info;
                String orgUnitID = lazyOrgInfo[k].getId().toString();
                BigDecimal bgVal = new BigDecimal("0.00");
                BigDecimal actualVal = new BigDecimal("0.00");
                Object obj = map.get(theLastBgItem);
                if (obj != null) {
                    info = (BgCompareAndAnalysisObjInfo)obj;
                    BgCompareAndAnalysisObjInfo.DataObj dObj = (BgCompareAndAnalysisObjInfo.DataObj)info.getOrgUnitIdMap().get(orgUnitID);
                    if (dObj == null) {
                        bgVal = new BigDecimal("0.00");
                        actualVal = new BigDecimal("0.00");
                    } else {
                        bgVal = dObj.getBudgetVal();
                        actualVal = dObj.getActualVal();
                    }
                }
                if (rtnMap.keySet().contains(bgItem)) {
                    info = (BgCompareAndAnalysisObjInfo)rtnMap.get(bgItem);
                    info.addData(bgVal, actualVal, orgUnitID, null, null);
                    continue;
                }
                rtnMap.put(bgItem, new BgCompareAndAnalysisObjInfo(orgUnitID, bgVal, actualVal, null, null, new HashMap()));
            }
        }
        return rtnMap;
    }

    private Map getTheLastDataHelper(Context ctx, String bgFormID, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        String sql = "select fformula from t_bg_bgdata where fbgformid = '" + bgFormID + "'";
        BgPeriodInfo beginPeriod = filterParam.getBeginPeriod();
        String bgPeriodNumber = BgNPeriodHelper.getOffsetBgPeriodNumber((String)beginPeriod.getNumber(), (int)-1);
        IRowSet rs = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String bgFormulaStr = rs.getString("fformula");
                String theLastBgItem = this.getPreviousPeriod(bgFormulaStr, bgPeriodNumber);
                map.put(bgFormulaStr, theLastBgItem);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return map;
    }

    private String getPreviousPeriod(String bgFormulaStr, String bgPeriodNumber) {
        if (bgFormulaStr == null) {
            return "";
        }
        if (bgPeriodNumber == null) {
            return bgFormulaStr;
        }
        String[] bgItemAry = BgFillHelper.parseStrFormulaToArray(bgFormulaStr);
        if (bgItemAry != null) {
            return new StringBuffer("=BgItem(\"" + bgItemAry[0] + "\",\"" + bgPeriodNumber + "\",\"" + bgItemAry[2] + "\",\"" + bgItemAry[3] + "\"," + bgItemAry[4] + ",\"" + bgItemAry[5] + "\")").toString();
        }
        return "";
    }

    private String getTheLastDataFormula(String bgItem) {
        String[] bgItemAry = BgFillHelper.parseStrFormulaToArray(bgItem);
        String periodParam = bgItemAry[1];
        String lastBgItemPeriodNum = "";
        if (periodParam.endsWith("Y")) {
            lastBgItemPeriodNum = Integer.valueOf(periodParam.substring(0, periodParam.indexOf("Y"))) - 1 + "Y";
            return AnalysisColumnTool.rebuildFormulaWithPeriodParam(bgItemAry, lastBgItemPeriodNum);
        }
        lastBgItemPeriodNum = BgCompareAndAnalysisByBgItemFacadeControllerBean.isOne(periodParam) ? BgCompareAndAnalysisByBgItemFacadeControllerBean.specialHandling(periodParam) : BgCompareAndAnalysisByBgItemFacadeControllerBean.commonHandling(periodParam);
        return AnalysisColumnTool.rebuildFormulaWithPeriodParam(bgItemAry, lastBgItemPeriodNum);
    }

    @Override
    protected Map _getData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisFacadeControllerBean. _getData invoke");
        BgPeriodInfo beginInfo = filterParam.getBeginPeriod();
        BgPeriodInfo endInfo = filterParam.getEndPeriod();
        BgPeriodCollection bgPC = null;
        bgPC = BgPeriodFactory.getLocalInstance(ctx).getPeriodCollection(beginInfo.getId(), endInfo.getId());
        String periodIdSql = this.constructPeriodSql(bgPC);
        String sql = this.sqlFactoryForGetData(ctx, filterParam);
        sql = sql + " and fbgperiodid in " + periodIdSql;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, BgCompareAndAnalysisObjInfo> map = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        try {
            while (rs.next()) {
                BigDecimal pastVal = rs.getBigDecimal("sumPastVal");
                if (pastVal == null) {
                    pastVal = new BigDecimal("0.00");
                }
                String formula = rs.getString("fformula");
                BigDecimal budget = rs.getBigDecimal("fbgvalue");
                BigDecimal actual = rs.getBigDecimal("fbizactual");
                String orgUnitId = rs.getString("forgunitid");
                String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(formula);
                formula = AnalysisColumnTool.rebuildFormulaWithPeriodParamNull(formulaParamArray);
                if (map.keySet().contains(formula)) {
                    BgCompareAndAnalysisObjInfo info = (BgCompareAndAnalysisObjInfo)map.get(formula);
                    info.addData(budget, actual, orgUnitId, pastVal, null);
                    continue;
                }
                map.put(formula, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, pastVal, null, new HashMap()));
            }
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return map;
    }

    private String getSumPastValSql() {
        String sql = "a left join (select fbgdataid , sum(FPASTVALUE) sumPastVal from T_BG_bgpastdata where fpastrecordid in (select fid from t_bg_bgpastrecord where fpastSource not in (5,7,9)) group by fbgdataid) b on a.fid = b.fbgdataid";
        return sql;
    }

    private String getBgTemplateRootIdByBgFormId(Context ctx, String bgFormId) throws BOSException, SQLException {
        String sql = "select frootid from t_bg_bgtemplate where fid in (select fbgtemplateid from t_bg_bgform where fid = '" + bgFormId + "')";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String frootid = "";
        while (rs.next()) {
            frootid = rs.getString("frootid");
        }
        return frootid;
    }

    private String getAllBgSchemeIdsSql(Context ctx, String bgSchemeId, CostCenterOrgUnitInfo[] orgAry) throws BOSException, SQLException {
        String sql = "select fid from t_bg_bgscheme where frootid in (select frootid from t_bg_bgscheme where fid in ('" + bgSchemeId.replaceAll(",", "','") + "') ) and forgunitid in " + this.constructOrgUnitSql(orgAry) + "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int index = 0;
        int size = rs.size();
        String[] array = new String[size];
        while (rs.next()) {
            array[index++] = rs.getString("fid");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        for (int i = 0; i < size; ++i) {
            sb.append(array[i]);
            if (i == size - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private String getBgTemplateIdByOrgIdsAndTemplateId(Context ctx, String bgFormId, CostCenterOrgUnitInfo[] orgAry) throws BOSException, SQLException {
        String sql = "select fid from t_bg_bgtemplate where frootid = '" + this.getBgTemplateRootIdByBgFormId(ctx, bgFormId) + "' and forgunitid in " + this.constructOrgUnitSql(orgAry) + "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int index = 0;
        int size = rs.size();
        String[] array = new String[size];
        while (rs.next()) {
            array[index++] = rs.getString("fid");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        for (int i = 0; i < size; ++i) {
            sb.append(array[i]);
            if (i == size - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private String constructOrgUnitSql(CostCenterOrgUnitInfo[] orgAry) {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = orgAry.length;
        for (int i = 0; i < num; ++i) {
            String tempOrgId = orgAry[i].getId().toString();
            sb.append(tempOrgId);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private String constructPeriodSql(BgPeriodCollection bgPC) {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = bgPC.size();
        for (int i = 0; i < num; ++i) {
            String periodID = bgPC.get(i).getId().toString();
            sb.append(periodID);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private String getLastYearPeriodIds(Context ctx, BgPeriodInfo beginInfo, BgPeriodInfo endInfo) throws EASBizException, BOSException {
        beginInfo = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(beginInfo.getId()));
        endInfo = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(endInfo.getId()));
        int type = beginInfo.getPeriodType().getValue();
        int year = beginInfo.getYear() - 1;
        java.util.Date beginDate = beginInfo.getBeginDate();
        java.util.Date endDate = endInfo.getEndDate();
        String sql = "select fid from t_bg_bgperiod where fyear = " + year + " and fperiodtype = " + type + " and fbegindate >= to_date('" + this.dateToStr(new java.util.Date(beginDate.getYear() - 1, beginDate.getMonth(), beginDate.getDate(), 0, 0, 0)) + " ') and fenddate <= to_date('" + this.dateToStr(new java.util.Date(endDate.getYear() - 1, endDate.getMonth(), endDate.getDate(), 23, 59, 59)) + "')";
        StringBuffer sb = new StringBuffer();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> idList = new ArrayList<String>();
            while (rs.next()) {
                String fid = rs.getString("fid");
                idList.add(fid);
            }
            sb.append("('");
            int num = idList.size();
            for (int i = 0; i < num; ++i) {
                String periodID = idList.get(i).toString();
                sb.append(periodID);
                if (i == num - 1) break;
                sb.append("','");
            }
            sb.append("')");
        }
        catch (SQLException e1) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e1);
        }
        return sb.toString();
    }

    private String dateToStr(java.util.Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(date_pattern);
        return sdf.format(date);
    }

    private String getLastYearBgSchemeID(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        String currentBgSchemeID = filterParam.getBgSchemeInfo().getId().toString();
        String sql = "select fdatefrom , fdateto from t_bg_bgscheme where fid = '" + currentBgSchemeID + "'";
        java.util.Date sDate = null;
        java.util.Date eDate = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                Date tempSDate = rs.getDate("fdatefrom");
                Date tempEDate = rs.getDate("fdateto");
                if (tempSDate.getYear() - 1 != tempEDate.getYear() - 1) {
                    String string = currentBgSchemeID;
                    return string;
                }
                sDate = new java.util.Date(tempSDate.getYear() - 1, 0, 1, 0, 0, 0);
                eDate = new java.util.Date(tempEDate.getYear() - 1, 11, 31, 23, 59, 59);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        CostCenterOrgUnitInfo[] orgUnitAry = filterParam.getCostCenterOrgUnitInfoAry();
        StringBuffer sqlSB = new StringBuffer("select fid ,fname_l2, fisFormal from t_bg_bgscheme where ");
        sqlSB.append(" ( (fdateto <= to_date('" + this.dateToStr(eDate) + "') ");
        sqlSB.append(" and fdateto >= to_date('" + this.dateToStr(sDate) + "') ) or");
        sqlSB.append("   ( fdatefrom <= to_date('" + this.dateToStr(eDate) + "')");
        sqlSB.append(" and fdatefrom >= to_date('" + this.dateToStr(sDate) + "') )");
        sqlSB.append(" ) and fisformal = 1 ");
        sqlSB.append(" and forgunitid in " + this.constructOrgUnitSql(orgUnitAry));
        sqlSB.append(" order by fnumber asc");
        String idList = currentBgSchemeID;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString());
            while (rs.next()) {
                String id = rs.getString("fid");
                idList = idList + "," + id;
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, ex, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return idList;
    }

    @Override
    protected Map _getLastYearData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisFacadeControllerBean. _getLastYearData invoke");
        String lastBgSchemeID = this.getLastYearBgSchemeID(ctx, filterParam);
        BgSchemeInfo currentInfo = filterParam.getBgSchemeInfo();
        if (lastBgSchemeID.equals("")) {
            return new HashMap();
        }
        String[] bgschemeid = lastBgSchemeID.split(",");
        HashMap<String, Integer> mapSchemeNumberOrder = new HashMap<String, Integer>();
        int length = bgschemeid.length;
        for (int i = 0; i < length; ++i) {
            mapSchemeNumberOrder.put(bgschemeid[i], Integer.valueOf(i + ""));
        }
        String currentBgSchemeID = filterParam.getBgSchemeInfo().getId().toString();
        lastBgSchemeID = currentBgSchemeID + "," + lastBgSchemeID;
        String sql = this.sqlFactory(ctx, filterParam, lastBgSchemeID);
        filterParam.setBgSchemeInfo(currentInfo);
        BgPeriodInfo beginInfo = filterParam.getBeginPeriod();
        BgPeriodInfo endInfo = filterParam.getEndPeriod();
        String periodIdSql = this.getLastYearPeriodIds(ctx, beginInfo, endInfo);
        sql = sql + " and fbgperiodid in " + periodIdSql;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, BgCompareAndAnalysisObjInfo> map = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        try {
            HashMap<String, Boolean> mapIsCurrentSchemeItem = new HashMap<String, Boolean>();
            while (rs.next()) {
                String lastSchemeid = null;
                String formula = rs.getString("fformula");
                BigDecimal budget = rs.getBigDecimal("fbgvalue");
                BigDecimal actual = rs.getBigDecimal("fbizactual");
                String orgUnitId = rs.getString("forgunitid");
                String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(formula);
                formula = AnalysisColumnTool.rebuildFormulaWithPeriodParamNull(formulaParamArray);
                String schemeid = rs.getString("fbgschemeid");
                if (map.keySet().contains(formula)) {
                    BgCompareAndAnalysisObjInfo info;
                    if (mapIsCurrentSchemeItem.containsKey(formula) && ((Boolean)mapIsCurrentSchemeItem.get(formula)).booleanValue()) {
                        if (!schemeid.equals(currentBgSchemeID)) continue;
                        info = (BgCompareAndAnalysisObjInfo)map.get(formula);
                        info.addData(budget, actual, orgUnitId, null, null);
                        continue;
                    }
                    if (schemeid.equals(currentBgSchemeID)) {
                        mapIsCurrentSchemeItem.put(formula, Boolean.TRUE);
                        map.put(formula, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, null, null, new HashMap(), schemeid));
                        continue;
                    }
                    info = (BgCompareAndAnalysisObjInfo)map.get(formula);
                    lastSchemeid = info.getSchemeid();
                    if (lastBgSchemeID.equals(schemeid)) {
                        info.addData(budget, actual, orgUnitId, null, null);
                        continue;
                    }
                    if ((Integer)mapSchemeNumberOrder.get(lastSchemeid) <= (Integer)mapSchemeNumberOrder.get(schemeid)) continue;
                    map.put(formula, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, null, null, new HashMap(), schemeid));
                    continue;
                }
                if (schemeid.equals(currentBgSchemeID)) {
                    mapIsCurrentSchemeItem.put(formula, Boolean.TRUE);
                }
                map.put(formula, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, null, null, new HashMap(), schemeid));
            }
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return map;
    }

    private String sqlFactory(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, BgSchemeAssignException {
        return this.sqlFactory(ctx, filterParam, null);
    }

    private String sqlFactory(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam, String bgSchemeID2) throws BOSException, BgSchemeAssignException {
        String cacheSql = this.isUseCache(filterParam);
        if (!cacheSql.equals("")) {
            return cacheSql;
        }
        String bgFormId = filterParam.getBgFormID();
        if (StringUtils.isEmpty((String)bgSchemeID2)) {
            bgSchemeID2 = filterParam.getBgSchemeInfo().getId().toString();
        }
        String bgSchemeId = bgSchemeID2;
        CostCenterOrgUnitInfo[] orgUnitInfoAry = filterParam.getCostCenterOrgUnitInfoAry();
        CostCenterOrgUnitInfo[] lazyLoadDataOrgUnitInfoAry = filterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
        CurrencyInfo currency = filterParam.getCurrencyInfo();
        String currencyId = null;
        if (currency != null) {
            currencyId = currency.getId().toString();
        }
        String templateIdSql = "";
        String schemeIdSql = "";
        try {
            templateIdSql = this.getBgTemplateIdByOrgIdsAndTemplateId(ctx, bgFormId, orgUnitInfoAry);
            schemeIdSql = this.getAllBgSchemeIdsSql(ctx, bgSchemeId, orgUnitInfoAry);
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        String sql = "select fid ,fbgvalue ,FBizActual,forgunitid, fformula,fbgschemeid from T_BG_bgdata where fbgtemplateid in " + templateIdSql + " and fbgschemeid in " + schemeIdSql + " and forgunitid in " + this.constructOrgUnitSql(lazyLoadDataOrgUnitInfoAry);
        if (currencyId != null) {
            sql = sql + " and fcurrencyid ='" + currencyId + "'";
        }
        this.cache(filterParam, sql);
        return sql;
    }

    private String sqlFactoryForGetData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, BgSchemeAssignException {
        String bgFormId = filterParam.getBgFormID();
        String bgSchemeId = filterParam.getBgSchemeInfo().getId().toString();
        CostCenterOrgUnitInfo[] orgUnitInfoAry = filterParam.getCostCenterOrgUnitInfoAry();
        CostCenterOrgUnitInfo[] lazyLoadDataOrgUnitInfoAry = filterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
        CurrencyInfo currency = filterParam.getCurrencyInfo();
        String currencyId = "";
        if (currency != null) {
            currencyId = currency.getId().toString();
        }
        String templateIdSql = "";
        String schemeIdSql = "";
        try {
            templateIdSql = this.getBgTemplateIdByOrgIdsAndTemplateId(ctx, bgFormId, orgUnitInfoAry);
            schemeIdSql = this.getAllBgSchemeIdsSql(ctx, bgSchemeId, orgUnitInfoAry);
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        String sql = "select fid ,fbgvalue ,FBizActual,forgunitid, fformula ,sumPastVal from T_BG_bgdata " + this.getSumPastValSql() + " where fbgtemplateid in " + templateIdSql + " and fbgschemeid in " + schemeIdSql + " and forgunitid in " + this.constructOrgUnitSql(lazyLoadDataOrgUnitInfoAry);
        if (!"".equals(currencyId)) {
            sql = sql + " and fcurrencyid ='" + currencyId + "'";
        }
        return sql;
    }

    private String isUseCache(NewBgCompareAndAnalysisFilterParam filterParam) {
        if (filterParam.equals(lastFilterParamCache)) {
            return lastSqlCache;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache(NewBgCompareAndAnalysisFilterParam filterParam, String sql) {
        BgCompareAndAnalysisFacadeControllerBean bgCompareAndAnalysisFacadeControllerBean = this;
        synchronized (bgCompareAndAnalysisFacadeControllerBean) {
            lastFilterParamCache = filterParam;
            lastSqlCache = sql;
        }
    }

    @Override
    protected Map _getThisYearData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        BgPeriodInfo endInfo = filterParam.getEndPeriod();
        logger.info((Object)"BgCompareAndAnalysisFacadeControllerBean. _getThisYearData invoke");
        String periodIdSql = this.getThisYearPeriodIds(ctx, endInfo);
        String sql = this.sqlFactory(ctx, filterParam);
        sql = sql + " and fbgperiodid in " + periodIdSql;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, BgCompareAndAnalysisObjInfo> map = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        try {
            while (rs.next()) {
                String formula = rs.getString("fformula");
                BigDecimal budget = rs.getBigDecimal("fbgvalue");
                BigDecimal actual = rs.getBigDecimal("fbizactual");
                String orgUnitId = rs.getString("forgunitid");
                String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(formula);
                if (map.containsKey(formula = AnalysisColumnTool.rebuildFormulaWithPeriodParamNull(formulaParamArray))) {
                    BgCompareAndAnalysisObjInfo info = (BgCompareAndAnalysisObjInfo)map.get(formula);
                    info.addData(budget, actual, orgUnitId, null, null);
                    continue;
                }
                map.put(formula, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, null, null, new HashMap()));
            }
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return map;
    }

    private String getThisYearPeriodIds(Context ctx, BgPeriodInfo endInfo) throws EASBizException, BOSException {
        endInfo = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(endInfo.getId()));
        int type = endInfo.getPeriodType().getValue();
        int year = endInfo.getYear();
        java.util.Date dateTo = endInfo.getEndDate();
        dateTo = new java.util.Date(dateTo.getYear(), dateTo.getMonth(), dateTo.getDate(), 23, 59, 59);
        String sql = "select fid, fnumber from t_bg_bgperiod where fenddate <= to_date('" + this.dateToStr(dateTo) + "') and fyear = " + year + " and fperiodtype = " + type;
        StringBuffer sb = new StringBuffer();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> idList = new ArrayList<String>();
            while (rs.next()) {
                String fid = rs.getString("fid");
                idList.add(fid);
            }
            sb.append("('");
            int num = idList.size();
            for (int i = 0; i < num; ++i) {
                String periodID = idList.get(i).toString();
                sb.append(periodID);
                if (i == num - 1) break;
                sb.append("','");
            }
            sb.append("')");
        }
        catch (SQLException e1) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e1);
        }
        return sb.toString();
    }

    @Override
    protected Map _getSumData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        BgPeriodInfo endInfo = filterParam.getEndPeriod();
        String bgSchemeId = filterParam.getBgSchemeInfo().getId().toString();
        logger.info((Object)"BgCompareAndAnalysisFacadeControllerBean. _getSumData invoke");
        String periodIdSql = "";
        try {
            periodIdSql = this.getSumDataSql(ctx, endInfo, bgSchemeId);
        }
        catch (SQLException e1) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e1);
        }
        String sql = this.sqlFactory(ctx, filterParam);
        sql = sql + " and fbgperiodid in " + periodIdSql;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, BgCompareAndAnalysisObjInfo> map = new HashMap<String, BgCompareAndAnalysisObjInfo>();
        try {
            while (rs.next()) {
                String formula = rs.getString("fformula");
                BigDecimal budget = rs.getBigDecimal("fbgvalue");
                BigDecimal actual = rs.getBigDecimal("fbizactual");
                String orgUnitId = rs.getString("forgunitid");
                String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(formula);
                formula = AnalysisColumnTool.rebuildFormulaWithPeriodParamNull(formulaParamArray);
                if (map.keySet().contains(formula)) {
                    BgCompareAndAnalysisObjInfo info = (BgCompareAndAnalysisObjInfo)map.get(formula);
                    info.addData(budget, actual, orgUnitId, null, null);
                    continue;
                }
                map.put(formula, new BgCompareAndAnalysisObjInfo(orgUnitId, budget, actual, null, null, new HashMap()));
            }
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return map;
    }

    private String getSumDataSql(Context ctx, BgPeriodInfo endInfo, String bgSchemeId) throws BOSException, SQLException, BgSchemeAssignException {
        String sql;
        IRowSet rs;
        String periodId = endInfo.getId().toString();
        int type = endInfo.getPeriodType().getValue();
        java.util.Date dateFrom = null;
        java.util.Date dateTo = null;
        String _sql = "select FDateFrom from T_BG_BgScheme where fid = '" + bgSchemeId + "'";
        IRowSet _rs = DbUtil.executeQuery((Context)ctx, (String)_sql);
        if (_rs.next()) {
            dateFrom = _rs.getDate("fdatefrom");
            dateFrom = new java.util.Date(dateFrom.getYear(), dateFrom.getMonth(), dateFrom.getDate(), 0, 0, 0);
        }
        if ((rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fenddate from t_bg_bgPeriod where fid ='" + periodId + "'"))).next()) {
            dateTo = rs.getDate("fenddate");
            dateTo = new java.util.Date(dateTo.getYear(), dateTo.getMonth(), dateTo.getDate(), 23, 59, 59);
        }
        String sql_ = "select fid from t_bg_bgPeriod where fenddate <= to_date('" + this.dateToStr(dateTo) + "') and  fbegindate >= to_date('" + this.dateToStr(dateFrom) + "') and fperiodtype = " + type;
        StringBuffer sb = new StringBuffer();
        try {
            IRowSet rs_ = DbUtil.executeQuery((Context)ctx, (String)sql_);
            ArrayList<String> idList = new ArrayList<String>();
            while (rs_.next()) {
                String fid = rs_.getString("fid");
                idList.add(fid);
            }
            sb.append("('");
            int num = idList.size();
            for (int i = 0; i < num; ++i) {
                String periodID = idList.get(i).toString();
                sb.append(periodID);
                if (i == num - 1) break;
                sb.append("','");
            }
            sb.append("')");
        }
        catch (SQLException e1) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e1);
        }
        return sb.toString();
    }

    @Override
    protected List _getBudgetViewValueList(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam, String orgUnitID, String formula) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisFacadeControllerBean. _getBudgetViewValueList invoke");
        String idSql = this.getViewValueListHelpSql(ctx, filterParam, orgUnitID, formula);
        if ("".equals(idSql)) {
            return null;
        }
        String sql = "select b.fpastvalue pastValue ,b.fadjusttime adjustTime,a.fpastSource pastSource from t_bg_bgpastrecord a, t_bg_bgpastdata b where a.fid = b.fpastrecordid  and b.fpastrecordid in (select fid from t_bg_bgpastrecord where fpastSource not in (5,7,9)) and b.fbgdataid in " + idSql;
        ArrayList<BgCompareAndAnalysisObjInfo.BudgetAdjustRecordDataObj> rtnList = new ArrayList<BgCompareAndAnalysisObjInfo.BudgetAdjustRecordDataObj>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                BigDecimal pastVal = rs.getBigDecimal("pastValue");
                int pastSource = rs.getInt("pastSource");
                Date modifyDate = rs.getDate("adjustTime");
                BgCompareAndAnalysisObjInfo.BudgetAdjustRecordDataObj info = new BgCompareAndAnalysisObjInfo.BudgetAdjustRecordDataObj(modifyDate, pastSource, pastVal);
                rtnList.add(info);
            }
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return rtnList;
    }

    private String getViewValueListHelpSql(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam, String orgUnitID, String formula) throws EASBizException, BOSException {
        String orgUnitNum = null;
        if (orgUnitID == null) {
            String[] array = formula.split("&");
            if (array.length < 2) {
                return "";
            }
            formula = array[0];
            orgUnitNum = array[1];
        }
        String sqlOrgUnit = null;
        sqlOrgUnit = orgUnitNum != null ? " and forgunitid = (select fid from t_org_baseunit where fnumber = '" + orgUnitNum + "')" : " and forgunitid = '" + orgUnitID + "'";
        String bgSchemeID = filterParam.getBgSchemeInfo().getId().toString();
        BgPeriodInfo beginInfo = filterParam.getBeginPeriod();
        String periodIdSql = "";
        ArrayList<String> listFormula = new ArrayList<String>();
        if (beginInfo != null) {
            BgPeriodInfo endInfo = filterParam.getEndPeriod();
            BgPeriodCollection bgPC = null;
            bgPC = BgPeriodFactory.getLocalInstance(ctx).getPeriodCollection(beginInfo.getId(), endInfo.getId());
            String[] params = BgFillHelper.parseStrFormulaToArray(formula);
            periodIdSql = this.constructPeriodSql(bgPC);
            String temFormula = null;
            int size = bgPC.size();
            for (int i = 0; i < size; ++i) {
                temFormula = "=BgItem(\"" + params[0] + "\",\"" + bgPC.get(i).getNumber() + "\",\"" + params[2] + "\",\"BgData\",true,\"" + params[5] + "\")";
                listFormula.add(temFormula);
            }
        } else {
            String[] bgItemAry = BgFillHelper.parseStrFormulaToArray(formula);
            periodIdSql = "(select fid from t_bg_bgperiod where fnumber = '" + bgItemAry[1] + "')";
            listFormula.add(formula);
        }
        String sql = "select fid , fformula from t_bg_bgdata  where fbgschemeid in (select fid from t_bg_bgscheme where frootid = (select frootid from t_bg_bgscheme where fid = '" + bgSchemeID + "')" + sqlOrgUnit + ") and fbgperiodid in " + periodIdSql;
        HashSet<String> tempIDSet = new HashSet<String>();
        String str = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String tempFormula = rs.getString("fformula");
                str = str + "\n" + tempFormula;
                if (!listFormula.contains(tempFormula)) continue;
                tempIDSet.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        StringBuffer sb = new StringBuffer();
        ArrayList tempIDList = new ArrayList(tempIDSet);
        sb.append("('");
        int num = tempIDList.size();
        for (int i = 0; i < num; ++i) {
            String periodID = tempIDList.get(i).toString();
            sb.append(periodID);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    @Override
    protected List _getActualViewValueList(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam, String orgUnitID, String formula) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisFacadeControllerBean. _getActualViewValueList invoke");
        String idSql = this.getViewValueListHelpSql(ctx, filterParam, orgUnitID, formula);
        String sql = "select FActualAmount , FBillType , FBgPeriodId , FBillNumber ,FBizDate from T_BG_BgCtrlRecord  where fbgDataId in " + idSql;
        ArrayList<BgCompareAndAnalysisObjInfo.ActualAdjustRecordDataObj> rtnList = new ArrayList<BgCompareAndAnalysisObjInfo.ActualAdjustRecordDataObj>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                BigDecimal actualVal = rs.getBigDecimal("FActualAmount");
                String billType = rs.getString("FBillType");
                String periodNum = rs.getString("FBgPeriodId");
                String billNum = rs.getString("FBillNumber");
                Date bizDate = rs.getDate("FBizDate");
                BgCompareAndAnalysisObjInfo.ActualAdjustRecordDataObj info = new BgCompareAndAnalysisObjInfo.ActualAdjustRecordDataObj(actualVal, billType, periodNum, billNum, bizDate);
                rtnList.add(info);
            }
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return rtnList;
    }

    @Override
    protected Map _getBalanceData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        if (filterParam.getBeginPeriod() == null && filterParam.getEndPeriod() == null) {
            BgFormInfo info = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(filterParam.getBgFormID()));
            BgPeriodInfo period = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(info.getBgPeriod().getId()));
            filterParam.setBeginPeriod(period);
            filterParam.setEndPeriod(period);
        }
        if (filterParam.getBeginPeriod() == null && filterParam.getEndPeriod() != null) {
            filterParam.setBeginPeriod(filterParam.getEndPeriod());
        }
        if (filterParam.getBeginPeriod() != null && filterParam.getEndPeriod() == null) {
            filterParam.setEndPeriod(filterParam.getBeginPeriod());
        }
        Map map = BgGetPeriodBlanceUtil.getBlance(ctx, filterParam, BgGetPeriodTypeForGetBlanceEnum.Is_User_Blance);
        HashMap mapReturn = new HashMap();
        Object key2 = null;
        String formula = null;
        if (map != null) {
            for (Object key2 : map.keySet()) {
                formula = key2;
                String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(formula);
                formula = AnalysisColumnTool.rebuildFormulaWithPeriodParamNull(formulaParamArray);
                mapReturn.put(formula, map.get(key2));
            }
        }
        return mapReturn;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCurBgSchemeIDByOrg(Context ctx, String bgSchemeID, String orgID) throws BgSchemeAssignException {
        Connection con;
        PreparedStatement ps;
        ResultSet rs;
        block5: {
            String string;
            String sql = "select fid from t_bg_bgscheme where forgunitid = ? and frootid in (select frootid from t_bg_bgscheme where fid = ?)";
            rs = null;
            ps = null;
            con = null;
            try {
                con = this.getConnection(ctx);
                ps = con.prepareStatement(sql);
                ps.setString(1, orgID);
                ps.setString(2, bgSchemeID);
                rs = ps.executeQuery();
                if (!rs.next()) break block5;
                string = rs.getString("fid");
            }
            catch (SQLDataException e) {
                try {
                    throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
                    catch (SQLException e2) {
                        throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e2);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return "";
    }

    private List getBgItemByBgFormID(Context ctx, String bgFormID) throws BOSException, BgSchemeAssignException {
        String sql = "select fformula from t_bg_bgdata where fbgformid = '" + bgFormID + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (rs.next()) {
                String bgItem = rs.getString("fformula");
                list.add(bgItem);
            }
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return list;
    }

    @Override
    protected Map _getPeriodBalanceData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        if (filterParam.getBeginPeriod() == null && filterParam.getEndPeriod() == null) {
            BgFormInfo info = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(filterParam.getBgFormID()));
            BgPeriodInfo period = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(info.getBgPeriod().getId()));
            filterParam.setBeginPeriod(period);
            filterParam.setEndPeriod(period);
        }
        if (filterParam.getBeginPeriod() == null && filterParam.getEndPeriod() != null) {
            filterParam.setBeginPeriod(filterParam.getEndPeriod());
        }
        if (filterParam.getBeginPeriod() != null && filterParam.getEndPeriod() == null) {
            filterParam.setEndPeriod(filterParam.getBeginPeriod());
        }
        Map map = BgGetPeriodBlanceUtil.getBlance(ctx, filterParam, BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance);
        HashMap mapReturn = new HashMap();
        Object key2 = null;
        String formula = null;
        if (map != null) {
            for (Object key2 : map.keySet()) {
                formula = key2;
                String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(formula);
                formula = AnalysisColumnTool.rebuildFormulaWithPeriodParamNull(formulaParamArray);
                mapReturn.put(formula, map.get(key2));
            }
        }
        return mapReturn;
    }

    @Override
    protected Map _getBeforeData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        if (filterParam.getBeginPeriod() == null && filterParam.getEndPeriod() == null) {
            BgFormInfo info = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(filterParam.getBgFormID()));
            BgPeriodInfo period = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(info.getBgPeriod().getId()));
            filterParam.setBeginPeriod(period);
            filterParam.setEndPeriod(period);
        }
        if (filterParam.getBeginPeriod() == null && filterParam.getEndPeriod() != null) {
            filterParam.setBeginPeriod(filterParam.getEndPeriod());
        }
        if (filterParam.getBeginPeriod() != null && filterParam.getEndPeriod() == null) {
            filterParam.setEndPeriod(filterParam.getBeginPeriod());
        }
        Map map = BgGetPeriodBlanceUtil.getBeforeBlance(ctx, filterParam, BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance);
        HashMap mapReturn = new HashMap();
        Object key2 = null;
        String formula = null;
        if (map != null) {
            for (Object key2 : map.keySet()) {
                formula = key2;
                String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(formula);
                formula = AnalysisColumnTool.rebuildFormulaWithPeriodParamNull(formulaParamArray);
                mapReturn.put(formula, map.get(key2));
            }
        }
        return mapReturn;
    }

    @Override
    protected Map _getHalfYareData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getLastMonthActualData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getLastMonthSumActualData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getQuarterData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return null;
    }
}

