/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCompareAndAnalysisBgFormulaObjInfo;
import com.kingdee.eas.ma.budget.BgControlFacadeFactory;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgControlFacade;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.util.AnalysisColumnTool;
import com.kingdee.eas.ma.budget.app.AbstractBgCompareAndAnalysisForBgFormulaFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCompareAndAnalysisForBgFormulaFacadeControllerBean
extends AbstractBgCompareAndAnalysisForBgFormulaFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)BgCompareAndAnalysisForBgFormulaFacadeControllerBean.class.getName());
    private static final long serialVersionUID = 7427036703336340396L;
    private static final String date_pattern = "yyyy-MM-dd HH:mm:ss";

    private String dateToStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(date_pattern);
        return sdf.format(date);
    }

    private String constructBgItemSql(String[] bgFormulaAry, BgPeriodCollection cols) {
        String[] bgItemAry = AnalysisColumnTool.parseBgFormula(bgFormulaAry, cols);
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = bgItemAry.length;
        for (int i = 0; i < num; ++i) {
            sb.append(bgItemAry[i]);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private BgPeriodCollection getBgPeriodColByNums(Context ctx, String[] bgFormulaAry, boolean isLastYear) throws EASBizException, BOSException {
        String sPeriodNum = bgFormulaAry[5];
        String ePeriodNum = bgFormulaAry[6];
        if (isLastYear) {
            sPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)sPeriodNum, (int)-1);
            ePeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)ePeriodNum, (int)-1);
        }
        BgPeriodCollection cols = null;
        cols = BgPeriodFactory.getLocalInstance(ctx).getPeriodColByNums(sPeriodNum, ePeriodNum);
        return cols;
    }

    @Override
    protected Map _getData(Context ctx, String bgFormula) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisForBgFormulaFacadeControllerBean. _getData invoke");
        HashMap<String, BgCompareAndAnalysisBgFormulaObjInfo> map = new HashMap<String, BgCompareAndAnalysisBgFormulaObjInfo>();
        String[] bgFormulaAry = BgFillHelper.parseStrFormulaToArray(bgFormula);
        String orgUnitNum = bgFormulaAry[0];
        orgUnitNum = this.getOrgUnitNumSql(orgUnitNum);
        if (orgUnitNum.equals("")) {
            return map;
        }
        BgPeriodCollection cols = this.getBgPeriodColByNums(ctx, bgFormulaAry, false);
        String sql = "select fbgformId , fformula, fbgvalue ,FBizActual ,sumPastVal from t_bg_bgdata " + this.getSumPastValSql() + " where fbgschemeid in  (select fid from t_bg_bgscheme where fnumber = '" + bgFormulaAry[1] + "' and forgunitid in (select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")) and fformula in " + this.constructBgItemSql(bgFormulaAry, cols) + " and forgunitid in ( select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")";
        String temsql = "select fbgformId , fformula, fbgvalue ,FBizActual ,sumPastVal from t_bg_bgTmpdata " + this.getSumPastValSql() + " where fbgschemeid in  (select fid from t_bg_bgscheme where fnumber = '" + bgFormulaAry[1] + "' and forgunitid in (select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")) and fformula in " + this.constructBgItemSql(bgFormulaAry, cols) + " and forgunitid in ( select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")";
        try {
            BigDecimal tempActual;
            BigDecimal tempBgVal;
            String id;
            BigDecimal tempPastVal;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            BigDecimal pastVal = new BigDecimal("0.00");
            BigDecimal budget = new BigDecimal("0.00");
            BigDecimal actual = new BigDecimal("0.00");
            HashMap<String, BigDecimal> pastMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> budgetMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> actualMap = new HashMap<String, BigDecimal>();
            while (rs.next()) {
                tempPastVal = rs.getBigDecimal("sumPastVal");
                id = rs.getString("fbgformId") + rs.getString("fformula");
                if (tempPastVal != null) {
                    pastMap.put(id + "sumPastVal", tempPastVal);
                }
                if ((tempBgVal = rs.getBigDecimal("fbgvalue")) != null) {
                    budgetMap.put(id + "fbgvalue", tempBgVal);
                }
                if ((tempActual = rs.getBigDecimal("fbizactual")) == null) continue;
                actualMap.put(id + "fbizactual", tempActual);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)temsql);
            while (rs.next()) {
                tempPastVal = rs.getBigDecimal("sumPastVal");
                id = rs.getString("fbgformId") + rs.getString("fformula");
                if (tempPastVal != null) {
                    pastMap.put(id + "sumPastVal", tempPastVal);
                }
                if ((tempBgVal = rs.getBigDecimal("fbgvalue")) != null) {
                    budgetMap.put(id + "fbgvalue", tempBgVal);
                }
                if ((tempActual = rs.getBigDecimal("fbizactual")) == null) continue;
                actualMap.put(id + "fbizactual", tempActual);
            }
            BigDecimal temData = new BigDecimal("0.00");
            for (Map.Entry e : pastMap.entrySet()) {
                temData = (BigDecimal)e.getValue();
                pastVal = pastVal.add(temData);
            }
            for (Map.Entry e : budgetMap.entrySet()) {
                temData = (BigDecimal)e.getValue();
                budget = budget.add(temData);
            }
            for (Map.Entry e : actualMap.entrySet()) {
                temData = (BigDecimal)e.getValue();
                actual = actual.add(temData);
            }
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = new BgCompareAndAnalysisBgFormulaObjInfo(budget, actual, pastVal, null);
            map.put(bgFormula, objInfo);
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return map;
    }

    private String getSumPastValSql() {
        String sql = "a left join (select fbgdataid , sum(FPASTVALUE) sumPastVal from T_BG_bgpastdata  where FPastRecordID in (select fid from t_bg_bgpastrecord where fpastSource <> " + BgPastSourceEnum.DECOMPOSER.getValue() + "  and   fpastSource <> " + BgPastSourceEnum.PERIODDEC.getValue() + " ) group by fbgdataid) b on a.fid = b.fbgdataid";
        return sql;
    }

    private String getLastYearPeriodIds(Context ctx, BgPeriodInfo beginInfo, BgPeriodInfo endInfo, String[] formulaParamArray) throws EASBizException, BOSException {
        if (beginInfo == null || endInfo == null) {
            return "('')";
        }
        beginInfo = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(beginInfo.getId()));
        endInfo = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(endInfo.getId()));
        int type = beginInfo.getPeriodType().getValue();
        int year = beginInfo.getYear() - 1;
        Date beginDate = beginInfo.getBeginDate();
        Date endDate = endInfo.getEndDate();
        String sql = "select fnumber from t_bg_bgperiod where fyear = " + year + " and fperiodtype = " + type + " and fbegindate >= to_date('" + this.dateToStr(new Date(beginDate.getYear() - 1, beginDate.getMonth(), beginDate.getDate(), 0, 0, 0)) + " ') and fenddate <= to_date('" + this.dateToStr(new Date(endDate.getYear() - 1, endDate.getMonth(), endDate.getDate(), 23, 59, 59)) + "')";
        StringBuffer sb = new StringBuffer();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> numList = new ArrayList<String>();
            while (rs.next()) {
                String num = rs.getString("fnumber");
                numList.add(num);
            }
            sb.append("('");
            int num = numList.size();
            for (int i = 0; i < num; ++i) {
                String periodNum = numList.get(i).toString();
                String bgItem = AnalysisColumnTool.buildBgItem(formulaParamArray, periodNum);
                sb.append(bgItem);
                if (i == num - 1) break;
                sb.append("','");
            }
            sb.append("')");
        }
        catch (SQLException e1) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e1);
        }
        return sb.toString();
    }

    @Override
    protected Map _getLastYearData(Context ctx, String bgFormula) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisForBgFormulaFacadeControllerBean. _getLastYearData invoke");
        HashMap<String, BgCompareAndAnalysisBgFormulaObjInfo> map = new HashMap<String, BgCompareAndAnalysisBgFormulaObjInfo>();
        String[] bgFormulaAry = BgFillHelper.parseStrFormulaToArray(bgFormula);
        String orgUnitNum = bgFormulaAry[0];
        orgUnitNum = this.getOrgUnitNumSql(orgUnitNum);
        if (orgUnitNum.equals("")) {
            return map;
        }
        BgPeriodCollection cols = this.getBgPeriodColByNums(ctx, bgFormulaAry, false);
        int size = cols.size();
        BgPeriodInfo sInfo = cols.get(0);
        BgPeriodInfo eInfo = cols.get(size - 1);
        String sql = "select fbgformId , fformula, fbgvalue ,FBizActual from t_bg_bgdata  where fbgschemeid in  (select fid from t_bg_bgscheme where fnumber = '" + bgFormulaAry[1] + "' and forgunitid in (select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")) and fformula in " + this.getLastYearPeriodIds(ctx, sInfo, eInfo, bgFormulaAry) + " and forgunitid in ( select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")";
        String temsql = "select fbgformId , fformula, fbgvalue ,FBizActual from t_bg_bgTmpdata  where fbgschemeid in  (select fid from t_bg_bgscheme where fnumber = '" + bgFormulaAry[1] + "' and forgunitid in (select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")) and fformula in " + this.getLastYearPeriodIds(ctx, sInfo, eInfo, bgFormulaAry) + " and forgunitid in ( select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")";
        try {
            BigDecimal tempActual;
            BigDecimal tempBgVal;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            BigDecimal budget = new BigDecimal("0.00");
            BigDecimal actual = new BigDecimal("0.00");
            HashMap<String, BigDecimal> budgetMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> actualMap = new HashMap<String, BigDecimal>();
            String id = null;
            while (rs.next()) {
                id = rs.getString("fbgformId") + rs.getString("fformula");
                tempBgVal = rs.getBigDecimal("fbgvalue");
                if (tempBgVal != null) {
                    budgetMap.put(id + "fbgvalue", tempBgVal);
                }
                if ((tempActual = rs.getBigDecimal("fbizactual")) == null) continue;
                actualMap.put(id + "fbizactual", tempActual);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)temsql);
            while (rs.next()) {
                id = rs.getString("fbgformId") + rs.getString("fformula");
                tempBgVal = rs.getBigDecimal("fbgvalue");
                if (tempBgVal != null) {
                    budgetMap.put(id + "fbgvalue", tempBgVal);
                }
                if ((tempActual = rs.getBigDecimal("fbizactual")) == null) continue;
                actualMap.put(id + "fbizactual", tempActual);
            }
            BigDecimal temData = new BigDecimal("0.00");
            for (Map.Entry e : budgetMap.entrySet()) {
                temData = (BigDecimal)e.getValue();
                budget = budget.add(temData);
            }
            for (Map.Entry e : actualMap.entrySet()) {
                temData = (BigDecimal)e.getValue();
                actual = actual.add(temData);
            }
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = new BgCompareAndAnalysisBgFormulaObjInfo(budget, actual, null, null);
            map.put(bgFormula, objInfo);
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return map;
    }

    private String getThisYearPeriodIds(Context ctx, BgPeriodInfo endInfo, String[] formulaParamArray) throws EASBizException, BOSException {
        endInfo = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(endInfo.getId()));
        int type = endInfo.getPeriodType().getValue();
        int year = endInfo.getYear();
        Date dateTo = endInfo.getEndDate();
        dateTo = new Date(dateTo.getYear(), dateTo.getMonth(), dateTo.getDate(), 23, 59, 59);
        String sql = "select fnumber from t_bg_bgperiod where fenddate <= to_date('" + this.dateToStr(dateTo) + "') and fyear = " + year + " and fperiodtype = " + type;
        StringBuffer sb = new StringBuffer();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> idList = new ArrayList<String>();
            while (rs.next()) {
                String num = rs.getString("fnumber");
                idList.add(num);
            }
            sb.append("('");
            int num = idList.size();
            for (int i = 0; i < num; ++i) {
                String periodNum = idList.get(i).toString();
                String bgItem = AnalysisColumnTool.buildBgItem(formulaParamArray, periodNum);
                sb.append(bgItem);
                if (i == num - 1) break;
                sb.append("','");
            }
            sb.append("')");
        }
        catch (SQLException e1) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e1);
        }
        return sb.toString();
    }

    private String getLYPeriod(Context ctx, BgPeriodCollection periodCol, String[] formulaParamArray) {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        BgPeriodInfo info = null;
        int size = periodCol.size();
        for (int i = 0; i < size; ++i) {
            info = periodCol.get(i);
            String periodNum = info.getNumber();
            String bgItem = AnalysisColumnTool.buildBgItem(formulaParamArray, periodNum);
            sb.append(bgItem);
            if (i == size - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    @Override
    protected Map _getThisYearData(Context ctx, String bgFormula) throws BOSException, EASBizException {
        int eYear;
        int periodEType;
        logger.info((Object)"BgCompareAndAnalysisForBgFormulaFacadeControllerBean. _getThisYearData invoke");
        HashMap<String, BgCompareAndAnalysisBgFormulaObjInfo> map = new HashMap<String, BgCompareAndAnalysisBgFormulaObjInfo>();
        String[] bgFormulaAry = BgFillHelper.parseStrFormulaToArray(bgFormula);
        String orgUnitNum = bgFormulaAry[0];
        orgUnitNum = this.getOrgUnitNumSql(orgUnitNum);
        if (orgUnitNum.equals("")) {
            return map;
        }
        int periodBType = BgNPeriodHelper.parserBgPeriodType((String)bgFormulaAry[5]);
        if (periodBType != (periodEType = BgNPeriodHelper.parserBgPeriodType((String)bgFormulaAry[6]))) {
            return map;
        }
        int bYear = BgNPeriodHelper.parserBgPeriodYear((String)bgFormulaAry[5]);
        if (bYear != (eYear = BgNPeriodHelper.parserBgPeriodYear((String)bgFormulaAry[6]))) {
            return map;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(periodBType), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(bYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bgFormulaAry[5], CompareType.LESS_EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        view.setSelector(sic);
        BgPeriodCollection cols = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodCollection(view);
        int size = cols.size();
        BgPeriodInfo eInfo = cols.get(size - 1);
        String sql = "select fbgformId , fformula, fbgvalue ,FBizActual from t_bg_bgdata  where fbgschemeid in  (select fid from t_bg_bgscheme where fnumber = '" + bgFormulaAry[1] + "' and forgunitid in (select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")) and fformula in " + this.getLYPeriod(ctx, cols, bgFormulaAry) + " and forgunitid in ( select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")";
        String temsql = "select fbgformId , fformula, fbgvalue ,FBizActual from t_bg_bgTmpdata  where fbgschemeid in  (select fid from t_bg_bgscheme where fnumber = '" + bgFormulaAry[1] + "' and forgunitid in (select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")) and fformula in " + this.getLYPeriod(ctx, cols, bgFormulaAry) + " and forgunitid in ( select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")";
        IRowSet rs = null;
        try {
            BigDecimal tempActual;
            BigDecimal tempBgVal;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            BigDecimal budget = new BigDecimal("0.00");
            BigDecimal actual = new BigDecimal("0.00");
            HashMap<String, BigDecimal> budgetMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> actualMap = new HashMap<String, BigDecimal>();
            String id = null;
            while (rs.next()) {
                id = rs.getString("fbgformId") + rs.getString("fformula");
                tempBgVal = rs.getBigDecimal("fbgvalue");
                if (tempBgVal != null) {
                    budgetMap.put(id + "fbgvalue", tempBgVal);
                }
                if ((tempActual = rs.getBigDecimal("fbizactual")) == null) continue;
                actualMap.put(id + "fbizactual", tempActual);
            }
            SQLUtils.cleanup((ResultSet)rs);
            rs = DbUtil.executeQuery((Context)ctx, (String)temsql);
            while (rs.next()) {
                id = rs.getString("fbgformId") + rs.getString("fformula");
                tempBgVal = rs.getBigDecimal("fbgvalue");
                if (tempBgVal != null) {
                    budgetMap.put(id + "fbgvalue", tempBgVal);
                }
                if ((tempActual = rs.getBigDecimal("fbizactual")) == null) continue;
                actualMap.put(id + "fbizactual", tempActual);
            }
            BigDecimal temData = new BigDecimal("0.00");
            for (Map.Entry e : budgetMap.entrySet()) {
                temData = (BigDecimal)e.getValue();
                budget = budget.add(temData);
            }
            for (Map.Entry e : actualMap.entrySet()) {
                temData = (BigDecimal)e.getValue();
                actual = actual.add(temData);
            }
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = new BgCompareAndAnalysisBgFormulaObjInfo(budget, actual, null, null);
            map.put(bgFormula, objInfo);
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return map;
    }

    private String getSumDataSql(Context ctx, BgPeriodInfo endInfo, String bgSchemeId, String[] formulaParamArray) throws BOSException, BgSchemeAssignException {
        String periodId = endInfo.getId().toString();
        int type = endInfo.getPeriodType().getValue();
        Date dateFrom = null;
        Date dateTo = null;
        String _sql = "select FDateFrom from T_BG_BgScheme where fid = '" + bgSchemeId + "'";
        IRowSet _rs = DbUtil.executeQuery((Context)ctx, (String)_sql);
        try {
            String sql;
            IRowSet rs;
            if (_rs.next()) {
                dateFrom = _rs.getDate("fdatefrom");
                dateFrom = new Date(dateFrom.getYear(), dateFrom.getMonth(), dateFrom.getDate(), 0, 0, 0);
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fenddate from t_bg_bgPeriod where fid ='" + periodId + "'"))).next()) {
                dateTo = rs.getDate("fenddate");
                dateTo = new Date(dateTo.getYear(), dateTo.getMonth(), dateTo.getDate(), 23, 59, 59);
            }
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        String sql_ = "select fnumber from t_bg_bgPeriod where fenddate <= to_date('" + this.dateToStr(dateTo) + "') and  fbegindate >= to_date('" + this.dateToStr(dateFrom) + "') and fperiodtype = " + type;
        StringBuffer sb = new StringBuffer();
        try {
            IRowSet rs_ = DbUtil.executeQuery((Context)ctx, (String)sql_);
            ArrayList<String> numList = new ArrayList<String>();
            while (rs_.next()) {
                String num = rs_.getString("fnumber");
                numList.add(num);
            }
            sb.append("('");
            int num = numList.size();
            for (int i = 0; i < num; ++i) {
                String periodNum = numList.get(i).toString();
                String bgItem = AnalysisColumnTool.buildBgItem(formulaParamArray, periodNum);
                sb.append(bgItem);
                if (i == num - 1) break;
                sb.append("','");
            }
            sb.append("')");
        }
        catch (SQLException e1) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e1);
        }
        return sb.toString();
    }

    private String getOrgUnitNumSql(String orgUnitNums) {
        String[] array = orgUnitNums.split(";");
        int num = array.length;
        if (num == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        for (int i = 0; i < num; ++i) {
            sb.append(array[i]);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    @Override
    protected Map _getSumData(Context ctx, String bgFormula, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisForBgFormulaFacadeControllerBean. _getSumData invoke");
        HashMap<String, BgCompareAndAnalysisBgFormulaObjInfo> map = new HashMap<String, BgCompareAndAnalysisBgFormulaObjInfo>();
        String[] bgFormulaAry = BgFillHelper.parseStrFormulaToArray(bgFormula);
        String orgUnitNum = bgFormulaAry[0];
        orgUnitNum = this.getOrgUnitNumSql(orgUnitNum);
        if (orgUnitNum.equals("")) {
            return map;
        }
        BgPeriodCollection cols = this.getBgPeriodColByNums(ctx, bgFormulaAry, false);
        int size = cols.size();
        BgPeriodInfo eInfo = cols.get(size - 1);
        String bgSchemeID = filterParam.getBgSchemeInfo().getId().toString();
        String sql = "select fbgformId , fformula, fbgvalue ,FBizActual from t_bg_bgdata  where fbgschemeid in  (select fid from t_bg_bgscheme where fnumber = '" + bgFormulaAry[1] + "' and forgunitid in (select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")) and fformula in " + this.getSumDataSql(ctx, eInfo, bgSchemeID, bgFormulaAry) + " and forgunitid in ( select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")";
        String temsql = "select fbgformId , fformula, fbgvalue ,FBizActual from t_bg_bgTmpdata  where fbgschemeid in  (select fid from t_bg_bgscheme where fnumber = '" + bgFormulaAry[1] + "' and forgunitid in (select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")) and fformula in " + this.getSumDataSql(ctx, eInfo, bgSchemeID, bgFormulaAry) + " and forgunitid in ( select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")";
        try {
            BigDecimal tempActual;
            BigDecimal tempBgVal;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            BigDecimal budget = new BigDecimal("0.00");
            BigDecimal actual = new BigDecimal("0.00");
            HashMap<String, BigDecimal> budgetMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> actualMap = new HashMap<String, BigDecimal>();
            String id = null;
            while (rs.next()) {
                id = rs.getString("fbgformId") + rs.getString("fformula");
                tempBgVal = rs.getBigDecimal("fbgvalue");
                if (tempBgVal != null) {
                    budgetMap.put(id + "fbgvalue", tempBgVal);
                }
                if ((tempActual = rs.getBigDecimal("fbizactual")) == null) continue;
                actualMap.put(id + "fbizactual", tempActual);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)temsql);
            while (rs.next()) {
                id = rs.getString("fbgformId") + rs.getString("fformula");
                tempBgVal = rs.getBigDecimal("fbgvalue");
                if (tempBgVal != null) {
                    budgetMap.put(id + "fbgvalue", tempBgVal);
                }
                if ((tempActual = rs.getBigDecimal("fbizactual")) == null) continue;
                actualMap.put(id + "fbizactual", tempActual);
            }
            BigDecimal temData = new BigDecimal("0.00");
            for (Map.Entry e : budgetMap.entrySet()) {
                temData = (BigDecimal)e.getValue();
                budget = budget.add(temData);
            }
            for (Map.Entry e : actualMap.entrySet()) {
                temData = (BigDecimal)e.getValue();
                actual = actual.add(temData);
            }
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = new BgCompareAndAnalysisBgFormulaObjInfo(budget, actual, null, null);
            map.put(bgFormula, objInfo);
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return map;
    }

    @Override
    protected Map _getBalanceData(Context ctx, String bgFormula) throws BOSException, EASBizException {
        HashMap<String, BgCompareAndAnalysisBgFormulaObjInfo> map = new HashMap<String, BgCompareAndAnalysisBgFormulaObjInfo>();
        logger.info((Object)"BgCompareAndAnalysisForBgFormulaFacadeControllerBean. _getBalanceData invoke");
        String[] bgFormulaAry = BgFillHelper.parseStrFormulaToArray(bgFormula);
        String orgUnitNum = bgFormulaAry[0];
        String schemeNum = bgFormulaAry[1];
        if (orgUnitNum.equals("")) {
            return map;
        }
        String oql = "select period , id , orgUnit.id where orgUnit.number ='" + orgUnitNum + "' and number = '" + schemeNum + "'";
        BgSchemeCollection cols = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection(oql);
        BgSchemeInfo info = cols.get(0);
        IBgControlFacade facade = BgControlFacadeFactory.getLocalInstance(ctx);
        String bgItem = AnalysisColumnTool.changeBgFormulaToBgItem(bgFormula);
        BOSUuid orgID = info.getOrgUnit().getId();
        BOSUuid bgSchemeID = info.getId();
        BgPeriodEnum bgSchemePeriod = info.getPeriod();
        BigDecimal balance = facade.getBalanceByFormula(bgItem, orgID, bgSchemeID, bgSchemePeriod);
        BgCompareAndAnalysisBgFormulaObjInfo objInfo = new BgCompareAndAnalysisBgFormulaObjInfo(null, null, null, balance);
        map.put(bgFormula, objInfo);
        return map;
    }

    @Override
    protected Map _getBalanceData(Context ctx, List formulas) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getData(Context ctx, List fomulas) throws BOSException, EASBizException {
        logger.info((Object)"BgCompareAndAnalysisForBgFormulaFacadeControllerBean. _getData invoke");
        HashMap<String, BgCompareAndAnalysisBgFormulaObjInfo> map = new HashMap<String, BgCompareAndAnalysisBgFormulaObjInfo>();
        String bgFormula = null;
        String[] bgFormulaAry = BgFillHelper.parseStrFormulaToArray(bgFormula);
        String orgUnitNum = bgFormulaAry[0];
        orgUnitNum = this.getOrgUnitNumSql(orgUnitNum);
        if (orgUnitNum.equals("")) {
            return map;
        }
        BgPeriodCollection cols = this.getBgPeriodColByNums(ctx, bgFormulaAry, false);
        String sql = "select fbgformId , fformula, fbgvalue ,FBizActual ,sumPastVal from t_bg_bgdata " + this.getSumPastValSql() + " where fbgschemeid in  (select fid from t_bg_bgscheme where fnumber = '" + bgFormulaAry[1] + "' and forgunitid in (select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")) and fformula in " + this.constructBgItemSql(bgFormulaAry, cols) + " and forgunitid in ( select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")";
        String temsql = "select fbgformId , fformula, fbgvalue ,FBizActual ,sumPastVal from t_bg_bgTmpdata " + this.getSumPastValSql() + " where fbgschemeid in  (select fid from t_bg_bgscheme where fnumber = '" + bgFormulaAry[1] + "' and forgunitid in (select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")) and fformula in " + this.constructBgItemSql(bgFormulaAry, cols) + " and forgunitid in ( select fid from t_org_baseunit where fnumber in " + orgUnitNum + ")";
        try {
            BigDecimal tempActual;
            BigDecimal tempBgVal;
            String id;
            BigDecimal tempPastVal;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            BigDecimal pastVal = new BigDecimal("0.00");
            BigDecimal budget = new BigDecimal("0.00");
            BigDecimal actual = new BigDecimal("0.00");
            HashMap<String, BigDecimal> pastMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> budgetMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> actualMap = new HashMap<String, BigDecimal>();
            while (rs.next()) {
                tempPastVal = rs.getBigDecimal("sumPastVal");
                id = rs.getString("fbgformId") + rs.getString("fformula");
                if (tempPastVal != null) {
                    pastMap.put(id + "sumPastVal", tempPastVal);
                }
                if ((tempBgVal = rs.getBigDecimal("fbgvalue")) != null) {
                    budgetMap.put(id + "fbgvalue", tempBgVal);
                }
                if ((tempActual = rs.getBigDecimal("fbizactual")) == null) continue;
                actualMap.put(id + "fbizactual", tempActual);
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)temsql);
            while (rs.next()) {
                tempPastVal = rs.getBigDecimal("sumPastVal");
                id = rs.getString("fbgformId") + rs.getString("fformula");
                if (tempPastVal != null) {
                    pastMap.put(id + "sumPastVal", tempPastVal);
                }
                if ((tempBgVal = rs.getBigDecimal("fbgvalue")) != null) {
                    budgetMap.put(id + "fbgvalue", tempBgVal);
                }
                if ((tempActual = rs.getBigDecimal("fbizactual")) == null) continue;
                actualMap.put(id + "fbizactual", tempActual);
            }
            BigDecimal temData = new BigDecimal("0.00");
            for (Map.Entry e : pastMap.entrySet()) {
                temData = (BigDecimal)e.getValue();
                pastVal = pastVal.add(temData);
            }
            for (Map.Entry e : budgetMap.entrySet()) {
                temData = (BigDecimal)e.getValue();
                budget = budget.add(temData);
            }
            for (Map.Entry e : actualMap.entrySet()) {
                temData = (BigDecimal)e.getValue();
                actual = actual.add(temData);
            }
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = new BgCompareAndAnalysisBgFormulaObjInfo(budget, actual, pastVal, null);
            map.put(bgFormula, objInfo);
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return map;
    }

    @Override
    protected Map _getLastYearData(Context ctx, List formulas) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getThisYearData(Context ctx, List formulas) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getSumData(Context ctx, List formulas, NewBgCompareAndAnalysisFilterParam param) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getHalfYareData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getLastMonthActualData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getLastMonthSumActualData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getQuarterData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException, EASBizException {
        return null;
    }
}

