/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgControlRuleCollection;
import com.kingdee.eas.ma.budget.BgControlRuleInfo;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgCtrlHandlerFactory;
import com.kingdee.eas.ma.budget.BgCtrlHelper;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.BgCtrlRecordFactory;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgCtrlTypeEnum;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormulaException;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodException;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeException;
import com.kingdee.eas.ma.budget.BgUtilsHelper;
import com.kingdee.eas.ma.budget.BudgetCtrlFacadeFactory;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.IBgCtrlRecord;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgFormulaFacade;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBudgetCtrlFacade;
import com.kingdee.eas.ma.budget.INewBgControlFacade;
import com.kingdee.eas.ma.budget.NewBgControlFacadeFactory;
import com.kingdee.eas.ma.budget.app.AbstractBgControlFacadeControllerBean;
import com.kingdee.eas.ma.budget.app.BgControlPeriodCacheHelper;
import com.kingdee.eas.ma.budget.app.BudgetCtrlHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgControlFacadeControllerBean
extends AbstractBgControlFacadeControllerBean {
    private static final long serialVersionUID = -1767735691190307830L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgControlFacadeControllerBean");
    public static final String PERIOD_TYPE = "periodType";
    public static final String RESULT = "result";
    public static final String currencyId = "currencyId";
    public static final String elementId = "elementId";
    public static final String isControl = "isControl";
    public static final String isGroupControl = "isGroupControl";
    public static final String isFlexible = "isFlexible";
    public static final String ctrlType = "ctrlType";
    public static final String groupNo = "groupNo";
    public static final String flexibleParam = "flexibleParam";

    @Override
    protected BigDecimal _getBalanceByFormula(Context ctx, String itemFormula, BOSUuid orgUnitId, BOSUuid schemeId, BgPeriodEnum periodTypeEnum) throws BOSException, EASBizException {
        BigDecimal zero = new BigDecimal("0.00");
        List list = new ArrayList();
        try {
            list = TableToolkit.parseFormula((String)itemFormula, (boolean)false);
        }
        catch (com.kingdee.bos.kscript.ParserException e1) {
            return zero;
        }
        if (list == null || list.isEmpty()) {
            return zero;
        }
        FormulaHint hint = (FormulaHint)list.get(0);
        String[] params = hint.getParams();
        String periodNumber = params[1];
        String currencyNumber = params[5];
        String elementNumber = params[2];
        String periodId = null;
        Date endDate = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid , fenddate from t_bg_bgperiod where fnumber = ? ", (Object[])new String[]{periodNumber});
        try {
            if (rs.next()) {
                periodId = rs.getString(1);
                endDate = rs.getDate(2);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        BgCtrlResultInfo resultInfo = new BgCtrlResultInfo();
        BgCtrlParamInfo bgCtrlParamInfo = new BgCtrlParamInfo();
        bgCtrlParamInfo.setPeriodId(periodId);
        bgCtrlParamInfo.setBizDate(endDate);
        bgCtrlParamInfo.setOrgUnitId(orgUnitId.toString());
        bgCtrlParamInfo.setCurrencyNumber(currencyNumber);
        bgCtrlParamInfo.setElementNumber(elementNumber);
        this.setBgCtrlResult(ctx, bgCtrlParamInfo.getOrgUnitId(), itemFormula, bgCtrlParamInfo, resultInfo, false, periodTypeEnum, schemeId.toString(), BgGetPeriodTypeForGetBlanceEnum.Is_Control);
        if (bgCtrlParamInfo.getBgSchemeId() == null || schemeId == null || !bgCtrlParamInfo.getBgSchemeId().trim().equals(schemeId.toString())) {
            return zero;
        }
        BigDecimal result = zero;
        if (resultInfo.getBalance() != null && (result = resultInfo.getBalance()).signum() < 0) {
            result = zero;
        }
        return result;
    }

    @Override
    protected BigDecimal _getBalanceByNumber(Context ctx, String combinId, String elementNumber, String periodNumber, String currencyNumber, BOSUuid orgUnitId, BOSUuid schemeId, BgPeriodEnum periodTypeEnum) throws BOSException, EASBizException {
        BigDecimal result = new BigDecimal("0.00");
        BigDecimal zero = new BigDecimal("0.00");
        String combiNumber = "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fkey from t_bg_bgitemcombination where fid = ?", (Object[])new Object[]{combinId});
        try {
            if (rs.next()) {
                combiNumber = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String itemFormula = "=BgItem(\"" + combiNumber.replaceAll("_", ",") + "\",\"" + periodNumber + "\",\"" + elementNumber + "\",\"BgData\",true,\"" + currencyNumber + "\")";
        BgCtrlResultInfo resultInfo = new BgCtrlResultInfo();
        BgCtrlParamInfo bgCtrlParamInfo = new BgCtrlParamInfo();
        IBgPeriod iP = BgPeriodFactory.getLocalInstance(ctx);
        BgPeriodInfo period = iP.getBgPeriodInfo("select * where number='" + periodNumber + "'");
        bgCtrlParamInfo.setPeriodId(period.getId().toString());
        bgCtrlParamInfo.setBizDate(period.getEndDate());
        bgCtrlParamInfo.setOrgUnitId(orgUnitId.toString());
        bgCtrlParamInfo.setCurrencyNumber(currencyNumber);
        bgCtrlParamInfo.setElementNumber(elementNumber);
        this.setBgCtrlResult(ctx, bgCtrlParamInfo.getOrgUnitId(), itemFormula, bgCtrlParamInfo, resultInfo, false, periodTypeEnum, schemeId.toString(), BgGetPeriodTypeForGetBlanceEnum.Is_Control);
        if (bgCtrlParamInfo.getBgSchemeId() == null || schemeId == null || !bgCtrlParamInfo.getBgSchemeId().trim().equals(schemeId.toString())) {
            return zero;
        }
        if (resultInfo.getBalance() != null && (result = resultInfo.getBalance()).signum() < 0) {
            result = new BigDecimal("0.00");
        }
        return result;
    }

    @Override
    protected boolean _updateBalanceByFormula(Context ctx, BigDecimal newBalance, String itemFormula, BOSUuid orgUnitId, BOSUuid schemeId) throws BOSException, EASBizException {
        boolean result = false;
        Connection myConn = null;
        PreparedStatement myStmt = null;
        StringBuffer mySb = new StringBuffer(200);
        mySb.append("update t_bg_bgdata set fbgbalance = ? where fformula=? and forgunitid=? and fbgschemeid = ? ");
        try {
            myConn = this.getConnection(ctx);
            myStmt = myConn.prepareStatement(mySb.toString());
            myStmt.setBigDecimal(1, newBalance);
            myStmt.setString(2, itemFormula);
            myStmt.setString(3, orgUnitId.toString());
            myStmt.setString(4, schemeId.toString());
            int updateRows = myStmt.executeUpdate();
            if (updateRows > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BgException(BgException.DATABASEERROR, e, new Object[]{"T_BG_BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(myStmt, (Connection)myConn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)myStmt, (Connection)myConn);
        return result;
    }

    @Override
    protected boolean _updateBalanceByNumber(Context ctx, BigDecimal newBalance, String combiNumber, String elementNumber, String periodNumber, String currencyNumber, BOSUuid orgUnitId, BOSUuid schemeId) throws BOSException, EASBizException {
        IBgElement iBgE = BgElementFactory.getLocalInstance(ctx);
        BgElementInfo elementInfo = iBgE.getBgElementInfo("select * where number = '" + elementNumber + "'");
        String itemFormula = "=BgItem(\"" + combiNumber + "\",\"" + periodNumber + "\",\"" + elementNumber + "\",\"" + elementInfo.getType().getName() + "\"," + elementInfo.isIsApportionable() + ",\"" + currencyNumber + "\")";
        return this._updateBalanceByFormula(ctx, newBalance, itemFormula, orgUnitId, schemeId);
    }

    @Override
    protected void _checkBudget(Context ctx) throws BOSException {
    }

    @Override
    protected IObjectCollection _getBudget(Context ctx, String boName, IObjectCollection paramColl, IObjectValue info) throws BOSException, EASBizException {
        BgCtrlResultCollection ctrlResultCol;
        block2: {
            IBudgetCtrlFacade iBudgetCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
            ctrlResultCol = new BgCtrlResultCollection();
            try {
                ctrlResultCol = iBudgetCtrl.getBudget(info);
            }
            catch (Exception ex) {
                BgCtrlException _ex;
                logger.error((Object)"budget error:", (Throwable)ex);
                logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"6_BgControlFacadeControllerBean", (Locale)ctx.getLocale()) + ex.getMessage()));
                if (!(ex instanceof BgCtrlException) || !(_ex = (BgCtrlException)((Object)ex)).getSubCode().equals(BgCtrlException.BILLNOTSTORE.getCode())) break block2;
                throw _ex;
            }
        }
        return ctrlResultCol;
    }

    @Override
    protected IObjectCollection _getBudget(Context ctx, String boName, IObjectCollection paramColl) throws BOSException, EASBizException {
        return this.getBgCtrlResultColl(ctx, boName, paramColl, false);
    }

    @Override
    protected IObjectCollection _requestBudget(Context ctx, String boId, String boName, String handlerName) throws BOSException, EASBizException {
        boolean isNewRule = this.isNewRule(ctx, boName);
        BgCtrlResultCollection bgCtrRstColl = new BgCtrlResultCollection();
        if (handlerName == null) {
            INewBgControlFacade iNewCtrl = NewBgControlFacadeFactory.getLocalInstance(ctx);
            bgCtrRstColl = iNewCtrl.requestBudget(boId, boName);
        } else if (isNewRule) {
            INewBgControlFacade iNewCtrl = NewBgControlFacadeFactory.getLocalInstance(ctx);
            bgCtrRstColl = iNewCtrl.requestBudget(boId, boName);
        } else {
            BgCtrlParamCollection bgCtrlParamColl = BgCtrlHandlerFactory.createHandler(handlerName).getParameters(ctx, boId);
            bgCtrRstColl = (BgCtrlResultCollection)this._requestBudget(ctx, boId, boName, (IObjectCollection)bgCtrlParamColl);
            this.dealUpperLevel(ctx, boId, boName, bgCtrRstColl, bgCtrlParamColl, true);
        }
        return bgCtrRstColl;
    }

    private void dealUpperLevel(Context ctx, String boId, String boName, BgCtrlResultCollection bgCtrRstColl, BgCtrlParamCollection bgCtrlParamColl, boolean isRequestBudget) throws BOSException, EASBizException {
        StringBuffer strBuff = new StringBuffer(" select ctrlScheme.FIsFindUpperOrg, ctrlScheme.FFindUpperOrgMaxLevel  from t_bg_bgControlScheme ctrlScheme  where ctrlScheme.FBoName = ? and ctrlScheme.FIsValid = 1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuff.toString(), (Object[])new String[]{boName});
        boolean isFindUpperOrg = false;
        int maxLevel = -1;
        try {
            if (rs.next()) {
                isFindUpperOrg = rs.getBoolean(1);
                maxLevel = rs.getInt(2);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> orgUnitMap = new HashMap<String, Object>();
        for (int i = 0; bgCtrlParamColl != null && !bgCtrlParamColl.isEmpty() && i < bgCtrlParamColl.size(); ++i) {
            if (bgCtrlParamColl.get(i).getOrgUnitId() == null) continue;
            orgUnitMap.put(bgCtrlParamColl.get(i).getOrgUnitId(), null);
        }
        if (isFindUpperOrg) {
            Map orgUnitParentMap = BgCtrlHelper.getParentOrgUnitMap(ctx, orgUnitMap, isFindUpperOrg, maxLevel);
            this.requestUpperOrgBudget(ctx, boId, boName, bgCtrRstColl, bgCtrlParamColl, orgUnitParentMap, isRequestBudget);
        }
    }

    private void requestUpperOrgBudget(Context ctx, String boId, String boName, BgCtrlResultCollection bgCtrRstColl, BgCtrlParamCollection bgCtrlParamColl, Map orgUnitParentMap, boolean isRequestBudget) throws BOSException, EASBizException {
        int i;
        BgCtrlResultCollection subCtrlRstColl = new BgCtrlResultCollection();
        BgCtrlParamCollection subCtrlParamColl = new BgCtrlParamCollection();
        for (i = bgCtrRstColl.size() - 1; i >= 0; --i) {
            BgCtrlParamInfo newCtrlParamInfo;
            if (bgCtrRstColl.get(i).getBalance() != null || !orgUnitParentMap.containsKey((newCtrlParamInfo = (BgCtrlParamInfo)bgCtrlParamColl.get(i).clone()).getOrgUnitId())) continue;
            newCtrlParamInfo.setOrgUnitId((String)orgUnitParentMap.get(newCtrlParamInfo.getOrgUnitId()));
            newCtrlParamInfo.put("index", new Integer(i));
            subCtrlParamColl.add(newCtrlParamInfo);
        }
        if (subCtrlParamColl != null && subCtrlParamColl.size() > 0) {
            subCtrlRstColl = isRequestBudget ? (BgCtrlResultCollection)this._requestBudget(ctx, boId, boName, (IObjectCollection)subCtrlParamColl) : this.getBgCtrlResultColl(ctx, boName, (IObjectCollection)subCtrlParamColl, false);
            for (i = 0; subCtrlRstColl != null && !subCtrlRstColl.isEmpty() && i < subCtrlRstColl.size(); ++i) {
                if (subCtrlRstColl.get(i).getBalance() != null) {
                    bgCtrRstColl.set((Integer)subCtrlParamColl.get(i).get("index"), (BgCtrlResultInfo)subCtrlRstColl.get(i).clone());
                }
                bgCtrlParamColl.set((Integer)subCtrlParamColl.get(i).get("index"), (BgCtrlParamInfo)subCtrlParamColl.get(i).clone());
            }
            for (i = bgCtrRstColl.size() - 1; i >= 0; --i) {
                if (bgCtrRstColl.get(i).getBalance() != null) continue;
                this.requestUpperOrgBudget(ctx, boId, boName, bgCtrRstColl, bgCtrlParamColl, orgUnitParentMap, isRequestBudget);
                break;
            }
        }
    }

    @Override
    protected IObjectCollection _requestBudget(Context ctx, String boId, String boName, IObjectCollection paramColl) throws BOSException, EASBizException {
        IBudgetCtrlFacade iBudgetCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
        iBudgetCtrl.requestBudgetLocal(BOSUuid.read((String)boId));
        return null;
    }

    private void writeCtrlRecord(Context ctx, IObjectCollection paramColl, BgCtrlResultCollection bgCtrlResultColl) throws BOSException, EASBizException {
        IBgCtrlRecord iBgCtrRecord = BgCtrlRecordFactory.getLocalInstance(ctx);
        iBgCtrRecord.record(bgCtrlResultColl);
        this.updateSuperItemActualAndCtrlRecord(ctx, (BgCtrlParamCollection)paramColl, bgCtrlResultColl);
    }

    private BgCtrlResultCollection getBgCtrlResultColl(Context ctx, String boId, String boName, IObjectCollection paramColl, boolean isSubmit) throws BOSException, EASBizException {
        BgCtrlParamCollection bgCtrlParamColl = this.getFullParamColl(ctx, boName, paramColl);
        if (isSubmit) {
            this._addActualAmount(ctx, (IObjectCollection)bgCtrlParamColl, true);
        }
        BgCtrlResultCollection resultColl = new BgCtrlResultCollection();
        if (bgCtrlParamColl != null && bgCtrlParamColl.size() > 0) {
            for (int i = 0; i < bgCtrlParamColl.size(); ++i) {
                BgCtrlParamInfo paramInfo = bgCtrlParamColl.get(i);
                resultColl.addCollection(this.getBgCtrlRstColl(ctx, paramInfo, isSubmit));
            }
        }
        return resultColl;
    }

    private BgCtrlResultCollection getBgCtrlResultColl(Context ctx, String boName, IObjectCollection paramColl, boolean isSubmit) throws BOSException, EASBizException {
        BgCtrlParamCollection bgCtrlParamColl = this.getFullParamColl(ctx, boName, paramColl);
        BgCtrlResultCollection resultColl = new BgCtrlResultCollection();
        if (bgCtrlParamColl != null && bgCtrlParamColl.size() > 0) {
            for (int i = 0; i < bgCtrlParamColl.size(); ++i) {
                BgCtrlParamInfo paramInfo = bgCtrlParamColl.get(i);
                resultColl.addCollection(this.getBgCtrlRstColl(ctx, paramInfo, isSubmit));
            }
        }
        return resultColl;
    }

    private BgCtrlResultCollection getBgCtrlRstColl(Context ctx, BgCtrlParamInfo paramInfo, boolean isSubmit) throws BOSException, EASBizException {
        BgCtrlResultCollection resultColl = new BgCtrlResultCollection();
        String itemFormula1 = "=BgItem(\"" + paramInfo.getItemCombinNumber() + "\",\"" + paramInfo.getPeriodNumber() + "\",\"" + paramInfo.getElementNumber() + "\",\"BgData\",true,\"" + paramInfo.getCurrencyNumber() + "\")";
        BgCtrlResultInfo info = this.getBgCtrlRstInfo(ctx, paramInfo.getOrgUnitId(), itemFormula1, paramInfo, isSubmit);
        resultColl.add(info);
        return resultColl;
    }

    private BgCtrlResultInfo getBgCtrlRstInfo(Context ctx, String orgUnitId, String itemFormula, BgCtrlParamInfo bgCtrlParamInfo, boolean isSubmit) throws BOSException, EASBizException {
        BgCtrlResultInfo resultInfo = new BgCtrlResultInfo();
        resultInfo.setBgItemFormula(itemFormula);
        resultInfo.setOrgUnitId(bgCtrlParamInfo.getOrgUnitId());
        resultInfo.setReqAmount(bgCtrlParamInfo.getAmount());
        resultInfo.setBillId(bgCtrlParamInfo.getSrcBillId());
        resultInfo.setBillNumber(bgCtrlParamInfo.getSrcBillNumber());
        resultInfo.setBizDate(bgCtrlParamInfo.getBizDate());
        resultInfo.setBillType(bgCtrlParamInfo.getBillType());
        resultInfo.setBgPeriodNumber(bgCtrlParamInfo.getPeriodNumber());
        resultInfo.setItemName(bgCtrlParamInfo.getItemCombinName());
        resultInfo.setBillItemName(bgCtrlParamInfo.getBillItemName() == null || bgCtrlParamInfo.getBillItemName().trim().length() == 0 ? bgCtrlParamInfo.getItemCombinName() : bgCtrlParamInfo.getBillItemName());
        resultInfo.setIsBalanced(true);
        this.setBgCtrlResult(ctx, bgCtrlParamInfo.getOrgUnitId(), itemFormula, bgCtrlParamInfo, resultInfo, isSubmit, null, null, BgGetPeriodTypeForGetBlanceEnum.Is_Control);
        return resultInfo;
    }

    private BgCtrlParamCollection getFullParamColl(Context ctx, String boName, IObjectCollection paramColl) throws BOSException, EASBizException {
        BgCtrlParamCollection bgCtrlParamColl = new BgCtrlParamCollection();
        if (paramColl != null && paramColl.size() > 0) {
            BgCtrlParamInfo tmpParamInfo = (BgCtrlParamInfo)paramColl.getObject(0);
            if (tmpParamInfo.getPeriodNumber() == null || tmpParamInfo.getElementNumber() == null) {
                StringBuffer strBuff = new StringBuffer(" select BGCONTROLRULE.FPeriodCycle, BGCONTROLRULE.FElementNumber,  CtrlScheme.fisAllowAccess, CtrlScheme.fboAlias  from t_bg_bgcontrolrule BGCONTROLRULE ,t_bg_bgControlScheme CtrlScheme ,t_bg_bgelement BGELEMENT ");
                strBuff.append(" where BGCONTROLRULE.FBgCtrlSchemeID = CtrlScheme.FID and  CtrlScheme.FBoName = '" + boName + "' and CtrlScheme.FIsValid = 1 and  BGELEMENT.FNumber=BGCONTROLRULE.FElementNumber ");
                IRowSet bgCtrlRules = DbUtil.executeQuery((Context)ctx, (String)strBuff.toString());
                try {
                    while (bgCtrlRules.next()) {
                        String elementNumber = bgCtrlRules.getString("FElementNumber");
                        BgPeriodCollection bgPeriodColl = null;
                        int periodType = bgCtrlRules.getInt("FPeriodCycle");
                        try {
                            bgPeriodColl = BgHelper.getBgPeriodCollOnDate(ctx, periodType, tmpParamInfo.getBizDate());
                        }
                        catch (Exception e) {
                            throw new BgPeriodException(BgPeriodException.NOEXIST);
                        }
                        BgPeriodInfo bgPeriodInfo = null;
                        if (bgPeriodColl != null && bgPeriodColl.size() > 0) {
                            bgPeriodInfo = bgPeriodColl.get(0);
                        }
                        if (bgPeriodInfo == null) {
                            throw new BgPeriodException(BgPeriodException.NOEXIST);
                        }
                        boolean isAllowExcess = bgCtrlRules.getBoolean(3);
                        String billType = bgCtrlRules.getString(4);
                        for (int i = 0; i < paramColl.size(); ++i) {
                            BgCtrlParamInfo paramInfo = (BgCtrlParamInfo)paramColl.getObject(i);
                            paramInfo.setElementNumber(elementNumber);
                            paramInfo.setPeriodId(bgPeriodInfo.getId().toString());
                            paramInfo.setPeriodNumber(bgPeriodInfo.getNumber());
                            paramInfo.setPeriodType(BgPeriodEnum.getEnum(periodType));
                            paramInfo.setBillType(billType);
                            bgCtrlParamColl.add(paramInfo);
                        }
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                }
            } else {
                for (int i = 0; i < paramColl.size(); ++i) {
                    BgCtrlParamInfo paramInfo = (BgCtrlParamInfo)paramColl.getObject(i);
                    bgCtrlParamColl.add(paramInfo);
                }
            }
            IBgFormulaFacade iBgF = BgFormulaFacadeFactory.getLocalInstance(ctx);
            for (int i = 0; i < bgCtrlParamColl.size(); ++i) {
                String itemCombinNumber = bgCtrlParamColl.get(i).getItemCombinNumber();
                String orgUnitId = bgCtrlParamColl.get(i).getOrgUnitId();
                itemCombinNumber = iBgF.parseBgItemCombi_ctrl(itemCombinNumber, orgUnitId);
                bgCtrlParamColl.get(i).setItemCombinNumber(itemCombinNumber);
                bgCtrlParamColl.get(i).setItemCombinName(this.getItemCombinName(ctx, itemCombinNumber.replaceAll(",", "_"), orgUnitId));
            }
        }
        return bgCtrlParamColl;
    }

    private String getItemCombinName(Context ctx, String itemKey, String orgUnitId) throws BOSException {
        String sql = " select fname_" + ctx.getLocale() + " from t_bg_bgitem where fnumber = ? and forgunitid = ?";
        String[] strs = itemKey.split("_");
        String nameStr = "";
        try {
            for (int i = 0; i < strs.length; ++i) {
                String name = "";
                String number = strs[i];
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{number, BgSHelper.getIsolateOrg(ctx, orgUnitId)});
                if (rs.next()) {
                    name = rs.getString(1);
                }
                SQLUtils.cleanup((ResultSet)rs);
                nameStr = nameStr + name + "_";
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        nameStr = nameStr.substring(0, nameStr.length() - 1);
        return nameStr;
    }

    /*
     * Unable to fully structure code
     */
    private void setBgCtrlResult(Context ctx, String orgUnitId, String itemFormula, BgCtrlParamInfo bgCtrlParamInfo, BgCtrlResultInfo resultInfo, boolean isSubmit, BgPeriodEnum periodTypeEnum, String bgshcmeid, BgGetPeriodTypeForGetBlanceEnum getPeriodTypeForGetBlance) throws BOSException, EASBizException {
        block54: {
            block55: {
                helper = new BgControlPeriodCacheHelper();
                conn = this.getConnection(ctx);
                statement = null;
                rs = null;
                strBuff = new StringBuffer(200);
                strBuff.append(" select BGDATA.* from t_bg_bgdata BGDATA ,t_bg_bgscheme BGSCHEME ,t_bg_bgform BGFORM ");
                if (getPeriodTypeForGetBlance.getValue() == 0) {
                    strBuff.append(" where BGSCHEME.FID=BGDATA.FBgSchemeId and BGFORM.FID=BGDATA.FBgFormId and BGSCHEME.FIsFormal=1 and BGFORM.FState = 2 and BGDATA.fformula=? and BGDATA.forgunitid=? and BGDATA.FBgPeriodId = ?");
                } else {
                    strBuff.append(" where BGSCHEME.FID=BGDATA.FBgSchemeId and BGFORM.FID=BGDATA.FBgFormId and BGSCHEME.Fid='" + bgshcmeid + "' and BGFORM.FState = " + 2 + " and BGDATA.fformula=? and BGDATA.forgunitid=? and BGDATA.FBgPeriodId = ?");
                }
                currencyNumber = bgCtrlParamInfo.getCurrencyNumber() == null ? "" : bgCtrlParamInfo.getCurrencyNumber();
                rsCurrency = DbUtil.executeQuery((Context)ctx, (String)"select fid from t_bd_currency where fnumber = ?", (Object[])new String[]{currencyNumber});
                currencyId = null;
                if (rsCurrency.next()) {
                    currencyId = rsCurrency.getString(1);
                }
                elementNumber = bgCtrlParamInfo.getElementNumber() == null ? "" : bgCtrlParamInfo.getElementNumber();
                rsCurrency = DbUtil.executeQuery((Context)ctx, (String)"select fid from t_bg_bgelement where fnumber = ? ", (Object[])new String[]{elementNumber});
                elementId = null;
                if (rsCurrency.next()) {
                    elementId = rsCurrency.getString(1);
                }
                statement = conn.prepareStatement(strBuff.toString());
                statement.setString(2, orgUnitId);
                statement.setString(1, itemFormula);
                statement.setString(3, bgCtrlParamInfo.getPeriodId());
                rs = statement.executeQuery();
                curPeriodBgDataId = null;
                bgSchemeId = null;
                curPeriodBgDataIsControl = false;
                curPeriodBgDataIsGrpCtrl = false;
                curPeriodBgDataGrpNo = null;
                curPeriodBgDataBgValue = null;
                curPeriodBgDataBgActual = null;
                curPeriodBgDataIsFlexible = false;
                curPeriodBgDataFlexibleParam = null;
                curPeriodBgDataCtrlType = 10;
                if (rs.next()) {
                    curPeriodBgDataId = rs.getString("FID");
                    bgSchemeId = rs.getString("FBgSchemeId");
                    curPeriodBgDataIsControl = rs.getBoolean("FIsControl");
                    curPeriodBgDataIsGrpCtrl = rs.getBoolean("FIsGroupCtrl");
                    if (curPeriodBgDataIsGrpCtrl) {
                        curPeriodBgDataGrpNo = rs.getString("FGroupNo");
                    }
                    curPeriodBgDataCtrlType = rs.getInt("FCtrlType");
                    curPeriodBgDataBgValue = rs.getBigDecimal("FBgValue");
                    curPeriodBgDataBgActual = rs.getBigDecimal("FBizActual");
                    curPeriodBgDataIsFlexible = rs.getBoolean("FIsFlexible");
                    if (curPeriodBgDataIsFlexible) {
                        curPeriodBgDataFlexibleParam = rs.getBigDecimal("FFlexParam");
                    }
                } else if (getPeriodTypeForGetBlance.getValue() == 30) {
                    throw new BgFormulaException(BgFormulaException.NO_FIND_CTRLSET_OF_ITEMFORMULA);
                }
                bgCtrlParamInfo.setBgSchemeId(bgSchemeId);
                if (curPeriodBgDataId == null) ** GOTO lbl235
                resultInfo.setBgDataId(curPeriodBgDataId);
                resultInfo.setBgSchemeId(bgSchemeId);
                bgCtrlParamInfo.setCtrlType(BgCtrlTypeEnum.getEnum(curPeriodBgDataCtrlType));
                if (!curPeriodBgDataIsControl || !curPeriodBgDataIsGrpCtrl && curPeriodBgDataCtrlType == 10) {
                    if (curPeriodBgDataIsFlexible) {
                        curPeriodBgDataBgValue = curPeriodBgDataBgValue.multiply(curPeriodBgDataFlexibleParam);
                    }
                    if (isSubmit) {
                        resultInfo.setBalance(curPeriodBgDataBgValue.subtract(curPeriodBgDataBgActual));
                    } else {
                        resultInfo.setBalance(curPeriodBgDataBgValue.subtract(curPeriodBgDataBgActual));
                    }
                    if (!curPeriodBgDataIsControl) {
                        resultInfo.setIsBalanced(true);
                    } else if (resultInfo.getBalance().signum() == -1) {
                        resultInfo.setIsBalanced(false);
                    }
                    break block54;
                }
                periodIdListValue = null;
                periodIdListValue = curPeriodBgDataCtrlType == 20 ? helper.getThisYearCtrlPeriodIdList(ctx, bgCtrlParamInfo, curPeriodBgDataCtrlType, periodTypeEnum, true) : helper.getAllPeriodIdList(ctx, bgCtrlParamInfo, bgSchemeId, curPeriodBgDataCtrlType, periodTypeEnum, false, false);
                periodIdListActual = null;
                periodIdListActual = getPeriodTypeForGetBlance.getValue() == 20 ? helper.getAllPeriodIdList(ctx, bgCtrlParamInfo, bgSchemeId, curPeriodBgDataCtrlType, periodTypeEnum, false, true) : (curPeriodBgDataCtrlType == 20 ? helper.getThisYearCtrlPeriodIdList(ctx, bgCtrlParamInfo, curPeriodBgDataCtrlType, periodTypeEnum, false) : helper.getAllPeriodIdList(ctx, bgCtrlParamInfo, bgSchemeId, curPeriodBgDataCtrlType, periodTypeEnum, true, true));
                list = new ArrayList<E>();
                try {
                    list = TableToolkit.parseFormula((String)itemFormula, (boolean)false);
                }
                catch (com.kingdee.bos.kscript.ParserException e1) {
                    SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
                    helper.clear();
                    return;
                }
                if (list != null && !list.isEmpty()) break block55;
                SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
                helper.clear();
                return;
            }
            try {
                hint = (FormulaHint)list.get(0);
                params = hint.getParams();
                combinId = "";
                sqlCombinId = "select fid from T_BG_BgItemCombination where fkey = ? ";
                rsCombin = DbUtil.executeQuery((Context)ctx, (String)sqlCombinId, (Object[])new String[]{params[0].replaceAll(",", "_")});
                if (rsCombin.next()) {
                    combinId = rsCombin.getString(1);
                }
                totalBgValue = new BigDecimal("0.00");
                totalBizActual = new BigDecimal("0.00");
                zero = new BigDecimal("0.00");
                if (curPeriodBgDataCtrlType == 12) {
                    if (!curPeriodBgDataIsGrpCtrl) {
                        sql = "select  sum( a.fbgvalue * (case a.FIsFlexible when 1 then a.fflexparam else 1 end ))  from t_bg_bgdata a ,t_bg_bgform b  where a.fbgformid=b.fid and b.fstate = 2 and a.forgunitid = ? and a.fbgschemeid = ? and a.fbgitemcombinid = ? ";
                        count = periodIdListValue.size();
                        for (i = 0; i < count; ++i) {
                            sql = i == 0 ? sql + " and (" : sql + " or";
                            sql = sql + " a.FBgPeriodId = '";
                            sql = sql + (String)periodIdListValue.get(i);
                            sql = sql + "'";
                            if (i != count - 1) continue;
                            sql = sql + " )";
                        }
                        rs1 = DbUtil.executeQuery((Context)ctx, (String)(sql = sql + " and a.fcurrencyid = ? and a.fbgelementid = ? "), (Object[])new Object[]{orgUnitId, bgSchemeId, combinId, currencyId, elementId});
                        if (rs1.next()) {
                            totalBgValue = rs1.getBigDecimal(1) == null ? zero : rs1.getBigDecimal(1);
                        }
                    } else {
                        sql = "select sum( a.fbgvalue * (case a.FIsFlexible when 1 then a.fflexparam else 1 end ))   from t_bg_bgdata a ,t_bg_bgform b  where a.fbgformid=b.fid and b.fstate = 2 and a.forgunitid = ? and a.fbgschemeid = ?  and a.FGroupNo = ? ";
                        count = periodIdListValue.size();
                        for (i = 0; i < count; ++i) {
                            sql = i == 0 ? sql + " and (" : sql + " or";
                            sql = sql + " a.FBgPeriodId = '";
                            sql = sql + (String)periodIdListValue.get(i);
                            sql = sql + "'";
                            if (i != count - 1) continue;
                            sql = sql + " )";
                        }
                        rs1 = DbUtil.executeQuery((Context)ctx, (String)(sql = sql + " and a.fcurrencyid = ? and a.fbgelementid = ?"), (Object[])new Object[]{orgUnitId, bgSchemeId, curPeriodBgDataGrpNo, currencyId, elementId});
                        if (rs1.next()) {
                            totalBgValue = rs1.getBigDecimal(1);
                        }
                    }
                }
                sqlToGetAllBgData = new StringBuffer("SELECT a.FBgValue, a.FIsFlexible, a.FFlexParam  from t_bg_bgdata a ,t_bg_bgform b  where a.fbgformid=b.fid and b.fstate = 2 and a.forgunitid = '" + orgUnitId + "' and a.fbgschemeid='" + bgSchemeId + "' ");
                sqlToGetAllBgData.append(" and (");
                if (curPeriodBgDataCtrlType == 12) {
                    sqlToGetAllBgData.append(" a.FBgPeriodId = '");
                    sqlToGetAllBgData.append(bgCtrlParamInfo.getPeriodId());
                    sqlToGetAllBgData.append("'");
                } else {
                    count = periodIdListValue.size();
                    for (i = 0; i < count; ++i) {
                        if (i > 0) {
                            sqlToGetAllBgData.append(" or");
                        }
                        sqlToGetAllBgData.append(" a.FBgPeriodId = '");
                        sqlToGetAllBgData.append((String)periodIdListValue.get(i));
                        sqlToGetAllBgData.append("'");
                    }
                }
                sqlToGetAllBgData.append(" )");
                sqlToGetAllBgData.append(" and");
                if (curPeriodBgDataIsGrpCtrl) {
                    sqlToGetAllBgData.append(" a.FGroupNo = '");
                    sqlToGetAllBgData.append(curPeriodBgDataGrpNo);
                    sqlToGetAllBgData.append("'");
                } else {
                    iP = BgPeriodFactory.getLocalInstance(ctx);
                    count = periodIdListValue.size();
                    for (i = 0; i < count; ++i) {
                        periodInfo = iP.getBgPeriodInfo((IObjectPK)new ObjectUuidPK((String)periodIdListValue.get(i)));
                        _itemFormula = "=BgItem(\"" + params[0] + "\",\"" + periodInfo.getNumber() + "\",\"" + params[2] + "\",\"" + params[3] + "\",true,\"" + params[5] + "\")";
                        if (i == 0) {
                            sqlToGetAllBgData.append(" ( ");
                        } else {
                            sqlToGetAllBgData.append(" or");
                        }
                        sqlToGetAllBgData.append(" a.fformula = '");
                        sqlToGetAllBgData.append(_itemFormula);
                        sqlToGetAllBgData.append("'");
                        if (i != count - 1) continue;
                        sqlToGetAllBgData.append(" ) ");
                    }
                }
                rsToGetAllBgData = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAllBgData.toString());
                bgValueCount = new BigDecimal("0");
                if (curPeriodBgDataCtrlType == 12) {
                    bgValueCount = bgValueCount.add(totalBgValue);
                } else {
                    while (rsToGetAllBgData.next()) {
                        bgValue = rsToGetAllBgData.getBigDecimal("FBgValue");
                        if (rsToGetAllBgData.getBoolean("FIsFlexible")) {
                            flexibleParam = rsToGetAllBgData.getBigDecimal("FFlexParam");
                            bgValue = bgValue.multiply(flexibleParam);
                        }
                        bgValueCount = bgValueCount.add(bgValue);
                    }
                }
                if (!curPeriodBgDataIsGrpCtrl) {
                    sql = "select  sum(a.fbizactual)  from t_bg_bgdata a ,t_bg_bgform b  where a.fbgformid=b.fid and b.fstate = 2 and a.forgunitid = ? and a.fbgschemeid = ? and a.fbgitemcombinid = ? ";
                    count = periodIdListActual.size();
                    for (i = 0; i < count; ++i) {
                        sql = i == 0 ? sql + " and (" : sql + " or";
                        sql = sql + " a.FBgPeriodId = '";
                        sql = sql + (String)periodIdListActual.get(i);
                        sql = sql + "'";
                        if (i != count - 1) continue;
                        sql = sql + " )";
                    }
                    rs1 = DbUtil.executeQuery((Context)ctx, (String)(sql = sql + " and a.fcurrencyid = ? and a.fbgelementid = ? "), (Object[])new Object[]{orgUnitId, bgSchemeId, combinId, currencyId, elementId});
                    if (rs1.next()) {
                        totalBizActual = rs1.getBigDecimal(1) == null ? zero : rs1.getBigDecimal(1);
                    }
                } else {
                    sql = "select sum(a.fbizactual)  from t_bg_bgdata a ,t_bg_bgform b  where a.fbgformid=b.fid and b.fstate = 2 and a.forgunitid = ? and a.fbgschemeid = ?  and a.FGroupNo = ? ";
                    count = periodIdListActual.size();
                    for (i = 0; i < count; ++i) {
                        sql = i == 0 ? sql + " and (" : sql + " or";
                        sql = sql + " a.FBgPeriodId = '";
                        sql = sql + (String)periodIdListActual.get(i);
                        sql = sql + "'";
                        if (i != count - 1) continue;
                        sql = sql + " )";
                    }
                    rs1 = DbUtil.executeQuery((Context)ctx, (String)(sql = sql + " and a.fcurrencyid = ? and a.fbgelementid = ? "), (Object[])new Object[]{orgUnitId, bgSchemeId, curPeriodBgDataGrpNo, currencyId, elementId});
                    if (rs1.next()) {
                        totalBizActual = rs1.getBigDecimal(1);
                    }
                }
                if (isSubmit) {
                    resultInfo.setBalance(bgValueCount.subtract(totalBizActual));
                } else {
                    resultInfo.setBalance(bgValueCount.subtract(totalBizActual));
                }
                if (resultInfo.getBalance().signum() < 0) {
                    resultInfo.setIsBalanced(false);
                }
                break block54;
lbl235:
                // 1 sources

                resultInfo.setBalance(null);
                bgCtrlParamInfo.setCtrlType(BgCtrlTypeEnum.NoCtrl);
            }
            catch (SQLException e) {
                try {
                    BgControlFacadeControllerBean.logger.debug((Object)e.getMessage());
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable var47_64) {
                    SQLUtils.cleanup(rs, statement, (Connection)conn);
                    helper.clear();
                    throw var47_64;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        helper.clear();
    }

    @Override
    protected void _specialApprove(Context ctx, String boId, String boName, IObjectCollection resultColl) throws BOSException, EASBizException {
    }

    @Override
    protected void _cancelRequestBudget(Context ctx, String boId) throws BOSException, EASBizException {
        IBudgetCtrlFacade iBudgetCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
        iBudgetCtrl.returnBudgetLocal(BOSUuid.read((String)boId));
    }

    @Override
    protected boolean _bgAuditWF(Context ctx, BOSUuid boId, String boName, String handleName) throws BOSException, BgCtrlException, EASBizException {
        IBudgetCtrlFacade iBudgetCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
        return iBudgetCtrl.requestBudgetWF(boId);
    }

    @Override
    protected boolean _getIsCanControlWithoutBudget(Context ctx, String boName) throws BOSException, EASBizException {
        throw new BgException(BgException.ILLEGALARGUMENT, new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"7_BgControlFacadeControllerBean", (Locale)ctx.getLocale())});
    }

    @Override
    protected boolean _bgAudit(Context ctx, String boId, String boName, String handleName) throws BOSException, EASBizException {
        IBudgetCtrlFacade iBudgetCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
        return iBudgetCtrl.requestBudgetLocal(BOSUuid.read((String)boId));
    }

    @Override
    protected void _updateUpperOrgActual(Context ctx, IObjectCollection ctrlReColl) throws EASBizException, BOSException {
        BgCtrlResultCollection ctrlColl = (BgCtrlResultCollection)ctrlReColl;
        Map<String, Object> orgUnitMap = new HashMap();
        HashMap<String, String> schemeMap = new HashMap<String, String>();
        for (int i = 0; i < ctrlColl.size(); ++i) {
            if (ctrlColl.get(i).getBgSchemeId() == null || ctrlColl.get(i).getBalance() == null) continue;
            schemeMap.put(ctrlColl.get(i).getOrgUnitId(), ctrlColl.get(i).getBgSchemeId());
            orgUnitMap.put(ctrlColl.get(i).getOrgUnitId(), null);
        }
        orgUnitMap = BgCtrlHelper.getParentOrgUnitMap(ctx, orgUnitMap, true, 100);
        String str = "(''";
        for (Object key : orgUnitMap.keySet()) {
            str = str + ",'" + orgUnitMap.get(key) + "'";
        }
        str = str + ")";
        String sql = "select forgunitid ,fid from t_bg_bgscheme where forgunitid in " + str + " and  frootid = (select frootid from t_bg_bgscheme where fid = ? ) and fid != ?";
        HashMap upperOrgSchemeMap = new HashMap();
        for (int i = 0; i < ctrlColl.size(); ++i) {
            if (ctrlColl.get(i).getBgSchemeId() == null || ctrlColl.get(i).getBalance() == null) continue;
            String orgUnitId = ctrlColl.get(i).getOrgUnitId();
            String schemeId = (String)schemeMap.get(orgUnitId);
            if (upperOrgSchemeMap.containsKey(orgUnitId)) continue;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{schemeId, schemeId});
            HashMap<String, String> tmp1 = new HashMap<String, String>();
            try {
                while (rs.next()) {
                    if (!this.isUpper(orgUnitMap, orgUnitId, rs.getString(1))) continue;
                    tmp1.put(rs.getString(1), rs.getString(2));
                }
                upperOrgSchemeMap.put(orgUnitId, tmp1);
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        String updateSql = "update t_bg_bgdata set fbizactual = fbizactual + ?  where fformula = ? and forgunitid = ? and fbgschemeid = ? ";
        PreparedStatement ps = null;
        PreparedStatement ps1 = null;
        Connection connection = null;
        PreparedStatement insertDetailRecordSta = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(updateSql);
            boolean isSubmit = false;
            for (int i = 0; i < ctrlColl.size(); ++i) {
                if (ctrlColl.get(i).getBgSchemeId() == null || ctrlColl.get(i).getBalance() == null) continue;
                BigDecimal actualValue = ctrlColl.get(i).getReqAmount();
                String formula = ctrlColl.get(i).getBgItemFormula();
                String orgUnitId = ctrlColl.get(i).getOrgUnitId();
                Map tmp1 = (Map)upperOrgSchemeMap.get(orgUnitId);
                if (tmp1 == null || tmp1.isEmpty()) continue;
                for (String orgId : tmp1.keySet()) {
                    String schemeId = (String)tmp1.get(orgId);
                    ps.setBigDecimal(1, actualValue);
                    ps.setString(2, formula);
                    ps.setString(3, orgId);
                    ps.setString(4, schemeId);
                    ps.addBatch();
                    if (isSubmit) continue;
                    isSubmit = true;
                }
            }
            if (isSubmit) {
                ps.executeBatch();
            }
            SQLUtils.cleanup((Statement)ps);
            String sql1 = " select fid from t_bg_bgctrlrecord where forgunitid = ? and fbgschemeid = ? and fitemformula = ? ";
            String insertSql = "insert into \tT_BG_BGCTRLRECORD (FID, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, \tFLASTUPDATETIME, FCONTROLUNITID, FBGDATAID, FBILLID, \tFBILLNAME, FBILLNUMBER, FBILLALIAS, FBILLTYPE, \tFBIZDATE, FACTUALAMOUNT, FBILLOPERATE, FBGPERIODID, FITEMNAME, FBgTraceType, FOrgUnitID, FBgSchemeID, fitemFormula)    values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            String updateSql1 = "update t_bg_bgctrlrecord set factualAmount = factualAmount + ?  where forgunitid = ? and fbgschemeid = ? and fitemformula = ? ";
            ps = connection.prepareStatement(updateSql1);
            ps1 = connection.prepareStatement(insertSql);
            String insertDetailRecordSQL = "INSERT INTO T_BG_BgCtrlRecordSumDetail (FID, FBillId, FBgCtrlRecordId, FActualAmount) VALUES (?, ?, ?, ?)";
            insertDetailRecordSta = connection.prepareStatement(insertDetailRecordSQL);
            isSubmit = false;
            boolean isSubmit1 = false;
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Timestamp time = new Timestamp(System.currentTimeMillis());
            String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            HashMap<String, String> bgDataMap = new HashMap<String, String>();
            HashMap<String, String> bgFormMap = new HashMap<String, String>();
            for (int i = 0; i < ctrlColl.size(); ++i) {
                if (ctrlColl.get(i).getBgSchemeId() == null || ctrlColl.get(i).getBalance() == null) continue;
                BigDecimal actualValue = ctrlColl.get(i).getReqAmount();
                String formula = ctrlColl.get(i).getBgItemFormula();
                String orgUnitId = ctrlColl.get(i).getOrgUnitId();
                String itemName = ctrlColl.get(i).getItemName();
                Map tmp1 = (Map)upperOrgSchemeMap.get(orgUnitId);
                if (tmp1 == null || tmp1.isEmpty()) continue;
                for (String orgId : tmp1.keySet()) {
                    String schemeId = (String)tmp1.get(orgId);
                    String bgCtrlRecordId = null;
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{orgId, schemeId, formula});
                    if (rs.next()) {
                        bgCtrlRecordId = rs.getString("fid");
                        ps.setBigDecimal(1, actualValue);
                        ps.setString(2, orgId);
                        ps.setString(3, schemeId);
                        ps.setString(4, formula);
                        ps.addBatch();
                        if (!isSubmit) {
                            isSubmit = true;
                        }
                    } else {
                        String id;
                        bgCtrlRecordId = id = BOSUuid.create((String)"FF6153C2").toString();
                        String bgFormId = null;
                        String bgDataId = null;
                        if (bgFormMap.containsKey(orgId + "_" + schemeId + "_" + formula)) {
                            bgFormId = (String)bgFormMap.get(orgId + "_" + schemeId + "_" + formula);
                            bgDataId = (String)bgDataMap.get(orgId + "_" + schemeId + "_" + formula);
                        } else {
                            rs = DbUtil.executeQuery((Context)ctx, (String)"select fbgformid ,fid from t_bg_bgdata  where forgunitid = ? and fbgschemeid = ? and fformula = ? ", (Object[])new String[]{orgId, schemeId, formula});
                            if (!rs.next()) continue;
                            bgFormId = rs.getString(1);
                            bgDataId = rs.getString(2);
                            bgFormMap.put(orgId + "_" + schemeId + "_" + formula, bgFormId);
                            bgDataMap.put(orgId + "_" + schemeId + "_" + formula, bgDataId);
                        }
                        ps1.setString(1, id);
                        ps1.setString(2, userId);
                        ps1.setTimestamp(3, time);
                        ps1.setString(4, userId);
                        ps1.setTimestamp(5, time);
                        ps1.setString(6, cuId);
                        ps1.setString(7, bgDataId);
                        ps1.setString(8, bgFormId);
                        ps1.setString(9, null);
                        ps1.setString(10, null);
                        ps1.setString(11, null);
                        ps1.setString(12, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"8_BgControlFacadeControllerBean", (Locale)ctx.getLocale()));
                        ps1.setTimestamp(13, time);
                        ps1.setBigDecimal(14, actualValue);
                        ps1.setString(15, null);
                        ps1.setString(16, ctrlColl.get(i).getBgPeriodNumber());
                        ps1.setString(17, itemName);
                        ps1.setInt(18, 4);
                        ps1.setString(19, orgId);
                        ps1.setString(20, schemeId);
                        ps1.setString(21, formula);
                        ps1.addBatch();
                        if (!isSubmit1) {
                            isSubmit1 = true;
                        }
                    }
                    String bgCtrlRecordDetailId = BOSUuid.create((String)"390384DA").toString();
                    insertDetailRecordSta.setString(1, bgCtrlRecordDetailId);
                    insertDetailRecordSta.setString(2, ctrlColl.get(i).getBillId());
                    insertDetailRecordSta.setString(3, bgCtrlRecordId);
                    insertDetailRecordSta.setBigDecimal(4, actualValue);
                    insertDetailRecordSta.addBatch();
                }
            }
            if (isSubmit) {
                ps.executeBatch();
            }
            if (isSubmit1) {
                ps1.executeBatch();
            }
            if (isSubmit || isSubmit1) {
                insertDetailRecordSta.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertDetailRecordSta);
                SQLUtils.cleanup(ps1);
                SQLUtils.cleanup((Statement)ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertDetailRecordSta);
        SQLUtils.cleanup((Statement)ps1);
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        this.updateUpperOrgUpperItemCtrlData(ctx, (IObjectCollection)ctrlColl, upperOrgSchemeMap);
    }

    private boolean isUpper(Map orgUnitMap, String orgUnitId, String parentOrgId) {
        if (!orgUnitMap.containsKey(orgUnitId)) {
            return false;
        }
        String _parentOrgId = (String)orgUnitMap.get(orgUnitId);
        if (_parentOrgId.equals(parentOrgId)) {
            return true;
        }
        return this.isUpper(orgUnitMap, _parentOrgId, parentOrgId);
    }

    private void updateUpperOrgUpperItemCtrlData(Context ctx, IObjectCollection ctrlResultCol, Map upperOrgSchemeMap) throws BOSException, EASBizException {
        if (ctrlResultCol == null || ctrlResultCol.size() == 0) {
            return;
        }
        IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
        BgCtrlResultCollection _ctrlResultCol = (BgCtrlResultCollection)ctrlResultCol;
        for (int i = 0; i < _ctrlResultCol.size(); ++i) {
            if (_ctrlResultCol.get(i).getBgSchemeId() == null || _ctrlResultCol.get(i).getBalance() == null) continue;
            BgCtrlResultInfo ctrlResultInfo = _ctrlResultCol.get(i);
            BigDecimal actualValue = ctrlResultInfo.getReqAmount();
            String formula = ctrlResultInfo.getBgItemFormula();
            String orgUnitId = ctrlResultInfo.getOrgUnitId();
            Map upperOrgMap = (Map)upperOrgSchemeMap.get(orgUnitId);
            if (upperOrgMap == null || upperOrgMap.isEmpty()) continue;
            for (String orgId : upperOrgMap.keySet()) {
                String schemeId = (String)upperOrgMap.get(orgId);
                iBgItem.updateBgItemSuperiorValue(BOSUuid.read((String)orgId), BOSUuid.read((String)schemeId), formula, actualValue);
                iBgItem.sumBgItemSuperiorCtrlRecord(BOSUuid.read((String)orgId), BOSUuid.read((String)schemeId), formula, ctrlResultInfo);
            }
        }
    }

    private boolean getCanAcross(Context ctx, BgCtrlResultCollection ctrlColl, boolean isCanControlWithoutBudget, boolean isWorkFlow) throws BgCtrlException {
        BgCtrlResultInfo info;
        int i;
        if (ctrlColl == null || ctrlColl.isEmpty()) {
            if (!isCanControlWithoutBudget) {
                String message = BgUtilsHelper.getBalanceAuditInfoFromCollection(ctrlColl, ctx, isCanControlWithoutBudget);
                if (!isWorkFlow) {
                    throw new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{message});
                }
                logger.error((Object)message);
                return false;
            }
            return true;
        }
        for (i = 0; i < ctrlColl.size(); ++i) {
            info = ctrlColl.get(i);
            if (!info.isIsBalanced() && info.getReqAmount().floatValue() > 0.0f) {
                String message = BgUtilsHelper.getBalanceAuditInfoFromCollection(ctrlColl, ctx, isCanControlWithoutBudget);
                if (!isWorkFlow) {
                    throw new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{message});
                }
                logger.error((Object)message);
                return false;
            }
            if (info.getBalance() != null || isCanControlWithoutBudget) continue;
            String message = BgUtilsHelper.getBalanceAuditInfoFromCollection(ctrlColl, ctx, isCanControlWithoutBudget);
            if (!isWorkFlow) {
                throw new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{message});
            }
            logger.error((Object)message);
            return false;
        }
        for (i = 0; i < ctrlColl.size(); ++i) {
            info = ctrlColl.get(i);
            if (info.getBalance() != null || isCanControlWithoutBudget) continue;
            String message = BgUtilsHelper.getBalanceAuditInfoFromCollection(ctrlColl, ctx, isCanControlWithoutBudget);
            if (!isWorkFlow) {
                throw new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{message});
            }
            logger.error((Object)message);
            return false;
        }
        return true;
    }

    @Override
    protected void _bgAuditAllowAccessWF(Context ctx, BOSUuid boId, String boName, String handlerName) throws BOSException, EASBizException {
        IBudgetCtrlFacade iBudgetCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
        iBudgetCtrl.specialApprove(boId);
    }

    @Override
    protected IObjectCollection _bgAuditAllowAccess(Context ctx, BOSUuid boId, String boName, String handlerName) throws BOSException, EASBizException {
        IBudgetCtrlFacade iBudgetCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
        iBudgetCtrl.requestBudgetLocal(boId);
        return null;
    }

    @Override
    protected void _addActualAmount(Context ctx, IObjectCollection ctrlParamColl, boolean isAdd) throws BOSException, EASBizException {
        BgCtrlParamCollection bgCtrlParamColl = (BgCtrlParamCollection)ctrlParamColl;
        StringBuffer strBuff = new StringBuffer(200);
        strBuff.append(" select BGDATA.fid ,BGDATA.fbgschemeid from t_bg_bgdata BGDATA ,t_bg_bgscheme BGSCHEME ,t_bg_bgform BGFORM ");
        strBuff.append(" where BGSCHEME.FID=BGDATA.FBgSchemeId and BGFORM.FID=BGDATA.FBgFormId and BGSCHEME.FIsFormal=1 and BGFORM.FState = 2 and BGDATA.fformula=? and BGDATA.forgunitid=? and BGDATA.FBgPeriodId = ?");
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update t_bg_bgdata set FBizActual = FBizActual + ? WHERE fid = ? ");
        IRowSet row = null;
        try {
            for (int i = 0; i < bgCtrlParamColl.size(); ++i) {
                BgCtrlParamInfo paramInfo = bgCtrlParamColl.get(i);
                String itemFormula = "=BgItem(\"" + paramInfo.getItemCombinNumber() + "\",\"" + paramInfo.getPeriodNumber() + "\",\"" + paramInfo.getElementNumber() + "\",\"BgData\",true,\"" + paramInfo.getCurrencyNumber() + "\")";
                String orgId = paramInfo.getOrgUnitId();
                String periodId = paramInfo.getPeriodId();
                row = DbUtil.executeQuery((Context)ctx, (String)strBuff.toString(), (Object[])new Object[]{itemFormula, orgId, periodId});
                if (!row.next()) continue;
                String bgDataId = row.getString(1);
                String bgSchemeId = row.getString(2);
                BigDecimal amount = null;
                amount = isAdd ? paramInfo.getAmount() : paramInfo.getAmount().multiply(new BigDecimal("-1"));
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{amount, bgDataId});
                paramInfo.setItemFormula(itemFormula);
                paramInfo.setBgSchemeId(bgSchemeId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(row, null, null);
        }
    }

    @Override
    protected void _returnBudgetWF(Context ctx, BOSUuid boId, String boName, String handlerName) throws BOSException, EASBizException {
        IBudgetCtrlFacade iBudgetCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
        iBudgetCtrl.returnBudget(boId);
    }

    @Override
    protected void _updateSuperItemActualAndCtrlRecord(Context ctx, IObjectCollection bgCtrlColl, IObjectCollection bgCtrRtColl) throws BOSException, EASBizException {
        BgCtrlParamCollection bgCtrlParamColl = (BgCtrlParamCollection)bgCtrlColl;
        BgCtrlResultCollection bgCtrRstColl = (BgCtrlResultCollection)bgCtrRtColl;
        IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
        for (int i = 0; i < bgCtrlParamColl.size(); ++i) {
            BgCtrlParamInfo param = bgCtrlParamColl.get(i);
            BgCtrlResultInfo result = bgCtrRstColl.get(i);
            String itemFormula = param.getItemFormula();
            String bgSchemeId = param.getBgSchemeId();
            String orgUnitId = param.getOrgUnitId();
            if (bgSchemeId == null || bgSchemeId.trim().equals("")) continue;
            iBgItem.updateBgItemSuperiorValue(BOSUuid.read((String)orgUnitId), BOSUuid.read((String)bgSchemeId), itemFormula, param.getAmount());
            iBgItem.updateBgItemSuperiorCtrlRecord(BOSUuid.read((String)orgUnitId), BOSUuid.read((String)bgSchemeId), itemFormula, result, null);
        }
    }

    @Override
    protected void _returnBudget(Context ctx, BOSUuid boId, String boName, String handlerName) throws BOSException, EASBizException {
        IBudgetCtrlFacade iBudgetCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
        iBudgetCtrl.returnBudgetLocal(boId);
    }

    private boolean isNewRule(Context ctx, String boName) throws BOSException {
        boolean isNewRule = false;
        StringBuffer strBuff = new StringBuffer(" select count(ctrlRule.foqlorgunit)  from t_bg_bgcontrolrule ctrlRule ,t_bg_bgControlScheme ctrlScheme");
        strBuff.append(" where ctrlRule.FBgCtrlSchemeID = ctrlScheme.FID and  ctrlScheme.FBoName = '" + boName + "' and ctrlScheme.FIsValid = 1 and  ctrlRule.foqlorgunit is not null ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuff.toString());
        try {
            if (rs.next()) {
                int cnt = rs.getInt(1);
                isNewRule = cnt > 0;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return isNewRule;
    }

    @Override
    protected boolean _isEnableRule(Context ctx, String boName) throws BOSException, EASBizException {
        boolean isNewRule = false;
        StringBuffer strBuff = new StringBuffer(" select count(fid)  from t_bg_bgControlScheme ctrlScheme");
        strBuff.append(" where ctrlScheme.FBoName = '" + boName + "' and ctrlScheme.FIsValid = 1 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strBuff.toString());
        try {
            if (rs.next()) {
                int cnt = rs.getInt(1);
                isNewRule = cnt > 0;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return isNewRule;
    }

    @Override
    protected List _batchGetBalanceByNumbers(Context ctx, List bgRptDataList) throws BOSException, EASBizException {
        ArrayList<BigDecimal> resultList = new ArrayList<BigDecimal>();
        IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance(ctx);
        for (int i = 0; i < bgRptDataList.size(); ++i) {
            Map paraMap = (Map)bgRptDataList.get(i);
            String combinId = paraMap.get("combinId").toString();
            String elementNumber = paraMap.get("elementNumber").toString();
            String periodNumber = paraMap.get("periodNumber").toString();
            String currencyNumber = paraMap.get("currencyNumber").toString();
            BOSUuid orgUnitId = (BOSUuid)paraMap.get("orgUnitId");
            BOSUuid schemeId = (BOSUuid)paraMap.get("schemeId");
            String bgPeriodId = paraMap.get("bgPeriodId").toString();
            BgPeriodInfo period = iBgPeriod.getBgPeriodInfo("select periodType where id='" + bgPeriodId + "'");
            BigDecimal result = this._getBalanceByNumber(ctx, combinId, elementNumber, periodNumber, currencyNumber, orgUnitId, schemeId, period.getPeriodType());
            resultList.add(result);
        }
        return resultList;
    }

    @Override
    protected HashMap _getGeneralAssActType(Context ctx) throws BOSException, EASBizException {
        String sql = " Select a.fassthgattribute,a.fname_" + ctx.getLocale() + " from T_BD_ASSTACTTYPE a where a.fassthgattribute like 'generalAssActType%' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (rs.next()) {
                map.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected HashMap _getGeneralAssActTypeGroupIds(Context ctx) throws BOSException, EASBizException {
        String sql = "Select a.fassthgattribute,b.fid from T_BD_ASSTACTTYPE a ,T_BD_GeneralAsstActTypeGroup b  where a.fglasstacttypegrpid = b.fid and  a.fassthgattribute like 'generalAssActType%' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (rs.next()) {
                map.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected BigDecimal _getBalanceByBgAvlBalFormula(Context ctx, String itemFormula, String orgUnitId, String schemeId, BgPeriodEnum periodTypeEnum, BgGetPeriodTypeForGetBlanceEnum getPeriodTypeForGetBlance) throws BOSException, EASBizException {
        BigDecimal zero = new BigDecimal("0.00");
        List list = new ArrayList();
        try {
            list = TableToolkit.parseFormula((String)itemFormula, (boolean)false);
        }
        catch (com.kingdee.bos.kscript.ParserException e1) {
            return zero;
        }
        if (list == null || list.isEmpty()) {
            return zero;
        }
        FormulaHint hint = (FormulaHint)list.get(0);
        String[] params = hint.getParams();
        String periodNumber = params[1];
        String currencyNumber = params[5];
        String elementNumber = params[2];
        String periodId = null;
        Date endDate = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid , fenddate from t_bg_bgperiod where fnumber = ? ", (Object[])new String[]{periodNumber});
        try {
            if (rs.next()) {
                periodId = rs.getString(1);
                endDate = rs.getDate(2);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        BgCtrlResultInfo resultInfo = new BgCtrlResultInfo();
        BgCtrlParamInfo bgCtrlParamInfo = new BgCtrlParamInfo();
        bgCtrlParamInfo.setPeriodId(periodId);
        bgCtrlParamInfo.setBizDate(endDate);
        bgCtrlParamInfo.setOrgUnitId(orgUnitId.toString());
        bgCtrlParamInfo.setCurrencyNumber(currencyNumber);
        bgCtrlParamInfo.setElementNumber(elementNumber);
        this.setBgCtrlResult(ctx, bgCtrlParamInfo.getOrgUnitId(), itemFormula, bgCtrlParamInfo, resultInfo, false, periodTypeEnum, schemeId, getPeriodTypeForGetBlance);
        if (bgCtrlParamInfo.getBgSchemeId() == null || schemeId == null || !bgCtrlParamInfo.getBgSchemeId().trim().equals(schemeId.toString())) {
            return zero;
        }
        BigDecimal result = zero;
        if (resultInfo.getBalance() != null) {
            result = resultInfo.getBalance();
            if (getPeriodTypeForGetBlance.getValue() == 10 && result.compareTo(zero) < 0) {
                result = zero;
            }
        }
        return result;
    }

    @Override
    protected IObjectCollection _batchGetBgBalance(Context ctx, IObjectCollection bgCtrlParamCol, BgGetPeriodTypeForGetBlanceEnum bgGetPeriodTypeForGetBlanceEnum) throws BOSException, EASBizException {
        if (bgCtrlParamCol == null || bgCtrlParamCol.size() == 0) {
            return bgCtrlParamCol;
        }
        if (!(bgCtrlParamCol instanceof BgCtrlParamCollection)) {
            throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, new String[]{" the parameter is not a BgCtrlParamCollection object!"});
        }
        BgCtrlParamCollection _bgCtrlParamCol = (BgCtrlParamCollection)bgCtrlParamCol;
        BgCtrlParamCollection retrunCtrlParamCol = new BgCtrlParamCollection();
        HashMap<String, Map> checkMap = new HashMap<String, Map>();
        HashMap<String, Map> calcuMap = new HashMap<String, Map>();
        Map ctrlParamMap = new HashMap();
        HashMap queryBgDataMap = new HashMap();
        IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance(ctx);
        HashMap<String, BgPeriodInfo> mapBgPeriod = new HashMap<String, BgPeriodInfo>();
        for (int i = 0; i < _bgCtrlParamCol.size(); ++i) {
            BgCtrlParamInfo ctrlParamInfo = _bgCtrlParamCol.get(i);
            if (ctrlParamInfo == null) {
                throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, new String[]{" the BgCtrlParamInfo is Null!"});
            }
            String orgUnitId = ctrlParamInfo.getOrgUnitId();
            String bgSchemeId = ctrlParamInfo.getBgSchemeId();
            String formula = ctrlParamInfo.getItemFormula();
            String itemCombinId = ctrlParamInfo.getItemCombinId();
            String periodId = ctrlParamInfo.getPeriodId();
            String currencyId = ctrlParamInfo.getCurrencyId();
            String elementId = ctrlParamInfo.getElementId();
            if (orgUnitId == null || orgUnitId.length() == 0) {
                throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, new String[]{" the orgUnitId of BgCtrlParamInfo is Null!"});
            }
            if (bgSchemeId == null || bgSchemeId.length() == 0) {
                throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, new String[]{" the bgSchemeId of BgCtrlParamInfo is Null!"});
            }
            if (formula == null || formula.length() == 0) {
                throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, new String[]{" the formula of BgCtrlParamInfo is Null!"});
            }
            if (itemCombinId == null || itemCombinId.length() == 0) {
                throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, new String[]{" the itemCombinId of BgCtrlParamInfo is Null!"});
            }
            if (periodId == null || periodId.length() == 0) {
                throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, new String[]{" the periodId of BgCtrlParamInfo is Null!"});
            }
            if (currencyId == null || currencyId.length() == 0) {
                throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, new String[]{" the currencyid of BgCtrlParamInfo is Null!"});
            }
            if (elementId == null || elementId.length() == 0) {
                throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, new String[]{" the elementid of BgCtrlParamInfo is Null!"});
            }
            BgPeriodInfo bgPeriodInfo = null;
            if (mapBgPeriod.containsKey(periodId)) {
                bgPeriodInfo = (BgPeriodInfo)mapBgPeriod.get(periodId);
            } else {
                bgPeriodInfo = iBgPeriod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
                mapBgPeriod.put(periodId, bgPeriodInfo);
            }
            ctrlParamInfo.setBizDate(bgPeriodInfo.getEndDate());
            String orgSchemeKey = orgUnitId + "#" + bgSchemeId;
            ctrlParamMap = checkMap.containsKey(orgSchemeKey) ? (Map)checkMap.get(orgSchemeKey) : new HashMap();
            String ctrlParamKey = orgUnitId + "#" + bgSchemeId + "#" + itemCombinId + "#" + periodId + "#" + currencyId + "#" + elementId;
            ctrlParamMap.put(ctrlParamKey, ctrlParamInfo);
            checkMap.put(orgSchemeKey, ctrlParamMap);
            BgNSQLHelper.getSubMap((Map)BgNSQLHelper.getSubMap(queryBgDataMap, (String)orgUnitId, (boolean)true), (String)bgSchemeId, (boolean)true).put(formula, formula);
        }
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet ret = null;
        int batchNum = 50;
        int size = _bgCtrlParamCol.size();
        int count = (size - 1) / batchNum + 1;
        boolean pos = false;
        StringBuffer sql = new StringBuffer();
        sql.append(" select d.* ");
        sql.append("   from T_Bg_BgData d,");
        sql.append("        T_Bg_BgScheme s ,");
        sql.append("        T_Bg_BgForm f ");
        sql.append("  where s.FID=d.FBgSchemeId  ");
        sql.append("    and d.FDataState = ").append(9);
        sql.append("    and f.FID=d.FBgFormId ");
        if (bgGetPeriodTypeForGetBlanceEnum.getValue() == 0) {
            sql.append("   and s.FIsFormal=1 ");
        }
        sql.append(" and d.forgunitid = ? and d.fbgschemeid = ? and d.fformula in(");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql).append(")");
        try {
            conn = this.getConnection(ctx);
            statement = conn.prepareStatement(sql.toString());
            for (String orgId : queryBgDataMap.keySet()) {
                Map subMap = (Map)queryBgDataMap.get(orgId);
                for (String bgSchemeid : subMap.keySet()) {
                    Object[] params = ((Map)subMap.get(bgSchemeid)).keySet().toArray();
                    int batchCount = BgNSQLHelper.getBatchCount((Object[])params);
                    for (int i = 0; i < batchCount; ++i) {
                        statement.setString(1, orgId);
                        statement.setString(2, bgSchemeid);
                        BgNSQLHelper.setParam4BatchDefCount((PreparedStatement)statement, (int)3, (int)i, (Object[])params);
                        ret = statement.executeQuery();
                        logger.error((Object)("endQuery:" + System.currentTimeMillis()));
                        while (ret.next()) {
                            String orgUnitId = ret.getString("FOrgUnitId");
                            String bgSchemeId = ret.getString("FBgSchemeId");
                            String formula = ret.getString("FFormula");
                            String itemCombinId = ret.getString("FBgItemCombinId");
                            String periodId = ret.getString("FBgPeriodId");
                            String currencyId = ret.getString("FCurrencyId");
                            String elementId = ret.getString("FBgElementId");
                            String bgDataId = ret.getString("FID");
                            boolean isControl = ret.getBoolean("FIsControl");
                            boolean isGroupControl = ret.getBoolean("FIsGroupCtrl");
                            boolean isFlexible = ret.getBoolean("FIsFlexible");
                            BigDecimal bgValue = ret.getBigDecimal("FBgValue");
                            BigDecimal bgActual = ret.getBigDecimal("FBizActual");
                            int ctrlType = ret.getInt("FCtrlType");
                            if (ctrlType == -1) {
                                ctrlType = 10;
                            }
                            String groupNo = null;
                            if (isGroupControl) {
                                groupNo = ret.getString("FGroupNo");
                            }
                            BigDecimal flexibleParam = null;
                            if (isFlexible) {
                                flexibleParam = ret.getBigDecimal("FFlexParam");
                            }
                            String orgSchemeKey = orgUnitId + "#" + bgSchemeId;
                            String ctrlParamKey = orgUnitId + "#" + bgSchemeId + "#" + itemCombinId + "#" + periodId + "#" + currencyId + "#" + elementId;
                            if (!checkMap.containsKey(orgSchemeKey) || !((Map)checkMap.get(orgSchemeKey)).containsKey(ctrlParamKey)) continue;
                            Map _ctrlParamMap = (Map)checkMap.get(orgSchemeKey);
                            BgCtrlParamInfo _ctrlParamInfo = (BgCtrlParamInfo)_ctrlParamMap.get(ctrlParamKey);
                            BgCtrlResultInfo ctrlResultInfo = new BgCtrlResultInfo();
                            ctrlResultInfo.setBgDataId(bgDataId);
                            ctrlResultInfo.setOrgUnitId(orgUnitId);
                            ctrlResultInfo.setBgSchemeId(bgSchemeId);
                            ctrlResultInfo.setBgItemFormula(formula);
                            if (isFlexible) {
                                ctrlResultInfo.setBgValue(bgValue.multiply(flexibleParam));
                            } else {
                                ctrlResultInfo.setBgValue(bgValue);
                            }
                            ctrlResultInfo.setBizActual(bgActual);
                            ctrlResultInfo.put(currencyId, currencyId);
                            ctrlResultInfo.put(elementId, elementId);
                            ctrlResultInfo.put(isControl, isControl);
                            ctrlResultInfo.put(isGroupControl, isGroupControl);
                            ctrlResultInfo.put(isFlexible, isFlexible);
                            ctrlResultInfo.put(ctrlType, new Integer(ctrlType));
                            ctrlResultInfo.put(groupNo, groupNo);
                            ctrlResultInfo.put(flexibleParam, flexibleParam);
                            _ctrlParamInfo.put(RESULT, ctrlResultInfo);
                            BgCtrlTypeEnum ctrlTypeEnum = BgCtrlTypeEnum.getEnum(ctrlType);
                            _ctrlParamInfo.setCtrlType(ctrlTypeEnum);
                            _ctrlParamMap.put(this.buildMapKey(_ctrlParamInfo), _ctrlParamInfo);
                            checkMap.put(orgSchemeKey, _ctrlParamMap);
                            calcuMap.put(orgSchemeKey, _ctrlParamMap);
                        }
                        SQLUtils.cleanup((ResultSet)ret);
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ret, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(ret, (Statement)statement, (Connection)conn);
        Map resultMap = this.batchCalculateBal(ctx, calcuMap, bgGetPeriodTypeForGetBlanceEnum);
        for (String _key : resultMap.keySet()) {
            Map _ctrlParamMap = (Map)resultMap.get(_key);
            Iterator itr2 = _ctrlParamMap.keySet().iterator();
            while (itr2.hasNext()) {
                retrunCtrlParamCol.add((BgCtrlParamInfo)_ctrlParamMap.get(itr2.next()));
            }
        }
        return retrunCtrlParamCol;
    }

    private Map batchCalculateBal(Context ctx, Map ctrlParamMap, BgGetPeriodTypeForGetBlanceEnum bgGetPeriodTypeForGetBlanceEnum) throws BOSException, EASBizException {
        if (ctrlParamMap == null || ctrlParamMap.isEmpty()) {
            return new HashMap();
        }
        BgControlPeriodCacheHelper helper = new BgControlPeriodCacheHelper();
        List<String> bgValPeriodIds = null;
        List<String> bgActPeriodIds = null;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        boolean isCurrPeriod = bgGetPeriodTypeForGetBlanceEnum.getValue() == 20;
        StringBuffer SQL = new StringBuffer();
        SQL.append(" SELECT a.fbgvalue * (case a.FIsFlexible when 1 then a.fflexparam else 1 end ),");
        SQL.append("        a.fbizactual,");
        SQL.append("        a.forgunitid,");
        SQL.append("        a.fbgschemeid,");
        SQL.append("        a.fbgItemcombinId,");
        SQL.append("        a.FBgPeriodId,");
        SQL.append("        a.FCurrencyId,");
        SQL.append("        a.FBgElementId,");
        SQL.append("        a.fisgroupctrl,");
        SQL.append("        a.fgroupno");
        SQL.append("   FROM t_bg_bgdata a,");
        SQL.append("        t_bg_bgform b,  ");
        SQL.append("        t_bg_bgscheme s  ");
        SQL.append("  WHERE a.fbgformid=b.fid");
        SQL.append("    AND a.fDatastate = ").append(9);
        SQL.append("    AND a.forgunitid = ? ");
        SQL.append("    AND a.fbgschemeid= ? ");
        SQL.append("    AND a.fbgschemeid=s.fid");
        try {
            connection = this.getConnection(ctx);
            statement = connection.prepareStatement(SQL.toString());
            for (String orgSchemeKey : ctrlParamMap.keySet()) {
                String bgPeriodId;
                BgCtrlParamInfo paramInfo;
                Map _ctrlParamMap = (Map)ctrlParamMap.get(orgSchemeKey);
                if (_ctrlParamMap == null || _ctrlParamMap.isEmpty()) continue;
                String[] orgScheme = orgSchemeKey.split("\\#");
                String orgUnitId = orgScheme[0];
                String bgSchemeId = orgScheme[1];
                statement.setString(1, orgUnitId);
                statement.setString(2, bgSchemeId);
                resultSet = statement.executeQuery();
                HashMap<String, BigDecimal[]> tempValMap = new HashMap<String, BigDecimal[]>();
                while (resultSet.next()) {
                    BigDecimal bgAvlVal = resultSet.getBigDecimal(1);
                    BigDecimal bizActualVal = resultSet.getBigDecimal(2);
                    String itemCombinId = resultSet.getString("FBgItemCombinId");
                    String periodId = resultSet.getString("FBgPeriodId");
                    String currencyId = resultSet.getString("FCurrencyId");
                    String elementId = resultSet.getString("FBgElementId");
                    boolean isGorupCtrl = resultSet.getBoolean("fisgroupctrl");
                    String groupNo = resultSet.getString("fgroupno");
                    String key = null;
                    key = orgUnitId + "#" + bgSchemeId + "#" + itemCombinId + "#" + periodId + "#" + currencyId + "#" + elementId;
                    BigDecimal[] vals = new BigDecimal[]{bgAvlVal, bizActualVal};
                    tempValMap.put(key, vals);
                }
                SQLUtils.cleanup((ResultSet)resultSet);
                for (String valueKey : _ctrlParamMap.keySet()) {
                    BigDecimal[] vals;
                    String valKey;
                    BgCtrlParamInfo cloneParamInfo;
                    String periodId;
                    BgCtrlParamInfo _ctrlParamInfo = (BgCtrlParamInfo)_ctrlParamMap.get(valueKey);
                    BgCtrlResultInfo _bgCtrlResultInfo = (BgCtrlResultInfo)_ctrlParamInfo.get(RESULT);
                    if (_bgCtrlResultInfo == null) continue;
                    boolean isGroupCtrl = false;
                    if (_bgCtrlResultInfo.get(isGroupControl) != null) {
                        isGroupCtrl = (Boolean)_bgCtrlResultInfo.get(isGroupControl);
                    }
                    String _bgSchemeId = _ctrlParamInfo.getBgSchemeId();
                    BgCtrlTypeEnum ctrlType = _ctrlParamInfo.getCtrlType();
                    BgPeriodEnum periodType = _ctrlParamInfo.getPeriodType();
                    if (ctrlType.getValue() == -1 || ctrlType.getValue() == 10) {
                        bgValPeriodIds = new ArrayList<String>();
                        bgValPeriodIds.add(_ctrlParamInfo.getPeriodId());
                        bgActPeriodIds = bgValPeriodIds;
                    } else if (ctrlType.getValue() == 11) {
                        bgValPeriodIds = helper.getAllPeriodIdList(ctx, _ctrlParamInfo, _bgSchemeId, ctrlType.getValue(), periodType, false, false);
                        bgActPeriodIds = isCurrPeriod ? helper.getAllPeriodIdList(ctx, _ctrlParamInfo, _bgSchemeId, ctrlType.getValue(), periodType, false, true) : helper.getAllPeriodIdList(ctx, _ctrlParamInfo, _bgSchemeId, ctrlType.getValue(), periodType, true, true);
                    } else if (ctrlType.getValue() == 12) {
                        bgValPeriodIds = helper.getAllPeriodIdList(ctx, _ctrlParamInfo, _bgSchemeId, ctrlType.getValue(), periodType, false, false);
                        bgActPeriodIds = isCurrPeriod ? helper.getAllPeriodIdList(ctx, _ctrlParamInfo, _bgSchemeId, ctrlType.getValue(), periodType, false, true) : helper.getAllPeriodIdList(ctx, _ctrlParamInfo, _bgSchemeId, ctrlType.getValue(), periodType, true, true);
                    } else if (ctrlType.getValue() == 20) {
                        bgValPeriodIds = helper.getThisYearCtrlPeriodIdList(ctx, _ctrlParamInfo, ctrlType.getValue(), periodType, true);
                        bgActPeriodIds = isCurrPeriod ? helper.getThisYearCtrlPeriodIdList(ctx, _ctrlParamInfo, ctrlType.getValue(), periodType, false) : helper.getThisYearCtrlPeriodIdList(ctx, _ctrlParamInfo, ctrlType.getValue(), periodType, true);
                    }
                    if (bgValPeriodIds != null) {
                        for (int i = 0; i < bgValPeriodIds.size(); ++i) {
                            BigDecimal bgVal;
                            periodId = (String)bgValPeriodIds.get(i);
                            cloneParamInfo = (BgCtrlParamInfo)_ctrlParamInfo.clone();
                            cloneParamInfo.setPeriodId(periodId);
                            valKey = this.buildMapKey(cloneParamInfo);
                            if (!tempValMap.containsKey(valKey)) continue;
                            vals = (BigDecimal[])tempValMap.get(valKey);
                            BigDecimal bigDecimal = bgVal = _bgCtrlResultInfo.getBgValue() != null ? _bgCtrlResultInfo.getBgValue() : BgNConstants.ZERO;
                            if (periodId.equals(_ctrlParamInfo.getPeriodId())) continue;
                            _bgCtrlResultInfo.setBgValue(bgVal.add(vals[0]));
                        }
                    }
                    if (bgActPeriodIds != null) {
                        for (int i = 0; i < bgActPeriodIds.size(); ++i) {
                            periodId = (String)bgActPeriodIds.get(i);
                            if (periodId.equals(_ctrlParamInfo.getPeriodId())) continue;
                            cloneParamInfo = (BgCtrlParamInfo)_ctrlParamInfo.clone();
                            cloneParamInfo.setPeriodId(periodId);
                            valKey = this.buildMapKey(cloneParamInfo);
                            if (!tempValMap.containsKey(valKey)) continue;
                            vals = (BigDecimal[])tempValMap.get(valKey);
                            BigDecimal bgAct = _bgCtrlResultInfo.getBizActual() != null ? _bgCtrlResultInfo.getBizActual() : BgNConstants.ZERO;
                            _bgCtrlResultInfo.setBizActual(bgAct.add(vals[1]));
                        }
                    }
                    BigDecimal balance = _bgCtrlResultInfo.getBgValue().subtract(_bgCtrlResultInfo.getBizActual());
                    _bgCtrlResultInfo.setBalance(balance);
                    _ctrlParamInfo.put(RESULT, _bgCtrlResultInfo);
                    _ctrlParamMap.put(valueKey, _ctrlParamInfo);
                }
                HashMap<String, BigDecimal> tempGrpValMap = new HashMap<String, BigDecimal>();
                for (String tempKey : _ctrlParamMap.keySet()) {
                    paramInfo = (BgCtrlParamInfo)_ctrlParamMap.get(tempKey);
                    BgCtrlResultInfo resultInfo = (BgCtrlResultInfo)paramInfo.get(RESULT);
                    if (resultInfo == null) continue;
                    boolean isGroupCtrl = false;
                    if (resultInfo.get(isGroupControl) != null) {
                        isGroupCtrl = (Boolean)resultInfo.get(isGroupControl);
                    }
                    if (!isGroupCtrl) continue;
                    String groupNo = (String)resultInfo.get(groupNo);
                    bgPeriodId = paramInfo.getPeriodId();
                    if (!tempGrpValMap.containsKey(groupNo + "#" + bgPeriodId)) {
                        tempGrpValMap.put(groupNo + "#" + bgPeriodId, resultInfo.getBalance());
                        continue;
                    }
                    BigDecimal val = (BigDecimal)tempGrpValMap.get(groupNo + "#" + bgPeriodId);
                    tempGrpValMap.put(groupNo + "#" + bgPeriodId, val.add(resultInfo.getBalance()));
                }
                for (String tempKey : _ctrlParamMap.keySet()) {
                    paramInfo = (BgCtrlParamInfo)_ctrlParamMap.get(tempKey);
                    BgCtrlResultInfo resultInfo = (BgCtrlResultInfo)paramInfo.get(RESULT);
                    if (resultInfo == null) continue;
                    boolean isGroupCtrl = false;
                    if (resultInfo.get(isGroupControl) != null) {
                        isGroupCtrl = (Boolean)resultInfo.get(isGroupControl);
                    }
                    if (!isGroupCtrl) continue;
                    String groupNo = (String)resultInfo.get(groupNo);
                    bgPeriodId = paramInfo.getPeriodId();
                    BigDecimal grpCtrlBal = (BigDecimal)tempGrpValMap.get(groupNo + "#" + bgPeriodId);
                    resultInfo.setBalance(grpCtrlBal);
                    paramInfo.put(RESULT, resultInfo);
                    _ctrlParamMap.put(tempKey, paramInfo);
                }
                ctrlParamMap.put(orgSchemeKey, _ctrlParamMap);
            }
        }
        catch (SQLException e) {
            try {
                logger.debug((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, statement, (Connection)connection);
                helper.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup(resultSet, (Statement)statement, (Connection)connection);
        helper.clear();
        return ctrlParamMap;
    }

    private String buildMapKey(BgCtrlParamInfo paramInfo) {
        return paramInfo.getOrgUnitId() + "#" + paramInfo.getBgSchemeId() + "#" + paramInfo.getItemCombinId() + "#" + paramInfo.getPeriodId() + "#" + paramInfo.getCurrencyId() + "#" + paramInfo.getElementId();
    }

    @Override
    protected List _checkRequireFields(Context ctx, String boName, String ouID) throws BOSException, EASBizException {
        ArrayList<String> returnValue = new ArrayList<String>();
        if (StringUtils.isEmpty((String)boName) || StringUtils.isEmpty((String)ouID)) {
            return returnValue;
        }
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, ouID);
        if (ctrlScheme == null) {
            return returnValue;
        }
        String oqlOrgUnit = null;
        String oqlItemCombination = null;
        String oqlItemCombinationName = null;
        String oqlOqlCurrency = null;
        String oqlOqlBizDate = null;
        String oqlRequest = null;
        String[] oqlOrgUnitSplited = null;
        String[] oqlItemCombinationTemp = null;
        String[] oqlItemCombinationSplited = null;
        String[] oqlOqlCurrencySplited = null;
        String[] oqlOqlBizDateSplited = null;
        String[] oqlRequestSplited = null;
        BgControlRuleCollection ruleCol = ctrlScheme.getRules();
        for (int i = 0; i < ruleCol.size(); ++i) {
            BgControlRuleInfo rule = ruleCol.get(i);
            oqlOrgUnit = rule.getOqlOrgUnit() == null ? "" : rule.getOqlOrgUnit();
            oqlItemCombination = rule.getOqlItemCombination() == null ? "" : rule.getOqlItemCombination();
            oqlOqlCurrency = rule.getOqlCurrency() == null ? "" : rule.getOqlCurrency();
            oqlOqlBizDate = rule.getOqlBizDate() == null ? "" : rule.getOqlBizDate();
            oqlRequest = rule.getOqlRequest() == null ? "" : rule.getOqlRequest();
            oqlOrgUnitSplited = oqlOrgUnit.split("\\|");
            oqlItemCombinationSplited = oqlItemCombination.split("\\|");
            oqlOqlCurrencySplited = oqlOqlCurrency.split("\\|");
            oqlOqlBizDateSplited = oqlOqlBizDate.split("\\|");
            oqlRequestSplited = oqlRequest.split("\\|");
            if (!StringUtils.isEmpty((String)oqlOrgUnitSplited[0]) && !returnValue.contains(oqlOrgUnitSplited[0])) {
                returnValue.add(oqlOrgUnitSplited[0]);
            }
            if (!StringUtils.isEmpty((String)oqlOqlCurrencySplited[0]) && !returnValue.contains(oqlOqlCurrencySplited[0])) {
                returnValue.add(oqlOqlCurrencySplited[0]);
            }
            if (!StringUtils.isEmpty((String)oqlOqlBizDateSplited[0]) && !returnValue.contains(oqlOqlBizDateSplited[0])) {
                returnValue.add(oqlOqlBizDateSplited[0]);
            }
            if (!StringUtils.isEmpty((String)oqlRequestSplited[0]) && !returnValue.contains(oqlRequestSplited[0])) {
                returnValue.add(oqlRequestSplited[0]);
            }
            if (oqlRequestSplited.length == 2 && !StringUtils.isEmpty((String)oqlRequestSplited[1]) && oqlRequestSplited[1].indexOf("entries.entryDC") != -1 && !returnValue.contains("entries.entryDC")) {
                returnValue.add("entries.entryDC");
            }
            oqlItemCombinationTemp = oqlItemCombination.split("\\@");
            for (int j = 0; j < oqlItemCombinationTemp.length; ++j) {
                oqlItemCombinationSplited = oqlItemCombinationTemp[j].split("\\|");
                if (StringUtils.isEmpty((String)oqlItemCombinationSplited[0]) || returnValue.contains(oqlItemCombinationSplited[0])) continue;
                returnValue.add(oqlItemCombinationSplited[0]);
                oqlItemCombinationName = this.generateNameFiled(oqlItemCombinationSplited[0]);
                if (StringUtils.isEmpty((String)oqlItemCombinationName) || returnValue.contains(oqlItemCombinationName)) continue;
                returnValue.add(oqlItemCombinationName);
            }
            if (StringUtils.isEmpty((String)rule.getOqlRuleCondition())) continue;
            try {
                FilterInfo filter = new FilterInfo(rule.getOqlRuleCondition());
                int jn = filter.getFilterItems().size();
                for (int j = 0; j < jn; ++j) {
                    FilterItemInfo item = filter.getFilterItems().get(j);
                    String prop = item.getPropertyName();
                    returnValue.add(prop);
                }
                continue;
            }
            catch (ParserException e) {
                logger.error((Object)e.toString());
            }
        }
        return returnValue;
    }

    private String generateNameFiled(String subNameField) {
        if (BudgetCtrlUtil.isEmpty(subNameField)) {
            return null;
        }
        String oqlNameField = null;
        if (subNameField.toLowerCase().indexOf(".id") != -1) {
            oqlNameField = subNameField.replaceAll(".id", ".name");
        } else if (subNameField.toLowerCase().indexOf(".number") != -1) {
            oqlNameField = subNameField.replaceAll(".number", ".name");
        } else if (subNameField.toLowerCase().indexOf(".longnumber") != -1) {
            oqlNameField = subNameField.replaceAll(".longnumber", ".name");
        }
        return oqlNameField;
    }

    @Override
    protected Map _checkBudget(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        IBudgetCtrlFacade iBudgetCtrl = BudgetCtrlFacadeFactory.getLocalInstance(ctx);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            boolean isPass = iBudgetCtrl.checkBudget(billInfo);
            returnMap.put("isPass", new Boolean(isPass));
            returnMap.put("message", null);
        }
        catch (BgCtrlException ex) {
            logger.error((Object)ex);
            returnMap.put("isPass", new Boolean(false));
            returnMap.put("message", ex.getMessage());
        }
        return returnMap;
    }

    @Override
    protected Map _checkBudgetAccess(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        return BudgetCtrlFacadeFactory.getLocalInstance(ctx).checkBudgetAccess(billInfo);
    }

    @Override
    public List _checkRequireFields(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String boName = BudgetCtrlHelper.getBOName(ctx, model);
        String OUID = BudgetCtrlHelper.getBillOUID(ctx, boName, model);
        return this._checkRequireFields(ctx, boName, OUID);
    }
}

