/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BgControlPeriodCacheHelper {
    private static Logger logger = Logger.getLogger((String)BgControlPeriodCacheHelper.class.getName());
    Map allPeriodIds = new HashMap();
    Map bgPeriods = new HashMap();
    Map schemeDateCache = new HashMap();
    private static final String SPLITER = "###";

    public List getAllPeriodIdList(Context ctx, BgCtrlParamInfo bgCtrlParamInfo, String bgSchemeId, int curPeriodBgDataCtrlType, BgPeriodEnum periodTypeEnum, boolean isSelectAllPeriodInScheme, boolean isActul) throws BOSException, EASBizException {
        if (curPeriodBgDataCtrlType == 10 || periodTypeEnum.getValue() == 8) {
            ArrayList<String> periodIdList = new ArrayList<String>();
            periodIdList.add(bgCtrlParamInfo.getPeriodId());
            return periodIdList;
        }
        return this.innerGetAllPeriodIdList(ctx, bgCtrlParamInfo, bgSchemeId, curPeriodBgDataCtrlType, periodTypeEnum, isSelectAllPeriodInScheme, isActul);
    }

    public List getThisYearCtrlPeriodIdList(Context ctx, BgCtrlParamInfo bgCtrlParamInfo, int curPeriodBgDataCtrlType, BgPeriodEnum periodTypeEnum, boolean isGetAll) throws BOSException, EASBizException {
        return this.innerGetThisYearCtrlPeriodIdList(ctx, bgCtrlParamInfo, curPeriodBgDataCtrlType, periodTypeEnum, isGetAll);
    }

    public void clear() {
        this.allPeriodIds.clear();
        this.bgPeriods.clear();
    }

    private List innerGetAllPeriodIdList(Context ctx, BgCtrlParamInfo bgCtrlParamInfo, String bgSchemeId, int curPeriodBgDataCtrlType, BgPeriodEnum periodTypeEnum, boolean isSelectAllPeriodInScheme, boolean isActul) throws BOSException, EASBizException {
        List periodIdList = new ArrayList();
        BgSchemeDateRange range = this.queryBgSchemeRange(ctx, bgSchemeId);
        if (range != null) {
            Date endDate;
            Date beginDate = range.dateFrom;
            if (isSelectAllPeriodInScheme) {
                endDate = range.dateTo;
            } else {
                endDate = curPeriodBgDataCtrlType == 11 ? bgCtrlParamInfo.getBizDate() : range.dateTo;
                if (isActul && curPeriodBgDataCtrlType == 12) {
                    endDate = bgCtrlParamInfo.getBizDate();
                }
            }
            int periodType = -1;
            periodType = periodTypeEnum == null ? (bgCtrlParamInfo.getPeriodType() == null ? range.period : bgCtrlParamInfo.getPeriodType().getValue()) : periodTypeEnum.getValue();
            periodIdList = this.getBgPeriodRange(ctx, periodType, beginDate, endDate);
        }
        return periodIdList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BgSchemeDateRange queryBgSchemeRange(Context ctx, String bgSchemeId) throws BOSException, EASBizException {
        BgSchemeDateRange range = null;
        if (this.schemeDateCache.containsKey(bgSchemeId)) {
            return (BgSchemeDateRange)this.schemeDateCache.get(bgSchemeId);
        }
        IRowSet rs = null;
        try {
            String sql = "SELECT TOP 1 FDateFrom, FDateTo, FPeriod FROM T_BG_BgScheme WHERE FID = ?";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bgSchemeId});
            if (rs.next()) {
                range = new BgSchemeDateRange();
                range.dateFrom = rs.getDate("FDateFrom");
                range.dateTo = rs.getDate("FDateTo");
                range.period = rs.getInt("FPeriod");
                this.schemeDateCache.put(bgSchemeId, range);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return range;
    }

    private List innerGetThisYearCtrlPeriodIdList(Context ctx, BgCtrlParamInfo bgCtrlParamInfo, int curPeriodBgDataCtrlType, BgPeriodEnum periodTypeEnum, boolean isGetAll) throws BOSException, EASBizException {
        BgPeriodInfo period;
        if (curPeriodBgDataCtrlType != 20 || periodTypeEnum == BgPeriodEnum.PERSONAL) {
            throw new BOSException("the period type of ThisYearCtrl is error!");
        }
        List periodIdList = new ArrayList();
        int periodType = -1;
        if (periodTypeEnum == null) {
            if (bgCtrlParamInfo.getPeriodType() == null) {
                return periodIdList;
            }
            periodType = bgCtrlParamInfo.getPeriodType().getValue();
        } else {
            periodType = periodTypeEnum.getValue();
        }
        if (periodType == -1) {
            return periodIdList;
        }
        Date beginDate = null;
        Date endDate = null;
        String periodNumber = bgCtrlParamInfo.getPeriodNumber();
        String periodId = null;
        if (periodNumber == null || periodNumber.length() == 0) {
            periodId = bgCtrlParamInfo.getPeriodId().toString();
        }
        if ((period = this.getBgPeriodInfo(ctx, periodNumber, periodId)) == null) {
            return periodIdList;
        }
        int year = period.getYear();
        beginDate = new Date();
        beginDate.setYear(year - 1900);
        beginDate.setMonth(0);
        beginDate.setDate(1);
        beginDate.setHours(0);
        beginDate.setMinutes(0);
        beginDate.setSeconds(0);
        if (isGetAll && bgCtrlParamInfo.getBizDate() != null) {
            endDate = new Date();
            endDate.setYear(year - 1900);
            endDate.setMonth(11);
            endDate.setDate(31);
            endDate.setHours(0);
            endDate.setMinutes(0);
            endDate.setSeconds(0);
        } else {
            endDate = bgCtrlParamInfo.getBizDate();
        }
        periodIdList = this.getBgPeriodRange(ctx, periodType, beginDate, endDate);
        return periodIdList;
    }

    private List getBgPeriodRange(Context ctx, int periodType, Date beginDate, Date endDate) throws BOSException, EASBizException {
        List<String> periodIdList = null;
        String key = periodType + SPLITER + beginDate + SPLITER + endDate;
        if (this.allPeriodIds.containsKey(key)) {
            periodIdList = (List)this.allPeriodIds.get(key);
        } else {
            periodIdList = new ArrayList();
            try {
                BgPeriodCollection bgPeriodList = BgHelper.getBgPeriodCollOverDateRange(ctx, periodType, beginDate, endDate);
                if (bgPeriodList != null) {
                    int count = bgPeriodList.size();
                    for (int i = 0; i < count; ++i) {
                        periodIdList.add(bgPeriodList.get(i).getId().toString());
                    }
                }
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            if (!periodIdList.isEmpty()) {
                this.allPeriodIds.put(key, periodIdList);
            }
        }
        return periodIdList;
    }

    private BgPeriodInfo getBgPeriodInfo(Context ctx, String periodNumber, String periodId) throws BOSException, EASBizException {
        BgPeriodInfo period;
        block7: {
            if (this.bgPeriods.containsKey(periodNumber)) {
                return (BgPeriodInfo)this.bgPeriods.get(periodNumber);
            }
            if (this.bgPeriods.containsKey(periodId)) {
                return (BgPeriodInfo)this.bgPeriods.get(periodId);
            }
            IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance(ctx);
            period = null;
            try {
                if (!StringUtils.isEmpty((String)periodNumber)) {
                    period = (BgPeriodInfo)iBgPeriod.getValue(" select * where number = '" + periodNumber + "' ");
                    break block7;
                }
                if (periodId != null) {
                    period = (BgPeriodInfo)iBgPeriod.getValue(" select * where id = '" + periodId + "' ");
                    break block7;
                }
                throw new BOSException(" the period is null!");
            }
            catch (ObjectNotFoundException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        if (period != null) {
            this.bgPeriods.put(period.getId().toString(), period);
            this.bgPeriods.put(period.getNumber(), period);
        }
        return period;
    }

    private static class BgSchemeDateRange {
        public Date dateFrom;
        public Date dateTo;
        public int period;

        private BgSchemeDateRange() {
        }
    }
}

