/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgControlException;
import com.kingdee.eas.ma.budget.BgControlPeriodMapCollection;
import com.kingdee.eas.ma.budget.BgControlPeriodMapHelper;
import com.kingdee.eas.ma.budget.BgControlPeriodMapInfo;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.app.AbstractBgControlPeriodMapControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgControlPeriodMapControllerBean
extends AbstractBgControlPeriodMapControllerBean {
    private static final long serialVersionUID = -3237658653801306077L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgControlPeriodMapControllerBean");

    @Override
    protected void _savePeriodMap(Context ctx, String ctrlSchemeId, IObjectCollection periodMapCollection) throws BOSException, EASBizException {
        int i;
        String sql1 = "delete from T_BG_BgControlPeriodMap where FBgCtrlSchemeID = ?";
        String sql2 = "insert into T_BG_BgControlPeriodMap( FID,FBgCtrlSchemeID, FBizBeginPeriod,FBizEndPeriod,FBgPeriod )  values(?,?,?,?,?)";
        PreparedStatement ps = null;
        Connection connection = null;
        Object[] uuids = new String[periodMapCollection.size()];
        BgControlPeriodMapInfo tmpInfo = new BgControlPeriodMapInfo();
        for (i = 0; i < periodMapCollection.size(); ++i) {
            uuids[i] = BOSUuid.create((BOSObjectType)tmpInfo.getBOSType()).toString();
        }
        Arrays.sort(uuids);
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql1);
            ps.setString(1, ctrlSchemeId.toString());
            ps.execute();
            SQLUtils.cleanup((Statement)ps);
            ps = connection.prepareStatement(sql2);
            for (i = 0; i < periodMapCollection.size(); ++i) {
                BgControlPeriodMapInfo info = (BgControlPeriodMapInfo)periodMapCollection.getObject(i);
                ps.setString(1, (String)uuids[i]);
                ps.setString(2, ctrlSchemeId.toString());
                ps.setString(3, info.getBizBeginPeriod().toString());
                ps.setString(4, info.getBizEndPeriod().toString());
                ps.setString(5, info.getBgPeriod().toString());
                ps.addBatch();
            }
            int[] i2 = ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("BgControlPeriodMap:" + e));
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                tmpInfo = null;
                uuids = null;
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        tmpInfo = null;
        uuids = null;
    }

    @Override
    protected IObjectCollection _getPeriodMap(Context ctx, String ctrlSchemeId) throws BOSException, EASBizException {
        BgControlPeriodMapCollection col1 = new BgControlPeriodMapCollection();
        String sql = "select FID,FBgCtrlSchemeID,FBizBeginPeriod,FBizEndPeriod,FBgPeriod from T_BG_BgControlPeriodMap  where FBgCtrlSchemeID = ? order by FID asc";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{ctrlSchemeId.toString()});
            while (rs.next()) {
                BgControlPeriodMapInfo info = new BgControlPeriodMapInfo();
                String bizBeginPeriod = rs.getString(3);
                String bizEndPeriod = rs.getString(4);
                String bgPeriod = rs.getString(5);
                info.setBizBeginPeriod(bizBeginPeriod);
                info.setBizEndPeriod(bizEndPeriod);
                info.setBgPeriod(bgPeriod);
                col1.add(info);
            }
            BgControlPeriodMapHelper.fillBgPeriodInfo(ctx, col1);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("BgControlItemMap:" + e));
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return col1;
    }

    @Override
    protected IObjectValue _queryBgPeriod(Context ctx, String bgCtrlSchemeID, Date bizDate, BgPeriodEnum periodType) throws BOSException, EASBizException {
        IObjectCollection col = this._getPeriodMap(ctx, bgCtrlSchemeID);
        if (col == null || col.isEmpty()) {
            throw new BgControlException(BgControlException.NOTDEFINDMAPPERIOD);
        }
        BgControlPeriodMapCollection col2 = (BgControlPeriodMapCollection)col;
        for (int i = 0; i < col2.size(); ++i) {
            BgControlPeriodMapInfo info = col2.get(i);
            String bizBeginPeriod = info.getBizBeginPeriod();
            String bizEndPeriod = info.getBizEndPeriod();
            String bgPeriod = info.getBgPeriod();
            boolean isWild = BgControlPeriodMapHelper.isWildcard(bizBeginPeriod);
            if (bgPeriod.indexOf(BgControlPeriodMapHelper.getString(ctx, "9_BgControlPeriodMapControllerBean", LocaleUtils.locale_l2)) >= 0) {
                BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)info.get("BGPERIOD_INFO");
                bgPeriod = isWild ? bgPeriodInfo.getNumber().replaceAll(String.valueOf(bgPeriodInfo.getYear()), "%") : bgPeriodInfo.getNumber();
            }
            Date bizBeginDate = BgControlPeriodMapHelper.processDate(bizDate, bizBeginPeriod, ctx);
            Date bizEndDate = BgControlPeriodMapHelper.processDate(bizDate, bizEndPeriod, ctx);
            bizBeginDate.setHours(0);
            bizBeginDate.setMinutes(0);
            bizBeginDate.setSeconds(0);
            bizEndDate.setHours(0);
            bizEndDate.setMinutes(0);
            bizEndDate.setSeconds(0);
            if (!bizDate.toLocaleString().equals(bizBeginDate.toLocaleString()) && bizDate.before(bizBeginDate) || bizDate.after(bizEndDate)) {
                if (i != col2.size() - 1) continue;
                throw new BgControlException(BgControlException.NOTFOUNDMAPPERIOD);
            }
            if (bizBeginPeriod.indexOf("%") > -1) {
                bgPeriod = bgPeriod.replaceAll("%", String.valueOf(bizDate.getYear() + 1900));
            }
            IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance(ctx);
            CoreBaseInfo bgInfo = null;
            try {
                bgInfo = iBgPeriod.getValue(" select * where number = '" + bgPeriod + "' and periodType =" + periodType.getValue());
            }
            catch (ObjectNotFoundException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            return bgInfo == null ? null : (BgPeriodInfo)bgInfo;
        }
        return null;
    }

    @Override
    protected Map _getString(Context ctx, String resource, Set keySet, Locale[] locales) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (resource != null && keySet != null && locales != null) {
            for (Object key : keySet) {
                for (int i = 0; i < locales.length; ++i) {
                    map.put(key + "_" + locales[i], ResourceBase.getString((String)resource, (String)((String)key), (Locale)locales[i]));
                }
            }
        }
        return map;
    }
}

