/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.AbstractBgCtrlBizParamInfo;
import com.kingdee.eas.ma.budget.BgCtrlBizBillCollection;
import com.kingdee.eas.ma.budget.BgCtrlBizBillFactory;
import com.kingdee.eas.ma.budget.BgCtrlBizBillInfo;
import com.kingdee.eas.ma.budget.BgCtrlBizParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlBizParamEnum;
import com.kingdee.eas.ma.budget.BgCtrlBizParamFactory;
import com.kingdee.eas.ma.budget.BgCtrlBizParamInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgCtrlBizParamControllerBean;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCtrlBizParamControllerBean
extends AbstractBgCtrlBizParamControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgCtrlBizParamControllerBean");

    @Override
    protected Map _getParam(Context ctx, String orgUnitId, Set boNames) throws BOSException, EASBizException {
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        if (orgUnitId == null || boNames == null || boNames.isEmpty()) {
            return values;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("bizBill.boName");
        evi.getSelector().add("value");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bizBill.boName", (Object)boNames, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId));
        BgCtrlBizParamCollection paramCol = BgCtrlBizParamFactory.getLocalInstance(ctx).getBgCtrlBizParamCollection(evi);
        if (paramCol != null) {
            for (int i = 0; i < paramCol.size(); ++i) {
                values.put(paramCol.get(i).getBizBill().getBoName(), paramCol.get(i).getValue().getValue());
                boNames.remove(paramCol.get(i).getBizBill().getBoName());
            }
        }
        if (boNames.isEmpty()) {
            return values;
        }
        Map<Integer, Set<String>> orgTypes = this.splitByOrgType(ctx, boNames);
        SelectorItemCollection orgSic = new SelectorItemCollection();
        orgSic.add("longNumber");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = this.getConnection(ctx);
            for (int orgViewType : orgTypes.keySet()) {
                String[] lns;
                OrgType orgType = NewOrgViewHelper.convert((OrgViewType)OrgViewType.getEnum((int)orgViewType));
                if (orgType == null) continue;
                Set<String> boIds = orgTypes.get(orgViewType);
                OrgTypeSelfInfo orgInfo = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo();
                if (orgInfo == null) continue;
                String tableName = orgInfo.getViewTableName();
                OrgUnitInfo orgUnit = NewOrgViewHelper.getOrgUnitInfo((Context)ctx, (String)orgUnitId, (OrgType)orgType, (SelectorItemCollection)orgSic);
                if (orgUnit == null || (lns = orgUnit.getLongNumber().split("!")).length <= 1) continue;
                StringBuffer sql = new StringBuffer();
                sql.append("Select billM.FBoName, paramM.FValue From T_BG_BgCtrlBizBill billM, T_BG_BgCtrlBizParam paramM, ").append(tableName).append(" orgM, (");
                sql.append(" Select param.FBizBillID, Max(org.FLongNumber) FLongNumber From T_BG_BgCtrlBizParam param, " + tableName + " org Where param.FOrgUnitId = org.FID ").append(" AND param.FIsIncludeSub = 1 ").append(" AND param.FBizBillID IN (");
                Iterator<String> itBo = boIds.iterator();
                while (itBo.hasNext()) {
                    sql.append("'").append((Object)itBo.next()).append("'");
                    sql.append(", ");
                }
                sql.append("'").append("#").append("'");
                sql.append(") AND org.FNumber IN (");
                for (int i = 0; i < lns.length - 1; ++i) {
                    sql.append("'").append(lns[i]).append("'");
                    sql.append(", ");
                }
                sql.append("'").append("#").append("'");
                sql.append(") Group By param.FBizBillID");
                sql.append(") subQuery Where billM.FID = paramM.FBizBillID And paramM.FOrgUnitID = orgM.FID AND OrgM.FLongNumber = subQuery.FLongNumber AND paramM.FBizBillId = subQuery.FBizBillID");
                pstmt = conn.prepareStatement(sql.toString());
                res = pstmt.executeQuery();
                while (res.next()) {
                    values.put(res.getString("FBoName"), res.getInt("FValue"));
                }
                SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(res, pstmt, (Connection)conn);
        }
        return values;
    }

    private Map<Integer, Set<String>> splitByOrgType(Context ctx, Set boNames) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("orgViewType");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("boName", (Object)boNames, CompareType.INCLUDE));
        BgCtrlBizBillCollection bills = BgCtrlBizBillFactory.getLocalInstance(ctx).getBgCtrlBizBillCollection(evi);
        HashMap<Integer, Set<String>> orgTypes = new HashMap<Integer, Set<String>>();
        if (bills == null || bills.isEmpty()) {
            return orgTypes;
        }
        for (int i = 0; i < bills.size(); ++i) {
            int orgViewType = bills.get(i).getOrgViewType().getValue();
            if (!orgTypes.containsKey(orgViewType)) {
                orgTypes.put(orgViewType, new HashSet());
            }
            ((Set)orgTypes.get(orgViewType)).add(bills.get(i).getId().toString());
        }
        return orgTypes;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    protected Map _getOrgAndParamControlMap(Context ctx, String boName, String orgUnitId, int level) throws BOSException, EASBizException {
        sql = new StringBuffer();
        bill = BgCtrlBizBillFactory.getLocalInstance(ctx).getBgCtrlBizBillInfo("where boName = '" + boName + "'");
        orgType = NewOrgViewHelper.convert((OrgViewType)bill.getOrgViewType());
        longNumber = "";
        longNumberSub = "";
        paramId = bill.getId().toString();
        orgTable = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo().getViewTableName();
        viewTableSql = "select FLevel,flongnumber from " + orgTable + " where fid=?";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)viewTableSql, (Object[])new String[]{orgUnitId});
        try {
            orgUnitLevel = 0;
            while (rowSet.next()) {
                orgUnitLevel = rowSet.getInt("FLevel");
                longNumber = rowSet.getString("flongnumber");
                longNumberSub = longNumber + "!%";
            }
            level = orgUnitLevel + level;
        }
        catch (SQLException e1) {
            BgCtrlBizParamControllerBean.logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        l = ctx.getLocale();
        sql.append("SELECT ou.FID ouid, ou.FParentID ouparentid, ou.FName_").append(l.toString()).append(" ouname, ou.FNumber ounum, ou.FLongNumber oulongnum, pi.FValue pivalue, pi.FBizBillID piid, ").append("pi.FCanModify, pi.FSuperiorControlID, pi.FIsIncludeSub, pi.FID pcid").append(" FROM ").append(orgTable).append(" ou ").append(" LEFT JOIN (Select * From T_BG_BgCtrlBizParam Where FBizBillId = ?) pi on ou.FID = pi.FOrgUnitID ").append(" WHERE ou.FLevel < ? and (ou.FLongNumber like ? or ou.FLongNumber = ? )").append(" ORDER BY ou.FLongNumber");
        params = new Object[]{paramId, level, longNumberSub, longNumber};
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        ret = new LinkedHashMap<FullOrgUnitInfo, BgCtrlBizParamInfo>();
        subCtrl = new HashMap<String, BgCtrlBizParamInfo>();
        superNumbers = new HashSet<String>();
lbl30:
        // 2 sources

        try {
            while (rs.next()) {
                block12: {
                    org = new FullOrgUnitInfo();
                    org.setId(BOSUuid.read((String)rs.getString("ouid")));
                    org.setName(rs.getString("ouname"));
                    org.setNumber(rs.getString("ounum"));
                    curLongNumber = rs.getString("oulongnum");
                    org.setLongNumber(curLongNumber);
                    tempParamItemId = rs.getString("piid");
                    if (!StringUtils.isEmpty((String)tempParamItemId)) break block12;
                    ret.put(org, null);
                    lns = curLongNumber.split("!");
                    for (ln = 0; ln < lns.length - 1; ++ln) {
                        superNumbers.add(lns[ln]);
                    }
                    ** GOTO lbl30
                }
                tempParamItemInfo = new BgCtrlBizParamInfo();
                tempParamItemInfo.setOrgUnit(org);
                tempParamItemInfo.setValue(BgCtrlBizParamEnum.getEnum(rs.getInt("pivalue")));
                tempParamItemInfo.setBizBill(bill);
                paramControId = rs.getString("pcid");
                tempParamItemInfo.setId(BOSUuid.read((String)paramControId));
                tempParamItemInfo.setCanModify(rs.getBoolean("FCanModify"));
                tempParamItemInfo.setSuperiorControlID(rs.getString("FSuperiorControlID"));
                tempParamItemInfo.setIsIncludeSub(rs.getBoolean("FIsIncludeSub"));
                ret.put(org, tempParamItemInfo);
                if (!tempParamItemInfo.isIsIncludeSub()) continue;
                subCtrl.put(org.getNumber(), tempParamItemInfo);
            }
        }
        catch (SQLException e) {
            BgCtrlBizParamControllerBean.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (superNumbers.isEmpty()) {
            return ret;
        }
        superNumbers.removeAll(subCtrl.keySet());
        evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("bizBill.id");
        evi.getSelector().add("value");
        evi.getSelector().add("canModify");
        evi.getSelector().add("superiorControlID");
        evi.getSelector().add("isIncludeSub");
        evi.getSelector().add("orgUnit.id");
        evi.getSelector().add("orgUnit.number");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bizBill.id", (Object)bill.getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isIncludeSub", (Object)Boolean.TRUE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.number", superNumbers, CompareType.INCLUDE));
        col = BgCtrlBizParamFactory.getLocalInstance(ctx).getBgCtrlBizParamCollection(evi);
        for (i = 0; i < col.size(); ++i) {
            col.get(i).setBizBill(bill);
            subCtrl.put(col.get(i).getOrgUnit().getNumber(), col.get(i));
        }
        for (Map.Entry<K, BgCtrlBizParamInfo> entry : ret.entrySet()) {
            if (entry.getValue() == null) {
                lns = ((FullOrgUnitInfo)entry.getKey()).getLongNumber().split("!");
                for (ln = lns.length - 2; ln >= 0; --ln) {
                    if (!subCtrl.containsKey(lns[ln])) continue;
                    superParam = (BgCtrlBizParamInfo)subCtrl.get(lns[ln]);
                    tempParamItemInfo = new BgCtrlBizParamInfo();
                    tempParamItemInfo.setOrgUnit((FullOrgUnitInfo)entry.getKey());
                    tempParamItemInfo.setValue(superParam.getValue());
                    tempParamItemInfo.setBizBill(bill);
                    tempParamItemInfo.setCanModify(superParam.isCanModify());
                    tempParamItemInfo.setSuperiorControlID(superParam.getId().toString());
                    tempParamItemInfo.setIsIncludeSub(false);
                    entry.setValue(tempParamItemInfo);
                    break;
                }
            }
            if (entry.getValue() != null) continue;
            tempParamItemInfo = new BgCtrlBizParamInfo();
            tempParamItemInfo.setOrgUnit((FullOrgUnitInfo)entry.getKey());
            tempParamItemInfo.setValue(BgCtrlBizParamEnum.No);
            tempParamItemInfo.setBizBill(bill);
            tempParamItemInfo.setCanModify(true);
            tempParamItemInfo.setSuperiorControlID(null);
            tempParamItemInfo.setIsIncludeSub(false);
            entry.setValue(tempParamItemInfo);
        }
        return ret;
    }

    @Override
    protected void _saveParam(Context ctx, IObjectCollection paramCol) throws BOSException, EASBizException {
        BgCtrlBizParamInfo info2;
        if (paramCol == null || paramCol.isEmpty()) {
            return;
        }
        BgCtrlBizBillInfo bizBill = null;
        BgCtrlBizParamCollection col = (BgCtrlBizParamCollection)paramCol;
        HashMap<String, BgCtrlBizParamInfo> includeSub = new HashMap<String, BgCtrlBizParamInfo>();
        HashMap<String, FullOrgUnitInfo> subOrg = new HashMap<String, FullOrgUnitInfo>();
        HashMap<String, BgCtrlBizParamInfo> subMap = new HashMap<String, BgCtrlBizParamInfo>();
        HashMap<String, BgCtrlBizParamInfo> noSubMap = new HashMap<String, BgCtrlBizParamInfo>();
        ArrayList<String> paramList = new ArrayList<String>();
        OrgType orgType = null;
        Iterator it = col.iterator();
        while (it.hasNext()) {
            info2 = (BgCtrlBizParamInfo)it.next();
            bizBill = info2.getBizBill();
            if (orgType == null && info2.getBizBill().getOrgViewType() != null) {
                orgType = NewOrgViewHelper.convert((OrgViewType)info2.getBizBill().getOrgViewType());
            }
            if (info2.isIsIncludeSub()) {
                includeSub.put(info2.getOrgUnit().getNumber(), info2);
                paramList.add(info2.getOrgUnit().getLongNumber() + "!%");
                continue;
            }
            noSubMap.put(info2.getOrgUnit().getNumber(), info2);
        }
        if (!paramList.isEmpty() && orgType != null) {
            int batchCount = 20;
            String orgTable = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo().getViewTableName();
            StringBuffer sql = new StringBuffer();
            sql.append("Select FID, FNumber, FLongNumber, FLevel, FName_").append(ctx.getLocale()).append(" FName From ").append(orgTable).append(" Where ");
            for (int i = 0; i < 20; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(" FLongNumber LIKE ? ");
            }
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet res = null;
            try {
                Object[] params = paramList.toArray();
                int batch = BgNSQLHelper.getBatchCount((Object[])params, (int)20);
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                for (int i = 0; i < batch; ++i) {
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)i, (int)20, (Object[])params);
                    res = pstmt.executeQuery();
                    while (res.next()) {
                        FullOrgUnitInfo org = new FullOrgUnitInfo();
                        org.setId(BOSUuid.read((String)res.getString("FID")));
                        org.setNumber(res.getString("FNumber"));
                        org.setLongNumber(res.getString("FLongNumber"));
                        org.setName(res.getString("FName"));
                        org.setLevel(res.getInt("FLevel"));
                        subOrg.put(org.getNumber(), org);
                    }
                    SQLUtils.cleanup((ResultSet)res);
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pstmt, conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        }
        if (!subOrg.isEmpty()) {
            for (FullOrgUnitInfo org : subOrg.values()) {
                if (noSubMap.containsKey(org.getNumber())) {
                    info2 = (BgCtrlBizParamInfo)noSubMap.get(org.getNumber());
                    noSubMap.remove(org.getNumber());
                } else if (includeSub.containsKey(org.getNumber())) {
                    info2 = (BgCtrlBizParamInfo)includeSub.get(org.getNumber());
                    includeSub.remove(org.getNumber());
                } else {
                    info2 = new BgCtrlBizParamInfo();
                    info2.setBizBill(bizBill);
                    info2.setOrgUnit(org);
                    info2.setIsIncludeSub(false);
                }
                String[] lns = org.getLongNumber().split("!");
                AbstractBgCtrlBizParamInfo parentInfo = null;
                for (int i = 0; i < lns.length - 1; ++i) {
                    if (!includeSub.containsKey(lns[i])) continue;
                    parentInfo = (BgCtrlBizParamInfo)includeSub.get(lns[i]);
                    break;
                }
                if (parentInfo != null) {
                    if (parentInfo.getId() == null) {
                        parentInfo.setId(BOSUuid.create((BOSObjectType)parentInfo.getBOSType()));
                    }
                    info2.setCanModify(parentInfo.isCanModify());
                    info2.setSuperiorControlID(parentInfo.getId().toString());
                    info2.setValue(parentInfo.getValue());
                }
                subMap.put(org.getNumber(), info2);
            }
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        HashMap<String, BgCtrlBizParamInfo> allMap = new HashMap<String, BgCtrlBizParamInfo>();
        allMap.putAll(includeSub);
        allMap.putAll(subMap);
        allMap.putAll(noSubMap);
        for (BgCtrlBizParamInfo info2 : allMap.values()) {
            if (info2.getId() == null) {
                info2.setId(BOSUuid.create((BOSObjectType)info2.getBOSType()));
            }
            colls.add((CoreBaseInfo)info2);
        }
        this.saveParamCollection(ctx, bizBill, colls);
    }

    private void saveParamCollection(Context ctx, BgCtrlBizBillInfo bizBill, CoreBaseCollection colls) throws BOSException {
        if (colls == null || colls.isEmpty()) {
            return;
        }
        HashSet<String> orgIds = new HashSet<String>();
        for (int i = 0; i < colls.size(); ++i) {
            orgIds.add(((BgCtrlBizParamInfo)colls.get(i)).getOrgUnit().getId().toString());
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        HashMap<String, String> existsParams = new HashMap<String, String>();
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
        try {
            conn = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("Select FOrgUnitId, FId From T_Bg_BgCtrlBizParam Where FBizBillID = ? AND FOrgUnitId IN(");
            BgNSQLHelper.addPlaceHolder((StringBuffer)sql).append(")");
            Object[] sqlParams = orgIds.toArray();
            int batchCount = BgNSQLHelper.getBatchCount((Object[])sqlParams);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < batchCount; ++i) {
                pstmt.setString(1, bizBill.getId().toString());
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)2, (int)i, (int)200, (Object[])sqlParams);
                res = pstmt.executeQuery();
                while (res.next()) {
                    existsParams.put(res.getString("FOrgUnitId"), res.getString("FID"));
                }
                SQLUtils.cleanup((ResultSet)res);
            }
            SQLUtils.cleanup((Statement)pstmt);
            String updateSql = "Update T_Bg_BgCtrlBizParam Set FCanModify = ?, FSuperiorControlID = ?, FIsIncludeSub = ?, FValue = ?, FLastUpdateUserId = ?, FLastUpdateTime = ? Where FID = ?";
            String insertSql = "Insert into T_Bg_BgCtrlBizParam(FID, FBizBillID, FOrgUnitID, FCanModify, FSuperiorControlID, FIsIncludeSub, FValue, FLastUpdateUserId, FLastUpdateTime, FCreatorID, FCreateTime) Values(?,?,?,?,?,?,?,?,?,?,?)";
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Timestamp now = new Timestamp(System.currentTimeMillis());
            for (int i = 0; i < colls.size(); ++i) {
                BgCtrlBizParamInfo info = (BgCtrlBizParamInfo)colls.get(i);
                if (existsParams.containsKey(info.getOrgUnit().getId().toString())) {
                    sqlParams = new Object[]{info.isCanModify(), info.getSuperiorControlID(), info.isIsIncludeSub(), info.getValue().getValue(), userId, now, existsParams.get(info.getOrgUnit().getId().toString())};
                    updateParams.add(sqlParams);
                    continue;
                }
                sqlParams = new Object[]{info.getId().toString(), bizBill.getId().toString(), info.getOrgUnit().getId().toString(), info.isCanModify(), info.getSuperiorControlID(), info.isIsIncludeSub(), info.getValue().getValue(), userId, now, userId, now};
                insertParams.add(sqlParams);
            }
            if (!insertParams.isEmpty()) {
                BgNSQLHelper.executeBatch((Connection)conn, (String)insertSql, insertParams);
            }
            if (!updateParams.isEmpty()) {
                BgNSQLHelper.executeBatch((Connection)conn, (String)updateSql, updateParams);
            }
            BgNSQLHelper.execute((Context)ctx, (String)"Update T_Bg_BgCtrlBizParam Set FSuperiorControlID = null, FCanModify = 1 Where FBizBillId = ? And FSuperiorControlID IS NOT NULL AND FSuperiorControlID NOT IN (Select FID From T_Bg_BgCtrlBizParam Where FIsIncludeSub = 1)", (Object[])new Object[]{bizBill.getId().toString()});
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _isCtrl(Context ctx, String orgUnitId, String boName) throws BOSException, EASBizException {
        if (orgUnitId == null || boName == null) {
            return false;
        }
        if (BgCtrlBizBillFactory.getLocalInstance(ctx).exists("where boName = '" + boName + "'")) {
            HashSet<String> boNames = new HashSet<String>();
            boNames.add(boName);
            Map param = this._getParam(ctx, orgUnitId, boNames);
            this.initParam(ctx, boName);
            return new Integer(1).equals(param.get(boName));
        }
        return true;
    }

    private void initParam(Context ctx, String boName) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)boName)) {
            return;
        }
        HashSet<String> boNames = new HashSet<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("Select FBoName From T_BG_BgCtrlBizBill Where FBoName = ? AND NOT EXISTS (Select FBizBillId From T_BG_BgCtrlBizParam Where T_BG_BgCtrlBizParam.FBizBillID = T_BG_BgCtrlBizBill.FID)");
            pstmt.setString(1, boName);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                boNames.add(rst.getString("FBoName"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        this.initParam(ctx, boNames);
    }

    @Override
    protected void _initParam(Context ctx) throws BOSException, EASBizException {
        HashSet<String> boNames = new HashSet<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("Select FBoName From T_BG_BgCtrlBizBill Where FBoName IS NOT NULL AND FID NOT IN (Select FBizBillId From T_BG_BgCtrlBizParam)");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                boNames.add(rst.getString("FBoName"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        this.initParam(ctx, boNames);
    }

    private void initParam(Context ctx, Set<String> boNames) throws BOSException, EASBizException {
        if (ctx == null || boNames == null || boNames.isEmpty()) {
            return;
        }
        Map<Integer, Set<String>> orgTypes = this.splitByOrgType(ctx, boNames);
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        HashSet insertBoIds = new HashSet();
        try {
            conn = this.getConnection(ctx);
            for (int orgViewType : orgTypes.keySet()) {
                OrgType orgType = NewOrgViewHelper.convert((OrgViewType)OrgViewType.getEnum((int)orgViewType));
                if (orgType == null) continue;
                Object[] boIds = orgTypes.get(orgViewType).toArray();
                insertBoIds.addAll(orgTypes.get(orgViewType));
                OrgTypeSelfInfo orgInfo = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo();
                if (orgInfo == null) continue;
                String tableName = orgInfo.getViewTableName();
                StringBuffer sql = new StringBuffer();
                sql.append("Insert into T_Bg_BgCtrlBizParam(FID, FBizBillID, FOrgUnitID, FCanModify, FIsIncludeSub, FValue, FLastUpdateUserId, FLastUpdateTime, FCreatorID, FCreateTime) ").append("Select newbosid('").append(new BgCtrlBizParamInfo().getBOSType()).append("'), bizBill.FID, ctrlScheme.FCostCenterID, 1, 0, ").append(1).append(", ?, ?, ?, ? ").append("From T_BG_BgControlScheme ctrlScheme, T_Bg_BgCtrlBizBill bizBill Where bizBill.FBoName = ctrlScheme.FBoName AND ctrlScheme.FIsValid = 1 AND ctrlScheme.FCostCenterID in (Select FID From ").append(tableName).append(") ").append("AND bizBill.FID in (");
                BgNSQLHelper.addPlaceHolder((StringBuffer)sql).append(")");
                pstmt = conn.prepareStatement(sql.toString());
                int batchCount = BgNSQLHelper.getBatchCount((Object[])boIds);
                for (int i = 0; i < batchCount; ++i) {
                    pstmt.setString(1, userId);
                    pstmt.setTimestamp(2, now);
                    pstmt.setString(3, userId);
                    pstmt.setTimestamp(4, now);
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)5, (int)i, (int)200, (Object[])boIds);
                    pstmt.executeUpdate();
                }
                SQLUtils.cleanup((Statement)pstmt);
            }
            pstmt = conn.prepareStatement("Select distinct FBizBillID From T_Bg_BgCtrlBizParam");
            res = pstmt.executeQuery();
            while (res.next()) {
                insertBoIds.remove(res.getString("FBizBillID"));
            }
            SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
            String sql = "Insert into T_Bg_BgCtrlBizParam(FID, FBizBillID, FOrgUnitID, FCanModify, FIsIncludeSub, FValue, FLastUpdateUserId, FLastUpdateTime, FCreatorID, FCreateTime) Values(newbosid('" + new BgCtrlBizParamInfo().getBOSType() + "'), ?, '" + "00000000-0000-0000-0000-000000000000CCE7AED4" + "', 1, 0, " + 0 + ", ?, ?, ?, ?)";
            ArrayList<Object[]> insertParam = new ArrayList<Object[]>();
            Iterator it = insertBoIds.iterator();
            while (it.hasNext()) {
                Object[] params = new Object[]{it.next(), userId, now, userId, now};
                insertParam.add(params);
            }
            BgNSQLHelper.executeBatch((Connection)conn, (String)sql.toString(), insertParam);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
    }
}

