/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgControlException;
import com.kingdee.eas.ma.budget.BgControlItemMapCollection;
import com.kingdee.eas.ma.budget.BgControlItemMapInfo;
import com.kingdee.eas.ma.budget.BgControlMultiRuleCollection;
import com.kingdee.eas.ma.budget.BgControlMultiRuleInfo;
import com.kingdee.eas.ma.budget.BgControlPeriodMapCollection;
import com.kingdee.eas.ma.budget.BgControlPeriodMapInfo;
import com.kingdee.eas.ma.budget.BgControlRuleCollection;
import com.kingdee.eas.ma.budget.BgControlRuleInfo;
import com.kingdee.eas.ma.budget.BgControlSchemeFactory;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.IBgControlScheme;
import com.kingdee.eas.ma.budget.app.AbstractBgCtrlImportFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCtrlImportFacadeControllerBean
extends AbstractBgCtrlImportFacadeControllerBean {
    private static final long serialVersionUID = 7604854754241299342L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgCtrlImportFacadeControllerBean");

    @Override
    protected Map _checkNumberRepeat(Context ctx, String orgId, String[] numbers) throws BOSException, EASBizException {
        HashMap<String, String> repeatMap = new HashMap<String, String>();
        if (orgId == null || numbers == null || numbers.length == 0) {
            return repeatMap;
        }
        StringBuffer querySql = new StringBuffer("SELECT \t\tFId, \t\tFNumber FROM\t\tT_Bg_BgControlScheme Where \tFCostCenterId = ? AND \tFIsSysDefault = 0 AND \tFNumber IN(");
        Object[] conditions = new String[numbers.length + 1];
        conditions[0] = orgId;
        int size = numbers.length;
        for (int i = 0; i < size; ++i) {
            conditions[i + 1] = numbers[i];
            if (i == size - 1) {
                querySql.append("?)");
                continue;
            }
            querySql.append("?,");
        }
        IRowSet rs = null;
        try {
            String id = null;
            String number = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])conditions);
            while (rs.next()) {
                id = rs.getString(1);
                number = rs.getString(2);
                repeatMap.put(number, id);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"budget error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return repeatMap;
    }

    @Override
    protected String _importData(Context ctx, String orgId, Map importMap, Map repeatMap) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        IBgControlScheme iBgCtrl = BgControlSchemeFactory.getLocalInstance(ctx);
        String SOURCE_STR = "com.kingdee.eas.ma.budget.BgCtrlImportResource";
        String thenumber = ResourceBase.getString((String)SOURCE_STR, (String)"number", (Locale)ContextUtils.getLocaleFromEnv());
        String lost = ResourceBase.getString((String)SOURCE_STR, (String)"lost", (Locale)ContextUtils.getLocaleFromEnv());
        String success = ResourceBase.getString((String)SOURCE_STR, (String)"success", (Locale)ContextUtils.getLocaleFromEnv());
        String SchemeHasAssigned = ResourceBase.getString((String)SOURCE_STR, (String)"SchemeHasAssigned", (Locale)ContextUtils.getLocaleFromEnv());
        String IsAssignedFromParent = ResourceBase.getString((String)SOURCE_STR, (String)"IsAssignedFromParent", (Locale)ContextUtils.getLocaleFromEnv());
        if (repeatMap != null && !repeatMap.isEmpty()) {
            String number2 = null;
            String id = null;
            ObjectUuidPK pk = null;
            for (String number2 : repeatMap.keySet()) {
                id = (String)repeatMap.get(number2);
                pk = new ObjectUuidPK(id);
                try {
                    this.checkCanUpdate(ctx, id, null);
                    iBgCtrl.delete((IObjectPK)pk);
                }
                catch (EASBizException e) {
                    EASBizException ex;
                    if (e instanceof BgSchemeAssignException) {
                        ex = (BgSchemeAssignException)e;
                        if (!BgSchemeAssignException.NOTALLOWDELETEASSIGNED.getCode().equals(ex.getSubCode())) continue;
                        errorMsg.append(thenumber + number2 + lost + SchemeHasAssigned + "\n");
                        importMap.remove(number2);
                        continue;
                    }
                    if (e instanceof BgControlException) {
                        ex = (BgControlException)e;
                        if (!BgControlException.ASSIGENNOTALLOWUPDATE.getCode().equals(ex.getSubCode())) continue;
                        errorMsg.append(thenumber + number2 + lost + IsAssignedFromParent + "\n");
                        importMap.remove(number2);
                        continue;
                    }
                    errorMsg.append(thenumber + number2 + lost + e.getMessage(ctx.getLocale()) + "\n");
                    importMap.remove(number2);
                }
                catch (BOSException e) {
                    errorMsg.append(thenumber + number2 + lost + e.getMessage() + "\n");
                    importMap.remove(number2);
                }
            }
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("rules.*"));
        sic.add(new SelectorItemInfo("itemMap.*"));
        sic.add(new SelectorItemInfo("periodMap.*"));
        sic.add(new SelectorItemInfo("multiRule.*"));
        FullOrgUnitInfo costInfo = new FullOrgUnitInfo();
        costInfo.setId(BOSUuid.read((String)orgId));
        BgControlSchemeInfo info = null;
        String elementNumber = (String)importMap.get("elementNumber");
        if (elementNumber == null) {
            this.addNewBgElement(ctx);
        }
        for (String number : importMap.keySet()) {
            if ("elementNumber".equals(number)) continue;
            String id = ((BOSUuid)importMap.get(number)).toString();
            if (id != null) {
                try {
                    info = (BgControlSchemeInfo)iBgCtrl.getValue((IObjectPK)new ObjectUuidPK(id), sic);
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                    errorMsg.append(thenumber + number + lost + e.getMessage(ctx.getLocale()) + "\n");
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                    errorMsg.append(thenumber + number + lost + e.getMessage() + "\n");
                    continue;
                }
            }
            BgControlSchemeInfo cloneInfo = this.cloneInfo(info, elementNumber);
            this.resetAlias(cloneInfo, ctx);
            cloneInfo.setCostCenter(costInfo);
            cloneInfo.setRoot(cloneInfo);
            cloneInfo.setParent(cloneInfo);
            cloneInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            cloneInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            cloneInfo.setIsSysDefault(false);
            try {
                iBgCtrl.addnew((CoreBaseInfo)cloneInfo);
                errorMsg.append(thenumber + number + success + "\n");
            }
            catch (BOSException e) {
                errorMsg.append(thenumber + number + lost + e.getMessage() + "\n");
                logger.error((Object)e);
            }
            catch (EASBizException e) {
                errorMsg.append(thenumber + number + lost + e.getMessage(ctx.getLocale()) + "\n");
                logger.error((Object)e);
            }
        }
        return errorMsg.toString();
    }

    private void addNewBgElement(Context ctx) throws BOSException, EASBizException {
        String querySql = "select * from t_bg_bgelement where FNumber = '01' or fid ='ZxmeDVycSkWl6C3iHIZyeutnq5Y='";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql);
        try {
            if (rs != null && rs.next()) {
                return;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BgFormException(BgFormException.DATABASEERROR);
        }
        String insertSql = "insert into t_bg_bgelement (FID, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME, FCONTROLUNITID, FNAME_L1, FNAME_L2, FNAME_L3, FNUMBER, FDATATYPE, FREFERENCE, FAPPORTIONABLE, FISACTUAL, FENABLED, FTYPE, FEXTTYPE)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        conn = this.getConnection(ctx);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = "256c221a-0106-1000-e000-10d7c0a813f413B7DE7F";
        if (userInfo == null || userInfo.getId() == null) {
            userId = userInfo.getId().toString();
        }
        Date currentDate = new Date(System.currentTimeMillis());
        try {
            pstmt = conn.prepareStatement(insertSql.toString());
            pstmt.setString(1, "ZxmeDVycSkWl6C3iHIZyeutnq5Y=");
            pstmt.setString(2, userId);
            pstmt.setDate(3, currentDate);
            pstmt.setString(4, userId);
            pstmt.setDate(5, currentDate);
            pstmt.setString(6, "00000000-0000-0000-0000-000000000000CCE7AED4");
            pstmt.setString(7, "");
            pstmt.setString(8, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"12_BgCtrlImportFacadeControllerBean", (Locale)ctx.getLocale()));
            pstmt.setString(9, ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"13_BgCtrlImportFacadeControllerBean", (Locale)ctx.getLocale()));
            pstmt.setString(10, "01");
            pstmt.setInt(11, 0);
            pstmt.setInt(12, 0);
            pstmt.setInt(13, 1);
            pstmt.setInt(14, 0);
            pstmt.setInt(15, 1);
            pstmt.setInt(16, 0);
            pstmt.setInt(17, 0);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BgFormException(BgFormException.DATABASEERROR);
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    protected void checkCanUpdate(Context ctx, String id, String oprt) throws BOSException, EASBizException {
        IBgControlScheme iBgCtrl = BgControlSchemeFactory.getLocalInstance(ctx);
        BgControlSchemeInfo bgCtrlSchemeInfo = (BgControlSchemeInfo)iBgCtrl.getValue((IObjectPK)new ObjectUuidPK(id));
        if (bgCtrlSchemeInfo.isIsAssigned() && bgCtrlSchemeInfo.isIsNotAllowUpdate()) {
            throw new BgControlException(BgControlException.ASSIGENNOTALLOWUPDATE);
        }
    }

    private BgControlSchemeInfo cloneInfo(BgControlSchemeInfo info, String elementNumber) {
        BgControlSchemeInfo _info = (BgControlSchemeInfo)info.clone();
        _info.remove("id");
        BgControlRuleCollection _ruleCol = new BgControlRuleCollection();
        for (int r = 0; r < info.getRules().size() && info.getRules().get(r) != null; ++r) {
            BgControlRuleInfo ruleInfo = info.getRules().get(r);
            BgControlRuleInfo _ruleInfo = new BgControlRuleInfo();
            _ruleInfo.setOqlOrgUnit(ruleInfo.getOqlOrgUnit());
            _ruleInfo.setAliasOrgUnit(ruleInfo.getAliasOrgUnit());
            _ruleInfo.setOqlItemCombination(ruleInfo.getOqlItemCombination());
            _ruleInfo.setAliasItemCombination(ruleInfo.getAliasItemCombination());
            _ruleInfo.setOqlPeriod(ruleInfo.getOqlPeriod());
            _ruleInfo.setAliasPeriod(ruleInfo.getAliasPeriod());
            _ruleInfo.setOqlCurrency(ruleInfo.getOqlCurrency());
            _ruleInfo.setAliasCurrency(ruleInfo.getAliasCurrency());
            _ruleInfo.setOqlActual(ruleInfo.getOqlActual());
            _ruleInfo.setAliasActual(ruleInfo.getAliasActual());
            if (elementNumber == null) {
                _ruleInfo.setElementNumber(ruleInfo.getElementNumber());
            } else {
                _ruleInfo.setElementNumber(elementNumber);
            }
            _ruleInfo.setPeriodCycle(ruleInfo.getPeriodCycle());
            _ruleInfo.setPackageName(ruleInfo.getPackageName());
            _ruleInfo.setBillName(ruleInfo.getBillName());
            _ruleInfo.setPackageAlias(ruleInfo.getPackageAlias());
            _ruleInfo.setBillAlias(ruleInfo.getBillAlias());
            _ruleInfo.setIsEnable(ruleInfo.isIsEnable());
            _ruleInfo.setIsAllowExcess(ruleInfo.isIsAllowExcess());
            _ruleInfo.setOqlBizDate(ruleInfo.getOqlBizDate());
            _ruleInfo.setAliasBizDate(ruleInfo.getAliasBizDate());
            _ruleInfo.setOqlRequest(ruleInfo.getOqlRequest());
            _ruleInfo.setAliasRequest(ruleInfo.getAliasRequest());
            _ruleInfo.setOqlRequestExtendExpression(ruleInfo.getOqlRequestExtendExpression());
            _ruleInfo.setCustomBgPeriodNumber(ruleInfo.getCustomBgPeriodNumber());
            _ruleInfo.setOqlRuleCondition(ruleInfo.getOqlRuleCondition());
            _ruleInfo.setAliasRuleCondition(ruleInfo.getAliasRuleCondition());
            _ruleInfo.setName(ruleInfo.getName());
            _ruleInfo.setNumber(ruleInfo.getNumber());
            _ruleInfo.setDescription(ruleInfo.getDescription());
            _ruleInfo.remove("id");
            _ruleInfo.remove("bgCtrlScheme");
            _ruleCol.add(_ruleInfo);
        }
        _info.getRules().clear();
        _info.getRules().addCollection(_ruleCol);
        BgControlItemMapCollection _itemMapCol = new BgControlItemMapCollection();
        for (int s = 0; s < info.getItemMap().size() && info.getItemMap().get(s) != null; ++s) {
            BgControlItemMapInfo itemMapInfo = info.getItemMap().get(s);
            BgControlItemMapInfo _itemMapInfo = new BgControlItemMapInfo();
            _itemMapInfo.setBillFieldCombinValue(itemMapInfo.getBillFieldCombinValue());
            _itemMapInfo.setBillFieldCombinAlias(itemMapInfo.getBillFieldCombinAlias());
            _itemMapInfo.setBillItemCombinValue(itemMapInfo.getBillItemCombinValue());
            _itemMapInfo.setBillItemCombinAlias(itemMapInfo.getBillItemCombinAlias());
            _itemMapInfo.setBgItemCombinID(itemMapInfo.getBgItemCombinID());
            _itemMapInfo.setBgItemCombinKey(itemMapInfo.getBgItemCombinKey());
            _itemMapInfo.setBgItemCombinAlias(itemMapInfo.getBgItemCombinAlias());
            _itemMapInfo.remove("id");
            _itemMapInfo.remove("bgCtrlScheme");
            _itemMapCol.add(_itemMapInfo);
        }
        _info.getItemMap().clear();
        _info.getItemMap().addCollection(_itemMapCol);
        BgControlPeriodMapCollection _periodMapCol = new BgControlPeriodMapCollection();
        for (int t = 0; t < info.getPeriodMap().size() && info.getPeriodMap().get(t) != null; ++t) {
            BgControlPeriodMapInfo periodMapInfo = info.getPeriodMap().get(t);
            BgControlPeriodMapInfo _periodMapInfo = new BgControlPeriodMapInfo();
            _periodMapInfo.setBizBeginPeriod(periodMapInfo.getBizBeginPeriod());
            _periodMapInfo.setBizEndPeriod(periodMapInfo.getBizEndPeriod());
            _periodMapInfo.setBgPeriod(periodMapInfo.getBgPeriod());
            _periodMapInfo.remove("id");
            _periodMapInfo.remove("bgCtrlScheme");
            _periodMapCol.add(_periodMapInfo);
        }
        _info.getPeriodMap().clear();
        _info.getPeriodMap().addCollection(_periodMapCol);
        BgControlMultiRuleCollection _multiRuleCol = new BgControlMultiRuleCollection();
        for (int u = 0; u < info.getMultiRule().size() && info.getMultiRule().get(u) != null; ++u) {
            BgControlMultiRuleInfo multiRuleInfo = info.getMultiRule().get(u);
            BgControlMultiRuleInfo _multiRuleInfo = new BgControlMultiRuleInfo();
            _multiRuleInfo.setBizItemCombinId(multiRuleInfo.getBizItemCombinId());
            _multiRuleInfo.setBizItemCombinNumber(multiRuleInfo.getBizItemCombinNumber());
            _multiRuleInfo.setBizItemCombinAlias(multiRuleInfo.getBizItemCombinAlias());
            _multiRuleInfo.setCtrlItemCombinId(multiRuleInfo.getCtrlItemCombinId());
            _multiRuleInfo.setCtrlItemCombinNumber(multiRuleInfo.getCtrlItemCombinNumber());
            _multiRuleInfo.setCtrlItemCombinAlias(multiRuleInfo.getCtrlItemCombinAlias());
            _multiRuleInfo.setCtrlCoe(multiRuleInfo.getCtrlCoe());
            _multiRuleInfo.setCtrlRule(multiRuleInfo.getCtrlRule());
            _multiRuleInfo.setCtrlValue(multiRuleInfo.getCtrlValue());
            _multiRuleInfo.remove("id");
            _multiRuleInfo.remove("bgCtrlScheme");
            _multiRuleCol.add(_multiRuleInfo);
        }
        _info.getMultiRule().clear();
        _info.getMultiRule().addCollection(_multiRuleCol);
        return _info;
    }

    private void resetAlias(BgControlSchemeInfo scheme, Context ctx) {
        EntityObjectInfo entity;
        Locale locale = ctx.getLocale();
        if (locale != null && locale.toString().equalsIgnoreCase("l1") && (entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(scheme.getBoName()))) != null) {
            for (int i = 0; i < scheme.getRules().size(); ++i) {
                BgControlRuleInfo rule = scheme.getRules().get(i);
                rule.setAliasActual(this.getAlias(ctx, entity, rule.getOqlActual()));
                rule.setAliasBizDate(this.getAlias(ctx, entity, rule.getOqlBizDate()));
                rule.setAliasCurrency(this.getAlias(ctx, entity, rule.getOqlCurrency()));
                rule.setAliasOrgUnit(this.getAlias(ctx, entity, rule.getOqlOrgUnit()));
                rule.setAliasPeriod(this.getAlias(ctx, entity, rule.getOqlPeriod()));
                rule.setAliasRequest(this.getAlias(ctx, entity, rule.getOqlRequest()));
                rule.setAliasItemCombination(this.getAlias(ctx, entity, rule.getOqlItemCombination()));
                rule.setAliasRuleCondition(this.getAlias(ctx, entity, rule.getOqlRuleCondition()));
            }
        }
    }

    private String getAlias(Context ctx, EntityObjectInfo entity, String propertity) {
        if (ctx == null || entity == null || StringUtils.isEmpty((String)propertity)) {
            return null;
        }
        StringBuffer res = new StringBuffer();
        String limit = null;
        if (propertity.indexOf("|") > 0) {
            int index = propertity.indexOf("|");
            limit = propertity.substring(index + 1);
            propertity = propertity.substring(0, index);
        }
        String[] props = propertity.split("\\.");
        PropertyInfo prop = null;
        for (int i = 0; i < props.length; ++i) {
            prop = entity.getPropertyByName(props[i]);
            res.append(prop.getAlias()).append(".");
            if (!(prop instanceof LinkPropertyInfo)) break;
            entity = ((LinkPropertyInfo)prop).getRelationship().getSupplierObject();
        }
        if (limit != null) {
            res.append("|").append(limit);
        }
        return res.substring(0, res.length() - 1);
    }
}

